<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   $api = json_decode($_SESSION["apuracao"], 1);
   requerPermissao('22:23');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Apuração
         <small>Financeiro</small>
      </h1>
      <div class="pull-right" style="margin-top: -35px;">
          <a class="btn btn-danger" href="javascript: history.back('-1');"><i class="fa fa-reply"></i></a>
          <a class="btn btn-warning" href="javascript: print();"><i class="fa fa-print"></i></a>
      </div>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Resultado Geral</strong></h4>
                  <div class="pull-right" style=" margin-top: 6px; "><?php echo $api['dates']; ?></div>
               </div>
               <div class="box-content">
                  <div class="box-body">
                    <div class="row">

                      <?php if(isset($api["error"])){
                         echo '<div class="col-12"><div class="callout callout-danger">
                          <h4>Ops! Algo deu errado.</h4>

                          <p>'.$api["error"].'</p>
                        </div></div>';
                      } ?>

                      <div class="col-12 col-md-3 col-sm-3 col-lg-3" style="text-align: center;">
                        <div class="box-body py-25">
                          <p class="font-size-40 text-success">
                            <strong>R$<?php echo $api['total']['entries']; ?></strong>
                          </p>
                          <p class="font-weight-600">Entradas</p>
                        </div>
                      </div>

                      <div class="col-12 col-md-3 col-sm-3 col-lg-3" style="text-align: center;">
                        <div class="box-body py-25">
                          <p class="font-size-40 text-danger">
                            <strong>R$<?php echo $api['total']['rewards']; ?></strong>
                          </p>
                          <p class="font-weight-600">Saídas</p>
                        </div>
                      </div>

                      <div class="col-12 col-md-3 col-sm-3 col-lg-3" style="text-align: center;">
                        <div class="box-body py-25">
                          <p class="font-size-40 text-warning">
                            <strong>R$<?php echo $api['total']['comissions']; ?></strong>
                          </p>
                          <p class="font-weight-600">Comissões</p>
                        </div>
                      </div>

                      <div class="col-12 col-md-3 col-sm-3 col-lg-3" style="text-align: center;">
                        <div class="box-body py-25">
                          <p class="font-size-40 text-<?php if($api['total']['total'] < 0){ echo 'danger'; } else { echo 'success'; } ?>">
                            <strong>R$<?php echo $api['total']['total']; ?></strong>
                          </p>
                          <p class="font-weight-600">Total</p>
                        </div>
                      </div>

                    </div>
                  </div>
               </div>
            </div>

            <?php foreach ($api['byManager'] as $tipo => $info) { ?>
            <div class="box box-solid bg-orange">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong"><?php echo $tipo; ?></strong></h4>
                  <div class="pull-right" style=" margin-top: 6px; "><?php echo $api['dates']; ?></div>
               </div>
               <div class="box-content">
                  <div class="box-body">

                    <blockquote class="blockquote custom_blockquote">
                      <b>Lembre-se: </b> nesta seção, estamos exibindo a soma dos valores da apuração do usuário em questão + a apuração dos usuários gerenciados por ele.
                    </blockquote>

                     <div class="table-responsive">
                        <table id="exampleNameOrder" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="120">Entradas</th>
                                 <th width="120">Saídas</th>
                                 <th width="120">Comissões</th>
                                 <th width="120">Total</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                $aux = 1;
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="9" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($info as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $aux; ?></td>
                                 <td><?php echo strtoupper($v["name"]); ?></td>
                                 <td align="center"><b class="">R$<?php echo $v["entries"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["rewards"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["comissions"]; ?></b></td>
                                 <td align="center" class="text-<?php if($v['balance_type'] == '-'){ echo 'danger'; } elseif($v['total'] == '0,00'){ } else { echo 'success'; } ?>"><b class="">R$<?php echo $v["total"]; ?></b></td>
                              </tr>
                              <?php $aux++; } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
            <?php } ?>

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Apuração por usuário</strong></h4>
                  <div class="pull-right" style=" margin-top: 6px; "><?php echo $api['dates']; ?></div>
               </div>
               <div class="box-content">
                  <div class="box-body">

                     <div class="table-responsive">
                        <table id="exampleNameOrder" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="120">Entradas</th>
                                 <th width="120">Saídas</th>
                                 <th width="120">Comissões</th>
                                 <th width="120">Total</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 $aux = 1;
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="9" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['byUser'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $aux; ?></td>
                                 <td><?php echo strtoupper($v["name"]); ?></td>
                                 <td align="center"><b class="">R$<?php echo $v["entries"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["rewards"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["comissions"]; ?></b></td>
                                 <td align="center" class="text-<?php if($v['balance_type'] == '-'){ echo 'danger'; } elseif($v['total'] == '0,00'){ } else { echo 'success'; } ?>"><b class="">R$<?php echo $v["total"]; ?></b></td>
                              </tr>
                              <?php $aux++; } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>

            <?php if(isset($api['coupons'])){ ?>
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Bilhetes</strong></h4>
                  <div class="pull-right" style=" margin-top: 6px; "><?php echo $api['dates']; ?></div>
               </div>
               <div class="box-content">
                  <div class="box-body">

                     <div class="table-responsive">
                     <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                        <thead>
                           <tr>
                              <th>-</th>
                              <th>Código</th>
                              <th>Data</th>
                              <th>Cliente</th>
                              <th>Colaborador</th>
                              <th>Valor</th>
                              <th>Poss. Ret.</th>
                              <th>Status</th>
                              <th>Opções</th>
                           </tr>
                        </thead>
                        <tbody>
                           <?php $i = 1; foreach ($api['coupons'] as $code => $v) { if($code == ''){ continue; } ?>
                           <tr>
                              <td align="center"><?php echo $i; ?></td>
                              <td align="center"><b><?php echo $code; ?></b></td>
                              <td align="center"><?php echo $v["date"]; ?></td>
                              <td><?php echo $v["client"]; ?></td>
                              <td><?php echo $v["seller"]; ?></td>
                              <td align="center">R$<?php echo $v["price"]; ?></td>
                              <td align="center">R$<?php if($v["status"] <> '2'){ echo $v["return"]; } else { echo $v["rewards"]; } ?></td>
                              <td align="center">
                                 <?php
                                    switch ($v["status"]) {
                                       case '1':
                                          echo '<span class="badge badge-info">Aberto</span>';
                                          break;

                                       case '2':
                                          echo '<span class="badge badge-success">Ganhou</span>';
                                          break;

                                       case '3':
                                          echo '<span class="badge badge-danger">Perdeu</span>';
                                          break;

                                       case '4':
                                          echo '<span class="badge bg-navy">Cancelado</span>';
                                          break;

                                       case '11':
                                          echo '<span class="badge bg-cyan">Process. Parcial</span>';
                                          break;

                                       default:
                                          echo '<span class="badge badge-warning">Indefinido</span>';
                                          break;
                                    }
                                 ?>
                              </td>
                              <td align="center">
                                 <div class="input-group-btn">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false">Opções</button>
                                    <div class="dropdown-menu" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 37px, 0px); top: 0px; left: 0px; will-change: transform;">
                                       <a class="dropdown-item" href="/bilhetes/conferir?code=<?php echo $code; ?>"><i class="fa fa-eye"></i> &nbsp; Visualizar</a>
                                       <a class="dropdown-item" target="framePrint" href="/imprimir/<?php echo $code; ?>"><i class="fa fa-print"></i> &nbsp; Imprimir</a>
                                       <a class="dropdown-item" href="/bilhetes/atualizar/<?php echo $code; ?>"><i class="fa fa-refresh"></i> &nbsp; Atualizar</a>
                                       <div class="dropdown-divider"></div>
                                       <a class="dropdown-item" target="framePrint" href="/bilhetes/cancelar/<?php echo $code; ?>"><i class="fa fa-ban"></i> &nbsp; Cancelar</a>
                                    </div>
                                 </div>
                              </td>
                           </tr>
                           <?php $i++; } ?>
                        </tbody>
                        <tfoot>
                           <tr>
                              <th>-</th>
                              <th>Código</th>
                              <th>Data</th>
                              <th>Cliente</th>
                              <th>Colaborador</th>
                              <th>Valor</th>
                              <th>Poss. Ret.</th>
                              <th>Status</th>
                              <th>Opções</th>
                           </tr>
                        </tfoot>
                     </table>
                     </div>
                  </div>
               </div>
            </div>
            <?php } ?>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('[id="exampleNameOrder"]').DataTable( {
            "order": [[ 1, "asc" ]],
            dom: 'lBfrtip',
            buttons: [
              'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });

         $('[id="secondaryBlock"]').click(function(){
            var u = $(this).attr('data-usuario');
            $('.btnStatusUser'+u).click();
         });

         $('[id="changeSaldo"]').click(function(){
            var btn = $(this);
            btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-spinner fa-spin');
            var user = btn.attr('data-usuario');
            var balance = $('#saldo-'+user).val();

            $.get('/api/changeBalance?user='+user+'&balance='+balance, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
               }
               else if(info.success != undefined){
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
                  $('#saldo-'+user).css('background', '#14b56f47');


                  $.toast({
                     heading: 'Pronto!',
                     text: 'O crédito foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                  });
               }
            });
         });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script><?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/mapa.php';
   requerPermissao('8');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Mapa de Apostas
         <small>Gerenciamento de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Mapa de Apostas</strong></h4>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">

                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Partida</th>
                                 <th width="120">Valor</th>
                                 <th width="80">Quant.</th>
                                 <th width="200">Opções</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['matches'] as $i => $v) {
                                  $i++;
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><?php echo strtoupper($v["name"]); ?></td>
                                 <td align="center"><b href="#">R$<?php echo ($v["price"]); ?></b></td>
                                 <td align="center" class="text-info"><b class=""><?php echo $v["qtd"]; ?></b></td>
                                 <td align="center">
                                    <a href="/gestao-de-apostas/ver-mapa/<?php echo $v['code']; ?>" class="btn btn-sm btn-warning ">Selecionar &nbsp; <i class="fa fa-caret-right"></i></a>
                                 </td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>