<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/usuarios.php';
   requerPermissao('2:25');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         <?php echo $_SESSION["tipos_usuarios_byslug"][$slug]["nome"]; ?>
         <small>Usuários</small>
      </h1>
      <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right" style="margin-top: -35px;"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Usuários</strong></h4>
                  <a href="/usuarios/novo" class="btn btn-warning btn-md pull-right"><i class="fa fa-user-plus"></i> &nbsp; Novo Usuário</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <form action="" style="max-width: 300px;">
                           <center><b>Filtro de caixa</b></center>
                          <div class="input-group">
                            <input type="text" name="date" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="De" value="<?php echo $api['date']; ?>">
                            <span class="input-group-addon">&nbsp; até &nbsp;</span>
                            <input type="text" name="enddate" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="Até" value="<?php echo $api['enddate']; ?>">
                          </div>
                          <button type="submit" class="btn btn-info btn-md btn-block"><i class="fa fa-search"></i> &nbsp; Aplicar</button><br />
                        </form>

                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="230" style="min-width: 200px !important;">Crédito</th>
                                 <th>Gerente</th>
                                 <th width="120">Caixa</th>
                                 <th width="80">Status</th>
                                 <th width="200">Operações</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['user_info'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td style="text-transform: uppercase;"><b><?php echo ($v["name"]); ?></b></td>
                                 <td align="center">
                                    <div class="input-group input-group-sm">
                                       <span class="input-group-addon"><i class="fa fa-dollar"></i></span>
                                       <input type="text" class="form-control margin0" id="saldo-<?php echo ($v['id']); ?>" value="<?php echo $v['credit']; ?>" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value); calcReturn(this.value);">
                                       <span class="input-group-btn">
                                          <a data-usuario="<?php echo ($v['id']); ?>" id="changeSaldo" class="btn btn-success btn-sm"><i class="fa fa-check"></i></a>
                                       </span>
                                    </div>
                                 </td>
                                 <td align="center"><a href="#"><?php echo strtoupper($v["manager"]); ?></a></td>
                                 <td align="center" class="text-<?php if($v['balance_type'] == '-'){ echo 'danger'; } elseif($v['balance'] == '0,00'){ } else { echo 'success'; } ?>"><b class="">R$<?php echo $v["balance"]; ?></b></td>
                                 <td align="center"><a id="changeStatus" data-usuario="<?php echo ($v['id']); ?>" class="btn btnStatusUser<?php echo ($v['id']); ?> btn-sm btn-<?php if($v['status'] == '1'){ echo 'success'; } else { echo 'danger'; } ?>" data-toggle="tooltip" data-placement="top" title="Ativar / Desativar"><?php if($v['status'] == '1'){ echo 'Ativo'; } else { echo 'Inativo'; } ?></a></td>
                                 <td align="center">
                                    <div class="btn-group">
                                       <a class="btn btn-warning btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                       Gerenciar &nbsp; <i class="fa fa-caret-down"></i>
                                       </a>
                                       <div class="dropdown-menu" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 33px, 0px); top: 0px; left: 0px; will-change: transform;">
                                          <a class="dropdown-item" href="/usuarios/editar/<?php echo $v['id']; ?>"><i class="fa fa-edit"></i> &nbsp; Editar</a>
                                          <a class="dropdown-item" href="/caixa?type=general&user=<?php echo $v['id']; ?>"><i class="fa fa-bar-chart"></i> &nbsp; Ver caixa</a>
                                          <a class="dropdown-item" id="secondaryBlock" data-usuario="<?php echo ($v['id']); ?>" href="#"><i class="fa fa-ban"></i> &nbsp; Des/Bloquear</a>
                                          <a class="dropdown-item" href="/usuarios/permissoes/<?php echo $v['id']; ?>"><i class="fa fa-shield"></i> &nbsp; Permissões</a>
                                          <a class="dropdown-item" href="/usuarios/recalcular-comissoes/<?php echo $v['id']; ?>"><i class="fa fa-dollar"></i> &nbsp; Recalcular Comissões</a>
                                          <div class="dropdown-divider"></div>
                                          <a id="markOK" data-id="<?php echo $v['id']; ?>" class="dropdown-item btn-danger" href="#"><i class="fa fa-times"></i> &nbsp; Excluir</a>
                                       </div>
                                    </div>
                                 </td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script src="/js/jquery.mask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){
         $('.tel').mask('(99) 99999-9999');

         $('[id="secondaryBlock"]').click(function(){
            var u = $(this).attr('data-usuario');
            $('.btnStatusUser'+u).click();
         });

         $("#example").on("click", '[id="changeSaldo"]', function(){
            var btn = $(this);
            btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-spinner fa-spin');
            var user = btn.attr('data-usuario');
            var balance = $('#saldo-'+user).val();

            $.get('/api/changeBalance?user='+user+'&balance='+balance, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
               }
               else if(info.success != undefined){
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
                  $('#saldo-'+user).css('background', '#14b56f47');


                  $.toast({
                     heading: 'Pronto!',
                     text: 'O crédito foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                  });
               }
            });
         });

         $("#example").on("click", '[id="changeStatus"]', function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

         $("#example").on("click", '[id="markOK"]', function(){
            var btn = $(this);
            var id = btn.attr('data-id');
            btn.html('<i class="fa fa-spinner fa-spin"></i>').toggleClass('btn-danger btn-info');
            $.get('/api/deleteUser?user='+id, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-times"></i>').toggleClass('btn-danger btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){

                $.toast({
                  heading: 'Pronto!',
                  text: 'Registro apagado com sucesso.',
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

                location.reload();

              }
            });

            return false;
            ev.preventDefault();
        });

      });
    });
</script>