<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/caixa-dos-usuarios.php';
   requerPermissao('26:27');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Saldos
         <small>Usuários</small>
      </h1>
      <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right" style="margin-top: -35px;"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12 col-lg-8 col-md-8 col-sm-12 col-xs-12 offset-lg-2 offset-md-2">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Saldos</strong></h4>
                  <a href="/historico/credit" class="btn btn-warning btn-md pull-right"><i class="fa fa-history"></i> &nbsp; Histórico de Saldo</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="230" style="min-width: 200px !important;">Crédito</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['user_info'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><?php echo strtoupper($v["name"]); ?></td>
                                 <td align="center">
                                    <div class="input-group input-group-sm">
                                       <span class="input-group-addon"><i class="fa fa-dollar"></i></span>
                                       <input type="text" class="form-control margin0" id="saldo-<?php echo ($v['id']); ?>" value="<?php echo $v['credit']; ?>" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value); calcReturn(this.value);">
                                       <span class="input-group-btn">
                                          <a data-usuario="<?php echo ($v['id']); ?>" id="changeSaldo" class="btn btn-success btn-sm"><i class="fa fa-check"></i></a>
                                       </span>
                                    </div>
                                 </td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){


         $('[id="changeSaldo"]').click(function(){
            var btn = $(this);
            btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-spinner fa-spin');
            var user = btn.attr('data-usuario');
            var balance = $('#saldo-'+user).val();

            $.get('/api/changeBalance?user='+user+'&balance='+balance, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
               }
               else if(info.success != undefined){
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
                  $('#saldo-'+user).css('background', '#14b56f47');


                  $.toast({
                     heading: 'Pronto!',
                     text: 'O crédito foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                  });
               }
            });
         });
      });
    });
</script>