<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/recalcular-comissoes.php';
   requerPermissao('2:25'); // Processamento de PINs
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Recalcular Comissões
         <small>Usuários</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-lg-4 col-md-4 col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Sobre a grade</strong></h4>
                  <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                    <div class="table-responsive">
                      <?php foreach ($rates['rates'] as $k => $v) { ?>
                      <table class="table tableRate" id="rate<?php echo $v['id']; ?>" style="<?php if($v['id'] <> $user['user_info']['comission_rate']){ echo 'display: none;'; } ?>">
                        <tbody>
                          <tr>
                            <td scope="row">Nome da grade</td>
                            <td align="right"><b><?php echo $v['name']; ?></b></td>
                          </tr>
                          <tr>
                            <td scope="row">Cotação mínima</td>
                            <td align="right"><b><?php echo $v['min_odd']; ?></b></td>
                          </tr>
                          <tr>
                            <td align="center" colspan="2">Regras da grade</td>
                          </tr>
                          <?php foreach ($v['rules'] as $k => $r) {?>
                          <tr>
                            <td scope="row">De <?php echo $r['min']; ?> a <?php echo $r['max']; ?> jogos</td>
                            <td align="right"><b><?php echo $r['percent']; ?>%</b></td>
                          </tr>
                          <?php } ?>
                        </tbody>
                      </table>
                      <?php } ?>
                    </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-lg-8 col-md-8 col-12">
            <form id="saveRecalc" action="/api/updateComissions" method="GET">
               <div class="box box-solid bg-warning">
                  <div class="box-header">
                    <h4 class="box-title"><strong class="event-strong">Dados para recálculo</strong></h4>
                    <button type="submit" class="btn bg-success btn-md pull-right" id="finishBet" data-toggle="modal" data-target="#recalcReturn"><i class="fa fa-retweet"></i> &nbsp; Recalcular</button>
                  </div>
                  <div class="box-content">
                    <div class="media-list media-list-hover media-list-divided">
                       <div class="media">
                          <div class="media-body">
                             <p>
                                <a class="hover-primary" href="#"><strong>Usuário</strong></a>
                                <time class="float-right"><input type="hidden" name="user" value="<?php echo $user['user_info']['id']; ?>" /><input type="text" name="username" readonly="" disabled="" class="form-control" placeholder="Usuário" value="<?php echo $user['user_info']['name']; ?>" /></time>
                             </p>
                          </div>
                       </div>
                       <div class="media">
                          <div class="media-body">
                             <p>
                                <a class="hover-primary" href="#"><strong>Grade</strong></a>
                                <time class="float-right">
                                  <select name="rate" id="selRate" class="form-control">
                                    <option value="">Selecione</option>
                                    <?php foreach ($rates['rates'] as $k => $v) {
                                      echo '<option '; if($v['id'] == $user['user_info']['comission_rate']){ echo 'selected'; } echo ' value="'.$k.'">'.$v['name'].'</option>';
                                    } ?>
                                  </select>
                                </time>
                             </p>
                          </div>
                       </div>
                       <div class="media">
                          <div class="media-body">
                             <p>
                                <a class="hover-primary" href="#"><strong>Data inicial</strong></a>
                                <time class="float-right"><input  class="form-control datepicker" name="date" value="<?php echo date('d/m/Y'); ?>" placeholder="Data de Início" id="data" /></time>
                             </p>
                          </div>
                       </div>
                       <div class="media">
                          <div class="media-body">
                             <p>
                                <a class="hover-primary" href="#"><strong>Data final</strong></a>
                                <time class="float-right"><input  class="form-control datepicker" name="enddate" value="<?php echo date('d/m/Y'); ?>" placeholder="Data de Fim" id="data" /></time>
                             </p>
                          </div>
                       </div>
                    </div>
                  </div>
               </div>
            </form>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<!-- modal -->
<div id="recalcReturn" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="display: none;" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content" id="loadingInfoSetLimits">
         <div class="modal-header">
            <h4 class="modal-title" id="myModalLabel">Resultado</h4>
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
         </div>
         <div class="modal-body" id="loading">
            <div class="col-12 col-lg-12">
              <div id="error"></div>
              <table class="table" id="tableReturn">
                <tr>
                  <th>Código</th>
                  <th>Com. Antiga</th>
                  <th>Com. Nova</th>
                </tr>
              </table>
            </div>
         </div>
         <div class="modal-footer">
            <a class="btn btn-lg btn-danger waves-effect" data-dismiss="modal">Fechar</a>
         </div>
      </div>
      <!-- /.modal-content -->
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script src="/plugins/pickadate/lib/picker.js"></script>
<script src="/plugins/pickadate/lib/picker.date.js"></script>
<link href="/plugins/pickadate/lib/themes/default.css" rel="stylesheet" />
<link href="/plugins/pickadate/lib/themes/default.date.css" rel="stylesheet" />
<script>

   $(function(){
      $(document).ready(function(){
        $('#selRate').change(function(){
          var id = $(this).val();

          $('.tableRate').hide();
          $('#rate'+id).show();
        });

        $('.datepicker').pickadate({
          // Strings and translations
          monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
          monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
          weekdaysFull: ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'],
          weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'],
          showMonthsShort: undefined,
          showWeekdaysFull: undefined,

          // Buttons
          today: 'Hoje',
          clear: 'Limpar',
          close: 'Fechar',

          // Accessibility labels
          labelMonthNext: 'Prox Mês',
          labelMonthPrev: 'Mês Anterior',
          labelMonthSelect: 'Selecione um mês',
          labelYearSelect: 'Selecione um ano',

          // Formats
          format: 'dd/mm/yyyy',
        });

        $('#saveRecalc').submit(function(e){
          var spinner = '<div class="loadermodal"><center><img class="floader" src="/loaders/rings.svg" /> Recuperando PIN...</center></div>';
          var dados = $( this ).serialize();
          var form = $(this);
          $('#loading').append(spinner);
          $('.tableItems').remove();

          $.ajax({
             type: "GET",
             url: form.attr('action'),
             data: dados,
             success: function( d )
             {
                JSON.parse(d);
                var d = $.parseJSON(d);
                if(d.error != undefined){
                   $('#error').html('<div class="callout callout-danger" id="msg"><p>'+d.error+'</p> </div>').show();
                } else {
                   $('#error').html('<div class="callout callout-success" id="msg"><p>'+d.success+'</p> </div>').show();
                   $.each(d.updated, function(i, item){
                      $('#tableReturn').append('<tr class="tableItems"> <td><a href="/bilhetes/conferir?code='+item["code"]+'" target="_blank" class="btn btn-sm btn-info">'+item["code"]+'</a></td> <td align="center" class="text-red">R$'+item["old_comission"]+'</td> <td align="center" class="text-green">R$'+item["new_comission"]+'</td> </tr>');
                   });
                }
                $('.loadermodal').remove();
             }
          });
          return false;
        });

      });
   });
</script>