<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/permissoes-usuario.php';
   requerPermissao('25'); // Gerenciar TODOS os usuários do sistema
?>
<link rel="stylesheet" href="/assets/vendor_plugins/iCheck/all.css">
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Permissões de Usuários
         <small>Usuários</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">
            <div class="callout callout-danger" id="msg">
               <h4>Muita atenção!</h4>
               <p>Alterar permissões de usuários de maneira errada por designar previlégios a usuários que não estão aptos para isso. Tenha bastante cuidado na hora de alterar estes parâmetros.</p>
            </div>
         </div>
         <div class="col-lg-4 col-md-4 col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Selecionar usuário</strong></h4>
                  <ul class="box-controls controls-bets pull-right">
                     <li><a class="box-btn-close" href="#"></a></li>
                     <li><a class="box-btn-slide" href="#"></a></li>
                     <li><a class="box-btn-fullscreen" href="#"></a></li>
                  </ul>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <form id="pinForm" method="POST" action="">
                        <label for="" class="block">
                        Escolha um usuário:
                           <select class="custom-select form-control" id="username" name="username">
                              <option value="">Selecione</option>
                              <?php
                                 foreach ($users as $tuid => $v) {
                                    // if($_SESSION["tipos_usuarios"][$_SESSION["usuario"]["tipo"]]["hierarquia"] <> '1'){ continue; }
                                    echo '<optgroup label="'.$_SESSION["tipos_usuarios"][$tuid]["nome"].'">';
                                    foreach ($v as $u) {
                                       echo '<option '; if($registro == $u["id"]){ echo 'selected'; } echo ' value="'.$u["id"].'">'.$u["nome"].'</option>';
                                    }
                                    echo '</optgroup>';
                                 }
                              ?>
                           </select>
                        </label>
                        <div class="row">
                           <div class="col-12">
                              <button class="btn btn-success btn-md pull-right"><i class="fa fa-shield"></i> &nbsp; Ver Permissões</button>
                           </div>
                        </div>
                     </form>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-lg-8 col-md-8 col-12">
            <form id="finishPermissions" action="/api/changePermissions" method="POST">
               <div class="box box-solid bg-warning">
                  <div class="box-header">
                     <h4 class="box-title"><strong class="event-strong">Permissões do usuário </strong></h4>
                     <button type="submit" class="btn bg-success btn-md pull-right" id="finishEdition"><i class="fa fa-check"></i> &nbsp; Salvar</button>
                  </div>
                  <div class="box-content">
                     <div class="box-body loadingSpinner">
                        <input type="hidden" name="user" value="<?php echo $registro; ?>">
                        <?php
                           foreach ($all_perms as $c => $v) {
                              echo '<center><blockquote class="title_separator"><b>'.$c.'</b></blockquote></center><div class="row">';

                              foreach ($v as $k => $v2) {
                                 echo '<div class="col-xs-12 col-3 perms_items"><input '; if(in_array($v2["id"], $user_perms)){ echo 'checked'; } echo ' type="checkbox" id="check'.$v2["id"].'" class="chk-col-green" name="perms[]" value="'.$v2["id"].'" /> &nbsp; <label for="check'.$v2["id"].'">'.$v2["name"].'</label></div>';
                              }
                              echo '</div>';
                           }
                        ?>

                     </div>
                  </div>
               </div>
            </form>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script>

   $(function(){
      $(document).ready(function(){
         var spinner = '<div class="loadermodal"><center><img class="floader" src="/loaders/rings.svg" /> Recuperando permissões...</center></div>';
         $('#pinForm').submit(function(e){
            $('#msg').remove();
            $('#loadingData, #error').hide();
            $('.loadingSpinner').append(spinner);
            var dados = $( '#username' ).val();
            location.href = '/usuarios/permissoes/'+dados;

            e.preventDefault();
         });

         $('#finishPermissions').submit(function(ev){
           ev.preventDefault();
           var dados = $( this ).serialize();
           var f = $(this);
            $('[id="finishEdition"]').html('<i class="fa fa-spinner fa-spin" style="margin-right: 5px;"></i> Salvando').toggleClass('btn-info bg-success');

           $.ajax({
             type: "GET",
             url: f.attr('action'),
             data: dados,
             success: function( d )
             {
               try {
                   JSON.parse(d);
                   var info = $.parseJSON(d);
                   if(info.success != undefined){
                     $.toast({
                        heading: 'Pronto!',
                        text: 'As permissões foram alteradas com sucesso.',
                        position: 'top-right',
                        loaderBg: '#FFF',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                     });
                   } else {

                     alert(info.error);

                     $.toast({
                        heading: 'Ops!',
                        text: 'Ocorreu um erro na alteração de permissões.',
                        position: 'top-right',
                        loaderBg: '#FFF',
                        icon: 'error',
                        hideAfter: 3500,
                        stack: 6
                     });
                   }
               } catch (e) {
                   alert(info.error);

                  $.toast({
                     heading: 'Ops!',
                     text: 'Ocorreu um erro na alteração de permissões.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'error',
                     hideAfter: 3500,
                     stack: 6
                  });
               }

               $('[id="finishEdition"]').html('<i class="fa fa-check" style="margin-right: 5px;"></i> Salvar').toggleClass('btn-info bg-success');
             }
           });

         });
      });
   });
</script>