<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/prestar-contas.php';
   requerPermissao('30:31');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Prestação de Contas
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <blockquote class="blockquote custom_blockquote">
              <b>Lembre-se: </b> os caixas são zerados automaticamente. Você pode utilizar esta seção para obter os valores que precisam ser prestado contas. Acompanhe qualquer caixa a qualquer momento, através desta seção ou em <a href="/usuarios/caixa-dos-usuarios" class="text-warning">Caixa dos usuários</a>.
            </blockquote>

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Prestação de Contas</strong></h4>
                  <a href="/prestacao-de-contas/historico" class="btn btn-warning btn-md pull-right"><i class="fa fa-history"></i> &nbsp; Ver histórico</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <form action="" style="max-width: 300px;">
                           <center><b>Filtro de datas</b></center>
                          <div class="input-group">
                            <input type="text" name="date" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="De" value="<?php echo $api['date']; ?>">
                            <span class="input-group-addon">&nbsp; até &nbsp;</span>
                            <input type="text" name="enddate" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="Até" value="<?php echo $api['enddate']; ?>">
                          </div>
                          <button type="submit" class="btn btn-info btn-md btn-block"><i class="fa fa-search"></i> &nbsp; Aplicar</button><br />
                        </form>

                        <table id="exampe" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="80">Status</th>
                                 <th width="120">Entradas</th>
                                 <th width="120">Saídas</th>
                                 <th width="120">Comissões</th>
                                 <th width="120">Lançamentos</th>
                                 <th width="120">Total</th>
                                 <th width="200">Operações</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="9" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['user_info'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><?php echo strtoupper($v["name"]); ?><div style="font-size: 12px;"><b><i class="fa fa-caret-right"></i> &nbsp; <?php echo $api["dates"]; ?></b></div></td>
                                 <td align="center"><a id="changeStatus" data-usuario="<?php echo ($v['id']); ?>" class="btn btnStatusUser<?php echo ($v['id']); ?> btn-sm btn-<?php if($v['status'] == '1'){ echo 'success'; } else { echo 'danger'; } ?>" data-toggle="tooltip" data-placement="top" title="Ativar / Desativar"><?php if($v['status'] == '1'){ echo 'Ativo'; } else { echo 'Inativo'; } ?></a></td>
                                 <td align="center"><b class="">R$<?php echo $v["entries"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["rewards"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["comissions"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["lanc"]; ?></b></td>
                                 <td align="center" class="text-<?php if($v['balance_type'] == '-'){ echo 'danger'; } elseif($v['balance'] == '0,00'){ } else { echo 'success'; } ?>"><b class="">R$<?php echo $v["balance"]; ?></b></td>
                                 <td align="center">
                                  <a href="/imprimir-caixa?type=general&user=<?php echo $v['id']; ?>&date=<?php echo $api['date']; ?>&enddate=<?php echo $api['enddate']; ?>" target="_blank" class="btn bg-warning btn-sm" data-toggle="tooltip" data-placement="top" title="Imprimir"><i class="fa fa-print"></i></a>
                                  <a href="/caixa?type=general&user=<?php echo $v['id']; ?>&date=<?php echo $api['date']; ?>&enddate=<?php echo $api['enddate']; ?>" target="_blank" class="btn bg-navy btn-sm" data-toggle="tooltip" data-placement="top" title="Detalhar"><i class="fa fa-file-text"></i></a>
                                  <a id="markOK" url="/api/setAccountabilityOK?user=<?php echo $v['id']; ?>&date=<?php echo $api['date']; ?>&enddate=<?php echo $api['enddate']; ?>" class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Marcar como prestado contas"><i class="fa fa-check"></i></a>
                                 </td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('[id="markOK"]').click(function(ev){
          alert('A');
            var btn = $(this);
            var url = btn.attr('url');
            btn.html('<i class="fa fa-spinner fa-spin"></i>').toggleClass('btn-success btn-info');
            $.get(url, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-check"></i>').toggleClass('btn-success btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){
                btn.toggleClass('bg-navy btn-info').html('<i class="fa fa-thumbs-up"></i>').hide();

                $.toast({
                  heading: 'Pronto!',
                  text: 'Marcado como prestado contas.',
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

              }
            });

            return false;
            ev.preventDefault();
        });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script>