<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/prestar-contas-historico.php';
   requerPermissao('30:31');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Histórico
         <small>Prestação de Contas</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <blockquote class="blockquote custom_blockquote">
              <b>Lembre-se: </b> os caixas são zerados automaticamente. Você pode utilizar esta seção para obter os valores que precisam ser prestado contas. Acompanhe qualquer caixa a qualquer momento, através desta seção ou em <a href="/usuarios/caixa-dos-usuarios" class="text-warning">Caixa dos usuários</a>.
            </blockquote>

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Histórico - Prestação de Contas</strong></h4>
                  <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i></a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="120">Entradas</th>
                                 <th width="120">Saídas</th>
                                 <th width="120">Comissões</th>
                                 <th width="120">Lançamentos</th>
                                 <th width="120">Total</th>
                                 <th width="200">Período</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['items'] as $i => $v) {
                                  $i++;
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><?php echo strtoupper($v["user"]); ?><div style="font-size: 12px;"><b><i class="fa fa-caret-right"></i> &nbsp; Feito por <?php echo $v["admin"]; ?></b></div></td>
                                 <td align="center"><b class="">R$<?php echo $v["entries"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["rewards"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["comissions"]; ?></b></td>
                                 <td align="center"><b class="">R$<?php echo $v["lanc"]; ?></b></td>
                                 <td align="center" class="text-<?php if($v['balance_type'] == '-'){ echo 'danger'; } elseif($v['balance'] == '0,00'){ } else { echo 'success'; } ?>"><b class="">R$<?php echo $v["balance"]; ?></b></td>
                                 <td align="center"><?php echo $v["date"]; ?></td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('[id="markOK"]').click(function(ev){
            var btn = $(this);
            var url = btn.attr('url');
            btn.html('<i class="fa fa-spinner fa-spin"></i>').toggleClass('btn-success btn-info');
            $.get(url, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-check"></i>').toggleClass('btn-success btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){
                btn.toggleClass('bg-navy btn-info').html('<i class="fa fa-thumbs-up"></i>').hide();

                $.toast({
                  heading: 'Pronto!',
                  text: 'Marcado como prestado contas.',
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

              }
            });

            return false;
            ev.preventDefault();
        });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script>