<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/parametros.php';
   requerPermissao('32');
?>
<link rel="stylesheet" href="/assets/vendor_plugins/iCheck/all.css">
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Parâmetros
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
        <form id="paramsForm" method="POST" action="/api/setParams">
           <div class="col-12">
              <div class="box box-solid bg-black">
                 <div class="box-header">
                    <h4 class="box-title"><strong class="event-strong">Parâmetros</strong></h4>
                    <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
                 </div>
                 <div class="box-content">
                    <div class="box-body">
                      <div class="row">
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Informações Básicas</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Nome da banca</label>
                            <input value="<?php echo $api['config_nome']; ?>" name="config_nome" type="text" class="form-control" placeholder="Ex: Bets Fan">
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>E-mail</label>
                            <input value="<?php echo $api['config_email']; ?>" name="config_email" type="text" class="form-control">
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Telefone</label>
                            <input value="<?php echo $api['config_telefone']; ?>" name="config_telefone" type="text" class="form-control">
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Telefone na impressão</label>
                              <select name="config_tel_impressao" class="form-control">
                                <option value="1">Selecione</option>
                                <option <?php if($api['config_tel_impressao'] == '1'){ echo 'selected'; } ?> value="1">Banca</option>
                                <option <?php if($api['config_tel_impressao'] == '2'){ echo 'selected'; } ?> value="2">Vendedor > Gerente > Banca</option>
                                <option <?php if($api['config_tel_impressao'] == '3'){ echo 'selected'; } ?> value="3">Gerente > Banca</option>
                                <option <?php if($api['config_tel_impressao'] == '4'){ echo 'selected'; } ?> value="4">Vendedor > Banca</option>
                              </select>
                              <p class="help-block">Selecione a ordem de exibição do telefone na impressão.</p>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Jogos por bilhete</label>
                            <div class="input-group">
                              <span class="input-group-addon">Mínimo:</span>
                              <input value="<?php echo $api['config_min_jogos']; ?>" type="text" class="form-control" name="config_min_jogos" placeholder="Ex: 2">
                              <span class="input-group-addon"> apostas por bilhete</span>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="input-group">
                              <span class="input-group-addon">Máximo:</span>
                              <input value="<?php echo $api['config_max_apostas']; ?>" type="text" class="form-control" name="config_max_apostas" placeholder="Ex: 20">
                              <span class="input-group-addon"> apostas por bilhete</span>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Prêmio máximo</label>
                            <div class="input-group">
                              <span class="input-group-addon">R$</span>
                              <input onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" value="<?php echo $api['config_max_ganhos_reais']; ?>" type="text" class="form-control" name="config_max_ganhos_reais" placeholder="Ex: 20.000,00">
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Multiplicador máximo</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_multiplicador']; ?>" type="text" class="form-control" name="config_multiplicador" placeholder="Ex: 500">
                              <span class="input-group-addon">vezes</span>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Se o multiplicador máximo for atingido</label>
                            <div class="input-group">
                              <select name="config_atingiu_maximo" class="form-control">
                                <option value="">Selecione</option>
                                <option <?php if($api['config_atingiu_maximo'] == '1'){ echo 'selected'; } ?> value="1">Permite aposta e limita ao multiplicador máximo</option>
                                <option <?php if($api['config_atingiu_maximo'] == '0'){ echo 'selected'; } ?> value="0">Impede a conclusão da aposta</option>
                              </select>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Exibir jogos até</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_sincronizacao']; ?>" type="text" class="form-control datetime" name="config_sincronizacao" placeholder="Ex: DD/MM/AAAA HH:MM">
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Informar nome do cliente nos bilhetes</label>
                            <div class="input-group">
                              <select name="config_exigir_nome_cliente" class="form-control">
                                <option value="">Selecione</option>
                                <option <?php if($api['config_exigir_nome_cliente'] == '1'){ echo 'selected'; } ?> value="1">Obrigatório</option>
                                <option <?php if($api['config_exigir_nome_cliente'] == '0'){ echo 'selected'; } ?> value="0">Opcional</option>
                              </select>
                            </div>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Ao Vivo</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Ao vivo até</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_aovivo_ate']; ?>" type="text" class="form-control" name="config_aovivo_ate" placeholder="Ex: 80">
                              <label class="input-group-addon">mins de jogo</label>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Desconto / Aumento AO VIVO</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_aovivo']; ?>" type="text" class="form-control" name="config_aovivo" placeholder="Ex: 5 ou -5">
                              <label class="input-group-addon">%</label>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Jogos entram no ao vivo</label>
                            <div class="input-group">
                              <select name="config_aovivo_tipo" class="form-control">
                                <option value="">Selecione</option>
                                <option <?php if($api['config_aovivo_tipo'] == 'auto'){ echo 'selected'; } ?> value="auto">Automaticamente</option>
                                <option <?php if($api['config_aovivo_tipo'] == 'manual'){ echo 'selected'; } ?> value="manual">Manualmente</option>
                              </select>
                            </div>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Cancelamento de bilhetes</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Prazo de cancelamento</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_prazo_cancelamento']; ?>" type="text" class="form-control" name="config_prazo_cancelamento" placeholder="Ex: 40">
                              <label class="input-group-addon">minutos</label>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Cancelamento</label>
                            <div class="input-group">
                              <label><input <?php if($api['config_cambista_cancela'] == '1'){ echo 'checked'; } ?> type="checkbox" class="form-control chk-col-green" name="config_cambista_cancela" value="1"> &nbsp; Cancelamento permitido, antes dos jogos começarem.</label>
                            </div>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Monitoramento de Apostas</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Por valor</label>
                            <div class="input-group">
                              <label class="input-group-addon">R$</label>
                              <input onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" value="<?php echo $api['config_not_valor']; ?>" type="text" class="form-control" name="config_not_valor" placeholder="Ex: 500,00">
                            </div>
                            <p class="help-block">Quando o valor de uma aposta for maior que esse, você verá na seção de monitoramento.</p>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Por prêmio</label>
                            <div class="input-group">
                              <label class="input-group-addon">R$</label>
                              <input onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" value="<?php echo $api['config_not_premio']; ?>" type="text" class="form-control" name="config_not_premio" placeholder="Ex: 500,00">
                            </div>
                            <p class="help-block">Quando o prêmio de uma aposta for maior que esse, você verá na seção de monitoramento.</p>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Cotações</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Cotação mínima - Apostas simples</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_ct_minima_simples']; ?>" type="text" class="form-control oddtype" name="config_ct_minima_simples" placeholder="Ex: 1.25">
                            </div>
                            <p class="help-block">Menor cotação permitida para apostas com 1 time.</p>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Cotação mínima - Apostas múltiplas</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_ct_minima_multipla']; ?>" type="text" class="form-control oddtype" name="config_ct_minima_multipla" placeholder="Ex: 1.25">
                            </div>
                            <p class="help-block">Menor cotação permitida para apostas com 2 ou mais times.</p>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Cotação máxima</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_ct_maxima']; ?>" type="text" class="form-control oddtype" name="config_ct_maxima" placeholder="Ex: 50.00">
                            </div>
                            <p class="help-block">Maior cotação permitida de ser mostrada no sistema.</p>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Menor cotação por bilhete</label>
                            <div class="input-group">
                              <input value="<?php echo $api['config_menor_multiplicador_bilhete']; ?>" type="text" class="form-control oddtype" name="config_menor_multiplicador_bilhete" placeholder="Ex: 2.00">
                            </div>
                            <p class="help-block">Ex: 2.00. Neste caso, se a cotação total do bilhete for abaixo de 2.00, a aposta não é finalizada.</p>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Processamento de PINs</blockquote></div>
                        <div class="col-12 col-lg-6">
                          <div class="form-group">
                            <label>Conferência de cotações</label>
                            <div class="input-group">
                              <select name="config_conferir_odds_pin" class="form-control">
                                <option value="">Selecione</option>
                                <option <?php if($api['config_conferir_odds_pin'] == '1'){ echo 'selected'; } ?> value="1">Atualizar cotações antes de finalizar</option>
                                <option <?php if($api['config_conferir_odds_pin'] == '0'){ echo 'selected'; } ?> value="0">Finalizar com cotações do PIN original</option>
                              </select>
                            </div>
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Esportes</blockquote></div>
                        <div class="col-12">
                          <div class="box box-warnig box-solid">
                             <div class="box-header with-border">
                                <h3 class="box-title">Esportes</h3>
                             </div>
                             <div id="box-collapse-3" class="">
                                <div class="box-body">
                                   <?php
                                      $sql = $mysqli->query("SELECT esporte_id, esporte_nome, esporte_exibido FROM esportes ORDER BY esporte_ordem ASC");

                                      while($esporte = $sql->fetch_assoc()){
                                        echo '<label for="esp'.$esporte["esporte_id"].'"><input type="checkbox" id="esp'.$esporte["esporte_id"].'"'; if($esporte["esporte_exibido"] == '1'){ echo ' checked '; }  echo 'name="esportes[]" value="'.$esporte["esporte_id"].'"> &nbsp; '.utf8_encode($esporte["esporte_nome"]).'</label> <br />';
                                      }
                                    ?>
                                </div>
                                <!-- /.box-body -->
                             </div>
                             <!-- /.collapse in -->
                          </div>
                        </div>
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Regulamento</blockquote></div>
                        <div class="col-12">
                          <textarea name="config_regulamento" class="form-control" id="editor1" cols="30" rows="10"><?php echo ($api['config_regulamento']); ?></textarea>
                        </div>

                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Rodapé do bilhete</blockquote></div>
                        <div class="col-12">
                          <textarea name="config_bilhete_rodape" class="form-control" id="" cols="30" rows="5"><?php echo ($api['config_bilhete_rodape']); ?></textarea>
                        </div>
                      </div>
                    </div>
                 </div>
                 <div class="box-footer">
                    <button type="submit" id="submitForm" class="btn btn-lg btn-success pull-right"><i class="fa fa-check"></i> &nbsp; Salvar</button>
                 </div>
              </div>
           </div>
         </form>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/js/moneymask.js"></script>
<script src="/js/jquery.mask.js"></script>
<script src="/assets/vendor_plugins/iCheck/icheck.min.js"></script>
<!-- CK Editor -->
<script src="/assets/vendor_components/ckeditor/ckeditor.js"></script>
<script src="/js/pages/editor.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('.datetime').mask('99/99/9999 99:99');
        $('.oddtype').mask('000.00', {reverse: true});

        $('input').iCheck({
          checkboxClass: 'icheckbox_square',
          radioClass: 'iradio_square-red',
          increaseArea: '20%' // optional
        });

        $('#paramsForm').submit(function(){
          for(name in CKEDITOR.instances){
              CKEDITOR.instances[name].destroy()
          }

           $('#submitForm').toggleClass('btn-success btn-info').html('<i class="fa fa-spinner fa-spin"></i> &nbsp; Salvando...');
           var dados = $( this ).serialize();
           var f = $(this);

           $.ajax({
              type: f.attr('method'),
              url: f.attr('action'),
              data: dados,
              success: function( data )
              {
                console.log('DT: '+data);
                 var info = $.parseJSON(data);
                 if(info.error != undefined){ alert(info.error); $('#submitForm').toggleClass('btn-success btn-info').html('<i class="fa fa-check"></i> &nbsp; Salvar'); }
                 else if(info.success != undefined){
                    // alert(info.success);
                    $('#submitForm').css('background', '#1b890e').css('border-color', '#1b890e').html('<i class="fa fa-check"></i> &nbsp; Pronto!');

                    $.toast({
                       heading: 'Pronto!',
                       text: 'Os parâmetros foram salvos com sucesso.',
                       position: 'top-right',
                       loaderBg: '#FFF',
                       icon: 'success',
                       hideAfter: 3500,
                       stack: 6
                    });
                    setTimeout(function(){ $('#submitForm').toggleClass('btn-success btn-info').attr('style', '').html('<i class="fa fa-check"></i> &nbsp Salvar'); }, 2000);
                 }
              }
           });
           CKEDITOR.replace('editor1');
           return false;
        });

      });
    });
</script>
<style>
  .form-group label { font-weight: bold !important; }
  .input-group .input-group-addon, .input-group .input-group-text {
    background-color: #e5e5e5 !important;
  }
</style>