<?php
  include_once $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
  include_once $_SERVER["DOCUMENT_ROOT"].'/inc/functions-financeiro.php';
  include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';


  ini_set('max_execution_time', 120);
  ini_set('memory_limit', '-1');

  ini_set('display_errors',1);
  ini_set('display_startup_erros',1);
  error_reporting(E_ALL);

  $sql = $mysqli->query("SELECT * FROM configs WHERE config_id = '1'");
  $cfg = $sql->fetch_assoc();

  $premio_maximo = $cfg["config_max_ganhos_reais"];
  $multiplicador = $cfg["config_multiplicador"];
  $atingiu_maximo = $cfg["config_atingiu_maximo"];

  function defineSituacaoBilhete($codigo, $apostas){

    $status['1'] = ($apostas['aberto']);
    $status['2'] = ($apostas['ganhou']);
    $status['3'] = ($apostas['perdeu']);
    $status['4'] = ($apostas['cancelado']);

    // Pesquisa se todos são CANCELADOS
    if($status['4'] > 0 && $status['1'] == 0 && $status['2'] == 0 && $status['3'] == 0){
      return '4'; // Cancelado
    }

    // Pesquisa se todos são CANCELADOS
    if($status['4'] > 0 && $status['1'] == 0 && $status['2'] == 0 && $status['3'] == 0){
      return '4'; // Cancelado
    }

    // Pesquisa se todos são GANHOU
    if($status['2'] > 0 && $status['1'] == 0 && $status['3'] == 0){ // Se não houver nenhuma aposta que não seja GANHOU, o bilhete está finalizado
      return '2'; // Ganhou
    }

    // Pesquisa se há apostas perdidas
    if($status['3'] > 0){ // Há apostas perdidas. Então, o bilhete é perdido
      echo 'C '.$codigo.' entrou. C: '.$status['3'].' - AP: '.print_r($apostas).' <br />';
      return '3'; // Perdeu
    }

    // Pesquisa se há apostas em PROCESS. PARCIAL
    if($status['1'] > 0 && $status['3'] == 0 && $status[2] > 0){ // Há apostas em aberto. Então, o bilhete é em aberto
      return '11'; // Processamento Parcial
    }

    // Pesquisa se há apostas em aberto
    if($status['1'] > 0){ // Há apostas em aberto. Então, o bilhete é em aberto
      return '1'; // Em aberto
    }


    return 'undefined';
  }

  function definePremiacao($cotacao, $valor){
    global $premio_maximo;
    global $multiplicador;
    global $atingiu_maximo;

    if($cotacao > $multiplicador){ $cotacao = $multiplicador; }

    $valor = str_replace('.', '', $valor);
    $valor = str_replace(',', '.', $valor);

    $retorno_total = $cotacao * $valor;


    if($atingiu_maximo == '1'){

      $mxfloat = str_replace('.', '', $premio_maximo);
      $mxfloat = str_replace(',', '.', $mxfloat);

      if($retorno_total > $mxfloat){
        return $premio_maximo;
      }
    }
    return $retorno_total;
  }

  $simulador = '0';
  $aGanhas = array();
  $processamento_parcial = array();
  $mqueries = '';

  $bils_abertos = array();

  //OFF while($b = $sql_dois->fetch_assoc()){ array_push($bils_abertos, $b["cupom_codigo"]); }
  //print_r($bils_abertos);
  $bils_abertos = join("','",$bils_abertos);

  // LISTA TODAS AS APOSTAS
  // Próxima segunda
  $proxsegunda = date('Y-m-d');
  $datainicio = date('Y-m-d', strtotime('-3 days', strtotime($proxsegunda)));
  $datalimite = date('Y-m-d', strtotime('+1 days', strtotime($proxsegunda)));

  // SELECT aposta_cupom, aposta_status, COUNT(*) AS total, SUM(aposta_cotacao) AS cotacao FROM apostas WHERE aposta_data > '$datalimite 00:00:00' GROUP BY aposta_cupom, aposta_status
  $sqlAp = $mysqli->query("SELECT aposta_cupom, aposta_status, aposta_cotacao FROM apostas WHERE aposta_usuario <> '$simulador' and aposta_data BETWEEN '$datainicio 00:00:00' and '$datalimite 23:59:59'");
  echo "$datainicio 00:00:00 / $datalimite 23:59:59 <br />";
  if(!$sqlAp){ echo 'GBAN ERROR: '.$mysqli->error; exit; }

  // Inicializa os arrays
  $cupons = array();
  $jaPerdidos = array();
  $wherePerdeu = array();
  $cupons_totais = array();

  // Agrupa em array
  while ($cp = $sqlAp->fetch_assoc()) {

    // Se já perdeu, continua
    if(isset($jaPerdidos[$cp["aposta_cupom"]])){ continue; }

    // Cria cupom caso nao exista
    if(!isset($cupons[$cp["aposta_cupom"]])){
      $cupons[$cp["aposta_cupom"]] = array();
      $cupons[$cp["aposta_cupom"]]['aberto'] = 0;
      $cupons[$cp["aposta_cupom"]]['ganhou'] = 0;
      $cupons[$cp["aposta_cupom"]]['perdeu'] = 0;
      $cupons[$cp["aposta_cupom"]]['cancelado'] = 0;
      $cupons[$cp["aposta_cupom"]]['cotacao'] = 0.00;

      array_push($cupons_totais, $cp["aposta_cupom"]);
    }

    // Se for ABERTO, soma
    if($cp["aposta_status"] == '1'){
      $cupons[$cp["aposta_cupom"]]['aberto'] += 1;
    }

    // Se for GANHOU, soma
    if($cp["aposta_status"] == '2'){
      $cupons[$cp["aposta_cupom"]]['ganhou'] += 1;
      if($cupons[$cp["aposta_cupom"]]['cotacao'] == 0.00){ $cupons[$cp["aposta_cupom"]]['cotacao'] = $cp["aposta_cotacao"]; }
      else { $cupons[$cp["aposta_cupom"]]['cotacao'] *= $cp["aposta_cotacao"]; }
    }

    // Se for PERDEU, soma
    if($cp["aposta_status"] == '3'){
      $jaPerdidos[$cp["aposta_cupom"]] = 1;

      if(!in_array($cp["aposta_cupom"], $wherePerdeu)){
          array_push($wherePerdeu, $cp["aposta_cupom"]);
      }
    }

    // Se for CANCELADO, soma
    if($cp["aposta_status"] == '4'){
      $cupons[$cp["aposta_cupom"]]['cancelado'] += 1;
    }

  }

  //print_r($cupons['1417718191']);

  // Seleciona usuários individuais
  $usuariosIndividuais = array();
  $sql = $mysqli->query("SELECT usuario_credito, usuario_id FROM usuarios WHERE usuario_tipo = '5'");



  if(!$sql){ echo 'ERRO 1! '.$mysqli->error; exit; }
  while($ui = $sql->fetch_assoc()){
    if(!isset($usuariosIndividuais[$ui["usuario_id"]])){ $usuariosIndividuais[$ui["usuario_id"]] = $ui["usuario_credito"]; }
  }

  // Coloca PERDEU nos bilhetes JAPERDEU
  $wherePerdeu = join("','",$wherePerdeu);
  $sql = $mysqli->query("UPDATE cupons SET cupom_situacao = '3' WHERE cupom_codigo IN ('$wherePerdeu')");

  echo '- Bilhetes perdidos: '.$mysqli->affected_rows.' <br />';

  // STATUS


  $sql_dois = $mysqli->query("SELECT cupom_usuario, cupom_id, cupom_codigo, cupom_valor, cupom_situacao FROM cupons WHERE cupom_situacao = '1' and cupom_usuario <> {$simulador}");
  if(!$sql_dois){ echo 'ERRO 2! O sistema retornou: '.$mysqli->error; exit; }
  //OFF $sql_dois->data_seek(0);
  //echo "SELECT cupom_usuario, cupom_id, cupom_codigo, cupom_valor, cupom_situacao FROM cupons WHERE cupom_situacao = '1' and cupom_usuario <> {$simulador}";
  $erros = 0;
  $sucesso = 0;
  // echo 'Iniciou em '.date('d/m/Y - H:i:s').'<br />';
  echo 'Total: '.$sql_dois->num_rows.' bilhetes em aberto. <br />';

  while($c = $sql_dois->fetch_assoc()){
    if(!isset($cupons[$c["cupom_codigo"]])){ /* echo 'O cupom <b>'.$c["cupom_codigo"].'</b> foi pulado. MOTIVO INDEFINIDO! <br />'; */ continue; }

    $status = defineSituacaoBilhete($c["cupom_codigo"], $cupons[$c["cupom_codigo"]]);

    // Processamento parcial
    if($status == '11'){
        array_push($processamento_parcial, $c["cupom_codigo"]);
        continue;
    }

    $id = $c["cupom_id"];

    // SAÍDAS
    if($status == '2'){
      $premios = definePremiacao($cupons[$c["cupom_codigo"]]['cotacao'], $c["cupom_valor"]);
      if($premios == '0,00' || $premios == '0.00' || $premios == ''){ echo 'O bilhete '.$c["cupom_codigo"].' foi pulado por estar com valor do premio em branco. CT: '.$cupons[$c["cupom_codigo"]]['cotacao'].' | CV: '.$c["cupom_valor"].' | RT: '.$premios.' <br />'; continue; }
    }
    else {
      $premios = '';
    }


    if($status == '0'){ /* echo 'O cupom <b>'.$c["cupom_codigo"].'</b> foi pulado! <br />'; */ continue;  }
    if($status == '1'){
      continue;
    }

    // Altera saldo para usuário individual
    if(isset($usuariosIndividuais[$c["cupom_usuario"]])){
      $saldo = $usuariosIndividuais[$c["cupom_usuario"]];
      $saldo = opMonetaria($saldo, $premios, '+');
      $uid = $c["cupom_usuario"];

      echo 'Alteração de saldo do '.$uid.', de '.$usuariosIndividuais[$c["cupom_usuario"]].' para '.$saldo.' <br />';

      $sql = $mysqli->query("UPDATE usuarios SET usuario_credito = '$saldo' WHERE usuario_id = '$uid'");
    }

    $mqueries .= "UPDATE cupons SET cupom_saidas = '$premios', cupom_situacao = '$status' WHERE cupom_id = '$id'; ";

      echo 'Bilhete <b>'.$c["cupom_codigo"].'</b> foi alterado para ';
      switch ($status) {
        case '1':
          echo '<span class="label label-xs label-info">Aguardando Resultado</span>';
          break;

        case '2':
          echo '<span class="label label-xs label-success">Ganhou</span>';
          break;

        case '3':
          echo '<span class="label label-xs label-danger">Perdeu</span>';
          break;

        default:
          echo 'INDEFINIDO';
          break;
      }
      //echo '<br /> Q: <textarea>'.$mqueries.'</textarea>';
      echo '! <br />';
      $sucesso++;
  }

  //exit;

  // Coloca bilhetes em processamento parcial
  $processamento_parcial = join("','",$processamento_parcial);
  echo 'Parcial: '.$processamento_parcial;
  $mqueries .= "UPDATE cupons SET cupom_parcial = '1' WHERE cupom_codigo IN ('$processamento_parcial') and cupom_situacao = '1'; ";

  $sqlmulti = mysqli_multi_query($mysqli, $mqueries);
  if(!$sqlmulti){ /*echo '<br />ERRO MULTQ! O sistema retornou: '.$mysqli->error; */ exit; }
    else {
      echo '<br />Bilhetes ganhos: '.$mysqli->affected_rows;
    }



?>