<?php
  require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
  require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
  require $_SERVER["DOCUMENT_ROOT"].'/api/pages/lancamentos.php';
  requerPermissao('29');
?>
<style> .main-header { z-index: 2 !important; } </style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Lançamentos de Caixa
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <br />
      <div class="row">
         <div class="col-lg-4 col-12">
            <form action="">
              <div class="input-group">
                <input type="text" name="date" class="form-control pull-right" id="datepicker" placeholder="De" value="<?php echo $api['date']; ?>">
                <span class="input-group-addon">&nbsp; até &nbsp;</span>
                <input type="text" name="enddate" class="form-control pull-right" id="datepicker" placeholder="Até" value="<?php echo $api['enddate']; ?>">
              </div>
              <button type="submit" class="btn btn-info btn-md btn-block"><i class="fa fa-search"></i> &nbsp; Filtrar</button><br />
            </form>
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border bg-inverse">
                  <h3 class="box-title">Novo lançamento</h3>
               </div>
               <div class="box-body">
                  <form id="lancForm" method="GET" action="/api/setCashierLaunch">
                     <label for="" class="block margin-bottom-10">
                        Selecione o usuário:
                        <select name="user_launch" class="form-control">
                           <option value="">Selecione</option>
                           <?php
                              foreach ($users as $tuid => $v) {
                                 // if($_SESSION["tipos_usuarios"][$_SESSION["usuario"]["tipo"]]["hierarquia"] <> '1'){ continue; }
                                 echo '<optgroup label="'.$_SESSION["tipos_usuarios"][$tuid]["nome"].'">';
                                 foreach ($v as $u) {
                                    echo '<option value="'.$u["id"].'">'.$u["nome"].'</option>';
                                 }
                                 echo '</optgroup>';
                              }
                           ?>
                        </select>
                     </label>
                     <label for="" class="block margin-bottom-10">
                        Data:
                        <input type="text" class="form-control" name="date_launch" placeholder="DD/MM/AAAA HH:MM" value="<?php echo date('d/m/Y H:i'); ?>" />
                     </label>
                     <label for="" class="block margin-bottom-10">
                        Descrição:
                        <input type="text" class="form-control" name="description" placeholder="Ex: Pagamento de prêmio" />
                     </label>
                     <label for="" class="block margin-bottom-10">
                        Tipo:
                        <select name="type" class="form-control">
                           <option value="">Selecione</option>
                           <option value="C">(+) Crédito</option>
                           <option value="D">(-) Débito</option>
                        </select>
                     </label>
                     <label for="" class="block margin-bottom-10">
                        Valor:
                        <input type="text" class="form-control" name="price" placeholder="0,00" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" />
                     </label>
                     <div class="row">
                        <div class="col-12">
                           <button class="btn btn-success btn-md pull-right" id="sendForm"><i class="fa fa-check"></i> &nbsp; Adicionar</button>
                        </div>
                     </div>
                     <br /><br />
                     <blockquote class="blockquote custom_blockquote">
                      <b>Crédito: </b> adiciona ao caixa do usuário. <br />
                      <b>Débito: </b> retira do caixa do usuário. <br />
                    </blockquote>
                  </form>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
         <div class="col-lg-8 col-12">
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Lançamentos</h3>
               </div>
               <!-- /.box-header -->
               <div class="box-body">
                  <div class="table-responsive">
                     <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                        <thead>
                           <tr>
                              <th>-</th>
                              <th>Data</th>
                              <th>Usuário</th>
                              <th>Valor</th>
                              <th>Tipo</th>
                              <th>Descrição</th>
                              <th>Opções</th>
                           </tr>
                        </thead>
                        <tbody>
                           <?php $i = 1; foreach ($api['list'] as $code => $v) { ?>
                           <tr id="lanc<?php echo $v['id']; ?>">
                              <td align="center"><?php echo $i; ?></td>
                              <td align="center"><?php echo desfazDatetime($v["date"]); ?></td>
                              <td align="center"><b><?php echo $v["user"]; ?></b></td>
                              <td align="center">R$<?php echo $v["price"]; ?></td>
                              <td align="center">
                                 <?php
                                    switch ($v["type"]) {
                                       case 'C':
                                          echo '<span class="badge badge-success">Crédito</span>';
                                          break;

                                       case 'D':
                                          echo '<span class="badge badge-danger">Débito</span>';
                                          break;

                                       default:
                                          echo '<span class="badge badge-warning">Indefinido</span>';
                                          break;
                                    }
                                 ?>
                              </td>
                              <td align="center"><?php echo $v["description"]; ?></td>
                              <td align="center">
                                <a id="markOK" url="/api/deleteCashierLaunch?id=<?php echo $v['id']; ?>" data-id="<?php echo $v['id']; ?>" class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="top" title="Apagar lançamento"><i class="fa fa-times"></i></a>
                              </td>
                           </tr>
                           <?php $i++; } ?>
                        </tbody>
                        <tfoot>
                           <tr>
                              <th>-</th>
                              <th>Usuário</th>
                              <th>Data</th>
                              <th>Valor</th>
                              <th>Tipo</th>
                              <th>Descrição</th>
                              <th>Opções</th>
                           </tr>
                        </tfoot>
                     </table>
                  </div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- InputMask -->
<script src="/assets/vendor_plugins/input-mask/jquery.inputmask.js"></script>
<script src="/assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- popper -->
<script src="/assets/vendor_components/popper/dist/popper.min.js"></script>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

         $('#lancForm').submit(function(e){
            var dados = $( this ).serialize();
            var form = $(this);
            $('#sendForm').toggleClass('btn-success btn-info').html('<i class="fa fa-spinner fa-spin"></i>');

            $.ajax({
               type: "GET",
               url: form.attr('action'),
               data: dados,
               success: function( d )
               {
                  JSON.parse(d);
                  var d = $.parseJSON(d);
                  if(d.error != undefined){
                     $.toast({
                        heading: 'Erro!',
                        text: d.error,
                        position: 'top-right',
                        loaderBg: '#FFF',
                        icon: 'error',
                        hideAfter: 3500,
                        stack: 6
                     });
                     $('#sendForm').toggleClass('btn-danger btn-info').html('<i class="fa fa-times"></i> &nbsp; OOOPS!');
                     setTimeout(function(){ $('#sendForm').toggleClass('btn-success btn-danger').html('<i class="fa fa-check"></i> &nbsp; Adicionar'); }, 3500);
                  } else {
                     $.toast({
                        heading: 'Pronto!',
                        text: 'O lançamento foi efetuado com sucesso.',
                        position: 'top-right',
                        loaderBg: '#FFF',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                     });
                     $('#sendForm').toggleClass('btn-success btn-info').html('<i class="fa fa-check"></i> &nbsp; Pronto!');
                     setTimeout(function(){ location.reload(); }, 2000);
                  }
               }
            });
            e.preventDefault();
         });

        $('[id="markOK"]').click(function(ev){
            var btn = $(this);
            var url = btn.attr('url');
            var id = btn.attr('data-id');
            btn.html('<i class="fa fa-spinner fa-spin"></i>').toggleClass('btn-success btn-info');
            $.get(url, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-check"></i>').toggleClass('btn-success btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){
                $('#lanc'+id).hide();
                $.toast({
                  heading: 'Pronto!',
                  text: 'O lançamento foi apagado.',
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

              }
            });

            return false;
            ev.preventDefault();
        });

      });
    });
 </script>