<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/home.php';
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Início
         <small>Gestão de Banca</small>
      </h1>
      <p class="pull-right" style=" margin-top: -30px; "><?php echo $balance["dates"]; ?></p>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-<?php if($balance['total'] < 0){ echo 'red'; } else { echo 'success'; } ?>">
               <span class="info-box-icon bg-white text-<?php if($balance['total'] < 0){ echo 'red'; } else { echo 'success'; } ?>"><i class="ti-money"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">R$<?php echo $balance["total"]; ?></span>
                  <span class="info-box-text">Caixa</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-info">
               <span class="info-box-icon bg-white text-info"><i class="ti-layout-media-center"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">R$<?php echo $balance["open_entries"]; ?></span>
                  <span class="info-box-text">Em aberto</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <!-- fix for small devices only -->
         <div class="clearfix visible-sm-block"></div>
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-purple">
               <span class="info-box-icon bg-white text-purple"><i class="ti-calendar"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number"><?php echo $balance["today_coupons"]; ?></span>
                  <span class="info-box-text">Bilhetes hoje</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-inverse">
               <span class="info-box-icon bg-white text-warning"><i class="ti-star"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number"><b><?php echo $balance["best_seller"]; ?></b> <sup>R$<?php echo $balance["best_seller_balance"]; ?></sup></span>
                  <span class="info-box-text">Vendedor da semana</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
      </div>
      <div class="row">
         <div class="col-lg-6 col-12">
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Bilhetes vendidos</h3>
                  <div class="box-tools pull-right">
                     <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                     <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
               </div>
               <div class="box-body">
                  <ul class="list-inline text-right">
                     <li>
                        <h5><i class="fa fa-circle mr-5 text-info"></i>Pré-jogo</h5>
                     </li>
                     <li>
                        <h5><i class="fa fa-circle mr-5 text-danger"></i>Ao Vivo</h5>
                     </li>
                  </ul>
                  <div id="grafico-vendas-dashboard" style="height: 250px;"></div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
         <div class="col-lg-6 col-12">
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Usuários negativos</h3>
                  <div class="box-tools pull-right">
                     <a href="/usuarios/colaboradores" class="btn btn-default btn-sm" style=" margin-top: -2px; "><i class="fa fa-plus"></i> &nbsp; Ver todos</a>
                  </div>
               </div>
               <div class="box-body">
                  <div class="media-list media-list-hover media-list-divided">
                     <?php
                        $i = 5;
                        foreach ($users['user_info'] as $k => $v) {
                           if($v['balance_type'] <> '-' || $i == 0){ continue; }
                           $i--;
                     ?>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="/caixa?type=general&user=<?php echo $v['id']; ?>"><strong><?php echo $v['name']; ?></strong></a>
                              <time class="float-right"><a href="/caixa?type=general&user=<?php echo $v['id']; ?>" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><a id="changeStatus" data-usuario="<?php echo ($v['id']); ?>" class="btn btnStatusUser<?php echo ($v['id']); ?> btn-xs btn-<?php if($v['status'] == '1'){ echo 'success'; } else { echo 'danger'; } ?>" data-toggle="tooltip" data-placement="top" title="Ativar / Desativar"><?php if($v['status'] == '1'){ echo 'Ativo'; } else { echo 'Inativo'; } ?></a> &nbsp; <b class="text-danger">R$ <?php echo $v['balance']; ?></b></p>
                        </div>
                     </div>
                     <?php } ?>
                  </div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
      </div>
      <!-- /.row -->
      <div class="row">
         <div class="col-lg-12 col-12">
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Crédito acabando</h3>
                  <div class="box-tools pull-right">
                     <a href="/usuarios/colaboradores" class="btn btn-default btn-sm" style=" margin-top: -2px; "><i class="fa fa-plus"></i> &nbsp; Ver todos</a>
                  </div>
               </div>
               <div class="box-body">
                  <div class="media-list media-list-hover media-list-divided">
                     <?php
                        usort($users['user_info'], function($a, $b) { return $a['credit_cents'] - $b['credit_cents']; });
                        $i = 5;
                        foreach ($users['user_info'] as $k => $v) {
                           if($i == 0){ continue; }
                           $i--;
                     ?>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="/caixa?type=general&user=<?php echo $v['id']; ?>"><strong><?php echo $v['name']; ?></strong></a>

                              <div class="input-group input-group-sm pull-right" style=" max-width: 150px; margin-top: -17px; ">
                                 <span class="input-group-addon"><i class="fa fa-dollar"></i></span>
                                 <input type="text" class="form-control margin0" id="saldo-<?php echo ($v['id']); ?>" value="<?php echo $v['credit']; ?>" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);">
                                 <span class="input-group-btn">
                                    <a data-usuario="<?php echo ($v['id']); ?>" id="changeSaldo" class="btn btn-success btn-sm"><i class="fa fa-check"></i></a>
                                 </span>
                              </div>
                           </p>
                           <p><b class="text-green" id="credit<?php echo $v['id']; ?>">R$ <?php echo $v['credit']; ?></b> | Gerente: <?php echo $v['manager']; ?></p>
                        </div>
                     </div>
                     <?php } ?>
                  </div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

         Morris.Area({
              element: 'grafico-vendas-dashboard',
              data: [
              <?php
               foreach ($balance["seller_by_category"] as $p => $v) {
                  echo "{
                     period: '".$p."',
                     PreJogo: ".$v["prematch"].",
                     AoVivo: ".$v["live"].",
                  },";
               }
              ?>
              ],
              xkey: 'period',
              parseTime: false,
              ykeys: ['PreJogo', 'AoVivo'],
              labels: ['Pré-Jogo', 'Ao Vivo'],
              pointSize: 0,
              fillOpacity: 0.9,
              pointStrokeColors:['#b4becb', '#01c0c8'],
              behaveLikeLine: true,
              gridLineColor: '#e0e0e0',
              lineWidth: 0,
              smooth: false,
              hideHover: 'auto',
              lineColors: ['#398bf7', '#f96868'],
              resize: true
          });

         $('[id="secondaryBlock"]').click(function(){
            var u = $(this).attr('data-usuario');
            $('.btnStatusUser'+u).click();
         });

         $('[id="changeSaldo"]').click(function(){
            var btn = $(this);
            btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-spinner fa-spin');
            var user = btn.attr('data-usuario');
            var balance = $('#saldo-'+user).val();

            $.get('/api/changeBalance?user='+user+'&balance='+balance, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
               }
               else if(info.success != undefined){
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
                  $('#saldo-'+user).css('background', '#14b56f47');
                  $('#credit'+user).html('R$ '+balance);

                  $.toast({
                     heading: 'Pronto!',
                     text: 'O crédito foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                  });
               }
            });
         });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script>