<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/home.php';
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Início
         <small>Gestão de Banca</small>
      </h1>
      <a href="/nova-aposta" class="btn btn-success pull-right" style=" margin-top: -38px; "><i class="ti-plus"></i> &nbsp; Nova Aposta</a>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-success">
               <span class="info-box-icon bg-white text-success"><i class="ti-money"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">R$2.369,00</span>
                  <span class="info-box-text">Caixa</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-info">
               <span class="info-box-icon bg-white text-info"><i class="ti-layout-media-center"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">41</span>
                  <span class="info-box-text">Em aberto</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <!-- fix for small devices only -->
         <div class="clearfix visible-sm-block"></div>
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-purple">
               <span class="info-box-icon bg-white text-purple"><i class="ti-calendar"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">760</span>
                  <span class="info-box-text">Bilhetes hoje</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
         <div class="col-xl-3 col-md-6 col-12">
            <div class="info-box bg-inverse">
               <span class="info-box-icon bg-white text-warning"><i class="ti-star"></i></span>
               <div class="info-box-content">
                  <span class="info-box-number">FULANO DE TAL</span>
                  <span class="info-box-text">Melhor vendedor (semana)</span>
               </div>
               <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
         </div>
         <!-- /.col -->
      </div>
      <div class="row">
         <div class="col-lg-6 col-12">
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Bilhetes vendidos</h3>
                  <div class="box-tools pull-right">
                     <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                     <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
               </div>
               <div class="box-body">
                  <ul class="list-inline text-right">
                     <li>
                        <h5><i class="fa fa-circle mr-5 text-info"></i>Pré-jogo</h5>
                     </li>
                     <li>
                        <h5><i class="fa fa-circle mr-5 text-danger"></i>Ao Vivo</h5>
                     </li>
                  </ul>
                  <div id="grafico-vendas-dashboard" style="height: 250px;"></div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
         <div class="col-lg-6 col-12">
            <!-- AREA CHART -->
            <div class="box">
               <div class="box-header with-border">
                  <h3 class="box-title">Usuários negativos</h3>
                  <div class="box-tools pull-right">
                     <a href="a" class="btn btn-default btn-sm" style=" margin-top: -2px; "><i class="fa fa-plus"></i> Ver todos</a>
                  </div>
               </div>
               <div class="box-body">
                  <div class="media-list media-list-hover media-list-divided">
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="#"><strong>Maryam Amiri</strong></a>
                              <time class="float-right"><a href="#" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><b class="text-danger">R$ -2.300,25</b></p>
                        </div>
                     </div>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="#"><strong>Sam Maick</strong></a>
                              <time class="float-right"><a href="#" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><b class="text-danger">R$ -2.300,25</b></p>
                        </div>
                     </div>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="#"><strong>Ashley Hank</strong></a>
                              <time class="float-right"><a href="#" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><b class="text-danger">R$ -2.300,25</b></p>
                        </div>
                     </div>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="#"><strong>Frank Camly</strong></a>
                              <time class="float-right"><a href="#" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><b class="text-danger">R$ -2.300,25</b></p>
                        </div>
                     </div>
                     <div class="media">
                        <div class="media-body">
                           <p>
                              <a class="hover-primary" href="#"><strong>Frank Camly</strong></a>
                              <time class="float-right"><a href="#" class="btn btn-xs btn-danger">Ver Caixa</a></time>
                           </p>
                           <p><b class="text-danger">R$ -2.300,25</b></p>
                        </div>
                     </div>
                  </div>
               </div>
               <!-- /.box-body -->
            </div>
            <!-- /.box -->
         </div>
      </div>
      <!-- /.row -->
      <div class="row">
         <div class="col-md-6 col-lg-4">
            <div class="box box-body bg-brown">
               <div class="flexbox">
                  <div id="a"><i class="fa fa-futbol-o" style=" font-size: 45px; "></i></div>
                  <div class="text-right">
                     <span>Jogos disponíveis (Futebol)</span><br>
                     <span>
                     <i class="ion-ios-arrow-up text-warning"></i>
                     <span class="font-size-18 ml-1">813</span>
                     </span>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-6 col-lg-4">
            <div class="box box-body bg-brown">
               <div class="flexbox">
                  <div id="a"><i class="fa fa-users" style=" font-size: 45px; "></i></div>
                  <div class="text-right">
                     <span>Colaboradores</span><br>
                     <span>
                     <i class="ion-ios-arrow-up text-white"></i>
                     <span class="font-size-18 ml-1">80</span>
                     </span>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-6 col-lg-4 d-none d-lg-block">
            <div class="box box-body bg-brown">
               <div class="flexbox">
                  <div id="a"><i class="fa fa-star" style=" font-size: 45px; "></i></div>
                  <div class="text-right">
                     <span>Jogo mais apostado</span><br>
                     <span>
                     <i class="ion-ios-arrow-up text-white"></i>
                     <span class="font-size-18 ml-1">Fulano x Cicrano</span>
                     </span>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
      <div class="row">
         <div class="col-xl-7 col-12">
            <!-- quick email widget -->
            <div class="box">
               <div class="box-header">
                  <i class="fa fa-envelope"></i>
                  <h3 class="box-title">Fale com o FBET</h3>
                  <!-- tools box -->
                  <div class="pull-right box-tools">
                     Respostas entre 15 minutos e 24 horas.
                  </div>
                  <!-- /. tools -->
               </div>
               <div class="box-body">
                  <form action="#" method="post">
                     <div class="form-group">
                        <input type="text" class="form-control" name="telmail" placeholder="Telefone ou E-mail">
                     </div>
                     <div class="form-group">
                        <input type="text" class="form-control" name="subject" placeholder="Assunto">
                     </div>
                     <div>
                        <textarea class="textarea b-1 p-10 w-p100" placeholder="Sua mensagem..."></textarea>
                     </div>
                  </form>
               </div>
               <div class="box-footer clearfix">
                  <button type="button" class="pull-right btn btn-blue" id="sendEmail"> Enviar &nbsp; <i class="fa fa-paper-plane-o"></i></button>
               </div>
            </div>
         </div>
         <div class="col-xl-5 col-12">
            <div class="box">
               <div class="card-body py-60 bg-dark" data-overlay="5">
                  <blockquote class="blockquote blockquote-inverse no-border no-margin">
                     <center>
                        <p class="font-size-22" style=" font-size: 30px; font-weight: bold; ">AVISOS FBET</p>
                        <footer>Atenção a esta área! Notificaremos sempre que houver algo importante.</footer>
                     </center>
                  </blockquote>
               </div>
               <div class="box-body">
                  <!-- h4>Informações sobre jogos</h4>
                     <p>30/07 15:52:57</p>

                     <p>Holisticly maximize team building ROI via next-generation resources. Enthusiastically promote team driven customer service and error-free solutions.</p -->
                  <center>
                     <p>Nenhum aviso no momento</p>
                  </center>
               </div>
            </div>
            <div class="box">
               <div class="box-header">
                  <h4 class="box-title">Tráfego do Sistema</h4>
                  <div class="box-tool pull-right">
                     <small class="mt-10 text-success"><i class="fa fa-sort-asc"></i> Referente a <?php echo date('d/m/Y'); ?></small>
                  </div>
               </div>
               <div class="box-body">
                  <ul class="flexbox flex-justified text-center my-20">
                     <li class="br-1">
                        <div class="font-size-18">80</div>
                        <small>Logins no sistema</small>
                     </li>
                     <li class="br-1">
                        <div class="font-size-18">15</div>
                        <small>Colaboradores</small>
                     </li>
                     <li>
                        <div class="font-size-18">568</div>
                        <small>Acessos ao simulador</small>
                     </li>
                  </ul>
                  <div id="sparkline8">
                     <canvas width="484" height="60" style="display: inline-block; width: 484px; height: 60px; vertical-align: top;"></canvas>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script>
   $(function(){
      $(document).ready(function(){
         Morris.Area({
              element: 'grafico-vendas-dashboard',
              data: [{
                  period: '30/07',
                  PreJogo: 55,
                  AoVivo: 205,
              }, {
                  period: '31/07',
                  PreJogo: 130,
                  AoVivo: 100,
              }, {
                  period: '01/08',
                  PreJogo: 80,
                  AoVivo: 60,
              }, {
                  period: '02/08',
                  PreJogo: 70,
                  AoVivo: 200,
              }, {
                  period: '03/08',
                  PreJogo: 180,
                  AoVivo: 150,
              }, {
                  period: '04/08',
                  PreJogo: 105,
                  AoVivo: 90,
              },
               {
                  period: '05/08',
                  PreJogo: 250,
                  AoVivo: 150,
              }],
              xkey: 'period',
              parseTime: false,
              ykeys: ['PreJogo', 'AoVivo'],
              labels: ['Pré-Jogo', 'Ao Vivo'],
              pointSize: 0,
              fillOpacity: 0.9,
              pointStrokeColors:['#b4becb', '#01c0c8'],
              behaveLikeLine: true,
              gridLineColor: '#e0e0e0',
              lineWidth: 0,
              smooth: false,
              hideHover: 'auto',
              lineColors: ['#398bf7', '#f96868'],
              resize: true
          });
      });
   });
</script>