<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/historico.php';
   requerPermissao('28');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Histórico de Alterações
         <small>Históricos</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Histórico</strong></h4>
                  <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <form action="" style="max-width: 300px;">
                           <center><b>Filtrar datas</b></center>
                          <div class="input-group">
                            <input type="text" name="date" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="De" value="<?php echo $api['date']; ?>">
                            <span class="input-group-addon">&nbsp; até &nbsp;</span>
                            <input type="text" name="enddate" class="form-control pull-right" id="datepicker" autocomplete="off" placeholder="Até" value="<?php echo $api['enddate']; ?>">
                          </div>
                          <button type="submit" class="btn btn-info btn-md btn-block"><i class="fa fa-search"></i> &nbsp; Aplicar</button><br />
                        </form>

                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th width="200">Data</th>
                                 <th>Título</th>
                                 <th width="200">Tipo</th>
                                 <th width="200">Usuário</th>
                                 <th width="200">Feito por</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 $aux = 1;
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['history'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $aux; ?></td>
                                 <td align="center"><?php echo ($v["date"]); ?></td>
                                 <td><?php echo ($v["title"]); ?></td>
                                 <td align="center"><span class="badge badge-dark"><?php echo ($v["type"]); ?></span></td>
                                 <td align="center"><b><?php echo ($v["affected_user"]); ?></b></td>
                                 <td align="center"><b><?php echo ($v["admin"]); ?></b></td>
                              </tr>
                              <?php $aux++; } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

         $('[id="secondaryBlock"]').click(function(){
            var u = $(this).attr('data-usuario');
            $('.btnStatusUser'+u).click();
         });

         $('[id="changeSaldo"]').click(function(){
            var btn = $(this);
            btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-spinner fa-spin');
            var user = btn.attr('data-usuario');
            var balance = $('#saldo-'+user).val();

            $.get('/api/changeBalance?user='+user+'&balance='+balance, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
               }
               else if(info.success != undefined){
                  btn.toggleClass('btn-info btn-success').find('i').attr('class', 'fa fa-check');
                  $('#saldo-'+user).css('background', '#14b56f47');


                  $.toast({
                     heading: 'Pronto!',
                     text: 'O crédito foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                  });
               }
            });
         });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var user = btn.attr('data-usuario');

            $.get('/api/changeStatus?user='+user, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.user_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script>