<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/graficos.php';
   requerPermissao('10');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Gráficos
         <small>Gerenciamento de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Gráficos</strong></h4>
                  <a href="javascript:print();" class="btn btn-warning btn-md pull-right"><i class="fa fa-print"></i> &nbsp; Imprimir</a>
               </div>
            </div>
         </div>
        <div class="col-12 col-md-6 col-lg-6">
          <form action="">
            <div class="input-group">
              <input type="text" name="date" class="form-control pull-right" id="datepicker" placeholder="De" value="<?php echo $api['date']; ?>">
              <span class="input-group-addon">&nbsp; até &nbsp;</span>
              <input type="text" name="enddate" class="form-control pull-right" id="datepicker" placeholder="Até" value="<?php echo $api['enddate']; ?>">
            </div>
            <button type="submit" class="btn btn-info btn-md btn-block"><i class="fa fa-search"></i> &nbsp; Aplicar</button><br />
          </form>
        </div>
        <div class="col-12 col-md-6 col-lg-6"><center><blockquote class="blockquote custom_blockquote">
              <b><?php echo $api['dates']; ?></b>
            </blockquote></center></div>

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Bilhetes por tipo</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                <canvas id="graph1"></canvas>
              </div>
           </div>
        </div>
        <!-- CHART -->

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Bilhetes por dia</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                <canvas id="graph2"></canvas>
              </div>
           </div>
        </div>
        <!-- CHART -->

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Vendas (R$) por dia</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                <canvas id="graph3"></canvas>
              </div>
           </div>
        </div>
        <!-- CHART -->

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Melhores vendedores</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                <canvas id="graph4"></canvas>
              </div>
           </div>
        </div>
        <!-- CHART -->

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Cancelamentos de bilhetes</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                <canvas id="graph5"></canvas>
              </div>
           </div>
        </div>
        <!-- CHART -->

        <!-- CHART -->
        <div class="col-md-6 col-lg-6">
           <div class="box">
              <div class="box-header with-border">
                 <h5 class="box-title">Bilhetes por status</h5>
                 <div class="box-tools pull-right">
                    <ul class="card-controls">
                       <li><a href="" class="link card-btn-reload" data-toggle="tooltip" title="" data-original-title="Atualuzar"><i class="fa fa-refresh"></i></a></li>
                    </ul>
                 </div>
              </div>
              <div class="box-body">
                 <div class="text-center py-20">
                    <div class="donut" data-peity='{ "fill": ["#4CAF52", "#f44336", "#293b44"], "radius": 80, "innerRadius": 60  }' ><?php echo $api['status']['2'].','.$api['status']['3'].','.$api['status']['4']; ?></div>
                 </div>
                 <ul class="flexbox flex-justified text-center mt-30">
                    <li class="br-1">
                       <div class="font-size-20 text-success"><?php echo $api['status']['2']; ?></div>
                       <small>Ganhos</small>
                    </li>
                    <li class="br-1">
                       <div class="font-size-20 text-danger"><?php echo $api['status']['3']; ?></div>
                       <small>Perdidos</small>
                    </li>
                    <li>
                       <div class="font-size-20"><?php echo $api['status']['4']; ?></div>
                       <small>Cancelados</small>
                    </li>
                 </ul>
              </div>
           </div>
        </div>
        <!-- CHART -->
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script src="/assets/vendor_plugins/input-mask/jquery.inputmask.js"></script>
<script src="/assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- easypiechart -->
<script src="/assets/vendor_components/easypiechart/dist/jquery.easypiechart.js"></script>
<!-- chart-widgets -->
<script src="/js/pages/chart-widgets.js"></script>

<!-- ChartJS -->
<script src="/assets/vendor_components/chart.js-master/Chart.min.js"></script>

<script>

    var randomScalingFactor = function() {
      return Math.round(Math.random() * 100);
    };

    var config1 = {
      type: 'line',
      data: {
        labels: ['<?php echo join("', '", array_keys($api['charts'])); ?>'],
        datasets: [{
          label: 'Pré-jogo',
          fill: false,
          backgroundColor: '#03a9f4',
          borderColor: '#03a9f4',
          data: [
            <?php foreach ($api['charts'] as $d => $v) { echo $v['prematch'].', '; } ?>
          ]
        }, {
          label: 'Ao vivo',
          fill: false,
          backgroundColor: '#f84c5e',
          borderColor: '#f84c5e',
          data: [
            <?php foreach ($api['charts'] as $d => $v) { echo $v['live'].', '; } ?>
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          text: 'Quantidade de bilhetes divididos entre pré-jogo e ao vivo.'
        },
      }
    };

    var config2 = {
      type: 'line',
      data: {
        labels: ['<?php echo join("', '", array_keys($api['charts'])); ?>'],
        datasets: [{
          label: 'Bilhetes vendidos',
          fill: false,
          backgroundColor: '#f84c5e',
          borderColor: '#f84c5e',
          data: [
            <?php foreach ($api['charts'] as $d => $v) { echo $v['qtd'].', '; } ?>
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          text: 'Quantidade de bilhetes separados por dia'
        },
      }
    };

    var config3 = {
      type: 'line',
      data: {
        labels: ['<?php echo join("', '", array_keys($api['charts'])); ?>'],
        datasets: [{
          label: 'Valor vendido R$',
          fill: false,
          backgroundColor: '#4caf50',
          borderColor: '#4caf50',
          data: [
            <?php foreach ($api['charts'] as $d => $v) { echo $v['sells'].', '; } ?>
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          text: 'Vendas (R$) separados por dia',
          // scaleLabel: function(label){return  '$' + label.value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");}
        },
      }
    };

    var config4 = {
      type: 'bar',
      data: {
        labels: [
          <?php foreach ($api['sellers'] as $k => $n) { echo "'".$n["name"]."', "; } ?>
        ],
        datasets: [{
          label: 'Bilhetes',
          fill: false,
          backgroundColor: '#ff5722',
          borderColor: '#ff5722',
          data: [
            <?php foreach ($api['sellers'] as $d => $v) { echo $v['qtd'].', '; } ?>
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          text: 'Melhores vendedores'
        },
      }
    };

    var config5 = {
      type: 'line',
      data: {
        labels: ['<?php echo join("', '", array_keys($api['charts'])); ?>'],
        datasets: [{
          label: 'Cancelados',
          fill: 'start',
          backgroundColor: 'rgba(247, 79, 29, 0.74)',
          borderColor: '#e24010',
          data: [
            <?php foreach ($api['charts'] as $d => $v) { echo $v['cancelled'].', '; } ?>
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          text: 'Cancelamentos por dia'
        },
      }
    };

    window.onload = function() {
      // CHART1
      var ctx = document.getElementById('graph1').getContext('2d');
      window.myLine = new Chart(ctx, config1);

      // CHART2
      var ctx = document.getElementById('graph2').getContext('2d');
      window.myLine = new Chart(ctx, config2);

      // CHART3
      var ctx = document.getElementById('graph3').getContext('2d');
      window.myLine = new Chart(ctx, config3);

      // CHART4
      var ctx = document.getElementById('graph4').getContext('2d');
      window.myLine = new Chart(ctx, config4);

      // CHART5
      var ctx = document.getElementById('graph5').getContext('2d');
      window.myLine = new Chart(ctx, config5);
    };
</script>