<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/analise-de-risco.php';
   requerPermissao('9');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Análise de Risco
         <small>Gerenciamento de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Análise de Risco</strong></h4>
                  <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i></a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Partidas</th>
                                 <th width="120">Qtd.</th>
                                 <th width="120">Valor</th>
                                 <th width="120">Retorno</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                $i = 1;
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="6" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['combos'] as $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td>
                                  <?php
                                    foreach ($v['matches'] as $m) {
                                      echo '<p><b class="'; if($m['win'] == '1'){ echo 'text-green'; } echo '""><i class="fa fa-caret-right"></i> &nbsp; '.$m['name'].' <span class="pull-right">'.$m['market'].' ('.$m['option'].')</span></b></p>';
                                    }
                                  ?>
                                  <div style="display: none;" id="bilhetesCombo<?php echo $i; ?>">
                                    <?php foreach ($v['coupons'] as $cp) { echo '<a class="btn btn-sm bg-warning" href="/bilhetes/conferir?code='.$cp.'" target="_blank">'.$cp.'</a> &nbsp;'; } ?>
                                  </div>
                                </td>
                                 <td align="center">
                                  <a class="btn btn-sm bg-navy" onClick="openComboCoupons('<?php echo $i; ?>');"><?php echo $v["qtd"]; ?></a>
                                 </td>
                                 <td align="center"><b class="text-green">R$<?php echo $v["price"]; ?></b></td>
                                 <td align="center"><b class="text-red">R$<?php echo $v["return"]; ?></b></td>
                              </tr>
                              <?php $i++; } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script>
  function openComboCoupons(e){
    var el = document.getElementById('bilhetesCombo'+e);
    if(el.style.display == 'block'){ el.style.display = 'none'; }
    else { { el.style.display = 'block'; } }
  }
</script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>