<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/conferir-bilhete.php';
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Conferir Bilhete
         <small>Bilhetes</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-lg-4 col-md-4 col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Código do bilhete</strong></h4>
                  <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <form id="pinForm" method="GET" action="">
                        <label for="" class="block">
                        Informe o código:
                        <input value="<?php echo $_GET['code']; ?>" type="text" class="form-control" name="code" placeholder="Código..." />
                        </label>
                        <div class="row">
                           <div class="col-12">
                              <button class="btn btn-success btn-md pull-right"><i class="fa fa-search"></i> &nbsp; Pesquisar</button>
                           </div>
                        </div>
                     </form>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-lg-8 col-md-8 col-12">
            <div class="box box-solid bg-warning">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">#<?php if(isset($_GET["code"])){ echo $_GET["code"]; } ?></strong></h4>

                  <?php if(isset($_SESSION["usuario"])){ ?>
                  <a href="/bilhetes/cancelar/<?php if(isset($_GET["code"])){ echo $_GET["code"]; } ?>" target="framePrint" class="btn bg-danger btn-md pull-right" id=""><i class="fa fa-ban"></i> &nbsp; Cancelar</a>
                  <a href="/imprimir/<?php if(isset($_GET["code"])){ echo $_GET["code"]; } ?>" target="framePrint" class="btn bg-info btn-md pull-right" id=""><i class="fa fa-print"></i> &nbsp; Imprimir</a>
                  <a href="/bilhetes/atualizar/<?php if(isset($_GET["code"])){ echo $_GET["code"]; } ?>" class="btn btn-tumblr btn-md pull-right" id=""><i class="fa fa-refresh"></i> &nbsp; Atualizar</a>
                  <a href="/bilhetes/recorrigir/<?php if(isset($_GET["code"])){ echo $_GET["code"]; } ?>" class="btn btn-facebook btn-md pull-right" id="">Recorrigir</a>
                  <?php } ?>
               </div>
               <div class="box-content">
                  <div class="box-body" id="loadingData">
                     <?php if(isset($_GET["code"])){ ?>
                     <!-- ################################### BILHETE ################################### -->
                     <div class="print_area">
                        <h2 class="center"><?php echo utf8_encode($_SESSION["configs"]["config_nome"]); ?></h2>
                        <div class="tel center f14">TEL.: <?php echo exibirTelImpressao($_SESSION["configs"]["config_tel_impressao"], $_SESSION["configs"]["config_telefone"], $cupom["cupom_usuario"], $users); ?></div>
                        <div class="dashed dashed10"></div>
                        <div class="f14"><b>Data: </b> <span class="pull-right"><?php echo desfazDatetime($cupom["cupom_data"]); ?></span></div>
                        <div class="f14"><b>Vendedor: </b> <span class="pull-right"><?php echo $users[$cupom["cupom_usuario"]]['nome']; ?></span></div>
                        <div class="f14"><b>Cliente: </b> <span class="pull-right"><?php echo utf8_encode($cupom["cupom_cliente"]); ?></span></div>
                        <div class="dashed dashed10"></div>
                        <?php
                           switch ($cupom["cupom_situacao"]) {
                              case '1':
                                 if($cupom["cupom_parcial"] == '1'){
                                    echo '<a class="btn btn-lg btn-block bg-cyan">Process. Parcial</a>';
                                 } else {
                                    echo '<a class="btn btn-lg btn-block btn-info">Aberto</a>';
                                 }
                                 break;

                              case '2':
                                 echo '<a class="btn btn-lg btn-block btn-success">Ganhou</a>';
                                 break;

                              case '3':
                                 echo '<a class="btn btn-lg btn-block btn-danger">Perdeu</a>';
                                 break;

                              case '4':
                                 echo '<a class="btn btn-lg btn-block bg-navy">Cancelado</a>';
                                 break;

                              default:
                                 echo '<a class="btn btn-lg btn-block btn-warning">Indefinido</a>';
                                 break;
                           }
                        ?>
                        <div class="dashed dashed10"></div>
                        <h4 class="center margin0">SUAS SELEÇÕES</h4>
                        <div class="dashed dashed10"></div>

                        <?php
                           $campeonato_exibido = '';
                           $cotacao_total = 0;

                           while($a = $sql->fetch_assoc()){
                              if(utf8_encode($a["aposta_campeonato"]) <> $campeonato_exibido){
                                 echo '<div class="event f16 center">'.utf8_encode($a["aposta_campeonato"]).'</div>';
                                 $campeonato_exibido = utf8_encode($a["aposta_campeonato"]);
                              }

                              // Adiciona cotação
                              if($cotacao_total == 0){ $cotacao_total = $a["aposta_cotacao"]; }
                              else { $cotacao_total *= $a["aposta_cotacao"]; }
                        ?>
                        <div class="item">
                           <b><?php echo utf8_encode($a["aposta_jogo_nome"]); ?></b>
                           <div><?php echo desfazDatetime($a["aposta_data_jogo"]); ?></div>
                           <div><?php echo utf8_encode($a["aposta_mercado"]); ?></div>
                           <div><b><?php echo utf8_encode($a["aposta_opcao"]); ?></b> <span class="pull-right"><b><?php echo ($a["aposta_cotacao"]); ?></b></span></div>
                           <div><b>Status</b> <span class="pull-right"><b>
                              <?php
                                 switch ($a["aposta_status"]) {
                                    case '1':
                                       echo '<span class="badge badge-info">Aberto</span>';
                                       break;

                                    case '2':
                                       echo '<span class="badge badge-success">Ganhou</span>';
                                       break;

                                    case '3':
                                       echo '<span class="badge badge-danger">Perdeu</span>';
                                       break;

                                    case '4':
                                       echo '<span class="badge bg-navy">Cancelado</span>';
                                       break;

                                    default:
                                       echo '<span class="badge badge-warning">Indefinido</span>';
                                       break;
                                 }
                              ?>
                           </b></span></div>
                           <div class="dashed"></div>
                        </div>
                        <?php
                           }

                           // Multiplicador máximo
                           if($cotacao_total > $_SESSION['configs']['config_multiplicador']){ $cotacao_total = $_SESSION['configs']['config_multiplicador']; }
                           $retorno = $cupom["cupom_valor"] * $cotacao_total;
                           if($retorno > $_SESSION['configs']['config_max_ganhos_reais']){ $retorno = $_SESSION['configs']['config_max_ganhos_reais']; }
                        ?>

                        <div class="f14"><b>Valor: </b> <span class="pull-right">R$<?php echo formataReal($cupom["cupom_valor"]); ?></span></div>
                        <div class="f14"><b>Cotação: </b> <span class="pull-right"><?php echo number_format($cotacao_total, 2); ?></span></div>
                        <div class="f14"><b>Poss. Retorno: </b> <span class="pull-right"><?php if($cupom["cupom_situacao"] <> '2'){ echo 'R$'.formataReal($retorno); } else { echo '<span class="badge badge-success">R$'.formataReal($cupom["cupom_saidas"]).'</span>'; } ?></span></div>
                        <div class="dashed"></div>
                        <div class="center f13">BILHETE</div>
                        <h2 class="center"><?php echo strtoupper($cupom["cupom_codigo"]); ?></h2>
                        <div class="dashed"></div>
                        <p><?php echo utf8_encode($_SESSION["configs"]["config_bilhete_rodape"]); ?></p>
                     </div>
                     <!-- ################################### /BILHETE ################################## -->
                     <?php } else { echo '<center>Informe o código do bilhete no campo ao lado.</center>'; } ?>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<iframe src="" frameborder="0" id="framePrint" name="framePrint" height="0"></iframe>