<?php 
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php'; 
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php'; 
   requerPermissao('34'); // Atualizar bilhetes
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/conferir-bilhete.php'; 
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Atualizar bilhete
         <small>Bilhetes</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-lg-4 col-md-4 col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Sobre o bilhete</strong></h4>
               </div>
               <div class="box-content">
                  <div class="box-body">
                    <div class="table-responsive">
                      <table class="table">
                        <tbody>
                          <tr>
                            <td scope="row">Código</td>
                            <td align="right"><b><?php echo ($cupom["cupom_codigo"]); ?></b></td>
                          </tr>
                          <tr>
                            <td scope="row">Valor</td>
                            <td align="right"><b>R$<?php echo formataReal($cupom["cupom_valor"]); ?></b></td>
                          </tr>
                          <tr>
                            <td scope="row">Possível Retorno</td>
                            <td align="right"><b>R$<?php echo formataReal($cupom["cupom_retorno"]); ?></b></td>
                          </tr>
                          <tr>
                            <td scope="row">Jogos</td>
                            <td align="right"><b><?php echo ($cupom["cupom_jogos"]); ?></b></td>
                          </tr>
                          <tr>
                            <td scope="row">Status</td>
                            <td align="right">
                              <?php
                                 switch ($cupom["cupom_situacao"]) {
                                    case '1':
                                       echo '<span class="badge badge-info">Aberto</span>';
                                       break;
                                    
                                    case '2':
                                       echo '<span class="badge badge-success">Ganhou</span>';
                                       break;
                                    
                                    case '3':
                                       echo '<span class="badge badge-danger">Perdeu</span>';
                                       break;
                                    
                                    case '4':
                                       echo '<span class="badge bg-navy">Cancelado</span>';
                                       break;
                                    
                                    default:
                                       echo '<span class="badge badge-warning">Indefinido</span>';
                                       break;
                                 }
                              ?>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-lg-8 col-md-8 col-12">
            <form id="finishBetForm" action="/bilhetes/salvar-atualizacao" method="POST">
               <div class="box box-solid bg-warning">
                  <div class="box-header">
                     <h4 class="box-title"><strong class="event-strong">Atualizar bilhete</strong></h4>
                     <button type="submit" class="btn bg-success btn-md pull-right" id="finishBet"><i class="fa fa-check"></i> &nbsp; Salvar</button>
                  </div>
                  <div class="box-content">
                     <div class="box-body" id="">
                        <center>
                           <blockquote>Jogos do bilhete</blockquote>
                        </center>
                        <input type="hidden" name="code" value="<?php echo $cupom['cupom_codigo']; ?>" />
                        <?php while($a = $sql->fetch_assoc()){  ?>
                        <div class="media-list media-list-hover media-list-divided">
                           <div class="media">
                              <div class="media-body">
                                 <p>
                                    <h4><?php echo utf8_encode($a["aposta_jogo_nome"]); ?></h4>
                                    <strong><?php echo desfazDatetime($a["aposta_data_jogo"]); ?></strong>
                                    <time class="float-right">
                                      <select name="opcoes[<?php echo ($a["aposta_opcao_id"]); ?>]" class="form-control selectAtualizarJogos" id="">
                                        <option value="">Selecione</option>
                                        <option <?php if($a["aposta_status"] == '1'){ echo 'selected'; } ?> value="1">Em aberto</option>
                                        <option <?php if($a["aposta_status"] == '2'){ echo 'selected'; } ?> value="2">Ganhou</option>
                                        <option <?php if($a["aposta_status"] == '3'){ echo 'selected'; } ?> value="3">Perdeu</option>
                                        <option <?php if($a["aposta_status"] == '4'){ echo 'selected'; } ?> value="4">Cancelado</option>
                                      </select>
                                    </time>
                                 </p>
                              </div>
                           </div>
                        </div>
                        <?php } ?>
                     </div>
                  </div>
               </div>
            </form>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/jquery/dist/jquery.min.js"></script>
<!-- popper -->

<script>

   $(function(){
      $(document).ready(function(){
         $('[id="finishBet"]').click(function(){
           var btn = $(this);
           btn.html('<i class="fa fa-spinner fa-spin" style="margin-right: 5px;"></i> Finalizando').removeClass('bg-success').addClass('btn-info');
         });
      });
   });
</script>