<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Atualizar Sistema
         <small>Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
           <div class="col-lg-12 col-12">
              <div class="box box-solid bg-black">
                 <div class="box-header">
                    <h4 class="box-title"><strong class="event-strong">Atualização de Sistema</strong></h4>
                    <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
                 </div>
                 <div class="box-content">
                    <div class="box-body">
                      <div class="row">
                        <div class="col-12"><blockquote class="blockquote" style=" margin: 15px 0; ">Atualizações disponíveis</blockquote></div>
                        <div class="col-12">
                          <div class="table-responsive">
                             <table class="table table-striped">
                                <tbody>
                                   <tr>
                                      <th>Versão</th>
                                      <th>Mudanças</th>
                                      <th>Data</th>
                                      <th style="width: 40px">Atualizar</th>
                                   </tr>
                                   <?php
                                    $xml = simplexml_load_file('http://www.sysfbet.com.br/updates/fbet/versions.xml');
                                    foreach ($xml as $v) {
                                      if((string)$v->attributes()->version < $cfg["config_versao"]){ continue; }
                                  ?>
                                   <tr>
                                      <td align="center"><?php echo (string)$v->attributes()->version; if((string)$v->attributes()->version == $cfg["config_versao"]){ echo '&nbsp; &nbsp; <span class="badge badge-success">Atual</span>'; } ?></td>
                                      <td align="center"><p class="help-block"><small><?php echo (string)$v->attributes()->changes; ?></small></p></td>
                                      <td align="center"><?php echo desfazDatetime((string)$v->attributes()->date); ?></td>
                                      <td align="center"><a id="updateBtn" class="btn btn-sm btn-warning <?php if((string)$v->attributes()->version == $cfg["config_versao"]){ echo 'disabled'; } ?>" data-v="<?php echo (string)$v->attributes()->version; ?>"><i class="fa fa-retweet"></i> &nbsp; Atualizar</a></td>
                                   </tr>
                                   <?php } ?>
                                </tbody>
                             </table>
                          </div>
                        </div>
                      </div>
                    </div>
                 </div>
                 <div class="box-footer">
                    <center><b style="color: #000; font-size: 18px;">Mantenha sempre seu sistema atualizado.</b></center>
                 </div>
              </div>
           </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script>

    $(function(){
      $(document).ready(function(){
          $('[id="updateBtn"]').click(function(){
              $(this).toggleClass('btn-warning btn-info').html('<i class="fa fa-spinner fa-spin"></i> &nbsp; Processando');
              var version = $(this).attr('data-v');
              var btn = $(this);
              $.get('/iniciar-atualizacao?versao='+version+'&action=check', function(d){
                if(d != ''){ alert(d); btn.attr('class', 'btn btn-sm btn-warning').html('<i class="fa fa-retweet"></i> &nbsp; Atualizar'); return false; }
                btn.toggleClass('btn-dark btn-info').html('<i class="fa fa-spinner fa-spin"></i> &nbsp; Baixando');
                $.get('/iniciar-atualizacao?versao='+version+'&action=download', function(d){
                  btn.toggleClass('btn-dark bg-success').html('<i class="fa fa-spinner fa-spin"></i> &nbsp; Instalando');
                  $.get('/iniciar-atualizacao?versao='+version+'&action=install', function(d){
                    btn.toggleClass('bg-success bg-green').html('<i class="fa fa-check"></i> &nbsp; Atualizado');
                  });
                });
              });
          });
      });
    });
</script>