<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/jogos-manuais.php';
   requerPermissao('15');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Jogos Manuais
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Cadastrar um jogo</strong></h4>
                  <a href="javascript: history.back('-1');" class="btn btn-warning btn-md pull-right"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
               </div>
               <div class="box-content"><!-- form start -->
                  <form class="form-horizontal" method="POST" action="/administracao/jogos-manuais-salvar">
                     <div class="box-body">
                        <br />
                        <blockquote class="blockquote custom_blockquote">Informações do Jogo</blockquote>
                        <div class="form-group">
                           <label for="status" class="col-sm-2 control-label">Status</label>
                           <div class="col-sm-4">
                              <select name="status" class="form-control">
                                 <option value="1" selected>Disponível</option>
                                 <option value="0">Indisponível</option>
                              </select>
                           </div>
                        </div>
                        <div class="form-group">
                           <label for="esporte" class="col-sm-2 control-label">Esporte</label>
                           <div class="col-sm-4">
                              <select name="esporte" class="form-control">
                                 <option value="0" selected>Selecione</option>
                                 <?php
                                    $sql = $mysqli->query("SELECT esporte_id, esporte_nome FROM esportes");
                                    while($esp = $sql->fetch_assoc()){
                                      echo '<option '; if(utf8_encode($esp["esporte_nome"]) == 'Futebol'){ echo ' selected '; } echo ' value="'.(int)$esp["esporte_nome"].'">'.utf8_encode($esp["esporte_nome"]).'</option>';
                                    }
                                    ?>
                              </select>
                           </div>
                        </div>
                        <div class="form-group">
                           <label for="pais" class="label_documento col-sm-2 control-label">País</label>
                           <div class="col-sm-4">
                              <input type="text" class="form-control" name="pais" placeholder="Ex: Brasil">
                           </div>
                        </div>
                        <div class="form-group">
                           <label for="campeonato" class="label_documento col-sm-2 control-label">Campeonato</label>
                           <div class="col-sm-4">
                              <input type="text" class="form-control" name="campeonato" placeholder="Ex: Cearense">
                           </div>
                        </div>
                        <div class="form-group">
                           <label for="timecasa" class="label_documento col-sm-2 control-label">Partida</label>
                           <div class="col-sm-6">
                              <div class="input-group">
                                 <input type="text" class="form-control" name="timecasa" placeholder="Time da Casa">
                                 <span class="input-group-addon">X</span>
                                 <input type="text" class="form-control" name="timevisitante" placeholder="Time Visitante">
                              </div>
                           </div>
                        </div>
                        <div class="form-group">
                           <label for="pais" class="label_documento col-sm-2 control-label">Data do Jogo</label>
                           <div class="col-sm-4">
                              <input type="text" class="form-control date_time" id="datetime" name="data" placeholder="99/99/9999 99:99">
                              <p>* Horário de Brasília</p>
                           </div>
                        </div>
                        <br />
                        <blockquote class="blockquote custom_blockquote">Mercados e Cotações</blockquote>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label text-right">Vencedor</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Vencedor']['Casa']" placeholder="Casa">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Vencedor']['Empate']" placeholder="Empate">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Vencedor']['Visitante']" placeholder="Fora">
                           </div>
                        </div>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label text-right">Dupla possibilidade</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Dupla possibilidade']['Equipe 1 ou empate']" placeholder="Equipe 1 ou empate">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Dupla possibilidade']['Equipe 2 ou empate']" placeholder="Equipe 2 ou empate">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Dupla possibilidade']['Equipe 1 ou Equipe 2']" placeholder="Equipe 1 ou Equipe 2">
                           </div>
                        </div>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label text-right">Total de gols no jogo</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Total de gols no jogo']['Mais de 2.5']" placeholder="Mais de 2.5">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Total de gols no jogo']['Menos de 2.5']" placeholder="Menos de 2.5">
                           </div>
                        </div>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label text-right">Ambas equipes marcam</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Ambas equipes marcam']['Sim']" placeholder="Sim">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Ambas equipes marcam']['Não']" placeholder="Não">
                           </div>
                        </div>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label text-right">Handicap de Gol</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Handicap de Gol']['Casa -1']" placeholder="Casa -1">
                           </div>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              <input type="tel" onkeyup="send(event)" oninput="this.value = SimpleMaskMoney.format(this.value);" class="form-control" name="mercado['Handicap de Gol']['Fora -1']" placeholder="Fora -1">
                           </div>
                        </div>
                        <div class="form-group row">
                           <label for="nome" class="col-sm-2 control-label">Observação</label>
                           <div class="col-12 col-lg-3 col-md-3 col-sm-3">
                              Exemplo de ODD: 1.20 (com ponto)
                           </div>
                        </div>
                     </div>
                     <!-- /.box-body -->
                     <div class="box-footer">
                        <button type="reset" class="btn btn-lg btn-danger"><i class="fa fa-times"></i> &nbsp; Limpar Formulário</button>
                        <button type="submit" class="btn btn-lg btn-success pull-right"><i class="fa fa-check"></i> &nbsp; Cadastrar</button>
                     </div>
                     <!-- /.box-footer -->
                  </form>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<script src="/js/moneymask.js"></script>
<script src="/js/jquery.mask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: '.',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);

    }

    $(function(){
      $(document).ready(function(){
        $('.date').mask('00/00/0000');
        $('.time').mask('00:00:00');
        $('.date_time').mask('00/00/0000 00:00');
      });
    });
</script>