<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   requerPermissao('4');

   // Consulta a API
   $u = 0;
   if(isset($_GET["registro"])){ $u = (int)$_GET["registro"]; }
   $params['choices'] = 'false';
   $r = api('getMercados', $params);
   $data = json_decode($r, true);

   // Lista de usuarios
   $params = array();
   $params['markets'] = 1;
   $params['token'] = $_SESSION["usuario"]["api_token"];
   $usuarios = api('/listUsers', $params);
   $usuarios = json_decode($usuarios, true);
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Mercados
         <small>Administração</small>
      </h1>
      <a href="javascript:history.back('-1');" class="btn btn-danger btn-md pull-right" style="margin-top: -35px;"><i class="fa fa-reply"></i> &nbsp; Voltar</a>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-lg-4 col-md-4 col-12">
            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title">
                     <strong class="event-strong">Selecione um mercado</strong>
                  </h4>
                  <a class="btn bg-danger btn-md pull-right" data-toggle="modal" data-target="#limpar-tudo"><i class="fa fa-trash"></i> &nbsp; Limpar tudo</a>
               </div>
               <div class="box-content" id="listaMercados">
                  <input type="text" class="search form-control" placeholder="Pesquisar mercado..." />
                  <select name="usuario" id="" class="form-control" onchange="javascript:handleSelect(this)">
                     <option value="">Aplicar para todos</option>
                     <?php
                        $nome_usuario = '';
                        foreach ($usuarios["user_info"] as $k => $usuario) {
                           echo '<option '; if($usuario["id"] == $u){ $nome_usuario = 'para '.$usuario["name"]; echo ' selected '; } echo ' value="'.$usuario["id"].'">'.$usuario["name"].'</option>';
                        }
                     ?>
                  </select>

                  <div class="box-body list">

                     <?php foreach ($data as $r) { ?>
                     <div class="media-list media-list-hover media-list-divided fbet_list_mercados">
                        <a class="media media-single" href="#" id="viewMarket" data-market="<?php echo $r; ?>">
                        <span class="title"><?php echo $r; ?></span>
                        <span class="badge badge-pill bg-black"><i class="fa fa-caret-right"></i></span>
                        </a>
                     </div>
                     <?php } ?>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-lg-8 col-md-8 col-12">
            <form action="/ajax/mercados-salvar" id="sendMarket">
               <div class="box box-solid bg-warning">
                  <div class="box-header">
                     <h4 class="box-title"><strong class="event-strong" id="nome_mercado"></strong></h4>
                     <input type="hidden" value="" name="mercado_nome" />
                     <input type="hidden" value="<?php echo $u; ?>" name="usuario" />
                     <button type="submit" class="btn btn-success btn-md pull-right"><i class="fa fa-check"></i> &nbsp; Salvar <?php echo $nome_usuario; ?></button>
                  </div>
                  <div class="box-content">
                     <div class="box-body" id="mercadoInfo">
                        <center>
                           <blockquote>Alterações no mercado</blockquote>
                        </center>

                        <div class="media-list media-list-hover media-list-divided">
                           <div class="media">
                              <div class="media-body">
                                 <p>
                                    <a class="hover-primary" href="#"><strong>Ativo?</strong></a>
                                    <time class="float-right">
                                       <select name="mercado_ativo" class="form-control" id="">
                                          <option value="1">Ativo</option>
                                          <option value="0">Inativo</option>
                                       </select>
                                    </time>
                                 </p>
                              </div>
                           </div>
                           <div class="media">
                              <div class="media-body">
                                 <p>
                                    <a class="hover-primary" href="#"><strong>Alterar</strong></a>
                                    <time class="float-right">
                                       <select name="mercado_tipo" class="form-control" id="">
                                          <option value="">Selecione</option>
                                          <option value="1">+ Aumentar</option>
                                          <option value="0">- Diminuir</option>
                                       </select>
                                    </time>
                                 </p>
                              </div>
                           </div>
                           <div class="media">
                              <div class="media-body">
                                 <p>
                                    <a class="hover-primary" href="#"><strong>Porcentagem</strong></a>
                                    <time class="float-right">
                                 <div class="input-group" style="float: right; max-width: 100px; margin-top: -18px;">
                                 <input type="text" name="mercado_porcentagem" class="form-control" placeholder="Ex: 10" />
                                 <span class="input-group-addon">
                                 %
                                 </span>
                                 </div>
                                 </time>
                                 </p>
                              </div>
                           </div>
                        </div>
                        <center>
                           <blockquote>Alterações nas opções</blockquote>
                        </center>
                        <div class="media-list media-list-hover media-list-divided mercados-list" id="mercado_lista_opcoes">

                        </div>
                     </div>
                  </div>
               </div>
            </form>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>

<div class="modal modal-danger fade" id="limpar-tudo" style="display: none;" aria-hidden="true">
     <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
         <h4 class="modal-title">Tem certeza?</h4>
         <button type="button" class="close" data-dismiss="modal" aria-label="Close">
           <span aria-hidden="true">×</span></button>
        </div>
        <div class="modal-body">
         <p>Esta ação irá remover <b>todas as alterações</b> de mercados feitas no sistema, sejam elas gerais ou por usuários. Deseja confirmar a operação?</p>
        </div>
        <div class="modal-footer">
         <button type="button" class="btn bg-red" data-dismiss="modal">Cancelar</button>
         <a href="/administracao/mercados-limpar" class="btn bg-dark float-right"><i class="fa fa-trash"></i> &nbsp; Limpar</a>
        </div>
      </div>
      <!-- /.modal-content -->
     </div>
     <!-- /.modal-dialog -->
  </div>

<!-- DataTables -->
<script src="//cdnjs.cloudflare.com/ajax/libs/list.js/1.5.0/list.min.js"></script>
<script>
   function handleSelect(elm){
      if(elm.value == '' || elm.value == '0'){
         window.location = '/administracao/mercados';
      } else {
         window.location = '/administracao/mercados/'+elm.value;
      }
   }

   $(function(){
      $(document).ready(function(){
         var options = {
           valueNames: [ 'fbet_list_mercados', 'title' ]
         };

         var userList = new List('listaMercados', options);

         var spinner = '<div class="loadermodal"><center><img class="floader" src="/loaders/rings.svg" /> Carregando...</center></div>';
         var u = "<?php echo $u; ?>";
         $('[id="viewMarket"]').click(function(){
            $('#mercadoInfo').show();
            $('#mercado_lista_opcoes').html('');
            $('[name="mercado_porcentagem"]').val('');
            $('[name="mercado_tipo"]').val('');
            $('[name="mercado_ativo"]').val('');
            $('#msg').remove();

            var m = $(this).attr('data-market');
            $("html, body").animate({scrollTop: 0}, 1000);

            $('#mercadoInfo').append(spinner);
            $.post('/ajax/mercados-abrir', { mercado: m, usuario: u }, function(data){
               // $('#spinner').html(data);
               var r = JSON.parse(data);
               var aux = 0;
               var passouMercado = 0;

               $.each(r, function(i, item) {
                  if(item.opcao == ''){
                     if(item.ativo == '' || item.ativo == 'undefined'){ item.ativo = '1'; }
                     passouMercado = 1;
                     $('[name="mercado_porcentagem"]').val(item.porcentagem);
                     $('[name="mercado_tipo"]').val(item.tipo);
                     $('[name="mercado_ativo"]').val(item.ativo);
                  } else {
                     var ativo = item.ativo;
                     if(item.ativo == '1'){ ativo = '<span class="badge bg-green">ATIVO</span>'; }
                     else { ativo = '<span class="badge bg-danger">INATIVO</span>'; }

                     var modificado = item.tipo;
                     if(modificado == '0'){ modificado = '<b class="text-red">Diminuído em '+item.porcentagem+'%</b> |'; }
                     else if(modificado == '1'){ modificado = '<b class="text-green">Aumentado em '+item.porcentagem+'%</b> |'; }
                     else { modificado = ''; }

                     if(item.ativo == '1'){ var ativoInfo = '<option selected value="1">Ativo</option> <option value="0">Inativo</option>'; }
                     else { var ativoInfo = '<option value="1">Ativo</option> <option selected value="0">Inativo</option>'; }

                     if(item.tipo == '1'){ var tipoInfo = '<option selected value="1">Aumentar</option> <option value="0">Diminuir</option>'; }
                     else if(item.tipo == '0') { var tipoInfo = '<option value="1">Aumentar</option> <option selected value="0">Diminuir</option>'; }
                     else { var tipoInfo = '<option value="1">Aumentar</option> <option value="0">Diminuir</option>'; }

                     $('#mercado_lista_opcoes').append('<div class="media"> <div class="media-body"> <p> <a class="hover-primary" href="#"><strong>'+ativo+' &nbsp; '+item.opcao+'</strong></a> <time class="float-right"><a id="abrirConfig" data-op="'+aux+'" class="btn btn-sm btn-warning"><i class="fa fa-cogs"></i> &nbsp; Configurar</a></time> </p> <p>'+modificado+' Limite: <b>'+item.limite+'</b></p> <!-- Alteração --> <div class="row rowConfiguracaoOpcao" id="op'+aux+'"> <div class="col-lg-2 col-md-3 col-12"><select name="opcoes['+item.opcao+'][ativo]" class="form-control" id=""> '+ativoInfo+' </select> </div> <div class="col-lg-3 col-md-3 col-12"> <select name="opcoes['+item.opcao+'][tipo]" class="form-control" id=""> <option value="">Selecione</option> '+tipoInfo+' </select> </div> <div class="col-lg-3 col-md-3 col-12"> <div class="input-group"> <input type="text" name="opcoes['+item.opcao+'][porcentagem]" class="form-control" placeholder="Ex: 10" value="'+item.porcentagem+'"> <span class="input-group-addon"> % </span> </div> </div> <div class="col-lg-3 col-md-3 col-12"> <input type="text" name="opcoes['+item.opcao+'][limite]" class="form-control" placeholder="Limite" value="'+item.limite+'"> </div> </div> <!-- /Alteração --> </div> </div>'); aux = parseInt(aux) + parseInt(1);
                  }

                  $('#nome_mercado').html(item.mercado);
                  $('[name="mercado_nome"]').val(item.mercado);
               });

               if(passouMercado == '0'){ $('[name="mercado_ativo"]').val('1'); }
               $('.loadermodal').remove();

               $('[id="abrirConfig"]').click(function(){
                  $(this).toggleClass('bg-black btn-warning');
                  var o = $(this).attr('data-op');
                  $('#op'+o).slideToggle().css('display', 'flex');
               });
            });
         });



         $('#sendMarket').submit(function(){
            $('#msg').remove();
            var dados = $( this ).serialize();
            var form = $(this);
            var spinner = '<div class="loadermodal"><center><img class="floader" src="/loaders/rings.svg" /> Salvando...</center></div>';
            $('#mercadoInfo').append(spinner);

            $.ajax({
               type: "POST",
               url: form.attr('action'),
               data: dados,
               success: function( data )
               {
                  if(data == '1'){
                     $('#mercadoInfo').prepend('<div class="callout callout-success" id="msg"> <h4>Pronto!</h4> <p>As informações foram atualizadas com sucesso. <b>Lembre-se: esta alteração pode levar até 5 minutos para ser propagada por completo.</b></p> </div>');
                  } else {
                     $('#mercadoInfo').prepend('<div class="callout callout-danger" id="msg"> <h4>Ops!</h4> <p>'+data+'</p> </div>');
                  }
                  $('.loadermodal').remove();
               }
            });

            return false;
         });
      });
   });
</script>
<!-- popper -->
<script src="/assets/vendor_components/popper/dist/popper.min.js"></script>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<!-- script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script -->
<!-- script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script -->
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>