<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/jogos-manuais.php';
   requerPermissao('15');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Jogos Manuais
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Jogos Cadastrados</strong></h4>
                  <a href="/administracao/novo-jogo-manual" class="btn btn-warning btn-md pull-right"><i class="fa fa-plus"></i> &nbsp; Criar jogo</a>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">
                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Nome</th>
                                 <th width="80">Status</th>
                                 <th width="200">Cotações</th>
                                 <th width="200">Operações</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="5" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['matches'] as $i => $v) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><div><sup><?php echo strtoupper($v["sport"].' | '.$v["event"]); ?></sup></div><b><?php echo ($v["name"]); ?></b></div></td>
                                 <td align="center"><a id="changeStatus" data-id="<?php echo ($v['id']); ?>" class="btn btnStatusUser<?php echo ($v['id']); ?> btn-sm btn-<?php if($v['status'] == '1'){ echo 'success'; } else { echo 'danger'; } ?>" data-toggle="tooltip" data-placement="top" title="Ativar / Desativar"><?php if($v['status'] == '1'){ echo 'Ativo'; } else { echo 'Inativo'; } ?></a></td>
                                 <td align="center"><b class=""><?php echo $v["odds"]; ?></b></td>
                                 <td align="center">
                                  <a href="/administracao/editar-jogo-manual/<?php echo $v['id']; ?>" class="btn bg-warning btn-sm" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                  <a id="markOK" data-id="<?php echo $v['id']; ?>" class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="top" title="Excluir jogo"><i class="fa fa-times"></i></a>
                                 </td>
                              </tr>
                              <?php } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('[id="markOK"]').click(function(ev){
            var btn = $(this);
            var id = btn.attr('data-id');
            btn.html('<i class="fa fa-spinner fa-spin"></i>').toggleClass('btn-danger btn-info');
            $.get('/api/deleteManualMatch?match_id='+id, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-times"></i>').toggleClass('btn-danger btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){

                $.toast({
                  heading: 'Pronto!',
                  text: 'Registro apagado com sucesso.',
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

                location.reload();

              }
            });

            return false;
            ev.preventDefault();
        });

         $('[id="changeStatus"]').click(function(){
            var btn = $(this);
            var btn_content = btn.html();
            btn.toggleClass('btn-danger btn-success').html('<i class="fa fa-spinner fa-spin"></i>');
            var id = btn.attr('data-id');

            $.get('/api/changeStatusManualMatch?id='+id, function(data){
               var info = $.parseJSON(data);
               if(info.error != undefined){
                  alert(info.error);
                  btn.toggleClass('btn-info btn-success').html(btn_content);
               }
               else if(info.success != undefined){
                  if(info.match_status == '1'){
                     btn.html('Ativo');
                  } else {
                     btn.html('Inativo');
                  }

                 $.toast({
                     heading: 'Pronto!',
                     text: 'O status foi alterado com sucesso.',
                     position: 'top-right',
                     loaderBg: '#FFF',
                     icon: 'success',
                     hideAfter: 3500,
                     stack: 6
                 });

               }
            });
         });

      });
    });
</script>