<?php
   require $_SERVER["DOCUMENT_ROOT"].'/inc/topo.php';
   require $_SERVER["DOCUMENT_ROOT"].'/inc/menu.php';
   require $_SERVER["DOCUMENT_ROOT"].'/api/pages/atualizar-resultados.php';
   requerPermissao('33');
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <section class="content-header">
      <h1>
         Atualizar Resultados
         <small>Gestão de Banca</small>
      </h1>
   </section>
   <!-- Main content -->
   <section class="content">
      <div class="row">
         <div class="col-12">

            <div class="box box-solid bg-black">
               <div class="box-header">
                  <h4 class="box-title"><strong class="event-strong">Atualizar Resultados</strong></h4>
               </div>
               <div class="box-content">
                  <div class="box-body">
                     <div class="table-responsive">

                        <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                           <thead>
                              <tr>
                                 <th width="60">-</th>
                                 <th>Opção</th>
                                 <th width="80">Status</th>
                                 <th width="250">Operações</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                  $i = 1;
                                 if(isset($api["error"])){
                                    echo '<tr><td colspan="4" align="center"><div class="callout callout-danger"> <h4>OOPS!</h4> <p>'.$api["error"].'</p> </div></td></tr>';
                                 } else {
                                 foreach ($api['options'] as $mid => $v) {
                                    echo '<tr><td colspan="4" class="bg-dark"><b>'.$v['name'].'</b> - '.$v['date'].'</td></tr>';
                                    foreach ($v['bets'] as $mercado => $b) {
                                      echo '<tr><td colspan="4" class="bg-secondary"><b>'.$mercado.'</b></td></tr>';
                                      foreach ($b as $key => $bet) {
                              ?>
                              <tr>
                                 <td align="center"><?php echo $i; ?></td>
                                 <td><?php echo strtoupper($bet["name"]); ?></td>
                                 <td align="center"><span id="badge<?php echo $bet['id']; ?>" class="badge badge-warning">Aguardando Resultado</span></td>
                                 <td align="center">
                                  <a id="markOK" data-status="2" data-id="<?php echo $bet['id']; ?>" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="Ganhou"><i class="fa fa-check"></i></a>
                                  <a id="markOK" data-status="3" data-id="<?php echo $bet['id']; ?>" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="Perdeu"><i class="fa fa-times"></i></a>
                                  <a id="markOK" data-status="4" data-id="<?php echo $bet['id']; ?>" class="btn bg-navy" data-toggle="tooltip" data-placement="top" title="Cancelado"><i class="fa fa-ban"></i></a>
                                  <a id="markOK" data-status="1" data-id="<?php echo $bet['id']; ?>" class="btn btn-info" data-toggle="tooltip" data-placement="top" title="Aguardando Resultado"><i class="fa fa-circle"></i></a>
                                 </td>
                              </tr>
                              <?php $i++; } } } } ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </section>
   <!-- /.content -->
</div>
<div style=" position: fixed; bottom: 0; z-index: 10000; text-align: right; padding: 10px; right: 0; background: #fff; "><a url="/api/finishMatchesUpdate" class="btn btn-lg btn-success" id="finishUpdate"><i class="fa fa-check"></i> &nbsp; Finalizar Correção</a></div>
<!-- /.content-wrapper -->
<!-- ./wrapper -->
<?php require $_SERVER["DOCUMENT_ROOT"].'/inc/rodape.php'; ?>
<!-- DataTables -->
<script src="/assets/vendor_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/media/js/jquery.dataTables.min.js"></script>
<script src="/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script> $(function(){ $('[id="datepicker"]').datepicker({ autoclose: true, format: 'yyyy-mm-dd' }); }); </script>
<!-- start - This is for export functionality only -->
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/dataTables.buttons.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.flash.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/jszip.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/pdfmake.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/ex-js/vfs_fonts.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.html5.min.js"></script>
<script src="/assets/vendor_plugins/DataTables-1.10.15/extensions/Buttons/js/buttons.print.min.js"></script>
<!-- end - This is for export functionality only -->
<!-- Unique_Admin for Data Table -->
<script src="/js/pages/data-table.js"></script>
<script src="/js/moneymask.js"></script>
<script>
    let input = document.getElementsByTagName('input')[0];

    // configuration
    SimpleMaskMoney.args = {
        prefix: '',
        suffix: '',
        fixed: true,
        fractionDigits: 2,
        decimalSeparator: ',',
        thousandsSeparator: '.',
        autoCompleteDecimal: false
    };

    // Your send method
    send = (e) => {
        if (e.key !== "Enter") return;
        // This method return value of your input in format number to save in your database
        SimpleMaskMoney.formatToNumber(input.value);
    }

    $(function(){
      $(document).ready(function(){

        $('[id="markOK"]').click(function(ev){
            var btn = $(this);
            var id = $(this).attr('data-id');
            var status = $(this).attr('data-status');
            var url = '/api/saveSessionMatchesUpdate?id='+id+'&status='+status;
            $.get(url, function(d){
              var info = $.parseJSON(d);
              if(info.error != undefined){
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){
                if(status == '1'){ $('#badge'+id).attr('class', 'badge badge-warning').html('Aguardando Resultado'); }
                else if(status == '2'){ $('#badge'+id).attr('class', 'badge badge-success').html('Ganhou'); }
                else if(status == '3'){ $('#badge'+id).attr('class', 'badge badge-danger').html('Perdeu'); }
                else if(status == '4'){ $('#badge'+id).attr('class', 'badge bg-navy').html('Cancelado'); }
              }
            });

            return false;
            ev.preventDefault();
        });

        $('[id="finishUpdate"]').click(function(ev){
            var btn = $(this);
            var url = btn.attr('url');
            btn.html('<i class="fa fa-spinner fa-spin"></i> &nbsp; Processando').toggleClass('btn-success btn-info');
            $.get(url, function(d){
              console.log(d);
              var info = $.parseJSON(d);
              if(info.error != undefined){
                btn.html('<i class="fa fa-check"></i> &nbsp; Finalizar Correção').toggleClass('btn-success btn-info');
                $.toast({
                  heading: 'Erro!',
                  text: info.error,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'error',
                  hideAfter: 3500,
                  stack: 6
                });
              }
              else if(info.success != undefined){
                btn.toggleClass('btn-success btn-info').html('<i class="fa fa-check"></i> &nbsp; Finalizar Correção');

                $.toast({
                  heading: 'Pronto!',
                  text: info.success,
                  position: 'top-right',
                  loaderBg: '#FFF',
                  icon: 'success',
                  hideAfter: 3500,
                  stack: 6
                });

              }
            });

            return false;
            ev.preventDefault();
        });

      });
    });
</script>