<?php
  require '../../inc/conexao.php';
  require '../../inc/functions.php';
  ini_set('display_errors',1);
  ini_set('display_startup_erros',1);
  error_reporting(E_ALL);

  if(isset($_COOKIE["impressora"])){
    $COL_COUNT = (int)$_COOKIE["impressora"];
  }
  else {
    $COL_COUNT = 32;
  }

  $espacoTag = "&nbsp";
  $lineBreak = "<br/>";

  function SetColCount(){
      global $COL_COUNT;
      global $lineBreak;

      $temp = "";
      $temp = "!CC~" . $COL_COUNT . $lineBreak;
      return $temp;
  }

  function Centralizar($msg, $negrito, $sublinhado, $fonteMaior)
  {
      global $lineBreak;

      $temp = "";
      $temp = "!AC~" . $msg;

    if($negrito == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($sublinhado == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($fonteMaior == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    $temp .= $lineBreak;

      return $temp;
  }

  function AlinharEsquerda($msg, $negrito, $sublinhado, $fonteMaior)
  {
      global $lineBreak;
      $temp = "";
      $temp = "!AE~" . $msg;

    if($negrito == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($sublinhado == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($fonteMaior == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    $temp .= $lineBreak;

      return $temp;
  }

  function LinhaPontilhada()
  {
      global $lineBreak;
      $temp = "";
      $temp = "!LP" . $lineBreak;
      return $temp;
  }

  function AlinharEsquerdaDireitaMargin($esq, $dir, $margin, $negrito, $sublinhado, $fonteMaior)
  {
      global $lineBreak;
      $temp = "";
      $temp = "!EDM~" . $esq . "~" . $dir . "~" . $margin;

    if($negrito == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($sublinhado == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    if($fonteMaior == true)
    {
      $temp .= "~true";
    }
    else
    {
      $temp .= "~false";
    }

    $temp .= $lineBreak;

      return $temp;
  }

  function LineFeed()
  {
      global $lineBreak;
      return "!LF" . $lineBreak;
  }

  function trataTxt($str) {

    $str = str_replace("á", "a", $str);

    $str = str_replace("á", "a", $str);
    $str = str_replace("é", "e", $str);
    $str = str_replace("í", "i", $str);
    $str = str_replace("ó", "o", $str);
    $str = str_replace("ú", "u", $str);

    $str = str_replace("à", "a", $str);
    $str = str_replace("è", "e", $str);
    $str = str_replace("ì", "i", $str);
    $str = str_replace("ò", "o", $str);
    $str = str_replace("ù", "ù", $str);

    $str = str_replace("ã", "a", $str);
    $str = str_replace("õ", "o", $str);
    $str = str_replace("â", "a", $str);
    $str = str_replace("ê", "e", $str);
    $str = str_replace("î", "i", $str);
    $str = str_replace("ô", "o", $str);
    $str = str_replace("û", "u", $str);

    $str = str_replace(",", " ", $str);
    $str = str_replace("!", " ", $str);
    $str = str_replace("#", " ", $str);
    $str = str_replace("%", "", $str);
    $str = str_replace("¬", " ", $str);
    $str = str_replace("{", " ", $str);
    $str = str_replace("}", " ", $str);

    $str = str_replace("^", " ", $str);
    $str = str_replace("´", " ", $str);
    $str = str_replace("`", " ", $str);
    $str = str_replace("", " ", $str);
    $str = str_replace("/", " ", $str);
    $str = str_replace(";", " ", $str);
    $str = str_replace(":", " ", $str);
    $str = str_replace("?", " ", $str);

    $str = str_replace("¹", "1", $str);
    $str = str_replace("²", "2", $str);
    $str = str_replace("³", "3", $str);
    $str = str_replace("ª", "a", $str);
    $str = str_replace("º", "o", $str);
    $str = str_replace("ç", "c", $str);
    $str = str_replace("ü", "u", $str);

    $str = str_replace("ä", "a", $str);
    $str = str_replace("ï", "i", $str);
    $str = str_replace("ö", "o", $str);
    $str = str_replace("ë", "e", $str);
    $str = str_replace("É", "E", $str);
    $str = str_replace("$", "s", $str);
    $str = str_replace("ÿ", "y", $str);
    $str = str_replace("w", "w", $str);
    $str = str_replace("<", " ", $str);

    $str = str_replace(">", " ", $str);
    $str = str_replace("[", " ", $str);
    $str = str_replace("]", " ", $str);
    $str = str_replace("&", "e", $str);
    $str = str_replace("'", '' , $str);
    $str = str_replace('"', " ", $str);
    $str = str_replace('1', '1', $str);

    $str = str_replace('2', '2', $str);
    $str = str_replace('3', '3', $str);
    $str = str_replace('4', '4', $str);
    $str = str_replace('5', '5', $str);
    $str = str_replace('6', '6', $str);
    $str = str_replace('7', '7', $str);
    $str = str_replace('8', '8', $str);
    $str = str_replace('9', '9', $str);

    $str = str_replace('0', '0', $str);
    $str = str_replace('á', 'a', $str);
    $str = str_replace('Á', 'A', $str);
    $str = str_replace('é', 'e', $str);
    $str = str_replace('É', 'E', $str);
    $str = str_replace('í', 'i', $str);
    $str = str_replace('Í', 'i', $str);
    $str = str_replace('ó', 'o', $str);

    $str = str_replace('Ó', 'O', $str);
    $str = str_replace('ú', 'u', $str);
    $str = str_replace('Ú', 'U', $str);
    $str = str_replace('â', 'â', $str);
    $str = str_replace('â', 'â', $str);
    $str = str_replace('ê', 'ê', $str);
    $str = str_replace('Ê', 'â', $str);

    $str = str_replace('ô', 'ô', $str);
    $str = str_replace('Ô', 'â', $str);
    $str = str_replace('à', 'a', $str);
    $str = str_replace('À', 'â', $str);
    $str = str_replace('ç', 'c', $str);
    $str = str_replace('Ç', 'C', $str);
    $str = str_replace('ã', 'a', $str);

    $str = str_replace('Ã', 'ã', $str);
    $str = str_replace('õ', 'o', $str);
    $str = str_replace('Õ', 'o', $str);

    return $str;
  }
?>
<div class="page">
  <div class="navbar">
    <div class="navbar-inner sliding">
      <div class="left">
        <a href="#" class="link back">
          <i class="icon icon-back"></i>
          <span class="ios-only">Voltar</span>
        </a>
      </div>
      <div class="title">Impressão</div>
      <div class="right">
      </div>
    </div>
  </div>
  <div class="page-content">
    <div class="block-title">O que fazer agora?</div>
    <div class="list">
    <ul>
      <li>
        <a href="/" class="item-link item-content">
          <div class="item-media"><i class="material-icons">home</i></div>
          <div class="item-inner">
            <div class="item-title">Voltar ao início</div>
          </div>
        </a>
      </li>
      <li>
        <a href="/imprimir-app-tabela/" data-animate="false" data-reload-current="true" class="item-link item-content">
          <div class="item-media"><i class="material-icons">refresh</i></div>
          <div class="item-inner">
            <div class="item-title">Reimprimir</div>
          </div>
        </a>
      </li>
    </ul>
    </div>
    <div>
      <div class="item-media" style="text-align: center;"><i class="material-icons" style=" font-size: 70px; width: 70px; color: #12c213; font-weight: bold; ">check</i></div>
      <center>Impressão concluída!</center>
    </div>
    <div id="bilheteImpressao" style="margin: 10px auto; width: 7.9cm; overflow: scroll;">

        <?php
          // BILHETE
          echo SetColCount();
          echo Centralizar(' ', false, true, false);
          echo Centralizar(' ', false, true, false);
          echo Centralizar(trataTxt($_SESSION["configs"]["config_nome"]), true, false, true);
          echo Centralizar(trataTxt($_SESSION["configs"]["config_telefone"]), false, false, false);
          echo LinhaPontilhada();
          echo AlinharEsquerdaDireitaMargin("Data", date('d/m/Y H:i:s'),0, false, false, false);
          echo LinhaPontilhada();
          echo Centralizar("TABELA", false, false, false);


          foreach ($_SESSION["impressao"]["bets"] as $event => $m) {
            echo LinhaPontilhada();
            echo Centralizar(trataTxt($event), true, true, false);
            foreach ($m as $match) {
              echo AlinharEsquerdaDireitaMargin(trataTxt($match['nome']), trataTxt($match["casa"].' '.$match["empate"].' '.$match["fora"]), 0, false, false, false);
              echo AlinharEsquerdaDireitaMargin(trataTxt($match["data"]), '',0, false, false, false);
              echo LinhaPontilhada();
            }
          }

          echo Centralizar(trataTxt('Sistema FBET'), false, false, false);
          echo Centralizar(' ', false, true, false);
          echo Centralizar(' ', false, true, false);


        ?>

    </div>
  </div>
</div>
