<?php
    // ini_set('display_errors',1);
    // ini_set('display_startup_erros',1);
    // error_reporting(E_ALL);
    require '../../../inc/conexao.php';
    require '../../../inc/functions.php';
    require $_SERVER["DOCUMENT_ROOT"].'/api/pages/conferir-bilhete.php';
?>
<div class="page">
  <div class="navbar">
    <div class="navbar-inner sliding">
      <div class="left">
        <a href="#" class="link back">
          <i class="icon icon-back"></i>
          <span class="ios-only">Voltar</span>
        </a>
      </div>
      <div class="title">Ver | #<?php echo $_GET["code"]; ?></div>
      <div class="right">
        <a href="/" class="link topIcon icon-only icon-spin"><i class="material-icons icon_btn">home</i></a>
        <a href="/imprimir-app-bilhete/?code=<?php if(isset($_GET['code'])){ echo $_GET['code']; } ?>" data-ignore-cache="true" data-force="true" class="link topIcon icon-only icon-spin"><i class="material-icons icon_btn">print</i></a>
        <a href="/bilhete/<?php if(isset($_GET['code'])){ echo $_GET['code']; } ?>?share=1" class="link topIcon icon-only icon-spin external"><i class="material-icons icon_btn">share</i></a>
      </div>
    </div>
  </div>
  <div class="page-content">
     <?php if(isset($_GET["code"])){ ?>
     <!-- ################################### BILHETE ################################### -->
     <div class="print_area">
        <h2 class="center"><?php echo utf8_encode($_SESSION["configs"]["config_nome"]); ?></h2>
        <div class="tel center f14">TEL.: <?php echo exibirTelImpressao($_SESSION["configs"]["config_tel_impressao"], $_SESSION["configs"]["config_telefone"], $cupom["cupom_usuario"], $users); ?></div>
        <div class="dashed dashed10"></div>
        <div class="f14"><b>Data: </b> <span class="pull-right"><?php echo desfazDatetime($cupom["cupom_data"]); ?></span></div>
        <div class="f14"><b>Vendedor: </b> <span class="pull-right"><?php echo $users[$cupom["cupom_usuario"]]['nome']; ?></span></div>
        <div class="f14"><b>Cliente: </b> <span class="pull-right"><?php echo utf8_encode($cupom["cupom_cliente"]); ?></span></div>
        <div class="dashed dashed10"></div>
        <?php
           switch ($cupom["cupom_situacao"]) {
              case '1':
                 echo '<a class="col button button-fill color-blue">Aberto</a>';
                 break;

              case '2':
                 echo '<a class="col button button-fill color-green">Ganhou</a>';
                 break;

              case '3':
                 echo '<a class="col button button-fill color-red">Perdeu</a>';
                 break;

              case '4':
                 echo '<a class="col button button-fill color-black">Cancelado</a>';
                 break;

              default:
                 echo '<a class="col button button-fill">O BILHETE NÃO EXISTE</a>';
                 break;
           }
        ?>
        <div class="dashed dashed10"></div>
        <h4 class="center margin0">SUAS SELEÇÕES</h4>
        <div class="dashed dashed10"></div>

        <?php
           $campeonato_exibido = '';
           $cotacao_total = 0;

           while($a = $sql->fetch_assoc()){
              if(utf8_encode($a["aposta_campeonato"]) <> $campeonato_exibido){
                 echo '<div class="event f16 center">'.utf8_encode($a["aposta_campeonato"]).'</div>';
                 $campeonato_exibido = utf8_encode($a["aposta_campeonato"]);
              }

              // Adiciona cotação
              if($cotacao_total == 0){ $cotacao_total = $a["aposta_cotacao"]; }
              else { $cotacao_total *= $a["aposta_cotacao"]; }
        ?>
        <div class="item">
           <b><?php echo utf8_encode($a["aposta_jogo_nome"]); ?></b>
           <div><?php echo desfazDatetime($a["aposta_data_jogo"]); ?></div>
           <div><?php echo utf8_encode($a["aposta_mercado"]); ?></div>
           <div><b><?php echo utf8_encode($a["aposta_opcao"]); ?></b> <span class="pull-right"><b><?php echo ($a["aposta_cotacao"]); ?></b></span></div>
           <div><b>Status</b> <span class="pull-right"><b>
              <?php
                 switch ($a["aposta_status"]) {
                    case '1':
                       echo '<span class="badge color-blue">Aberto</span>';
                       break;

                    case '2':
                       echo '<span class="badge color-green">Ganhou</span>';
                       break;

                    case '3':
                       echo '<span class="badge color-red">Perdeu</span>';
                       break;

                    case '4':
                       echo '<span class="badge color-black">Cancelado</span>';
                       break;

                    default:
                       echo '<span class="badge badge-warning color-orange">Indefinido</span>';
                       break;
                 }
              ?>
           </b></span></div>
           <div class="dashed"></div>
        </div>
        <?php
           }

           // Multiplicador máximo
           if($cotacao_total > $_SESSION['configs']['config_multiplicador']){ $cotacao_total = $_SESSION['configs']['config_multiplicador']; }
           $retorno = $cupom["cupom_valor"] * $cotacao_total;
           if($retorno > $_SESSION['configs']['config_max_ganhos_reais']){ $retorno = $_SESSION['configs']['config_max_ganhos_reais']; }
        ?>

        <div class="f14"><b>Valor: </b> <span class="pull-right">R$<?php echo formataReal($cupom["cupom_valor"]); ?></span></div>
        <div class="f14"><b>Cotação: </b> <span class="pull-right"><?php echo number_format($cotacao_total, 2); ?></span></div>
        <div class="f14"><b>Poss. Retorno: </b> <span class="pull-right"><?php if($cupom["cupom_situacao"] <> '2'){ echo 'R$'.formataReal($retorno); } else { echo '<span class="badge badge-success">R$'.formataReal($cupom["cupom_saidas"]).'</span>'; } ?></span></div>
        <div class="dashed"></div>
        <div class="center f13">BILHETE</div>
        <h2 class="center"><?php echo strtoupper($cupom["cupom_codigo"]); ?></h2>
        <div class="dashed"></div>
        <p><?php echo utf8_encode($_SESSION["configs"]["config_bilhete_rodape"]); ?></p>
     </div>
     <!-- ################################### /BILHETE ################################## -->
     <?php } else { echo '<center>Informe o código do bilhete no campo ao lado.</center>'; } ?>
  </div>
</div>
