<?php
    // ini_set('display_errors',1);
    // ini_set('display_startup_erros',1);
    // error_reporting(E_ALL);
    require '../../../inc/conexao.php';
    require '../../../inc/functions.php';
?>
<div class="page">
  <div class="navbar">
    <div class="navbar-inner sliding">
      <div class="left">
        <a href="#" class="link back">
          <i class="icon icon-back"></i>
          <span class="ios-only">Voltar</span>
        </a>
      </div>
      <div class="title">Finalizar</div>
      <div class="right">
        <?php if(!isset($_SESSION["usuario"])){  ?>
        <a href="/login/?redirect=finalizar-aposta" class="link icon-only"><i class="icon material-icons md-only">person</i></a>
        <?php } ?>
        <a href="/" class="link icon-only"><i class="icon material-icons md-only">home</i></a>
      </div>
    </div>
  </div>
  <div class="page-content">
    <form id="finishBetForm" action="/api/finishBet">
      <div class="list inline-labels no-hairlines-md">
         <ul id="priceReturnBetFormFinish">
            <?php if(isset($_SESSION["usuario"])){  ?>
            <li class="item-content item-input">
               <div class="item-inner">
                  <center>Seu crédito: <b>R$<?php echo formataReal($_SESSION['usuario']['credito']); ?></b></center>
               </div>
            </li>
            <?php } ?>
            <li class="item-content item-input">
               <div class="item-inner">
                  <div class="item-title item-label">Cliente</div>
                  <div class="item-input-wrap">
                     <input type="text" name="cliente" placeholder="Ex: João" class="">
                     <span class="input-clear-button"></span>
                  </div>
               </div>
            </li>
            <li class="item-content item-input">
               <div class="item-inner">
                  <div class="item-title item-label">Valor</div>
                  <div class="item-input-wrap">
                     <input type="tel" placeholder="Ex: 10,00" class="" name="valor" id="priceBet" onfocusin="adjustPrice(this);" onfocusout="maskMoney(this); calcReturn(this.value);" onkeyup="calcReturn(this.value);">
                     <span class="input-clear-button"></span>
                  </div>
               </div>
            </li>
            <li class="item-content item-input">
               <div class="item-inner">
                  <div class="item-title item-label">Poss. Retorno</div>
                  <div class="item-input-wrap">
                     <input type="text" disabled="disabled" name="return" id="totalReturns" value="0,00">
                     <span class="input-clear-button"></span>
                  </div>
               </div>
            </li>
         </ul>
      </div>
    </form>

    <div class="list">
      <ul id="couponContent">
        <?php
          $cotacao = 0;
          foreach ($_SESSION["apostas"] as $k => $v) {
            $teams = explode(' x ', $v["aposta_jogo_nome"]);
            if($cotacao == 0){ $cotacao = $v["aposta_cotacao"]; } else { $cotacao *= $v["aposta_cotacao"]; }
        ?>
        <li class="option<?php echo $v['aposta_token']; ?>" id="item<?php echo $k; ?>">
          <a class="item-link item-content">
            <div class="item-inner item-inner-status">
              <div class="item-title">
                <div class="item-header"><?php echo $teams[0]; ?></div>
                <div class="item-header"><?php echo $teams[1]; ?></div>
                <div class="match_date"><?php echo desfazDatetime($v["aposta_data_jogo"]); ?> <br /><?php echo $v["aposta_nome_aposta"]; ?> <b>(<?php echo $v["aposta_opcao"]; ?>)</b></div>
              </div>
              <div class="item-after"><?php echo $v["aposta_cotacao"]; ?> &nbsp; <div class="chip chip-status color-red" onClick="clearOption(<?php echo $k; ?>);" data-match="<?php echo $k; ?>"> <div class="chip-label"><i class="material-icons">close</i></div> </div></div>
            </div>
          </a>
        </li>
        <?php } ?>
      </ul>
    </div><br /><br />
  </div>
  <div class="fab fab-extended color-red fab-left-bottom">
    <a onClick="clearOption('all');" data-match="all">
      <i class="icon material-icons md-only">delete</i>
      <div class="fab-text">Limpar</div>
    </a>
  </div>
  <div class="fab fab-extended color-<?php if(isset($_SESSION['usuario'])){ echo 'green'; } else { echo 'orange'; } ?> fab-right-bottom">
    <a href="#" onClick="finishBet();">
      <i class="icon material-icons md-only">check</i>
      <div class="fab-text"><?php if(isset($_SESSION["usuario"])){ echo 'Finalizar'; } else { echo 'Gerar PIN'; } ?></div>
    </a>
  </div>
</div>