<?php
    // ini_set('display_errors',1);
    // ini_set('display_startup_erros',1);
    // error_reporting(E_ALL);
    require '../../../inc/conexao.php';
    require '../../../inc/functions.php';
?>
<div class="page">
  <div class="navbar">
    <div class="navbar-inner sliding">
      <div class="left">
        <a href="#" class="link back">
          <i class="icon icon-back"></i>
          <span class="ios-only">Voltar</span>
        </a>
      </div>
      <div class="title">Campeonatos</div>
      <div class="right">
        <a href="javascript: location.reload();" class="link topIcon icon-only icon-spin"><i class="material-icons icon_btn">refresh</i></a>
      </div>
    </div>
  </div>
  <div class="page-content">
    <form action="" method="GET" id="filterMatches">
      <div class="list listMarginZero">
        <a class="item-link smart-select smart-select-init">
          <select name="esporte" id="sportFilterMatch">
            <option value="futebol" selected>Futebol</option>
            <option value="basquete">Basquete</option>
            <option value="volei">Volei</option>
          </select>
          <div class="item-content">
            <div class="item-inner">
              <div class="item-title">Esporte</div>
            </div>
          </div>
        </a>
        <a class="item-link smart-select smart-select-init" data-url="select/">
          <select name="data" id="dataFilterMatch">
            <option value="<?php echo date('Y-m-d'); ?>" data-display-as="Hoje">Hoje</option>
            <option value="<?php echo date('Y-m-d', strtotime('+1 day', strtotime(date('Y-m-d')))); ?>" data-display-as="Amanhã">Amanhã</option>
            <?php $d = 2; while($d <= 5){ ?>
            <option value="<?php echo date('Y-m-d', strtotime('+'.$d.' days', strtotime(date('Y-m-d')))); ?>">
              <?php
                $n = date('N', strtotime('+'.$d.' days', strtotime(date('Y-m-d'))));
                echo date('d/m/Y', strtotime('+'.$d.' days', strtotime(date('Y-m-d'))));
                switch ($n) {
                  case '1':
                    echo ' - Segunda-feira';
                    break;

                  case '2':
                    echo ' - Terça-feira';
                    break;

                  case '3':
                    echo ' - Quarta-feira';
                    break;

                  case '4':
                    echo ' - Quinta-feira';
                    break;

                  case '5':
                    echo ' - Sexta-feira';
                    break;

                  case '6':
                    echo ' - Sábado';
                    break;

                  case '7':
                    echo ' - Domingo';
                    break;

                  default:
                    # code...
                    break;
                }
              ?>
            </option>
            <?php $d++; } ?>
          </select>
          <div class="item-content">
            <div class="item-inner">
              <div class="item-title">Data</div>
            </div>
          </div>
        </a>
      </div>
      <a class="col button button-fill color-orange" onClick="filterMatches();">Filtrar</a>
    </form>
    <div class="block-title">Jogos do dia</div>
    <div class="list">
      <ul>
        <li>
          <a href="/partidas/?esporte=<?php echo $GETQUERY['esporte']; ?>&data=<?php echo date('Y-m-d'); ?>" class="item-link item-content">
            <div class="item-media"><i class="material-icons icon_btn">today</i></div>
            <div class="item-inner">
              <div class="item-title">Jogos de hoje</div>
            </div>
          </a>
        </li>
        <li>
          <a href="/partidas/?esporte=<?php echo $GETQUERY['esporte']; ?>&data=<?php echo date('Y-m-d', strtotime('+1 day', strtotime(date('Y-m-d')))); ?>" class="item-link item-content">
            <div class="item-media"><i class="material-icons icon_btn">today</i></div>
            <div class="item-inner">
              <div class="item-title">Jogos de amanhã</div>
            </div>
          </a>
        </li>
      </ul>
    </div>
    <div class="block-title">Selecione um país</div>
    <div class="list">
      <ul id="matchesListByFilter">
        <?php
          $qtd_available_matches = 0;
          $filtroPaises = array();
          foreach ($p["data"] as $pais => $i) {
          array_push($filtroPaises, $pais);
          if(!in_array($pais, $p["filtroPaises"]) && count($p["filtroPaises"]) > 0){ continue; }
          $qtd_available_matches++;

          $pname = $pais;
          $pname = str_replace(' ', '-', $pname);
          $pname = str_replace('á', 'a', $pname);
          $pname = str_replace('ã', 'a', $pname);
          $pname = str_replace('â', 'a', $pname);
          $pname = str_replace('é', 'e', $pname);
          $pname = str_replace('ê', 'e', $pname);
          $pname = str_replace('í', 'i', $pname);
          $pname = str_replace('ç', 'c', $pname);
          $pname = str_replace('ó', 'o', $pname);
          $pname = str_replace('ô', 'o', $pname);
          $pname = str_replace('õ', 'o', $pname);
          $pname = str_replace('ú', 'u', $pname);
        ?>
          <li>
            <a href="/partidas/?esporte=<?php echo $GETQUERY['esporte']; ?>&pais=<?php echo $pais; ?>&data=<?php echo date('Y-m-d'); ?>" class="item-link item-content">
              <div class="item-media"><span class="flags flags-category flags-sports flags--md flags--<?php echo $pname; ?>"></span></div>
              <div class="item-inner">
                <div class="item-title"><?php echo $pais; ?></div>
                <div class="item-after"><div class="chip color-orange mini-chip"> <div class="chip-label"><?php echo count($i); ?></div> </div></div>
              </div>
            </a>
          </li>
        <?php
          }

          if($qtd_available_matches == 0){
            echo '<div class="alert alert-warning text-center" id="noMatches"><h4>Não há jogos disponíveis para esta data ou pesquisa.</h4></div>';
          }
        ?>
      </ul><br /><br />
    </div>
  </div>
<?php include $_SERVER["DOCUMENT_ROOT"].'/m/inc/float_menu.php'; ?>