// Dom7
var $ = Dom7;

// Theme
var theme = 'auto';
if (document.location.search.indexOf('theme=') >= 0) {
  theme = document.location.search.split('theme=')[1].split('&')[0];
}

// Init App
var app = new Framework7({
  pushState: true,
  pushStateSeparator: '#page/',
  id: 'io.framework7.testapp',
  root: '#app',
  theme: theme,
  data: function () {
    return {
      user: {
        firstName: 'John',
        lastName: 'Doe',
      },
    };
  },
  methods: {
    helloWorld: function () {
      app.dialog.alert('Hello World!');
    },
  },
  dialog: {
    preloaderTitle: 'Um instante...',
    buttonCancel: 'Cancelar',
  },
  touch: {
    disableContextMenu: false,
  },
  routes: routes,
  vi: {
    placementId: 'pltd4o7ibb9rc653x14',
  },
});
var $$ = Dom7;
var mainView = app.views.create('.view-main', { pushState: true });

if(typeof(Website2APK) != "undefined"){
  Website2APK.showToast("Bem-vindo ao FScores!");
}

if(autenticado == '0'){
  app.dialog.preloader('Autenticando...');
  
  if(typeof(Website2APK) != "undefined"){
    var devId = Website2APK.getUniqueDeviceID();
  }
  else {
    var devId = '123456789';
  }

  app.request.get('pages/conta/autenticar.php?sleep=1&token='+devId, function(data) {
    app.dialog.close();
    location.reload();
  });
}

//var devId = Website2APK.getUniqueDeviceID();
//Website2APK.showToast("Bem-vindo ao FScores!");


function changeMatchesView(btn, type){
      [].forEach.call(document.querySelectorAll('.types_comparation'), function (el) {
        el.style.display = 'none';
      });

      [].forEach.call(document.querySelectorAll('.type_'+type), function (el) {
        el.style.display = 'block';
      });

      [].forEach.call(document.querySelectorAll('.changeH2H'), function (el) {
        el.classList.remove("button-active");
      });

      btn.classList.add("button-active");
      return false;
    }

    function getVarsFromString(name, url) {
      if (!url) url = window.location.href;
      name = name.replace(/[\[\]]/g, "\\$&");
      var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
          results = regex.exec(url);
      if (!results) return null;
      if (!results[2]) return '';
      return decodeURIComponent(results[2].replace(/\+/g, " "));
    }

    function sendForm(btn, form_id){
      btn.innerHTML = '<div class="preloader color-white" style="width: 20px !important; height: 20px !important;"><span class="preloader-inner"> <span class="preloader-inner-gap"></span> <span class="preloader-inner-left"> <span class="preloader-inner-half-circle"></span> </span> <span class="preloader-inner-right"> <span class="preloader-inner-half-circle"></span> </span> </span></div>';
      var formData = app.form.convertToData('#'+form_id);
      var dados = JSON.stringify(formData);
      btn.setAttribute("href", "tcc"); 
      alert(formData+' | '+dados+' | '+dados[0]["codigo"]+' | '+dados["codigo"]);
    }

    function sendBet(el, betCode, banca){
      var code = document.getElementById(betCode).value;
      app.request.get('pages/bilhetes/addBilhete.php?code='+code+'&banca='+banca, function(data) {
        if(data == '1'){
          app.dialog.alert('O bilhete foi adicionado.', 'Pronto');
          location.href = "/";
        }
        else {
          app.dialog.alert(data, 'Erro');
        }
      });
    }

    function definePorcentagem(i, total, name){
      if(total == 0){ return 0; }
      /*console.log('DP '+name+': '+(i / (total / 100)));*/
      return (i / (total / 100));
    }

    function confirmDelete(cod, goIndex){
      app.dialog.confirm('Você tem certeza que deseja remover o bilhete '+cod+'?', 'Tem certeza?', function(){
        app.dialog.preloader('Apagando...');
        
        app.request.get('pages/bilhetes/apagar.php?sleep=1&codigo='+cod, function(data) {
          app.dialog.close();
          
          if(data == '1'){
            document.getElementById('bilhete'+cod).style.display = 'none';

            if(goIndex == true){ location.href = '/'; }
          }
          else {
            app.dialog.alert(data, 'Erro');
          }
        });
      });
    }

    function respondeEnquete(btn, match, resposta){
      app.dialog.preloader('Carregando...');

      app.request.get('pages/jogos/responderEnquete.php?match='+match+'&resposta='+resposta, function(data) {
        app.dialog.close();
        
        if(data == '1'){
          // Aumenta contador
          var vt = parseInt(btn.getAttribute('votos')) + parseInt(1);
          btn.setAttribute('votos', vt);
          document.getElementById('survey_options').classList.add("survey_answered");

          // Altera tamanhos
          var total_survey = parseInt(document.getElementById('surveyBtn1').getAttribute('votos')) + parseInt(document.getElementById('surveyBtnX').getAttribute('votos')) + parseInt(document.getElementById('surveyBtn2').getAttribute('votos'));
          var total_survey_1 = parseInt(total_survey) / 100;

          var survey1 = parseInt(document.getElementById('surveyBtn1').getAttribute('votos')) / total_survey_1; 
          if(parseInt(survey1) > 0){
            document.getElementById('surveyBtn1').innerHTML = parseInt(survey1)+'% ('+document.getElementById('surveyBtn1').getAttribute('votos')+')';
          }
          else {
           document.getElementById('surveyBtn1').style.display = 'none'; 
          }
          document.getElementById('surveyBtn1').style.maxWidth = survey1+'%';
          document.getElementById('surveyBtn1').setAttribute('onClick', '');

          var surveyX = parseInt(document.getElementById('surveyBtnX').getAttribute('votos')) / total_survey_1; 
          if(parseInt(surveyX) > 0){
            document.getElementById('surveyBtnX').innerHTML = parseInt(surveyX)+'% ('+document.getElementById('surveyBtnX').getAttribute('votos')+')';
          }
          else {
           document.getElementById('surveyBtnX').style.display = 'none'; 
          }
          document.getElementById('surveyBtnX').style.maxWidth = surveyX+'%';
          document.getElementById('surveyBtnX').setAttribute('onClick', '');

          var survey2 = parseInt(document.getElementById('surveyBtn2').getAttribute('votos')) / total_survey_1; 
          if(parseInt(survey2) > 0){
            document.getElementById('surveyBtn2').innerHTML = parseInt(survey2)+'% ('+document.getElementById('surveyBtn2').getAttribute('votos')+')';
          }
          else {
           document.getElementById('surveyBtn2').style.display = 'none'; 
          }
          document.getElementById('surveyBtn2').style.maxWidth = survey2+'%';
          document.getElementById('surveyBtn2').setAttribute('onClick', '');
        }
        else {
          app.dialog.alert(data, 'Erro');
        }
      });

    }

    function startMatchUpdates(match){
      console.log('Starting updates to match '+match);
      app.request.get('pages/jogos/updateMatch.php?match='+match, function(data) {
        var ret = JSON.parse(data);

        // INFO DO JOGO
        var placar = ret.placar;
        var tempo = ret.tempo;

        if(ret.isLive == '1' || ret.isLive == '3'){
          if(ret.isLive == '1'){ 
            document.getElementById('versus-navbar').classList.add("isLive"); 
            document.getElementById('matchOddsPre').classList.add("displayNone");
          }
          document.getElementById('match_info_date').classList.add("displayNone");
          document.getElementById('match_survey1').classList.add("displayNone");
          document.getElementById('match_name_h').classList.add("displayNone");

          document.getElementById('vg_odd_home').innerHTML = ret.oddCasa
          document.getElementById('vg_odd_draw').innerHTML = ret.oddEmpate
          document.getElementById('vg_odd_away').innerHTML = ret.oddVisitante

          var liveOddsDiv = document.getElementById('matchOddsLive');
          liveOddsDiv.innerHTML = '';
          
          for (var k in ret.odds) {
            //console.log(k);
            liveOddsDiv.innerHTML = liveOddsDiv.innerHTML+'<div class="boption">'+k+' <span class="blink">Ao vivo</span></div>';

            //console.log(ret.odds[k]);
            var op = ret.odds[k];
            for(var o in op){
              liveOddsDiv.innerHTML = liveOddsDiv.innerHTML+'<div class="ooption"><span class="option_name">'+op[o]['name']+'</span> <button class="col button button-small color-gray button-outline">'+op[o]['odd']+'</button></div>';
              // console.log(op[o]['name']);
            }
          }

          // Eventos
          var matchEvents = document.getElementById('match-events');
          matchEvents.innerHTML = '';
          for(var k in ret.eventos){
            matchEvents.innerHTML = matchEvents.innerHTML+'<li class="noHeight"> <div class="item-inner"> <div class="item-subtitle">'+ret.eventos[k]+'</div> </div> </li>';
          }

          // Estatísticas
          document.getElementById('statinfo_yellow_1').innerHTML = ret.yellow_1;
          document.getElementById('statinfo_yellow_2').innerHTML = ret.yellow_2;
          app.progressbar.set(document.getElementById('statbar_yellow_1'), definePorcentagem(ret.yellow_1, ret.yellow_total, 'Y1'), 2000);
          app.progressbar.set(document.getElementById('statbar_yellow_2'), definePorcentagem(ret.yellow_2, ret.yellow_total, 'Y2'), 2000);

          document.getElementById('statinfo_corner_1').innerHTML = ret.corner_1;
          document.getElementById('statinfo_corner_2').innerHTML = ret.corner_2;
          app.progressbar.set(document.getElementById('statbar_corner_1'), definePorcentagem(ret.corner_1, ret.corner_total, 'C1'), 2000);
          app.progressbar.set(document.getElementById('statbar_corner_2'), definePorcentagem(ret.corner_2, ret.corner_total, 'C2'), 2000);

          document.getElementById('statinfo_red_1').innerHTML = ret.red_1;
          document.getElementById('statinfo_red_2').innerHTML = ret.red_2;
          app.progressbar.set(document.getElementById('statbar_red_1'), definePorcentagem(ret.red_1, ret.red_total, 'R1'), 2000);
          app.progressbar.set(document.getElementById('statbar_red_2'), definePorcentagem(ret.red_2, ret.red_total, 'R2'), 2000);

          document.getElementById('statinfo_pen_1').innerHTML = ret.pen_1;
          document.getElementById('statinfo_pen_2').innerHTML = ret.pen_2;
          app.progressbar.set(document.getElementById('statbar_pen_1'), definePorcentagem(ret.pen_1, ret.pen_total, 'P1'), 2000);
          app.progressbar.set(document.getElementById('statbar_pen_2'), definePorcentagem(ret.pen_2, ret.pen_total, 'P2'), 2000);

          document.getElementById('statinfo_subs_1').innerHTML = ret.subs_1;
          document.getElementById('statinfo_subs_2').innerHTML = ret.subs_2;
          app.progressbar.set(document.getElementById('statbar_subs_1'), definePorcentagem(ret.subs_1, ret.subs_total, 'S1'), 2000);
          app.progressbar.set(document.getElementById('statbar_subs_2'), definePorcentagem(ret.subs_2, ret.subs_total, 'S2'), 2000);

        }

        document.getElementById('match_time').innerHTML = tempo;
        document.getElementById('match_ss').innerHTML = placar;
        if(ret.ht != undefined){
          document.getElementById('match_ht').innerHTML = ret.ht;
        }

      });

      return false;
    }

    function startLiveUpdates(){
      console.log('Starting updates to LIVE matches.');
      app.request.get('pages/jogos/liveMatches.php', function(data) {
        var retLive = JSON.parse(data)
        var liveMatchesDiv = document.getElementById('liveMatchesDiv');
        liveMatchesDiv.innerHTML = '';
        
        // INFO DO JOGO
        for (var k in retLive) {
          liveMatchesDiv.innerHTML = liveMatchesDiv.innerHTML+'<li> <a href="'+retLive[k]['url']+'" onclick="showLoader();" class="item-link item-content"> <div class="item-media isLive match_list_time">'+retLive[k]['tempo']+'\'</div> <div class="item-inner"> <div class="item-title"> <div class="item-header"><span class="isLive">'+retLive[k]['placar_casa']+'</span> &nbsp; '+retLive[k]['time_casa']+'</div> <div class="item-header"><span class="isLive">'+retLive[k]['placar_visitante']+'</span> &nbsp; '+retLive[k]['time_visitante']+'</div> </div> <div class="item-after"> Detalhes </div> </div> </a> </li>';
        }


      });

      return false;
    }

    function showLoader(){
      app.preloader.show();
      setTimeout(function(){ app.preloader.hide(); }, 5000);
      return false;
    }

    var matchUpdate;
    var liveUpdate;
    $$(document).on('page:init', function (e, page) {
      app.preloader.hide();
      // Page Data contains all required information about loaded and initialized page
      var pagename = page.route.name;
      var url = page.route.url;

      //window.location.assign("#"+pagename);

      // Se for página de jogos
      if(pagename == 'info-jogo'){
        var matchId = getVarsFromString('match', url);
        // alert('MID: '+matchId);
        startMatchUpdates(matchId);
        matchUpdate = setInterval(function() { startMatchUpdates(matchId); }, 200000);
      } else {
        console.log('Aborting updates to matches. P: '+pagename);
        clearInterval(matchUpdate);
      }

      // Se for página de jogos
      if(pagename == 'jogos-aovivo'){
        // alert('MID: '+matchId);
        startLiveUpdates();
        liveUpdate = setInterval(function() { startLiveUpdates(); }, 5000);
      } 
      else if(pagename == 'info-jogo'){ }
      else if(pagename == 'inicio'){ }
      else {
        console.log('Aborting updates to lives. P: '+pagename);
        clearInterval(liveUpdate);
      }
    });