<?php 
  include_once $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
  include_once $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
  include_once $_SERVER["DOCUMENT_ROOT"].'/inc/functions-financeiro.php';

  $sql = $mysqli->query("SELECT * FROM configs WHERE config_id = '1'");
  $cfg = $sql->fetch_assoc();

    // Valor máximo de retorno
  $retornoMaximo = str_replace('.', '', $cfg['config_max_ganhos_reais']);
  $retornoMaximo = str_replace(',', '.', $retornoMaximo);

  ini_set('display_errors',1);
  ini_set('display_startup_erros',1);
  error_reporting(E_ALL);

  function defineSituacaoBilhete($codigo, $apostas){

    $status['1'] = ($apostas['aberto']);
    $status['2'] = ($apostas['ganhou']);
    $status['3'] = ($apostas['perdeu']);
    $status['4'] = ($apostas['cancelado']);

    // Pesquisa se todos são CANCELADOS
    if($status['4'] > 0 && $status['1'] == 0 && $status['2'] == 0 && $status['3'] == 0){ 
      return '4'; // Cancelado
    }

    // Pesquisa se todos são CANCELADOS
    if($status['4'] > 0 && $status['1'] == 0 && $status['2'] == 0 && $status['3'] == 0){ 
      return '4'; // Cancelado
    }

    // Pesquisa se todos são GANHOU
    if($status['2'] > 0 && $status['1'] == 0 && $status['3'] == 0){ // Se não houver nenhuma aposta que não seja GANHOU, o bilhete está finalizado
      return '2'; // Ganhou
    }

    // Pesquisa se há apostas perdidas
    if($status['3'] > 0){ // Há apostas perdidas. Então, o bilhete é perdido
      echo 'C '.$codigo.' entrou. C: '.$status['3'].' - AP: '.print_r($apostas).' <br />';
      return '3'; // Perdeu
    }

    // Pesquisa se há apostas em aberto
    if($status['1'] > 0){ // Há apostas em aberto. Então, o bilhete é em aberto
      return '1'; // Em aberto
    }


    return 'undefined';
  }

  function definePremiacao($cotacao, $valor){

    global $retornoMaximo;
    $valor = str_replace('.', '', $valor);
    $valor = str_replace(',', '.', $valor);

    $retorno_total = $cotacao * $valor;

    if($retorno_total > $retornoMaximo){ $retorno_total = $retornoMaximo; }
    return number_format($retorno_total, 2, ',', '.'); 
  }

  // Pega ID do simulador
  $sql = $mysqli->query("SELECT usuario_id FROM usuarios WHERE usuario_nome = 'Simulador'");

  $simulador = '';
  if(mysqli_num_rows($sql) > 0){ $simulador = $sql->fetch_assoc(); $simulador = $simulador['usuario_id']; }


  // LISTA TODAS AS APOSTAS
  // Próxima segunda
  $proxsegunda = date('Y-m-d', strtotime("next Monday"));
  $datalimite = date('Y-m-d', strtotime('-20 days', strtotime($proxsegunda)));

  // SELECT aposta_cupom, aposta_status, COUNT(*) AS total, SUM(aposta_cotacao) AS cotacao FROM apostas WHERE aposta_data > '$datalimite 00:00:00' GROUP BY aposta_cupom, aposta_status
  $sql = $mysqli->query("SELECT aposta_cupom, aposta_status, aposta_cotacao FROM apostas WHERE aposta_vendedor <> '$simulador' and aposta_data > '$datalimite 00:00:00'");

  // Inicializa os arrays
  $cupons = array();
  $jaPerdidos = array();
  $wherePerdeu = array();

  // Agrupa em array
  while ($cp = $sql->fetch_assoc()) {

    // Se já perdeu, continua
    if(isset($jaPerdidos[$cp["aposta_cupom"]])){ continue; }

    // Cria cupom caso nao exista
    if(!isset($cupons[$cp["aposta_cupom"]])){ 
      $cupons[$cp["aposta_cupom"]] = array(); 
      $cupons[$cp["aposta_cupom"]]['aberto'] = 0;
      $cupons[$cp["aposta_cupom"]]['ganhou'] = 0;
      $cupons[$cp["aposta_cupom"]]['perdeu'] = 0;
      $cupons[$cp["aposta_cupom"]]['cancelado'] = 0;
      $cupons[$cp["aposta_cupom"]]['cotacao'] = 0.00;
    }

    // Se for ABERTO, soma
    if($cp["aposta_status"] == '1'){
      $cupons[$cp["aposta_cupom"]]['aberto'] += 1;
    }

    // Se for GANHOU, soma
    if($cp["aposta_status"] == '2'){
      $cupons[$cp["aposta_cupom"]]['ganhou'] += 1;
      if($cupons[$cp["aposta_cupom"]]['cotacao'] == 0.00){ $cupons[$cp["aposta_cupom"]]['cotacao'] = $cp["aposta_cotacao"]; }
      else { $cupons[$cp["aposta_cupom"]]['cotacao'] *= $cp["aposta_cotacao"]; }
    }

    // Se for PERDEU, soma
    if($cp["aposta_status"] == '3'){
      $jaPerdidos[$cp["aposta_cupom"]] = 1;

      if(!in_array($cp["aposta_cupom"], $wherePerdeu)){
          array_push($wherePerdeu, $cp["aposta_cupom"]);
      }
    }

    // Se for CANCELADO, soma
    if($cp["aposta_status"] == '4'){
      $cupons[$cp["aposta_cupom"]]['cancelado'] += 1;
    }
  
  }

  // Coloca PERDEU nos bilhetes JAPERDEU
  $wherePerdeu = join("','",$wherePerdeu); 
  $sql = $mysqli->query("UPDATE cupons SET cupom_situacao = '3' WHERE cupom_codigo IN ('$wherePerdeu')");

  // STATUS
  $sql = $mysqli->query("SELECT cupom_multiplas, cupom_vendedor, cupom_id, cupom_codigo, cupom_valor, cupom_situacao FROM cupons WHERE cupom_simulador = '0' and cupom_situacao = '1' and cupom_vendedor <> '$simulador' ORDER BY cupom_id ASC");
  $erros = 0;
  $sucesso = 0;
  echo 'Iniciou em '.date('d/m/Y - H:i:s').'<br />';

  echo 'Total: '.mysqli_num_rows($sql).' bilhetes. <br />';
  if(!$sql){ echo 'ERRO! O sistema retornou: '.$mysqli->error; exit; }

  while($c = $sql->fetch_assoc()){
    if(!isset($cupons[$c["cupom_codigo"]])){ echo 'O cupom <b>'.$c["cupom_codigo"].'</b> foi pulado. MOTIVO INDEFINIDO! <br />'; continue; }

    $status = defineSituacaoBilhete($c["cupom_codigo"], $cupons[$c["cupom_codigo"]]);
    
    $id = $c["cupom_id"];

    // SAÍDAS
    if($status == '2'){
      if($cupons[$c["cupom_codigo"]]['cotacao'] > $cfg_cotacao_maxima){ $cupons[$c["cupom_codigo"]]['cotacao'] = $cfg_cotacao_maxima; }
      $premios = definePremiacao($cupons[$c["cupom_codigo"]]['cotacao'], $c["cupom_valor"]);
      if($premios == '0,00' || $premios == '0.00' || $premios == ''){ echo 'O bilhete '.$c["cupom_codigo"].' foi pulado por estar com valor do premio em branco. <br />'; continue; }
    }
    else {
      $premios = '';
    }


    if($status == '0'){ echo 'O cupom <b>'.$c["cupom_codigo"].'</b> foi pulado! <br />'; continue; }
    if($status == '1'){ echo 'O bilhete '.$c["cupom_codigo"].' nao precisa de atualizacao. <br />'; continue; }

    $sql_dois = $mysqli->query("UPDATE cupons SET cupom_saidas = '$premios', cupom_situacao = '$status' WHERE cupom_id = '$id'");

    if($sql_dois){ echo 'Cupom <b>'.$c["cupom_codigo"].'</b> alterado de '.$c["cupom_situacao"].' para '.$status.'! <br />'; $sucesso++; }
    else { $erros++; }
  }

  // CALCULA QUANTOS CAIXAS NEGATIVOS
  $sql = $mysqli->query("UPDATE configs SET config_msg_caixa = ''");


  ///////////////////////////////////////////////////////////////////////////////////


    $usuarios = array();
    $sql_dois = $mysqli->query("SELECT cupom_valor, cupom_vendedor, cupom_comissao, cupom_saidas, cupom_situacao FROM cupons
      WHERE 
        (cupom_situacao = '1' OR cupom_situacao = '2' OR cupom_situacao = '3') AND
        cupom_situacao <> '4' and cupom_lixeira = '0' and cupom_simulador = '0'
      ");

    if(!$sql_dois){ echo 'ERRO! Sistema: '.$mysqli->error; exit; }
    while($atualizacao_cupons = $sql_dois->fetch_assoc()){

      if(!isset($usuarios[$atualizacao_cupons["cupom_vendedor"]])){
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_ea'] = '0,00';
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_e'] = '0,00';
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_s'] = '0,00';
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_c'] = '0,00';
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_l'] = '0,00';
      }

      if($atualizacao_cupons["cupom_situacao"] == '1'){
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_ea'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_ea'], $atualizacao_cupons["cupom_valor"], '+');
      }
      elseif($atualizacao_cupons["cupom_situacao"] == '2'){
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_e'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_e'], $atualizacao_cupons["cupom_valor"], '+');
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_s'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_s'], $atualizacao_cupons["cupom_saidas"], '+');
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_c'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_c'], $atualizacao_cupons["cupom_comissao"], '+');
      }
      elseif($atualizacao_cupons["cupom_situacao"] == '3'){
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_e'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_e'], $atualizacao_cupons["cupom_valor"], '+');
        $usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_c'] = opMonetaria($usuarios[$atualizacao_cupons["cupom_vendedor"]]['total_c'], $atualizacao_cupons["cupom_comissao"], '+');
      }
    }

    $negativos = 0;

    foreach ($usuarios as $id => $usuario) {
      // ENTRADAS EM ABERTO
      $entradas_abertas = $usuarios[$id]['total_ea'];
      $entradas = $usuarios[$id]['total_e'];
      $saidas = $usuarios[$id]['total_s'];
      $comissoes = $usuarios[$id]['total_c'];
      $lancamentos = $usuarios[$id]['total_l'];
      
      $total = '0,00';
      $total = opMonetaria($total, $entradas, '+');
      $total = opMonetaria($total, $saidas, '-');
      $total = opMonetaria($total, $comissoes, '-');

      ///////////////////////////////////////////////////////////////////////////////////

      $confere_total = str_replace('.', '', $total);
      $confere_total = str_replace(',', '.', $confere_total);

      if($confere_total < 0){ $negativos++; }
    }

  ///////////////////////////////////////////////////////////////////////////////////

  if($negativos > 0){
    $msg = utf8_decode('<b>Atenção!</b> Atualmente, o caixa de '.$negativos.' colaboradores está negativo. <a href="/colaboradores/caixa">Clique aqui</a> para visualizar.');
    $sql = $mysqli->query("UPDATE configs SET config_msg_caixa = '$msg'");
  }
  else {
    $sql = $mysqli->query("UPDATE configs SET config_msg_caixa = ''");
  }

  echo 'Finalizou em '.date('d/m/Y - H:i:s');
?>