/**
 * Framework7 2.3.0
 * Full featured mobile HTML framework for building iOS & Android apps
 * http://framework7.io/
 *
 * Copyright 2014-2018 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: May 27, 2018
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.Framework7=t()}(this,function(){"use strict";var t7ctx;t7ctx="undefined"!=typeof window?window:"undefined"!=typeof global?global:void 0;var Template7Context=t7ctx,Template7Utils={quoteSingleRexExp:new RegExp("'","g"),quoteDoubleRexExp:new RegExp('"',"g"),isFunction:function(e){return"function"==typeof e},escape:function(e){return void 0!==Template7Context&&Template7Context.escape?Template7Context.escape(e):e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;")},helperToSlices:function(e){var t,a,n,r=Template7Utils.quoteDoubleRexExp,i=Template7Utils.quoteSingleRexExp,o=e.replace(/[{}#}]/g,"").trim().split(" "),s=[];for(a=0;a<o.length;a+=1){var l=o[a],p=void 0,c=void 0;if(0===a)s.push(l);else if(0===l.indexOf('"')||0===l.indexOf("'"))if(p=0===l.indexOf('"')?r:i,c=0===l.indexOf('"')?'"':"'",2===l.match(p).length)s.push(l);else{for(t=0,n=a+1;n<o.length;n+=1)if(l+=" "+o[n],o[n].indexOf(c)>=0){t=n,s.push(l);break}t&&(a=t)}else if(l.indexOf("=")>0){var d=l.split("="),u=d[0],h=d[1];if(p||(p=0===h.indexOf('"')?r:i,c=0===h.indexOf('"')?'"':"'"),2!==h.match(p).length){for(t=0,n=a+1;n<o.length;n+=1)if(h+=" "+o[n],o[n].indexOf(c)>=0){t=n;break}t&&(a=t)}var f=[u,h.replace(p,"")];s.push(f)}else s.push(l)}return s},stringToBlocks:function(e){var t,a,n=[];if(!e)return[];var r=e.split(/({{[^{^}]*}})/);for(t=0;t<r.length;t+=1){var i=r[t];if(""!==i)if(i.indexOf("{{")<0)n.push({type:"plain",content:i});else{if(i.indexOf("{/")>=0)continue;if((i=i.replace(/{{([#/])*([ ])*/,"{{$1").replace(/([ ])*}}/,"}}")).indexOf("{#")<0&&i.indexOf(" ")<0&&i.indexOf("else")<0){n.push({type:"variable",contextName:i.replace(/[{}]/g,"")});continue}var o=Template7Utils.helperToSlices(i),s=o[0],l=">"===s,p=[],c={};for(a=1;a<o.length;a+=1){var d=o[a];Array.isArray(d)?c[d[0]]="false"!==d[1]&&d[1]:p.push(d)}if(i.indexOf("{#")>=0){var u="",h="",f=0,m=void 0,v=!1,g=!1,b=0;for(a=t+1;a<r.length;a+=1)if(r[a].indexOf("{{#")>=0&&(b+=1),r[a].indexOf("{{/")>=0&&(b-=1),r[a].indexOf("{{#"+s)>=0)u+=r[a],g&&(h+=r[a]),f+=1;else if(r[a].indexOf("{{/"+s)>=0){if(!(f>0)){m=a,v=!0;break}f-=1,u+=r[a],g&&(h+=r[a])}else r[a].indexOf("else")>=0&&0===b?g=!0:(g||(u+=r[a]),g&&(h+=r[a]));v&&(m&&(t=m),"raw"===s?n.push({type:"plain",content:u}):n.push({type:"helper",helperName:s,contextName:p,content:u,inverseContent:h,hash:c}))}else i.indexOf(" ")>0&&(l&&(s="_partial",p[0]&&(0===p[0].indexOf("[")?p[0]=p[0].replace(/[[\]]/g,""):p[0]='"'+p[0].replace(/"|'/g,"")+'"')),n.push({type:"helper",helperName:s,contextName:p,hash:c}))}}return n},parseJsVariable:function(e,t,a){return e.split(/([+ -*/^])/g).map(function(e){if(e.indexOf(t)<0)return e;if(!a)return JSON.stringify("");var n=a;return e.indexOf(t+".")>=0&&e.split(t+".")[1].split(".").forEach(function(e){n=n[e]?n[e]:"undefined"}),JSON.stringify(n)}).join("")},parseJsParents:function(e,t){return e.split(/([+ -*^])/g).map(function(e){if(e.indexOf("../")<0)return e;if(!t||0===t.length)return JSON.stringify("");var a=e.split("../").length-1,n=a>t.length?t[t.length-1]:t[a-1];return e.replace(/..\//g,"").split(".").forEach(function(e){n=n[e]?n[e]:"undefined"}),JSON.stringify(n)}).join("")},getCompileVar:function(e,t,a){void 0===a&&(a="data_1");var n,r,i=t,o=0;0===e.indexOf("../")?(o=e.split("../").length-1,i="ctx_"+((r=i.split("_")[1]-o)>=1?r:1),n=e.split("../")[o].split(".")):0===e.indexOf("@global")?(i="Template7.global",n=e.split("@global.")[1].split(".")):0===e.indexOf("@root")?(i="root",n=e.split("@root.")[1].split(".")):n=e.split(".");for(var s=0;s<n.length;s+=1){var l=n[s];if(0===l.indexOf("@")){var p=a.split("_")[1];o>0&&(p=r),s>0?i+="[(data_"+p+" && data_"+p+"."+l.replace("@","")+")]":i="(data_"+p+" && data_"+p+"."+l.replace("@","")+")"}else(Number.isFinite?Number.isFinite(l):Template7Context.isFinite(l))?i+="["+l+"]":"this"===l||l.indexOf("this.")>=0||l.indexOf("this[")>=0||l.indexOf("this(")>=0?i=l.replace("this",t):i+="."+l}return i},getCompiledArguments:function(e,t,a){for(var n=[],r=0;r<e.length;r+=1)/^['"]/.test(e[r])?n.push(e[r]):/^(true|false|\d+)$/.test(e[r])?n.push(e[r]):n.push(Template7Utils.getCompileVar(e[r],t,a));return n.join(", ")}},Template7Helpers={_partial:function(e,t){var a=this,n=Template7Class.partials[e];return!n||n&&!n.template?"":(n.compiled||(n.compiled=new Template7Class(n.template).compile()),Object.keys(t.hash).forEach(function(e){a[e]=t.hash[e]}),n.compiled(a,t.data,t.root))},escape:function(e){if("string"!=typeof e)throw new Error('Template7: Passed context to "escape" helper should be a string');return Template7Utils.escape(e)},if:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a?t.fn(this,t.data):t.inverse(this,t.data)},unless:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a?t.inverse(this,t.data):t.fn(this,t.data)},each:function(e,t){var a=e,n="",r=0;if(Template7Utils.isFunction(a)&&(a=a.call(this)),Array.isArray(a)){for(t.hash.reverse&&(a=a.reverse()),r=0;r<a.length;r+=1)n+=t.fn(a[r],{first:0===r,last:r===a.length-1,index:r});t.hash.reverse&&(a=a.reverse())}else for(var i in a)r+=1,n+=t.fn(a[i],{key:i});return r>0?n:t.inverse(this)},with:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=e.call(this)),t.fn(a)},join:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a.join(t.hash.delimiter||t.hash.delimeter)},js:function js(expression,options){var data=options.data,func,execute=expression;return"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),a=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(a,JSON.stringify(data[e]))}}),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})",eval(func).call(this)},js_if:function js_if(expression,options){var data=options.data,func,execute=expression;"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),a=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(a,JSON.stringify(data[e]))}}),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Class.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})";var condition=eval(func).call(this);return condition?options.fn(this,options.data):options.inverse(this,options.data)}};Template7Helpers.js_compare=Template7Helpers.js_if;var Template7Options={},Template7Partials={},script=Template7Context.document.createElement("script");Template7Context.document.head.appendChild(script);var Template7Class=function(e){this.template=e},staticAccessors={options:{configurable:!0},partials:{configurable:!0},helpers:{configurable:!0}},d;function Template7(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=e[0],n=e[1];if(2===e.length){var r=new Template7Class(a),i=r.compile()(n);return r=null,i}return new Template7Class(a)}Template7Class.prototype.compile=function compile(template,depth){void 0===template&&(template=this.template),void 0===depth&&(depth=1);var t=this;if(t.compiled)return t.compiled;if("string"!=typeof template)throw new Error("Template7: Template must be a string");var stringToBlocks=Template7Utils.stringToBlocks,getCompileVar=Template7Utils.getCompileVar,getCompiledArguments=Template7Utils.getCompiledArguments,blocks=stringToBlocks(template),ctx="ctx_"+depth,data="data_"+depth;if(0===blocks.length)return function(){return""};function getCompileFn(e,a){return e.content?t.compile(e.content,a):function(){return""}}function getCompileInverse(e,a){return e.inverseContent?t.compile(e.inverseContent,a):function(){return""}}var resultString="",i;for(resultString+=1===depth?"(function ("+ctx+", "+data+", root) {\n":"(function ("+ctx+", "+data+") {\n",1===depth&&(resultString+="function isArray(arr){return Array.isArray(arr);}\n",resultString+="function isFunction(func){return (typeof func === 'function');}\n",resultString+='function c(val, ctx) {if (typeof val !== "undefined" && val !== null) {if (isFunction(val)) {return val.call(ctx);} else return val;} else return "";}\n',resultString+="root = root || ctx_1 || {};\n"),resultString+="var r = '';\n",i=0;i<blocks.length;i+=1){var block=blocks[i];if("plain"!==block.type){var variable=void 0,compiledArguments=void 0;if("variable"===block.type&&(variable=getCompileVar(block.contextName,ctx,data),resultString+="r += c("+variable+", "+ctx+");"),"helper"===block.type){var parents=void 0;if("ctx_1"!==ctx){for(var level=ctx.split("_")[1],parentsString="ctx_"+(level-1),j=level-2;j>=1;j-=1)parentsString+=", ctx_"+j;parents="["+parentsString+"]"}else parents="["+ctx+"]";var dynamicHelper=void 0;if(0===block.helperName.indexOf("[")&&(block.helperName=getCompileVar(block.helperName.replace(/[[\]]/g,""),ctx,data),dynamicHelper=!0),dynamicHelper||block.helperName in Template7Helpers)compiledArguments=getCompiledArguments(block.contextName,ctx,data),resultString+="r += (Template7Helpers"+(dynamicHelper?"["+block.helperName+"]":"."+block.helperName)+").call("+ctx+", "+(compiledArguments&&compiledArguments+", ")+"{hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});";else{if(block.contextName.length>0)throw new Error('Template7: Missing helper: "'+block.helperName+'"');variable=getCompileVar(block.helperName,ctx,data),resultString+="if ("+variable+") {",resultString+="if (isArray("+variable+")) {",resultString+="r += (Template7Helpers.each).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}else {",resultString+="r += (Template7Helpers.with).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}}"}}}else resultString+="r +='"+block.content.replace(/\r/g,"\\r").replace(/\n/g,"\\n").replace(/'/g,"\\'")+"';"}return resultString+="\nreturn r;})",1===depth?(t.compiled=eval(resultString),t.compiled):resultString},staticAccessors.options.get=function(){return Template7Options},staticAccessors.partials.get=function(){return Template7Partials},staticAccessors.helpers.get=function(){return Template7Helpers},Object.defineProperties(Template7Class,staticAccessors),Template7.registerHelper=function(e,t){Template7Class.helpers[e]=t},Template7.unregisterHelper=function(e){Template7Class.helpers[e]=void 0,delete Template7Class.helpers[e]},Template7.registerPartial=function(e,t){Template7Class.partials[e]={template:t}},Template7.unregisterPartial=function(e){Template7Class.partials[e]&&(Template7Class.partials[e]=void 0,delete Template7Class.partials[e])},Template7.compile=function(e,t){return new Template7Class(e,t).compile()},Template7.options=Template7Class.options,Template7.helpers=Template7Class.helpers,Template7.partials=Template7Class.partials,d="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document;var doc=d,w;w="undefined"==typeof window?{document:doc,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window;var win=w,Dom7=function(e){for(var t=0;t<e.length;t+=1)this[t]=e[t];return this.length=e.length,this};function $$1(e,t){var a=[],n=0;if(e&&!t&&e instanceof Dom7)return e;if(e)if("string"==typeof e){var r,i,o=e.trim();if(o.indexOf("<")>=0&&o.indexOf(">")>=0){var s="div";for(0===o.indexOf("<li")&&(s="ul"),0===o.indexOf("<tr")&&(s="tbody"),0!==o.indexOf("<td")&&0!==o.indexOf("<th")||(s="tr"),0===o.indexOf("<tbody")&&(s="table"),0===o.indexOf("<option")&&(s="select"),(i=doc.createElement(s)).innerHTML=o,n=0;n<i.childNodes.length;n+=1)a.push(i.childNodes[n])}else for(r=t||"#"!==e[0]||e.match(/[ .<>:~]/)?(t||doc).querySelectorAll(e.trim()):[doc.getElementById(e.trim().split("#")[1])],n=0;n<r.length;n+=1)r[n]&&a.push(r[n])}else if(e.nodeType||e===win||e===doc)a.push(e);else if(e.length>0&&e[0].nodeType)for(n=0;n<e.length;n+=1)a.push(e[n]);return new Dom7(a)}function unique(e){for(var t=[],a=0;a<e.length;a+=1)-1===t.indexOf(e[a])&&t.push(e[a]);return t}function toCamelCase(e){return e.toLowerCase().replace(/-(.)/g,function(e,t){return t.toUpperCase()})}function requestAnimationFrame(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)}function cancelAnimationFrame(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)}function addClass(e){if(void 0===e)return this;for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var n=0;n<this.length;n+=1)void 0!==this[n].classList&&this[n].classList.add(t[a]);return this}function removeClass(e){for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var n=0;n<this.length;n+=1)void 0!==this[n].classList&&this[n].classList.remove(t[a]);return this}function hasClass(e){return!!this[0]&&this[0].classList.contains(e)}function toggleClass(e){for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var n=0;n<this.length;n+=1)void 0!==this[n].classList&&this[n].classList.toggle(t[a]);return this}function attr(e,t){var a=arguments;if(1===arguments.length&&"string"==typeof e)return this[0]?this[0].getAttribute(e):void 0;for(var n=0;n<this.length;n+=1)if(2===a.length)this[n].setAttribute(e,t);else for(var r in e)this[n][r]=e[r],this[n].setAttribute(r,e[r]);return this}function removeAttr(e){for(var t=0;t<this.length;t+=1)this[t].removeAttribute(e);return this}function prop(e,t){var a=arguments;if(1!==arguments.length||"string"!=typeof e){for(var n=0;n<this.length;n+=1)if(2===a.length)this[n][e]=t;else for(var r in e)this[n][r]=e[r];return this}if(this[0])return this[0][e]}function data(e,t){var a;if(void 0!==t){for(var n=0;n<this.length;n+=1)(a=this[n]).dom7ElementDataStorage||(a.dom7ElementDataStorage={}),a.dom7ElementDataStorage[e]=t;return this}if(a=this[0]){if(a.dom7ElementDataStorage&&e in a.dom7ElementDataStorage)return a.dom7ElementDataStorage[e];var r=a.getAttribute("data-"+e);return r||void 0}}function removeData(e){for(var t=0;t<this.length;t+=1){var a=this[t];a.dom7ElementDataStorage&&a.dom7ElementDataStorage[e]&&(a.dom7ElementDataStorage[e]=null,delete a.dom7ElementDataStorage[e])}}function dataset(){var e=this[0];if(e){var t={};if(e.dataset)for(var a in e.dataset)t[a]=e.dataset[a];else for(var n=0;n<e.attributes.length;n+=1){var r=e.attributes[n];r.name.indexOf("data-")>=0&&(t[toCamelCase(r.name.split("data-")[1])]=r.value)}for(var i in t)"false"===t[i]?t[i]=!1:"true"===t[i]?t[i]=!0:parseFloat(t[i])===1*t[i]&&(t[i]*=1);return t}}function val(e){var t=this;if(void 0!==e){for(var a=0;a<t.length;a+=1){var n=t[a];if(Array.isArray(e)&&n.multiple&&"select"===n.nodeName.toLowerCase())for(var r=0;r<n.options.length;r+=1)n.options[r].selected=e.indexOf(n.options[r].value)>=0;else n.value=e}return t}if(t[0]){if(t[0].multiple&&"select"===t[0].nodeName.toLowerCase()){for(var i=[],o=0;o<t[0].selectedOptions.length;o+=1)i.push(t[0].selectedOptions[o].value);return i}return t[0].value}}function transform(e){for(var t=0;t<this.length;t+=1){var a=this[t].style;a.webkitTransform=e,a.transform=e}return this}function transition(e){"string"!=typeof e&&(e+="ms");for(var t=0;t<this.length;t+=1){var a=this[t].style;a.webkitTransitionDuration=e,a.transitionDuration=e}return this}function on(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2],o=t[3];function s(e){var t=e.target;if(t){var a=e.target.dom7EventData||[];if(a.indexOf(e)<0&&a.unshift(e),$$1(t).is(r))i.apply(t,a);else for(var n=$$1(t).parents(),o=0;o<n.length;o+=1)$$1(n[o]).is(r)&&i.apply(n[o],a)}}function l(e){var t=e&&e.target&&e.target.dom7EventData||[];t.indexOf(e)<0&&t.unshift(e),i.apply(this,t)}"function"==typeof t[1]&&(n=(e=t)[0],i=e[1],o=e[2],r=void 0),o||(o=!1);for(var p,c=n.split(" "),d=0;d<this.length;d+=1){var u=this[d];if(r)for(p=0;p<c.length;p+=1){var h=c[p];u.dom7LiveListeners||(u.dom7LiveListeners={}),u.dom7LiveListeners[h]||(u.dom7LiveListeners[h]=[]),u.dom7LiveListeners[h].push({listener:i,proxyListener:s}),u.addEventListener(h,s,o)}else for(p=0;p<c.length;p+=1){var f=c[p];u.dom7Listeners||(u.dom7Listeners={}),u.dom7Listeners[f]||(u.dom7Listeners[f]=[]),u.dom7Listeners[f].push({listener:i,proxyListener:l}),u.addEventListener(f,l,o)}}return this}function off(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2],o=t[3];"function"==typeof t[1]&&(n=(e=t)[0],i=e[1],o=e[2],r=void 0),o||(o=!1);for(var s=n.split(" "),l=0;l<s.length;l+=1)for(var p=s[l],c=0;c<this.length;c+=1){var d=this[c],u=void 0;if(!r&&d.dom7Listeners?u=d.dom7Listeners[p]:r&&d.dom7LiveListeners&&(u=d.dom7LiveListeners[p]),u&&u.length)for(var h=u.length-1;h>=0;h-=1){var f=u[h];i&&f.listener===i?(d.removeEventListener(p,f.proxyListener,o),u.splice(h,1)):i||(d.removeEventListener(p,f.proxyListener,o),u.splice(h,1))}}return this}function once(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=this,r=t[0],i=t[1],o=t[2],s=t[3];return"function"==typeof t[1]&&(r=(e=t)[0],o=e[1],s=e[2],i=void 0),n.on(r,i,function e(){for(var t=[],a=arguments.length;a--;)t[a]=arguments[a];o.apply(this,t),n.off(r,i,e,s)},s)}function trigger(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];for(var a=e[0].split(" "),n=e[1],r=0;r<a.length;r+=1)for(var i=a[r],o=0;o<this.length;o+=1){var s=this[o],l=void 0;try{l=new win.CustomEvent(i,{detail:n,bubbles:!0,cancelable:!0})}catch(e){(l=doc.createEvent("Event")).initEvent(i,!0,!0),l.detail=n}s.dom7EventData=e.filter(function(e,t){return t>0}),s.dispatchEvent(l),s.dom7EventData=[],delete s.dom7EventData}return this}function transitionEnd(e){var t,a=["webkitTransitionEnd","transitionend"],n=this;function r(i){if(i.target===this)for(e.call(this,i),t=0;t<a.length;t+=1)n.off(a[t],r)}if(e)for(t=0;t<a.length;t+=1)n.on(a[t],r);return this}function animationEnd(e){var t,a=["webkitAnimationEnd","animationend"],n=this;function r(i){if(i.target===this)for(e.call(this,i),t=0;t<a.length;t+=1)n.off(a[t],r)}if(e)for(t=0;t<a.length;t+=1)n.on(a[t],r);return this}function width(){return this[0]===win?win.innerWidth:this.length>0?parseFloat(this.css("width")):null}function outerWidth(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetWidth+parseFloat(t.getPropertyValue("margin-right"))+parseFloat(t.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null}function height(){return this[0]===win?win.innerHeight:this.length>0?parseFloat(this.css("height")):null}function outerHeight(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetHeight+parseFloat(t.getPropertyValue("margin-top"))+parseFloat(t.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null}function offset(){if(this.length>0){var e=this[0],t=e.getBoundingClientRect(),a=doc.body,n=e.clientTop||a.clientTop||0,r=e.clientLeft||a.clientLeft||0,i=e===win?win.scrollY:e.scrollTop,o=e===win?win.scrollX:e.scrollLeft;return{top:t.top+i-n,left:t.left+o-r}}return null}function hide(){for(var e=0;e<this.length;e+=1)this[e].style.display="none";return this}function show(){for(var e=0;e<this.length;e+=1){var t=this[e];"none"===t.style.display&&(t.style.display=""),"none"===win.getComputedStyle(t,null).getPropertyValue("display")&&(t.style.display="block")}return this}function styles(){return this[0]?win.getComputedStyle(this[0],null):{}}function css(e,t){var a;if(1===arguments.length){if("string"!=typeof e){for(a=0;a<this.length;a+=1)for(var n in e)this[a].style[n]=e[n];return this}if(this[0])return win.getComputedStyle(this[0],null).getPropertyValue(e)}if(2===arguments.length&&"string"==typeof e){for(a=0;a<this.length;a+=1)this[a].style[e]=t;return this}return this}function toArray(){for(var e=[],t=0;t<this.length;t+=1)e.push(this[t]);return e}function each(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],t,this[t]))return this;return this}function forEach(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],this[t],t))return this;return this}function filter(e){for(var t=[],a=0;a<this.length;a+=1)e.call(this[a],a,this[a])&&t.push(this[a]);return new Dom7(t)}function map(e){for(var t=[],a=0;a<this.length;a+=1)t.push(e.call(this[a],a,this[a]));return new Dom7(t)}function html(e){if(void 0===e)return this[0]?this[0].innerHTML:void 0;for(var t=0;t<this.length;t+=1)this[t].innerHTML=e;return this}function text(e){if(void 0===e)return this[0]?this[0].textContent.trim():null;for(var t=0;t<this.length;t+=1)this[t].textContent=e;return this}function is(e){var t,a,n=this[0];if(!n||void 0===e)return!1;if("string"==typeof e){if(n.matches)return n.matches(e);if(n.webkitMatchesSelector)return n.webkitMatchesSelector(e);if(n.msMatchesSelector)return n.msMatchesSelector(e);for(t=$$1(e),a=0;a<t.length;a+=1)if(t[a]===n)return!0;return!1}if(e===doc)return n===doc;if(e===win)return n===win;if(e.nodeType||e instanceof Dom7){for(t=e.nodeType?[e]:e,a=0;a<t.length;a+=1)if(t[a]===n)return!0;return!1}return!1}function indexOf(e){for(var t=0;t<this.length;t+=1)if(this[t]===e)return t;return-1}function index(){var e,t=this[0];if(t){for(e=0;null!==(t=t.previousSibling);)1===t.nodeType&&(e+=1);return e}}function eq(e){if(void 0===e)return this;var t,a=this.length;return new Dom7(e>a-1?[]:e<0?(t=a+e)<0?[]:[this[t]]:[this[e]])}function append(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];for(var n=0;n<t.length;n+=1){e=t[n];for(var r=0;r<this.length;r+=1)if("string"==typeof e){var i=doc.createElement("div");for(i.innerHTML=e;i.firstChild;)this[r].appendChild(i.firstChild)}else if(e instanceof Dom7)for(var o=0;o<e.length;o+=1)this[r].appendChild(e[o]);else this[r].appendChild(e)}return this}function appendTo(e){return $$1(e).append(this),this}function prepend(e){var t,a,n=this;for(t=0;t<this.length;t+=1)if("string"==typeof e){var r=doc.createElement("div");for(r.innerHTML=e,a=r.childNodes.length-1;a>=0;a-=1)n[t].insertBefore(r.childNodes[a],n[t].childNodes[0])}else if(e instanceof Dom7)for(a=0;a<e.length;a+=1)n[t].insertBefore(e[a],n[t].childNodes[0]);else n[t].insertBefore(e,n[t].childNodes[0]);return this}function prependTo(e){return $$1(e).prepend(this),this}function insertBefore(e){for(var t=$$1(e),a=0;a<this.length;a+=1)if(1===t.length)t[0].parentNode.insertBefore(this[a],t[0]);else if(t.length>1)for(var n=0;n<t.length;n+=1)t[n].parentNode.insertBefore(this[a].cloneNode(!0),t[n])}function insertAfter(e){for(var t=$$1(e),a=0;a<this.length;a+=1)if(1===t.length)t[0].parentNode.insertBefore(this[a],t[0].nextSibling);else if(t.length>1)for(var n=0;n<t.length;n+=1)t[n].parentNode.insertBefore(this[a].cloneNode(!0),t[n].nextSibling)}function next(e){return this.length>0?e?this[0].nextElementSibling&&$$1(this[0].nextElementSibling).is(e)?new Dom7([this[0].nextElementSibling]):new Dom7([]):this[0].nextElementSibling?new Dom7([this[0].nextElementSibling]):new Dom7([]):new Dom7([])}function nextAll(e){var t=[],a=this[0];if(!a)return new Dom7([]);for(;a.nextElementSibling;){var n=a.nextElementSibling;e?$$1(n).is(e)&&t.push(n):t.push(n),a=n}return new Dom7(t)}function prev(e){if(this.length>0){var t=this[0];return e?t.previousElementSibling&&$$1(t.previousElementSibling).is(e)?new Dom7([t.previousElementSibling]):new Dom7([]):t.previousElementSibling?new Dom7([t.previousElementSibling]):new Dom7([])}return new Dom7([])}function prevAll(e){var t=[],a=this[0];if(!a)return new Dom7([]);for(;a.previousElementSibling;){var n=a.previousElementSibling;e?$$1(n).is(e)&&t.push(n):t.push(n),a=n}return new Dom7(t)}function siblings(e){return this.nextAll(e).add(this.prevAll(e))}function parent(e){for(var t=[],a=0;a<this.length;a+=1)null!==this[a].parentNode&&(e?$$1(this[a].parentNode).is(e)&&t.push(this[a].parentNode):t.push(this[a].parentNode));return $$1(unique(t))}function parents(e){for(var t=[],a=0;a<this.length;a+=1)for(var n=this[a].parentNode;n;)e?$$1(n).is(e)&&t.push(n):t.push(n),n=n.parentNode;return $$1(unique(t))}function closest(e){var t=this;return void 0===e?new Dom7([]):(t.is(e)||(t=t.parents(e).eq(0)),t)}function find(e){for(var t=[],a=0;a<this.length;a+=1)for(var n=this[a].querySelectorAll(e),r=0;r<n.length;r+=1)t.push(n[r]);return new Dom7(t)}function children(e){for(var t=[],a=0;a<this.length;a+=1)for(var n=this[a].childNodes,r=0;r<n.length;r+=1)e?1===n[r].nodeType&&$$1(n[r]).is(e)&&t.push(n[r]):1===n[r].nodeType&&t.push(n[r]);return new Dom7(unique(t))}function remove(){for(var e=0;e<this.length;e+=1)this[e].parentNode&&this[e].parentNode.removeChild(this[e]);return this}function detach(){return this.remove()}function add(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,n;for(a=0;a<e.length;a+=1){var r=$$1(e[a]);for(n=0;n<r.length;n+=1)this[this.length]=r[n],this.length+=1}return this}function empty(){for(var e=0;e<this.length;e+=1){var t=this[e];if(1===t.nodeType){for(var a=0;a<t.childNodes.length;a+=1)t.childNodes[a].parentNode&&t.childNodes[a].parentNode.removeChild(t.childNodes[a]);t.textContent=""}}return this}$$1.fn=Dom7.prototype,$$1.Class=Dom7,$$1.Dom7=Dom7;var Methods=Object.freeze({addClass:addClass,removeClass:removeClass,hasClass:hasClass,toggleClass:toggleClass,attr:attr,removeAttr:removeAttr,prop:prop,data:data,removeData:removeData,dataset:dataset,val:val,transform:transform,transition:transition,on:on,off:off,once:once,trigger:trigger,transitionEnd:transitionEnd,animationEnd:animationEnd,width:width,outerWidth:outerWidth,height:height,outerHeight:outerHeight,offset:offset,hide:hide,show:show,styles:styles,css:css,toArray:toArray,each:each,forEach:forEach,filter:filter,map:map,html:html,text:text,is:is,indexOf:indexOf,index:index,eq:eq,append:append,appendTo:appendTo,prepend:prepend,prependTo:prependTo,insertBefore:insertBefore,insertAfter:insertAfter,next:next,nextAll:nextAll,prev:prev,prevAll:prevAll,siblings:siblings,parent:parent,parents:parents,closest:closest,find:find,children:children,remove:remove,detach:detach,add:add,empty:empty});function scrollTo(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2],o=t[3],s=t[4];return 4===t.length&&"function"==typeof o&&(s=o,n=(e=t)[0],r=e[1],i=e[2],s=e[3],o=e[4]),void 0===o&&(o="swing"),this.each(function(){var e,t,a,l,p,c,d,u,h=this,f=r>0||0===r,m=n>0||0===n;if(void 0===o&&(o="swing"),f&&(e=h.scrollTop,i||(h.scrollTop=r)),m&&(t=h.scrollLeft,i||(h.scrollLeft=n)),i){f&&(a=h.scrollHeight-h.offsetHeight,p=Math.max(Math.min(r,a),0)),m&&(l=h.scrollWidth-h.offsetWidth,c=Math.max(Math.min(n,l),0));var v=null;f&&p===e&&(f=!1),m&&c===t&&(m=!1),requestAnimationFrame(function a(n){void 0===n&&(n=(new Date).getTime()),null===v&&(v=n);var r,l=Math.max(Math.min((n-v)/i,1),0),g="linear"===o?l:.5-Math.cos(l*Math.PI)/2;f&&(d=e+g*(p-e)),m&&(u=t+g*(c-t)),f&&p>e&&d>=p&&(h.scrollTop=p,r=!0),f&&p<e&&d<=p&&(h.scrollTop=p,r=!0),m&&c>t&&u>=c&&(h.scrollLeft=c,r=!0),m&&c<t&&u<=c&&(h.scrollLeft=c,r=!0),r?s&&s():(f&&(h.scrollTop=d),m&&(h.scrollLeft=u),requestAnimationFrame(a))})}})}function scrollTop(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2],o=t[3];3===t.length&&"function"==typeof i&&(n=(e=t)[0],r=e[1],o=e[2],i=e[3]);return void 0===n?this.length>0?this[0].scrollTop:null:this.scrollTo(void 0,n,r,i,o)}function scrollLeft(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2],o=t[3];3===t.length&&"function"==typeof i&&(n=(e=t)[0],r=e[1],o=e[2],i=e[3]);return void 0===n?this.length>0?this[0].scrollLeft:null:this.scrollTo(n,void 0,r,i,o)}var Scroll=Object.freeze({scrollTo:scrollTo,scrollTop:scrollTop,scrollLeft:scrollLeft});function animate(e,t){var a,n=this,r={props:Object.assign({},e),params:Object.assign({duration:300,easing:"swing"},t),elements:n,animating:!1,que:[],easingProgress:function(e,t){return"swing"===e?.5-Math.cos(t*Math.PI)/2:"function"==typeof e?e(t):t},stop:function(){r.frameId&&cancelAnimationFrame(r.frameId),r.animating=!1,r.elements.each(function(e,t){delete t.dom7AnimateInstance}),r.que=[]},done:function(e){if(r.animating=!1,r.elements.each(function(e,t){delete t.dom7AnimateInstance}),e&&e(n),r.que.length>0){var t=r.que.shift();r.animate(t[0],t[1])}},animate:function(e,t){if(r.animating)return r.que.push([e,t]),r;var a=[];r.elements.each(function(t,n){var i,o,s,l,p;n.dom7AnimateInstance||(r.elements[t].dom7AnimateInstance=r),a[t]={container:n},Object.keys(e).forEach(function(r){i=win.getComputedStyle(n,null).getPropertyValue(r).replace(",","."),o=parseFloat(i),s=i.replace(o,""),l=parseFloat(e[r]),p=e[r]+s,a[t][r]={initialFullValue:i,initialValue:o,unit:s,finalValue:l,finalFullValue:p,currentValue:o}})});var i,o,s=null,l=0,p=0,c=!1;return r.animating=!0,r.frameId=requestAnimationFrame(function d(){var u,h;i=(new Date).getTime(),c||(c=!0,t.begin&&t.begin(n)),null===s&&(s=i),t.progress&&t.progress(n,Math.max(Math.min((i-s)/t.duration,1),0),s+t.duration-i<0?0:s+t.duration-i,s),a.forEach(function(n){var c=n;o||c.done||Object.keys(e).forEach(function(n){if(!o&&!c.done){u=Math.max(Math.min((i-s)/t.duration,1),0),h=r.easingProgress(t.easing,u);var d=c[n],f=d.initialValue,m=d.finalValue,v=d.unit;c[n].currentValue=f+h*(m-f);var g=c[n].currentValue;(m>f&&g>=m||m<f&&g<=m)&&(c.container.style[n]=m+v,(p+=1)===Object.keys(e).length&&(c.done=!0,l+=1),l===a.length&&(o=!0)),o?r.done(t.complete):c.container.style[n]=g+v}})}),o||(r.frameId=requestAnimationFrame(d))}),r}};if(0===r.elements.length)return n;for(var i=0;i<r.elements.length;i+=1)r.elements[i].dom7AnimateInstance?a=r.elements[i].dom7AnimateInstance:r.elements[i].dom7AnimateInstance=r;return a||(a=r),"stop"===e?a.stop():a.animate(r.props,r.params),n}function stop(){for(var e=0;e<this.length;e+=1)this[e].dom7AnimateInstance&&this[e].dom7AnimateInstance.stop()}var Animate=Object.freeze({animate:animate,stop:stop}),noTrigger="resize scroll".split(" ");function eventShortcut(e){for(var t,a=[],n=arguments.length-1;n-- >0;)a[n]=arguments[n+1];if(void 0===a[0]){for(var r=0;r<this.length;r+=1)noTrigger.indexOf(e)<0&&(e in this[r]?this[r][e]():$$1(this[r]).trigger(e));return this}return(t=this).on.apply(t,[e].concat(a))}function click(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["click"].concat(e))}function blur(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["blur"].concat(e))}function focus(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focus"].concat(e))}function focusin(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusin"].concat(e))}function focusout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusout"].concat(e))}function keyup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keyup"].concat(e))}function keydown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keydown"].concat(e))}function keypress(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keypress"].concat(e))}function submit(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["submit"].concat(e))}function change(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["change"].concat(e))}function mousedown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousedown"].concat(e))}function mousemove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousemove"].concat(e))}function mouseup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseup"].concat(e))}function mouseenter(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseenter"].concat(e))}function mouseleave(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseleave"].concat(e))}function mouseout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseout"].concat(e))}function mouseover(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseover"].concat(e))}function touchstart(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchstart"].concat(e))}function touchend(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchend"].concat(e))}function touchmove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchmove"].concat(e))}function resize(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["resize"].concat(e))}function scroll(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["scroll"].concat(e))}var eventShortcuts=Object.freeze({click:click,blur:blur,focus:focus,focusin:focusin,focusout:focusout,keyup:keyup,keydown:keydown,keypress:keypress,submit:submit,change:change,mousedown:mousedown,mousemove:mousemove,mouseup:mouseup,mouseenter:mouseenter,mouseleave:mouseleave,mouseout:mouseout,mouseover:mouseover,touchstart:touchstart,touchend:touchend,touchmove:touchmove,resize:resize,scroll:scroll});[Methods,Scroll,Animate,eventShortcuts].forEach(function(e){Object.keys(e).forEach(function(t){$$1.fn[t]=e[t]})});var NEWTON_ITERATIONS=4,NEWTON_MIN_SLOPE=.001,SUBDIVISION_PRECISION=1e-7,SUBDIVISION_MAX_ITERATIONS=10,kSplineTableSize=11,kSampleStepSize=1/(kSplineTableSize-1),float32ArraySupported="function"==typeof Float32Array;function A(e,t){return 1-3*t+3*e}function B(e,t){return 3*t-6*e}function C(e){return 3*e}function calcBezier(e,t,a){return((A(t,a)*e+B(t,a))*e+C(t))*e}function getSlope(e,t,a){return 3*A(t,a)*e*e+2*B(t,a)*e+C(t)}function binarySubdivide(e,t,a,n,r){var i,o,s=0;do{(i=calcBezier(o=t+(a-t)/2,n,r)-e)>0?a=o:t=o}while(Math.abs(i)>SUBDIVISION_PRECISION&&++s<SUBDIVISION_MAX_ITERATIONS);return o}function newtonRaphsonIterate(e,t,a,n){for(var r=0;r<NEWTON_ITERATIONS;++r){var i=getSlope(t,a,n);if(0===i)return t;t-=(calcBezier(t,a,n)-e)/i}return t}function bezier(e,t,a,n){if(!(0<=e&&e<=1&&0<=a&&a<=1))throw new Error("bezier x values must be in [0, 1] range");var r=float32ArraySupported?new Float32Array(kSplineTableSize):new Array(kSplineTableSize);if(e!==t||a!==n)for(var i=0;i<kSplineTableSize;++i)r[i]=calcBezier(i*kSampleStepSize,e,a);return function(i){return e===t&&a===n?i:0===i?0:1===i?1:calcBezier(function(t){for(var n=0,i=1,o=kSplineTableSize-1;i!==o&&r[i]<=t;++i)n+=kSampleStepSize;var s=n+(t-r[--i])/(r[i+1]-r[i])*kSampleStepSize,l=getSlope(s,e,a);return l>=NEWTON_MIN_SLOPE?newtonRaphsonIterate(t,s,e,a):0===l?s:binarySubdivide(t,n,n+kSampleStepSize,e,a)}(i),t,n)}}for(var defaultDiacriticsRemovalap=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],diacriticsMap={},i=0;i<defaultDiacriticsRemovalap.length;i+=1)for(var letters=defaultDiacriticsRemovalap[i].letters,j=0;j<letters.length;j+=1)diacriticsMap[letters[j]]=defaultDiacriticsRemovalap[i].base;var createPromise=function(e){var t,a,n=!1,r=!1,i={then:void 0,catch:void 0},o={then:function(e){return n?e.apply(void 0,t):i.then=e,o},catch:function(e){return r?e.apply(void 0,a):i.catch=e,o}};return e(function(){for(var e=[],a=arguments.length;a--;)e[a]=arguments[a];n=!0,i.then?i.then.apply(i,e):t=e},function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];r=!0,i.catch?i.catch.apply(i,e):a=e}),o},Utils={mdPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-gap"></span>\n      <span class="preloader-inner-left">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n      <span class="preloader-inner-right">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n    </span>\n  '.trim(),eventNameToColonCase:function(e){var t;return e.split("").map(function(e,a){return e.match(/[A-Z]/)&&0!==a&&!t?(t=!0,":"+e.toLowerCase()):e.toLowerCase()}).join("")},deleteProps:function(e){var t=e;Object.keys(t).forEach(function(e){try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}})},bezier:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return bezier.apply(void 0,e)},nextTick:function(e,t){return void 0===t&&(t=0),setTimeout(e,t)},nextFrame:function(e){return Utils.requestAnimationFrame(e)},now:function(){return Date.now()},promise:function(e){return win.Promise?new Promise(e):createPromise(e)},requestAnimationFrame:function(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)},cancelAnimationFrame:function(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)},removeDiacritics:function(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return diacriticsMap[e]||e})},parseUrlQuery:function(e){var t,a,n,r,i={},o=e||win.location.href;if("string"==typeof o&&o.length)for(r=(a=(o=o.indexOf("?")>-1?o.replace(/\S*\?/,""):"").split("&").filter(function(e){return""!==e})).length,t=0;t<r;t+=1)n=a[t].replace(/#\S+/g,"").split("="),i[decodeURIComponent(n[0])]=void 0===n[1]?void 0:decodeURIComponent(n[1])||"";return i},getTranslate:function(e,t){var a,n,r;void 0===t&&(t="x");var i=win.getComputedStyle(e,null);return win.WebKitCSSMatrix?((n=i.transform||i.webkitTransform).split(",").length>6&&(n=n.split(", ").map(function(e){return e.replace(",",".")}).join(", ")),r=new win.WebKitCSSMatrix("none"===n?"":n)):a=(r=i.MozTransform||i.OTransform||i.MsTransform||i.msTransform||i.transform||i.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,")).toString().split(","),"x"===t&&(n=win.WebKitCSSMatrix?r.m41:16===a.length?parseFloat(a[12]):parseFloat(a[4])),"y"===t&&(n=win.WebKitCSSMatrix?r.m42:16===a.length?parseFloat(a[13]):parseFloat(a[5])),n||0},serializeObject:function(e,t){if(void 0===t&&(t=[]),"string"==typeof e)return e;var a,n=[];function r(e){if(t.length>0){for(var a="",n=0;n<t.length;n+=1)a+=0===n?t[n]:"["+encodeURIComponent(t[n])+"]";return a+"["+encodeURIComponent(e)+"]"}return encodeURIComponent(e)}function i(e){return encodeURIComponent(e)}return Object.keys(e).forEach(function(o){var s;if(Array.isArray(e[o])){s=[];for(var l=0;l<e[o].length;l+=1)Array.isArray(e[o][l])||"object"!=typeof e[o][l]?s.push(r(o)+"[]="+i(e[o][l])):((a=t.slice()).push(o),a.push(String(l)),s.push(Utils.serializeObject(e[o][l],a)));s.length>0&&n.push(s.join("&"))}else null===e[o]||""===e[o]?n.push(r(o)+"="):"object"==typeof e[o]?((a=t.slice()).push(o),""!==(s=Utils.serializeObject(e[o],a))&&n.push(s)):void 0!==e[o]&&""!==e[o]?n.push(r(o)+"="+i(e[o])):""===e[o]&&n.push(r(o))}),n.join("&")},isObject:function(e){return"object"==typeof e&&null!==e&&e.constructor&&e.constructor===Object},merge:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=e[0];e.splice(0,1);for(var n=e,r=0;r<n.length;r+=1){var i=e[r];if(void 0!==i&&null!==i)for(var o=Object.keys(Object(i)),s=0,l=o.length;s<l;s+=1){var p=o[s],c=Object.getOwnPropertyDescriptor(i,p);void 0!==c&&c.enumerable&&(a[p]=i[p])}}return a},extend:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,n,r=!0;"boolean"==typeof e[0]?(r=e[0],a=e[1],e.splice(0,2),n=e):(a=e[0],e.splice(0,1),n=e);for(var i=0;i<n.length;i+=1){var o=e[i];if(void 0!==o&&null!==o)for(var s=Object.keys(Object(o)),l=0,p=s.length;l<p;l+=1){var c=s[l],d=Object.getOwnPropertyDescriptor(o,c);void 0!==d&&d.enumerable&&(r?Utils.isObject(a[c])&&Utils.isObject(o[c])?Utils.extend(a[c],o[c]):!Utils.isObject(a[c])&&Utils.isObject(o[c])?(a[c]={},Utils.extend(a[c],o[c])):a[c]=o[c]:a[c]=o[c])}}return a}},Device=function(){var e=win.navigator.userAgent,t={ios:!1,android:!1,androidChrome:!1,desktop:!1,windows:!1,iphone:!1,iphoneX:!1,ipod:!1,ipad:!1,cordova:win.cordova||win.phonegap,phonegap:win.cordova||win.phonegap},a=e.match(/(Windows Phone);?[\s\/]+([\d.]+)?/),n=e.match(/(Android);?[\s\/]+([\d.]+)?/),r=e.match(/(iPad).*OS\s([\d_]+)/),i=e.match(/(iPod)(.*OS\s([\d_]+))?/),o=!r&&e.match(/(iPhone\sOS|iOS)\s([\d_]+)/),s=o&&375===win.screen.width&&812===win.screen.height;if(a&&(t.os="windows",t.osVersion=a[2],t.windows=!0),n&&!a&&(t.os="android",t.osVersion=n[2],t.android=!0,t.androidChrome=e.toLowerCase().indexOf("chrome")>=0),(r||o||i)&&(t.os="ios",t.ios=!0),o&&!i&&(t.osVersion=o[2].replace(/_/g,"."),t.iphone=!0,t.iphoneX=s),r&&(t.osVersion=r[2].replace(/_/g,"."),t.ipad=!0),i&&(t.osVersion=i[3]?i[3].replace(/_/g,"."):null,t.iphone=!0),t.ios&&t.osVersion&&e.indexOf("Version/")>=0&&"10"===t.osVersion.split(".")[0]&&(t.osVersion=e.toLowerCase().split("version/")[1].split(" ")[0]),t.webView=(o||r||i)&&(e.match(/.*AppleWebKit(?!.*Safari)/i)||win.navigator.standalone),t.webview=t.webView,t.desktop=!(t.os||t.android||t.webView),t.os&&"ios"===t.os){var l=t.osVersion.split("."),p=doc.querySelector('meta[name="viewport"]');t.minimalUi=!t.webView&&(i||o)&&(1*l[0]==7?1*l[1]>=1:1*l[0]>7)&&p&&p.getAttribute("content").indexOf("minimal-ui")>=0}return t.needsStatusbarOverlay=function(){return!(!(t.webView||t.android&&t.cordova)||win.innerWidth*win.innerHeight!=win.screen.width*win.screen.height)&&(!t.iphoneX||90!==win.orientation&&-90!==win.orientation)},t.statusbar=t.needsStatusbarOverlay(),t.pixelRatio=win.devicePixelRatio||1,t}(),Framework7Class=function(e,t){void 0===e&&(e={}),void 0===t&&(t=[]);var a=this;a.params=e,a.eventsParents=t,a.eventsListeners={},a.params&&a.params.on&&Object.keys(a.params.on).forEach(function(e){a.on(e,a.params.on[e])})},staticAccessors$1={components:{configurable:!0}};Framework7Class.prototype.on=function(e,t,a){var n=this;if("function"!=typeof t)return n;var r=a?"unshift":"push";return e.split(" ").forEach(function(e){n.eventsListeners[e]||(n.eventsListeners[e]=[]),n.eventsListeners[e][r](t)}),n},Framework7Class.prototype.once=function(e,t,a){var n=this;if("function"!=typeof t)return n;return n.on(e,function a(){for(var r=[],i=arguments.length;i--;)r[i]=arguments[i];t.apply(n,r),n.off(e,a)},a)},Framework7Class.prototype.off=function(e,t){var a=this;return a.eventsListeners?(e.split(" ").forEach(function(e){void 0===t?a.eventsListeners[e]=[]:a.eventsListeners[e].forEach(function(n,r){n===t&&a.eventsListeners[e].splice(r,1)})}),a):a},Framework7Class.prototype.emit=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,n,r,i,o=this;if(!o.eventsListeners)return o;"string"==typeof e[0]||Array.isArray(e[0])?(a=e[0],n=e.slice(1,e.length),r=o,i=o.eventsParents):(a=e[0].events,n=e[0].data,r=e[0].context||o,i=e[0].local?[]:e[0].parents||o.eventsParents);var s=Array.isArray(a)?a:a.split(" "),l=s.map(function(e){return e.replace("local::","")}),p=s.filter(function(e){return e.indexOf("local::")<0});return l.forEach(function(e){if(o.eventsListeners&&o.eventsListeners[e]){var t=[];o.eventsListeners[e].forEach(function(e){t.push(e)}),t.forEach(function(e){e.apply(r,n)})}}),i&&i.length>0&&i.forEach(function(e){e.emit.apply(e,[p].concat(n))}),o},Framework7Class.prototype.useModulesParams=function(e){var t=this;t.modules&&Object.keys(t.modules).forEach(function(a){var n=t.modules[a];n.params&&Utils.extend(e,n.params)})},Framework7Class.prototype.useModules=function(e){void 0===e&&(e={});var t=this;t.modules&&Object.keys(t.modules).forEach(function(a){var n=t.modules[a],r=e[a]||{};n.instance&&Object.keys(n.instance).forEach(function(e){var a=n.instance[e];t[e]="function"==typeof a?a.bind(t):a}),n.on&&t.on&&Object.keys(n.on).forEach(function(e){t.on(e,n.on[e])}),n.create&&n.create.bind(t)(r)})},staticAccessors$1.components.set=function(e){this.use&&this.use(e)},Framework7Class.installModule=function(e){for(var t=[],a=arguments.length-1;a-- >0;)t[a]=arguments[a+1];var n=this;n.prototype.modules||(n.prototype.modules={});var r=e.name||Object.keys(n.prototype.modules).length+"_"+Utils.now();return n.prototype.modules[r]=e,e.proto&&Object.keys(e.proto).forEach(function(t){n.prototype[t]=e.proto[t]}),e.static&&Object.keys(e.static).forEach(function(t){n[t]=e.static[t]}),e.install&&e.install.apply(n,t),n},Framework7Class.use=function(e){for(var t=[],a=arguments.length-1;a-- >0;)t[a]=arguments[a+1];var n=this;return Array.isArray(e)?(e.forEach(function(e){return n.installModule(e)}),n):n.installModule.apply(n,[e].concat(t))},Object.defineProperties(Framework7Class,staticAccessors$1);var Framework7=function(e){function t(t){e.call(this,t);var a=Utils.extend({},t),n=this,r={version:"1.0.0",id:"io.framework7.testapp",root:"body",theme:"auto",language:win.navigator.language,routes:[],name:"Framework7",initOnDeviceReady:!0,init:!0};n.useModulesParams(r),n.params=Utils.extend(r,t);var i=$$1(n.params.root);return Utils.extend(n,{id:n.params.id,name:n.params.name,version:n.params.version,routes:n.params.routes,language:n.params.language,root:i,rtl:"rtl"===i.css("direction"),theme:"auto"===n.params.theme?Device.ios?"ios":"md":n.params.theme,passedParams:a}),n.root&&n.root[0]&&(n.root[0].f7=n),n.useModules(),n.params.init&&(Device.cordova&&n.params.initOnDeviceReady?$$1(doc).on("deviceready",function(){n.init()}):n.init()),n}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={$:{configurable:!0},t7:{configurable:!0}},n={Dom7:{configurable:!0},$:{configurable:!0},Template7:{configurable:!0},Class:{configurable:!0}};return t.prototype.init=function(){var e=this;e.initialized||(e.root.addClass("framework7-initializing"),e.rtl&&$$1("html").attr("dir","rtl"),e.root.addClass("framework7-root"),$$1("html").removeClass("ios md").addClass(e.theme),e.data={},e.params.data&&"function"==typeof e.params.data?Utils.extend(e.data,e.params.data.bind(e)()):e.params.data&&Utils.extend(e.data,e.params.data),e.methods={},e.params.methods&&Utils.extend(e.methods,e.params.methods),Utils.nextFrame(function(){e.root.removeClass("framework7-initializing")}),e.initialized=!0,e.emit("init"))},a.$.get=function(){return $$1},a.t7.get=function(){return Template7},n.Dom7.get=function(){return $$1},n.$.get=function(){return $$1},n.Template7.get=function(){return Template7},n.Class.get=function(){return e},Object.defineProperties(t.prototype,a),Object.defineProperties(t,n),t}(Framework7Class),DeviceModule={name:"device",proto:{device:Device},static:{device:Device},on:{init:function(){var e=[],t=doc.querySelector("html");if(t){if(e.push("device-pixel-ratio-"+Math.floor(Device.pixelRatio)),Device.pixelRatio>=2&&e.push("device-retina"),Device.os){if(e.push("device-"+Device.os,"device-"+Device.os+"-"+Device.osVersion.split(".")[0],"device-"+Device.os+"-"+Device.osVersion.replace(/\./g,"-")),"ios"===Device.os){for(var a=parseInt(Device.osVersion.split(".")[0],10)-1;a>=6;a-=1)e.push("device-ios-gt-"+a);Device.iphoneX&&e.push("device-iphone-x")}}else Device.desktop&&e.push("device-desktop");(Device.cordova||Device.phonegap)&&e.push("device-cordova"),e.forEach(function(e){t.classList.add(e)})}}}},Support=(Xo=!1,Yo=doc.createElement("div"),"sticky -webkit-sticky -moz-sticky".split(" ").forEach(function(e){Xo||(Yo.style.position=e,Yo.style.position===e&&(Xo=!0))}),Uo=Xo,Vo=doc.createElement("div"),{positionSticky:Uo,touch:!!("ontouchstart"in win||win.DocumentTouch&&doc instanceof win.DocumentTouch),pointerEvents:!(!win.navigator.pointerEnabled&&!win.PointerEvent),prefixedPointerEvents:!!win.navigator.msPointerEnabled,transition:(ap=Vo.style,"transition"in ap||"webkitTransition"in ap||"MozTransition"in ap),transforms3d:win.Modernizr&&!0===win.Modernizr.csstransforms3d||(cp=Vo.style,"webkitPerspective"in cp||"MozPerspective"in cp||"OPerspective"in cp||"MsPerspective"in cp||"perspective"in cp),flexbox:function(){for(var e=doc.createElement("div").style,t="alignItems webkitAlignItems webkitBoxAlign msFlexAlign mozBoxAlign webkitFlexDirection msFlexDirection mozBoxDirection mozBoxOrient webkitBoxDirection webkitBoxOrient".split(" "),a=0;a<t.length;a+=1)if(t[a]in e)return!0;return!1}(),observer:"MutationObserver"in win||"WebkitMutationObserver"in win,passiveListener:function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});win.addEventListener("testPassiveListener",null,t)}catch(e){}return e}(),gestures:"ongesturestart"in win}),Xo,Yo,cp,ap,Uo,Vo,SupportModule={name:"support",proto:{support:Support},static:{support:Support},on:{init:function(){var e=doc.querySelector("html");if(e){var t=[];Support.positionSticky&&t.push("support-position-sticky"),t.forEach(function(t){e.classList.add(t)})}}}},UtilsModule={name:"utils",proto:{utils:Utils},static:{utils:Utils}},ResizeModule={name:"resize",instance:{getSize:function(){var e=this;if(!e.root[0])return{width:0,height:0,left:0,top:0};var t=e.root.offset(),a=[e.root[0].offsetWidth,e.root[0].offsetHeight,t.left,t.top],n=a[0],r=a[1],i=a[2],o=a[3];return e.width=n,e.height=r,e.left=i,e.top=o,{width:n,height:r,left:i,top:o}}},on:{init:function(){var e=this;e.getSize(),win.addEventListener("resize",function(){e.emit("resize")},!1),win.addEventListener("orientationchange",function(){e.emit("orientationchange")})},orientationchange:function(){this.device&&this.device.minimalUi&&(90!==win.orientation&&-90!==win.orientation||(doc.body.scrollTop=0)),this.device.ipad&&(doc.body.scrollLeft=0,setTimeout(function(){doc.body.scrollLeft=0},0))},resize:function(){this.getSize()}}},globals={},jsonpRequests=0;function Request(e){var t=Utils.extend({},globals);"beforeCreate beforeOpen beforeSend error complete success statusCode".split(" ").forEach(function(e){delete t[e]});var a=Utils.extend({url:win.location.toString(),method:"GET",data:!1,async:!0,cache:!0,user:"",password:"",headers:{},xhrFields:{},statusCode:{},processData:!0,dataType:"text",contentType:"application/x-www-form-urlencoded",timeout:0},t),n=Utils.extend({},a,e);function r(e){for(var t,a,r=[],i=arguments.length-1;i-- >0;)r[i]=arguments[i+1];return globals[e]&&(t=globals[e].apply(globals,r)),n[e]&&(a=n[e].apply(n,r)),"boolean"!=typeof t&&(t=!0),"boolean"!=typeof a&&(a=!0),t&&a}if(!1!==r("beforeCreate",n)){n.type&&(n.method=n.type);var i,o=n.url.indexOf("?")>=0?"&":"?",s=n.method.toUpperCase();if(("GET"===s||"HEAD"===s||"OPTIONS"===s||"DELETE"===s)&&n.data)(i="string"==typeof n.data?n.data.indexOf("?")>=0?n.data.split("?")[1]:n.data:Utils.serializeObject(n.data)).length&&(n.url+=o+i,"?"===o&&(o="&"));if("json"===n.dataType&&n.url.indexOf("callback=")>=0){var l,p="f7jsonp_"+(Date.now()+(jsonpRequests+=1)),c=n.url.split("callback="),d=c[0]+"callback="+p;if(c[1].indexOf("&")>=0){var u=c[1].split("&").filter(function(e){return e.indexOf("=")>0}).join("&");u.length>0&&(d+="&"+u)}var h=doc.createElement("script");return h.type="text/javascript",h.onerror=function(){clearTimeout(l),r("error",null,"scripterror"),r("complete",null,"scripterror")},h.src=d,win[p]=function(e){clearTimeout(l),r("success",e),h.parentNode.removeChild(h),h=null,delete win[p]},doc.querySelector("head").appendChild(h),void(n.timeout>0&&(l=setTimeout(function(){h.parentNode.removeChild(h),h=null,r("error",null,"timeout")},n.timeout)))}"GET"!==s&&"HEAD"!==s&&"OPTIONS"!==s&&"DELETE"!==s||!1===n.cache&&(n.url+=o+"_nocache"+Date.now());var f=new XMLHttpRequest;if(f.requestUrl=n.url,f.requestParameters=n,!1===r("beforeOpen",f,n))return f;f.open(s,n.url,n.async,n.user,n.password);var m,v=null;if(("POST"===s||"PUT"===s||"PATCH"===s)&&n.data)if(n.processData)if([ArrayBuffer,Blob,Document,FormData].indexOf(n.data.constructor)>=0)v=n.data;else{var g="---------------------------"+Date.now().toString(16);"multipart/form-data"===n.contentType?f.setRequestHeader("Content-Type","multipart/form-data; boundary="+g):f.setRequestHeader("Content-Type",n.contentType),v="";var b=Utils.serializeObject(n.data);if("multipart/form-data"===n.contentType){b=b.split("&");for(var y=[],w=0;w<b.length;w+=1)y.push('Content-Disposition: form-data; name="'+b[w].split("=")[0]+'"\r\n\r\n'+b[w].split("=")[1]+"\r\n");v="--"+g+"\r\n"+y.join("--"+g+"\r\n")+"--"+g+"--\r\n"}else v=b}else v=n.data,f.setRequestHeader("Content-Type",n.contentType);return n.headers&&Object.keys(n.headers).forEach(function(e){f.setRequestHeader(e,n.headers[e])}),void 0===n.crossDomain&&(n.crossDomain=/^([\w-]+:)?\/\/([^\/]+)/.test(n.url)&&RegExp.$2!==win.location.host),n.crossDomain||f.setRequestHeader("X-Requested-With","XMLHttpRequest"),n.xhrFields&&Utils.extend(f,n.xhrFields),f.onload=function(){var e;if(m&&clearTimeout(m),f.status>=200&&f.status<300||0===f.status)if("json"===n.dataType){var t;try{e=JSON.parse(f.responseText)}catch(e){t=!0}t?r("error",f,"parseerror"):r("success",e,f.status,f)}else r("success",e="text"===f.responseType||""===f.responseType?f.responseText:f.response,f.status,f);else r("error",f,f.status);n.statusCode&&(globals.statusCode&&globals.statusCode[f.status]&&globals.statusCode[f.status](f),n.statusCode[f.status]&&n.statusCode[f.status](f)),r("complete",f,f.status)},f.onerror=function(){m&&clearTimeout(m),r("error",f,f.status),r("complete",f,"error")},n.timeout>0&&(f.onabort=function(){m&&clearTimeout(m)},m=setTimeout(function(){f.abort(),r("error",f,"timeout"),r("complete",f,"timeout")},n.timeout)),!1===r("beforeSend",f,n)?f:(f.send(v),f)}}function RequestShortcut(e){for(var t,a,n=[],r=arguments.length-1;r-- >0;)n[r]=arguments[r+1];var i=[],o=i[0],s=i[1],l=i[2],p=i[3],c=i[4];"function"==typeof n[1]?(o=(t=n)[0],l=t[1],p=t[2],c=t[3]):(o=(a=n)[0],s=a[1],l=a[2],p=a[3],c=a[4]),[l,p].forEach(function(e){"string"==typeof e&&(c=e,e===l?l=void 0:p=void 0)}),c=c||("json"===e||"postJSON"===e?"json":void 0);var d={url:o,method:"post"===e||"postJSON"===e?"POST":"GET",data:s,success:l,error:p,dataType:c};return"postJSON"===e&&Utils.extend(d,{contentType:"application/json",processData:!1,crossDomain:!0,data:"string"==typeof s?s:JSON.stringify(s)}),Request(d)}Request.get=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["get"].concat(e))},Request.post=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["post"].concat(e))},Request.json=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},Request.getJSON=Request.json,Request.postJSON=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["postJSON"].concat(e))},Request.setup=function(e){e.type&&!e.method&&Utils.extend(e,{method:e.type}),Utils.extend(globals,e)};var RequestModule={name:"request",proto:{request:Request},static:{request:Request}};function initTouch(){var e,t,a,n,r,i,o,s,l,p,c,d,u,h,f,m,v,g,b=this,y=b.params.touch,w="md"===b.theme&&y.materialRipple;function $(e){var t,a=$$1(e),n=a.parents(y.activeStateElements);return a.is(y.activeStateElements)&&(t=a),n.length>0&&(t=t?t.add(n):n),t||a}function C(e){var t=e.parents(".page-content, .panel");return 0!==t.length&&("yes"!==t.prop("scrollHandlerSet")&&(t.on("scroll",function(){clearTimeout(u),clearTimeout(g)}),t.prop("scrollHandlerSet","yes")),!0)}function x(){d&&d.addClass("active-state")}function E(){d&&(d.removeClass("active-state"),d=null)}function S(e,t,a){e&&(m=b.touchRipple.create(e,t,a))}function k(){m&&(m.remove(),m=void 0,v=void 0)}function T(a){(v=function(e){var t=y.materialRippleElements,a=$$1(e);if(a.is(t))return!a.hasClass("no-ripple")&&a;if(a.parents(t).length>0){var n=a.parents(t).eq(0);return!n.hasClass("no-ripple")&&n}return!1}(a))&&0!==v.length?C(v)?g=setTimeout(function(){S(v,e,t)},80):S(v,e,t):v=void 0}function M(){clearTimeout(g),k()}function P(){m?k():v&&!l?(clearTimeout(g),S(v,e,t),setTimeout(k,0)):k()}function O(e,t){b.emit({events:e,data:[t]})}function D(e){O("touchstart touchstart:active",e)}function I(e){O("touchmove touchmove:active",e)}function L(e){O("touchend touchend:active",e)}function z(e){O("touchstart:passive",e)}function B(e){O("touchmove:passive",e)}function A(e){O("touchend:passive",e)}Device.ios&&Device.webView&&win.addEventListener("touchstart",function(){});var R=!!Support.passiveListener&&{passive:!0},U=!!Support.passiveListener&&{passive:!1};doc.addEventListener("click",function(e){O("click",e)},!0),Support.passiveListener?(doc.addEventListener(b.touchEvents.start,D,U),doc.addEventListener(b.touchEvents.move,I,U),doc.addEventListener(b.touchEvents.end,L,U),doc.addEventListener(b.touchEvents.start,z,R),doc.addEventListener(b.touchEvents.move,B,R),doc.addEventListener(b.touchEvents.end,A,R)):(doc.addEventListener(b.touchEvents.start,function(e){D(e),z(e)},!1),doc.addEventListener(b.touchEvents.move,function(e){I(e),B(e)},!1),doc.addEventListener(b.touchEvents.end,function(e){L(e),A(e)},!1)),Support.touch?(b.on("click",function(e){var t,a,i,o,s=!1;return r?(n=null,r=!1,!0):"submit"===e.target.type&&0===e.detail||"file"===e.target.type||(n||(t=e.target,a="input select textarea label".split(" "),t.nodeName&&a.indexOf(t.nodeName.toLowerCase())>=0||(s=!0)),h||(s=!0),doc.activeElement===n&&(s=!0),e.forwardedTouchEvent&&(s=!0),e.cancelable||(s=!0),y.tapHold&&y.tapHoldPreventClicks&&p&&(s=!1),s||(e.stopImmediatePropagation(),e.stopPropagation(),n?(i=$$1(n),o=!0,(i.is("label")||i.parents("label").length>0)&&(o=!Device.android&&!(!Device.ios||!i.is("input"))),(o||l)&&e.preventDefault()):e.preventDefault(),n=null),f=setTimeout(function(){h=!1},Device.ios||Device.androidChrome?100:400),y.tapHold&&(c=setTimeout(function(){p=!1},Device.ios||Device.androidChrome?100:400)),s)}),b.on("touchstart",function(m){var v,g,b,S,k=this;if(l=!1,p=!1,m.targetTouches.length>1)return d&&E(),!0;if(m.touches.length>1&&d&&E(),y.tapHold&&(c&&clearTimeout(c),c=setTimeout(function(){m&&m.touches&&m.touches.length>1||(p=!0,m.preventDefault(),$$1(m.target).trigger("taphold"))},y.tapHoldDelay)),f&&clearTimeout(f),v=m.target,g=$$1(v),!(h=!("input"===v.nodeName.toLowerCase()&&("file"===v.type||"range"===v.type)||"select"===v.nodeName.toLowerCase()&&Device.android||g.hasClass("no-fastclick")||g.parents(".no-fastclick").length>0||y.fastClicksExclude&&g.is(y.fastClicksExclude))))return r=!1,!0;if(Device.ios||Device.android&&"getSelection"in win){var M=win.getSelection();if(M.rangeCount&&M.focusNode!==doc.body&&(!M.isCollapsed||doc.activeElement===M.focusNode))return i=!0,!0;i=!1}return Device.android&&(b=m.target,S="button input textarea select".split(" "),!doc.activeElement||b===doc.activeElement||doc.activeElement===doc.body||S.indexOf(b.nodeName.toLowerCase())>=0||doc.activeElement.blur()),r=!0,n=m.target,a=(new Date).getTime(),e=m.targetTouches[0].pageX,t=m.targetTouches[0].pageY,Device.ios&&(o=void 0,$$1(n).parents().each(function(){var e=k;e.scrollHeight>e.offsetHeight&&!o&&((o=e).f7ScrollTop=o.scrollTop)})),a-s<y.fastClicksDelayBetweenClicks&&m.preventDefault(),y.activeState&&(C(d=$(n))?u=setTimeout(x,80):x()),w&&T(n),!0}),b.on("touchmove",function(a){if(r){var i=y.fastClicksDistanceThreshold;if(i){var o=a.targetTouches[0].pageX,s=a.targetTouches[0].pageY;(Math.abs(o-e)>i||Math.abs(s-t)>i)&&(l=!0)}else l=!0;l&&(r=!1,n=null,l=!0,y.tapHold&&clearTimeout(c),y.activeState&&(clearTimeout(u),E()),w&&M())}}),b.on("touchend",function(e){clearTimeout(u),clearTimeout(c);var t,a,l,d,f=(new Date).getTime();if(!r)return!i&&h&&(Device.android&&!e.cancelable||!e.cancelable||e.preventDefault()),!0;if(doc.activeElement===e.target)return y.activeState&&E(),w&&P(),!0;if(i||e.preventDefault(),f-s<y.fastClicksDelayBetweenClicks)return setTimeout(E,0),!0;if(s=f,r=!1,Device.ios&&o&&o.scrollTop!==o.f7ScrollTop)return!1;if(y.activeState&&(x(),setTimeout(E,0)),w&&P(),function(e){if(doc.activeElement===e)return!1;var t=e.nodeName.toLowerCase(),a="button checkbox file image radio submit".split(" ");return!e.disabled&&!e.readOnly&&("textarea"===t||("select"===t?!Device.android:"input"===t&&a.indexOf(e.type)<0))}(n)){if(Device.ios&&Device.webView)return n.focus(),!1;n.focus()}return doc.activeElement&&n!==doc.activeElement&&doc.activeElement!==doc.body&&"label"!==n.nodeName.toLowerCase()&&doc.activeElement.blur(),e.preventDefault(),!(y.tapHoldPreventClicks&&p||(a=(t=e).changedTouches[0],l=doc.createEvent("MouseEvents"),d="click",Device.android&&"select"===n.nodeName.toLowerCase()&&(d="mousedown"),l.initMouseEvent(d,!0,!0,win,1,a.screenX,a.screenY,a.clientX,a.clientY,!1,!1,!1,!1,0,null),l.forwardedTouchEvent=!0,b.device.ios&&win.navigator.standalone?setTimeout(function(){(n=doc.elementFromPoint(t.changedTouches[0].clientX,t.changedTouches[0].clientY)).dispatchEvent(l)},10):n.dispatchEvent(l),1))}),doc.addEventListener("touchcancel",function(){r=!1,n=null,clearTimeout(u),clearTimeout(c),y.activeState&&E(),w&&P()},{passive:!0})):y.activeState&&(b.on("touchstart",function(a){$(a.target).addClass("active-state"),"which"in a&&3===a.which&&setTimeout(function(){$$1(".active-state").removeClass("active-state")},0),w&&(e=a.pageX,t=a.pageY,T(a.target,a.pageX,a.pageY))}),b.on("touchmove",function(){$$1(".active-state").removeClass("active-state"),w&&M()}),b.on("touchend",function(){$$1(".active-state").removeClass("active-state"),w&&P()})),doc.addEventListener("contextmenu",function(e){y.disableContextMenu&&(Device.ios||Device.android||Device.cordova)&&e.preventDefault(),w&&(d&&E(),P())})}var TouchModule={name:"touch",params:{touch:{fastClicks:!0,fastClicksDistanceThreshold:10,fastClicksDelayBetweenClicks:50,fastClicksExclude:"",disableContextMenu:!0,tapHold:!1,tapHoldDelay:750,tapHoldPreventClicks:!0,activeState:!0,activeStateElements:"a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus",materialRipple:!0,materialRippleElements:".ripple, .link, .item-link, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus"}},instance:{touchEvents:{start:Support.touch?"touchstart":"mousedown",move:Support.touch?"touchmove":"mousemove",end:Support.touch?"touchend":"mouseup"}},on:{init:initTouch}},pathToRegexp_1=pathToRegexp,parse_1=parse,compile_1=compile,tokensToFunction_1=tokensToFunction,tokensToRegExp_1=tokensToRegExp,DEFAULT_DELIMITER="/",DEFAULT_DELIMITERS="./",PATH_REGEXP=new RegExp(["(\\\\.)","(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?"].join("|"),"g");function parse(e,t){for(var a,n=[],r=0,i=0,o="",s=t&&t.delimiter||DEFAULT_DELIMITER,l=t&&t.delimiters||DEFAULT_DELIMITERS,p=!1;null!==(a=PATH_REGEXP.exec(e));){var c=a[0],d=a[1],u=a.index;if(o+=e.slice(i,u),i=u+c.length,d)o+=d[1],p=!0;else{var h="",f=e[i],m=a[2],v=a[3],g=a[4],b=a[5];if(!p&&o.length){var y=o.length-1;l.indexOf(o[y])>-1&&(h=o[y],o=o.slice(0,y))}o&&(n.push(o),o="",p=!1);var w=""!==h&&void 0!==f&&f!==h,$="+"===b||"*"===b,C="?"===b||"*"===b,x=h||s,E=v||g;n.push({name:m||r++,prefix:h,delimiter:x,optional:C,repeat:$,partial:w,pattern:E?escapeGroup(E):"[^"+escapeString(x)+"]+?"})}}return(o||i<e.length)&&n.push(o+e.substr(i)),n}function compile(e,t){return tokensToFunction(parse(e,t))}function tokensToFunction(e){for(var t=new Array(e.length),a=0;a<e.length;a++)"object"==typeof e[a]&&(t[a]=new RegExp("^(?:"+e[a].pattern+")$"));return function(a,n){for(var r="",i=n&&n.encode||encodeURIComponent,o=0;o<e.length;o++){var s=e[o];if("string"!=typeof s){var l,p=a?a[s.name]:void 0;if(Array.isArray(p)){if(!s.repeat)throw new TypeError('Expected "'+s.name+'" to not repeat, but got array');if(0===p.length){if(s.optional)continue;throw new TypeError('Expected "'+s.name+'" to not be empty')}for(var c=0;c<p.length;c++){if(l=i(p[c]),!t[o].test(l))throw new TypeError('Expected all "'+s.name+'" to match "'+s.pattern+'"');r+=(0===c?s.prefix:s.delimiter)+l}}else if("string"!=typeof p&&"number"!=typeof p&&"boolean"!=typeof p){if(!s.optional)throw new TypeError('Expected "'+s.name+'" to be '+(s.repeat?"an array":"a string"));s.partial&&(r+=s.prefix)}else{if(l=i(String(p)),!t[o].test(l))throw new TypeError('Expected "'+s.name+'" to match "'+s.pattern+'", but got "'+l+'"');r+=s.prefix+l}}else r+=s}return r}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function escapeGroup(e){return e.replace(/([=!:$/()])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function regexpToRegexp(e,t){if(!t)return e;var a=e.source.match(/\((?!\?)/g);if(a)for(var n=0;n<a.length;n++)t.push({name:n,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,pattern:null});return e}function arrayToRegexp(e,t,a){for(var n=[],r=0;r<e.length;r++)n.push(pathToRegexp(e[r],t,a).source);return new RegExp("(?:"+n.join("|")+")",flags(a))}function stringToRegexp(e,t,a){return tokensToRegExp(parse(e,a),t,a)}function tokensToRegExp(e,t,a){for(var n=(a=a||{}).strict,r=!1!==a.end,i=escapeString(a.delimiter||DEFAULT_DELIMITER),o=a.delimiters||DEFAULT_DELIMITERS,s=[].concat(a.endsWith||[]).map(escapeString).concat("$").join("|"),l="",p=!1,c=0;c<e.length;c++){var d=e[c];if("string"==typeof d)l+=escapeString(d),p=c===e.length-1&&o.indexOf(d[d.length-1])>-1;else{var u=escapeString(d.prefix),h=d.repeat?"(?:"+d.pattern+")(?:"+u+"(?:"+d.pattern+"))*":d.pattern;t&&t.push(d),d.optional?d.partial?l+=u+"("+h+")?":l+="(?:"+u+"("+h+"))?":l+=u+"("+h+")"}}return r?(n||(l+="(?:"+i+")?"),l+="$"===s?"$":"(?="+s+")"):(n||(l+="(?:"+i+"(?="+s+"))?"),p||(l+="(?="+i+"|"+s+")")),new RegExp("^"+l,flags(a))}function pathToRegexp(e,t,a){return e instanceof RegExp?regexpToRegexp(e,t):Array.isArray(e)?arrayToRegexp(e,t,a):stringToRegexp(e,t,a)}pathToRegexp_1.parse=parse_1,pathToRegexp_1.compile=compile_1,pathToRegexp_1.tokensToFunction=tokensToFunction_1,pathToRegexp_1.tokensToRegExp=tokensToRegExp_1;var tempDom=doc.createElement("div"),Framework7Component=function(e,t){void 0===t&&(t={});var a=Utils.extend({},e),n=Utils.merge(this,t,{$options:a});"beforeCreate created beforeMount mounted beforeDestroy destroyed".split(" ").forEach(function(e){a[e]&&(a[e]=a[e].bind(n))}),a.data&&(a.data=a.data.bind(n),Utils.extend(n,a.data())),a.render&&(a.render=a.render.bind(n)),a.methods&&Object.keys(a.methods).forEach(function(e){n[e]=a.methods[e].bind(n)}),a.on&&Object.keys(a.on).forEach(function(e){a.on[e]=a.on[e].bind(n)}),a.once&&Object.keys(a.once).forEach(function(e){a.once[e]=a.once[e].bind(n)}),a.beforeCreate&&a.beforeCreate(),a.watch&&Object.keys(a.watch).forEach(function(e){var t=n[e];Object.defineProperty(n,e,{enumerable:!0,configurable:!0,set:function(r){var i=t;t=r,i!==r&&a.watch[e].call(n,r,i)},get:function(){return t}})});var r=function(){var e="";if(a.render)e=a.render();else if(a.template)if("string"==typeof a.template)try{e=Template7.compile(a.template)(n)}catch(e){throw e}else e=a.template(n);return e}();r&&"string"==typeof r?(r=r.trim(),tempDom.innerHTML=r):r&&(tempDom.innerHTML="",tempDom.appendChild(r));var i=tempDom.children[0],o=$$1(i);n.$el=o,n.el=i,n.el=i;var s,l=[];$$1(tempDom).find("*").each(function(e,t){for(var a=[],r=0;r<t.attributes.length;r+=1){var i=t.attributes[r];0===i.name.indexOf("@")&&a.push({name:i.name,value:i.value})}a.forEach(function(e){t.removeAttribute(e.name);var a=e.name.replace("@",""),r=a,i=!1,o=!1,s=!1;a.indexOf(".")>=0&&a.split(".").forEach(function(e,t){0===t?r=e:("stop"===e&&(i=!0),"prevent"===e&&(o=!0),"once"===e&&(s=!0))});var p=e.value.toString();l.push({el:t,name:r,once:s,handler:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,r,s=e[0];i&&s.stopPropagation(),o&&s.preventDefault();var l=[];if(p.indexOf("(")<0?(l=e,a=p):(a=p.split("(")[0],p.split("(")[1].split(")")[0].split(",").forEach(function(e){var t=e.trim();if(isNaN(t))if("true"===t)t=!0;else if("false"===t)t=!1;else if("null"===t)t=null;else if("undefined"===t)t=void 0;else if('"'===t[0])t=t.replace(/"/g,"");else if("'"===t[0])t=t.replace(/'/g,"");else if(t.indexOf(".")>0){var a;t.split(".").forEach(function(e){a||(a=n),a=a[e]}),t=a}else t=n[t];else t=parseFloat(t);l.push(t)})),a.indexOf(".")>=0)a.split(".").forEach(function(e,t){if(r||(r=n),!r[e])throw new Error("Component doesn't have method \""+a.split(".").slice(0,t+1).join(".")+'"');r=r[e]});else{if(!n[a])throw new Error("Component doesn't have method \""+a+'"');r=n[a]}r.apply(void 0,l)}})})}),a.style&&((s=doc.createElement("style")).innerHTML=a.style),a.styleScopeId&&i.setAttribute("data-scope",a.styleScopeId),a.on&&Object.keys(a.on).forEach(function(e){o.on(Utils.eventNameToColonCase(e),a.on[e])}),a.once&&Object.keys(a.once).forEach(function(e){o.once(Utils.eventNameToColonCase(e),a.once[e])}),l.forEach(function(e){$$1(e.el)[e.once?"once":"on"](e.name,e.handler)}),a.created&&a.created(),n.$mount=function(e){a.beforeMount&&a.beforeMount(),s&&$$1("head").append(s),e&&e(i),a.mounted&&a.mounted()},n.$destroy=function(){a.beforeDestroy&&a.beforeDestroy(),s&&$$1(s).remove(),a.on&&Object.keys(a.on).forEach(function(e){o.off(Utils.eventNameToColonCase(e),a.on[e])}),a.once&&Object.keys(a.once).forEach(function(e){o.off(Utils.eventNameToColonCase(e),a.once[e])}),l.forEach(function(e){$$1(e.el).off(e.name,e.handler)}),a.destroyed&&a.destroyed(),i&&i.f7Component&&(i.f7Component=null,delete i.f7Component),Utils.deleteProps(n),n=null};for(var p=0;p<tempDom.children.length;p+=1)tempDom.children[p].f7Component=n;return n},Component={parse:function(e){var t,a,n="f7_component_callback_"+(new Date).getTime();e.indexOf("<template>")>=0&&(t=e.split("<template>").filter(function(e,t){return t>0}).join("<template>").split("</template>").filter(function(e,t,a){return t<a.length-1}).join("</template>").replace(/{{#raw}}([ \n]*)<template/g,"{{#raw}}<template").replace(/\/template>([ \n]*){{\/raw}}/g,"/template>{{/raw}}").replace(/([ \n])<template/g,"$1{{#raw}}<template").replace(/\/template>([ \n])/g,"/template>{{/raw}}$1"));var r,i=Utils.now();if(e.indexOf("<style>")>=0?a=e.split("<style>")[1].split("</style>")[0]:e.indexOf("<style scoped>")>=0&&(a=(a=e.split("<style scoped>")[1].split("</style>")[0]).split("\n").map(function(e){return e.indexOf("{")>=0?e.indexOf("{{this}}")>=0?e.replace("{{this}}",'[data-scope="'+i+'"]'):'[data-scope="'+i+'"] '+e.trim():e}).join("\n")),e.indexOf("<script>")>=0){var o=e.split("<script>");r=o[o.length-1].split("<\/script>")[0].trim()}else r="return {}";r="window."+n+" = function () {"+r+"}";var s=doc.createElement("script");s.innerHTML=r,$$1("head").append(s);var l=win[n]();return $$1(s).remove(),l.template||l.render||(l.template=t),a&&(l.style=a,l.styleScopeId=i),l},create:function(e,t){return void 0===t&&(t={}),new Framework7Component(e,t)}},History={queue:[],clearQueue:function(){0!==History.queue.length&&History.queue.shift()()},routerQueue:[],clearRouterQueue:function(){if(0!==History.routerQueue.length){var e=History.routerQueue.pop(),t=e.router,a=e.stateUrl,n=e.action,r=t.params.animate;!1===t.params.pushStateAnimate&&(r=!1),"back"===n&&t.back({animate:r,pushState:!1}),"load"===n&&t.navigate(a,{animate:r,pushState:!1})}},handle:function(e){if(!History.blockPopstate){var t=e.state;History.previousState=History.state,History.state=t,History.allowChange=!0,History.clearQueue(),(t=History.state)||(t={}),this.views.forEach(function(e){var a=e.router,n=t[e.id];if(!n&&e.params.pushState&&(n={url:e.router.history[0]}),n){var r=n.url||void 0,i=a.params.animate;!1===a.params.pushStateAnimate&&(i=!1),r!==a.url&&(a.history.indexOf(r)>=0?a.allowPageChange?a.back({animate:i,pushState:!1}):History.routerQueue.push({action:"back",router:a}):a.allowPageChange?a.navigate(r,{animate:i,pushState:!1}):History.routerQueue.unshift({action:"load",stateUrl:r,router:a}))}})}},initViewState:function(e,t){var a,n=Utils.extend({},History.state||{},((a={})[e]=t,a));History.state=n,win.history.replaceState(n,"")},push:function(e,t,a){var n;if(History.allowChange){History.previousState=History.state;var r=Utils.extend({},History.previousState||{},((n={})[e]=t,n));History.state=r,win.history.pushState(r,"",a)}else History.queue.push(function(){History.push(e,t,a)})},replace:function(e,t,a){var n;if(History.allowChange){History.previousState=History.state;var r=Utils.extend({},History.previousState||{},((n={})[e]=t,n));History.state=r,win.history.replaceState(r,"",a)}else History.queue.push(function(){History.replace(e,t,a)})},go:function(e){History.allowChange=!1,win.history.go(e)},back:function(){History.allowChange=!1,win.history.back()},allowChange:!0,previousState:{},state:win.history.state,blockPopstate:!0,init:function(e){$$1(win).on("load",function(){setTimeout(function(){History.blockPopstate=!1},0)}),doc.readyState&&"complete"===doc.readyState&&(History.blockPopstate=!1),$$1(win).on("popstate",History.handle.bind(e))}};function SwipeBack(e){var t,a,n,r,i,o,s,l,p,c,d,u,h,f,m,v=e,g=v.$el,b=v.$navbarEl,y=v.app,w=v.params,$=!1,C=!1,x={},E=[],S=[],k=!0,T=[],M=[],P=w[y.theme+"SwipeBackAnimateShadow"],O=w[y.theme+"SwipeBackAnimateOpacity"],D=w[y.theme+"SwipeBackActiveArea"],I=w[y.theme+"SwipeBackThreshold"];function L(e){var a=w[y.theme+"SwipeBack"];!k||!a||$||y.swipeout&&y.swipeout.el||!v.allowPageChange||$$1(e.target).closest(".range-slider, .calendar-months").length>0||(C=!1,$=!0,t=void 0,x.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,x.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,r=Utils.now(),c=v.dynamicNavbar,d=v.separateNavbar)}function z(e){if($){var r="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,m="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===t&&(t=!!(t||Math.abs(m-x.y)>Math.abs(r-x.x))||r<x.x),t||e.f7PreventSwipeBack||y.preventSwipeBack)$=!1;else{if(!C){var k=!1,L=$$1(e.target),z=L.closest(".swipeout");z.length>0&&(!y.rtl&&z.find(".swipeout-actions-left").length>0&&(k=!0),y.rtl&&z.find(".swipeout-actions-right").length>0&&(k=!0)),((E=L.closest(".page")).hasClass("no-swipeback")||L.closest(".no-swipeback").length>0)&&(k=!0),S=g.find(".page-previous:not(.stacked)");x.x,g.offset().left;if(a=g.width(),(y.rtl?x.x<g.offset().left-g[0].scrollLeft+(a-D):x.x-g.offset().left>D)&&(k=!0),0!==S.length&&0!==E.length||(k=!0),k)return void($=!1);P&&0===(u=E.find(".page-shadow-effect")).length&&(u=$$1('<div class="page-shadow-effect"></div>'),E.append(u)),O&&0===(h=S.find(".page-opacity-effect")).length&&(h=$$1('<div class="page-opacity-effect"></div>'),S.append(h)),c&&(d?(T=b.find(".navbar-current:not(.stacked)"),M=b.find(".navbar-previous:not(.stacked)")):(T=E.children(".navbar").children(".navbar-inner"),M=S.children(".navbar").children(".navbar-inner")),f=b[0].offsetWidth,i=T.children(".left, .title, .right, .subnavbar, .fading"),o=M.children(".left, .title, .right, .subnavbar, .fading"),w.iosAnimateNavbarBackIcon&&(T.hasClass("sliding")?(s=T.children(".left").find(".back .icon"),l=T.children(".left").find(".back span").eq(0)):(s=T.children(".left.sliding").find(".back .icon"),l=T.children(".left.sliding").find(".back span").eq(0)),p=M.hasClass("sliding")?M.children(".left").find(".back .icon"):M.children(".left.sliding").find(".back .icon"))),$$1(".sheet.modal-in").length>0&&y.sheet&&y.sheet.close($$1(".sheet.modal-in"))}e.f7PreventPanelSwipe=!0,C=!0,y.preventSwipePanelBySwipeBack=!0,e.preventDefault();var B=y.rtl?-1:1;(n=(r-x.x-I)*B)<0&&(n=0);var A=n/a,R={percentage:A,currentPageEl:E[0],previousPageEl:S[0],currentNavbarEl:T[0],previousNavbarEl:M[0]};g.trigger("swipeback:move",R),v.emit("swipebackMove",R);var U=n*B,H=(n/5-a/5)*B;1===Device.pixelRatio&&(U=Math.round(U),H=Math.round(H)),E.transform("translate3d("+U+"px,0,0)"),P&&(u[0].style.opacity=1-1*A),"md"!==y.theme&&S.transform("translate3d("+H+"px,0,0)"),O&&(h[0].style.opacity=1-1*A),c&&(i.each(function(e,t){var a=$$1(t);if(a.is(".subnavbar")||(a[0].style.opacity=1-Math.pow(A,.33)),a[0].className.indexOf("sliding")>=0||T.hasClass("sliding")){var n=A*a[0].f7NavbarRightOffset;if(1===Device.pixelRatio&&(n=Math.round(n)),a.transform("translate3d("+n+"px,0,0)"),w.iosAnimateNavbarBackIcon&&a[0].className.indexOf("left")>=0&&s.length>0){var r=-n;d||(r-=f*A),s.transform("translate3d("+r+"px,0,0)")}}}),o.each(function(e,t){var a=$$1(t);if(a.is(".subnavbar")||(a[0].style.opacity=Math.pow(A,3)),a[0].className.indexOf("sliding")>=0||M.hasClass("sliding")){var n=a[0].f7NavbarLeftOffset*(1-A);if(n=a[0].className.indexOf("title")>=0&&s&&s.length&&l.length?(a[0].f7NavbarLeftOffset+l[0].offsetLeft)*(1-A):a[0].f7NavbarLeftOffset*(1-A),1===Device.pixelRatio&&(n=Math.round(n)),a.transform("translate3d("+n+"px,0,0)"),w.iosAnimateNavbarBackIcon&&a[0].className.indexOf("left")>=0&&p.length>0){var r=-n;d||(r+=f/5*(1-A)),p.transform("translate3d("+r+"px,0,0)")}}}))}}}function B(){if(y.preventSwipePanelBySwipeBack=!1,!$||!C)return $=!1,void(C=!1);if($=!1,C=!1,0===n)return $$1([E[0],S[0]]).transform(""),u&&u.length>0&&u.remove(),h&&h.length>0&&h.remove(),void(c&&(i.transform("").css({opacity:""}),o.transform("").css({opacity:""}),s&&s.length>0&&s.transform(""),p&&s.length>0&&p.transform("")));var e=Utils.now()-r,t=!1;(e<300&&n>10||e>=300&&n>a/2)&&(E.removeClass("page-current").addClass("page-next"+("md"===y.theme?" page-next-on-right":"")),S.removeClass("page-previous").addClass("page-current").removeAttr("aria-hidden"),u&&(u[0].style.opacity=""),h&&(h[0].style.opacity=""),c&&(T.removeClass("navbar-current").addClass("navbar-next"),M.removeClass("navbar-previous").addClass("navbar-current").removeAttr("aria-hidden")),t=!0),$$1([E[0],S[0]]).addClass("page-transitioning page-transitioning-swipeback").transform(""),c&&(i.css({opacity:""}).each(function(e,a){var n=t?a.f7NavbarRightOffset:0,r=$$1(a),i=t?-n:0;!d&&t&&(i-=f),r.transform("translate3d("+n+"px,0,0)"),w.iosAnimateNavbarBackIcon&&r.hasClass("left")&&s.length>0&&s.addClass("navbar-transitioning").transform("translate3d("+i+"px,0,0)")}).addClass("navbar-transitioning"),o.transform("").css({opacity:""}).each(function(e,a){var n=t?0:a.f7NavbarLeftOffset,r=$$1(a),i=t?0:-n;d||t||(i+=f/5),r.transform("translate3d("+n+"px,0,0)"),w.iosAnimateNavbarBackIcon&&r.hasClass("left")&&p.length>0&&p.addClass("navbar-transitioning").transform("translate3d("+i+"px,0,0)")}).addClass("navbar-transitioning")),k=!1,v.allowPageChange=!1;var l={currentPage:E[0],previousPage:S[0],currentNavbar:T[0],previousNavbar:M[0]};t?(v.currentRoute=S[0].f7Page.route,v.currentPage=S[0],v.pageCallback("beforeOut",E,T,"current","next",{route:E[0].f7Page.route,swipeBack:!0}),v.pageCallback("beforeIn",S,M,"previous","current",{route:S[0].f7Page.route,swipeBack:!0}),g.trigger("swipeback:beforechange",l),v.emit("swipebackBeforeChange",l)):(g.trigger("swipeback:beforereset",l),v.emit("swipebackBeforeReset",l)),E.transitionEnd(function(){$$1([E[0],S[0]]).removeClass("page-transitioning page-transitioning-swipeback"),c&&(i.removeClass("navbar-transitioning").css({opacity:""}).transform(""),o.removeClass("navbar-transitioning").css({opacity:""}).transform(""),s&&s.length>0&&s.removeClass("navbar-transitioning"),p&&p.length>0&&p.removeClass("navbar-transitioning")),k=!0,v.allowPageChange=!0,t?(1===v.history.length&&v.history.unshift(v.url),v.history.pop(),v.saveHistory(),w.pushState&&History.back(),v.pageCallback("afterOut",E,T,"current","next",{route:E[0].f7Page.route,swipeBack:!0}),v.pageCallback("afterIn",S,M,"previous","current",{route:S[0].f7Page.route,swipeBack:!0}),w.stackPages&&v.initialPages.indexOf(E[0])>=0?(E.addClass("stacked"),d&&T.addClass("stacked")):(v.pageCallback("beforeRemove",E,T,"next",{swipeBack:!0}),v.removePage(E),d&&v.removeNavbar(T)),g.trigger("swipeback:afterchange",l),v.emit("swipebackAfterChange",l),v.emit("routeChanged",v.currentRoute,v.previousRoute,v),w.preloadPreviousPage&&v.back(v.history[v.history.length-2],{preload:!0})):(g.trigger("swipeback:afterreset",l),v.emit("swipebackAfterReset",l)),u&&u.length>0&&u.remove(),h&&h.length>0&&h.remove()})}m=!("touchstart"!==y.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1},g.on(y.touchEvents.start,L,m),y.on("touchmove:active",z),y.on("touchend:passive",B),v.on("routerDestroy",function(){var e=!("touchstart"!==y.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1};g.off(y.touchEvents.start,L,e),y.off("touchmove:active",z),y.off("touchend:passive",B)})}function redirect(e,t,a){var n=this,r=t.route.redirect;if(a.initial&&n.params.pushState&&(a.replaceState=!0,a.history=!0),"function"==typeof r){n.allowPageChange=!1;var i=r.call(n,t,function(t,r){void 0===r&&(r={}),n.allowPageChange=!0,n[e](t,Utils.extend({},a,r))},function(){n.allowPageChange=!0});return i&&"string"==typeof i?(n.allowPageChange=!0,n[e](i,a)):n}return n[e](r,a)}function refreshPage(){return this.navigate(this.currentRoute.url,{ignoreCache:!0,reloadCurrent:!0})}function forward(e,t){void 0===t&&(t={});var a,n,r,i,o=this,s=o.app,l=o.view,p=Utils.extend({animate:o.params.animate,pushState:!0,replaceState:!1,history:!0,reloadCurrent:o.params.reloadPages,reloadPrevious:!1,reloadAll:!1,clearPreviousHistory:!1,on:{}},t),c=o.dynamicNavbar,d=o.separateNavbar,u=o.$el,h=$$1(e),f=p.reloadPrevious||p.reloadCurrent||p.reloadAll;if(h.length&&o.removeThemeElements(h),c&&(r=h.children(".navbar").children(".navbar-inner"),d&&(n=o.$navbarEl,r.length>0&&h.children(".navbar").remove(),0===r.length&&h[0].f7Page&&(r=h[0].f7Page.$navbarEl))),o.allowPageChange=!1,0===h.length)return o.allowPageChange=!0,o;var m,v=u.children(".page:not(.stacked)").filter(function(e,t){return t!==h[0]});if(d&&(m=n.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==r[0]})),p.reloadPrevious&&v.length<2)return o.allowPageChange=!0,o;var g="next";if(p.reloadCurrent||p.reloadAll?g="current":p.reloadPrevious&&(g="previous"),h.addClass("page-"+g).removeClass("stacked"),c&&r.length&&r.addClass("navbar-"+g).removeClass("stacked"),p.reloadCurrent)a=v.eq(v.length-1),d&&(i=$$1(s.navbar.getElByPage(a)));else if(p.reloadPrevious)a=v.eq(v.length-2),d&&(i=$$1(s.navbar.getElByPage(a)));else if(p.reloadAll)a=v.filter(function(e,t){return t!==h[0]}),d&&(i=m.filter(function(e,t){return t!==r[0]}));else{if(v.length>1){var b=0;for(b=0;b<v.length-1;b+=1){var y=s.navbar.getElByPage(v.eq(b));o.params.stackPages?(v.eq(b).addClass("stacked"),d&&$$1(y).addClass("stacked")):(o.pageCallback("beforeRemove",v[b],m&&m[b],"previous",void 0,p),o.removePage(v[b]),d&&y&&o.removeNavbar(y))}}a=u.children(".page:not(.stacked)").filter(function(e,t){return t!==h[0]}),d&&(i=n.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==r[0]}))}if(c&&!d&&(i=a.children(".navbar").children(".navbar-inner")),o.params.pushState&&(p.pushState||p.replaceState)&&!p.reloadPrevious){var w=o.params.pushStateRoot||"";History[p.reloadCurrent||p.reloadAll||p.replaceState?"replace":"push"](l.id,{url:p.route.url},w+o.params.pushStateSeparator+p.route.url)}p.reloadPrevious||(o.currentPageEl=h[0],c&&r.length?o.currentNavbarEl=r[0]:delete o.currentNavbarEl,o.currentRoute=p.route);var $=p.route.url;p.history&&((p.reloadCurrent&&o.history.length)>0||p.replaceState?o.history[o.history.length-(p.reloadPrevious?2:1)]=$:p.reloadPrevious?o.history[o.history.length-2]=$:p.reloadAll?o.history=[$]:o.history.push($)),o.saveHistory();var C=h.parents(doc).length>0,x=h[0].f7Component;if(p.reloadPrevious?(x&&!C?x.$mount(function(e){$$1(e).insertBefore(a)}):h.insertBefore(a),d&&r.length&&(i.length?r.insertBefore(i):(o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),n.append(r)))):(a.next(".page")[0]!==h[0]&&(x&&!C?x.$mount(function(e){u.append(e)}):u.append(h[0])),d&&r.length&&(o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),n.append(r[0]))),C||o.pageCallback("mounted",h,r,g,f?g:"current",p,a),p.reloadCurrent&&a.length>0?o.params.stackPages&&o.initialPages.indexOf(a[0])>=0?(a.addClass("stacked"),d&&i.addClass("stacked")):(o.pageCallback("beforeRemove",a,i,"previous",void 0,p),o.removePage(a),d&&i&&i.length&&o.removeNavbar(i)):p.reloadAll?a.each(function(e,t){var a=$$1(t),n=$$1(s.navbar.getElByPage(a));o.params.stackPages&&o.initialPages.indexOf(a[0])>=0?(a.addClass("stacked"),d&&n.addClass("stacked")):(o.pageCallback("beforeRemove",a,i&&i.eq(e),"previous",void 0,p),o.removePage(a),d&&n.length&&o.removeNavbar(n))}):p.reloadPrevious&&(o.params.stackPages&&o.initialPages.indexOf(a[0])>=0?(a.addClass("stacked"),d&&i.addClass("stacked")):(o.pageCallback("beforeRemove",a,i,"previous",void 0,p),o.removePage(a),d&&i&&i.length&&o.removeNavbar(i))),p.route.route.tab&&o.tabLoad(p.route.route.tab,Utils.extend({},p,{history:!1,pushState:!1})),o.pageCallback("init",h,r,g,f?g:"current",p,a),p.reloadCurrent||p.reloadAll)return o.allowPageChange=!0,o.pageCallback("beforeIn",h,r,g,"current",p),o.pageCallback("afterIn",h,r,g,"current",p),p.reloadCurrent&&p.clearPreviousHistory&&o.clearPreviousHistory(),o;if(p.reloadPrevious)return o.allowPageChange=!0,o;function E(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";h.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),a.removeClass(e).addClass("page-previous").attr("aria-hidden","true"),c&&(r.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),i.removeClass(t).addClass("navbar-previous").attr("aria-hidden","true")),o.allowPageChange=!0,o.pageCallback("afterIn",h,r,"next","current",p),o.pageCallback("afterOut",a,i,"current","previous",p);var n="ios"===s.theme?o.params.preloadPreviousPage||o.params.iosSwipeBack:o.params.preloadPreviousPage;n||(h.hasClass("smart-select-page")||h.hasClass("photo-browser-page")||h.hasClass("autocomplete-page"))&&(n=!0),n||(o.params.stackPages?(a.addClass("stacked"),d&&i.addClass("stacked")):h.attr("data-name")&&"smart-select-page"===h.attr("data-name")||(o.pageCallback("beforeRemove",a,i,"previous",void 0,p),o.removePage(a),d&&i.length&&o.removeNavbar(i))),p.clearPreviousHistory&&o.clearPreviousHistory(),o.emit("routeChanged",o.currentRoute,o.previousRoute,o),o.params.pushState&&History.clearRouterQueue()}function S(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";a.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),h.removeClass(e).addClass("page-next").removeAttr("aria-hidden"),c&&(i.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),r.removeClass(t).addClass("navbar-next").removeAttr("aria-hidden"))}if(o.pageCallback("beforeIn",h,r,"next","current",p),o.pageCallback("beforeOut",a,i,"current","previous",p),p.animate){var k="md"===o.app.theme?o.params.materialPageLoadDelay:o.params.iosPageLoadDelay;k?setTimeout(function(){S(),o.animate(a,h,i,r,"forward",function(){E()})},k):(S(),o.animate(a,h,i,r,"forward",function(){E()}))}else E();return o}function load(e,t,a){void 0===e&&(e={}),void 0===t&&(t={});var n=this;if(!n.allowPageChange&&!a)return n;var r=e,i=t,o=r.url,s=r.content,l=r.el,p=r.pageName,c=r.template,d=r.templateUrl,u=r.component,h=r.componentUrl;if(!i.reloadCurrent&&i.route&&i.route.route&&i.route.route.parentPath&&n.currentRoute.route&&n.currentRoute.route.parentPath===i.route.route.parentPath){if(i.route.url===n.url)return!1;var f=Object.keys(i.route.params).length===Object.keys(n.currentRoute.params).length;if(f&&Object.keys(i.route.params).forEach(function(e){e in n.currentRoute.params&&n.currentRoute.params[e]===i.route.params[e]||(f=!1)}),f)return!!i.route.route.tab&&n.tabLoad(i.route.route.tab,i)}if(i.route&&i.route.url&&n.url===i.route.url&&!i.reloadCurrent&&!i.reloadPrevious&&!n.params.allowDuplicateUrls)return n.allowPageChange=!0,!1;function m(e,t){return n.forward(e,Utils.extend(i,t))}function v(){return n.allowPageChange=!0,n}if(!i.route&&o&&(i.route=n.parseRouteUrl(o),Utils.extend(i.route,{route:{url:o,path:o}})),(o||d||h)&&(n.allowPageChange=!1),s)n.forward(n.getPageEl(s),i);else if(c||d)try{n.pageTemplateLoader(c,d,i,m,v)}catch(e){throw n.allowPageChange=!0,e}else if(l)n.forward(n.getPageEl(l),i);else if(p)n.forward(n.$el.children('.page[data-name="'+p+'"]').eq(0),i);else if(u||h)try{n.pageComponentLoader(n.el,u,h,i,m,v)}catch(e){throw n.allowPageChange=!0,e}else o&&(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(o,i).then(function(e){n.forward(n.getPageEl(e),i)}).catch(function(){n.allowPageChange=!0}));return n}function navigate(e,t){void 0===t&&(t={});var a,n,r=this;"string"==typeof e?a=e:(a=e.url,n=e.route);var i=r.app;if(!r.view)return i.views.main&&i.views.main.router.navigate(a,t),r;if("#"===a||""===a)return r;var o,s=a.replace("./","");if("/"!==s[0]&&0!==s.indexOf("#")){var l=r.currentRoute.parentPath||r.currentRoute.path;s=((l?l+"/":"/")+s).replace("///","/").replace("//","/")}if(!(o=n?Utils.extend(r.parseRouteUrl(s),{route:Utils.extend({},n)}):r.findMatchingRoute(s)))return r;if(o.route.redirect)return redirect.call(r,"navigate",o,t);var p={};return o.route.options?Utils.extend(p,o.route.options,t,{route:o}):Utils.extend(p,t,{route:o}),p&&p.context&&(o.context=p.context,p.route.context=p.context),"popup popover sheet loginScreen actions customModal".split(" ").forEach(function(e){o.route[e]&&r.modalLoad(e,o,p)}),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(e){var t;o.route[e]&&r.load(((t={})[e]=o.route[e],t),p)}),o.route.async&&(r.allowPageChange=!1,o.route.async.call(r,o,r.currentRoute,function(e,t){r.allowPageChange=!1;var a=!1;t&&t.context&&(o.context?o.context=Utils.extend({},o.context,t.context):o.context=t.context,p.route.context=o.context),"popup popover sheet loginScreen actions customModal".split(" ").forEach(function(n){if(e[n]){a=!0;var i=Utils.extend({},o,{route:e});r.allowPageChange=!0,r.modalLoad(n,i,Utils.extend(p,t))}}),a||r.load(e,Utils.extend(p,t),!0)},function(){r.allowPageChange=!0})),r}function tabLoad(e,t){void 0===t&&(t={});var a,n,r=this,i=Utils.extend({animate:r.params.animate,pushState:!0,history:!0,parentPageEl:null,preload:!1,on:{}},t);i.route&&(i.preload||i.route===r.currentRoute||(n=r.previousRoute,r.currentRoute=i.route),i.preload?(a=i.route,n=r.currentRoute):(a=r.currentRoute,n||(n=r.previousRoute)),r.params.pushState&&i.pushState&&!i.reloadPrevious&&History.replace(r.view.id,{url:i.route.url},(r.params.pushStateRoot||"")+r.params.pushStateSeparator+i.route.url),i.history&&(r.history[Math.max(r.history.length-1,0)]=i.route.url,r.saveHistory()));var o,s=$$1(i.parentPageEl||r.currentPageEl);o=s.length&&s.find("#"+e.id).length?s.find("#"+e.id).eq(0):r.view.selector?r.view.selector+" #"+e.id:"#"+e.id;var l=r.app.tab.show({tabEl:o,animate:i.animate,tabRoute:i.route}),p=l.$newTabEl,c=l.$oldTabEl,d=l.animated,u=l.onTabsChanged;if(p&&p.parents(".page").length>0&&i.route){var h=p.parents(".page")[0].f7Page;h&&i.route&&(h.route=i.route)}if(!r.params.unloadTabContent&&p[0].f7RouterTabLoaded)return r;function f(t,a){var n=t.url,i=t.content,o=t.el,s=t.template,l=t.templateUrl,h=t.component,f=t.componentUrl;function m(t){r.allowPageChange=!0,t&&("string"==typeof t?p.html(t):(p.html(""),t.f7Component?t.f7Component.$mount(function(e){p.append(e)}):p.append(t)),r.params.unloadTabContent||(p[0].f7RouterTabLoaded=!0),function(t){r.removeThemeElements(p);var a=p;"string"!=typeof t&&(a=$$1(t)),a.trigger("tab:init tab:mounted",e),r.emit("tabInit tabMounted",p[0],e),c&&r.params.unloadTabContent&&(d?u(function(){r.tabRemove(c,p,e)}):r.tabRemove(c,p,e))}(t))}function v(){return r.allowPageChange=!0,r}if(i)m(i);else if(s||l)try{r.tabTemplateLoader(s,l,a,m,v)}catch(e){throw r.allowPageChange=!0,e}else if(o)m(o);else if(h||f)try{r.tabComponentLoader(p[0],h,f,a,m,v)}catch(e){throw r.allowPageChange=!0,e}else n&&(r.xhr&&(r.xhr.abort(),r.xhr=!1),r.xhrRequest(n,a).then(function(e){m(e)}).catch(function(){r.allowPageChange=!0}))}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(t){var a;e[t]&&f(((a={})[t]=e[t],a),i)}),e.async&&e.async.call(r,a,n,function(e,t){f(e,Utils.extend(i,t))},function(){r.allowPageChange=!0}),r}function tabRemove(e,t,a){var n;e.children().each(function(e,t){t.f7Component&&(n=!0,$$1(t).trigger("tab:beforeremove",a),t.f7Component.$destroy())}),n||e.trigger("tab:beforeremove",a),this.emit("tabBeforeRemove",e[0],t[0],a),this.removeTabContent(e[0],a)}function modalLoad(e,t,a){void 0===a&&(a={});var n,r=this,i=r.app,o=Utils.extend({animate:r.params.animate,pushState:!0,history:!0,on:{}},a),s=Utils.extend({},t.route[e]),l=t.route;function p(){var a=i[e].create(s);l.modalInstance=a;var n=a.el;function p(){a.close()}a.on("modalOpen",function(){n||(r.removeThemeElements(a.el),a.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,a),r.emit("modalInit "+e+"Init "+e+"Mounted",a.el,t,a)),r.once("swipeBackMove",p)}),a.on("modalClose",function(){r.off("swipeBackMove",p),a.closeByRouter||r.back()}),a.on("modalClosed",function(){a.$el.trigger(e.toLowerCase()+":beforeremove",t,a),a.emit("modalBeforeRemove "+e+"BeforeRemove",a.el,t,a);var n=a.el.f7Component;n&&n.$destroy(),Utils.nextTick(function(){(n||s.component)&&r.removeModal(a.el),a.destroy(),delete l.modalInstance})}),o.route&&(r.params.pushState&&o.pushState&&History.push(r.view.id,{url:o.route.url,modal:e},(r.params.pushStateRoot||"")+r.params.pushStateSeparator+o.route.url),o.route!==r.currentRoute&&(r.currentRoute=Utils.extend(o.route,{modal:a})),o.history&&(r.history.push(o.route.url),r.saveHistory())),n&&(r.removeThemeElements(a.el),a.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,a),r.emit("modalInit "+e+"Init "+e+"Mounted",a.el,t,a)),a.open()}function c(e,t){var a=e.url,n=e.content,o=e.template,l=e.templateUrl,c=e.component,d=e.componentUrl;function u(e){e&&("string"==typeof e?s.content=e:e.f7Component?e.f7Component.$mount(function(e){s.el=e,i.root.append(e)}):s.el=e,p())}function h(){return r.allowPageChange=!0,r}if(n)u(n);else if(o||l)try{r.modalTemplateLoader(o,l,t,u,h)}catch(e){throw r.allowPageChange=!0,e}else if(c||d)try{r.modalComponentLoader(i.root[0],c,d,t,u,h)}catch(e){throw r.allowPageChange=!0,e}else a?(r.xhr&&(r.xhr.abort(),r.xhr=!1),r.xhrRequest(a,t).then(function(e){s.content=e,p()}).catch(function(){r.allowPageChange=!0})):p()}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(e){var t;s[e]&&!n&&(n=!0,c(((t={})[e]=s[e],t),o))}),n||"actions"!==e||p(),s.async&&s.async.call(r,o.route,r.currentRoute,function(e,t){c(e,Utils.extend(o,t))},function(){r.allowPageChange=!0}),r}function modalRemove(e){Utils.extend(e,{closeByRouter:!0}),e.close()}function backward(e,t){var a,n,r,i,o=this,s=o.app,l=o.view,p=Utils.extend({animate:o.params.animate,pushState:!0},t),c=o.dynamicNavbar,d=o.separateNavbar,u=$$1(e),h=o.$el.children(".page-current");if(u.length&&o.removeThemeElements(u),c&&(n=u.children(".navbar").children(".navbar-inner"),d?(a=o.$navbarEl,n.length>0&&u.children(".navbar").remove(),0===n.length&&u[0].f7Page&&(n=u[0].f7Page.$navbarEl),r=a.find(".navbar-current")):r=h.children(".navbar").children(".navbar-inner")),o.allowPageChange=!1,0===u.length||0===h.length)return o.allowPageChange=!0,o;if(o.removeThemeElements(u),u.addClass("page-previous").removeClass("stacked").removeAttr("aria-hidden"),c&&n.length>0&&n.addClass("navbar-previous").removeClass("stacked").removeAttr("aria-hidden"),p.force&&(h.prev(".page-previous:not(.stacked)").length>0||0===h.prev(".page-previous").length))if(o.history.indexOf(p.route.url)>=0?(i=o.history.length-o.history.indexOf(p.route.url)-1,o.history=o.history.slice(0,o.history.indexOf(p.route.url)+2),l.history=o.history):o.history[[o.history.length-2]]?o.history[o.history.length-2]=p.route.url:o.history.unshift(o.url),i&&o.params.stackPages)h.prevAll(".page-previous").each(function(e,t){var a,n=$$1(t);d&&(a=$$1(s.navbar.getElByPage(n))),n[0]!==u[0]&&n.index()>u.index()&&(o.initialPages.indexOf(n[0])>=0?(n.addClass("stacked"),d&&a.addClass("stacked")):(o.pageCallback("beforeRemove",n,a,"previous",void 0,p),o.removePage(n),d&&a.length>0&&o.removeNavbar(a)))});else{var f,m=h.prev(".page-previous:not(.stacked)");d&&(f=$$1(s.navbar.getElByPage(m))),o.params.stackPages&&o.initialPages.indexOf(m[0])>=0?(m.addClass("stacked"),f.addClass("stacked")):m.length>0&&(o.pageCallback("beforeRemove",m,f,"previous",void 0,p),o.removePage(m),d&&f.length&&o.removeNavbar(f))}var v,g,b=u.parents(doc).length>0,y=u[0].f7Component;function w(){0===u.next(h).length&&(!b&&y?y.$mount(function(e){$$1(e).insertBefore(h)}):u.insertBefore(h)),d&&n.length&&(n.insertBefore(r),r.length>0?n.insertBefore(r):(o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),a.append(n))),b||o.pageCallback("mounted",u,n,"previous","current",p,h)}if(p.preload)return w(),p.route.route.tab&&o.tabLoad(p.route.route.tab,Utils.extend({},p,{history:!1,pushState:!1,preload:!0})),o.pageCallback("init",u,n,"previous","current",p,h),u.prevAll(".page-previous:not(.stacked)").length>0&&u.prevAll(".page-previous:not(.stacked)").each(function(e,t){var a,n=$$1(t);d&&(a=$$1(s.navbar.getElByPage(n))),o.params.stackPages&&o.initialPages.indexOf(t)>=0?(n.addClass("stacked"),d&&a.addClass("stacked")):(o.pageCallback("beforeRemove",n,a,"previous",void 0),o.removePage(n),d&&a.length&&o.removeNavbar(a))}),o.allowPageChange=!0,o;function $(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";u.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),h.removeClass(e).addClass("page-next").attr("aria-hidden","true"),c&&(n.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),r.removeClass(t).addClass("navbar-next").attr("aria-hidden","true")),o.pageCallback("afterIn",u,n,"previous","current",p),o.pageCallback("afterOut",h,r,"current","next",p),o.params.stackPages&&o.initialPages.indexOf(h[0])>=0?(h.addClass("stacked"),d&&r.addClass("stacked")):(o.pageCallback("beforeRemove",h,r,"next",void 0,p),o.removePage(h),d&&r.length&&o.removeNavbar(r)),o.allowPageChange=!0,o.emit("routeChanged",o.currentRoute,o.previousRoute,o),("ios"===s.theme?o.params.preloadPreviousPage||o.params.iosSwipeBack:o.params.preloadPreviousPage)&&o.back(o.history[o.history.length-2],{preload:!0}),o.params.pushState&&History.clearRouterQueue()}return o.params.pushState&&p.pushState&&(i?History.go(-i):History.back()),1===o.history.length&&o.history.unshift(o.url),o.history.pop(),o.saveHistory(),o.currentPageEl=u[0],c&&n.length?o.currentNavbarEl=n[0]:delete o.currentNavbarEl,o.currentRoute=p.route,w(),p.route.route.tab&&o.tabLoad(p.route.route.tab,Utils.extend({},p,{history:!1,pushState:!1})),o.pageCallback("init",u,n,"previous","current",p,h),o.pageCallback("beforeIn",u,n,"previous","current",p),o.pageCallback("beforeOut",h,r,"current","next",p),p.animate?(v="page-previous page-current page-next",g="navbar-previous navbar-current navbar-next",h.removeClass(v).addClass("page-current"),u.removeClass(v).addClass("page-previous").removeAttr("aria-hidden"),c&&(r.removeClass(g).addClass("navbar-current"),n.removeClass(g).addClass("navbar-previous").removeAttr("aria-hidden")),o.animate(h,u,r,n,"backward",function(){$()})):$(),o}function loadBack(e,t,a){var n=this;if(!n.allowPageChange&&!a)return n;var r=e,i=t,o=r.url,s=r.content,l=r.el,p=r.pageName,c=r.template,d=r.templateUrl,u=r.component,h=r.componentUrl;if(i.route.url&&n.url===i.route.url&&!i.reloadCurrent&&!i.reloadPrevious&&!n.params.allowDuplicateUrls)return!1;function f(e,t){return n.backward(e,Utils.extend(i,t))}function m(){return n.allowPageChange=!0,n}if(!i.route&&o&&(i.route=n.parseRouteUrl(o)),(o||d||h)&&(n.allowPageChange=!1),s)n.backward(n.getPageEl(s),i);else if(c||d)try{n.pageTemplateLoader(c,d,i,f,m)}catch(e){throw n.allowPageChange=!0,e}else if(l)n.backward(n.getPageEl(l),i);else if(p)n.backward(n.$el.children('.page[data-name="'+p+'"]').eq(0),i);else if(u||h)try{n.pageComponentLoader(n.el,u,h,i,f,m)}catch(e){throw n.allowPageChange=!0,e}else o&&(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(o,i).then(function(e){n.backward(n.getPageEl(e),i)}).catch(function(){n.allowPageChange=!0}));return n}function back(){for(var e,t,a=[],n=arguments.length;n--;)a[n]=arguments[n];"object"==typeof a[0]?t=a[0]||{}:(e=a[0],t=a[1]||{});var r=this,i=r.app;if(!r.view)return i.views.main.router.back(e,t),r;var o,s=r.currentRoute.modal;if(s||"popup popover sheet loginScreen actions customModal".split(" ").forEach(function(e){r.currentRoute.route[e]&&(s=!0,o=e)}),s){var l=r.currentRoute.modal||r.currentRoute.route.modalInstance||i[o].get(),p=r.history[r.history.length-2],c=r.findMatchingRoute(p);return!c&&p&&(c={url:p,path:p.split("?")[0],query:Utils.parseUrlQuery(p),route:{path:p.split("?")[0],url:p}}),c&&l?(r.params.pushState&&!1!==t.pushState&&History.back(),r.currentRoute=c,r.history.pop(),r.saveHistory(),r.modalRemove(l),r):r}var d=r.$el.children(".page-current").prevAll(".page-previous").eq(0);if(!t.force&&d.length>0)return r.params.pushState&&d[0].f7Page&&r.history[r.history.length-2]!==d[0].f7Page.route.url?(r.back(r.history[r.history.length-2],Utils.extend(t,{force:!0})),r):(r.loadBack({el:d},Utils.extend(t,{route:d[0].f7Page.route})),r);"#"===e&&(e=void 0),e&&"/"!==e[0]&&0!==e.indexOf("#")&&(e=((r.path||"/")+e).replace("//","/")),!e&&r.history.length>1&&(e=r.history[r.history.length-2]);var u=r.findMatchingRoute(e);if(u||e&&(u={url:e,path:e.split("?")[0],query:Utils.parseUrlQuery(e),route:{path:e.split("?")[0],url:e}}),!u)return r;if(u.route.redirect)return redirect.call(r,"back",u,t);var h={};return u.route.options?Utils.extend(h,u.route.options,t,{route:u}):Utils.extend(h,t,{route:u}),h&&h.context&&(u.context=h.context,h.route.context=h.context),h.force&&r.params.stackPages&&r.$el.children(".page-previous.stacked").each(function(e,t){t.f7Page&&t.f7Page.route&&t.f7Page.route.url===u.url&&r.loadBack({el:t},h)}),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(e){var t;u.route[e]&&r.loadBack(((t={})[e]=u.route[e],t),h)}),u.route.async&&(r.allowPageChange=!1,u.route.async.call(r,u,r.currentRoute,function(e,t){r.allowPageChange=!1,t&&t.context&&(u.context?u.context=Utils.extend({},u.context,t.context):u.context=t.context,h.route.context=u.context),r.loadBack(e,Utils.extend(h,t),!0)},function(){r.allowPageChange=!0})),r}function clearPreviousHistory(){var e=this,t=e.app,a=e.separateNavbar,n=e.history[e.history.length-1],r=$$1(e.currentPageEl);e.$el.children(".page:not(.stacked)").filter(function(e,t){return t!==r[0]}).each(function(n,r){var i=$$1(r),o=$$1(t.navbar.getElByPage(i));e.params.stackPages&&e.initialPages.indexOf(i[0])>=0?(i.addClass("stacked"),a&&o.addClass("stacked")):(e.pageCallback("beforeRemove",i,o,"previous",void 0,{}),e.removePage(i),a&&o.length&&e.removeNavbar(o))}),e.history=[n],e.view.history=[n],e.saveHistory()}var Router=function(e){function t(t,a){e.call(this,{},[void 0===a?t:a]);var n=this;n.isAppRouter=void 0===a,n.isAppRouter?Utils.extend(!1,n,{app:t,params:t.params.view,routes:t.routes||[],cache:t.cache}):Utils.extend(!1,n,{app:t,view:a,viewId:a.id,params:a.params,routes:a.routes,$el:a.$el,el:a.el,$navbarEl:a.$navbarEl,navbarEl:a.navbarEl,history:a.history,scrollHistory:a.scrollHistory,cache:t.cache,dynamicNavbar:"ios"===t.theme&&a.params.iosDynamicNavbar,separateNavbar:"ios"===t.theme&&a.params.iosDynamicNavbar&&a.params.iosSeparateDynamicNavbar,initialPages:[],initialNavbars:[]}),n.useModules(),n.tempDom=doc.createElement("div"),n.allowPageChange=!0;var r={},i={};return Object.defineProperty(n,"currentRoute",{enumerable:!0,configurable:!0,set:function(e){void 0===e&&(e={}),i=Utils.extend({},r),(r=e)&&(n.url=r.url,n.emit("routeChange",e,i,n))},get:function(){return r}}),Object.defineProperty(n,"previousRoute",{enumerable:!0,configurable:!0,get:function(){return i},set:function(e){i=e}}),Utils.extend(n,{forward:forward,load:load,navigate:navigate,refreshPage:refreshPage,tabLoad:tabLoad,tabRemove:tabRemove,modalLoad:modalLoad,modalRemove:modalRemove,backward:backward,loadBack:loadBack,back:back,clearPreviousHistory:clearPreviousHistory}),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.animatableNavElements=function(e,t){var a,n,r=this.dynamicNavbar,i=this.params.iosAnimateNavbarBackIcon;function o(e,t){var a,n=$$1(e),r=n.hasClass("sliding")||t.hasClass("sliding"),o=n.hasClass("subnavbar"),s=!r||!o,l=r&&i&&n.hasClass("left")&&n.find(".back .icon").length>0;return l&&(a=n.find(".back .icon")),{$el:n,$iconEl:a,hasIcon:l,leftOffset:n[0].f7NavbarLeftOffset,rightOffset:n[0].f7NavbarRightOffset,isSliding:r,isSubnavbar:o,needsOpacityTransition:s}}return r&&(a=[],n=[],e.children(".left, .right, .title, .subnavbar").each(function(t,n){a.push(o(n,e))}),t.children(".left, .right, .title, .subnavbar").each(function(e,a){n.push(o(a,t))}),[n,a].forEach(function(e){e.forEach(function(t){var r=t,i=t.isSliding,o=t.$el,s=e===n?a:n;i&&o.hasClass("title")&&s&&s.forEach(function(e){if(e.$el.hasClass("left")&&e.hasIcon){var t=e.$el.find(".back span")[0];r.leftOffset+=t?t.offsetLeft:0}})})})),{newNavEls:a,oldNavEls:n}},t.prototype.animateWithCSS=function(e,t,a,n,r,i){var o,s,l=this,p=l.dynamicNavbar,c=l.separateNavbar,d="ios"===l.app.theme,u="router-transition-"+r+" router-transition-css-"+r,h=0;if(d&&p){c||(h=n[0].offsetWidth);var f=l.animatableNavElements(n,a);o=f.newNavEls,s=f.oldNavEls}function m(e){d&&p&&(o.forEach(function(t){var a=t.$el,n="forward"===r?t.rightOffset:t.leftOffset;t.isSliding&&a.transform("translate3d("+n*(1-e)+"px,0,0)"),t.hasIcon&&("forward"===r?t.$iconEl.transform("translate3d("+(-n-h)*(1-e)+"px,0,0)"):t.$iconEl.transform("translate3d("+(h/5-n)*(1-e)+"px,0,0)"))}),s.forEach(function(t){var a=t.$el,n="forward"===r?t.leftOffset:t.rightOffset;t.isSliding&&a.transform("translate3d("+n*e+"px,0,0)"),t.hasIcon&&("forward"===r?t.$iconEl.transform("translate3d("+(h/5-n)*e+"px,0,0)"):t.$iconEl.transform("translate3d("+(-n-h)*e+"px,0,0)"))}))}("forward"===r?t:e).animationEnd(function(){l.dynamicNavbar&&(n.hasClass("sliding")?n.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):n.find(".sliding").transform(""),a.hasClass("sliding")?a.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):a.find(".sliding").transform("")),l.$el.removeClass(u),i&&i()}),p?(m(0),Utils.nextTick(function(){m(1),l.$el.addClass(u)})):l.$el.addClass(u)},t.prototype.animateWithJS=function(e,t,a,n,r,i){var o,s,l,p,c=this,d=c.dynamicNavbar,u=c.separateNavbar,h="ios"===c.app.theme,f=h?400:250,m="router-transition-"+r+" router-transition-js-"+r,v=null,g=!1,b=0;if(h&&d){u||(b=n[0].offsetWidth);var y=c.animatableNavElements(n,a);o=y.newNavEls,s=y.oldNavEls}h&&(l=$$1('<div class="page-shadow-effect"></div>'),p=$$1('<div class="page-opacity-effect"></div>'),"forward"===r?(t.append(l),e.append(p)):(t.append(p),e.append(l)));var w=Utils.bezier(.25,.1,.25,1);c.$el.addClass(m),Utils.nextFrame(function a(){var n=Utils.now();v||(v=n);var u=Math.max(Math.min((n-v)/f,1),0),y=w(u);u>=1&&(g=!0);var $=c.app.rtl?-1:1;if(h?("forward"===r?(t.transform("translate3d("+100*(1-y)*$+"%,0,0)"),e.transform("translate3d("+20*-y*$+"%,0,0)"),l[0].style.opacity=y,p[0].style.opacity=y):(t.transform("translate3d("+20*-(1-y)*$+"%,0,0)"),e.transform("translate3d("+100*y*$+"%,0,0)"),l[0].style.opacity=1-y,p[0].style.opacity=1-y),d&&(o.forEach(function(e){var t=e.$el,a="forward"===r?e.rightOffset:e.leftOffset;e.needsOpacityTransition&&(t[0].style.opacity=y),e.isSliding&&t.transform("translate3d("+a*(1-y)+"px,0,0)"),e.hasIcon&&("forward"===r?e.$iconEl.transform("translate3d("+(-a-b)*(1-y)+"px,0,0)"):e.$iconEl.transform("translate3d("+(b/5-a)*(1-y)+"px,0,0)"))}),s.forEach(function(e){var t=e.$el,a="forward"===r?e.leftOffset:e.rightOffset;e.needsOpacityTransition&&(t[0].style.opacity=1-y),e.isSliding&&t.transform("translate3d("+a*y+"px,0,0)"),e.hasIcon&&("forward"===r?e.$iconEl.transform("translate3d("+(b/5-a)*y+"px,0,0)"):e.$iconEl.transform("translate3d("+(-a-b)*y+"px,0,0)"))}))):"forward"===r?(t.transform("translate3d(0, "+56*(1-y)+"px,0)"),t.css("opacity",y)):(e.transform("translate3d(0, "+56*y+"px,0)"),e.css("opacity",1-y)),g)return t.transform("").css("opacity",""),e.transform("").css("opacity",""),h&&(l.remove(),p.remove(),d&&(o.forEach(function(e){e.$el.transform(""),e.$el.css("opacity","")}),s.forEach(function(e){e.$el.transform(""),e.$el.css("opacity","")}),o=[],s=[])),c.$el.removeClass(m),void(i&&i());Utils.nextFrame(a)})},t.prototype.animate=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=this;a.params.animateCustom?a.params.animateCustom.apply(a,e):a.params.animateWithJS?a.animateWithJS.apply(a,e):a.animateWithCSS.apply(a,e)},t.prototype.removeModal=function(e){this.removeEl(e)},t.prototype.removeTabContent=function(e){$$1(e).html("")},t.prototype.removeNavbar=function(e){this.removeEl(e)},t.prototype.removePage=function(e){this.removeEl(e)},t.prototype.removeEl=function(e){if(e){var t=$$1(e);0!==t.length&&(t[0].f7Component&&t[0].f7Component.$destroy&&t[0].f7Component.$destroy(),t.find(".tab").each(function(e,t){$$1(t).children().each(function(e,t){t.f7Component&&($$1(t).trigger("tab:beforeremove"),t.f7Component.$destroy())})}),this.params.removeElements&&(this.params.removeElementsWithTimeout?setTimeout(function(){t.remove()},this.params.removeElementsTimeout):t.remove()))}},t.prototype.getPageEl=function(e){var t=this;if("string"==typeof e)t.tempDom.innerHTML=e;else{if($$1(e).hasClass("page"))return e;t.tempDom.innerHTML="",$$1(t.tempDom).append(e)}return t.findElement(".page",t.tempDom)},t.prototype.findElement=function(e,t,a){var n=this.view,r=this.app,i=$$1(t),o=e;a&&(o+=":not(.stacked)");var s=i.find(o).filter(function(e,t){return 0===$$1(t).parents(".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page").length});return s.length>1&&("string"==typeof n.selector&&(s=i.find(n.selector+" "+o)),s.length>1&&(s=i.find("."+r.params.viewMainClass+" "+o))),1===s.length?s:(a||(s=this.findElement(o,i,!0)),s&&1===s.length?s:s&&s.length>1?$$1(s[0]):void 0)},t.prototype.flattenRoutes=function(e){var t=this;void 0===e&&(e=this.routes);var a=[];return e.forEach(function(e){if("routes"in e){var n=e.routes.map(function(t){var a=Utils.extend({},t);return a.path=(e.path+"/"+a.path).replace("///","/").replace("//","/"),a});a=a.concat(e,t.flattenRoutes(n))}else if("tabs"in e&&e.tabs){var r=e.tabs.map(function(t){var a=Utils.extend({},e,{path:(e.path+"/"+t.path).replace("///","/").replace("//","/"),parentPath:e.path,tab:t});return delete a.tabs,a});a=a.concat(t.flattenRoutes(r))}else a.push(e)}),a},t.prototype.parseRouteUrl=function(e){if(!e)return{};return{query:Utils.parseUrlQuery(e),hash:e.split("#")[1],params:{},url:e,path:e.split("#")[0].split("?")[0]}},t.prototype.findTabRoute=function(e){var t,a=$$1(e),n=this.currentRoute.route.parentPath,r=a.attr("id");return this.flattenRoutes(this.routes).forEach(function(e){e.parentPath===n&&e.tab&&e.tab.id===r&&(t=e)}),t},t.prototype.findRouteByKey=function(e,t){var a,n=this.routes;return this.flattenRoutes(n).forEach(function(n){a||n[e]===t&&(a=n)}),a},t.prototype.findMatchingRoute=function(e){if(e){var t,a=this.routes,n=this.flattenRoutes(a),r=this.parseRouteUrl(e),i=r.path,o=r.query,s=r.hash,l=r.params;return n.forEach(function(a){if(!t){var n,r,p=[],c=[a.path];if(a.alias&&("string"==typeof a.alias?c.push(a.alias):Array.isArray(a.alias)&&a.alias.forEach(function(e){c.push(e)})),c.forEach(function(e){n||(n=pathToRegexp_1(e,p).exec(i))}),n)p.forEach(function(e,t){var a=n[t+1];l[e.name]=a}),a.parentPath&&(r=i.split("/").slice(0,a.parentPath.split("/").length-1).join("/")),t={query:o,hash:s,params:l,url:e,path:i,parentPath:r,route:a,name:a.name}}}),t}},t.prototype.removeFromXhrCache=function(e){for(var t=this.cache.xhr,a=!1,n=0;n<t.length;n+=1)t[n].url===e&&(a=n);!1!==a&&t.splice(a,1)},t.prototype.xhrRequest=function(e,t){var a=this,n=a.params,r=t.ignoreCache,i=e,o=i.indexOf("?")>=0;return n.passRouteQueryToRequest&&t&&t.route&&t.route.query&&Object.keys(t.route.query).length&&(i+=(o?"&":"?")+Utils.serializeObject(t.route.query),o=!0),n.passRouteParamsToRequest&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&(i+=(o?"&":"?")+Utils.serializeObject(t.route.params),o=!0),i.indexOf("{{")>=0&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&Object.keys(t.route.params).forEach(function(e){var a=new RegExp("{{"+e+"}}","g");i=i.replace(a,t.route.params[e]||"")}),n.xhrCacheIgnoreGetParameters&&i.indexOf("?")>=0&&(i=i.split("?")[0]),Utils.promise(function(e,o){if(n.xhrCache&&!r&&i.indexOf("nocache")<0&&n.xhrCacheIgnore.indexOf(i)<0)for(var s=0;s<a.cache.xhr.length;s+=1){var l=a.cache.xhr[s];if(l.url===i&&Utils.now()-l.time<n.xhrCacheDuration)return void e(l.content)}a.xhr=a.app.request({url:i,method:"GET",beforeSend:function(e){a.emit("routerAjaxStart",e,t)},complete:function(r,s){a.emit("routerAjaxComplete",r),"error"!==s&&"timeout"!==s&&r.status>=200&&r.status<300||0===r.status?(n.xhrCache&&""!==r.responseText&&(a.removeFromXhrCache(i),a.cache.xhr.push({url:i,time:Utils.now(),content:r.responseText})),a.emit("routerAjaxSuccess",r,t),e(r.responseText)):(a.emit("routerAjaxError",r,t),o(r))},error:function(e){a.emit("routerAjaxError",e,t),o(e)}})})},t.prototype.removeThemeElements=function(e){var t=this.app.theme;$$1(e).find("."+("md"===t?"ios":"md")+"-only, .if-"+("md"===t?"ios":"md")).remove()},t.prototype.templateLoader=function(e,t,a,n,r){var i=this;function o(e){var t,o;try{if("function"==typeof(o=a.context||{}))o=o.call(i);else if("string"==typeof o)try{o=JSON.parse(o)}catch(e){throw r(),e}t="function"==typeof e?e(o):Template7.compile(e)(Utils.extend({},o||{},{$app:i.app,$root:Utils.extend({},i.app.data,i.app.methods),$route:a.route,$router:i,$theme:{ios:"ios"===i.app.theme,md:"md"===i.app.theme}}))}catch(e){throw r(),e}n(t,{context:o})}t?(i.xhr&&(i.xhr.abort(),i.xhr=!1),i.xhrRequest(t,a).then(function(e){o(e)}).catch(function(){r()})):o(e)},t.prototype.modalTemplateLoader=function(e,t,a,n,r){return this.templateLoader(e,t,a,function(e){n(e)},r)},t.prototype.tabTemplateLoader=function(e,t,a,n,r){return this.templateLoader(e,t,a,function(e){n(e)},r)},t.prototype.pageTemplateLoader=function(e,t,a,n,r){var i=this;return i.templateLoader(e,t,a,function(e,t){void 0===t&&(t={}),n(i.getPageEl(e),t)},r)},t.prototype.componentLoader=function(e,t,a,n,r){void 0===a&&(a={});var i=this,o="string"==typeof e?e:t;function s(e){var t=a.context||{};if("function"==typeof t)t=t.call(i);else if("string"==typeof t)try{t=JSON.parse(t)}catch(e){throw r(),e}var o=Utils.merge({},t,{$:$$1,$$:$$1,$app:i.app,$root:Utils.merge({},i.app.data,i.app.methods),$route:a.route,$router:i,$dom7:$$1,$theme:{ios:"ios"===i.app.theme,md:"md"===i.app.theme}}),s=Component.create(e,o);n(s.el)}o?(i.xhr&&(i.xhr.abort(),i.xhr=!1),i.xhrRequest(o,a).then(function(e){s(Component.parse(e))}).catch(function(e){throw r(),e})):s(e)},t.prototype.modalComponentLoader=function(e,t,a,n,r,i){this.componentLoader(t,a,n,function(e){r(e)},i)},t.prototype.tabComponentLoader=function(e,t,a,n,r,i){this.componentLoader(t,a,n,function(e){r(e)},i)},t.prototype.pageComponentLoader=function(e,t,a,n,r,i){this.componentLoader(t,a,n,function(e,t){void 0===t&&(t={}),r(e,t)},i)},t.prototype.getPageData=function(e,t,a,n,r,i){void 0===r&&(r={});var o,s,l=$$1(e),p=$$1(t),c=l[0].f7Page||{};if(("next"===a&&"current"===n||"current"===a&&"previous"===n)&&(o="forward"),("current"===a&&"next"===n||"previous"===a&&"current"===n)&&(o="backward"),c&&!c.fromPage){var d=$$1(i);d.length&&(s=d[0].f7Page)}(s=c.pageFrom||s)&&s.pageFrom&&(s.pageFrom=null);var u={app:this.app,view:this.view,router:this,$el:l,el:l[0],$pageEl:l,pageEl:l[0],$navbarEl:p,navbarEl:p[0],name:l.attr("data-name"),position:a,from:a,to:n,direction:o,route:c.route?c.route:r,pageFrom:s};return p&&p[0]&&(p[0].f7Page=u),l[0].f7Page=u,u},t.prototype.pageCallback=function(e,t,a,n,r,i,o){if(void 0===i&&(i={}),t){var s=this,l=$$1(t);if(l.length){var p=i.route,c=s.params.restoreScrollTopOnBack,d="page"+(e[0].toUpperCase()+e.slice(1,e.length)),u="page:"+e.toLowerCase(),h={};(h="beforeRemove"===e&&l[0].f7Page?Utils.extend(l[0].f7Page,{from:n,to:r,position:n}):s.getPageData(t,a,n,r,p,o)).swipeBack=!!i.swipeBack;var f=i.route?i.route.route:{},m=f.on;void 0===m&&(m={});var v=f.once;if(void 0===v&&(v={}),i.on&&Utils.extend(m,i.on),i.once&&Utils.extend(v,i.once),"mounted"===e&&y(),"init"===e){if(c&&("previous"===n||!n)&&"current"===r&&s.scrollHistory[h.route.url]&&!l.hasClass("no-restore-scroll")){var g=l.find(".page-content");g.length>0&&(g=g.filter(function(e,t){return 0===$$1(t).parents(".tab:not(.tab-active)").length&&!$$1(t).is(".tab:not(.tab-active)")})),g.scrollTop(s.scrollHistory[h.route.url])}if(y(),l[0].f7PageInitialized)return l.trigger("page:reinit",h),void s.emit("pageReinit",h);l[0].f7PageInitialized=!0}if(c&&"beforeOut"===e&&"current"===n&&"previous"===r){var b=l.find(".page-content");b.length>0&&(b=b.filter(function(e,t){return 0===$$1(t).parents(".tab:not(.tab-active)").length&&!$$1(t).is(".tab:not(.tab-active)")})),s.scrollHistory[h.route.url]=b.scrollTop()}c&&"beforeOut"===e&&"current"===n&&"next"===r&&delete s.scrollHistory[h.route.url],l.trigger(u,h),s.emit(d,h),"beforeRemove"===e&&(l[0].f7RouteEventsAttached&&(l[0].f7RouteEventsOn&&Object.keys(l[0].f7RouteEventsOn).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOn[e])}),l[0].f7RouteEventsOnce&&Object.keys(l[0].f7RouteEventsOnce).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOnce[e])}),l[0].f7RouteEventsAttached=null,l[0].f7RouteEventsOn=null,l[0].f7RouteEventsOnce=null,delete l[0].f7RouteEventsAttached,delete l[0].f7RouteEventsOn,delete l[0].f7RouteEventsOnce),l[0].f7Page=null)}}function y(){l[0].f7RouteEventsAttached||(l[0].f7RouteEventsAttached=!0,m&&Object.keys(m).length>0&&(l[0].f7RouteEventsOn=m,Object.keys(m).forEach(function(e){m[e]=m[e].bind(s),l.on(Utils.eventNameToColonCase(e),m[e])})),v&&Object.keys(v).length>0&&(l[0].f7RouteEventsOnce=v,Object.keys(v).forEach(function(e){v[e]=v[e].bind(s),l.once(Utils.eventNameToColonCase(e),v[e])})))}},t.prototype.saveHistory=function(){var e=this;e.view.history=e.history,e.params.pushState&&(win.localStorage["f7router-"+e.view.id+"-history"]=JSON.stringify(e.history))},t.prototype.restoreHistory=function(){var e=this;e.params.pushState&&win.localStorage["f7router-"+e.view.id+"-history"]&&(e.history=JSON.parse(win.localStorage["f7router-"+e.view.id+"-history"]),e.view.history=e.history)},t.prototype.clearHistory=function(){this.history=[],this.view&&(this.view.history=[]),this.saveHistory()},t.prototype.init=function(){var e=this,t=e.app,a=e.view;(a&&e.params.iosSwipeBack&&"ios"===t.theme||a&&e.params.mdSwipeBack&&"md"===t.theme)&&SwipeBack(e),e.dynamicNavbar&&!e.separateNavbar&&e.$el.addClass("router-dynamic-navbar-inside");var n,r,i,o=e.params.url,s=doc.location.href.split(doc.location.origin)[1];(e.params.pushState&&e.params.pushStateOnLoad?(e.params.pushStateRoot&&s.indexOf(e.params.pushStateRoot)>=0&&""===(s=s.split(e.params.pushStateRoot)[1])&&(s="/"),o=e.params.pushStateSeparator.length>0&&s.indexOf(e.params.pushStateSeparator)>=0?s.split(e.params.pushStateSeparator)[1]:s,e.restoreHistory(),e.history.indexOf(o)>=0?e.history=e.history.slice(0,e.history.indexOf(o)+1):e.params.url===o?e.history=[o]:History.state&&History.state[a.id]&&History.state[a.id].url===e.history[e.history.length-1]?o=e.history[e.history.length-1]:e.history=[s.split(e.params.pushStateSeparator)[0]||"/",o],e.history.length>1?n=!0:e.history=[],e.saveHistory()):(o||(o=s),doc.location.search&&o.indexOf("?")<0&&(o+=doc.location.search),doc.location.hash&&o.indexOf("#")<0&&(o+=doc.location.hash)),e.history.length>1?(r=e.findMatchingRoute(e.history[0]))||(r=Utils.extend(e.parseRouteUrl(e.history[0]),{route:{url:e.history[0],path:e.history[0].split("?")[0]}})):(r=e.findMatchingRoute(o))||(r=Utils.extend(e.parseRouteUrl(o),{route:{url:o,path:o.split("?")[0]}})),e.params.stackPages&&e.$el.children(".page").each(function(t,a){var n=$$1(a);e.initialPages.push(n[0]),e.separateNavbar&&n.children(".navbar").length>0&&e.initialNavbars.push(n.children(".navbar").find(".navbar-inner")[0])}),0===e.$el.children(".page:not(.stacked)").length&&o)?e.navigate(o,{initial:!0,reloadCurrent:!0,pushState:!1}):(e.currentRoute=r,e.$el.children(".page:not(.stacked)").each(function(t,a){var n,r=$$1(a);r.addClass("page-current"),e.separateNavbar&&((n=r.children(".navbar").children(".navbar-inner")).length>0?(e.$navbarEl.parents(doc).length||e.$el.prepend(e.$navbarEl),e.$navbarEl.append(n),r.children(".navbar").remove()):e.$navbarEl.addClass("navbar-hidden"));var o={route:e.currentRoute};e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.options&&Utils.extend(o,e.currentRoute.route.options),e.currentPageEl=r[0],e.dynamicNavbar&&n.length&&(e.currentNavbarEl=n[0]),e.removeThemeElements(r),e.dynamicNavbar&&n.length&&e.removeThemeElements(n),o.route.route.tab&&(i=!0,e.tabLoad(o.route.route.tab,Utils.extend({},o))),e.pageCallback("init",r,n,"current",void 0,o)}),n&&e.navigate(o,{initial:!0,pushState:!1,history:!1,animate:e.params.pushStateAnimateOnLoad,once:{pageAfterIn:function(){e.history.length>2&&e.back({preload:!0})}}}),n||i||(e.history.push(o),e.saveHistory()));!(o&&e.params.pushState&&e.params.pushStateOnLoad)||History.state&&History.state[a.id]||History.initViewState(a.id,{url:o}),e.emit("local::init routerInit",e)},t.prototype.destroy=function(){var e=this;e.emit("local::destroy routerDestroy",e),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},t}(Framework7Class),Router$1={name:"router",static:{Router:Router},instance:{cache:{xhr:[],templates:[],components:[]}},create:function(){var e=this;e.app?e.params.router&&(e.router=new Router(e.app,e)):e.router=new Router(e)}},View=function(e){function t(t,a,n){void 0===n&&(n={}),e.call(this,n,[t]);var r,i,o,s=t,l=$$1(a),p=this;return p.params=Utils.extend({routes:[],routesAdd:[]},s.params.view,n),p.params.routes.length>0?p.routes=p.params.routes:p.routes=[].concat(s.routes,p.params.routesAdd),r="string"==typeof a?a:(l.attr("id")?"#"+l.attr("id"):"")+(l.attr("class")?"."+l.attr("class").replace(/ /g,".").replace(".active",""):""),"ios"===s.theme&&p.params.iosDynamicNavbar&&p.params.iosSeparateDynamicNavbar&&0===(i=l.children(".navbar").eq(0)).length&&(i=$$1('<div class="navbar"></div>')),Utils.extend(!1,p,{app:s,$el:l,el:l[0],name:p.params.name,main:p.params.main||l.hasClass("view-main"),$navbarEl:i,navbarEl:i?i[0]:void 0,selector:r,history:[],scrollHistory:{}}),l[0].f7View=p,p.useModules(),s.views.push(p),p.main&&(s.views.main=p),p.name&&(s.views[p.name]=p),p.index=s.views.indexOf(p),o=p.name?"view_"+p.name:p.main?"view_main":"view_"+p.index,p.id=o,s.initialized?p.init():s.on("init",function(){p.init()}),p}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.destroy=function(){var e=this,t=e.app;e.$el.trigger("view:beforedestroy",e),e.emit("local::beforeDestroy viewBeforeDestroy",e),e.main?(t.views.main=null,delete t.views.main):e.name&&(t.views[e.name]=null,delete t.views[e.name]),e.$el[0].f7View=null,delete e.$el[0].f7View,t.views.splice(t.views.indexOf(e),1),e.params.router&&e.router&&e.router.destroy(),e.emit("local::destroy viewDestroy",e),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},t.prototype.init=function(){this.params.router&&this.router.init()},t}(Framework7Class);function initClicks(e){if(e.on("click",function(t){var a=$$1(t.target),n=a.closest("a"),r=n.length>0,i=r&&n.attr("href"),o=r&&n.hasClass("tab-link")&&(n.attr("data-tab")||i&&0===i.indexOf("#"));if(r&&(n.is(e.params.clicks.externalLinks)||i&&i.indexOf("javascript:")>=0)){var s=n.attr("target");!i||"_system"!==s&&"_blank"!==s&&"_browser"!==s||(t.preventDefault(),"_browser"!==s&&win.cordova&&win.cordova.InAppBrowser?win.cordova.InAppBrowser.open(i,s):win.open(i,s))}else{Object.keys(e.modules).forEach(function(t){var n=e.modules[t].clicks;n&&Object.keys(n).forEach(function(t){var r=a.closest(t).eq(0);r.length>0&&n[t].call(e,r,r.dataset())})});var l={};r&&(t.preventDefault(),l=n.dataset());var p=i&&i.length>0&&"#"!==i&&!o,c=l.template;if(p||n.hasClass("back")||c){var d;if(l.view?d=$$1(l.view)[0].f7View:(d=a.parents(".view")[0]&&a.parents(".view")[0].f7View,!n.hasClass("back")&&d&&d.params.linksView&&("string"==typeof d.params.linksView?d=$$1(d.params.linksView)[0].f7View:d.params.linksView instanceof View&&(d=d.params.linksView))),d||e.views.main&&(d=e.views.main),!d||!d.router)return;if(l.context&&"string"==typeof l.context)try{l.context=JSON.parse(l.context)}catch(e){}n.hasClass("back")?d.router.back(i,l):d.router.navigate(i,l)}}}),Support.touch&&!Device.android){var t=!!Support.passiveListener&&{passive:!1,capture:!1};$$1(doc).on(e.params.touch.fastClicks?"touchstart":"touchmove",".panel-backdrop, .dialog-backdrop, .preloader-backdrop, .popup-backdrop, .searchbar-backdrop",function(e){e.preventDefault()},t)}}View.use(Router$1);var ClicksModule={name:"clicks",params:{clicks:{externalLinks:".external"}},on:{init:function(){initClicks(this)}}},HistoryModule={name:"history",static:{history:History},on:{init:function(){History.init(this)}}},keyPrefix="f7storage-",Storage={get:function(e){return Utils.promise(function(t,a){try{t(JSON.parse(win.localStorage.getItem(""+keyPrefix+e)))}catch(e){a(e)}})},set:function(e,t){return Utils.promise(function(a,n){try{win.localStorage.setItem(""+keyPrefix+e,JSON.stringify(t)),a()}catch(e){n(e)}})},remove:function(e){return Utils.promise(function(t,a){try{win.localStorage.removeItem(""+keyPrefix+e),t()}catch(e){a(e)}})},clear:function(){},length:function(){},keys:function(){return Utils.promise(function(e,t){try{e(Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).map(function(e){return e.replace(keyPrefix,"")}))}catch(e){t(e)}})},forEach:function(e){return Utils.promise(function(t,a){try{Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).forEach(function(t,a){var n=t.replace(keyPrefix,"");Storage.get(n).then(function(t){e(n,t,a)})}),t()}catch(e){a(e)}})}},StorageModule={name:"storage",static:{Storage:Storage,storage:Storage}},Statusbar={hide:function(){$$1("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&win.StatusBar.hide()},show:function(){if(Device.cordova&&win.StatusBar)return win.StatusBar.show(),void Utils.nextTick(function(){Device.needsStatusbarOverlay()&&$$1("html").addClass("with-statusbar")});$$1("html").addClass("with-statusbar")},onClick:function(){var e;(e=$$1(".popup.modal-in").length>0?$$1(".popup.modal-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$$1(".panel.panel-active").length>0?$$1(".panel.panel-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$$1(".views > .view.tab-active").length>0?$$1(".views > .view.tab-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$$1(".views").length>0?$$1(".views").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):this.root.children(".view").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"))&&e.length>0&&(e.hasClass("tab")&&(e=e.parent(".tabs").children(".page-content.tab-active")),e.length>0&&e.scrollTop(0,300))},setIosTextColor:function(e){Device.cordova&&win.StatusBar&&("white"===e?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())},setBackgroundColor:function(e){$$1(".statusbar").css("background-color",e),Device.cordova&&win.StatusBar&&win.StatusBar.backgroundColorByHexString(e)},isVisible:function(){return!(!Device.cordova||!win.StatusBar)&&win.StatusBar.isVisible},iosOverlaysWebView:function(e){void 0===e&&(e=!0),Device.ios&&Device.cordova&&win.StatusBar&&(win.StatusBar.overlaysWebView(e),e?$$1("html").addClass("with-statusbar"):$$1("html").removeClass("with-statusbar"))},checkOverlay:function(){Device.needsStatusbarOverlay()?$$1("html").addClass("with-statusbar"):$$1("html").removeClass("with-statusbar")},init:function(){var e=this,t=e.params.statusbar;t.enabled&&("auto"===t.overlay?(Device.needsStatusbarOverlay()?$$1("html").addClass("with-statusbar"):$$1("html").removeClass("with-statusbar"),Device.ios&&(Device.cordova||Device.webView)&&(0===win.orientation&&e.once("resize",function(){Statusbar.checkOverlay()}),$$1(doc).on("resume",function(){Statusbar.checkOverlay()},!1),e.on(Device.ios?"orientationchange":"orientationchange resize",function(){Statusbar.checkOverlay()}))):!0===t.overlay?$$1("html").addClass("with-statusbar"):!1===t.overlay&&$$1("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&(t.scrollTopOnClick&&$$1(win).on("statusTap",Statusbar.onClick.bind(e)),t.iosOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===t.iosTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault()),t.iosBackgroundColor&&"ios"===e.theme&&Statusbar.setBackgroundColor(t.iosBackgroundColor),t.materialBackgroundColor&&"md"===e.theme&&Statusbar.setBackgroundColor(t.materialBackgroundColor))}},Statusbar$1={name:"statusbar",params:{statusbar:{enabled:!0,overlay:"auto",scrollTopOnClick:!0,iosOverlaysWebView:!0,iosTextColor:"black",iosBackgroundColor:null,materialBackgroundColor:null}},create:function(){Utils.extend(this,{statusbar:{checkOverlay:Statusbar.checkOverlay,hide:Statusbar.hide,show:Statusbar.show,iosOverlaysWebView:Statusbar.iosOverlaysWebView,setIosTextColor:Statusbar.setIosTextColor,setBackgroundColor:Statusbar.setBackgroundColor,isVisible:Statusbar.isVisible,init:Statusbar.init.bind(this)}})},on:{init:function(){Statusbar.init.call(this)}},clicks:{".statusbar":function(){this.params.statusbar.enabled&&this.params.statusbar.scrollTopOnClick&&Statusbar.onClick.call(this)}}};function getCurrentView(e){var t=$$1(".popover.modal-in .view"),a=$$1(".popup.modal-in .view"),n=$$1(".panel.panel-active .view"),r=$$1(".views");0===r.length&&(r=e.root);var i=r.children(".view");if(i.length>1&&i.hasClass("tab")&&(i=r.children(".view.tab-active")),t.length>0&&t[0].f7View)return t[0].f7View;if(a.length>0&&a[0].f7View)return a[0].f7View;if(n.length>0&&n[0].f7View)return n[0].f7View;if(i.length>0){if(1===i.length&&i[0].f7View)return i[0].f7View;if(i.length>1)return e.views.main}}var View$1={name:"view",params:{view:{name:void 0,main:!1,router:!0,linksView:null,stackPages:!1,xhrCache:!0,xhrCacheIgnore:[],xhrCacheIgnoreGetParameters:!1,xhrCacheDuration:6e5,preloadPreviousPage:!0,uniqueHistory:!1,uniqueHistoryIgnoreGetParameters:!1,allowDuplicateUrls:!1,reloadPages:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,restoreScrollTopOnBack:!0,unloadTabContent:!0,passRouteQueryToRequest:!0,passRouteParamsToRequest:!1,iosSwipeBack:!0,iosSwipeBackAnimateShadow:!0,iosSwipeBackAnimateOpacity:!0,iosSwipeBackActiveArea:30,iosSwipeBackThreshold:0,mdSwipeBack:!1,mdSwipeBackAnimateShadow:!0,mdSwipeBackAnimateOpacity:!1,mdSwipeBackActiveArea:30,mdSwipeBackThreshold:0,pushState:!1,pushStateRoot:void 0,pushStateAnimate:!0,pushStateAnimateOnLoad:!1,pushStateSeparator:"#!",pushStateOnLoad:!0,animate:!0,animateWithJS:!1,iosDynamicNavbar:!0,iosSeparateDynamicNavbar:!0,iosAnimateNavbarBackIcon:!0,iosPageLoadDelay:0,materialPageLoadDelay:0}},static:{View:View},create:function(){var e=this;Utils.extend(e,{views:Utils.extend([],{create:function(t,a){return new View(e,t,a)},get:function(e){var t=$$1(e);if(t.length&&t[0].f7View)return t[0].f7View}})}),Object.defineProperty(e.views,"current",{enumerable:!0,configurable:!0,get:function(){return getCurrentView(e)}}),e.view=e.views},on:{init:function(){var e=this;$$1(".view-init").each(function(t,a){if(!a.f7View){var n=$$1(a).dataset();e.views.create(a,n)}})},modalOpen:function(e){var t=this;e.$el.find(".view-init").each(function(e,a){if(!a.f7View){var n=$$1(a).dataset();t.views.create(a,n)}})},modalBeforeDestroy:function(e){e&&e.$el&&e.$el.find(".view-init").each(function(e,t){var a=t.f7View;a&&a.destroy()})}}},Navbar={size:function(e){var t=this;if("ios"===t.theme){var a=$$1(e);if(a.hasClass("navbar"))a=a.children(".navbar-inner").each(function(e,a){t.navbar.size(a)});else if(!(a.hasClass("stacked")||a.parents(".stacked").length>0||a.parents(".tab:not(.tab-active)").length>0||a.parents(".popup:not(.modal-in)").length>0)){var n,r,i,o,s=a.parents(".view").eq(0),l=t.rtl?a.children(".right"):a.children(".left"),p=t.rtl?a.children(".left"):a.children(".right"),c=a.children(".title"),d=a.children(".subnavbar"),u=0===l.length,h=0===p.length,f=u?0:l.outerWidth(!0),m=h?0:p.outerWidth(!0),v=c.outerWidth(!0),g=a.styles(),b=a[0].offsetWidth,y=b-parseInt(g.paddingLeft,10)-parseInt(g.paddingRight,10),w=a.hasClass("navbar-previous"),$=a.hasClass("sliding"),C=0,x=0;s.length>0&&s[0].f7View&&(r=(n=s[0].f7View.router)&&n.dynamicNavbar,n&&n.separateNavbar||(C=b,x=b/5)),h&&(i=y-v),u&&(i=0),u||h||(i=(y-m-v+f)/2);var E=(y-v)/2;y-f-m>v?(E<f&&(E=f),E+v>y-m&&(E=y-m-v),o=E-i):o=0;var S=t.rtl?-1:1;if(r){if(c.hasClass("sliding")||c.length>0&&$){var k=-(i+o)*S+x,T=(y-i-o-v)*S-C;if(w&&n&&n.params.iosAnimateNavbarBackIcon){var M=a.parent().find(".navbar-current").children(".left.sliding").find(".back .icon ~ span");M.length>0&&(k+=M[0].offsetLeft)}c[0].f7NavbarLeftOffset=k,c[0].f7NavbarRightOffset=T}u||!l.hasClass("sliding")&&!$||(t.rtl?(l[0].f7NavbarLeftOffset=-(y-l[0].offsetWidth)/2*S,l[0].f7NavbarRightOffset=f*S):(l[0].f7NavbarLeftOffset=-f+x,l[0].f7NavbarRightOffset=(y-l[0].offsetWidth)/2-C,n&&n.params.iosAnimateNavbarBackIcon&&l.find(".back .icon").length>0&&(l[0].f7NavbarRightOffset-=l.find(".back .icon")[0].offsetWidth))),h||!p.hasClass("sliding")&&!$||(t.rtl?(p[0].f7NavbarLeftOffset=-m*S,p[0].f7NavbarRightOffset=(y-p[0].offsetWidth)/2*S):(p[0].f7NavbarLeftOffset=-(y-p[0].offsetWidth)/2+x,p[0].f7NavbarRightOffset=m-C)),d.length&&(d.hasClass("sliding")||$)&&(d[0].f7NavbarLeftOffset=t.rtl?d[0].offsetWidth:-d[0].offsetWidth+x,d[0].f7NavbarRightOffset=-d[0].f7NavbarLeftOffset-C+x)}if(t.params.navbar.iosCenterTitle){var P=o;t.rtl&&u&&h&&c.length>0&&(P=-P),c.css({left:P+"px"})}}}},hide:function(e,t){void 0===t&&(t=!0);var a=$$1(e);if(a.hasClass("navbar-inner")&&(a=a.parents(".navbar")),a.length&&!a.hasClass("navbar-hidden")){var n="navbar-hidden"+(t?" navbar-transitioning":"");a.transitionEnd(function(){a.removeClass("navbar-transitioning")}),a.addClass(n)}},show:function(e,t){void 0===e&&(e=".navbar-hidden"),void 0===t&&(t=!0);var a=$$1(e);a.hasClass("navbar-inner")&&(a=a.parents(".navbar")),a.length&&a.hasClass("navbar-hidden")&&(t&&(a.addClass("navbar-transitioning"),a.transitionEnd(function(){a.removeClass("navbar-transitioning")})),a.removeClass("navbar-hidden"))},getElByPage:function(e){var t,a,n;if(e.$navbarEl||e.$el?(n=e,t=e.$el):(t=$$1(e)).length>0&&(n=t[0].f7Page),n&&n.$navbarEl&&n.$navbarEl.length>0?a=n.$navbarEl:t&&(a=t.children(".navbar").children(".navbar-inner")),a&&(!a||0!==a.length))return a[0]},getPageByEl:function(e){var t=$$1(e);if(!(t.hasClass("navbar")&&(t=t.find(".navbar-inner")).length>1))return t[0].f7Page},initHideNavbarOnScroll:function(e,t){var a,n,r,i,o,s,l,p=this,c=$$1(e),d=$$1(t||p.navbar.getElByPage(e)).closest(".navbar");function u(){c.hasClass("page-previous")||(n=this.scrollTop,r=this.scrollHeight,i=this.offsetHeight,o=n+i>=r,l=d.hasClass("navbar-hidden"),o?p.params.navbar.showOnPageScrollEnd&&(s="show"):s=a>n?p.params.navbar.showOnPageScrollTop||n<=44?"show":"hide":n>44?"hide":"show","show"===s&&l?(p.navbar.show(d),l=!1):"hide"!==s||l||(p.navbar.hide(d),l=!0),a=n)}c.on("scroll",".page-content",u,!0),c[0].f7ScrollNavbarHandler=u}},Navbar$1={name:"navbar",create:function(){var e=this;Utils.extend(e,{navbar:{size:Navbar.size.bind(e),hide:Navbar.hide.bind(e),show:Navbar.show.bind(e),getElByPage:Navbar.getElByPage.bind(e),initHideNavbarOnScroll:Navbar.initHideNavbarOnScroll.bind(e)}})},params:{navbar:{scrollTopOnTitleClick:!0,iosCenterTitle:!0,hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{"panelBreakpoint resize":function(){var e=this;"ios"===e.theme&&$$1(".navbar").each(function(t,a){e.navbar.size(a)})},pageBeforeRemove:function(e){e.$el[0].f7ScrollNavbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollNavbarHandler,!0)},pageBeforeIn:function(e){if("ios"===this.theme){var t,a=e.$el.parents(".view")[0].f7View,n=this.navbar.getElByPage(e);if(t=n?$$1(n).parents(".navbar"):e.$el.parents(".view").children(".navbar"),e.$el.hasClass("no-navbar")||a.router.dynamicNavbar&&!n){var r=!!(e.pageFrom&&e.router.history.length>0);this.navbar.hide(t,r)}else this.navbar.show(t)}},pageReinit:function(e){if("ios"===this.theme){var t=$$1(this.navbar.getElByPage(e));t&&0!==t.length&&this.navbar.size(t)}},pageInit:function(e){var t=this,a=$$1(t.navbar.getElByPage(e));if(a&&0!==a.length&&("ios"===t.theme&&t.navbar.size(a),t.params.navbar.hideOnPageScroll||e.$el.find(".hide-navbar-on-scroll").length||e.$el.hasClass("hide-navbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll"))){if(e.$el.find(".keep-navbar-on-scroll").length||e.$el.hasClass("keep-navbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.navbar.initHideNavbarOnScroll(e.el,a[0])}},modalOpen:function(e){var t=this;"ios"===t.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,a){t.navbar.size(a)})},panelOpen:function(e){var t=this;"ios"===t.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,a){t.navbar.size(a)})},panelSwipeOpen:function(e){var t=this;"ios"===t.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,a){t.navbar.size(a)})},tabShow:function(e){var t=this;$$1(e).find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,a){t.navbar.size(a)})}},clicks:{".navbar .title":function(e){if(this.params.navbar.scrollTopOnTitleClick&&!(e.closest("a").length>0)){var t,a=e.parents(".navbar");0===(t=a.parents(".page-content")).length&&(a.parents(".page").length>0&&(t=a.parents(".page").find(".page-content")),0===t.length&&a.nextAll(".page-current:not(.stacked)").length>0&&(t=a.nextAll(".page-current:not(.stacked)").find(".page-content"))),t&&t.length>0&&(t.hasClass("tab")&&(t=t.parent(".tabs").children(".page-content.tab-active")),t.length>0&&t.scrollTop(0,300))}}}},Toolbar={setHighlight:function(e){if("md"===this.theme){var t=$$1(e);if(0!==t.length&&(t.hasClass("tabbar")||t.hasClass("tabbar-labels"))){0===t.find(".tab-link-highlight").length&&t.children(".toolbar-inner").append('<span class="tab-link-highlight"></span>');var a,n,r=t.find(".tab-link-highlight"),i=t.find(".tab-link-active");if(t.hasClass("tabbar-scrollable")&&i&&i[0])a=i[0].offsetWidth+"px",n=i[0].offsetLeft+"px";else{var o=i.index();a=100/t.find(".tab-link").length+"%",n=100*(this.rtl?-o:o)+"%"}r.css("width",a).transform("translate3d("+n+",0,0)")}}},init:function(e){this.toolbar.setHighlight(e)},hide:function(e,t){void 0===t&&(t=!0);var a=$$1(e);if(!a.hasClass("toolbar-hidden")){var n="toolbar-hidden"+(t?" toolbar-transitioning":"");a.transitionEnd(function(){a.removeClass("toolbar-transitioning")}),a.addClass(n)}},show:function(e,t){void 0===t&&(t=!0);var a=$$1(e);a.hasClass("toolbar-hidden")&&(t&&(a.addClass("toolbar-transitioning"),a.transitionEnd(function(){a.removeClass("toolbar-transitioning")})),a.removeClass("toolbar-hidden"))},initHideToolbarOnScroll:function(e){var t,a,n,r,i,o,s,l=this,p=$$1(e),c=p.parents(".view").children(".toolbar");(0===c.length&&(c=p.find(".toolbar")),0===c.length&&(c=p.parents(".views").children(".tabbar, .tabbar-labels")),0!==c.length)&&(p.on("scroll",".page-content",d,!0),p[0].f7ScrollToolbarHandler=d);function d(){p.hasClass("page-previous")||(a=this.scrollTop,n=this.scrollHeight,r=this.offsetHeight,i=a+r>=n,s=c.hasClass("toolbar-hidden"),i?l.params.toolbar.showOnPageScrollEnd&&(o="show"):o=t>a?l.params.toolbar.showOnPageScrollTop||a<=44?"show":"hide":a>44?"hide":"show","show"===o&&s?(l.toolbar.show(c),s=!1):"hide"!==o||s||(l.toolbar.hide(c),s=!0),t=a)}}},Toolbar$1={name:"toolbar",create:function(){var e=this;Utils.extend(e,{toolbar:{hide:Toolbar.hide.bind(e),show:Toolbar.show.bind(e),setHighlight:Toolbar.setHighlight.bind(e),initHideToolbarOnScroll:Toolbar.initHideToolbarOnScroll.bind(e),init:Toolbar.init.bind(e)}})},params:{toolbar:{hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{pageBeforeRemove:function(e){e.$el[0].f7ScrollToolbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollToolbarHandler,!0)},pageBeforeIn:function(e){var t=e.$el.parents(".view").children(".toolbar");0===t.length&&(t=e.$el.find(".toolbar")),0===t.length&&(t=e.$el.parents(".views").children(".tabbar, .tabbar-labels")),0!==t.length&&(e.$el.hasClass("no-toolbar")?this.toolbar.hide(t):this.toolbar.show(t))},pageInit:function(e){var t=this;if(e.$el.find(".tabbar, .tabbar-labels").each(function(e,a){t.toolbar.init(a)}),t.params.toolbar.hideOnPageScroll||e.$el.find(".hide-toolbar-on-scroll").length||e.$el.hasClass("hide-toolbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll")){if(e.$el.find(".keep-toolbar-on-scroll").length||e.$el.hasClass("keep-toolbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.toolbar.initHideToolbarOnScroll(e.el)}},init:function(){var e=this;e.root.find(".tabbar, .tabbar-labels").each(function(t,a){e.toolbar.init(a)})}}},Subnavbar={name:"subnavbar",on:{pageInit:function(e){e.$navbarEl&&e.$navbarEl.length&&e.$navbarEl.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar"),e.$el.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar")}}},TouchRipple=function(e,t,a){var n=this;if(e){var r=e[0].getBoundingClientRect(),i=t-r.left,o=a-r.top,s=r.width,l=r.height,p=Math.max(Math.pow(Math.pow(l,2)+Math.pow(s,2),.5),48);return n.$rippleWaveEl=$$1('<div class="ripple-wave" style="width: '+p+"px; height: "+p+"px; margin-top:-"+p/2+"px; margin-left:-"+p/2+"px; left:"+i+"px; top:"+o+'px;"></div>'),e.prepend(n.$rippleWaveEl),n._clientLeft=n.$rippleWaveEl[0].clientLeft,n.rippleTransform="translate3d("+(s/2-i)+"px, "+(l/2-o)+"px, 0) scale(1)",n.$rippleWaveEl.transform(n.rippleTransform),n}};TouchRipple.prototype.onRemove=function(){var e=this;e.$rippleWaveEl.remove(),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},TouchRipple.prototype.remove=function(){var e=this;if(!e.removing){var t=this.$rippleWaveEl,a=this.rippleTransform,n=Utils.nextTick(function(){e.onRemove()},400);e.removing=!0,t.addClass("ripple-wave-fill").transform(a.replace("scale(1)","scale(1.01)")).transitionEnd(function(){clearTimeout(n),Utils.nextFrame(function(){t.addClass("ripple-wave-out").transform(a.replace("scale(1)","scale(1.01)")),n=Utils.nextTick(function(){e.onRemove()},700),t.transitionEnd(function(){clearTimeout(n),e.onRemove()})})})}};var TouchRipple$1={name:"touch-ripple",static:{TouchRipple:TouchRipple},create:function(){this.touchRipple={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return new(Function.prototype.bind.apply(TouchRipple,[null].concat(e)))}}}},openedModals=[],dialogsQueue=[];function clearDialogsQueue(){0!==dialogsQueue.length&&dialogsQueue.shift().open()}var Modal=function(e){function t(t,a){e.call(this,a,[t]);var n={};return this.useModulesParams(n),this.params=Utils.extend(n,a),this.useModules(),this}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.onOpen=function(){var e=this;openedModals.push(e),$$1("html").addClass("with-modal-"+e.type.toLowerCase()),e.$el.trigger("modal:open "+e.type.toLowerCase()+":open",e),e.emit("local::open modalOpen "+e.type+"Open",e)},t.prototype.onOpened=function(){var e=this;e.$el.trigger("modal:opened "+e.type.toLowerCase()+":opened",e),e.emit("local::opened modalOpened "+e.type+"Opened",e)},t.prototype.onClose=function(){var e=this;e.type&&e.$el&&(openedModals.splice(openedModals.indexOf(e),1),$$1("html").removeClass("with-modal-"+e.type.toLowerCase()),e.$el.trigger("modal:close "+e.type.toLowerCase()+":close",e),e.emit("local::close modalClose "+e.type+"Close",e))},t.prototype.onClosed=function(){var e=this;e.type&&e.$el&&(e.$el.removeClass("modal-out"),e.$el.hide(),e.$el.trigger("modal:closed "+e.type.toLowerCase()+":closed",e),e.emit("local::closed modalClosed "+e.type+"Closed",e))},t.prototype.open=function(e){var t,a=this,n=a.app,r=a.$el,i=a.$backdropEl,o=a.type,s=!0;if(void 0!==e?s=e:void 0!==a.params.animate&&(s=a.params.animate),!r||r.hasClass("modal-in"))return a;if("dialog"===o&&n.params.modal.queueDialogs&&($$1(".dialog.modal-in").length>0?t=!0:openedModals.length>0&&openedModals.forEach(function(e){"dialog"===e.type&&(t=!0)}),t))return dialogsQueue.push(a),a;var l=r.parent(),p=r.parents(doc).length>0;function c(){r.hasClass("modal-out")?a.onClosed():r.hasClass("modal-in")&&a.onOpened()}return n.params.modal.moveToRoot&&!l.is(n.root)&&(n.root.append(r),a.once(o+"Closed",function(){p?l.append(r):r.remove()})),r.show(),"dialog"===o&&r.css({marginTop:-Math.round(r.outerHeight()/2)+"px"}),a._clientLeft=r[0].clientLeft,i&&(i[s?"removeClass":"addClass"]("not-animated"),i.addClass("backdrop-in")),s?(r.animationEnd(function(){c()}),r.transitionEnd(function(){c()}),r.removeClass("modal-out not-animated").addClass("modal-in"),a.onOpen()):(r.removeClass("modal-out").addClass("modal-in not-animated"),a.onOpen(),a.onOpened()),a},t.prototype.close=function(e){var t=this,a=t.$el,n=t.$backdropEl,r=!0;if(void 0!==e?r=e:void 0!==t.params.animate&&(r=t.params.animate),!a||!a.hasClass("modal-in"))return t;function i(){a.hasClass("modal-out")?t.onClosed():a.hasClass("modal-in")&&t.onOpened()}return n&&(n[r?"removeClass":"addClass"]("not-animated"),n.removeClass("backdrop-in")),a[r?"removeClass":"addClass"]("not-animated"),r?(a.animationEnd(function(){i()}),a.transitionEnd(function(){i()}),a.removeClass("modal-in").addClass("modal-out"),t.onClose()):(a.addClass("not-animated").removeClass("modal-in").addClass("modal-out"),t.onClose(),t.onClosed()),"dialog"===t.type&&clearDialogsQueue(),t},t.prototype.destroy=function(){var e=this;e.destroyed||(e.emit("local::beforeDestroy modalBeforeDestroy "+e.type+"BeforeDestroy",e),e.$el&&(e.$el.trigger("modal:beforedestroy "+e.type.toLowerCase()+":beforedestroy",e),e.$el.length&&e.$el[0].f7Modal&&delete e.$el[0].f7Modal),Utils.deleteProps(e),e.destroyed=!0)},t}(Framework7Class),CustomModal=function(e){function t(t,a){var n=Utils.extend({backdrop:!0,closeByBackdropClick:!0,on:{}},a);e.call(this,t,n);var r,i,o=this;if(o.params=n,(r=o.params.el?$$1(o.params.el):$$1(o.params.content))&&r.length>0&&r[0].f7Modal)return r[0].f7Modal;if(0===r.length)return o.destroy();function s(e){o&&!o.destroyed&&i&&e.target===i[0]&&o.close()}return o.params.backdrop&&0===(i=t.root.children(".custom-modal-backdrop")).length&&(i=$$1('<div class="custom-modal-backdrop"></div>'),t.root.append(i)),o.on("customModalOpened",function(){o.params.closeByBackdropClick&&o.params.backdrop&&t.on("click",s)}),o.on("customModalClose",function(){o.params.closeByBackdropClick&&o.params.backdrop&&t.off("click",s)}),Utils.extend(o,{app:t,$el:r,el:r[0],$backdropEl:i,backdropEl:i&&i[0],type:"customModal"}),r[0].f7Modal=o,o}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Modal$1={name:"modal",static:{Modal:Modal,CustomModal:CustomModal},create:function(){var e=this;e.customModal={create:function(t){return new CustomModal(e,t)}}},params:{modal:{moveToRoot:!0,queueDialogs:!0}}},Dialog=function(e){function t(t,a){var n=Utils.extend({title:t.params.dialog.title,text:void 0,content:"",buttons:[],verticalButtons:!1,onClick:void 0,cssClass:void 0,destroyOnClose:!1,on:{}},a);void 0===n.closeByBackdropClick&&(n.closeByBackdropClick=t.params.dialog.closeByBackdropClick),e.call(this,t,n);var r,i=this,o=n.title,s=n.text,l=n.content,p=n.buttons,c=n.verticalButtons,d=n.cssClass;if(i.params=n,i.params.el)r=$$1(i.params.el);else{var u=["dialog"];0===p.length&&u.push("dialog-no-buttons"),p.length>0&&u.push("dialog-buttons-"+p.length),c&&u.push("dialog-buttons-vertical"),d&&u.push(d);var h="";p.length>0&&(h='\n          <div class="dialog-buttons">\n            '+p.map(function(e){return'\n              <span class="dialog-button'+(e.bold?" dialog-button-bold":"")+(e.color?" color-"+e.color:"")+(e.cssClass?" "+e.cssClass:"")+'">'+e.text+"</span>\n            "}).join("")+"\n          </div>\n        ");var f='\n        <div class="'+u.join(" ")+'">\n          <div class="dialog-inner">\n            '+(o?'<div class="dialog-title">'+o+"</div>":"")+"\n            "+(s?'<div class="dialog-text">'+s+"</div>":"")+"\n            "+l+"\n          </div>\n          "+h+"\n        </div>\n      ";r=$$1(f)}if(r&&r.length>0&&r[0].f7Modal)return r[0].f7Modal;if(0===r.length)return i.destroy();var m,v=t.root.children(".dialog-backdrop");function g(e){var t=$$1(this).index(),a=p[t];a.onClick&&a.onClick(i,e),i.params.onClick&&i.params.onClick(i,t),!1!==a.close&&i.close()}function b(e){var t=e.keyCode;p.forEach(function(a,n){a.keyCodes&&a.keyCodes.indexOf(t)>=0&&(doc.activeElement&&doc.activeElement.blur(),a.onClick&&a.onClick(i,e),i.params.onClick&&i.params.onClick(i,n),!1!==a.close&&i.close())})}function y(e){var t=e.target;0===$$1(t).closest(i.el).length&&i.params.closeByBackdropClick&&i.backdropEl&&i.backdropEl===t&&i.close()}return 0===v.length&&(v=$$1('<div class="dialog-backdrop"></div>'),t.root.append(v)),p&&p.length>0&&(i.on("open",function(){r.find(".dialog-button").each(function(e,t){p[e].keyCodes&&(m=!0),$$1(t).on("click",g)}),!m||t.device.ios||t.device.android||t.device.cordova||$$1(doc).on("keydown",b)}),i.on("close",function(){r.find(".dialog-button").each(function(e,t){$$1(t).off("click",g)}),!m||t.device.ios||t.device.android||t.device.cordova||$$1(doc).off("keydown",b),m=!1})),Utils.extend(i,{app:t,$el:r,el:r[0],$backdropEl:v,backdropEl:v[0],type:"dialog",setProgress:function(e,a){return t.progressbar.set(r.find(".progressbar"),e,a),i},setText:function(e){var t=r.find(".dialog-text");return 0===t.length&&(t=$$1('<div class="dialog-text"></div>'),void 0!==o?t.insertAfter(r.find(".dialog-title")):r.find(".dialog-inner").prepend(t)),t.html(e),i.params.text=e,i},setTitle:function(e){var t=r.find(".dialog-title");return 0===t.length&&(t=$$1('<div class="dialog-title"></div>'),r.find(".dialog-inner").prepend(t)),t.html(e),i.params.title=e,i}}),i.on("opened",function(){i.params.closeByBackdropClick&&t.on("click",y)}),i.on("close",function(){i.params.closeByBackdropClick&&t.off("click",y)}),r[0].f7Modal=i,i.params.destroyOnClose&&i.once("closed",function(){setTimeout(function(){i.destroy()},0)}),i}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal);function ConstructorMethods(e){void 0===e&&(e={});var t=e.defaultSelector,a=e.constructor,n=e.domProp,r=e.app,i=e.addMethods,o={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return r?new(Function.prototype.bind.apply(a,[null].concat([r],e))):new(Function.prototype.bind.apply(a,[null].concat(e)))},get:function(e){if(void 0===e&&(e=t),e instanceof a)return e;var r=$$1(e);return 0!==r.length?r[0][n]:void 0},destroy:function(e){var t=o.get(e);if(t&&t.destroy)return t.destroy()}};return i&&Array.isArray(i)&&i.forEach(function(e){o[e]=function(a){void 0===a&&(a=t);for(var n=[],r=arguments.length-1;r-- >0;)n[r]=arguments[r+1];var i=o.get(a);if(i&&i[e])return i[e].apply(i,n)}}),o}function ModalMethods(e){void 0===e&&(e={});var t=e.defaultSelector,a=e.constructor,n=e.app;return Utils.extend(ConstructorMethods({defaultSelector:t,constructor:a,app:n,domProp:"f7Modal"}),{open:function(e,t){var r=$$1(e),i=r[0].f7Modal;return i||(i=new a(n,{el:r})),i.open(t)},close:function(e,r){void 0===e&&(e=t);var i=$$1(e);if(0!==i.length){var o=i[0].f7Modal;return o||(o=new a(n,{el:i})),o.close(r)}}})}var Dialog$1={name:"dialog",params:{dialog:{title:void 0,buttonOk:"OK",buttonCancel:"Cancel",usernamePlaceholder:"Username",passwordPlaceholder:"Password",preloaderTitle:"Loading... ",progressTitle:"Loading... ",closeByBackdropClick:!1,destroyPredefinedDialogs:!0,keyboardActions:!0}},static:{Dialog:Dialog},create:function(){var e=this,t=e.params.dialog.title||e.name,a=e.params.dialog.destroyPredefinedDialogs,n=e.params.dialog.keyboardActions;e.dialog=Utils.extend(ModalMethods({app:e,constructor:Dialog,defaultSelector:".dialog.modal-in"}),{alert:function(){for(var r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2];return 2===i.length&&"function"==typeof i[1]&&(s=(r=i)[0],p=r[1],l=r[2]),new Dialog(e,{title:void 0===l?t:l,text:s,buttons:[{text:e.params.dialog.buttonOk,bold:!0,onClick:p,keyCodes:n?[13,27]:null}],destroyOnClose:a}).open()},prompt:function(){for(var r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2],c=i[3];return"function"==typeof i[1]&&(s=(r=i)[0],p=r[1],c=r[2],l=r[3]),new Dialog(e,{title:void 0===l?t:l,text:s,content:'<div class="dialog-input-field item-input"><div class="item-input-wrap"><input type="text" class="dialog-input"></div></div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:n?[27]:null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:n?[13]:null}],onClick:function(e,t){var a=e.$el.find(".dialog-input").val();0===t&&c&&c(a),1===t&&p&&p(a)},destroyOnClose:a}).open()},confirm:function(){for(var r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2],c=i[3];return"function"==typeof i[1]&&(s=(r=i)[0],p=r[1],c=r[2],l=r[3]),new Dialog(e,{title:void 0===l?t:l,text:s,buttons:[{text:e.params.dialog.buttonCancel,onClick:c,keyCodes:n?[27]:null},{text:e.params.dialog.buttonOk,bold:!0,onClick:p,keyCodes:n?[13]:null}],destroyOnClose:a}).open()},login:function(){for(var r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2],c=i[3];return"function"==typeof i[1]&&(s=(r=i)[0],p=r[1],c=r[2],l=r[3]),new Dialog(e,{title:void 0===l?t:l,text:s,content:'\n              <div class="dialog-input-field dialog-input-double item-input">\n                <div class="item-input-wrap">\n                  <input type="text" name="dialog-username" placeholder="'+e.params.dialog.usernamePlaceholder+'" class="dialog-input">\n                </div>\n              </div>\n              <div class="dialog-input-field dialog-input-double item-input">\n                <div class="item-input-wrap">\n                  <input type="password" name="dialog-password" placeholder="'+e.params.dialog.passwordPlaceholder+'" class="dialog-input">\n                </div>\n              </div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:n?[27]:null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:n?[13]:null}],onClick:function(e,t){var a=e.$el.find('[name="dialog-username"]').val(),n=e.$el.find('[name="dialog-password"]').val();0===t&&c&&c(a,n),1===t&&p&&p(a,n)},destroyOnClose:a}).open()},password:function(){for(var r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2],c=i[3];return"function"==typeof i[1]&&(s=(r=i)[0],p=r[1],c=r[2],l=r[3]),new Dialog(e,{title:void 0===l?t:l,text:s,content:'\n              <div class="dialog-input-field item-input">\n                <div class="item-input-wrap">\n                  <input type="password" name="dialog-password" placeholder="'+e.params.dialog.passwordPlaceholder+'" class="dialog-input">\n                </div>\n              </div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:n?[27]:null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:n?[13]:null}],onClick:function(e,t){var a=e.$el.find('[name="dialog-password"]').val();0===t&&c&&c(a),1===t&&p&&p(a)},destroyOnClose:a}).open()},preloader:function(t){var n="md"!==e.theme?"":Utils.mdPreloaderContent;return new Dialog(e,{title:void 0===t?e.params.dialog.preloaderTitle:t,content:'<div class="preloader">'+n+"</div>",cssClass:"dialog-preloader",destroyOnClose:a}).open()},progress:function(){for(var t,n,r,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2];2===i.length?"number"==typeof i[0]?(l=(t=i)[0],p=t[1],s=t[2]):"string"==typeof i[0]&&"string"==typeof i[1]&&(s=(n=i)[0],p=n[1],l=n[2]):1===i.length&&"number"==typeof i[0]&&(l=(r=i)[0],s=r[1],p=r[2]);var c=void 0===l,d=new Dialog(e,{title:void 0===s?e.params.dialog.progressTitle:s,cssClass:"dialog-progress",content:'\n              <div class="progressbar'+(c?"-infinite":"")+(p?" color-"+p:"")+'">\n                '+(c?"":"<span></span>")+"\n              </div>\n            ",destroyOnClose:a});return c||d.setProgress(l),d.open()}})}},Popup=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.popup,a);e.call(this,t,n);var r,i,o=this;if(o.params=n,(r=o.params.el?$$1(o.params.el):$$1(o.params.content))&&r.length>0&&r[0].f7Modal)return r[0].f7Modal;if(0===r.length)return o.destroy();function s(e){var t=e.target;0===$$1(t).closest(o.el).length&&o.params&&o.params.closeByBackdropClick&&o.params.backdrop&&o.backdropEl&&o.backdropEl===t&&o.close()}return o.params.backdrop&&0===(i=t.root.children(".popup-backdrop")).length&&(i=$$1('<div class="popup-backdrop"></div>'),t.root.append(i)),Utils.extend(o,{app:t,$el:r,el:r[0],$backdropEl:i,backdropEl:i&&i[0],type:"popup"}),o.on("popupOpened",function(){o.params.closeByBackdropClick&&t.on("click",s)}),o.on("popupClose",function(){o.params.closeByBackdropClick&&t.off("click",s)}),r[0].f7Modal=o,o}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Popup$1={name:"popup",params:{popup:{backdrop:!0,closeByBackdropClick:!0}},static:{Popup:Popup},create:function(){this.popup=ModalMethods({app:this,constructor:Popup,defaultSelector:".popup.modal-in"})},clicks:{".popup-open":function(e,t){void 0===t&&(t={});this.popup.open(t.popup,t.animate)},".popup-close":function(e,t){void 0===t&&(t={});this.popup.close(t.popup,t.animate)}}},LoginScreen=function(e){function t(t,a){var n=Utils.extend({on:{}},a);e.call(this,t,n);var r,i=this;return i.params=n,(r=i.params.el?$$1(i.params.el):$$1(i.params.content))&&r.length>0&&r[0].f7Modal?r[0].f7Modal:0===r.length?i.destroy():(Utils.extend(i,{app:t,$el:r,el:r[0],type:"loginScreen"}),r[0].f7Modal=i,i)}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),LoginScreen$1={name:"loginScreen",static:{LoginScreen:LoginScreen},create:function(){this.loginScreen=ModalMethods({app:this,constructor:LoginScreen,defaultSelector:".login-screen.modal-in"})},clicks:{".login-screen-open":function(e,t){void 0===t&&(t={});this.loginScreen.open(t.loginScreen,t.animate)},".login-screen-close":function(e,t){void 0===t&&(t={});this.loginScreen.close(t.loginScreen,t.animate)}}},Popover=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.popover,a);e.call(this,t,n);var r,i=this;if(i.params=n,(r=i.params.el?$$1(i.params.el):$$1(i.params.content))&&r.length>0&&r[0].f7Modal)return r[0].f7Modal;var o,s,l=$$1(i.params.targetEl).eq(0);if(0===r.length)return i.destroy();i.params.backdrop&&0===(o=t.root.children(".popover-backdrop")).length&&(o=$$1('<div class="popover-backdrop"></div>'),t.root.append(o)),0===r.find(".popover-angle").length?(s=$$1('<div class="popover-angle"></div>'),r.prepend(s)):s=r.find(".popover-angle");var p=i.open;function c(){i.resize()}function d(e){var t=e.target;0===$$1(t).closest(i.el).length&&(i.params.closeByBackdropClick&&i.params.backdrop&&i.backdropEl&&i.backdropEl===t?i.close():i.params.closeByOutsideClick&&i.close())}return Utils.extend(i,{app:t,$el:r,el:r[0],$targetEl:l,targetEl:l[0],$angleEl:s,angleEl:s[0],$backdropEl:o,backdropEl:o&&o[0],type:"popover",open:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1];"boolean"==typeof t[0]&&(r=(e=t)[0],n=e[1]),n&&(i.$targetEl=$$1(n),i.targetEl=i.$targetEl[0]),p.call(i,r)}}),i.on("popoverOpen",function(){i.resize(),t.on("resize",c),i.on("popoverClose popoverBeforeDestroy",function(){t.off("resize",c)})}),i.on("popoverOpened",function(){(i.params.closeByOutsideClick||i.params.closeByBackdropClick)&&t.on("click",d)}),i.on("popoverClose",function(){(i.params.closeByOutsideClick||i.params.closeByBackdropClick)&&t.off("click",d)}),r[0].f7Modal=i,i}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.resize=function(){var e=this,t=e.app,a=e.$el,n=e.$targetEl,r=e.$angleEl,i=e.params,o=i.targetX,s=i.targetY;a.css({left:"",top:""});var l,p,c,d,u,h,f=[a.width(),a.height()],m=f[0],v=f[1],g=0;if("ios"===t.theme?(r.removeClass("on-left on-right on-top on-bottom").css({left:"",top:""}),g=r.width()/2):a.removeClass("popover-on-left popover-on-right popover-on-top popover-on-bottom").css({left:"",top:""}),n&&n.length>0){c=n.outerWidth(),d=n.outerHeight();var b=n.offset();u=b.left-t.left,h=b.top-t.top;var y=n.parents(".page");y.length>0&&(h-=y[0].scrollTop)}else void 0!==o&&"undefined"!==s&&(u=o,h=s,c=e.params.targetWidth||0,d=e.params.targetHeight||0);var w=[0,0,0],$=w[0],C=w[1],x=w[2],E="md"===t.theme?"bottom":"top";"md"===t.theme?(v<t.height-h-d?(E="bottom",C=h):v<h?(C=h-v+d,E="top"):(E="bottom",C=h),C<=0?C=8:C+v>=t.height&&(C=t.height-v-8),($=u+c-m-8)+m>=t.width-8&&($=u+c-m-8),$<8&&($=8),"top"===E&&a.addClass("popover-on-top"),"bottom"===E&&a.addClass("popover-on-bottom")):(v+g<h?C=h-v-g:v+g<t.height-h-d?(E="bottom",C=h+d+g):(E="middle",x=C=d/2+h-v/2,C<=0?C=5:C+v>=t.height&&(C=t.height-v-5),x-=C),"top"===E||"bottom"===E?(x=$=c/2+u-m/2,$<5&&($=5),$+m>t.width&&($=t.width-m-5),$<0&&($=0),"top"===E&&r.addClass("on-bottom"),"bottom"===E&&r.addClass("on-top"),l=m/2-g+(x-=$),l=Math.max(Math.min(l,m-2*g-13),13),r.css({left:l+"px"})):"middle"===E&&($=u-m-g,r.addClass("on-right"),($<5||$+m>t.width)&&($<5&&($=u+c+g),$+m>t.width&&($=t.width-m-5),r.removeClass("on-right").addClass("on-left")),p=v/2-g+x,p=Math.max(Math.min(p,v-2*g-13),13),r.css({top:p+"px"}))),a.css({top:C+"px",left:$+"px"})},t}(Modal),Popover$1={name:"popover",params:{popover:{closeByBackdropClick:!0,closeByOutsideClick:!1,backdrop:!0}},static:{Popover:Popover},create:function(){var e=this;e.popover=Utils.extend(ModalMethods({app:e,constructor:Popover,defaultSelector:".popover.modal-in"}),{open:function(t,a,n){var r=$$1(t),i=r[0].f7Modal;return i||(i=new Popover(e,{el:r,targetEl:a})),i.open(a,n)}})},clicks:{".popover-open":function(e,t){void 0===t&&(t={});this.popover.open(t.popover,e,t.animate)},".popover-close":function(e,t){void 0===t&&(t={});this.popover.close(t.popover,t.animate)}}},Actions=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.actions,a);e.call(this,t,n);var r,i,o,s=this;if(s.params=n,s.params.buttons&&(r=s.params.buttons,Array.isArray(r[0])||(r=[r])),s.groups=r,s.params.el?i=$$1(s.params.el):s.params.content?i=$$1(s.params.content):s.params.buttons&&(s.params.convertToPopover&&(s.popoverHtml=s.renderPopover()),s.actionsHtml=s.render()),i&&i.length>0&&i[0].f7Modal)return i[0].f7Modal;if(i&&0===i.length&&!s.actionsHtml&&!s.popoverHtml)return s.destroy();s.params.backdrop&&0===(o=t.root.children(".actions-backdrop")).length&&(o=$$1('<div class="actions-backdrop"></div>'),t.root.append(o));var l,p=s.open,c=s.close;function d(e){var t,a,n=this;if($$1(n).hasClass("item-link")?(t=$$1(n).parents("li").index(),a=$$1(n).parents(".list").index()):(t=$$1(n).index(),a=$$1(n).parents(".actions-group").index()),void 0!==r){var i=r[a][t];i.onClick&&i.onClick(s,e),s.params.onClick&&s.params.onClick(s,e),!1!==i.close&&s.close()}}function u(e){var t=e.target;0===$$1(t).closest(s.el).length&&(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t?s.close():s.params.closeByOutsideClick&&s.close())}return s.open=function(e){var a=!1,n=s.params,r=n.targetEl,i=n.targetX,o=n.targetY,c=n.targetWidth,u=n.targetHeight;return s.params.convertToPopover&&(r||void 0!==i&&void 0!==o)&&(s.params.forceToPopover||t.device.ios&&t.device.ipad||t.width>=768)&&(a=!0),a&&s.popoverHtml?((l=t.popover.create({content:s.popoverHtml,backdrop:s.params.backdrop,targetEl:r,targetX:i,targetY:o,targetWidth:c,targetHeight:u})).open(e),l.once("popoverOpened",function(){l.$el.find(".item-link").each(function(e,t){$$1(t).on("click",d)})}),l.once("popoverClosed",function(){l.$el.find(".item-link").each(function(e,t){$$1(t).off("click",d)}),Utils.nextTick(function(){l.destroy(),l=void 0})})):(s.$el=s.actionsHtml?$$1(s.actionsHtml):s.$el,s.$el[0].f7Modal=s,s.groups&&(s.$el.find(".actions-button").each(function(e,t){$$1(t).on("click",d)}),s.once("actionsClosed",function(){s.$el.find(".actions-button").each(function(e,t){$$1(t).off("click",d)})})),s.el=s.$el[0],p.call(s,e)),s},s.close=function(e){return l?l.close(e):c.call(s,e),s},Utils.extend(s,{app:t,$el:i,el:i?i[0]:void 0,$backdropEl:o,backdropEl:o&&o[0],type:"actions"}),s.on("opened",function(){(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&t.on("click",u)}),s.on("close",function(){(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&t.off("click",u)}),i&&(i[0].f7Modal=s),s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){var e=this;if(e.params.render)return e.params.render.call(e,e);var t=e.groups;return('\n      <div class="actions-modal'+(e.params.grid?" actions-grid":"")+'">\n        '+t.map(function(e){return'<div class="actions-group">\n            '+e.map(function(e){var t=["actions-"+(e.label?"label":"button")],a=e.color,n=e.bg,r=e.bold,i=e.disabled,o=e.label,s=e.text,l=e.icon;return a&&t.push("color-"+a),n&&t.push("bg-color-"+n),r&&t.push("actions-button-bold"),i&&t.push("disabled"),o?'<div class="'+t.join(" ")+'">'+s+"</div>":('\n                <div class="'+t.join(" ")+'">\n                  '+(l?'<div class="actions-button-media">'+l+"</div>":"")+'\n                  <div class="actions-button-text">'+s+"</div>\n                </div>").trim()}).join("")+"\n          </div>"}).join("")+"\n      </div>\n    ").trim()},t.prototype.renderPopover=function(){var e=this;return e.params.renderPopover?e.params.renderPopover.call(e,e):('\n      <div class="popover popover-from-actions">\n        <div class="popover-inner">\n          '+e.groups.map(function(e){return'\n            <div class="list">\n              <ul>\n                '+e.map(function(e){var t=[],a=e.color,n=e.bg,r=e.bold,i=e.disabled,o=e.label,s=e.text,l=e.icon;return a&&t.push("color-"+a),n&&t.push("bg-color-"+n),r&&t.push("popover-from-actions-bold"),i&&t.push("disabled"),o?(t.push("popover-from-actions-label"),'<li class="'+t.join(" ")+'">'+s+"</li>"):(t.push("item-link"),l?(t.push("item-content"),'\n                      <li>\n                        <a class="'+t.join(" ")+'">\n                          <div class="item-media">\n                            '+l+'\n                          </div>\n                          <div class="item-inner">\n                            <div class="item-title">\n                              '+s+"\n                            </div>\n                          </div>\n                        </a>\n                      </li>\n                    "):(t.push("list-button"),'\n                    <li>\n                      <a href="#" class="list-button '+t.join(" ")+'">'+s+"</a>\n                    </li>\n                  "))}).join("")+"\n              </ul>\n            </div>\n          "}).join("")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Actions$1={name:"actions",params:{actions:{convertToPopover:!0,forceToPopover:!1,closeByBackdropClick:!0,render:null,renderPopover:null,backdrop:!0}},static:{Actions:Actions},create:function(){this.actions=ModalMethods({app:this,constructor:Actions,defaultSelector:".actions-modal.modal-in"})},clicks:{".actions-open":function(e,t){void 0===t&&(t={});this.actions.open(t.actions,t.animate)},".actions-close":function(e,t){void 0===t&&(t={});this.actions.close(t.actions,t.animate)}}},Sheet=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.sheet,a);e.call(this,t,n);var r,i,o,s=this;if(s.params=n,(r=s.params.el?$$1(s.params.el):$$1(s.params.content))&&r.length>0&&r[0].f7Modal)return r[0].f7Modal;if(0===r.length)return s.destroy();function l(e){var t=e.target;0===$$1(t).closest(s.el).length&&(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t?s.close():s.params.closeByOutsideClick&&s.close())}return s.params.backdrop&&0===(i=t.root.children(".sheet-backdrop")).length&&(i=$$1('<div class="sheet-backdrop"></div>'),t.root.append(i)),s.on("sheetOpen",function(){s.params.scrollToEl&&function(){var e=$$1(s.params.scrollToEl).eq(0);if(0!==e.length&&0!==(o=e.parents(".page-content")).length){var t,a=parseInt(o.css("padding-top"),10),n=parseInt(o.css("padding-bottom"),10),i=o[0].offsetHeight-a-r.height(),l=o[0].scrollHeight-a-r.height(),p=o.scrollTop(),c=e.offset().top-a+e[0].offsetHeight;if(c>i){var d=p+c-i;d+i>l&&(t=d+i-l+n,i===l&&(t=r.height()),o.css({"padding-bottom":t+"px"})),o.scrollTop(d,300)}}}()}),s.on("sheetOpened",function(){(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&t.on("click",l)}),s.on("sheetClose",function(){s.params.scrollToEl&&o&&o.length>0&&o.css({"padding-bottom":""}),(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&t.off("click",l)}),Utils.extend(s,{app:t,$el:r,el:r[0],$backdropEl:i,backdropEl:i&&i[0],type:"sheet"}),r[0].f7Modal=s,s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Sheet$1={name:"sheet",params:{sheet:{closeByBackdropClick:!0,closeByOutsideClick:!1}},static:{Sheet:Sheet},create:function(){var e=this;e.passedParams.sheet&&void 0!==e.passedParams.sheet.backdrop||(e.params.sheet.backdrop="md"===e.theme),e.sheet=Utils.extend({},ModalMethods({app:e,constructor:Sheet,defaultSelector:".sheet-modal.modal-in"}))},clicks:{".sheet-open":function(e,t){void 0===t&&(t={});$$1(".sheet-modal.modal-in").length>0&&t.sheet&&$$1(t.sheet)[0]!==$$1(".sheet-modal.modal-in")[0]&&this.sheet.close(".sheet-modal.modal-in"),this.sheet.open(t.sheet,t.animate)},".sheet-close":function(e,t){void 0===t&&(t={});this.sheet.close(t.sheet,t.animate)}}},Toast=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.toast,a);e.call(this,t,n);var r=this;r.app=t,r.params=n;var i,o,s=r.params,l=s.closeButton,p=s.closeTimeout;if(r.params.el)i=$$1(r.params.el);else{var c=r.render();i=$$1(c)}return i&&i.length>0&&i[0].f7Modal?i[0].f7Modal:0===i.length?r.destroy():(Utils.extend(r,{$el:i,el:i[0],type:"toast"}),i[0].f7Modal=r,l&&(i.find(".toast-button").on("click",function(){r.emit("local::closeButtonClick toastCloseButtonClick",r),r.close()}),r.on("beforeDestroy",function(){i.find(".toast-button").off("click")})),r.on("open",function(){$$1(".toast.modal-in").each(function(e,a){var n=t.toast.get(a);a!==r.el&&n&&n.close()}),p&&(o=Utils.nextTick(function(){r.close()},p))}),r.on("close",function(){win.clearTimeout(o)}),r.params.destroyOnClose&&r.once("closed",function(){setTimeout(function(){r.destroy()},0)}),r)}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){var e=this,t=e.app;if(e.params.render)return e.params.render.call(e,e);var a=e.params,n=a.position,r=a.cssClass,i=a.icon,o=a.text,s=a.closeButton,l=a.closeButtonColor,p=a.closeButtonText;return('\n      <div class="toast toast-'+n+" "+(r||"")+" "+(i?"toast-with-icon":"")+'">\n        <div class="toast-content">\n          '+(i?'<div class="toast-icon">'+i+"</div>":"")+'\n          <div class="toast-text">'+o+"</div>\n          "+(s&&!i?('\n          <a class="toast-button '+("md"===t.theme?"button":"link")+" "+(l?"color-"+l:"")+'">'+p+"</a>\n          ").trim():"")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Toast$1={name:"toast",static:{Toast:Toast},create:function(){var e=this;e.toast=Utils.extend({},ModalMethods({app:e,constructor:Toast,defaultSelector:".toast.modal-in"}),{show:function(t){return Utils.extend(t,{destroyOnClose:!0}),new Toast(e,t).open()}})},params:{toast:{icon:null,text:null,position:"bottom",closeButton:!1,closeButtonColor:null,closeButtonText:"Ok",closeTimeout:null,cssClass:null,render:null}}},Preloader={init:function(e){if("md"===this.theme){var t=$$1(e);0===t.length||t.children(".preloader-inner").length>0||t.append(Utils.mdPreloaderContent)}},visible:!1,show:function(e){void 0===e&&(e="white");if(!Preloader.visible){var t="md"!==this.theme?"":Utils.mdPreloaderContent;$$1("html").addClass("with-modal-preloader"),this.root.append('\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-'+e+'">'+t+"</div>\n      </div>\n    "),Preloader.visible=!0}},hide:function(){Preloader.visible&&($$1("html").removeClass("with-modal-preloader"),this.root.find(".preloader-backdrop, .preloader-modal").remove(),Preloader.visible=!1)}},Preloader$1={name:"preloader",create:function(){Utils.extend(this,{preloader:{init:Preloader.init.bind(this),show:Preloader.show.bind(this),hide:Preloader.hide.bind(this)}})},on:{photoBrowserOpen:function(e){var t=this;"md"===t.theme&&e.$el.find(".preloader").each(function(e,a){t.preloader.init(a)})},pageInit:function(e){var t=this;"md"===t.theme&&e.$el.find(".preloader").each(function(e,a){t.preloader.init(a)})}}},Progressbar={set:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=t[0],r=t[1],i=t[2];if("number"==typeof t[0]&&(r=(e=t)[0],i=e[1],n=this.root),void 0===r||null===r)return n;r||(r=0);var o=$$1(n||this.root);if(0===o.length)return n;var s,l=Math.min(Math.max(r,0),100);if(0===(s=o.hasClass("progressbar")?o.eq(0):o.children(".progressbar")).length||s.hasClass("progressbar-infinite"))return s;var p=s.children("span");return 0===p.length&&(p=$$1("<span></span>"),s.append(p)),p.transition(void 0!==i?i:"").transform("translate3d("+(-100+l)+"%,0,0)"),s[0]},show:function(){for(var e,t,a=[],n=arguments.length;n--;)a[n]=arguments[n];var r=this,i=a[0],o=a[1],s=a[2],l="determined";2===a.length?"string"!=typeof a[0]&&"object"!=typeof a[0]||"string"!=typeof a[1]?"number"==typeof a[0]&&"string"==typeof a[1]&&(o=(t=a)[0],s=t[1],i=r.root):(i=(e=a)[0],s=e[1],o=e[2],l="infinite"):1===a.length?"number"==typeof a[0]?(i=r.root,o=a[0]):"string"==typeof a[0]&&(l="infinite",i=r.root,s=a[0]):0===a.length&&(l="infinite",i=r.root);var p,c=$$1(i);if(0!==c.length)return c.hasClass("progressbar")||c.hasClass("progressbar-infinite")?p=c:0===(p=c.children(".progressbar:not(.progressbar-out), .progressbar-infinite:not(.progressbar-out)")).length&&(p=$$1('\n          <span class="progressbar'+("infinite"===l?"-infinite":"")+(s?" color-"+s:"")+' progressbar-in">\n            '+("infinite"===l?"":"<span></span>")+"\n          </span>"),c.append(p)),void 0!==o&&r.progressbar.set(p,o),p[0]},hide:function(e,t){void 0===t&&(t=!0);var a,n=$$1(e||this.root);if(0!==n.length)return 0===(a=n.hasClass("progressbar")||n.hasClass("progressbar-infinite")?n:n.children(".progressbar, .progressbar-infinite")).length||!a.hasClass("progressbar-in")||a.hasClass("progressbar-out")?a:(a.removeClass("progressbar-in").addClass("progressbar-out").animationEnd(function(){t&&a.remove()}),a)}},Progressbar$1={name:"progressbar",create:function(){Utils.extend(this,{progressbar:{set:Progressbar.set.bind(this),show:Progressbar.show.bind(this),hide:Progressbar.hide.bind(this)}})},on:{pageInit:function(e){var t=this;e.$el.find(".progressbar").each(function(e,a){var n=$$1(a);t.progressbar.set(n,n.attr("data-progress"))})}}},Sortable={init:function(){var e,t,a,n,r,i,o,s,l,p,c,d,u,h,f,m,v,g,b,y,w=this;var $=!!w.support.passiveListener&&{passive:!1,capture:!1};$$1(doc).on(w.touchEvents.start,".list.sortable .sortable-handler",function(n){t=!1,e=!0,a="touchstart"===n.type?n.targetTouches[0].pageY:n.pageY,r=$$1(this).parent("li"),u=r.index(),o=r.parents(".sortable");var s=r.parents(".list-group");s.length&&s.parents(o).length&&(o=s),i=o.children("ul").children("li"),w.panel&&(w.panel.allowOpen=!1),w.swipeout&&(w.swipeout.allow=!1)},$),w.on("touchmove:active",function(u){if(e&&r){var w="touchmove"===u.type?u.targetTouches[0].pageY:u.pageY;if(!t){h=r.parents(".page"),f=r.parents(".page-content");var $=parseInt(f.css("padding-top"),10),C=parseInt(f.css("padding-bottom"),10);y=f[0].scrollTop,v=h.offset().top+$,m=h.height()-$-C,r.addClass("sorting"),o.addClass("sortable-sorting"),g=r[0].offsetTop,l=r[0].offsetTop,p=r.parent().height()-g-r.height(),s=r[0].offsetHeight,b=r.offset().top}t=!0,u.preventDefault(),u.f7PreventSwipePanel=!0,n=w-a;var x=f[0].scrollTop-y,E=Math.min(Math.max(n+x,-l),p);r.transform("translate3d(0,"+E+"px,0)");var S,k=!0;n+x+44<-l&&(k=!1),n+x-44>p&&(k=!1),d=void 0,c=void 0,k&&(b+n+s+44>v+m&&(S=b+n+s+44-(v+m)),b+n<v+44&&(S=b+n-v-44),S&&(f[0].scrollTop+=S)),i.each(function(e,t){var a=$$1(t);if(a[0]!==r[0]){var n=a[0].offsetTop,i=a.height(),o=g+E;o>=n-i/2&&r.index()<a.index()?(a.transform("translate3d(0, "+-s+"px,0)"),c=a,d=void 0):o<=n+i/2&&r.index()>a.index()?(a.transform("translate3d(0, "+s+"px,0)"),c=void 0,d||(d=a)):a.transform("translate3d(0, 0%,0)")}})}}),w.on("touchend:passive",function(){if(!e||!t)return t=!1,void((e=!1)&&!t&&(w.panel&&(w.panel.allowOpen=!0),w.swipeout&&(w.swipeout.allow=!0)));var a,n,s;w.panel&&(w.panel.allowOpen=!0),w.swipeout&&(w.swipeout.allow=!0),i.transform(""),r.removeClass("sorting"),o.removeClass("sortable-sorting"),c&&r.insertAfter(c),d&&r.insertBefore(d),r.trigger("sortable:sort",{from:u,to:r.index()}),w.emit("sortableSort",r[0],{from:u,to:r.index()}),(c||d)&&o.hasClass("virtual-list")&&(a=o[0].f7VirtualList,n=r[0].f7VirtualListIndex,s=d?d[0].f7VirtualListIndex:c[0].f7VirtualListIndex,a&&a.moveItem(n,s)),d=void 0,c=void 0,e=!1,t=!1})},enable:function(e){void 0===e&&(e=".list.sortable");var t=$$1(e);0!==t.length&&(t.addClass("sortable-enabled"),t.trigger("sortable:enable"),this.emit("sortableEnable",t[0]))},disable:function(e){void 0===e&&(e=".list.sortable");var t=$$1(e);0!==t.length&&(t.removeClass("sortable-enabled"),t.trigger("sortable:disable"),this.emit("sortableDisable",t[0]))},toggle:function(e){void 0===e&&(e=".list.sortable");var t=$$1(e);0!==t.length&&(t.hasClass("sortable-enabled")?this.sortable.disable(t):this.sortable.enable(t))}},Sortable$1={name:"sortable",params:{sortable:!0},create:function(){var e=this;Utils.extend(e,{sortable:{init:Sortable.init.bind(e),enable:Sortable.enable.bind(e),disable:Sortable.disable.bind(e),toggle:Sortable.toggle.bind(e)}})},on:{init:function(){this.params.sortable&&this.sortable.init()}},clicks:{".sortable-enable":function(e,t){void 0===t&&(t={});this.sortable.enable(t.sortable)},".sortable-disable":function(e,t){void 0===t&&(t={});this.sortable.disable(t.sortable)},".sortable-toggle":function(e,t){void 0===t&&(t={});this.sortable.toggle(t.sortable)}}},Swipeout={init:function(){var e,t,a,n,r,i,o,s,l,p,c,d,u,h,f,m,v,g,b,y,w,$=this,C={};var x=!!$.support.passiveListener&&{passive:!0};$.on("touchstart",function(e){if(Swipeout.el){var t=$$1(e.target);$$1(Swipeout.el).is(t[0])||t.parents(".swipeout").is(Swipeout.el)||t.hasClass("modal-in")||(t.attr("class")||"").indexOf("-backdrop")>0||t.hasClass("actions-modal")||t.parents(".actions-modal.modal-in, .dialog.modal-in").length>0||$.swipeout.close(Swipeout.el)}}),$$1(doc).on($.touchEvents.start,"li.swipeout",function(r){Swipeout.allow&&(t=!1,e=!0,a=void 0,C.x="touchstart"===r.type?r.targetTouches[0].pageX:r.pageX,C.y="touchstart"===r.type?r.targetTouches[0].pageY:r.pageY,n=(new Date).getTime(),i=$$1(this))},x),$.on("touchmove:active",function(n){if(e){var x="touchmove"===n.type?n.targetTouches[0].pageX:n.pageX,E="touchmove"===n.type?n.targetTouches[0].pageY:n.pageY;if(void 0===a&&(a=!!(a||Math.abs(E-C.y)>Math.abs(x-C.x))),a)e=!1;else{if(!t){if($$1(".list.sortable-opened").length>0)return;o=i.find(".swipeout-content"),s=i.find(".swipeout-actions-right"),l=i.find(".swipeout-actions-left"),p=null,c=null,f=null,m=null,b=null,g=null,l.length>0&&(p=l.outerWidth(),f=l.children("a"),g=l.find(".swipeout-overswipe")),s.length>0&&(c=s.outerWidth(),m=s.children("a"),b=s.find(".swipeout-overswipe")),(u=i.hasClass("swipeout-opened"))&&(h=i.find(".swipeout-actions-left.swipeout-actions-opened").length>0?"left":"right"),i.removeClass("swipeout-transitioning"),$.params.swipeout.noFollow||(i.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),i.removeClass("swipeout-opened"))}if(t=!0,n.preventDefault(),r=x-C.x,d=r,u&&("right"===h?d-=c:d+=p),d>0&&0===l.length||d<0&&0===s.length){if(!u)return e=!1,t=!1,o.transform(""),m&&m.length>0&&m.transform(""),void(f&&f.length>0&&f.transform(""));d=0}var S,k;if(d<0?v="to-left":d>0?v="to-right":v||(v="to-left"),n.f7PreventSwipePanel=!0,$.params.swipeout.noFollow)return u?("right"===h&&r>0&&$.swipeout.close(i),"left"===h&&r<0&&$.swipeout.close(i)):(r<0&&s.length>0&&$.swipeout.open(i,"right"),r>0&&l.length>0&&$.swipeout.open(i,"left")),e=!1,void(t=!1);if(y=!1,w=!1,s.length>0){var T=d;k=T/c,T<-c&&(T=-c-Math.pow(-T-c,.8),d=T,b.length>0&&(w=!0)),"to-left"!==v&&(k=0,T=0),m.each(function(e,t){var a=$$1(t);void 0===t.f7SwipeoutButtonOffset&&(a[0].f7SwipeoutButtonOffset=t.offsetLeft),S=t.f7SwipeoutButtonOffset,b.length>0&&a.hasClass("swipeout-overswipe")&&"to-left"===v&&(a.css({left:(w?-S:0)+"px"}),w?a.addClass("swipeout-overswipe-active"):a.removeClass("swipeout-overswipe-active")),a.transform("translate3d("+(T-S*(1+Math.max(k,-1)))+"px,0,0)")})}if(l.length>0){var M=d;k=M/p,M>p&&(M=p+Math.pow(M-p,.8),d=M,g.length>0&&(y=!0)),"to-right"!==v&&(M=0,k=0),f.each(function(e,t){var a=$$1(t);void 0===t.f7SwipeoutButtonOffset&&(a[0].f7SwipeoutButtonOffset=p-t.offsetLeft-t.offsetWidth),S=t.f7SwipeoutButtonOffset,g.length>0&&a.hasClass("swipeout-overswipe")&&"to-right"===v&&(a.css({left:(y?S:0)+"px"}),y?a.addClass("swipeout-overswipe-active"):a.removeClass("swipeout-overswipe-active")),f.length>1&&a.css("z-index",f.length-e),a.transform("translate3d("+(M+S*(1-Math.min(k,1)))+"px,0,0)")})}i.trigger("swipeout",k),$.emit("swipeout",i[0],k),o.transform("translate3d("+d+"px,0,0)")}}}),$.on("touchend:passive",function(){if(!e||!t)return e=!1,void(t=!1);e=!1,t=!1;var a,h,g,b,C=(new Date).getTime()-n,x="to-left"===v?s:l,E="to-left"===v?c:p;if(a=C<300&&(r<-10&&"to-left"===v||r>10&&"to-right"===v)||C>=300&&Math.abs(d)>E/2?"open":"close",C<300&&(0===Math.abs(d)&&(a="close"),Math.abs(d)===E&&(a="open")),"open"===a){Swipeout.el=i[0],i.trigger("swipeout:open"),$.emit("swipeoutOpen",i[0]),i.addClass("swipeout-opened swipeout-transitioning");var S="to-left"===v?-E:E;if(o.transform("translate3d("+S+"px,0,0)"),x.addClass("swipeout-actions-opened"),h="to-left"===v?m:f)for(g=0;g<h.length;g+=1)$$1(h[g]).transform("translate3d("+S+"px,0,0)");w&&s.find(".swipeout-overswipe")[0].click(),y&&l.find(".swipeout-overswipe")[0].click()}else i.trigger("swipeout:close"),$.emit("swipeoutClose",i[0]),Swipeout.el=void 0,i.addClass("swipeout-transitioning").removeClass("swipeout-opened"),o.transform(""),x.removeClass("swipeout-actions-opened");f&&f.length>0&&f!==h&&f.each(function(e,t){var a=$$1(t);void 0===(b=t.f7SwipeoutButtonOffset)&&(a[0].f7SwipeoutButtonOffset=p-t.offsetLeft-t.offsetWidth),a.transform("translate3d("+b+"px,0,0)")}),m&&m.length>0&&m!==h&&m.each(function(e,t){var a=$$1(t);void 0===(b=t.f7SwipeoutButtonOffset)&&(a[0].f7SwipeoutButtonOffset=t.offsetLeft),a.transform("translate3d("+-b+"px,0,0)")}),o.transitionEnd(function(){u&&"open"===a||!u&&"close"===a||(i.trigger("open"===a?"swipeout:opened":"swipeout:closed"),$.emit("open"===a?"swipeoutOpened":"swipeoutClosed",i[0]),i.removeClass("swipeout-transitioning"),u&&"close"===a&&(s.length>0&&m.transform(""),l.length>0&&f.transform("")))})})},allow:!0,el:void 0,open:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var n=this,r=t[0],i=t[1],o=t[2];"function"==typeof t[1]&&(r=(e=t)[0],o=e[1],i=e[2]);var s=$$1(r).eq(0);if(0!==s.length&&s.hasClass("swipeout")&&!s.hasClass("swipeout-opened")){i||(i=s.find(".swipeout-actions-right").length>0?"right":"left");var l=s.find(".swipeout-actions-"+i),p=s.find(".swipeout-content");if(0!==l.length){s.trigger("swipeout:open").addClass("swipeout-opened").removeClass("swipeout-transitioning"),n.emit("swipeoutOpen",s[0]),l.addClass("swipeout-actions-opened");var c=l.children("a"),d=l.outerWidth(),u="right"===i?-d:d;c.length>1&&c.each(function(e,t){var a=$$1(t);"right"===i?a.transform("translate3d("+-t.offsetLeft+"px,0,0)"):a.css("z-index",c.length-e).transform("translate3d("+(d-t.offsetWidth-t.offsetLeft)+"px,0,0)")}),s.addClass("swipeout-transitioning"),p.transitionEnd(function(){s.trigger("swipeout:opened"),n.emit("swipeoutOpened",s[0]),o&&o.call(s[0])}),Utils.nextFrame(function(){c.transform("translate3d("+u+"px,0,0)"),p.transform("translate3d("+u+"px,0,0)")}),Swipeout.el=s[0]}}},close:function(e,t){var a=this,n=$$1(e).eq(0);if(0!==n.length&&n.hasClass("swipeout-opened")){var r,i=n.find(".swipeout-actions-opened").hasClass("swipeout-actions-right")?"right":"left",o=n.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),s=o.children("a"),l=o.outerWidth();Swipeout.allow=!1,n.trigger("swipeout:close"),a.emit("swipeoutClose",n[0]),n.removeClass("swipeout-opened").addClass("swipeout-transitioning"),n.find(".swipeout-content").transform("").transitionEnd(p),r=setTimeout(p,500),s.each(function(e,t){var a=$$1(t);"right"===i?a.transform("translate3d("+-t.offsetLeft+"px,0,0)"):a.transform("translate3d("+(l-t.offsetWidth-t.offsetLeft)+"px,0,0)"),a.css({left:"0px"}).removeClass("swipeout-overswipe-active")}),Swipeout.el&&Swipeout.el===n[0]&&(Swipeout.el=void 0)}function p(){Swipeout.allow=!0,n.hasClass("swipeout-opened")||(n.removeClass("swipeout-transitioning"),s.transform(""),n.trigger("swipeout:closed"),a.emit("swipeoutClosed",n[0]),t&&t.call(n[0]),r&&clearTimeout(r))}},delete:function(e,t){var a=this,n=$$1(e).eq(0);0!==n.length&&(Swipeout.el=void 0,n.trigger("swipeout:delete"),a.emit("swipeoutDelete",n[0]),n.css({height:n.outerHeight()+"px"}),n.transitionEnd(function(){if(n.trigger("swipeout:deleted"),a.emit("swipeoutDeleted",n[0]),t&&t.call(n[0]),n.parents(".virtual-list").length>0){var e=n.parents(".virtual-list")[0].f7VirtualList,r=n[0].f7VirtualListIndex;e&&void 0!==r&&e.deleteItem(r)}else a.params.swipeout.removeElements?a.params.swipeout.removeElementsWithTimeout?setTimeout(function(){n.remove()},a.params.swipeout.removeElementsTimeout):n.remove():n.removeClass("swipeout-deleting swipeout-transitioning")}),n[0]._clientLeft=n[0].clientLeft,n.addClass("swipeout-deleting swipeout-transitioning").css({height:"0px"}).find(".swipeout-content").transform("translate3d(-100%,0,0)"))}},Swipeout$1={name:"swipeout",params:{swipeout:{actionsNoFold:!1,noFollow:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0}},create:function(){var e=this;Utils.extend(e,{swipeout:{init:Swipeout.init.bind(e),open:Swipeout.open.bind(e),close:Swipeout.close.bind(e),delete:Swipeout.delete.bind(e)}}),Object.defineProperty(e.swipeout,"el",{enumerable:!0,configurable:!0,get:function(){return Swipeout.el},set:function(e){Swipeout.el=e}}),Object.defineProperty(e.swipeout,"allow",{enumerable:!0,configurable:!0,get:function(){return Swipeout.allow},set:function(e){Swipeout.allow=e}})},clicks:{".swipeout-open":function(e,t){void 0===t&&(t={});this.swipeout.open(t.swipeout,t.side)},".swipeout-close":function(e){var t=e.closest(".swipeout");0!==t.length&&this.swipeout.close(t)},".swipeout-delete":function(e,t){void 0===t&&(t={});var a=this,n=e.closest(".swipeout");if(0!==n.length){var r=t.confirm,i=t.confirmTitle;t.confirm?a.dialog.confirm(r,i,function(){a.swipeout.delete(n)}):a.swipeout.delete(n)}}},on:{init:function(){this.params.swipeout&&this.swipeout.init()}}},Accordion={toggleClicked:function(e){var t=e.closest(".accordion-item").eq(0);t.length||(t=e.parents("li").eq(0)),e.parents("li").length>1&&e.parents("li")[0]!==t[0]||this.accordion.toggle(t)},open:function(e){var t=this,a=$$1(e),n=a.parents(".accordion-list").eq(0),r=a.children(".accordion-item-content");if(0===r.length&&(r=a.find(".accordion-item-content")),0!==r.length){var i=n.length>0&&a.parent().children(".accordion-item-opened");i.length>0&&t.accordion.close(i),r.transitionEnd(function(){a.hasClass("accordion-item-opened")?(r.transition(0),r.css("height","auto"),r._clientLeft=r[0].clientLeft,r.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])):(r.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))}),r.css("height",r[0].scrollHeight+"px"),a.trigger("accordion:open"),a.addClass("accordion-item-opened"),t.emit("accordionOpen",a[0])}},close:function(e){var t=this,a=$$1(e),n=a.children(".accordion-item-content");0===n.length&&(n=a.find(".accordion-item-content")),a.removeClass("accordion-item-opened"),n.transition(0),n.css("height",n[0].scrollHeight+"px"),n._clientLeft=n[0].clientLeft,n.transition(""),n.transitionEnd(function(){a.hasClass("accordion-item-opened")?(n.transition(0),n.css("height","auto"),n._clientLeft=n[0].clientLeft,n.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])):(n.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))}),Utils.nextFrame(function(){n.transition(""),n.css("height",""),a.trigger("accordion:close"),t.emit("accordionClose")})},toggle:function(e){var t=$$1(e);0!==t.length&&(t.hasClass("accordion-item-opened")?this.accordion.close(e):this.accordion.open(e))}},Accordion$1={name:"accordion",create:function(){Utils.extend(this,{accordion:{open:Accordion.open.bind(this),close:Accordion.close.bind(this),toggle:Accordion.toggle.bind(this)}})},clicks:{".accordion-item .item-link, .accordion-item-toggle, .links-list.accordion-list > ul > li > a":function(e){Accordion.toggleClicked.call(this,e)}}},VirtualList=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this,r={cols:1,height:"md"===t.theme?48:44,cache:!0,dynamicHeightBufferSize:1,showFilteredItemsOnly:!1,renderExternal:void 0,setListHeight:!0,searchByItem:void 0,searchAll:void 0,itemTemplate:void 0,ul:null,createUl:!0,renderItem:function(e){return('\n          <li>\n            <div class="item-content">\n              <div class="item-inner">\n                <div class="item-title">'+e+"</div>\n              </div>\n            </div>\n          </li>\n        ").trim()},on:{}};if(n.useModulesParams(r),n.params=Utils.extend(r,a),void 0!==n.params.height&&n.params.height||(n.params.height="md"===t.theme?48:44),n.$el=$$1(a.el),n.el=n.$el[0],0!==n.$el.length){n.$el[0].f7VirtualList=n,n.items=n.params.items,n.params.showFilteredItemsOnly&&(n.filteredItems=[]),n.params.itemTemplate?"string"==typeof n.params.itemTemplate?n.renderItem=Template7.compile(n.params.itemTemplate):"function"==typeof n.params.itemTemplate&&(n.renderItem=n.params.itemTemplate):n.params.renderItem&&(n.renderItem=n.params.renderItem),n.$pageContentEl=n.$el.parents(".page-content"),n.pageContentEl=n.$pageContentEl[0],void 0!==n.params.updatableScroll?n.updatableScroll=n.params.updatableScroll:(n.updatableScroll=!0,Device.ios&&Device.osVersion.split(".")[0]<8&&(n.updatableScroll=!1));var i,o=n.params.ul;n.$ul=o?$$1(n.params.ul):n.$el.children("ul"),0===n.$ul.length&&n.params.createUl&&(n.$el.append("<ul></ul>"),n.$ul=n.$el.children("ul")),n.ul=n.$ul[0],i=n.ul||n.params.createUl?n.$ul:n.$el,Utils.extend(n,{$itemsWrapEl:i,itemsWrapEl:i[0],domCache:{},displayDomCache:{},tempDomElement:doc.createElement("ul"),lastRepaintY:null,fragment:doc.createDocumentFragment(),pageHeight:void 0,rowsPerScreen:void 0,rowsBefore:void 0,rowsAfter:void 0,rowsToRender:void 0,maxBufferHeight:0,listHeight:void 0,dynamicHeight:"function"==typeof n.params.height}),n.useModules();var s,l,p,c,d=n.handleScroll.bind(n),u=n.handleResize.bind(n);return n.attachEvents=function(){s=n.$el.parents(".page").eq(0),l=n.$el.parents(".tab").eq(0),p=n.$el.parents(".panel").eq(0),c=n.$el.parents(".popup").eq(0),n.$pageContentEl.on("scroll",d),s&&s.on("page:reinit",u),l&&l.on("tab:show",u),p&&p.on("panel:open",u),c&&c.on("popup:open",u),t.on("resize",u)},n.detachEvents=function(){n.$pageContentEl.off("scroll",d),s&&s.off("page:reinit",u),l&&l.off("tab:show",u),p&&p.off("panel:open",u),c&&c.off("popup:open",u),t.off("resize",u)},n.init(),n}}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.setListSize=function(){var e=this,t=e.filteredItems||e.items;if(e.pageHeight=e.$pageContentEl[0].offsetHeight,e.dynamicHeight){e.listHeight=0,e.heights=[];for(var a=0;a<t.length;a+=1){var n=e.params.height(t[a]);e.listHeight+=n,e.heights.push(n)}}else e.listHeight=Math.ceil(t.length/e.params.cols)*e.params.height,e.rowsPerScreen=Math.ceil(e.pageHeight/e.params.height),e.rowsBefore=e.params.rowsBefore||2*e.rowsPerScreen,e.rowsAfter=e.params.rowsAfter||e.rowsPerScreen,e.rowsToRender=e.rowsPerScreen+e.rowsBefore+e.rowsAfter,e.maxBufferHeight=e.rowsBefore/2*e.params.height;(e.updatableScroll||e.params.setListHeight)&&e.$itemsWrapEl.css({height:e.listHeight+"px"})},t.prototype.render=function(e,t){var a=this;e&&(a.lastRepaintY=null);var n=-(a.$el[0].getBoundingClientRect().top-a.$pageContentEl[0].getBoundingClientRect().top);if(void 0!==t&&(n=t),null===a.lastRepaintY||Math.abs(n-a.lastRepaintY)>a.maxBufferHeight||!a.updatableScroll&&a.$pageContentEl[0].scrollTop+a.pageHeight>=a.$pageContentEl[0].scrollHeight){a.lastRepaintY=n;var r,i,o,s=a.filteredItems||a.items,l=0,p=0;if(a.dynamicHeight){var c,d=0;a.maxBufferHeight=a.pageHeight;for(var u=0;u<a.heights.length;u+=1)c=a.heights[u],void 0===r&&(d+c>=n-2*a.pageHeight*a.params.dynamicHeightBufferSize?r=u:l+=c),void 0===i&&((d+c>=n+2*a.pageHeight*a.params.dynamicHeightBufferSize||u===a.heights.length-1)&&(i=u+1),p+=c),d+=c;i=Math.min(i,s.length)}else(r=(parseInt(n/a.params.height,10)-a.rowsBefore)*a.params.cols)<0&&(r=0),i=Math.min(r+a.rowsToRender*a.params.cols,s.length);var h,f=[];for(a.reachEnd=!1,h=r;h<i;h+=1){var m=void 0,v=a.items.indexOf(s[h]);h===r&&(a.currentFromIndex=v),h===i-1&&(a.currentToIndex=v),a.filteredItems?a.items[v]===a.filteredItems[a.filteredItems.length-1]&&(a.reachEnd=!0):v===a.items.length-1&&(a.reachEnd=!0),a.params.renderExternal?f.push(s[h]):a.domCache[v]?(m=a.domCache[v]).f7VirtualListIndex=v:(a.renderItem?a.tempDomElement.innerHTML=a.renderItem(s[h],v).trim():a.tempDomElement.innerHTML=s[h].toString().trim(),m=a.tempDomElement.childNodes[0],a.params.cache&&(a.domCache[v]=m),m.f7VirtualListIndex=v),h===r&&(o=a.dynamicHeight?l:h*a.params.height/a.params.cols),a.params.renderExternal||(m.style.top=o+"px",a.emit("local::itemBeforeInsert vlItemBeforeInsert",a,m,s[h]),a.fragment.appendChild(m))}a.updatableScroll||(a.dynamicHeight?a.itemsWrapEl.style.height=p+"px":a.itemsWrapEl.style.height=h*a.params.height/a.params.cols+"px"),a.params.renderExternal?s&&0===s.length&&(a.reachEnd=!0):(a.emit("local::beforeClear vlBeforeClear",a,a.fragment),a.itemsWrapEl.innerHTML="",a.emit("local::itemsBeforeInsert vlItemsBeforeInsert",a,a.fragment),s&&0===s.length?(a.reachEnd=!0,a.params.emptyTemplate&&(a.itemsWrapEl.innerHTML=a.params.emptyTemplate)):a.itemsWrapEl.appendChild(a.fragment),a.emit("local::itemsAfterInsert vlItemsAfterInsert",a,a.fragment)),void 0!==t&&e&&a.$pageContentEl.scrollTop(t,0),a.params.renderExternal&&a.params.renderExternal(a,{fromIndex:r,toIndex:i,listHeight:a.listHeight,topPosition:o,items:f})}},t.prototype.filterItems=function(e,t){void 0===t&&(t=!0);var a=this;a.filteredItems=[];for(var n=0;n<e.length;n+=1)a.filteredItems.push(a.items[e[n]]);t&&(a.$pageContentEl[0].scrollTop=0),a.update()},t.prototype.resetFilter=function(){var e=this;e.params.showFilteredItemsOnly?e.filteredItems=[]:(e.filteredItems=null,delete e.filteredItems),e.update()},t.prototype.scrollToItem=function(e){var t=this;if(e>t.items.length)return!1;var a=0;if(t.dynamicHeight)for(var n=0;n<e;n+=1)a+=t.heights[n];else a=e*t.params.height;var r=t.$el[0].offsetTop;return t.render(!0,r+a-parseInt(t.$pageContentEl.css("padding-top"),10)),!0},t.prototype.handleScroll=function(){this.render()},t.prototype.isVisible=function(){return!!(this.el.offsetWidth||this.el.offsetHeight||this.el.getClientRects().length)},t.prototype.handleResize=function(){this.isVisible()&&(this.setListSize(),this.render(!0))},t.prototype.appendItems=function(e){for(var t=0;t<e.length;t+=1)this.items.push(e[t]);this.update()},t.prototype.appendItem=function(e){this.appendItems([e])},t.prototype.replaceAllItems=function(e){this.items=e,delete this.filteredItems,this.domCache={},this.update()},t.prototype.replaceItem=function(e,t){this.items[e]=t,this.params.cache&&delete this.domCache[e],this.update()},t.prototype.prependItems=function(e){for(var t=this,a=e.length-1;a>=0;a-=1)t.items.unshift(e[a]);if(t.params.cache){var n={};Object.keys(t.domCache).forEach(function(a){n[parseInt(a,10)+e.length]=t.domCache[a]}),t.domCache=n}t.update()},t.prototype.prependItem=function(e){this.prependItems([e])},t.prototype.moveItem=function(e,t){var a=this,n=e,r=t;if(n!==r){var i=a.items.splice(n,1)[0];if(r>=a.items.length?(a.items.push(i),r=a.items.length-1):a.items.splice(r,0,i),a.params.cache){var o={};Object.keys(a.domCache).forEach(function(e){var t=parseInt(e,10),i=n<r?n:r,s=n<r?r:n,l=n<r?-1:1;(t<i||t>s)&&(o[t]=a.domCache[t]),t===i&&(o[s]=a.domCache[t]),t>i&&t<=s&&(o[t+l]=a.domCache[t])}),a.domCache=o}a.update()}},t.prototype.insertItemBefore=function(e,t){var a=this;if(0!==e)if(e>=a.items.length)a.appendItem(t);else{if(a.items.splice(e,0,t),a.params.cache){var n={};Object.keys(a.domCache).forEach(function(t){var r=parseInt(t,10);r>=e&&(n[r+1]=a.domCache[r])}),a.domCache=n}a.update()}else a.prependItem(t)},t.prototype.deleteItems=function(e){for(var t,a=this,n=0,r=function(r){var i=e[r];void 0!==t&&i>t&&(n=-r),i+=n,t=e[r];var o=a.items.splice(i,1)[0];if(a.filteredItems&&a.filteredItems.indexOf(o)>=0&&a.filteredItems.splice(a.filteredItems.indexOf(o),1),a.params.cache){var s={};Object.keys(a.domCache).forEach(function(e){var t=parseInt(e,10);t===i?delete a.domCache[i]:parseInt(e,10)>i?s[t-1]=a.domCache[e]:s[t]=a.domCache[e]}),a.domCache=s}},i=0;i<e.length;i+=1)r(i);a.update()},t.prototype.deleteAllItems=function(){var e=this;e.items=[],delete e.filteredItems,e.params.cache&&(e.domCache={}),e.update()},t.prototype.deleteItem=function(e){this.deleteItems([e])},t.prototype.clearCache=function(){this.domCache={}},t.prototype.update=function(e){e&&this.params.cache&&(this.domCache={}),this.setListSize(),this.render(!0)},t.prototype.init=function(){this.attachEvents(),this.setListSize(),this.render()},t.prototype.destroy=function(){var e=this;e.detachEvents(),e.$el[0].f7VirtualList=null,delete e.$el[0].f7VirtualList,Utils.deleteProps(e),e=null},t}(Framework7Class),VirtualList$1={name:"virtualList",static:{VirtualList:VirtualList},create:function(){this.virtualList=ConstructorMethods({defaultSelector:".virtual-list",constructor:VirtualList,app:this,domProp:"f7VirtualList"})}},ListIndex=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n,r,i,o,s=this,l={el:null,listEl:null,indexes:"auto",iosItemHeight:14,mdItemHeight:14,scrollList:!0,label:!1,renderItem:function(e,t){return("\n          <li>"+e+"</li>\n        ").trim()},renderSkipPlaceholder:function(){return'<li class="list-index-skip-placeholder"></li>'},on:{}};if(s.useModulesParams(l),s.params=Utils.extend(l,a),!s.params.el)return s;if(n=$$1(s.params.el),0===(o=n.find("ul")).length&&(o=$$1("<ul></ul>"),n.append(o)),s.params.listEl&&(r=$$1(s.params.listEl)),"auto"===s.params.indexes&&!r)return s;function p(){var e={index:s};s.calcSize(),e!==s.height&&s.render()}function c(e){var t=$$1(e.target).closest("li");if(t.length){var a=t.index();if(s.skipRate>0){var n=a/(t.siblings("li").length-1);a=Math.round((s.indexes.length-1)*n)}var r=s.indexes[a];s.$el.trigger("listindex:click",r,a),s.emit("local::click listIndexClick",s,r,a),s.$el.trigger("listindex:select",r,a),s.emit("local::select listIndexSelect",s,r,a),s.$listEl&&s.params.scrollList&&s.scrollListToIndex(r,a)}}r?i=r.parents(".page-content").eq(0):0===(i=n.siblings(".page-content").eq(0)).length&&(i=n.parents(".page").eq(0).find(".page-content").eq(0)),n[0].f7ListIndex=s,Utils.extend(s,{app:t,$el:n,el:n&&n[0],$ul:o,ul:o&&o[0],$listEl:r,listEl:r&&r[0],$pageContentEl:i,pageContentEl:i&&i[0],indexes:a.indexes,height:0,skipRate:0}),s.useModules();var d,u,h,f,m,v={},g=null;function b(e){var t=o.children();t.length&&(h=t[0].getBoundingClientRect().top,f=t[t.length-1].getBoundingClientRect().top+t[0].offsetHeight,v.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,v.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,d=!0,u=!1,g=null)}function y(e){if(d){!u&&s.params.label&&(m=$$1('<span class="list-index-label"></span>'),n.append(m)),u=!0;var t="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;e.preventDefault();var a=(t-h)/(f-h);a=Math.min(Math.max(a,0),1);var r=Math.round((s.indexes.length-1)*a),i=s.indexes[r],o=f-h,l=(s.height-o)/2+(1-a)*o;r!==g&&(s.params.label&&m.html(i).transform("translateY(-"+l+"px)"),s.$listEl&&s.params.scrollList&&s.scrollListToIndex(i,r)),g=r,s.$el.trigger("listindex:select",s),s.emit("local::select listIndexSelect",s,i,r)}}function w(){d&&(d=!1,u=!1,s.params.label&&(m&&m.remove(),m=void 0))}var $=!!t.support.passiveListener&&{passive:!0};return s.attachEvents=function(){n.parents(".tab").on("tab:show",p),n.parents(".page").on("page:reinit",p),n.parents(".panel").on("panel:open",p),n.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").on("modal:open",p),t.on("resize",p),n.on("click",c),n.on(t.touchEvents.start,b,$),t.on("touchmove:active",y),t.on("touchend:passive",w)},s.detachEvents=function(){n.parents(".tab").off("tab:show",p),n.parents(".page").off("page:reinit",p),n.parents(".panel").off("panel:open",p),n.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").off("modal:open",p),t.off("resize",p),n.off("click",c),n.off(t.touchEvents.start,b,$),t.off("touchmove:active",y),t.off("touchend:passive",w)},s.init(),s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.scrollListToIndex=function(e,t){var a,n=this,r=n.$listEl,i=n.$pageContentEl;if(!r||!i||0===i.length)return n;if(r.find(".list-group-title, .item-divider").each(function(t,n){if(!a){var r=$$1(n);r.text()===e&&(a=r)}}),!a||0===a.length)return n;var o=a.parent().offset().top,s=parseInt(i.css("padding-top"),10),l=i[0].scrollTop,p=a.offset().top;return o<=s?i.scrollTop(o+l-s):i.scrollTop(p+l-s),n},t.prototype.renderSkipPlaceholder=function(){return this.params.renderSkipPlaceholder.call(this)},t.prototype.renderItem=function(e,t){return this.params.renderItem.call(this,e,t)},t.prototype.render=function(){var e,t=this,a=t.$ul,n=t.indexes,r=t.skipRate,i=n.map(function(a,n){if(n%r!=0&&r>0)return e=!0,"";var i=t.renderItem(a,n);return e&&(i=t.renderSkipPlaceholder()+i),e=!1,i}).join("");return a.html(i),t},t.prototype.calcSize=function(){var e=this,t=e.app,a=e.params,n=e.el,r=e.indexes,i=n.offsetHeight,o="ios"===t.theme?a.iosItemHeight:a.mdItemHeight,s=Math.floor(i/o),l=r.length,p=0;return l>s&&(p=Math.ceil((2*l-1)/s)),e.height=i,e.skipRate=p,e},t.prototype.calcIndexes=function(){var e=this;return"auto"===e.params.indexes?(e.indexes=[],e.$listEl.find(".list-group-title, .item-divider").each(function(t,a){var n=$$1(a).text();e.indexes.indexOf(n)<0&&e.indexes.push(n)})):e.indexes=e.params.indexes,e},t.prototype.update=function(){return this.calcIndexes(),this.calcSize(),this.render(),this},t.prototype.init=function(){this.calcIndexes(),this.calcSize(),this.render(),this.attachEvents()},t.prototype.destroy=function(){var e=this;e.$el.trigger("listindex:beforedestroy",e),e.emit("local::beforeDestroy listIndexBeforeDestroy",e),e.detachEvents(),e.$el[0].f7ListIndex=null,delete e.$el[0].f7ListIndex,Utils.deleteProps(e),e=null},t}(Framework7Class),ListIndex$1={name:"listIndex",static:{ListIndex:ListIndex},create:function(){this.listIndex=ConstructorMethods({defaultSelector:".list-index",constructor:ListIndex,app:this,domProp:"f7ListIndex"})},on:{tabMounted:function(e){var t=this;$$1(e).find(".list-index-init").each(function(e,a){var n=Utils.extend($$1(a).dataset(),{el:a});t.listIndex.create(n)})},tabBeforeRemove:function(e){$$1(e).find(".list-index-init").each(function(e,t){t.f7ListIndex&&t.f7ListIndex.destroy()})},pageInit:function(e){var t=this;e.$el.find(".list-index-init").each(function(e,a){var n=Utils.extend($$1(a).dataset(),{el:a});t.listIndex.create(n)})},pageBeforeRemove:function(e){e.$el.find(".list-index-init").each(function(e,t){t.f7ListIndex&&t.f7ListIndex.destroy()})}}},Timeline={name:"timeline"},Tab={show:function(){for(var e,t,a,n=[],r=arguments.length;r--;)n[r]=arguments[r];var i,o,s,l,p=this;1===n.length&&n[0].constructor===Object?(i=n[0].tabEl,o=n[0].tabLinkEl,s=n[0].animate,l=n[0].tabRoute):(i=(e=n)[0],o=e[1],s=e[2],l=e[3],"boolean"==typeof n[1]&&(i=(t=n)[0],s=t[1],o=t[2],l=t[3],n.length>2&&o.constructor===Object&&(i=(a=n)[0],s=a[1],l=a[2],o=a[3]))),void 0===s&&(s=!0);var c,d=$$1(i);if(l&&d[0]&&(d[0].f7TabRoute=l),0===d.length||d.hasClass("tab-active"))return{$newTabEl:d,newTabEl:d[0]};o&&(c=$$1(o));var u=d.parent(".tabs");if(0===u.length)return{$newTabEl:d,newTabEl:d[0]};p.swipeout&&(p.swipeout.allowOpen=!0);var h=[];function f(){h.forEach(function(e){e()})}var m=!1;if(u.parent().hasClass("tabs-animated-wrap")){u.parent()[s?"removeClass":"addClass"]("not-animated");var v=parseFloat(u.css("transition-duration").replace(",","."));s&&v&&(u.transitionEnd(f),m=!0);var g=100*(p.rtl?d.index():-d.index());u.transform("translate3d("+g+"%,0,0)")}if(u.parent().hasClass("tabs-swipeable-wrap")&&p.swiper){var b=u.parent()[0].swiper;b&&b.activeIndex!==d.index()&&(m=!0,b.once("slideChangeTransitionEnd",function(){f()}).slideTo(d.index(),s?void 0:0))}var y=u.children(".tab-active");if(y.removeClass("tab-active").trigger("tab:hide"),p.emit("tabHide",y[0]),d.addClass("tab-active").trigger("tab:show"),p.emit("tabShow",d[0]),!c&&((!(c=$$1("string"==typeof i?'.tab-link[href="'+i+'"]':'.tab-link[href="#'+d.attr("id")+'"]'))||c&&0===c.length)&&$$1("[data-tab]").each(function(e,t){d.is($$1(t).attr("data-tab"))&&(c=$$1(t))}),l&&(!c||c&&0===c.length)&&0===(c=$$1('[data-route-tab-id="'+l.route.tab.id+'"]')).length&&(c=$$1('.tab-link[href="'+l.url+'"]')),c.length>1&&d.parents(".page").length&&(c=c.filter(function(e,t){return $$1(t).parents(".page")[0]===d.parents(".page")[0]}),"ios"===p.theme&&0===c.length&&l))){var w=d.parents(".page"),$=$$1(p.navbar.getElByPage(w));0===(c=$.find('[data-route-tab-id="'+l.route.tab.id+'"]')).length&&(c=$.find('.tab-link[href="'+l.url+'"]'))}if(c.length>0){var C;if(y&&y.length>0){var x=y.attr("id");x&&(!(C=$$1('.tab-link[href="#'+x+'"]'))||C&&0===C.length)&&(C=$$1('.tab-link[data-route-tab-id="'+x+'"]')),(!C||C&&0===C.length)&&$$1("[data-tab]").each(function(e,t){y.is($$1(t).attr("data-tab"))&&(C=$$1(t))}),(!C||C&&0===C.length)&&(C=c.siblings(".tab-link-active"))}else l&&(C=c.siblings(".tab-link-active"));if(C&&C.length>1&&y&&y.parents(".page").length&&(C=C.filter(function(e,t){return $$1(t).parents(".page")[0]===y.parents(".page")[0]})),C&&C.length>0&&C.removeClass("tab-link-active"),c&&c.length>0&&(c.addClass("tab-link-active"),"md"===p.theme&&p.toolbar)){var E=c.parents(".tabbar, .tabbar-labels");E.length>0&&p.toolbar.setHighlight(E)}}return{$newTabEl:d,newTabEl:d[0],$oldTabEl:y,oldTabEl:y[0],onTabsChanged:function(e){h.push(e)},animated:m}}},Tabs={name:"tabs",create:function(){Utils.extend(this,{tab:{show:Tab.show.bind(this)}})},clicks:{".tab-link":function(e,t){void 0===t&&(t={});(e.attr("href")&&0===e.attr("href").indexOf("#")||e.attr("data-tab"))&&this.tab.show({tabEl:t.tab||e.attr("href"),tabLinkEl:e,animate:t.animate})}}};function swipePanel(e){var t=e.app;Utils.extend(e,{swipeable:!0,swipeInitialized:!0});var a,n,r,i,o,s,l,p,c,d,u,h=t.params.panel,f=e.$el,m=e.$backdropEl,v=e.side,g=e.effect,b={},y=0;function w(s){if(e.swipeable&&t.panel.allowOpen&&(h.swipe||h.swipeOnlyClose)&&!n&&!($$1(".modal-in, .photo-browser-in").length>0)&&(a=t.panel["left"===v?"right":"left"]||{},(e.opened||!a.opened)&&(h.swipeCloseOpposite||h.swipeOnlyClose||!a.opened)&&(!s.target||"input"!==s.target.nodeName.toLowerCase()||"range"!==s.target.type)&&!($$1(s.target).closest(".range-slider, .tabs-swipeable-wrap, .calendar-months, .no-swipe-panel").length>0)&&(b.x="touchstart"===s.type?s.targetTouches[0].pageX:s.pageX,b.y="touchstart"===s.type?s.targetTouches[0].pageY:s.pageY,(!h.swipeOnlyClose||e.opened)&&("both"===h.swipe||!h.swipeCloseOpposite||h.swipe===v||e.opened)))){if(h.swipeActiveArea&&!e.opened){if("left"===v&&b.x>h.swipeActiveArea)return;if("right"===v&&b.x<t.width-h.swipeActiveArea)return}if(h.swipeCloseActiveAreaSide&&e.opened){if("left"===v&&b.x<f[0].offsetWidth-h.swipeCloseActiveAreaSide)return;if("right"===v&&b.x>t.width-f[0].offsetWidth+h.swipeCloseActiveAreaSide)return}y=0,u=$$1(e.getViewEl()),r=!1,n=!0,i=void 0,o=Utils.now(),d=void 0}}function $(a){if(n&&!((y+=1)<2))if(a.f7PreventSwipePanel||t.preventSwipePanelBySwipeBack||t.preventSwipePanel)n=!1;else{var w="touchmove"===a.type?a.targetTouches[0].pageX:a.pageX,$="touchmove"===a.type?a.targetTouches[0].pageY:a.pageY;if(void 0===i&&(i=!!(i||Math.abs($-b.y)>Math.abs(w-b.x))),i)n=!1;else{if(!d){if(d=w>b.x?"to-right":"to-left","both"===h.swipe&&h.swipeActiveArea>0&&!e.opened){if("left"===v&&b.x>h.swipeActiveArea)return void(n=!1);if("right"===v&&b.x<t.width-h.swipeActiveArea)return void(n=!1)}if(f.hasClass("panel-visible-by-breakpoint"))return void(n=!1);if("left"===v&&"to-left"===d&&!f.hasClass("panel-active")||"right"===v&&"to-right"===d&&!f.hasClass("panel-active"))return void(n=!1)}if(h.swipeNoFollow)return(new Date).getTime()-o<300&&("to-left"===d&&("right"===v&&t.panel.open(v),"left"===v&&f.hasClass("panel-active")&&t.panel.close()),"to-right"===d&&("left"===v&&t.panel.open(v),"right"===v&&f.hasClass("panel-active")&&t.panel.close())),n=!1,void(r=!1);r||(e.opened||(f.show(),m.show(),f.trigger("panel:swipeopen",e),e.emit("local::swipeOpen panelSwipeOpen",e)),c=f[0].offsetWidth,f.transition(0)),r=!0,a.preventDefault();var C=e.opened?0:-h.swipeThreshold;"right"===v&&(C=-C),s=w-b.x+C,"right"===v?"cover"===g?((l=s+(e.opened?0:c))<0&&(l=0),l>c&&(l=c)):((l=s-(e.opened?c:0))>0&&(l=0),l<-c&&(l=-c)):((l=s+(e.opened?c:0))<0&&(l=0),l>c&&(l=c)),"reveal"===g?(u.transform("translate3d("+l+"px,0,0)").transition(0),m.transform("translate3d("+l+"px,0,0)").transition(0),f.trigger("panel:swipe",e,Math.abs(l/c)),e.emit("local::swipe panelSwipe",e,Math.abs(l/c))):("left"===v&&(l-=c),f.transform("translate3d("+l+"px,0,0)").transition(0),m.transition(0),p=1-Math.abs(l/c),m.css({opacity:p}),f.trigger("panel:swipe",e,Math.abs(l/c)),e.emit("local::swipe panelSwipe",e,Math.abs(l/c)))}}}function C(){if(!n||!r)return n=!1,void(r=!1);n=!1,r=!1;var t,a=(new Date).getTime()-o,i=0===l||Math.abs(l)===c,p=h.swipeThreshold||0;if("swap"===(t=e.opened?"cover"===g?0===l?"reset":a<300&&Math.abs(l)>0?"swap":a>=300&&Math.abs(l)<c/2?"reset":"swap":l===-c?"reset":a<300&&Math.abs(l)>=0||a>=300&&Math.abs(l)<=c/2?"left"===v&&l===c?"reset":"swap":"reset":Math.abs(s)<p?"reset":"cover"===g?0===l?"swap":a<300&&Math.abs(l)>0?"swap":a>=300&&Math.abs(l)<c/2?"swap":"reset":0===l?"reset":a<300&&Math.abs(l)>0||a>=300&&Math.abs(l)>=c/2?"swap":"reset")&&(e.opened?e.close(!i):e.open(!i)),"reset"===t&&!e.opened)if(i)f.css({display:""});else{var d="reveal"===g?u:f;$$1("html").addClass("with-panel-transitioning"),d.transitionEnd(function(){f.hasClass("panel-active")||(f.css({display:""}),$$1("html").removeClass("with-panel-transitioning"))})}"reveal"===g&&Utils.nextFrame(function(){u.transition(""),u.transform("")}),f.transition("").transform(""),m.css({display:""}).transform("").transition("").css("opacity","")}t.on("touchstart:passive",w),t.on("touchmove:active",$),t.on("touchend:passive",C),e.on("panelDestroy",function(){t.off("touchstart:passive",w),t.off("touchmove:active",$),t.off("touchend:passive",C)})}var Panel=function(e){function t(t,a){var n;void 0===a&&(a={}),e.call(this,a,[t]);var r=this,i=$$1(a.el);if(0===i.length)return r;if(i[0].f7Panel)return i[0].f7Panel;i[0].f7Panel=r;var o=a.opened,s=a.side,l=a.effect;void 0===o&&(o=i.hasClass("panel-active")),void 0===s&&(s=i.hasClass("panel-left")?"left":"right"),void 0===l&&(l=i.hasClass("panel-cover")?"cover":"reveal"),t.panel[s]||Utils.extend(t.panel,((n={})[s]=r,n));var p=$$1(".panel-backdrop");return 0===p.length&&(p=$$1('<div class="panel-backdrop"></div>')).insertBefore(i),Utils.extend(r,{app:t,side:s,effect:l,$el:i,el:i[0],opened:o,$backdropEl:p,backdropEl:p[0]}),r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.init=function(){var e=this,t=e.app;t.params.panel[e.side+"Breakpoint"]&&e.initBreakpoints(),(t.params.panel.swipe===e.side||"both"===t.params.panel.swipe||t.params.panel.swipe&&t.params.panel.swipe!==e.side&&t.params.panel.swipeCloseOpposite)&&e.initSwipePanel()},t.prototype.getViewEl=function(){var e=this.app;return e.root.children(".views").length>0?e.root.children(".views")[0]:e.root.children(".view")[0]},t.prototype.setBreakpoint=function(){var e,t,a=this,n=a.app,r=a.side,i=a.$el,o=$$1(a.getViewEl()),s=n.params.panel[r+"Breakpoint"],l=i.hasClass("panel-visible-by-breakpoint");n.width>=s?l||($$1("html").removeClass("with-panel-"+r+"-reveal with-panel-"+r+"-cover with-panel"),i.css("display","").addClass("panel-visible-by-breakpoint").removeClass("panel-active"),a.onOpen(),a.onOpened(),o.css(((e={})["margin-"+r]=i.width()+"px",e)),n.allowPanelOpen=!0,n.emit("local::breakpoint panelBreakpoint"),a.$el.trigger("panel:breakpoint",a)):l&&(i.css("display","").removeClass("panel-visible-by-breakpoint panel-active"),a.onClose(),a.onClosed(),o.css(((t={})["margin-"+r]="",t)),n.emit("local::breakpoint panelBreakpoint"),a.$el.trigger("panel:breakpoint",a))},t.prototype.initBreakpoints=function(){var e=this,t=e.app;return e.resizeHandler=function(){e.setBreakpoint()},t.params.panel[e.side+"Breakpoint"]&&t.on("resize",e.resizeHandler),e.setBreakpoint(),e},t.prototype.initSwipePanel=function(){swipePanel(this)},t.prototype.destroy=function(){var e=this,t=e.app;e.emit("local::beforeDestroy panelBeforeDestroy",e),e.$el.trigger("panel:beforedestroy",e),e.resizeHandler&&t.off("resize",e.resizeHandler),e.$el.trigger("panel:destroy",e),e.emit("local::destroy panelDestroy"),delete t.panel[e.side],delete e.el.f7Panel,Utils.deleteProps(e),e=null},t.prototype.open=function(e){void 0===e&&(e=!0);var t=this,a=t.app;if(!a.panel.allowOpen)return!1;var n=t.side,r=t.effect,i=t.$el,o=t.$backdropEl;if(t.opened||i.hasClass("panel-visible-by-breakpoint")||i.hasClass("panel-active"))return!1;a.panel.close("left"===n?"right":"left",e),a.panel.allowOpen=!1,i[e?"removeClass":"addClass"]("not-animated"),i.css({display:"block"}).addClass("panel-active"),o[e?"removeClass":"addClass"]("not-animated"),o.show(),t._clientLeft=i[0].clientLeft,$$1("html").addClass("with-panel with-panel-"+n+"-"+r),t.onOpen();var s="reveal"===r?i.nextAll(".view, .views").eq(0):i;return e?function e(){s.transitionEnd(function(a){$$1(a.target).is(s)?i.hasClass("panel-active")?(t.onOpened(),o.css({display:""})):(t.onClosed(),o.css({display:""})):e()})}():(t.onOpened(),o.css({display:""})),!0},t.prototype.close=function(e){void 0===e&&(e=!0);var t=this,a=t.app,n=t.side,r=t.effect,i=t.$el,o=t.$backdropEl;if(!t.opened||i.hasClass("panel-visible-by-breakpoint")||!i.hasClass("panel-active"))return!1;i[e?"removeClass":"addClass"]("not-animated"),i.removeClass("panel-active"),o[e?"removeClass":"addClass"]("not-animated");var s="reveal"===r?i.nextAll(".view, .views").eq(0):i;return t.onClose(),a.panel.allowOpen=!1,e?(s.transitionEnd(function(){i.hasClass("panel-active")||(i.css({display:""}),$$1("html").removeClass("with-panel-transitioning"),t.onClosed())}),$$1("html").removeClass("with-panel with-panel-"+n+"-"+r).addClass("with-panel-transitioning")):(i.css({display:""}),i.removeClass("not-animated"),$$1("html").removeClass("with-panel with-panel-transitioning with-panel-"+n+"-"+r),t.onClosed()),!0},t.prototype.onOpen=function(){var e=this;e.opened=!0,e.$el.trigger("panel:open",e),e.emit("local::open panelOpen",e)},t.prototype.onOpened=function(){var e=this;e.app.panel.allowOpen=!0,e.$el.trigger("panel:opened",e),e.emit("local::opened panelOpened",e)},t.prototype.onClose=function(){var e=this;e.opened=!1,e.$el.addClass("panel-closing"),e.$el.trigger("panel:close",e),e.emit("local::close panelClose",e)},t.prototype.onClosed=function(){var e=this;e.app.panel.allowOpen=!0,e.$el.removeClass("panel-closing"),e.$el.trigger("panel:closed",e),e.emit("local::closed panelClosed",e)},t}(Framework7Class),Panel$1={name:"panel",params:{panel:{leftBreakpoint:0,rightBreakpoint:0,swipe:void 0,swipeActiveArea:0,swipeCloseActiveAreaSide:0,swipeCloseOpposite:!0,swipeOnlyClose:!1,swipeNoFollow:!1,swipeThreshold:0,closeByBackdropClick:!0}},static:{Panel:Panel},instance:{panel:{allowOpen:!0}},create:function(){var e=this;Utils.extend(e.panel,{disableSwipe:function(t){var a;void 0===t&&(t="both");var n=[];"string"==typeof t?"both"===t?(a="both",n=[e.panel.left,e.panel.right]):(a=t,n.push(e.panel[a])):n=[t],n.forEach(function(e){e&&Utils.extend(e,{swipeable:!1})})},enableSwipe:function(t){void 0===t&&(t="both");var a,n=[];"string"==typeof t?(a=t,"left"===e.params.panel.swipe&&"right"===a||"right"===e.params.panel.swipe&&"left"===a||"both"===a?(a="both",e.params.panel.swipe=a,n=[e.panel.left,e.panel.right]):(e.params.panel.swipe=a,n.push(e.panel[a]))):t&&n.push(t),n.length&&n.forEach(function(e){e&&(e.swipeInitialized?Utils.extend(e,{swipeable:!0}):e.initSwipePanel())})},create:function(t){return new Panel(e,t)},open:function(t,a){var n=t;if(!n){if($$1(".panel").length>1)return!1;n=$$1(".panel").hasClass("panel-left")?"left":"right"}if(!n)return!1;if(e.panel[n])return e.panel[n].open(a);var r=$$1(".panel-"+n);return r.length>0&&e.panel.create({el:r}).open(a)},close:function(t,a){var n,r;return r?n=$$1(".panel-"+(r=t)):r=(n=$$1(".panel.panel-active")).hasClass("panel-left")?"left":"right",!!r&&(e.panel[r]?e.panel[r].close(a):n.length>0&&e.panel.create({el:n}).close(a))},get:function(t){var a=t;if(!a){if($$1(".panel").length>1)return;a=$$1(".panel").hasClass("panel-left")?"left":"right"}if(a){if(e.panel[a])return e.panel[a];var n=$$1(".panel-"+a);return n.length>0?e.panel.create({el:n}):void 0}}})},on:{init:function(){var e=this;$$1(".panel").each(function(t,a){var n=$$1(a).hasClass("panel-left")?"left":"right";e.panel[n]=e.panel.create({el:a,side:n})})}},clicks:{".panel-open":function(e,t){void 0===t&&(t={});var a="left";("right"===t.panel||1===$$1(".panel").length&&$$1(".panel").hasClass("panel-right"))&&(a="right"),this.panel.open(a,t.animate)},".panel-close":function(e,t){void 0===t&&(t={});var a=t.panel;this.panel.close(a,t.animate)},".panel-backdrop":function(){var e=$$1(".panel-active"),t=e[0]&&e[0].f7Panel;e.trigger("panel:backdrop-click"),t&&t.emit("backdropClick",t),this.emit("panelBackdropClick",t||e[0]),this.params.panel.closeByBackdropClick&&this.panel.close()}}},Card={name:"card"},Chip={name:"chip"},FormData$1={store:function(e,t){var a=e,n=$$1(e);n.length&&n.is("form")&&n.attr("id")&&(a=n.attr("id")),this.form.data["form-"+a]=t;try{win.localStorage["f7form-"+a]=JSON.stringify(t)}catch(e){throw e}},get:function(e){var t=e,a=$$1(e);a.length&&a.is("form")&&a.attr("id")&&(t=a.attr("id"));try{if(win.localStorage["f7form-"+t])return JSON.parse(win.localStorage["f7form-"+t])}catch(e){throw e}if(this.form.data["form-"+t])return this.form.data["form-"+t]},remove:function(e){var t=e,a=$$1(e);a.length&&a.is("form")&&a.attr("id")&&(t=a.attr("id")),this.form.data["form-"+t]&&(this.form.data["form-"+t]="",delete this.form.data["form-"+t]);try{win.localStorage["f7form-"+t]&&(win.localStorage["f7form-"+t]="",win.localStorage.removeItem("f7form-"+t))}catch(e){throw e}}},FormStorage={init:function(e){var t=this,a=$$1(e),n=a.attr("id");if(n){var r=t.form.getFormData(n);r&&t.form.fillFromData(a,r),a.on("change submit",function(){var e=t.form.convertToData(a);e&&(t.form.storeFormData(n,e),a.trigger("form:storedata",e),t.emit("formStoreData",a[0],e))})}},destroy:function(e){$$1(e).off("change submit")}};function formToData(e){var t=$$1(e).eq(0);if(0!==t.length){var a={},n=["submit","image","button","file"],r=[];return t.find("input, select, textarea").each(function(e,i){var o=$$1(i);if(!o.hasClass("ignore-store-data")&&!o.hasClass("no-store-data")){var s=o.attr("name"),l=o.attr("type"),p=i.nodeName.toLowerCase();if(!(n.indexOf(l)>=0)&&!(r.indexOf(s)>=0)&&s)if("select"===p&&o.prop("multiple"))r.push(s),a[s]=[],t.find('select[name="'+s+'"] option').each(function(e,t){t.selected&&a[s].push(t.value)});else switch(l){case"checkbox":r.push(s),a[s]=[],t.find('input[name="'+s+'"]').each(function(e,t){t.checked&&a[s].push(t.value)});break;case"radio":r.push(s),t.find('input[name="'+s+'"]').each(function(e,t){t.checked&&(a[s]=t.value)});break;default:a[s]=o.val()}}}),t.trigger("form:todata",a),this.emit("formToData",t[0],a),a}}function formFromData(e,t){var a=$$1(e).eq(0);if(a.length){var n=t,r=a.attr("id");if(!n&&r&&(n=this.form.getFormData(r)),n){var i=["submit","image","button","file"],o=[];a.find("input, select, textarea").each(function(e,t){var r=$$1(t);if(!r.hasClass("ignore-store-data")&&!r.hasClass("no-store-data")){var s=r.attr("name"),l=r.attr("type"),p=t.nodeName.toLowerCase();if(void 0!==n[s]&&null!==n[s]&&!(i.indexOf(l)>=0)&&!(o.indexOf(s)>=0)&&s){if("select"===p&&r.prop("multiple"))o.push(s),a.find('select[name="'+s+'"] option').each(function(e,t){var a=t;n[s].indexOf(t.value)>=0?a.selected=!0:a.selected=!1});else switch(l){case"checkbox":o.push(s),a.find('input[name="'+s+'"]').each(function(e,t){var a=t;n[s].indexOf(t.value)>=0?a.checked=!0:a.checked=!1});break;case"radio":o.push(s),a.find('input[name="'+s+'"]').each(function(e,t){var a=t;n[s]===t.value?a.checked=!0:a.checked=!1});break;default:r.val(n[s])}"select"!==p&&"input"!==p&&"textarea"!==p||r.trigger("change","fromdata")}}}),a.trigger("form:fromdata",n),this.emit("formFromData",a[0],n)}}}function initAjaxForm(){var e=this;$$1(doc).on("submit change","form.form-ajax-submit, form.form-ajax-submit-onchange",function(t,a){var n=$$1(this);if(("change"!==t.type||n.hasClass("form-ajax-submit-onchange"))&&("submit"===t.type&&t.preventDefault(),"change"!==t.type||"fromdata"!==a)){var r=(n.attr("method")||"GET").toUpperCase(),i=n.prop("enctype")||n.attr("enctype"),o=n.attr("action");if(o){var s;s="POST"===r?"application/x-www-form-urlencoded"===i?e.form.convertToData(n[0]):new win.FormData(n[0]):Utils.serializeObject(e.form.convertToData(n[0]));var l=e.request({method:r,url:o,contentType:i,data:s,beforeSend:function(){n.trigger("formajax:beforesend",s,l),e.emit("formAjaxBeforeSend",n[0],s,l)},error:function(){n.trigger("formajax:error",s,l),e.emit("formAjaxError",n[0],s,l)},complete:function(){n.trigger("formajax:complete",s,l),e.emit("formAjaxComplete",n[0],s,l)},success:function(){n.trigger("formajax:success",s,l),e.emit("formAjaxSuccess",n[0],s,l)}})}}})}var Form={name:"form",create:function(){Utils.extend(this,{form:{data:{},storeFormData:FormData$1.store.bind(this),getFormData:FormData$1.get.bind(this),removeFormData:FormData$1.remove.bind(this),convertToData:formToData.bind(this),fillFromData:formFromData.bind(this),storage:{init:FormStorage.init.bind(this),destroy:FormStorage.destroy.bind(this)}}})},on:{init:function(){initAjaxForm.call(this)},tabBeforeRemove:function(e){var t=this;$$1(e).find(".form-store-data").each(function(e,a){t.form.storage.destroy(a)})},tabMounted:function(e){var t=this;$$1(e).find(".form-store-data").each(function(e,a){t.form.storage.init(a)})},pageBeforeRemove:function(e){var t=this;e.$el.find(".form-store-data").each(function(e,a){t.form.storage.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".form-store-data").each(function(e,a){t.form.storage.init(a)})}}},Input={ignoreTypes:["checkbox","button","submit","range","radio","image"],createTextareaResizableShadow:function(){var e=$$1(doc.createElement("textarea"));e.addClass("textarea-resizable-shadow"),e.prop({disabled:!0,readonly:!0}),Input.textareaResizableShadow=e},textareaResizableShadow:void 0,resizeTextarea:function(e){var t=$$1(e);Input.textareaResizableShadow||Input.createTextareaResizableShadow();var a=Input.textareaResizableShadow;if(t.length&&t.hasClass("resizable")){0===Input.textareaResizableShadow.parents().length&&this.root.append(a);var n=win.getComputedStyle(t[0]);"padding margin width font-size font-family font-style font-weight line-height font-variant text-transform letter-spacing border box-sizing display".split(" ").forEach(function(e){var t=n[e];"font-size line-height letter-spacing width".split(" ").indexOf(e)>=0&&(t=t.replace(",",".")),a.css(e,t)});var r=t[0].clientHeight;a.val("");var i=a[0].scrollHeight;a.val(t.val()),a.css("height",0);var o=a[0].scrollHeight;r!==o&&(o>i?(t.css("height",o+"px"),t.trigger("textarea:resize",{initialHeight:i,currentHeight:r,scrollHeight:o})):o<r&&(t.css("height",""),t.trigger("textarea:resize",{initialHeight:i,currentHeight:r,scrollHeight:o})))}},validate:function(e){var t=$$1(e);if(t.length){var a=t.parents(".item-input"),n=t.parents(".input"),r=t[0].validity,i=t.dataset().errorMessage||t[0].validationMessage||"";if(r)if(r.valid)a.removeClass("item-input-invalid item-input-with-error-message"),n.removeClass("input-invalid input-with-error-message"),t.removeClass("input-invalid");else{var o=t.nextAll(".item-input-error-message, .input-error-message");i&&(0===o.length&&(o=$$1('<div class="'+(n.length?"input-error-message":"item-input-error-message")+'"></div>')).insertAfter(t),o.text(i)),o.length>0&&(a.addClass("item-input-with-error-message"),n.addClass("input-with-eror-message")),a.addClass("item-input-invalid"),n.addClass("input-invalid"),t.addClass("input-invalid")}}},validateInputs:function(e){var t=this;$$1(e).find("input, textarea, select").each(function(e,a){t.input.validate(a)})},focus:function(e){var t=$$1(e),a=t.attr("type");Input.ignoreTypes.indexOf(a)>=0||(t.parents(".item-input").addClass("item-input-focused"),t.parents(".input").addClass("input-focused"),t.addClass("input-focused"))},blur:function(e){var t=$$1(e);t.parents(".item-input").removeClass("item-input-focused"),t.parents(".input").removeClass("input-focused"),t.removeClass("input-focused")},checkEmptyState:function(e){var t=$$1(e),a=t.val(),n=t.parents(".item-input"),r=t.parents(".input");a&&"string"==typeof a&&""!==a.trim()||Array.isArray(a)&&a.length>0?(n.addClass("item-input-with-value"),r.addClass("input-with-value"),t.addClass("input-with-value"),t.trigger("input:notempty")):(n.removeClass("item-input-with-value"),r.removeClass("input-with-value"),t.removeClass("input-with-value"),t.trigger("input:empty"))},scrollIntoView:function(e,t,a,n){void 0===t&&(t=0);var r=$$1(e),i=r.parents(".page-content, .panel").eq(0);if(!i.length)return!1;var o=i[0].offsetHeight,s=i[0].scrollTop,l=parseInt(i.css("padding-top"),10),p=parseInt(i.css("padding-bottom"),10),c=i.offset().top-s,d=r.offset().top-c,u=d+s-l,h=d+s-o+p+r[0].offsetHeight,f=u+(h-u)/2;return s>u?(i.scrollTop(a?f:u,t),!0):s<h?(i.scrollTop(a?f:h,t),!0):(n&&i.scrollTop(a?f:h,t),!1)},init:function(){var e=this;Input.createTextareaResizableShadow(),$$1(doc).on("click",".input-clear-button",function(){var e=$$1(this).siblings("input, textarea").eq(0),t=e.val();e.val("").trigger("change input").focus().trigger("input:clear",t)}),$$1(doc).on("change input","input, textarea, select",function(){var t=$$1(this),a=t.attr("type"),n=t[0].nodeName.toLowerCase();Input.ignoreTypes.indexOf(a)>=0||(e.input.checkEmptyState(t),(t.dataset().validate||null!==t.attr("validate"))&&e.input.validate(t),"textarea"===n&&t.hasClass("resizable")&&e.input.resizeTextarea(t))},!0),$$1(doc).on("focus","input, textarea, select",function(){var t=this;e.params.input.scrollIntoViewOnFocus&&(Device.android?$$1(win).once("resize",function(){doc&&doc.activeElement===t&&e.input.scrollIntoView(t,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)}):e.input.scrollIntoView(t,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)),e.input.focus(t)},!0),$$1(doc).on("blur","input, textarea, select",function(){var t=$$1(this),a=t[0].nodeName.toLowerCase();e.input.blur(t),(t.dataset().validate||null!==t.attr("validate"))&&e.input.validate(t),"textarea"===a&&t.hasClass("resizable")&&Input.textareaResizableShadow&&Input.textareaResizableShadow.remove()},!0),$$1(doc).on("invalid","input, textarea, select",function(t){var a=$$1(this);(a.dataset().validate||null!==a.attr("validate"))&&(t.preventDefault(),e.input.validate(a))},!0)}},Input$1={name:"input",params:{input:{scrollIntoViewOnFocus:Device.android,scrollIntoViewCentered:!1,scrollIntoViewDuration:0,scrollIntoViewAlways:!1}},create:function(){Utils.extend(this,{input:{scrollIntoView:Input.scrollIntoView.bind(this),focus:Input.focus.bind(this),blur:Input.blur.bind(this),validate:Input.validate.bind(this),validateInputs:Input.validateInputs.bind(this),checkEmptyState:Input.checkEmptyState.bind(this),resizeTextarea:Input.resizeTextarea.bind(this),init:Input.init.bind(this)}})},on:{init:function(){this.input.init()},tabMounted:function(e){var t=this,a=$$1(e);a.find(".item-input, .input").each(function(e,a){$$1(a).find("input, select, textarea").each(function(e,a){var n=$$1(a);Input.ignoreTypes.indexOf(n.attr("type"))>=0||t.input.checkEmptyState(n)})}),a.find("textarea.resizable").each(function(e,a){t.input.resizeTextarea(a)})},pageInit:function(e){var t=this,a=e.$el;a.find(".item-input, .input").each(function(e,a){$$1(a).find("input, select, textarea").each(function(e,a){var n=$$1(a);Input.ignoreTypes.indexOf(n.attr("type"))>=0||t.input.checkEmptyState(n)})}),a.find("textarea.resizable").each(function(e,a){t.input.resizeTextarea(a)})}}},Checkbox={name:"checkbox"},Radio={name:"radio"},Toggle=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this,r={};n.useModulesParams(r),n.params=Utils.extend(r,a);var i=n.params.el;if(!i)return n;var o=$$1(i);if(0===o.length)return n;var s,l=o.children('input[type="checkbox"]');Utils.extend(n,{app:t,$el:o,el:o[0],$inputEl:l,inputEl:l[0],disabled:o.hasClass("disabled")||l.hasClass("disabled")||l.attr("disabled")||l[0].disabled}),Object.defineProperty(n,"checked",{enumerable:!0,configurable:!0,set:function(e){n&&void 0!==n.$inputEl&&n.checked!==e&&(l[0].checked=e,n.$inputEl.trigger("change"))},get:function(){return l[0].checked}}),o[0].f7Toggle=n;var p,c,d,u,h,f={};function m(e){s||n.disabled||(f.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,f.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,c=0,s=!0,p=void 0,u=Utils.now(),h=n.checked,d=o[0].offsetWidth,Utils.nextTick(function(){s&&o.addClass("toggle-active-state")}))}function v(e){if(s&&!n.disabled){var a,r="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,o=t.rtl?-1:1;if(void 0===p&&(p=!!(p||Math.abs(i-f.y)>Math.abs(r-f.x))),p)s=!1;else e.preventDefault(),(c=r-f.x)*o<0&&Math.abs(c)>d/3&&h&&(a=!0),c*o>0&&Math.abs(c)>d/3&&!h&&(a=!0),a&&(f.x=r,n.checked=!h,h=!h)}}function g(){if(!s||n.disabled)return p&&o.removeClass("toggle-active-state"),void(s=!1);var e,a=t.rtl?-1:1;s=!1,o.removeClass("toggle-active-state"),Utils.now()-u<300&&(c*a<0&&h&&(e=!0),c*a>0&&!h&&(e=!0),e&&(n.checked=!h))}function b(){n.$el.trigger("toggle:change",n),n.emit("local::change toggleChange",n)}n.attachEvents=function(){if(Support.touch){var e=!!Support.passiveListener&&{passive:!0};o.on(t.touchEvents.start,m,e),t.on("touchmove",v),t.on("touchend:passive",g),n.$inputEl.on("change",b)}},n.detachEvents=function(){if(Support.touch){var e=!!Support.passiveListener&&{passive:!0};o.off(t.touchEvents.start,m,e),t.off("touchmove",v),t.off("touchend:passive",g),n.$inputEl.off("change",b)}},n.useModules(),n.init()}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.toggle=function(){this.checked=!this.checked},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.$el.trigger("toggle:beforedestroy",e),e.emit("local::beforeDestroy toggleBeforeDestroy",e),delete e.$el[0].f7Toggle,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Toggle$1={name:"toggle",create:function(){this.toggle=ConstructorMethods({defaultSelector:".toggle",constructor:Toggle,app:this,domProp:"f7Toggle"})},static:{Toggle:Toggle},on:{tabMounted:function(e){var t=this;$$1(e).find(".toggle-init").each(function(e,a){return t.toggle.create({el:a})})},tabBeforeRemove:function(e){$$1(e).find(".toggle-init").each(function(e,t){t.f7Toggle&&t.f7Toggle.destroy()})},pageInit:function(e){var t=this;e.$el.find(".toggle-init").each(function(e,a){return t.toggle.create({el:a})})},pageBeforeRemove:function(e){e.$el.find(".toggle-init").each(function(e,t){t.f7Toggle&&t.f7Toggle.destroy()})}}},Range=function(e){function t(t,a){e.call(this,a,[t]);var n=this,r={el:null,inputEl:null,dual:!1,step:1,label:!1,min:0,max:100,value:0,draggableBar:!0};n.useModulesParams(r),n.params=Utils.extend(r,a);var i=n.params.el;if(!i)return n;var o=$$1(i);if(0===o.length)return n;var s,l=o.dataset();"step min max value".split(" ").forEach(function(e){void 0===a[e]&&void 0!==l[e]&&(n.params[e]=parseFloat(l[e]))}),"dual label".split(" ").forEach(function(e){void 0===a[e]&&void 0!==l[e]&&(n.params[e]=l[e])}),n.params.value||(void 0!==l.value&&(n.params.value=l.value),void 0!==l.valueLeft&&void 0!==l.valueRight&&(n.params.value=[parseFloat(l.valueLeft),parseFloat(l.valueRight)])),n.params.dual||(n.params.inputEl?s=$$1(n.params.inputEl):o.find('input[type="range"]').length&&(s=o.find('input[type="range"]').eq(0)));var p=n.params,c=p.dual,d=p.step,u=p.label,h=p.min,f=p.max,m=p.value;Utils.extend(n,{$el:o,el:o[0],$inputEl:s,inputEl:s?s[0]:void 0,dual:c,step:d,label:u,min:h,max:f,value:m,previousValue:m}),s&&("step min max".split(" ").forEach(function(e){!a[e]&&s.attr(e)&&(n.params[e]=parseFloat(s.attr(e)),n[e]=parseFloat(s.attr(e)))}),void 0!==s.val()&&(n.params.value=parseFloat(s.val()),n.value=parseFloat(s.val()))),n.dual&&o.addClass("range-slider-dual"),n.label&&o.addClass("range-slider-label");var v=$$1('<div class="range-bar"></div>'),g=$$1('<div class="range-bar-active"></div>');v.append(g);var b,y='\n      <div class="range-knob-wrap">\n        <div class="range-knob"></div>\n        '+(n.label?'<div class="range-knob-label"></div>':"")+"\n      </div>\n    ",w=[$$1(y)],$=[];n.dual&&w.push($$1(y)),o.append(v),w.forEach(function(e){o.append(e)}),n.label&&($.push(w[0].find(".range-knob-label")),n.dual&&$.push(w[1].find(".range-knob-label"))),Utils.extend(n,{app:t,knobs:w,labels:$,$barEl:v,$barActiveEl:g}),o[0].f7Range=n;var C,x,E,S,k,T={};function M(){k=!0}function P(e){if(!b&&(n.params.draggableBar||0!==$$1(e.target).closest(".range-knob").length)){var t;k=!1,T.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,T.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,b=!0,C=void 0,x=o.offset().left;var a=(t=n.app.rtl?(x+n.rangeWidth-T.x)/n.rangeWidth:(T.x-x)/n.rangeWidth)*(n.max-n.min)+n.min;n.dual?Math.abs(n.value[0]-a)<Math.abs(n.value[1]-a)?(S=0,E=n.knobs[0],a=[a,n.value[1]]):(S=1,E=n.knobs[1],a=[n.value[0],a]):(E=n.knobs[0],a=t*(n.max-n.min)+n.min),Utils.nextTick(function(){b&&E.addClass("range-knob-active-state")},70),n.on("change",M),n.setValue(a,!0)}}function O(e){if(b){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===C&&(C=!!(C||Math.abs(a-T.y)>Math.abs(t-T.x))),C)b=!1;else{e.preventDefault();var r,i,o=(n.app.rtl?(x+n.rangeWidth-t)/n.rangeWidth:(t-x)/n.rangeWidth)*(n.max-n.min)+n.min;if(n.dual)0===S?(r=o)>(i=n.value[1])&&(i=r):(i=o)<(r=n.value[0])&&(r=i),o=[r,i];n.setValue(o,!0)}}}function D(){if(!b)return C&&E.removeClass("range-knob-active-state"),void(b=!1);n.off("change",M),b=!1,E.removeClass("range-knob-active-state"),k&&n.$inputEl&&!n.dual&&n.$inputEl.trigger("change"),k=!1,void 0!==n.previousValue&&(n.dual&&(n.previousValue[0]!==n.value[0]||n.previousValue[1]!==n.value[1])||!n.dual&&n.previousValue!==n.value)&&(n.$el.trigger("range:changed",n,n.value),n.emit("local::changed rangeChanged",n,n.value))}function I(){n.calcSize(),n.layout()}return n.attachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};n.$el.on(t.touchEvents.start,P,e),t.on("touchmove",O),t.on("touchend:passive",D),t.on("tabShow",I),t.on("resize",I),n.$el.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").on("modal:open",I),n.$el.parents(".panel").on("panel:open",I)},n.detachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};n.$el.off(t.touchEvents.start,P,e),t.off("touchmove",O),t.off("touchend:passive",D),t.off("tabShow",I),t.off("resize",I),n.$el.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").off("modal:open",I),n.$el.parents(".panel").off("panel:open",I)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.calcSize=function(){var e=this.$el.outerWidth();0!==e&&(this.rangeWidth=e,this.knobWidth=this.knobs[0].outerWidth())},t.prototype.layout=function(){var e,t=this,a=t.app,n=t.knobWidth,r=t.rangeWidth,i=t.min,o=t.max,s=t.knobs,l=t.$barActiveEl,p=t.value,c=t.label,d=t.labels,u=a.rtl?"right":"left";if(t.dual){var h=[(p[0]-i)/(o-i),(p[1]-i)/(o-i)];l.css(((e={})[u]=100*h[0]+"%",e.width=100*(h[1]-h[0])+"%",e)),s.forEach(function(e,t){var a=r*h[t],i=r*h[t]-n/2;i<0&&(a=n/2),i+n>r&&(a=r-n/2),e.css(u,a+"px"),c&&d[t].text(p[t])})}else{var f=(p-i)/(o-i);l.css("width",100*f+"%");var m=r*f,v=r*f-n/2;v<0&&(m=n/2),v+n>r&&(m=r-n/2),s[0].css(u,m+"px"),c&&d[0].text(p)}t.dual&&p.indexOf(i)>=0||!t.dual&&p===i?t.$el.addClass("range-slider-min"):t.$el.removeClass("range-slider-min"),t.dual&&p.indexOf(o)>=0||!t.dual&&p===o?t.$el.addClass("range-slider-max"):t.$el.removeClass("range-slider-max")},t.prototype.setValue=function(e,t){var a,n,r=this,i=r.step,o=r.min,s=r.max;if(r.dual){n=[r.value[0],r.value[1]];var l=e;if(Array.isArray(l)||(l=[e,e]),e[0]>e[1]&&(l=[l[0],l[0]]),(l=l.map(function(e){return Math.max(Math.min(Math.round(e/i)*i,s),o)}))[0]===r.value[0]&&l[1]===r.value[1])return r;l.forEach(function(e,t){r.value[t]=e}),a=n[0]!==l[0]||n[1]!==l[1],r.layout()}else{n=r.value;var p=Math.max(Math.min(Math.round(e/i)*i,s),o);r.value=p,r.layout(),a=n!==p}return a&&(r.previousValue=n),a?(r.$el.trigger("range:change",r,r.value),r.$inputEl&&!r.dual&&(r.$inputEl.val(r.value),t?r.$inputEl.trigger("input"):r.$inputEl.trigger("input change")),t||(r.$el.trigger("range:changed",r,r.value),r.emit("local::changed rangeChanged",r,r.value)),r.emit("local::change rangeChange",r,r.value),r):r},t.prototype.getValue=function(){return this.value},t.prototype.init=function(){return this.calcSize(),this.layout(),this.attachEvents(),this},t.prototype.destroy=function(){var e=this;e.$el.trigger("range:beforedestroy",e),e.emit("local::beforeDestroy rangeBeforeDestroy",e),delete e.$el[0].f7Range,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Range$1={name:"range",create:function(){var e=this;e.range=Utils.extend(ConstructorMethods({defaultSelector:".range-slider",constructor:Range,app:e,domProp:"f7Range"}),{getValue:function(t){void 0===t&&(t=".range-slider");var a=e.range.get(t);if(a)return a.getValue()},setValue:function(t,a){void 0===t&&(t=".range-slider");var n=e.range.get(t);if(n)return n.setValue(a)}})},static:{Range:Range},on:{tabMounted:function(e){var t=this;$$1(e).find(".range-slider-init").each(function(e,a){return new Range(t,{el:a})})},tabBeforeRemove:function(e){$$1(e).find(".range-slider-init").each(function(e,t){t.f7Range&&t.f7Range.destroy()})},pageInit:function(e){var t=this;e.$el.find(".range-slider-init").each(function(e,a){return new Range(t,{el:a})})},pageBeforeRemove:function(e){e.$el.find(".range-slider-init").each(function(e,t){t.f7Range&&t.f7Range.destroy()})}}},Stepper=function(e){function t(t,a){e.call(this,a,[t]);var n=this,r={el:null,inputEl:null,valueEl:null,value:0,formatValue:null,step:1,min:0,max:100,watchInput:!0,autorepeat:!1,autorepeatDynamic:!1,wraps:!1};n.useModulesParams(r),n.params=Utils.extend(r,a),n.params.value<n.params.min&&(n.params.value=n.params.min),n.params.value>n.params.max&&(n.params.value=n.params.max);var i=n.params.el;if(!i)return n;var o,s,l=$$1(i);if(0===l.length)return n;if(n.params.inputEl?o=$$1(n.params.inputEl):l.find(".stepper-input-wrap").find("input, textarea").length&&(o=l.find(".stepper-input-wrap").find("input, textarea").eq(0)),o&&o.length){"step min max".split(" ").forEach(function(e){!a[e]&&o.attr(e)&&(n.params[e]=parseFloat(o.attr(e)))});var p=parseFloat(o.val());void 0!==a.value||Number.isNaN(p)||!p&&0!==p||(n.params.value=p)}n.params.valueEl?s=$$1(n.params.valueEl):l.find(".stepper-value").length&&(s=l.find(".stepper-value").eq(0));var c=l.find(".stepper-button-plus"),d=l.find(".stepper-button-minus"),u=n.params,h=u.step,f=u.min,m=u.max,v=u.value;Utils.extend(n,{app:t,$el:l,el:l[0],$buttonPlusEl:c,buttonPlusEl:c[0],$buttonMinusEl:d,buttonMinusEl:d[0],$inputEl:o,inputEl:o?o[0]:void 0,$valueEl:s,valueEl:s?s[0]:void 0,step:h,min:f,max:m,value:v}),l[0].f7Stepper=n;var g,b,y,w,$,C={},x=null,E=!1;function S(e){g||($$1(e.target).closest(c).length?x="increment":$$1(e.target).closest(d).length&&(x="decrement"),x&&(C.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,C.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,g=!0,b=void 0,function e(t,a,n,r,i,o){clearTimeout($),$=setTimeout(function(){1===t&&(y=!0,E=!0),clearInterval(w),o(),w=setInterval(function(){o()},i),t<a&&e(t+1,a,n,r,i/2,o)},1===t?n:r)}(1,n.params.autorepeatDynamic?4:1,500,1e3,300,function(){n[x]()})))}function k(e){if(g){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;void 0!==b||E||(b=!!(b||Math.abs(a-C.y)>Math.abs(t-C.x)));var n=Math.pow(Math.pow(t-C.x,2)+Math.pow(a-C.y,2),.5);(b||n>20)&&(g=!1,clearTimeout($),clearInterval(w))}}function T(){clearTimeout($),clearInterval(w),x=null,E=!1,g=!1}function M(){y?y=!1:n.decrement()}function P(){y?y=!1:n.increment()}function O(e){e.detail&&e.detail.sentByF7Stepper||n.setValue(e.target.value,!0)}return n.attachEvents=function(){d.on("click",M),c.on("click",P),n.params.watchInput&&o&&o.length&&o.on("input",O),n.params.autorepeat&&(t.on("touchstart:passive",S),t.on("touchmove:active",k),t.on("touchend:passive",T))},n.detachEvents=function(){d.off("click",M),c.off("click",P),n.params.watchInput&&o&&o.length&&o.off("input",O)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.minus=function(){return this.decrement()},t.prototype.plus=function(){return this.increment()},t.prototype.decrement=function(){return this.setValue(this.value-this.step)},t.prototype.increment=function(){return this.setValue(this.value+this.step)},t.prototype.setValue=function(e,t){var a=this,n=a.step,r=a.min,i=a.max,o=a.value,s=Math.round(e/n)*n;if(a.params.wraps?(s>i&&(s=r),s<r&&(s=i)):s=Math.max(Math.min(s,i),r),Number.isNaN(s)&&(s=o),a.value=s,!(o!==s)&&!t)return a;a.$el.trigger("stepper:change",a,a.value);var l=a.formatValue(a.value);return a.$inputEl&&a.$inputEl.length&&(a.$inputEl.val(l),a.$inputEl.trigger("input change",{sentByF7Stepper:!0})),a.$valueEl&&a.$valueEl.length&&a.$valueEl.html(l),a.emit("local::change stepperChange",a,a.value),a},t.prototype.getValue=function(){return this.value},t.prototype.formatValue=function(e){return this.params.formatValue?this.params.formatValue.call(this,e):e},t.prototype.init=function(){if(this.attachEvents(),this.$valueEl&&this.$valueEl.length){var e=this.formatValue(this.value);this.$valueEl.html(e)}return this},t.prototype.destroy=function(){var e=this;e.$el.trigger("stepper:beforedestroy",e),e.emit("local::beforeDestroy stepperBeforeDestroy",e),delete e.$el[0].f7Stepper,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Stepper$1={name:"stepper",create:function(){var e=this;e.stepper=Utils.extend(ConstructorMethods({defaultSelector:".stepper",constructor:Stepper,app:e,domProp:"f7Stepper"}),{getValue:function(t){void 0===t&&(t=".stepper");var a=e.stepper.get(t);if(a)return a.getValue()},setValue:function(t,a){void 0===t&&(t=".stepper");var n=e.stepper.get(t);if(n)return n.setValue(a)}})},static:{Stepper:Stepper},on:{tabMounted:function(e){var t=this;$$1(e).find(".stepper-init").each(function(e,a){var n=$$1(a).dataset();new Stepper(t,Utils.extend({el:a},n||{}))})},tabBeforeRemove:function(e){$$1(e).find(".stepper-init").each(function(e,t){t.f7Stepper&&t.f7Stepper.destroy()})},pageInit:function(e){var t=this;e.$el.find(".stepper-init").each(function(e,a){var n=$$1(a).dataset();new Stepper(t,Utils.extend({el:a},n||{}))})},pageBeforeRemove:function(e){e.$el.find(".stepper-init").each(function(e,t){t.f7Stepper&&t.f7Stepper.destroy()})}}},SmartSelect=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this;n.app=t;var r=Utils.extend({on:{}},t.params.smartSelect),i=$$1(a.el).eq(0);if(0===i.length)return n;var o=i.find("select").eq(0);if(0===o.length)return n;var s=$$1(a.valueEl);0===s.length&&(s=i.find(".item-after")),0===s.length&&(s=$$1('<div class="item-after"></div>')).insertAfter(i.find(".item-title")),n.useModulesParams(r);var l=a.view;if(l||(l=i.parents(".view").length&&i.parents(".view")[0].f7View),!l)throw Error("Smart Select requires initialized View");var p=a.url;p||(p=i.attr("href")&&"#"!==i.attr("href")?i.attr("href"):o.attr("name").toLowerCase()+"-select/"),p||(p=n.params.url);var c=o[0].multiple,d=c?"checkbox":"radio",u=Utils.now();function h(){n.open()}function f(){n.setValue()}function m(){var e,t,a,r=this.value,i=[];if("checkbox"===this.type){for(var o=0;o<n.selectEl.options.length;o+=1)(e=n.selectEl.options[o]).value===r&&(e.selected=this.checked),e.selected&&(t=(a=e.dataset?e.dataset.displayAs:$$1(e).data("display-value-as"))&&void 0!==a?a:e.textContent,i.push(t.trim()));n.maxLength&&n.checkMaxLength()}else i=[t=(a=(e=n.$selectEl.find('option[value="'+r+'"]')[0]).dataset?e.dataset.displayAs:$$1(e).data("display-as"))&&void 0!==a?a:e.textContent],n.selectEl.value=r;n.$selectEl.trigger("change"),n.$valueEl.text(i.join(", ")),n.params.closeOnSelect&&"radio"===n.inputType&&n.close()}return Utils.extend(n,{params:Utils.extend(r,a),$el:i,el:i[0],$selectEl:o,selectEl:o[0],$valueEl:s,valueEl:s[0],url:p,multiple:c,inputType:d,id:u,view:l,inputName:d+"-"+u,selectName:o.attr("name"),maxLength:o.attr("maxlength")||a.maxLength}),i[0].f7SmartSelect=n,n.attachEvents=function(){i.on("click",h),i.on("change","select",f)},n.detachEvents=function(){i.off("click",h),i.off("change","select",f)},n.attachInputsEvents=function(){n.$containerEl.on("change",'input[type="checkbox"], input[type="radio"]',m)},n.detachInputsEvents=function(){n.$containerEl.off("change",'input[type="checkbox"], input[type="radio"]',m)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.checkMaxLength=function(){var e=this.$containerEl;this.selectEl.selectedOptions.length>=this.maxLength?e.find('input[type="checkbox"]').each(function(e,t){t.checked?$$1(t).parents("li").removeClass("disabled"):$$1(t).parents("li").addClass("disabled")}):e.find(".disabled").removeClass("disabled")},t.prototype.setValue=function(e){var t=[];void 0!==e?t=Array.isArray(e)?e:[e]:this.$selectEl.find("option").each(function(e,a){var n=$$1(a);if(a.selected){var r=a.dataset?a.dataset.displayAs:n.data("display-value-as");r&&void 0!==r?t.push(r):t.push(a.textContent.trim())}}),this.$valueEl.text(t.join(", "))},t.prototype.getItemsData=function(){var e,t=this,a=[];return t.$selectEl.find("option").each(function(n,r){var i=$$1(r),o=i.dataset(),s=o.optionImage||t.params.optionImage,l=o.optionIcon||t.params.optionIcon,p=s||l,c=o.optionColor,d=o.optionClass||"";i[0].disabled&&(d+=" disabled");var u=i.parent("optgroup")[0],h=u&&u.label,f=!1;u&&u!==e&&(f=!0,e=u,a.push({groupLabel:h,isLabel:f})),a.push({value:i[0].value,text:i[0].textContent.trim(),selected:i[0].selected,groupEl:u,groupLabel:h,image:s,icon:l,color:c,className:d,disabled:i[0].disabled,id:t.id,hasMedia:p,checkbox:"checkbox"===t.inputType,radio:"radio"===t.inputType,inputName:t.inputName,inputType:t.inputType})}),t.items=a,a},t.prototype.renderSearchbar=function(){return this.params.renderSearchbar?this.params.renderSearchbar.call(this):'\n      <form class="searchbar">\n        <div class="searchbar-inner">\n          <div class="searchbar-input-wrap">\n            <input type="search" placeholder="'+this.params.searchbarPlaceholder+'"/>\n            <i class="searchbar-icon"></i>\n            <span class="input-clear-button"></span>\n          </div>\n          <span class="searchbar-disable-button">'+this.params.searchbarDisableText+"</span>\n        </div>\n      </form>\n    "},t.prototype.renderItem=function(e,t){return this.params.renderItem?this.params.renderItem.call(this,e,t):e.isLabel?'<li class="item-divider">'+e.groupLabel+"</li>":'\n        <li class="'+(e.className||"")+'">\n          <label class="item-'+e.inputType+' item-content">\n            <input type="'+e.inputType+'" name="'+e.inputName+'" value="'+e.value+'" '+(e.selected?"checked":"")+'/>\n            <i class="icon icon-'+e.inputType+'"></i>\n            '+(e.hasMedia?'\n              <div class="item-media">\n                '+(e.icon?'<i class="icon '+e.icon+'"></i>':"")+"\n                "+(e.image?'<img src="'+e.image+'">':"")+"\n              </div>\n            ":"")+'\n            <div class="item-inner">\n              <div class="item-title'+(e.color?" color-"+e.color:"")+'">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      "},t.prototype.renderItems=function(){var e=this;return e.params.renderItems?e.params.renderItems.call(e,e.items):"\n      "+e.items.map(function(t,a){return""+e.renderItem(t,a)}).join("")+"\n    "},t.prototype.renderPage=function(){var e=this;if(e.params.renderPage)return e.params.renderPage.call(e,e.items);var t=e.params.pageTitle;return void 0===t&&(t=e.$el.find(".item-title").text().trim()),'\n      <div class="page smart-select-page" data-name="smart-select-page" data-select-name="'+e.selectName+'">\n        <div class="navbar '+(e.params.navbarColorTheme?"color-theme-"+e.params.navbarColorTheme:"")+'">\n          <div class="navbar-inner sliding '+(e.params.navbarColorTheme?"color-theme-"+e.params.navbarColorTheme:"")+'">\n            <div class="left">\n              <a href="#" class="link back">\n                <i class="icon icon-back"></i>\n                <span class="ios-only">'+e.params.pageBackLinkText+"</span>\n              </a>\n            </div>\n            "+(t?'<div class="title">'+t+"</div>":"")+"\n            "+(e.params.searchbar?'<div class="subnavbar">'+e.renderSearchbar()+"</div>":"")+"\n          </div>\n        </div>\n        "+(e.params.searchbar?'<div class="searchbar-backdrop"></div>':"")+'\n        <div class="page-content">\n          <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+" "+(e.params.formColorTheme?"color-theme-"+e.params.formColorTheme:"")+'">\n            <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderPopup=function(){var e=this;if(e.params.renderPopup)return e.params.renderPopup.call(e,e.items);var t=e.params.pageTitle;return void 0===t&&(t=e.$el.find(".item-title").text().trim()),'\n      <div class="popup smart-select-popup" data-select-name="'+e.selectName+'">\n        <div class="view">\n          <div class="page smart-select-page '+(e.params.searchbar?"page-with-subnavbar":"")+'" data-name="smart-select-page">\n            <div class="navbar'+(e.params.navbarColorTheme?"theme-"+e.params.navbarColorTheme:"")+'">\n              <div class="navbar-inner sliding">\n                <div class="left">\n                  <a href="#" class="link popup-close">\n                    <i class="icon icon-back"></i>\n                    <span class="ios-only">'+e.params.popupCloseLinkText+"</span>\n                  </a>\n                </div>\n                "+(t?'<div class="title">'+t+"</div>":"")+"\n                "+(e.params.searchbar?'<div class="subnavbar">'+e.renderSearchbar()+"</div>":"")+"\n              </div>\n            </div>\n            "+(e.params.searchbar?'<div class="searchbar-backdrop"></div>':"")+'\n            <div class="page-content">\n              <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+(e.params.formColorTheme?"theme-"+e.params.formColorTheme:"")+'">\n                <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderSheet=function(){var e=this;return e.params.renderSheet?e.params.renderSheet.call(e,e.items):'\n      <div class="sheet-modal smart-select-sheet" data-select-name="'+e.selectName+'">\n        <div class="toolbar '+(e.params.toolbarColorTheme?"theme-"+e.params.toolbarColorTheme:"")+'">\n          <div class="toolbar-inner">\n            <div class="left"></div>\n            <div class="right">\n              <a class="link sheet-close">'+e.params.sheetCloseLinkText+'</a>\n            </div>\n          </div>\n        </div>\n        <div class="sheet-modal-inner">\n          <div class="page-content">\n            <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+(e.params.formColorTheme?"theme-"+e.params.formColorTheme:"")+'">\n              <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n            </div>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderPopover=function(){var e=this;return e.params.renderPopover?e.params.renderPopover.call(e,e.items):'\n      <div class="popover smart-select-popover" data-select-name="'+e.selectName+'">\n        <div class="popover-inner">\n          <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+(e.params.formColorTheme?"theme-"+e.params.formColorTheme:"")+'">\n            <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.onOpen=function(e,t){var a=this,n=a.app,r=$$1(t);if(a.$containerEl=r,a.openedIn=e,a.opened=!0,a.params.virtualList&&(a.vl=n.virtualList.create({el:r.find(".virtual-list"),items:a.items,renderItem:a.renderItem.bind(a),height:a.params.virtualListHeight,searchByItem:function(e,t){return!!(t.text&&t.text.toLowerCase().indexOf(e.trim().toLowerCase())>=0)}})),a.params.searchbar){var i=r.find(".searchbar");"page"===e&&"ios"===n.theme&&(i=$$1(n.navbar.getElByPage(r)).find(".searchbar")),a.searchbar=n.searchbar.create({el:i,backdropEl:r.find(".searchbar-backdrop"),searchContainer:".smart-select-list-"+a.id,searchIn:".item-title"})}a.maxLength&&a.checkMaxLength(),a.params.closeOnSelect&&a.$containerEl.find('input[type="radio"][name="'+a.inputName+'"]:checked').parents("label").once("click",function(){a.close()}),a.attachInputsEvents(),a.$el.trigger("smartselect:open",a),a.emit("local::open smartSelectOpen",a)},t.prototype.onOpened=function(){this.$el.trigger("smartselect:opened",this),this.emit("local::opened smartSelectOpened",this)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.vl&&e.vl.destroy&&(e.vl.destroy(),e.vl=null,delete e.vl),e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),e.detachInputsEvents(),e.$el.trigger("smartselect:close",e),e.emit("local::close smartSelectClose",e))},t.prototype.onClosed=function(){this.destroyed||(this.opened=!1,this.$containerEl=null,delete this.$containerEl,this.$el.trigger("smartselect:closed",this),this.emit("local::closed smartSelectClosed",this))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;e.getItemsData();var t=e.renderPage(e.items);return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}}}}),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderPopup(e.items),on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.openSheet=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderSheet(e.items),backdrop:!1,scrollToEl:e.$el,closeByOutsideClick:!0,on:{sheetOpen:function(t){e.onOpen("sheet",t.el)},sheetOpened:function(t){e.onOpened("sheet",t.el)},sheetClose:function(t){e.onClose("sheet",t.el)},sheetClosed:function(t){e.onClosed("sheet",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,sheet:t}}):e.modal=e.app.sheet.create(t).open(),e},t.prototype.openPopover=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderPopover(e.items),targetEl:e.$el,on:{popoverOpen:function(t){e.onOpen("popover",t.el)},popoverOpened:function(t){e.onOpened("popover",t.el)},popoverClose:function(t){e.onClose("popover",t.el)},popoverClosed:function(t){e.onClosed("popover",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,popover:t}}):e.modal=e.app.popover.create(t).open(),e},t.prototype.open=function(e){return this.opened?this:(this["open"+(e||this.params.openIn).split("").map(function(e,t){return 0===t?e.toUpperCase():e}).join("")](),this)},t.prototype.close=function(){var e=this;return e.opened?(e.params.routableModals||"page"===e.openedIn?e.view.router.back():(e.modal.once("modalClosed",function(){Utils.nextTick(function(){e.modal.destroy(),delete e.modal})}),e.modal.close()),e):e},t.prototype.init=function(){this.attachEvents(),this.setValue()},t.prototype.destroy=function(){this.emit("local::beforeDestroy smartSelectBeforeDestroy",this),this.$el.trigger("smartselect:beforedestroy",this),this.detachEvents(),delete this.$el[0].f7SmartSelect,Utils.deleteProps(this),this.destroyed=!0},t}(Framework7Class),SmartSelect$1={name:"smartSelect",params:{smartSelect:{el:void 0,valueEl:void 0,openIn:"page",pageTitle:void 0,pageBackLinkText:"Back",popupCloseLinkText:"Close",sheetCloseLinkText:"Done",searchbar:!1,searchbarPlaceholder:"Search",searchbarDisableText:"Cancel",closeOnSelect:!1,virtualList:!1,virtualListHeight:void 0,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!0,url:"select/",renderPage:void 0,renderPopup:void 0,renderSheet:void 0,renderPopover:void 0,renderItems:void 0,renderItem:void 0,renderSearchbar:void 0}},static:{SmartSelect:SmartSelect},create:function(){var e=this;e.smartSelect=Utils.extend(ConstructorMethods({defaultSelector:".smart-select",constructor:SmartSelect,app:e,domProp:"f7SmartSelect"}),{open:function(t){var a=e.smartSelect.get(t);if(a&&a.open)return a.open()},close:function(t){var a=e.smartSelect.get(t);if(a&&a.close)return a.close()}})},on:{tabMounted:function(e){var t=this;$$1(e).find(".smart-select-init").each(function(e,a){t.smartSelect.create(Utils.extend({el:a},$$1(a).dataset()))})},tabBeforeRemove:function(e){$$1(e).find(".smart-select-init").each(function(e,t){t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()})},pageInit:function(e){var t=this;e.$el.find(".smart-select-init").each(function(e,a){t.smartSelect.create(Utils.extend({el:a},$$1(a).dataset()))})},pageBeforeRemove:function(e){e.$el.find(".smart-select-init").each(function(e,t){t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()})}},clicks:{".smart-select":function(e,t){e[0].f7SmartSelect||this.smartSelect.create(Utils.extend({el:e},t)).open()}}},Grid={name:"grid"},Calendar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n,r,i,o=this;if(o.params=Utils.extend({},t.params.calendar,a),o.params.containerEl&&0===(n=$$1(o.params.containerEl)).length)return o;o.params.inputEl&&(r=$$1(o.params.inputEl)),r&&(i=r.parents(".view").length&&r.parents(".view")[0].f7View),i||(i=t.views.main);var s="horizontal"===o.params.direction,l=1;function p(){o.open()}function c(e){e.preventDefault()}function d(e){var t=$$1(e.target);o.isPopover()||o.opened&&(t.closest('[class*="backdrop"]').length||(r&&r.length>0?t[0]!==r[0]&&0===t.closest(".sheet-modal, .calendar-modal").length&&o.close():0===$$1(e.target).closest(".sheet-modal, .calendar-modal").length&&o.close()))}return s&&(l=t.rtl?-1:1),Utils.extend(o,{app:t,$containerEl:n,containerEl:n&&n[0],inline:n&&n.length>0,$inputEl:r,inputEl:r&&r[0],initialized:!1,opened:!1,url:o.params.url,isHorizontal:s,inverter:l,view:i,animating:!1}),Utils.extend(o,{attachInputEvents:function(){o.$inputEl.on("click",p),o.params.inputReadOnly&&o.$inputEl.on("focus mousedown",c)},detachInputEvents:function(){o.$inputEl.off("click",p),o.params.inputReadOnly&&o.$inputEl.off("focus mousedown",c)},attachHtmlEvents:function(){t.on("click",d)},detachHtmlEvents:function(){t.off("click",d)}}),o.attachCalendarEvents=function(){var e,a,n,r,i,s,l,p,c,d,u,h,f,m=!0,v=o.$el,g=o.$wrapperEl;function b(t){a||e||(e=!0,n="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,i=n,r="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,s=r,l=(new Date).getTime(),u=0,m=!0,f=void 0,p=o.monthsTranslate)}function y(t){if(e){var l=o.isHorizontal;i="touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,s="touchmove"===t.type?t.targetTouches[0].pageY:t.pageY,void 0===f&&(f=!!(f||Math.abs(s-r)>Math.abs(i-n))),l&&f?e=!1:(t.preventDefault(),o.animating?e=!1:(m=!1,a||(a=!0,c=g[0].offsetWidth,d=g[0].offsetHeight,g.transition(0)),u=(h=l?i-n:s-r)/(l?c:d),p=100*(o.monthsTranslate*o.inverter+u),g.transform("translate3d("+(l?p:0)+"%, "+(l?0:p)+"%, 0)")))}}function w(){if(!e||!a)return e=!1,void(a=!1);e=!1,a=!1,(new Date).getTime()-l<300?Math.abs(h)<10?o.resetMonth():h>=10?t.rtl?o.nextMonth():o.prevMonth():t.rtl?o.prevMonth():o.nextMonth():u<=-.5?t.rtl?o.prevMonth():o.nextMonth():u>=.5?t.rtl?o.nextMonth():o.prevMonth():o.resetMonth(),setTimeout(function(){m=!0},100)}function $(e){if(m){var t=$$1(e.target).parents(".calendar-day");if(0===t.length&&$$1(e.target).hasClass("calendar-day")&&(t=$$1(e.target)),0!==t.length&&!t.hasClass("calendar-day-disabled")){o.params.rangePicker||(t.hasClass("calendar-day-next")&&o.nextMonth(),t.hasClass("calendar-day-prev")&&o.prevMonth());var a=t.attr("data-year"),n=t.attr("data-month"),r=t.attr("data-day");o.emit("local::dayClick calendarDayClick",o,t[0],a,n,r),(!t.hasClass("calendar-day-selected")||o.params.multiple||o.params.rangePicker)&&o.addValue(new Date(a,n,r,0,0,0)),o.params.closeOnSelect&&(o.params.rangePicker&&2===o.value.length||!o.params.rangePicker)&&o.close()}}}function C(){o.nextMonth()}function x(){o.prevMonth()}function E(){o.nextYear()}function S(){o.prevYear()}var k=!("touchstart"!==t.touchEvents.start||!t.support.passiveListener)&&{passive:!0,capture:!1};v.find(".calendar-prev-month-button").on("click",x),v.find(".calendar-next-month-button").on("click",C),v.find(".calendar-prev-year-button").on("click",S),v.find(".calendar-next-year-button").on("click",E),g.on("click",$),o.params.touchMove&&(g.on(t.touchEvents.start,b,k),t.on("touchmove:active",y),t.on("touchend:passive",w)),o.detachCalendarEvents=function(){v.find(".calendar-prev-month-button").off("click",x),v.find(".calendar-next-month-button").off("click",C),v.find(".calendar-prev-year-button").off("click",S),v.find(".calendar-next-year-button").off("click",E),g.off("click",$),o.params.touchMove&&(g.off(t.touchEvents.start,b,k),t.off("touchmove:active",y),t.off("touchend:passive",w))}},o.init(),o}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.normalizeDate=function(e){var t=new Date(e);return new Date(t.getFullYear(),t.getMonth(),t.getDate())},t.prototype.normalizeValues=function(e){var t=this,a=[];return e&&Array.isArray(e)&&(a=e.map(function(e){return t.normalizeDate(e)})),a},t.prototype.initInput=function(){this.$inputEl&&this.params.inputReadOnly&&this.$inputEl.prop("readOnly",!0)},t.prototype.isPopover=function(){var e=this.app,t=this.modal,a=this.params;if("sheet"===a.openIn)return!1;if(t&&"popover"!==t.type)return!1;if(!this.inline&&this.inputEl){if("popover"===a.openIn)return!0;if(e.device.ios)return!!e.device.ipad;if(e.width>=768)return!0}return!1},t.prototype.formatDate=function(e){var t=new Date(e),a=t.getFullYear(),n=t.getMonth(),r=n+1,i=t.getDate(),o=t.getDay(),s=this.params,l=s.dateFormat,p=s.monthNames,c=s.monthNamesShort,d=s.dayNames,u=s.dayNamesShort;return l.replace(/yyyy/g,a).replace(/yy/g,String(a).substring(2)).replace(/mm/g,r<10?"0"+r:r).replace(/m(\W+)/g,r+"$1").replace(/MM/g,p[n]).replace(/M(\W+)/g,c[n]+"$1").replace(/dd/g,i<10?"0"+i:i).replace(/d(\W+)/g,i+"$1").replace(/DD/g,d[o]).replace(/D(\W+)/g,u[o]+"$1")},t.prototype.formatValue=function(){var e=this,t=e.value;return e.params.formatValue?e.params.formatValue.call(e,t):t.map(function(t){return e.formatDate(t)}).join(e.params.rangePicker?" - ":", ")},t.prototype.addValue=function(e){var t=this,a=t.params,n=a.multiple,r=a.rangePicker;if(n){var i;t.value||(t.value=[]);for(var o=0;o<t.value.length;o+=1)new Date(e).getTime()===new Date(t.value[o]).getTime()&&(i=o);void 0===i?t.value.push(e):t.value.splice(i,1),t.updateValue()}else r?(t.value||(t.value=[]),2!==t.value.length&&0!==t.value.length||(t.value=[]),t.value[0]!==e?t.value.push(e):t.value=[],t.value.sort(function(e,t){return e-t}),t.updateValue()):(t.value=[e],t.updateValue())},t.prototype.setValue=function(e){this.value=e,this.updateValue()},t.prototype.getValue=function(){return this.value},t.prototype.updateValue=function(e){var t,a,n=this.$el,r=this.$wrapperEl,i=this.$inputEl,o=this.value,s=this.params;if(n&&n.length>0)if(r.find(".calendar-day-selected").removeClass("calendar-day-selected"),s.rangePicker&&2===o.length)for(t=new Date(o[0]).getTime();t<=new Date(o[1]).getTime();t+=864e5)a=new Date(t),r.find('.calendar-day[data-date="'+a.getFullYear()+"-"+a.getMonth()+"-"+a.getDate()+'"]').addClass("calendar-day-selected");else for(t=0;t<this.value.length;t+=1)a=new Date(o[t]),r.find('.calendar-day[data-date="'+a.getFullYear()+"-"+a.getMonth()+"-"+a.getDate()+'"]').addClass("calendar-day-selected");if(e||this.emit("local::change calendarChange",this,o),i&&i.length||s.header){var l=this.formatValue(o);s.header&&n&&n.length&&n.find(".calendar-selected-date").text(l),i&&i.length&&!e&&(i.val(l),i.trigger("change"))}},t.prototype.updateCurrentMonthYear=function(e){var t=this.$months,a=this.$el,n=this.params;void 0===e?(this.currentMonth=parseInt(t.eq(1).attr("data-month"),10),this.currentYear=parseInt(t.eq(1).attr("data-year"),10)):(this.currentMonth=parseInt(t.eq("next"===e?t.length-1:0).attr("data-month"),10),this.currentYear=parseInt(t.eq("next"===e?t.length-1:0).attr("data-year"),10)),a.find(".current-month-value").text(n.monthNames[this.currentMonth]),a.find(".current-year-value").text(this.currentYear)},t.prototype.update=function(){var e=this,t=e.currentYear,a=e.currentMonth,n=e.$wrapperEl,r=new Date(t,a),i=e.renderMonth(r,"prev"),o=e.renderMonth(r),s=e.renderMonth(r,"next");n.transition(0).html(""+i+o+s).transform("translate3d(0,0,0)"),e.$months=n.find(".calendar-month"),e.monthsTranslate=0,e.setMonthsTranslate(),e.$months.each(function(t,a){e.emit("local::monthAdd calendarMonthAdd",a)})},t.prototype.onMonthChangeStart=function(e){var t=this.$months,a=this.currentYear,n=this.currentMonth;this.updateCurrentMonthYear(e),t.removeClass("calendar-month-current calendar-month-prev calendar-month-next");var r="next"===e?t.length-1:0;t.eq(r).addClass("calendar-month-current"),t.eq("next"===e?r-1:r+1).addClass("next"===e?"calendar-month-prev":"calendar-month-next"),this.emit("local::monthYearChangeStart calendarMonthYearChangeStart",this,a,n)},t.prototype.onMonthChangeEnd=function(e,t){var a,n,r,i=this,o=i.currentYear,s=i.currentMonth,l=i.$wrapperEl,p=i.monthsTranslate;i.animating=!1,l.find(".calendar-month:not(.calendar-month-prev):not(.calendar-month-current):not(.calendar-month-next)").remove(),void 0===e&&(e="next",t=!0),t?(l.find(".calendar-month-next, .calendar-month-prev").remove(),n=i.renderMonth(new Date(o,s),"prev"),a=i.renderMonth(new Date(o,s),"next")):r=i.renderMonth(new Date(o,s),e),("next"===e||t)&&l.append(r||a),("prev"===e||t)&&l.prepend(r||n);var c=l.find(".calendar-month");i.$months=c,i.setMonthsTranslate(p),i.emit("local::monthAdd calendarMonthAdd",i,"next"===e?c.eq(c.length-1)[0]:c.eq(0)[0]),i.emit("local::monthYearChangeEnd calendarMonthYearChangeEnd",i,o,s)},t.prototype.setMonthsTranslate=function(e){var t=this.$months,a=this.isHorizontal,n=this.inverter;e=e||this.monthsTranslate||0,void 0===this.monthsTranslate&&(this.monthsTranslate=e),t.removeClass("calendar-month-current calendar-month-prev calendar-month-next");var r=100*-(e+1)*n,i=100*-e*n,o=100*-(e-1)*n;t.eq(0).transform("translate3d("+(a?r:0)+"%, "+(a?0:r)+"%, 0)").addClass("calendar-month-prev"),t.eq(1).transform("translate3d("+(a?i:0)+"%, "+(a?0:i)+"%, 0)").addClass("calendar-month-current"),t.eq(2).transform("translate3d("+(a?o:0)+"%, "+(a?0:o)+"%, 0)").addClass("calendar-month-next")},t.prototype.nextMonth=function(e){var t=this,a=t.params,n=t.$wrapperEl,r=t.inverter,i=t.isHorizontal;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));var o=parseInt(t.$months.eq(t.$months.length-1).attr("data-month"),10),s=parseInt(t.$months.eq(t.$months.length-1).attr("data-year"),10),l=new Date(s,o).getTime(),p=!t.animating;if(a.maxDate&&l>new Date(a.maxDate).getTime())t.resetMonth();else{if(t.monthsTranslate-=1,o===t.currentMonth){var c=100*-t.monthsTranslate*r,d=$$1(t.renderMonth(l,"next")).transform("translate3d("+(i?c:0)+"%, "+(i?0:c)+"%, 0)").addClass("calendar-month-next");n.append(d[0]),t.$months=n.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(t.$months.length-1)[0])}t.animating=!0,t.onMonthChangeStart("next");var u=100*t.monthsTranslate*r;n.transition(e).transform("translate3d("+(i?u:0)+"%, "+(i?0:u)+"%, 0)"),p&&n.transitionEnd(function(){t.onMonthChangeEnd("next")}),a.animate||t.onMonthChangeEnd("next")}},t.prototype.prevMonth=function(e){var t=this,a=t.params,n=t.$wrapperEl,r=t.inverter,i=t.isHorizontal;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));var o=parseInt(t.$months.eq(0).attr("data-month"),10),s=parseInt(t.$months.eq(0).attr("data-year"),10),l=new Date(s,o+1,-1).getTime(),p=!t.animating;if(a.minDate&&l<new Date(a.minDate).getTime())t.resetMonth();else{if(t.monthsTranslate+=1,o===t.currentMonth){var c=100*-t.monthsTranslate*r,d=$$1(t.renderMonth(l,"prev")).transform("translate3d("+(i?c:0)+"%, "+(i?0:c)+"%, 0)").addClass("calendar-month-prev");n.prepend(d[0]),t.$months=n.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(0)[0])}t.animating=!0,t.onMonthChangeStart("prev");var u=100*t.monthsTranslate*r;n.transition(e).transform("translate3d("+(i?u:0)+"%, "+(i?0:u)+"%, 0)"),p&&n.transitionEnd(function(){t.onMonthChangeEnd("prev")}),a.animate||t.onMonthChangeEnd("prev")}},t.prototype.resetMonth=function(e){void 0===e&&(e="");var t=this.$wrapperEl,a=this.inverter,n=this.isHorizontal,r=100*this.monthsTranslate*a;t.transition(e).transform("translate3d("+(n?r:0)+"%, "+(n?0:r)+"%, 0)")},t.prototype.setYearMonth=function(e,t,a){var n,r=this,i=r.params,o=r.isHorizontal,s=r.$wrapperEl,l=r.inverter;if(void 0===e&&(e=r.currentYear),void 0===t&&(t=r.currentMonth),void 0!==a&&"object"!=typeof a||(a="",i.animate||(a=0)),n=e<r.currentYear?new Date(e,t+1,-1).getTime():new Date(e,t).getTime(),i.maxDate&&n>new Date(i.maxDate).getTime())return!1;if(i.minDate&&n<new Date(i.minDate).getTime())return!1;var p=new Date(r.currentYear,r.currentMonth).getTime(),c=n>p?"next":"prev",d=r.renderMonth(new Date(e,t));r.monthsTranslate=r.monthsTranslate||0;var u,h=r.monthsTranslate,f=!r.animating;n>p?(r.monthsTranslate-=1,r.animating||r.$months.eq(r.$months.length-1).remove(),s.append(d),r.$months=s.find(".calendar-month"),u=100*-(h-1)*l,r.$months.eq(r.$months.length-1).transform("translate3d("+(o?u:0)+"%, "+(o?0:u)+"%, 0)").addClass("calendar-month-next")):(r.monthsTranslate+=1,r.animating||r.$months.eq(0).remove(),s.prepend(d),r.$months=s.find(".calendar-month"),u=100*-(h+1)*l,r.$months.eq(0).transform("translate3d("+(o?u:0)+"%, "+(o?0:u)+"%, 0)").addClass("calendar-month-prev")),r.emit("local::monthAdd calendarMonthAdd","next"===c?r.$months.eq(r.$months.length-1)[0]:r.$months.eq(0)[0]),r.animating=!0,r.onMonthChangeStart(c);var m=100*r.monthsTranslate*l;s.transition(a).transform("translate3d("+(o?m:0)+"%, "+(o?0:m)+"%, 0)"),f&&s.transitionEnd(function(){r.onMonthChangeEnd(c,!0)}),i.animate||r.onMonthChangeEnd(c)},t.prototype.nextYear=function(){this.setYearMonth(this.currentYear+1)},t.prototype.prevYear=function(){this.setYearMonth(this.currentYear-1)},t.prototype.dateInRange=function(e,t){var a,n=!1;if(!t)return!1;if(Array.isArray(t))for(a=0;a<t.length;a+=1)t[a].from||t[a].to?t[a].from&&t[a].to?e<=new Date(t[a].to).getTime()&&e>=new Date(t[a].from).getTime()&&(n=!0):t[a].from?e>=new Date(t[a].from).getTime()&&(n=!0):t[a].to&&e<=new Date(t[a].to).getTime()&&(n=!0):e===new Date(t[a]).getTime()&&(n=!0);else t.from||t.to?t.from&&t.to?e<=new Date(t.to).getTime()&&e>=new Date(t.from).getTime()&&(n=!0):t.from?e>=new Date(t.from).getTime()&&(n=!0):t.to&&e<=new Date(t.to).getTime()&&(n=!0):"function"==typeof t&&(n=t(new Date(e)));return n},t.prototype.daysInMonth=function(e){var t=new Date(e);return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()},t.prototype.renderMonths=function(e){return this.params.renderMonths?this.params.renderMonths.call(this,e):('\n      <div class="calendar-months-wrapper">\n        '+this.renderMonth(e,"prev")+"\n        "+this.renderMonth(e)+"\n        "+this.renderMonth(e,"next")+"\n      </div>\n    ").trim()},t.prototype.renderMonth=function(e,t){var a=this.params,n=this.value;if(a.renderMonth)return a.renderMonth.call(this,e,t);var r=new Date(e),i=r.getFullYear(),o=r.getMonth();"next"===t&&(r=11===o?new Date(i+1,0):new Date(i,o+1,1)),"prev"===t&&(r=0===o?new Date(i-1,11):new Date(i,o-1,1)),"next"!==t&&"prev"!==t||(o=r.getMonth(),i=r.getFullYear());var s,l,p=[],c=(new Date).setHours(0,0,0,0),d=a.minDate?new Date(a.minDate).getTime():null,u=a.maxDate?new Date(a.maxDate).getTime():null,h=this.daysInMonth(new Date(r.getFullYear(),r.getMonth()).getTime()-864e6),f=this.daysInMonth(r),m=6===a.firstDay?0:1,v="",g=a.firstDay-1+0,b=new Date(r.getFullYear(),r.getMonth()).getDay();if(0===b&&(b=7),n&&n.length)for(var y=0;y<n.length;y+=1)p.push(new Date(n[y]).setHours(0,0,0,0));for(var w=1;w<=6;w+=1){for(var $="",C=1;C<=7;C+=1){var x=void 0,E=(g+=1)-b,S="";1===w&&1===C&&E>m&&1!==a.firstDay&&(E=(g-=7)-b);var k=C-1+a.firstDay>6?C-1-7+a.firstDay:C-1+a.firstDay;if(E<0?(E=h+E+1,S+=" calendar-day-prev",x=new Date(o-1<0?i-1:i,o-1<0?11:o-1,E).getTime()):(E+=1)>f?(E-=f,S+=" calendar-day-next",x=new Date(o+1>11?i+1:i,o+1>11?0:o+1,E).getTime()):x=new Date(i,o,E).getTime(),x===c&&(S+=" calendar-day-today"),a.rangePicker&&2===p.length?x>=p[0]&&x<=p[1]&&(S+=" calendar-day-selected"):p.indexOf(x)>=0&&(S+=" calendar-day-selected"),a.weekendDays.indexOf(k)>=0&&(S+=" calendar-day-weekend"),l=!1,a.events&&this.dateInRange(x,a.events)&&(l=!0),l&&(S+=" calendar-day-has-events"),a.rangesClasses)for(var T=0;T<a.rangesClasses.length;T+=1)this.dateInRange(x,a.rangesClasses[T].range)&&(S+=" "+a.rangesClasses[T].cssClass);s=!1,(d&&x<d||u&&x>u)&&(s=!0),a.disabled&&this.dateInRange(x,a.disabled)&&(s=!0),s&&(S+=" calendar-day-disabled");var M=(x=new Date(x)).getFullYear(),P=x.getMonth();$+=('\n          <div data-year="'+M+'" data-month="'+P+'" data-day="'+E+'" class="calendar-day'+S+'" data-date="'+M+"-"+P+"-"+E+'">\n            <span>'+E+"</span>\n          </div>").trim()}v+='<div class="calendar-row">'+$+"</div>"}return v='<div class="calendar-month" data-year="'+i+'" data-month="'+o+'">'+v+"</div>"},t.prototype.renderWeekHeader=function(){if(this.params.renderWeekHeader)return this.params.renderWeekHeader.call(this);for(var e=this.params,t="",a=0;a<7;a+=1){var n=a+e.firstDay>6?a-7+e.firstDay:a+e.firstDay;t+='<div class="calendar-week-day">'+e.dayNamesShort[n]+"</div>"}return('\n      <div class="calendar-week-header">\n        '+t+"\n      </div>\n    ").trim()},t.prototype.renderMonthSelector=function(){var e,t=this.app;if(this.params.renderMonthSelector)return this.params.renderMonthSelector.call(this);this.inline&&0===this.$containerEl.closest(".theme-dark").length?e=!0:0===t.root.closest(".theme-dark").length&&(e=!0);var a="md"===t.theme&&e?"color-black":"";return('\n      <div class="calendar-month-selector">\n        <a href="#" class="link icon-only calendar-prev-month-button">\n          <i class="icon icon-prev '+a+'"></i>\n        </a>\n        <span class="current-month-value"></span>\n        <a href="#" class="link icon-only calendar-next-month-button">\n          <i class="icon icon-next '+a+'"></i>\n        </a>\n      </div>\n    ').trim()},t.prototype.renderYearSelector=function(){var e,t=this.app;if(this.params.renderYearSelector)return this.params.renderYearSelector.call(this);this.inline&&0===this.$containerEl.closest(".theme-dark").length?e=!0:0===t.root.closest(".theme-dark").length&&(e=!0);var a="md"===t.theme&&e?"color-black":"";return('\n      <div class="calendar-year-selector">\n        <a href="#" class="link icon-only calendar-prev-year-button">\n          <i class="icon icon-prev '+a+'"></i>\n        </a>\n        <span class="current-year-value"></span>\n        <a href="#" class="link icon-only calendar-next-year-button">\n          <i class="icon icon-next '+a+'"></i>\n        </a>\n      </div>\n    ').trim()},t.prototype.renderHeader=function(){return this.params.renderHeader?this.params.renderHeader.call(this):('\n      <div class="calendar-header">\n        <div class="calendar-selected-date">'+this.params.headerPlaceholder+"</div>\n      </div>\n    ").trim()},t.prototype.renderFooter=function(){var e=this.app;return this.params.renderFooter?this.params.renderFooter.call(this):('\n      <div class="calendar-footer">\n        <a href="#" class="'+("md"===e.theme?"button":"link")+' calendar-close sheet-close popover-close">'+this.params.toolbarCloseText+"</a>\n      </div>\n    ").trim()},t.prototype.renderToolbar=function(){return this.params.renderToolbar?this.params.renderToolbar.call(this,this):('\n      <div class="toolbar no-shadow">\n        <div class="toolbar-inner">\n          '+this.renderMonthSelector()+"\n          "+this.renderYearSelector()+"\n        </div>\n      </div>\n    ").trim()},t.prototype.renderInline=function(){var e=this.params,t=e.cssClass,a=e.toolbar,n=e.header,r=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n      <div class="calendar calendar-inline '+(i?"calendar-range":"")+" "+(t||"")+'">\n        '+(n?this.renderHeader():"")+"\n        "+(a?this.renderToolbar():"")+"\n        "+(o?this.renderWeekHeader():"")+'\n        <div class="calendar-months">\n          '+this.renderMonths(l)+"\n        </div>\n        "+(r?this.renderFooter():"")+"\n      </div>\n    ").trim()},t.prototype.renderCustomModal=function(){var e=this.params,t=e.cssClass,a=e.toolbar,n=e.header,r=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n      <div class="calendar calendar-modal '+(i?"calendar-range":"")+" "+(t||"")+'">\n        '+(n?this.renderHeader():"")+"\n        "+(a?this.renderToolbar():"")+"\n        "+(o?this.renderWeekHeader():"")+'\n        <div class="calendar-months">\n          '+this.renderMonths(l)+"\n        </div>\n        "+(r?this.renderFooter():"")+"\n      </div>\n    ").trim()},t.prototype.renderSheet=function(){var e=this.params,t=e.cssClass,a=e.toolbar,n=e.header,r=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n      <div class="sheet-modal calendar calendar-sheet '+(i?"calendar-range":"")+" "+(t||"")+'">\n        '+(n?this.renderHeader():"")+"\n        "+(a?this.renderToolbar():"")+"\n        "+(o?this.renderWeekHeader():"")+'\n        <div class="sheet-modal-inner calendar-months">\n          '+this.renderMonths(l)+"\n        </div>\n        "+(r?this.renderFooter():"")+"\n      </div>\n    ").trim()},t.prototype.renderPopover=function(){var e=this.params,t=e.cssClass,a=e.toolbar,n=e.header,r=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n      <div class="popover calendar-popover">\n        <div class="popover-inner">\n          <div class="calendar '+(i?"calendar-range":"")+" "+(t||"")+'">\n            '+(n?this.renderHeader():"")+"\n            "+(a?this.renderToolbar():"")+"\n            "+(o?this.renderWeekHeader():"")+'\n            <div class="calendar-months">\n              '+this.renderMonths(l)+"\n            </div>\n            "+(r?this.renderFooter():"")+"\n          </div>\n        </div>\n      </div>\n    ").trim()},t.prototype.render=function(){var e=this.params;if(e.render)return e.render.call(this);if(!this.inline){var t=e.openIn;return"auto"===t&&(t=this.isPopover()?"popover":"sheet"),"popover"===t?this.renderPopover():"sheet"===t?this.renderSheet():this.renderCustomModal()}return this.renderInline()},t.prototype.onOpen=function(){var e=this,t=e.initialized,a=e.$el,n=e.app,r=e.$inputEl,i=e.inline,o=e.value,s=e.params;e.opened=!0,e.attachCalendarEvents();var l=!o&&s.value;t?o&&e.setValue(o,0):o?e.setValue(o,0):s.value&&e.setValue(e.normalizeValues(s.value),0),e.updateCurrentMonthYear(),e.monthsTranslate=0,e.setMonthsTranslate(),l?e.updateValue():s.header&&o&&e.updateValue(!0),!i&&r.length&&"md"===n.theme&&r.trigger("focus"),e.initialized=!0,e.$months.each(function(t,a){e.emit("local::monthAdd calendarMonthAdd",a)}),a&&a.trigger("calendar:open",e),r&&r.trigger("calendar:open",e),e.emit("local::open calendarOpen",e)},t.prototype.onOpened=function(){this.$el&&this.$el.trigger("calendar:opened",this),this.$inputEl&&this.$inputEl.trigger("calendar:opened",this),this.emit("local::opened calendarOpened",this)},t.prototype.onClose=function(){var e=this,t=e.app;e.$inputEl&&"md"===t.theme&&e.$inputEl.trigger("blur"),e.detachCalendarEvents&&e.detachCalendarEvents(),e.$el&&e.$el.trigger("calendar:close",e),e.$inputEl&&e.$inputEl.trigger("calendar:close",e),e.emit("local::close calendarClose",e)},t.prototype.onClosed=function(){var e=this;e.opened=!1,e.inline||Utils.nextTick(function(){e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal}),e.$el&&e.$el.trigger("calendar:closed",e),e.$inputEl&&e.$inputEl.trigger("calendar:closed",e),e.emit("local::closed calendarClosed",e)},t.prototype.open=function(){var e,t=this,a=t.app,n=t.opened,r=t.inline,i=t.$inputEl,o=t.params;if(!n){if(r)return t.$el=$$1(t.render()),t.$el[0].f7Calendar=t,t.$wrapperEl=t.$el.find(".calendar-months-wrapper"),t.$months=t.$wrapperEl.find(".calendar-month"),t.$containerEl.append(t.$el),t.onOpen(),void t.onOpened();var s=o.openIn;"auto"===s&&(s=t.isPopover()?"popover":"sheet");var l=t.render(),p={targetEl:i,scrollToEl:t.params.scrollToInput?i:void 0,content:l,backdrop:"popover"===s&&!1!==a.params.popover.backdrop,on:{open:function(){t.modal=this,t.$el="popover"===s?this.$el.find(".calendar"):this.$el,t.$wrapperEl=t.$el.find(".calendar-months-wrapper"),t.$months=t.$wrapperEl.find(".calendar-month"),t.$el[0].f7Calendar=t,"customModal"===s&&$$1(t.$el).find(".calendar-close").once("click",function(){t.close()}),t.onOpen()},opened:function(){t.onOpened()},close:function(){t.onClose()},closed:function(){t.onClosed()}}};t.params.routableModals?t.view.router.navigate({url:t.url,route:(e={path:t.url},e[s]=p,e)}):(t.modal=a[s].create(p),t.modal.open())}},t.prototype.close=function(){var e=this.opened,t=this.inline;if(e)return t?(this.onClose(),void this.onClosed()):void(this.params.routableModals?this.view.router.back():this.modal.close())},t.prototype.init=function(){var e=this;if(e.initInput(),e.inline)return e.open(),void e.emit("local::init calendarInit",e);!e.initialized&&e.params.value&&e.setValue(e.normalizeValues(e.params.value)),e.$inputEl&&e.attachInputEvents(),e.params.closeByOutsideClick&&e.attachHtmlEvents(),e.emit("local::init calendarInit",e)},t.prototype.destroy=function(){var e=this;if(!e.destroyed){var t=e.$el;e.emit("local::beforeDestroy calendarBeforeDestroy",e),t&&t.trigger("calendar:beforedestroy",e),e.close(),e.$inputEl&&e.detachInputEvents(),e.params.closeByOutsideClick&&e.detachHtmlEvents(),t&&t.length&&delete e.$el[0].f7Calendar,Utils.deleteProps(e),e.destroyed=!0}},t}(Framework7Class),Calendar$1={name:"calendar",static:{Calendar:Calendar},create:function(){this.calendar=ConstructorMethods({defaultSelector:".calendar",constructor:Calendar,app:this,domProp:"f7Calendar"}),this.calendar.close=function(e){void 0===e&&(e=".calendar");var t=$$1(e);if(0!==t.length){var a=t[0].f7Calendar;!a||a&&!a.opened||a.close()}}},params:{calendar:{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],firstDay:1,weekendDays:[0,6],multiple:!1,rangePicker:!1,dateFormat:"yyyy-mm-dd",direction:"horizontal",minDate:null,maxDate:null,disabled:null,events:null,rangesClasses:null,touchMove:!0,animate:!0,closeOnSelect:!1,monthSelector:!0,yearSelector:!0,weekHeader:!0,value:null,containerEl:null,openIn:"auto",formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,header:!1,headerPlaceholder:"Select date",footer:!1,toolbar:!0,toolbarCloseText:"Done",cssClass:null,routableModals:!0,view:null,url:"date/",renderWeekHeader:null,renderMonths:null,renderMonth:null,renderMonthSelector:null,renderYearSelector:null,renderHeader:null,renderFooter:null,renderToolbar:null,renderInline:null,renderPopover:null,renderSheet:null,render:null}}};function pickerColumn(e,t){var a=this,n=a.app,r=$$1(e),i=r.index(),o=a.cols[i];if(!o.divider){var s,l,p,c,d;o.$el=r,o.el=r[0],o.$itemsEl=o.$el.find(".picker-items"),o.items=o.$itemsEl.find(".picker-item"),o.replaceValues=function(e,t){o.detachEvents(),o.values=e,o.displayValues=t,o.$itemsEl.html(a.renderColumn(o,!0)),o.items=o.$itemsEl.find(".picker-item"),o.calcSize(),o.setValue(o.values[0],0,!0),o.attachEvents()},o.calcSize=function(){a.params.rotateEffect&&(o.$el.removeClass("picker-column-absolute"),o.width||o.$el.css({width:""}));var e=0,t=o.$el[0].offsetHeight;s=o.items[0].offsetHeight,l=s*o.items.length,p=t/2-l+s/2,c=t/2-s/2,o.width&&(e=o.width,parseInt(e,10)===e&&(e+="px"),o.$el.css({width:e})),a.params.rotateEffect&&(o.width||(o.items.each(function(t,a){var n=$$1(a).children("span");e=Math.max(e,n[0].offsetWidth)}),o.$el.css({width:e+2+"px"})),o.$el.addClass("picker-column-absolute"))},o.setValue=function(e,t,n){void 0===t&&(t="");var r=o.$itemsEl.find('.picker-item[data-picker-value="'+e+'"]').index();if(void 0!==r&&-1!==r){var i=-r*s+c;o.$itemsEl.transition(t),o.$itemsEl.transform("translate3d(0,"+i+"px,0)"),a.params.updateValuesOnMomentum&&o.activeIndex&&o.activeIndex!==r&&(Utils.cancelAnimationFrame(d),o.$itemsEl.transitionEnd(function(){Utils.cancelAnimationFrame(d)}),E()),o.updateItems(r,i,t,n)}},o.updateItems=function(e,t,n,r){void 0===t&&(t=Utils.getTranslate(o.$itemsEl[0],"y")),void 0===e&&(e=-Math.round((t-c)/s)),e<0&&(e=0),e>=o.items.length&&(e=o.items.length-1);var i=o.activeIndex;o.activeIndex=e,o.$itemsEl.find(".picker-item-selected").removeClass("picker-item-selected"),o.items.transition(n);var l=o.items.eq(e).addClass("picker-item-selected").transform("");a.params.rotateEffect&&o.items.each(function(e,n){var r=$$1(n),i=(r.index()*s-(c-t))/s,l=Math.ceil(o.height/s/2)+1,p=-18*i;p>180&&(p=180),p<-180&&(p=-180),Math.abs(i)>l?r.addClass("picker-item-far"):r.removeClass("picker-item-far"),r.transform("translate3d(0, "+(-t+c)+"px, "+(a.needsOriginFix?-110:0)+"px) rotateX("+p+"deg)")}),(r||void 0===r)&&(o.value=l.attr("data-picker-value"),o.displayValue=o.displayValues?o.displayValues[e]:o.value,i!==e&&(o.onChange&&o.onChange(a,o.value,o.displayValue),a.updateValue()))};var u,h,f,m,v,g,b,y,w,$,C=!0,x=!!n.support.passiveListener&&{passive:!1,capture:!1};o.attachEvents=function(){o.$el.on(n.touchEvents.start,S,x),n.on("touchmove:active",k),n.on("touchend:passive",T),o.items.on("click",M)},o.detachEvents=function(){o.$el.off(n.touchEvents.start,S,x),n.off("touchmove:active",k),n.off("touchend:passive",T),o.items.off("click",M)},o.init=function(){o.calcSize(),o.$itemsEl.transform("translate3d(0,"+c+"px,0)").transition(0),0===i&&o.$el.addClass("picker-column-first"),i===a.cols.length-1&&o.$el.addClass("picker-column-last"),t&&o.updateItems(0,c,0),o.attachEvents()},o.destroy=function(){o.detachEvents()},o.init()}function E(){d=Utils.requestAnimationFrame(function(){o.updateItems(void 0,void 0,0),E()})}function S(e){h||u||(e.preventDefault(),u=!0,f="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,m=f,v=(new Date).getTime(),C=!0,g=Utils.getTranslate(o.$itemsEl[0],"y"),y=g)}function k(e){u&&(e.preventDefault(),C=!1,m="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,h||(Utils.cancelAnimationFrame(d),h=!0,g=Utils.getTranslate(o.$itemsEl[0],"y"),y=g,o.$itemsEl.transition(0)),b=void 0,(y=g+(m-f))<p&&(y=p-Math.pow(p-y,.8),b="min"),y>c&&(y=c+Math.pow(y-c,.8),b="max"),o.$itemsEl.transform("translate3d(0,"+y+"px,0)"),o.updateItems(void 0,y,0,a.params.updateValuesOnTouchmove),$=y-w||y,w=y)}function T(){if(!u||!h)return u=!1,void(h=!1);var e;u=!1,h=!1,o.$itemsEl.transition(""),b&&("min"===b?o.$itemsEl.transform("translate3d(0,"+p+"px,0)"):o.$itemsEl.transform("translate3d(0,"+c+"px,0)")),e=(new Date).getTime()-v>300?y:y+$*a.params.momentumRatio,e=Math.max(Math.min(e,c),p);var t=-Math.floor((e-c)/s);a.params.freeMode||(e=-t*s+c),o.$itemsEl.transform("translate3d(0,"+parseInt(e,10)+"px,0)"),o.updateItems(t,e,"",!0),a.params.updateValuesOnMomentum&&(E(),o.$itemsEl.transitionEnd(function(){Utils.cancelAnimationFrame(d)})),setTimeout(function(){C=!0},100)}function M(){if(C){Utils.cancelAnimationFrame(d);var e=$$1(this).attr("data-picker-value");o.setValue(e)}}}var Picker=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n,r,i,o=this;if(o.params=Utils.extend({},t.params.picker,a),o.params.containerEl&&0===(n=$$1(o.params.containerEl)).length)return o;function s(){o.resizeCols()}function l(){o.open()}function p(e){e.preventDefault()}function c(e){var t=$$1(e.target);o.isPopover()||o.opened&&(t.closest('[class*="backdrop"]').length||(r&&r.length>0?t[0]!==r[0]&&0===t.closest(".sheet-modal").length&&o.close():0===$$1(e.target).closest(".sheet-modal").length&&o.close()))}return o.params.inputEl&&(r=$$1(o.params.inputEl)),r&&(i=r.parents(".view").length&&r.parents(".view")[0].f7View),i||(i=t.views.main),Utils.extend(o,{app:t,$containerEl:n,containerEl:n&&n[0],inline:n&&n.length>0,needsOriginFix:t.device.ios||win.navigator.userAgent.toLowerCase().indexOf("safari")>=0&&win.navigator.userAgent.toLowerCase().indexOf("chrome")<0&&!t.device.android,cols:[],$inputEl:r,inputEl:r&&r[0],initialized:!1,opened:!1,url:o.params.url,view:i}),Utils.extend(o,{attachResizeEvent:function(){t.on("resize",s)},detachResizeEvent:function(){t.off("resize",s)},attachInputEvents:function(){o.$inputEl.on("click",l),o.params.inputReadOnly&&o.$inputEl.on("focus mousedown",p)},detachInputEvents:function(){o.$inputEl.off("click",l),o.params.inputReadOnly&&o.$inputEl.off("focus mousedown",p)},attachHtmlEvents:function(){t.on("click",c)},detachHtmlEvents:function(){t.off("click",c)}}),o.init(),o}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.initInput=function(){this.$inputEl&&this.params.inputReadOnly&&this.$inputEl.prop("readOnly",!0)},t.prototype.resizeCols=function(){if(this.opened)for(var e=0;e<this.cols.length;e+=1)this.cols[e].divider||(this.cols[e].calcSize(),this.cols[e].setValue(this.cols[e].value,0,!1))},t.prototype.isPopover=function(){var e=this.app,t=this.modal,a=this.params;if("sheet"===a.openIn)return!1;if(t&&"popover"!==t.type)return!1;if(!this.inline&&this.inputEl){if("popover"===a.openIn)return!0;if(e.device.ios)return!!e.device.ipad;if(e.width>=768)return!0}return!1},t.prototype.formatValue=function(){var e=this.value,t=this.displayValue;return this.params.formatValue?this.params.formatValue.call(this,e,t):e.join(" ")},t.prototype.setValue=function(e,t){var a=0;if(0===this.cols.length)return this.value=e,void this.updateValue(e);for(var n=0;n<this.cols.length;n+=1)this.cols[n]&&!this.cols[n].divider&&(this.cols[n].setValue(e[a],t),a+=1)},t.prototype.getValue=function(){return this.value},t.prototype.updateValue=function(e){var t,a=this,n=e||[],r=[];if(0===a.cols.length)for(var i=a.params.cols.filter(function(e){return!e.divider}),o=0;o<i.length;o+=1)void 0!==(t=i[o]).displayValues&&void 0!==t.values&&-1!==t.values.indexOf(n[o])?r.push(t.displayValues[t.values.indexOf(n[o])]):r.push(n[o]);else for(var s=0;s<a.cols.length;s+=1)a.cols[s].divider||(n.push(a.cols[s].value),r.push(a.cols[s].displayValue));n.indexOf(void 0)>=0||(a.value=n,a.displayValue=r,a.emit("local::change pickerChange",a,a.value,a.displayValue),a.inputEl&&(a.$inputEl.val(a.formatValue()),a.$inputEl.trigger("change")))},t.prototype.initColumn=function(e,t){pickerColumn.call(this,e,t)},t.prototype.destroyColumn=function(e){var t=$$1(e).index();this.cols[t]&&this.cols[t].destroy&&this.cols[t].destroy()},t.prototype.renderToolbar=function(){return this.params.renderToolbar?this.params.renderToolbar.call(this,this):('\n      <div class="toolbar no-shadow">\n        <div class="toolbar-inner">\n          <div class="left"></div>\n          <div class="right">\n            <a href="#" class="link sheet-close popover-close">'+this.params.toolbarCloseText+"</a>\n          </div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderColumn=function(e,t){var a,n,r="picker-column "+(e.textAlign?"picker-column-"+e.textAlign:"")+" "+(e.cssClass||"");return a=e.divider?'\n        <div class="'+r+' picker-column-divider">'+e.content+"</div>\n      ":'\n        <div class="'+r+'">\n          <div class="picker-items">'+(n=e.values.map(function(t,a){return'\n        <div class="picker-item" data-picker-value="'+t+'">\n          <span>'+(e.displayValues?e.displayValues[a]:t)+"</span>\n        </div>\n      "}).join(""))+"</div>\n        </div>\n      ",t?n.trim():a.trim()},t.prototype.renderInline=function(){var e=this,t=e.params,a=t.rotateEffect,n=t.cssClass,r=t.toolbar;return('\n      <div class="picker picker-inline '+(a?"picker-3d":"")+" "+(n||"")+'">\n        '+(r?e.renderToolbar():"")+'\n        <div class="picker-columns">\n          '+e.cols.map(function(t){return e.renderColumn(t)}).join("")+'\n          <div class="picker-center-highlight"></div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderSheet=function(){var e=this,t=e.params,a=t.rotateEffect,n=t.cssClass,r=t.toolbar;return('\n      <div class="sheet-modal picker picker-sheet '+(a?"picker-3d":"")+" "+(n||"")+'">\n        '+(r?e.renderToolbar():"")+'\n        <div class="sheet-modal-inner picker-columns">\n          '+e.cols.map(function(t){return e.renderColumn(t)}).join("")+'\n          <div class="picker-center-highlight"></div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderPopover=function(){var e=this,t=e.params,a=t.rotateEffect,n=t.cssClass,r=t.toolbar;return('\n      <div class="popover picker-popover">\n        <div class="popover-inner">\n          <div class="picker '+(a?"picker-3d":"")+" "+(n||"")+'">\n            '+(r?e.renderToolbar():"")+'\n            <div class="picker-columns">\n              '+e.cols.map(function(t){return e.renderColumn(t)}).join("")+'\n              <div class="picker-center-highlight"></div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ').trim()},t.prototype.render=function(){return this.params.render?this.params.render.call(this):this.inline?this.renderInline():this.isPopover()?this.renderPopover():this.renderSheet()},t.prototype.onOpen=function(){var e=this,t=e.initialized,a=e.$el,n=e.app,r=e.$inputEl,i=e.inline,o=e.value,s=e.params;e.opened=!0,e.attachResizeEvent(),a.find(".picker-column").each(function(a,n){var r=!0;(!t&&s.value||t&&o)&&(r=!1),e.initColumn(n,r)}),t?o&&e.setValue(o,0):o?e.setValue(o,0):s.value&&e.setValue(s.value,0),!i&&r.length&&"md"===n.theme&&r.trigger("focus"),e.initialized=!0,a&&a.trigger("picker:open",e),r&&r.trigger("picker:open",e),e.emit("local::open pickerOpen",e)},t.prototype.onOpened=function(){this.$el&&this.$el.trigger("picker:opened",this),this.$inputEl&&this.$inputEl.trigger("picker:opened",this),this.emit("local::opened pickerOpened",this)},t.prototype.onClose=function(){var e=this,t=e.app;e.detachResizeEvent(),e.cols.forEach(function(e){e.destroy&&e.destroy()}),e.$inputEl&&"md"===t.theme&&e.$inputEl.trigger("blur"),e.$el&&e.$el.trigger("picker:close",e),e.$inputEl&&e.$inputEl.trigger("picker:close",e),e.emit("local::close pickerClose",e)},t.prototype.onClosed=function(){var e=this;e.opened=!1,e.inline||Utils.nextTick(function(){e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal}),e.$el&&e.$el.trigger("picker:closed",e),e.$inputEl&&e.$inputEl.trigger("picker:closed",e),e.emit("local::closed pickerClosed",e)},t.prototype.open=function(){var e,t=this,a=t.app,n=t.opened,r=t.inline,i=t.$inputEl;if(!n){if(0===t.cols.length&&t.params.cols.length&&t.params.cols.forEach(function(e){t.cols.push(e)}),r)return t.$el=$$1(t.render()),t.$el[0].f7Picker=t,t.$containerEl.append(t.$el),t.onOpen(),void t.onOpened();var o=t.isPopover(),s=o?"popover":"sheet",l={targetEl:i,scrollToEl:t.params.scrollToInput?i:void 0,content:t.render(),backdrop:o,on:{open:function(){t.modal=this,t.$el=o?this.$el.find(".picker"):this.$el,t.$el[0].f7Picker=t,t.onOpen()},opened:function(){t.onOpened()},close:function(){t.onClose()},closed:function(){t.onClosed()}}};t.params.routableModals?t.view.router.navigate({url:t.url,route:(e={path:t.url},e[s]=l,e)}):(t.modal=a[s].create(l),t.modal.open())}},t.prototype.close=function(){var e=this.opened,t=this.inline;if(e)return t?(this.onClose(),void this.onClosed()):void(this.params.routableModals?this.view.router.back():this.modal.close())},t.prototype.init=function(){var e=this;if(e.initInput(),e.inline)return e.open(),void e.emit("local::init pickerInit",e);!e.initialized&&e.params.value&&e.setValue(e.params.value),e.$inputEl&&e.attachInputEvents(),e.params.closeByOutsideClick&&e.attachHtmlEvents(),e.emit("local::init pickerInit",e)},t.prototype.destroy=function(){var e=this;if(!e.destroyed){var t=e.$el;e.emit("local::beforeDestroy pickerBeforeDestroy",e),t&&t.trigger("picker:beforedestroy",e),e.close(),e.$inputEl&&e.detachInputEvents(),e.params.closeByOutsideClick&&e.detachHtmlEvents(),t&&t.length&&delete e.$el[0].f7Picker,Utils.deleteProps(e),e.destroyed=!0}},t}(Framework7Class),Picker$1={name:"picker",static:{Picker:Picker},create:function(){this.picker=ConstructorMethods({defaultSelector:".picker",constructor:Picker,app:this,domProp:"f7Picker"}),this.picker.close=function(e){void 0===e&&(e=".picker");var t=$$1(e);if(0!==t.length){var a=t[0].f7Picker;!a||a&&!a.opened||a.close()}}},params:{picker:{updateValuesOnMomentum:!1,updateValuesOnTouchmove:!0,rotateEffect:!1,momentumRatio:7,freeMode:!1,cols:[],containerEl:null,openIn:"auto",formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,toolbar:!0,toolbarCloseText:"Done",cssClass:null,routableModals:!0,view:null,url:"select/",renderToolbar:null,render:null}}},InfiniteScroll={handleScroll:function(e,t){var a,n=$$1(e),r=n[0].scrollTop,i=n[0].scrollHeight,o=n[0].offsetHeight,s=n[0].getAttribute("data-infinite-distance"),l=n.find(".virtual-list"),p=n.hasClass("infinite-scroll-top");if(s||(s=50),"string"==typeof s&&s.indexOf("%")>=0&&(s=parseInt(s,10)/100*o),s>o&&(s=o),p)r<s&&(n.trigger("infinite",t),this.emit("infinite",n[0],t));else if(r+o>=i-s){if(l.length>0&&(a=l.eq(-1)[0].f7VirtualList)&&!a.reachEnd&&!a.params.updatableScroll)return;n.trigger("infinite",t),this.emit("infinite",n[0],t)}},create:function(e){var t=this;$$1(e).on("scroll",function(e){t.infiniteScroll.handle(this,e)})},destroy:function(e){$$1(e).off("scroll")}},InfiniteScroll$1={name:"infiniteScroll",create:function(){Utils.extend(this,{infiniteScroll:{handle:InfiniteScroll.handleScroll.bind(this),create:InfiniteScroll.create.bind(this),destroy:InfiniteScroll.destroy.bind(this)}})},on:{tabMounted:function(e){var t=this;$$1(e).find(".infinite-scroll-content").each(function(e,a){t.infiniteScroll.create(a)})},tabBeforeRemove:function(e){var t=this;$$1(e).find(".infinite-scroll-content").each(function(e,a){t.infiniteScroll.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".infinite-scroll-content").each(function(e,a){t.infiniteScroll.create(a)})},pageBeforeRemove:function(e){var t=this;e.$el.find(".infinite-scroll-content").each(function(e,a){t.infiniteScroll.destroy(a)})}}},PullToRefresh=function(e){function t(t,a){e.call(this,{},[t]);var n=this,r=$$1(a),i=r.find(".ptr-preloader");n.$el=r,n.el=r[0],n.app=t,n.useModulesParams({});var o,s,l,p="md"===t.theme;n.done=function(){return(p?i:r).transitionEnd(function(){r.removeClass("ptr-transitioning ptr-pull-up ptr-pull-down"),r.trigger("ptr:done"),n.emit("local::done ptrDone",r[0])}),r.removeClass("ptr-refreshing").addClass("ptr-transitioning"),n},n.refresh=function(){return r.hasClass("ptr-refreshing")?n:(r.addClass("ptr-transitioning ptr-refreshing"),r.trigger("ptr:refresh",n.done),n.emit("local::refresh ptrRefresh",r[0],n.done),n)};var c,d,u,h,f,m,v,g,b={},y=!1,w=!1,$=0,C=!1,x=r.parents(".page");function E(e){if(s){if("android"!==Device.os)return;if("targetTouches"in e&&e.targetTouches.length>1)return}r.hasClass("ptr-refreshing")||$$1(e.target).closest(".sortable-handler").length||(l=!1,g=!1,s=!0,c=void 0,f=void 0,"touchstart"===e.type&&(o=e.targetTouches[0].identifier),b.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,b.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}function S(e){if(s){var t,a,C;if("touchmove"===e.type){if(o&&e.touches)for(var x=0;x<e.touches.length;x+=1)e.touches[x].identifier===o&&(C=e.touches[x]);C||(C=e.targetTouches[0]),t=C.pageX,a=C.pageY}else t=e.pageX,a=e.pageY;if(t&&a)if(void 0===c&&(c=!!(c||Math.abs(a-b.y)>Math.abs(t-b.x))),c){if(h=r[0].scrollTop,void 0===f&&0!==h&&(f=!0),!l){if(r.removeClass("ptr-transitioning"),h>r[0].offsetHeight)return void(s=!1);v&&(m=r.attr("data-ptr-distance")).indexOf("%")>=0&&(m=r[0].offsetHeight*parseInt(m,10)/100),$=r.hasClass("ptr-refreshing")?m:0,w=!(r[0].scrollHeight!==r[0].offsetHeight&&"ios"===Device.os&&!p)}l=!0,(d=a-b.y)>0&&h<=0||h<0?("ios"===Device.os&&parseInt(Device.osVersion.split(".")[0],10)>7&&0===h&&!f&&(w=!0),w&&(e.preventDefault(),u=Math.pow(d,.85)+$,p?i.transform("translate3d(0,"+u+"px,0)").find(".ptr-arrow").transform("rotate("+(d/66*180+100)+"deg)"):r.transform("translate3d(0,"+u+"px,0)")),w&&Math.pow(d,.85)>m||!w&&d>=2*m?(y=!0,r.addClass("ptr-pull-up").removeClass("ptr-pull-down")):(y=!1,r.removeClass("ptr-pull-up").addClass("ptr-pull-down")),g||(r.trigger("ptr:pullstart"),n.emit("local::pullStart ptrPullStart",r[0]),g=!0),r.trigger("ptr:pullmove",{event:e,scrollTop:h,translate:u,touchesDiff:d}),n.emit("local::pullMove ptrPullMove",r[0],{event:e,scrollTop:h,translate:u,touchesDiff:d})):(g=!1,r.removeClass("ptr-pull-up ptr-pull-down"),y=!1)}else s=!1}}function k(e){return"touchend"===e.type&&e.changedTouches&&e.changedTouches.length>0&&o&&e.changedTouches[0].identifier!==o?(s=!1,c=!1,l=!1,void(o=null)):s&&l?(u&&(r.addClass("ptr-transitioning"),u=0),p?i.transform("").find(".ptr-arrow").transform(""):r.transform(""),y?(r.addClass("ptr-refreshing"),r.trigger("ptr:refresh",n.done),n.emit("local::refresh ptrRefresh",r[0],n.done)):r.removeClass("ptr-pull-down"),s=!1,l=!1,void(g&&(r.trigger("ptr:pullend"),n.emit("local::pullEnd ptrPullEnd",r[0])))):(s=!1,void(l=!1))}return(x.find(".navbar").length>0||x.parents(".view").children(".navbar").length>0)&&(C=!0),x.hasClass("no-navbar")&&(C=!1),C||r.addClass("ptr-no-navbar"),r.attr("data-ptr-distance")?v=!0:m=p?66:44,x.length&&r.length?(r[0].f7PullToRefresh=n,n.attachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};r.on(t.touchEvents.start,E,e),t.on("touchmove",S),t.on("touchend:passive",k)},n.detachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};r.off(t.touchEvents.start,E,e),t.off("touchmove",S),t.off("touchend:passive",k)},n.useModules(),n.init(),n):n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy ptrBeforeDestroy",e),e.$el.trigger("ptr:beforedestroy",e),delete e.el.f7PullToRefresh,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),PullToRefresh$1={name:"pullToRefresh",create:function(){var e=this;e.ptr=Utils.extend(ConstructorMethods({defaultSelector:".ptr-content",constructor:PullToRefresh,app:e,domProp:"f7PullToRefresh"}),{done:function(t){var a=e.ptr.get(t);if(a)return a.done()},refresh:function(t){var a=e.ptr.get(t);if(a)return a.refresh()}})},static:{PullToRefresh:PullToRefresh},on:{tabMounted:function(e){var t=this;$$1(e).find(".ptr-content").each(function(e,a){t.ptr.create(a)})},tabBeforeRemove:function(e){var t=this;$$1(e).find(".ptr-content").each(function(e,a){t.ptr.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".ptr-content").each(function(e,a){t.ptr.create(a)})},pageBeforeRemove:function(e){var t=this;e.$el.find(".ptr-content").each(function(e,a){t.ptr.destroy(a)})}}},Lazy={destroy:function(e){var t=$$1(e).closest(".page");t.length&&t[0].f7LazyDestroy&&t[0].f7LazyDestroy()},create:function(e){var t=this,a=$$1(e).closest(".page").eq(0),n=a.find(".lazy");if(0!==n.length||a.hasClass("lazy")){var r=t.params.lazy.placeholder;!1!==r&&n.each(function(e,t){$$1(t).attr("data-src")&&!$$1(t).attr("src")&&$$1(t).attr("src",r)});var i=[],o=!1;a[0].f7LazyDestroy||(a[0].f7LazyDestroy=function(){a[0].f7LazyAttached=!1,delete a[0].f7LazyAttached,a.off("lazy",l),a.off("scroll",l,!0),a.find(".tab").off("tab:mounted tab:show",l),t.off("resize",l)}),a[0].f7LazyAttached||(a[0].f7LazyAttached=!0,a.on("lazy",l),a.on("scroll",l,!0),a.find(".tab").on("tab:mounted tab:show",l),t.on("resize",l)),l()}function s(e){i.indexOf(e)>=0&&i.splice(i.indexOf(e),1),o=!1,t.params.lazy.sequential&&i.length>0&&(o=!0,t.lazy.loadImage(i[0],s))}function l(){t.lazy.load(a,function(e){t.params.lazy.sequential&&o?i.indexOf(e)<0&&i.push(e):(o=!0,t.lazy.loadImage(e,s))})}},isInViewport:function(e){var t=e.getBoundingClientRect(),a=this.params.lazy.threshold||0;return t.top>=0-a&&t.left>=0-a&&t.top<=this.height+a&&t.left<=this.width+a},loadImage:function(e,t){var a=this,n=$$1(e),r=n.attr("data-background"),i=r||n.attr("data-src");if(i){var o=new win.Image;o.onload=function(){n.removeClass("lazy").addClass("lazy-loaded"),r?n.css("background-image","url("+i+")"):n.attr("src",i),t&&t(e),n.trigger("lazy:loaded"),a.emit("lazyLoaded",n[0])},o.onerror=function(){n.removeClass("lazy").addClass("lazy-loaded"),r?n.css("background-image","url("+(a.params.lazy.placeholder||"")+")"):n.attr("src",a.params.lazy.placeholder||""),t&&t(e),n.trigger("lazy:error"),a.emit("lazyError",n[0])},o.src=i,n.removeAttr("data-src").removeAttr("data-background"),n.trigger("lazy:load"),a.emit("lazyLoad",n[0])}},load:function(e,t){var a=this,n=$$1(e);n.hasClass("page")||(n=n.parents(".page").eq(0)),0!==n.length&&n.find(".lazy").each(function(e,n){$$1(n).parents(".tab:not(.tab-active)").length>0||a.lazy.isInViewport(n)&&(t?t(n):a.lazy.loadImage(n))})}},Lazy$1={name:"lazy",params:{lazy:{placeholder:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABAQMAAAAl21bKAAAAA1BMVEXCwsK592mkAAAACklEQVQI12NgAAAAAgAB4iG8MwAAAABJRU5ErkJggg==",threshold:0,sequential:!0}},create:function(){Utils.extend(this,{lazy:{create:Lazy.create.bind(this),destroy:Lazy.destroy.bind(this),loadImage:Lazy.loadImage.bind(this),load:Lazy.load.bind(this),isInViewport:Lazy.isInViewport.bind(this)}})},on:{pageInit:function(e){(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.create(e.$el)},pageAfterIn:function(e){(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.create(e.$el)},pageBeforeRemove:function(e){(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.destroy(e.$el)},tabMounted:function(e){var t=$$1(e);(t.find(".lazy").length>0||t.hasClass("lazy"))&&this.lazy.create(t)},tabBeforeRemove:function(e){var t=$$1(e);(t.find(".lazy").length>0||t.hasClass("lazy"))&&this.lazy.destroy(t)}}},DataTable=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this,r={};n.useModulesParams(r),n.params=Utils.extend(r,a);var i=$$1(n.params.el);if(0!==i.length){if(n.$el=i,n.el=i[0],n.$el[0].f7DataTable){var o=n.$el[0].f7DataTable;return n.destroy(),o}return n.$el[0].f7DataTable=n,Utils.extend(n,{collapsible:i.hasClass("data-table-collapsible"),$headerEl:i.find(".data-table-header"),$headerSelectedEl:i.find(".data-table-header-selected")}),n.attachEvents=function(){n.$el.on("change",'.checkbox-cell input[type="checkbox"]',s),n.$el.find("thead .sortable-cell").on("click",l)},n.detachEvents=function(){n.$el.off("change",'.checkbox-cell input[type="checkbox"]',s),n.$el.find("thead .sortable-cell").off("click",l)},n.useModules(),n.init(),n}function s(e){if(!e.detail||!e.detail.sentByF7DataTable){var t=$$1(this),a=t[0].checked,r=t.parents("td,th").index();t.parents("thead").length>0?(0===r&&i.find("tbody tr")[a?"addClass":"removeClass"]("data-table-row-selected"),i.find("tbody tr td:nth-child("+(r+1)+") input").prop("checked",a).trigger("change",{sentByF7DataTable:!0})):(0===r&&t.parents("tr")[a?"addClass":"removeClass"]("data-table-row-selected"),a?i.find("tbody .checkbox-cell:nth-child("+(r+1)+') input[type="checkbox"]:checked').length===i.find("tbody tr").length&&i.find("thead .checkbox-cell:nth-child("+(r+1)+') input[type="checkbox"]').prop("checked",!0).trigger("change",{sentByF7DataTable:!0}):i.find("thead .checkbox-cell:nth-child("+(r+1)+') input[type="checkbox"]').prop("checked",!1)),n.checkSelectedHeader()}}function l(){var e,t=$$1(this),a=t.hasClass("sortable-cell-active"),r=t.hasClass("sortable-desc")?"desc":"asc";a?(e="desc"===r?"asc":"desc",t.removeClass("sortable-desc sortable-asc").addClass("sortable-"+e)):(i.find("thead .sortable-cell-active").removeClass("sortable-cell-active"),t.addClass("sortable-cell-active"),e=r),t.trigger("datatable:sort",e),n.emit("local::sort dataTableSort",n,e)}}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.setCollapsibleLabels=function(){var e=this;e.collapsible&&e.$el.find("tbody td:not(.checkbox-cell)").each(function(t,a){var n=$$1(a),r=n.index(),i=n.attr("data-collapsible-title");i||""===i||n.attr("data-collapsible-title",e.$el.find("thead th").eq(r).text())})},t.prototype.checkSelectedHeader=function(){if(this.$headerEl.length>0&&this.$headerSelectedEl.length>0){var e=this.$el.find("tbody .checkbox-cell input:checked").length;this.$el[e>0?"addClass":"removeClass"]("data-table-has-checked"),this.$headerSelectedEl.find(".data-table-selected-count").text(e)}},t.prototype.init=function(){this.attachEvents(),this.setCollapsibleLabels(),this.checkSelectedHeader()},t.prototype.destroy=function(){var e=this;e.$el.trigger("datatable:beforedestroy",e),e.emit("local::beforeDestroy datatableBeforeDestroy",e),e.attachEvents(),e.$el[0].f7DataTable=null,delete e.$el[0].f7DataTable,Utils.deleteProps(e),e=null},t}(Framework7Class),DataTable$1={name:"dataTable",static:{DataTable:DataTable},create:function(){this.dataTable=ConstructorMethods({defaultSelector:".data-table",constructor:DataTable,app:this,domProp:"f7DataTable"})},on:{tabBeforeRemove:function(e){var t=this;$$1(e).find(".data-table-init").each(function(e,a){t.dataTable.destroy(a)})},tabMounted:function(e){var t=this;$$1(e).find(".data-table-init").each(function(e,a){t.dataTable.create({el:a})})},pageBeforeRemove:function(e){var t=this;e.$el.find(".data-table-init").each(function(e,a){t.dataTable.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".data-table-init").each(function(e,a){t.dataTable.create({el:a})})}},clicks:{}},Fab={morphOpen:function(e,t){var a=this,n=$$1(e),r=$$1(t);if(0!==r.length){r.transition(0).addClass("fab-morph-target-visible");var i={width:r[0].offsetWidth,height:r[0].offsetHeight,offset:r.offset(),borderRadius:r.css("border-radius"),zIndex:r.css("z-index")},o={width:n[0].offsetWidth,height:n[0].offsetHeight,offset:n.offset(),translateX:Utils.getTranslate(n[0],"x"),translateY:Utils.getTranslate(n[0],"y")};n[0].f7FabMorphData={$targetEl:r,target:i,fab:o};var s=o.offset.left+o.width/2-(i.offset.left+i.width/2)-o.translateX,l=o.offset.top+o.height/2-(i.offset.top+i.height/2)-o.translateY,p=i.width/o.width,c=i.height/o.height,d=Math.ceil(parseInt(i.borderRadius,10)/Math.max(p,c));d>0&&(d+=2),n[0].f7FabMorphResizeHandler=function(){n.transition(0).transform(""),r.transition(0),i.width=r[0].offsetWidth,i.height=r[0].offsetHeight,i.offset=r.offset(),o.offset=n.offset();var e=o.offset.left+o.width/2-(i.offset.left+i.width/2)-o.translateX,t=o.offset.top+o.height/2-(i.offset.top+i.height/2)-o.translateY,a=i.width/o.width,s=i.height/o.height;n.transform("translate3d("+-e+"px, "+-t+"px, 0) scale("+a+", "+s+")")},r.css("opacity",0).transform("scale("+1/p+", "+1/c+")"),n.addClass("fab-opened").css("z-index",i.zIndex-1).transform("translate3d("+-s+"px, "+-l+"px, 0)"),n.transitionEnd(function(){r.transition(""),Utils.nextTick(function(){r.css("opacity",1).transform("scale(1,1)")}),n.transform("translate3d("+-s+"px, "+-l+"px, 0) scale("+p+", "+c+")").css("border-radius",d+"px").css("box-shadow","none"),a.on("resize",n[0].f7FabMorphResizeHandler),r.parents(".page-content").length>0&&r.parents(".page-content").on("scroll",n[0].f7FabMorphResizeHandler)})}},morphClose:function(e){var t=$$1(e),a=t[0].f7FabMorphData;if(a){var n=a.$targetEl,r=a.target,i=a.fab;if(0!==n.length){var o=i.offset.left+i.width/2-(r.offset.left+r.width/2)-i.translateX,s=i.offset.top+i.height/2-(r.offset.top+r.height/2)-i.translateY,l=r.width/i.width,p=r.height/i.height;this.off("resize",t[0].f7FabMorphResizeHandler),n.parents(".page-content").length>0&&n.parents(".page-content").off("scroll",t[0].f7FabMorphResizeHandler),n.css("opacity",0).transform("scale("+1/l+", "+1/p+")"),t.transition("").css("box-shadow","").css("border-radius","").transform("translate3d("+-o+"px, "+-s+"px, 0)"),t.transitionEnd(function(){t.css("z-index","").removeClass("fab-opened").transform(""),Utils.nextTick(function(){t.transitionEnd(function(){n.removeClass("fab-morph-target-visible").css("opacity","").transform("").transition("")})})})}}},open:function(e,t){var a=$$1(e).eq(0),n=a.find(".fab-buttons");if(a.length&&!a.hasClass("fab-opened")&&(n.length||a.hasClass("fab-morph"))){if(this.fab.openedEl){if(this.fab.openedEl===a[0])return;this.fab.close(this.fab.openedEl)}this.fab.openedEl=a[0],a.hasClass("fab-morph")?this.fab.morphOpen(a,t||a.attr("data-morph-to")):a.addClass("fab-opened"),a.trigger("fab:open")}},close:function(e){void 0===e&&(e=".fab-opened");var t=$$1(e).eq(0),a=t.find(".fab-buttons");t.length&&t.hasClass("fab-opened")&&(a.length||t.hasClass("fab-morph"))&&(this.fab.openedEl=null,t.hasClass("fab-morph")?this.fab.morphClose(t):t.removeClass("fab-opened"),t.trigger("fab:close"))},toggle:function(e){$$1(e).hasClass("fab-opened")?this.fab.close(e):this.fab.open(e)}},Fab$1={name:"fab",create:function(){Utils.extend(this,{fab:{openedEl:null,morphOpen:Fab.morphOpen.bind(this),morphClose:Fab.morphClose.bind(this),open:Fab.open.bind(this),close:Fab.close.bind(this),toggle:Fab.toggle.bind(this)}})},clicks:{".fab > a":function(e){this.fab.toggle(e.parents(".fab"))},".fab-open":function(e,t){void 0===t&&(t={});this.fab.open(t.fab)},".fab-close":function(e,t){void 0===t&&(t={});this.fab.close(t.fab)}}},Searchbar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this,r={el:void 0,inputEl:void 0,disableButton:!0,disableButtonEl:void 0,backdropEl:void 0,searchContainer:void 0,searchItem:"li",searchIn:void 0,ignore:".searchbar-ignore",foundEl:".searchbar-found",notFoundEl:".searchbar-not-found",hideOnEnableEl:".searchbar-hide-on-enable",hideOnSearchEl:".searchbar-hide-on-search",backdrop:!0,removeDiacritics:!0,customSearch:!1,hideDividers:!0,hideGroups:!0,disableOnBackdropClick:!0,expandable:!1};n.useModulesParams(r),n.params=Utils.extend(r,a);var i,o,s,l,p,c,d,u,h,f,m=$$1(n.params.el);if(0===m.length)return n;if(m[0].f7Searchbar=n,m.parents(".page").length>0)i=m.parents(".page");else if((o=m.parents(".navbar-inner")).length>0)if(o[0].f7Page)i=o[0].f7Page.$el;else{var v=m.parents(".view").find(".page-current");v[0]&&v[0].f7Page&&v[0].f7Page.navbarEl===o[0]&&(i=v)}function g(e){e.preventDefault()}function b(e){n.enable(e),n.$el.addClass("searchbar-focused")}function y(){n.$el.removeClass("searchbar-focused")}function w(){var e=n.$inputEl.val().trim();(n.$searchContainer&&n.$searchContainer.length>0&&(n.params.searchIn||n.isVirtualList||n.params.searchIn===n.params.searchItem)||n.params.customSearch)&&n.search(e,!0)}function $(e,t){n.$el.trigger("searchbar:clear",t),n.emit("local::clear searchbarClear",n,t)}function C(e){n.disable(e)}function x(){!n||n&&!n.$el||n.enabled&&n.$el.removeClass("searchbar-enabled")}function E(){!n||n&&!n.$el||n.enabled&&n.$el.addClass("searchbar-enabled")}return a.foundEl?s=$$1(a.foundEl):"string"==typeof n.params.foundEl&&i&&(s=i.find(n.params.foundEl)),a.notFoundEl?l=$$1(a.notFoundEl):"string"==typeof n.params.notFoundEl&&i&&(l=i.find(n.params.notFoundEl)),a.hideOnEnableEl?p=$$1(a.hideOnEnableEl):"string"==typeof n.params.hideOnEnableEl&&i&&(p=i.find(n.params.hideOnEnableEl)),a.hideOnSearchEl?c=$$1(a.hideOnSearchEl):"string"==typeof n.params.hideOnSearchEl&&i&&(c=i.find(n.params.hideOnSearchEl)),n.params.backdrop&&0===(d=n.params.backdropEl?$$1(n.params.backdropEl):i&&i.length>0?i.find(".searchbar-backdrop"):m.siblings(".searchbar-backdrop")).length&&(d=$$1('<div class="searchbar-backdrop"></div>'),i&&i.length?m.parents(i).length>0&&o&&0===m.parents(o).length?d.insertBefore(m):d.insertBefore(i.find(".page-content").eq(0)):d.insertBefore(m)),n.params.searchContainer&&(u=$$1(n.params.searchContainer)),h=n.params.inputEl?$$1(n.params.inputEl):m.find('input[type="search"]').eq(0),n.params.disableButton&&(f=n.params.disableButtonEl?$$1(n.params.disableButtonEl):m.find(".searchbar-disable-button")),Utils.extend(n,{app:t,view:t.views.get(m.parents(".view")),$el:m,el:m[0],$backdropEl:d,backdropEl:d&&d[0],$searchContainer:u,searchContainer:u&&u[0],$inputEl:h,inputEl:h[0],$disableButtonEl:f,disableButtonEl:f&&f[0],disableButtonHasMargin:!1,$pageEl:i,pageEl:i&&i[0],$navbarEl:o,navbarEl:o&&o[0],$foundEl:s,foundEl:s&&s[0],$notFoundEl:l,notFoundEl:l&&l[0],$hideOnEnableEl:p,hideOnEnableEl:p&&p[0],$hideOnSearchEl:c,hideOnSearchEl:c&&c[0],previousQuery:"",query:"",isVirtualList:u&&u.hasClass("virtual-list"),virtualList:void 0,enabled:!1,expandable:n.params.expandable||m.hasClass("searchbar-expandable")}),n.attachEvents=function(){m.on("submit",g),n.params.disableButton&&n.$disableButtonEl.on("click",C),n.params.disableOnBackdropClick&&n.$backdropEl&&n.$backdropEl.on("click",C),n.expandable&&"ios"===t.theme&&n.view&&o&&n.$pageEl&&(n.$pageEl.on("page:beforeout",x),n.$pageEl.on("page:beforein",E)),n.$inputEl.on("focus",b),n.$inputEl.on("blur",y),n.$inputEl.on("change input compositionend",w),n.$inputEl.on("input:clear",$)},n.detachEvents=function(){m.off("submit",g),n.params.disableButton&&n.$disableButtonEl.off("click",C),n.params.disableOnBackdropClick&&n.$backdropEl&&n.$backdropEl.off("click",C),n.expandable&&"ios"===t.theme&&n.view&&o&&n.$pageEl&&(n.$pageEl.on("page:beforeout",x),n.$pageEl.on("page:beforein",E)),n.$inputEl.off("focus",b),n.$inputEl.off("blur",y),n.$inputEl.off("change input compositionend",w),n.$inputEl.off("input:clear",$)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.clear=function(e){if(!this.query&&e&&$$1(e.target).hasClass("searchbar-clear"))return this.disable(),this;var t=this.value;return this.$inputEl.val("").trigger("change").focus(),this.$el.trigger("searchbar:clear",t),this.emit("local::clear searchbarClear",this,t),this},t.prototype.setDisableButtonMargin=function(){if(!this.expandable){var e=this.app;this.$disableButtonEl.transition(0).show(),this.$disableButtonEl.css("margin-"+(e.rtl?"left":"right"),-this.disableButtonEl.offsetWidth+"px"),this._clientLeft=this.$disableButtonEl[0].clientLeft,this.$disableButtonEl.transition(""),this.disableButtonHasMargin=!0}},t.prototype.enable=function(e){var t=this;if(t.enabled)return t;var a=t.app;function n(){t.$backdropEl&&(t.$searchContainer&&t.$searchContainer.length||t.params.customSearch)&&!t.$el.hasClass("searchbar-enabled")&&!t.query&&t.backdropShow(),t.$el.addClass("searchbar-enabled"),!t.expandable&&t.$disableButtonEl&&t.$disableButtonEl.length>0&&"ios"===a.theme&&(t.disableButtonHasMargin||t.setDisableButtonMargin(),t.$disableButtonEl.css("margin-"+(a.rtl?"left":"right"),"0px")),t.$hideOnEnableEl&&t.$hideOnEnableEl.addClass("hidden-by-searchbar"),t.$el.trigger("searchbar:enable"),t.emit("local::enable searchbarEnable",t)}t.enabled=!0;var r=!1;return!0===e&&doc.activeElement!==t.inputEl&&(r=!0),a.device.ios&&"ios"===a.theme?t.expandable?(r&&t.$inputEl.focus(),n()):(r&&t.$inputEl.focus(),!e||"focus"!==e.type&&!0!==e?n():Utils.nextTick(function(){n()},400)):(r&&t.$inputEl.focus(),"md"===a.theme&&t.expandable&&t.$el.parents(".page, .view, .navbar-inner").scrollLeft(0),n()),t},t.prototype.disable=function(){var e=this;if(!e.enabled)return e;var t=e.app;return e.$inputEl.val("").trigger("change"),e.$el.removeClass("searchbar-enabled"),e.$el.removeClass("searchbar-focused"),!e.expandable&&e.$disableButtonEl&&e.$disableButtonEl.length>0&&"ios"===t.theme&&e.$disableButtonEl.css("margin-"+(t.rtl?"left":"right"),-e.disableButtonEl.offsetWidth+"px"),e.$backdropEl&&(e.$searchContainer&&e.$searchContainer.length||e.params.customSearch)&&e.backdropHide(),e.enabled=!1,e.$inputEl.blur(),e.$hideOnEnableEl&&e.$hideOnEnableEl.removeClass("hidden-by-searchbar"),e.$el.trigger("searchbar:disable"),e.emit("local::disable searchbarDisable",e),e},t.prototype.toggle=function(){return this.enabled?this.disable():this.enable(!0),this},t.prototype.backdropShow=function(){return this.$backdropEl&&this.$backdropEl.addClass("searchbar-backdrop-in"),this},t.prototype.backdropHide=function(){return this.$backdropEl&&this.$backdropEl.removeClass("searchbar-backdrop-in"),this},t.prototype.search=function(e,t){var a=this;if(a.previousQuery&&e.trim()===a.previousQuery)return a;if(void 0!==a.previousQuery&&""===a.previousQuery.trim()&&""===e.trim())return a;a.previousQuery=e.trim(),t||(a.enabled||a.enable(),a.$inputEl.val(e)),a.query=e,a.value=e;var n=a.$searchContainer,r=a.$el,i=a.$backdropEl,o=a.$foundEl,s=a.$notFoundEl,l=a.$hideOnSearchEl,p=a.isVirtualList;if(e.length>0&&l?l.addClass("hidden-by-searchbar"):l&&l.removeClass("hidden-by-searchbar"),0===e.length?n&&n.length&&r.hasClass("searchbar-enabled")&&i&&a.backdropShow():n&&n.length&&r.hasClass("searchbar-enabled")&&a.backdropHide(),a.params.customSearch)return r.trigger("searchbar:search",e,a.previousQuery),a.emit("local::search searchbarSearch",a,e,a.previousQuery),a;var c,d=[];if(p){if(a.virtualList=n[0].f7VirtualList,""===e.trim())return a.virtualList.resetFilter(),s&&s.hide(),o&&o.show(),a;if(c=a.params.removeDiacritics?Utils.removeDiacritics(e):e,a.virtualList.params.searchAll)d=a.virtualList.params.searchAll(c,a.virtualList.items)||[];else if(a.virtualList.params.searchByItem)for(var u=0;u<a.virtualList.items.length;u+=1)a.virtualList.params.searchByItem(c,a.virtualList.params.items[u],u)&&d.push(u)}else{var h;h=a.params.removeDiacritics?Utils.removeDiacritics(e.trim().toLowerCase()).split(" "):e.trim().toLowerCase().split(" "),n.find(a.params.searchItem).removeClass("hidden-by-searchbar").each(function(e,t){var n=$$1(t),r=[],i=a.params.searchIn?n.find(a.params.searchIn):n;a.params.searchIn===a.params.searchItem&&(i=n),i.each(function(e,t){var n=$$1(t).text().trim().toLowerCase();a.params.removeDiacritics&&(n=Utils.removeDiacritics(n)),r.push(n)}),r=r.join(" ");for(var o=0,s=0;s<h.length;s+=1)r.indexOf(h[s])>=0&&(o+=1);o===h.length||a.params.ignore&&n.is(a.params.ignore)?d.push(n[0]):n.addClass("hidden-by-searchbar")}),a.params.hideDividers&&n.find(".item-divider, .list-group-title").each(function(e,t){for(var n=$$1(t),r=n.nextAll("li"),i=!0,o=0;o<r.length;o+=1){var s=r.eq(o);if(s.hasClass("list-group-title")||s.hasClass("item-divider"))break;s.hasClass("hidden-by-searchbar")||(i=!1)}var l=a.params.ignore&&n.is(a.params.ignore);i&&!l?n.addClass("hidden-by-searchbar"):n.removeClass("hidden-by-searchbar")}),a.params.hideGroups&&n.find(".list-group").each(function(e,t){var n=$$1(t),r=a.params.ignore&&n.is(a.params.ignore);0!==n.find("li:not(.hidden-by-searchbar)").length||r?n.removeClass("hidden-by-searchbar"):n.addClass("hidden-by-searchbar")})}return 0===d.length?(s&&s.show(),o&&o.hide()):(s&&s.hide(),o&&o.show()),p&&a.virtualList&&a.virtualList.filterItems(d),r.trigger("searchbar:search",e,a.previousQuery,d),a.emit("local::search searchbarSearch",a,e,a.previousQuery,d),a},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){this.emit("local::beforeDestroy searchbarBeforeDestroy",this),this.$el.trigger("searchbar:beforedestroy",this),this.detachEvents(),delete this.$el.f7Searchbar,Utils.deleteProps(this)},t}(Framework7Class),Searchbar$1={name:"searchbar",static:{Searchbar:Searchbar},create:function(){this.searchbar=ConstructorMethods({defaultSelector:".searchbar",constructor:Searchbar,app:this,domProp:"f7Searchbar",addMethods:"clear enable disable toggle search".split(" ")})},on:{tabMounted:function(e){var t=this;$$1(e).find(".searchbar-init").each(function(e,a){var n=$$1(a);t.searchbar.create(Utils.extend(n.dataset(),{el:a}))})},tabBeforeRemove:function(e){$$1(e).find(".searchbar-init").each(function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()})},pageInit:function(e){var t=this;e.$el.find(".searchbar-init").each(function(e,a){var n=$$1(a);t.searchbar.create(Utils.extend(n.dataset(),{el:a}))}),"ios"===t.theme&&e.view&&e.view.router.separateNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each(function(e,a){var n=$$1(a);t.searchbar.create(Utils.extend(n.dataset(),{el:a}))})},pageBeforeRemove:function(e){e.$el.find(".searchbar-init").each(function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()}),"ios"===this.theme&&e.view&&e.view.router.separateNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each(function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()})}},clicks:{".searchbar-clear":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.clear()},".searchbar-enable":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.enable(!0)},".searchbar-disable":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.disable()},".searchbar-toggle":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.toggle()}}},Messages=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n={autoLayout:!0,messages:[],newMessagesFirst:!1,scrollMessages:!0,scrollMessagesOnEdge:!0,firstMessageRule:void 0,lastMessageRule:void 0,tailMessageRule:void 0,sameNameMessageRule:void 0,sameHeaderMessageRule:void 0,sameFooterMessageRule:void 0,sameAvatarMessageRule:void 0,customClassMessageRule:void 0,renderMessage:void 0};this.useModulesParams(n),this.params=Utils.extend(n,a);var r=$$1(a.el).eq(0);if(0===r.length)return this;r[0].f7Messages=this;var i=r.closest(".page-content").eq(0);return Utils.extend(this,{messages:this.params.messages,$el:r,el:r[0],$pageContentEl:i,pageContentEl:i[0]}),this.useModules(),this.init(),this}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.getMessageData=function(e){var t=$$1(e),a={name:t.find(".message-name").html(),header:t.find(".message-header").html(),textHeader:t.find(".message-text-header").html(),textFooter:t.find(".message-text-footer").html(),footer:t.find(".message-footer").html(),isTitle:t.hasClass("messages-title"),type:t.hasClass("message-sent")?"sent":"received",text:t.find(".message-text").html(),image:t.find(".message-image").html(),imageSrc:t.find(".message-image img").attr("src"),typing:t.hasClass("message-typing")};a.isTitle&&(a.text=t.html()),a.text&&a.textHeader&&(a.text=a.text.replace('<div class="message-text-header">'+a.textHeader+"</div>","")),a.text&&a.textFooter&&(a.text=a.text.replace('<div class="message-text-footer">'+a.textFooter+"</div>",""));var n=t.find(".message-avatar").css("background-image");return"none"!==n&&""!==n||(n=void 0),n=n&&"string"==typeof n?n.replace("url(","").replace(")","").replace(/"/g,"").replace(/'/g,""):void 0,a.avatar=n,a},t.prototype.getMessagesData=function(){var e=this,t=[];return e.$el.find(".message, .messages-title").each(function(a,n){t.push(e.getMessageData(n))}),t},t.prototype.renderMessage=function(e){var t=Utils.extend({type:"sent"},e);return this.params.renderMessage?this.params.renderMessage.call(this,t):t.isTitle?'<div class="messages-title">'+t.text+"</div>":'\n      <div class="message message-'+t.type+" "+(t.isTyping?"message-typing":"")+'">\n        '+(t.avatar?'\n        <div class="message-avatar" style="background-image:url('+t.avatar+')"></div>\n        ':"")+'\n        <div class="message-content">\n          '+(t.name?'<div class="message-name">'+t.name+"</div>":"")+"\n          "+(t.header?'<div class="message-header">'+t.header+"</div>":"")+'\n          <div class="message-bubble">\n            '+(t.textHeader?'<div class="message-text-header">'+t.textHeader+"</div>":"")+"\n            "+(t.image?'<div class="message-image">'+t.image+"</div>":"")+"\n            "+(t.imageSrc&&!t.image?'<div class="message-image"><img src="'+t.imageSrc+'"></div>':"")+"\n            "+(t.text||t.isTyping?'<div class="message-text">'+(t.text||"")+(t.isTyping?'<div class="message-typing-indicator"><div></div><div></div><div></div></div>':"")+"</div>":"")+"\n            "+(t.textFooter?'<div class="message-text-footer">'+t.textFooter+"</div>":"")+"\n          </div>\n          "+(t.footer?'<div class="message-footer">'+t.footer+"</div>":"")+"\n        </div>\n      </div>\n    "},t.prototype.renderMessages=function(e,t){void 0===e&&(e=this.messages),void 0===t&&(t=this.params.newMessagesFirst?"prepend":"append");var a=this,n=e.map(function(e){return a.renderMessage(e)}).join("");a.$el[t](n)},t.prototype.isFirstMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.firstMessageRule&&(e=this.params).firstMessageRule.apply(e,t)},t.prototype.isLastMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.lastMessageRule&&(e=this.params).lastMessageRule.apply(e,t)},t.prototype.isTailMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.tailMessageRule&&(e=this.params).tailMessageRule.apply(e,t)},t.prototype.isSameNameMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.sameNameMessageRule&&(e=this.params).sameNameMessageRule.apply(e,t)},t.prototype.isSameHeaderMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.sameHeaderMessageRule&&(e=this.params).sameHeaderMessageRule.apply(e,t)},t.prototype.isSameFooterMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.sameFooterMessageRule&&(e=this.params).sameFooterMessageRule.apply(e,t)},t.prototype.isSameAvatarMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];return!!this.params.sameAvatarMessageRule&&(e=this.params).sameAvatarMessageRule.apply(e,t)},t.prototype.isCustomClassMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];if(this.params.customClassMessageRule)return(e=this.params).customClassMessageRule.apply(e,t)},t.prototype.layout=function(){var e=this;e.$el.find(".message, .messages-title").each(function(t,a){var n=$$1(a);e.messages||(e.messages=e.getMessagesData());var r=[],i=e.messages[t],o=e.messages[t-1],s=e.messages[t+1];e.isFirstMessage(i,o,s)&&r.push("message-first"),e.isLastMessage(i,o,s)&&r.push("message-last"),e.isTailMessage(i,o,s)&&r.push("message-tail"),e.isSameNameMessage(i,o,s)&&r.push("message-same-name"),e.isSameHeaderMessage(i,o,s)&&r.push("message-same-header"),e.isSameFooterMessage(i,o,s)&&r.push("message-same-footer"),e.isSameAvatarMessage(i,o,s)&&r.push("message-same-avatar");var l=e.isCustomClassMessage(i,o,s);l&&l.length&&("string"==typeof l&&(l=l.split(" ")),l.forEach(function(e){r.push(e)})),n.removeClass("message-first message-last message-tail message-same-name message-same-header message-same-footer message-same-avatar"),r.forEach(function(e){n.addClass(e)})})},t.prototype.clear=function(){this.messages=[],this.$el.html("")},t.prototype.removeMessage=function(e,t){void 0===t&&(t=!0);var a,n,r=this;return"number"==typeof e?(a=e,n=r.$el.find(".message, .messages-title").eq(a)):r.messages&&r.messages.indexOf(e)>=0?(a=r.messages.indexOf(e),n=r.$el.children().eq(a)):a=(n=$$1(e)).index(),0===n.length?r:(n.remove(),r.messages.splice(a,1),r.params.autoLayout&&t&&r.layout(),r)},t.prototype.removeMessages=function(e,t){void 0===t&&(t=!0);var a=this;if(Array.isArray(e)){var n=[];e.forEach(function(e){n.push(a.$el.find(".message, .messages-title").eq(e))}),n.forEach(function(e){a.removeMessage(e,!1)})}else $$1(e).each(function(e,t){a.removeMessage(t,!1)});return a.params.autoLayout&&t&&a.layout(),a},t.prototype.addMessage=function(){for(var e,t,a=[],n=arguments.length;n--;)a[n]=arguments[n];var r,i,o;return"boolean"==typeof a[1]?(r=(e=a)[0],i=e[1],o=e[2]):(r=(t=a)[0],o=t[1],i=t[2]),void 0===i&&(i=!0),void 0===o&&(o=this.params.newMessagesFirst?"prepend":"append"),this.addMessages([r],i,o)},t.prototype.addMessages=function(){for(var e,t,a=[],n=arguments.length;n--;)a[n]=arguments[n];var r,i,o,s=this;"boolean"==typeof a[1]?(r=(e=a)[0],i=e[1],o=e[2]):(r=(t=a)[0],o=t[1],i=t[2]),void 0===i&&(i=!0),void 0===o&&(o=s.params.newMessagesFirst?"prepend":"append");var l=s.pageContentEl.scrollHeight,p=s.pageContentEl.offsetHeight,c=s.pageContentEl.scrollTop,d="",u=s.messages.filter(function(e){return e.isTyping})[0];r.forEach(function(e){u?"append"===o?s.messages.splice(s.messages.indexOf(u),0,e):s.messages.splice(s.messages.indexOf(u)+1,0,e):s.messages["append"===o?"push":"unshift"](e),d+=s.renderMessage(e)});var h=$$1(d);if(i&&("append"!==o||s.params.newMessagesFirst||h.addClass("message-appear-from-bottom"),"prepend"===o&&s.params.newMessagesFirst&&h.addClass("message-appear-from-top")),u?"append"===o?h.insertBefore(s.$el.find(".message-typing")):h.insertAfter(s.$el.find(".message-typing")):s.$el[o](h),s.params.autoLayout&&s.layout(),"prepend"!==o||u||(s.pageContentEl.scrollTop=c+(s.pageContentEl.scrollHeight-l)),s.params.scrollMessages&&("append"===o&&!s.params.newMessagesFirst||"prepend"===o&&s.params.newMessagesFirst&&!u))if(s.params.scrollMessagesOnEdge){var f=!1;s.params.newMessagesFirst&&0===c&&(f=!0),!s.params.newMessagesFirst&&c-(l-p)>=-10&&(f=!0),f&&s.scroll(i?void 0:0)}else s.scroll(i?void 0:0);return s},t.prototype.showTyping=function(e){void 0===e&&(e={});var t=this.messages.filter(function(e){return e.isTyping})[0];return t&&this.removeMessage(this.messages.indexOf(t)),this.addMessage(Utils.extend({type:"received",isTyping:!0},e)),this},t.prototype.hideTyping=function(){var e,t;if(this.messages.forEach(function(t,a){t.isTyping&&(e=a)}),void 0!==e&&this.$el.find(".message").eq(e).hasClass("message-typing")&&(t=!0,this.removeMessage(e)),!t){var a=this.$el.find(".message-typing");a.length&&this.removeMessage(a)}return this},t.prototype.scroll=function(e,t){void 0===e&&(e=300);var a,n=this.pageContentEl.scrollTop;if(void 0!==t)a=t;else if((a=this.params.newMessagesFirst?0:this.pageContentEl.scrollHeight-this.pageContentEl.offsetHeight)===n)return this;return this.$pageContentEl.scrollTop(a,e),this},t.prototype.init=function(){var e=this;e.messages&&0!==e.messages.length||(e.messages=e.getMessagesData()),e.params.messages&&e.params.messages.length&&e.renderMessages(),e.params.autoLayout&&e.layout(),e.params.scrollMessages&&e.scroll(0)},t.prototype.destroy=function(){this.emit("local::beforeDestroy messagesBeforeDestroy",this),this.$el.trigger("messages:beforedestroy",this),this.$el[0].f7Messages=null,delete this.$el[0].f7Messages,Utils.deleteProps(this)},t}(Framework7Class),Messages$1={name:"messages",static:{Messages:Messages},create:function(){this.messages=ConstructorMethods({defaultSelector:".messages",constructor:Messages,app:this,domProp:"f7Messages",addMethods:"renderMessages layout scroll clear removeMessage removeMessages addMessage addMessages".split(" ")})},on:{tabBeforeRemove:function(e){var t=this;$$1(e).find(".messages-init").each(function(e,a){t.messages.destroy(a)})},tabMounted:function(e){var t=this;$$1(e).find(".messages-init").each(function(e,a){t.messages.create({el:a})})},pageBeforeRemove:function(e){var t=this;e.$el.find(".messages-init").each(function(e,a){t.messages.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".messages-init").each(function(e,a){t.messages.create({el:a})})}},clicks:{}},Messagebar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this,r={top:!1,topOffset:0,bottomOffset:0,attachments:[],renderAttachments:void 0,renderAttachment:void 0,maxHeight:null,resizePage:!0};n.useModulesParams(r),n.params=Utils.extend(r,a);var i=$$1(n.params.el);if(0===i.length)return n;i[0].f7Messagebar=n;var o,s=i.parents(".page").eq(0),l=s.find(".page-content").eq(0),p=i.find(".messagebar-area");o=n.params.textareaEl?$$1(n.params.textareaEl):i.find("textarea");var c=i.find(".messagebar-attachments"),d=i.find(".messagebar-sheet");function u(){n.params.resizePage&&n.resizePage()}function h(e){e.preventDefault()}function f(e){var t=$$1(this).index();$$1(e.target).closest(".messagebar-attachment-delete").length?($$1(this).trigger("messagebar:attachmentdelete",t),n.emit("local::attachmentDelete messagebarAttachmentDelete",n,this,t)):($$1(this).trigger("messagebar:attachmentclick",t),n.emit("local::attachmentClick messagebarAttachmentClick",n,this,t))}function m(){n.checkEmptyState(),n.$el.trigger("messagebar:change"),n.emit("local::change messagebarChange",n)}function v(){n.sheetHide(),n.$el.addClass("messagebar-focused"),n.$el.trigger("messagebar:focus"),n.emit("local::focus messagebarFocus",n)}function g(){n.$el.removeClass("messagebar-focused"),n.$el.trigger("messagebar:blur"),n.emit("local::blur messagebarBlur",n)}return n.params.top&&i.addClass("messagebar-top"),Utils.extend(n,{$el:i,el:i[0],$areaEl:p,areaEl:p[0],$textareaEl:o,textareaEl:o[0],$attachmentsEl:c,attachmentsEl:c[0],attachmentsVisible:c.hasClass("messagebar-attachments-visible"),$sheetEl:d,sheetEl:d[0],sheetVisible:d.hasClass("messagebar-sheet-visible"),$pageEl:s,pageEl:s[0],$pageContentEl:l,pageContentEl:l,top:i.hasClass("messagebar-top")||n.params.top,attachments:[]}),n.attachEvents=function(){i.on("textarea:resize",u),i.on("submit",h),i.on("click",".messagebar-attachment",f),o.on("change input",m),o.on("focus",v),o.on("blur",g),t.on("resize",u)},n.detachEvents=function(){i.off("textarea:resize",u),i.off("submit",h),i.off("click",".messagebar-attachment",f),o.off("change input",m),o.off("focus",v),o.off("blur",g),t.off("resize",u)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.focus=function(){return this.$textareaEl.focus(),this},t.prototype.blur=function(){return this.$textareaEl.blur(),this},t.prototype.clear=function(){return this.$textareaEl.val("").trigger("change"),this},t.prototype.getValue=function(){return this.$textareaEl.val().trim()},t.prototype.setValue=function(e){return this.$textareaEl.val(e).trigger("change"),this},t.prototype.setPlaceholder=function(e){return this.$textareaEl.attr("placeholder",e),this},t.prototype.resizePage=function(){var e=this,t=e.params,a=e.$el,n=e.top,r=e.$pageEl,i=e.$pageContentEl,o=e.$areaEl,s=e.$textareaEl,l=e.$sheetEl,p=e.$attachmentsEl,c=a[0].offsetHeight,d=t.maxHeight;if(n);else{var u=parseInt(i.css("padding-bottom"),10),h=c+t.bottomOffset;if(h!==u&&i.length){var f=parseInt(i.css("padding-top"),10),m=i[0].scrollHeight,v=i[0].offsetHeight,g=i[0].scrollTop===m-v;d||(d=r[0].offsetHeight-f-l.outerHeight()-p.outerHeight()-parseInt(o.css("margin-top"),10)-parseInt(o.css("margin-bottom"),10)),s.css("max-height",d+"px"),i.css("padding-bottom",h+"px"),g&&i.scrollTop(i[0].scrollHeight-v),a.trigger("messagebar:resizepage"),e.emit("local::resizePage messagebarResizePage",e)}}},t.prototype.checkEmptyState=function(){var e=this.$el,t=this.$textareaEl.val().trim();t&&t.length?e.addClass("messagebar-with-value"):e.removeClass("messagebar-with-value")},t.prototype.attachmentsCreate=function(e){void 0===e&&(e="");var t=$$1('<div class="messagebar-attachments">'+e+"</div>");return t.insertBefore(this.$textareaEl),Utils.extend(this,{$attachmentsEl:t,attachmentsEl:t[0]}),this},t.prototype.attachmentsShow=function(e){void 0===e&&(e="");return this.$attachmentsEl=this.$el.find(".messagebar-attachments"),0===this.$attachmentsEl.length&&this.attachmentsCreate(e),this.$el.addClass("messagebar-attachments-visible"),this.attachmentsVisible=!0,this.params.resizePage&&this.resizePage(),this},t.prototype.attachmentsHide=function(){return this.$el.removeClass("messagebar-attachments-visible"),this.attachmentsVisible=!1,this.params.resizePage&&this.resizePage(),this},t.prototype.attachmentsToggle=function(){return this.attachmentsVisible?this.attachmentsHide():this.attachmentsShow(),this},t.prototype.renderAttachment=function(e){return this.params.renderAttachment?this.params.renderAttachment.call(this,e):'\n      <div class="messagebar-attachment">\n        <img src="'+e+'">\n        <span class="messagebar-attachment-delete"></span>\n      </div>\n    '},t.prototype.renderAttachments=function(){var e,t=this;e=t.params.renderAttachments?t.params.renderAttachments.call(t,t.attachments):""+t.attachments.map(function(e){return t.renderAttachment(e)}).join(""),0===t.$attachmentsEl.length?t.attachmentsCreate(e):t.$attachmentsEl.html(e)},t.prototype.sheetCreate=function(e){void 0===e&&(e="");var t=$$1('<div class="messagebar-sheet">'+e+"</div>");return this.$el.append(t),Utils.extend(this,{$sheetEl:t,sheetEl:t[0]}),this},t.prototype.sheetShow=function(e){void 0===e&&(e="");return this.$sheetEl=this.$el.find(".messagebar-sheet"),0===this.$sheetEl.length&&this.sheetCreate(e),this.$el.addClass("messagebar-sheet-visible"),this.sheetVisible=!0,this.params.resizePage&&this.resizePage(),this},t.prototype.sheetHide=function(){return this.$el.removeClass("messagebar-sheet-visible"),this.sheetVisible=!1,this.params.resizePage&&this.resizePage(),this},t.prototype.sheetToggle=function(){return this.sheetVisible?this.sheetHide():this.sheetShow(),this},t.prototype.init=function(){return this.attachEvents(),this.checkEmptyState(),this},t.prototype.destroy=function(){this.emit("local::beforeDestroy messagebarBeforeDestroy",this),this.$el.trigger("messagebar:beforedestroy",this),this.detachEvents(),this.$el[0].f7Messagebar=null,delete this.$el[0].f7Messagebar,Utils.deleteProps(this)},t}(Framework7Class),Messagebar$1={name:"messagebar",static:{Messagebar:Messagebar},create:function(){this.messagebar=ConstructorMethods({defaultSelector:".messagebar",constructor:Messagebar,app:this,domProp:"f7Messagebar",addMethods:"clear getValue setValue setPlaceholder resizePage focus blur attachmentsCreate attachmentsShow attachmentsHide attachmentsToggle renderAttachments sheetCreate sheetShow sheetHide sheetToggle".split(" ")})},on:{tabBeforeRemove:function(e){var t=this;$$1(e).find(".messagebar-init").each(function(e,a){t.messagebar.destroy(a)})},tabMounted:function(e){var t=this;$$1(e).find(".messagebar-init").each(function(e,a){t.messagebar.create(Utils.extend({el:a},$$1(a).dataset()))})},pageBeforeRemove:function(e){var t=this;e.$el.find(".messagebar-init").each(function(e,a){t.messagebar.destroy(a)})},pageInit:function(e){var t=this;e.$el.find(".messagebar-init").each(function(e,a){t.messagebar.create(Utils.extend({el:a},$$1(a).dataset()))})}}};function updateSize(){var e,t,a=this.$el;e=void 0!==this.params.width?this.params.width:a[0].clientWidth,t=void 0!==this.params.height?this.params.height:a[0].clientHeight,0===e&&this.isHorizontal()||0===t&&this.isVertical()||(e=e-parseInt(a.css("padding-left"),10)-parseInt(a.css("padding-right"),10),t=t-parseInt(a.css("padding-top"),10)-parseInt(a.css("padding-bottom"),10),Utils.extend(this,{width:e,height:t,size:this.isHorizontal()?e:t}))}function updateSlides(){var e=this,t=e.params,a=e.$wrapperEl,n=e.size,r=e.rtlTranslate,i=e.wrongRTL,o=a.children("."+e.params.slideClass),s=e.virtual&&t.virtual.enabled?e.virtual.slides.length:o.length,l=[],p=[],c=[],d=t.slidesOffsetBefore;"function"==typeof d&&(d=t.slidesOffsetBefore.call(e));var u=t.slidesOffsetAfter;"function"==typeof u&&(u=t.slidesOffsetAfter.call(e));var h=s,f=e.snapGrid.length,m=e.snapGrid.length,v=t.spaceBetween,g=-d,b=0,y=0;if(void 0!==n){var w,$;"string"==typeof v&&v.indexOf("%")>=0&&(v=parseFloat(v.replace("%",""))/100*n),e.virtualSize=-v,r?o.css({marginLeft:"",marginTop:""}):o.css({marginRight:"",marginBottom:""}),t.slidesPerColumn>1&&(w=Math.floor(s/t.slidesPerColumn)===s/e.params.slidesPerColumn?s:Math.ceil(s/t.slidesPerColumn)*t.slidesPerColumn,"auto"!==t.slidesPerView&&"row"===t.slidesPerColumnFill&&(w=Math.max(w,t.slidesPerView*t.slidesPerColumn)));for(var C,x=t.slidesPerColumn,E=w/x,S=E-(t.slidesPerColumn*E-s),k=0;k<s;k+=1){$=0;var T=o.eq(k);if(t.slidesPerColumn>1){var M=void 0,P=void 0,O=void 0;"column"===t.slidesPerColumnFill?(O=k-(P=Math.floor(k/x))*x,(P>S||P===S&&O===x-1)&&(O+=1)>=x&&(O=0,P+=1),M=P+O*w/x,T.css({"-webkit-box-ordinal-group":M,"-moz-box-ordinal-group":M,"-ms-flex-order":M,"-webkit-order":M,order:M})):P=k-(O=Math.floor(k/E))*E,T.css("margin-"+(e.isHorizontal()?"top":"left"),0!==O&&t.spaceBetween&&t.spaceBetween+"px").attr("data-swiper-column",P).attr("data-swiper-row",O)}if("none"!==T.css("display")){if("auto"===t.slidesPerView){var D=win.getComputedStyle(T[0],null),I=T[0].style.transform,L=T[0].style.webkitTransform;I&&(T[0].style.transform="none"),L&&(T[0].style.webkitTransform="none"),$=e.isHorizontal()?T[0].getBoundingClientRect().width+parseFloat(D.getPropertyValue("margin-left"))+parseFloat(D.getPropertyValue("margin-right")):T[0].getBoundingClientRect().height+parseFloat(D.getPropertyValue("margin-top"))+parseFloat(D.getPropertyValue("margin-bottom")),I&&(T[0].style.transform=I),L&&(T[0].style.webkitTransform=L),t.roundLengths&&($=Math.floor($))}else $=(n-(t.slidesPerView-1)*v)/t.slidesPerView,t.roundLengths&&($=Math.floor($)),o[k]&&(e.isHorizontal()?o[k].style.width=$+"px":o[k].style.height=$+"px");o[k]&&(o[k].swiperSlideSize=$),c.push($),t.centeredSlides?(g=g+$/2+b/2+v,0===b&&0!==k&&(g=g-n/2-v),0===k&&(g=g-n/2-v),Math.abs(g)<.001&&(g=0),y%t.slidesPerGroup==0&&l.push(g),p.push(g)):(y%t.slidesPerGroup==0&&l.push(g),p.push(g),g=g+$+v),e.virtualSize+=$+v,b=$,y+=1}}if(e.virtualSize=Math.max(e.virtualSize,n)+u,r&&i&&("slide"===t.effect||"coverflow"===t.effect)&&a.css({width:e.virtualSize+t.spaceBetween+"px"}),Support.flexbox&&!t.setWrapperSize||(e.isHorizontal()?a.css({width:e.virtualSize+t.spaceBetween+"px"}):a.css({height:e.virtualSize+t.spaceBetween+"px"})),t.slidesPerColumn>1&&(e.virtualSize=($+t.spaceBetween)*w,e.virtualSize=Math.ceil(e.virtualSize/t.slidesPerColumn)-t.spaceBetween,e.isHorizontal()?a.css({width:e.virtualSize+t.spaceBetween+"px"}):a.css({height:e.virtualSize+t.spaceBetween+"px"}),t.centeredSlides)){C=[];for(var z=0;z<l.length;z+=1)l[z]<e.virtualSize+l[0]&&C.push(l[z]);l=C}if(!t.centeredSlides){C=[];for(var B=0;B<l.length;B+=1)l[B]<=e.virtualSize-n&&C.push(l[B]);l=C,Math.floor(e.virtualSize-n)-Math.floor(l[l.length-1])>1&&l.push(e.virtualSize-n)}0===l.length&&(l=[0]),0!==t.spaceBetween&&(e.isHorizontal()?r?o.css({marginLeft:v+"px"}):o.css({marginRight:v+"px"}):o.css({marginBottom:v+"px"})),Utils.extend(e,{slides:o,snapGrid:l,slidesGrid:p,slidesSizesGrid:c}),s!==h&&e.emit("slidesLengthChange"),l.length!==f&&(e.params.watchOverflow&&e.checkOverflow(),e.emit("snapGridLengthChange")),p.length!==m&&e.emit("slidesGridLengthChange"),(t.watchSlidesProgress||t.watchSlidesVisibility)&&e.updateSlidesOffset()}}function updateAutoHeight(e){var t,a=this,n=[],r=0;if("number"==typeof e?a.setTransition(e):!0===e&&a.setTransition(a.params.speed),"auto"!==a.params.slidesPerView&&a.params.slidesPerView>1)for(t=0;t<Math.ceil(a.params.slidesPerView);t+=1){var i=a.activeIndex+t;if(i>a.slides.length)break;n.push(a.slides.eq(i)[0])}else n.push(a.slides.eq(a.activeIndex)[0]);for(t=0;t<n.length;t+=1)if(void 0!==n[t]){var o=n[t].offsetHeight;r=o>r?o:r}r&&a.$wrapperEl.css("height",r+"px")}function updateSlidesOffset(){for(var e=this.slides,t=0;t<e.length;t+=1)e[t].swiperSlideOffset=this.isHorizontal()?e[t].offsetLeft:e[t].offsetTop}function updateSlidesProgress(e){void 0===e&&(e=this&&this.translate||0);var t=this.params,a=this.slides,n=this.rtlTranslate;if(0!==a.length){void 0===a[0].swiperSlideOffset&&this.updateSlidesOffset();var r=-e;n&&(r=e),a.removeClass(t.slideVisibleClass);for(var i=0;i<a.length;i+=1){var o=a[i],s=(r+(t.centeredSlides?this.minTranslate():0)-o.swiperSlideOffset)/(o.swiperSlideSize+t.spaceBetween);if(t.watchSlidesVisibility){var l=-(r-o.swiperSlideOffset),p=l+this.slidesSizesGrid[i];(l>=0&&l<this.size||p>0&&p<=this.size||l<=0&&p>=this.size)&&a.eq(i).addClass(t.slideVisibleClass)}o.progress=n?-s:s}}}function updateProgress(e){void 0===e&&(e=this&&this.translate||0);var t=this,a=t.params,n=t.maxTranslate()-t.minTranslate(),r=t.progress,i=t.isBeginning,o=t.isEnd,s=i,l=o;0===n?(r=0,i=!0,o=!0):(i=(r=(e-t.minTranslate())/n)<=0,o=r>=1),Utils.extend(t,{progress:r,isBeginning:i,isEnd:o}),(a.watchSlidesProgress||a.watchSlidesVisibility)&&t.updateSlidesProgress(e),i&&!s&&t.emit("reachBeginning toEdge"),o&&!l&&t.emit("reachEnd toEdge"),(s&&!i||l&&!o)&&t.emit("fromEdge"),t.emit("progress",r)}function updateSlidesClasses(){var e,t=this.slides,a=this.params,n=this.$wrapperEl,r=this.activeIndex,i=this.realIndex,o=this.virtual&&a.virtual.enabled;t.removeClass(a.slideActiveClass+" "+a.slideNextClass+" "+a.slidePrevClass+" "+a.slideDuplicateActiveClass+" "+a.slideDuplicateNextClass+" "+a.slideDuplicatePrevClass),(e=o?this.$wrapperEl.find("."+a.slideClass+'[data-swiper-slide-index="'+r+'"]'):t.eq(r)).addClass(a.slideActiveClass),a.loop&&(e.hasClass(a.slideDuplicateClass)?n.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+i+'"]').addClass(a.slideDuplicateActiveClass):n.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+i+'"]').addClass(a.slideDuplicateActiveClass));var s=e.nextAll("."+a.slideClass).eq(0).addClass(a.slideNextClass);a.loop&&0===s.length&&(s=t.eq(0)).addClass(a.slideNextClass);var l=e.prevAll("."+a.slideClass).eq(0).addClass(a.slidePrevClass);a.loop&&0===l.length&&(l=t.eq(-1)).addClass(a.slidePrevClass),a.loop&&(s.hasClass(a.slideDuplicateClass)?n.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+s.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicateNextClass):n.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+s.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicateNextClass),l.hasClass(a.slideDuplicateClass)?n.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+l.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicatePrevClass):n.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+l.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicatePrevClass))}function updateActiveIndex(e){var t,a=this,n=a.rtlTranslate?a.translate:-a.translate,r=a.slidesGrid,i=a.snapGrid,o=a.params,s=a.activeIndex,l=a.realIndex,p=a.snapIndex,c=e;if(void 0===c){for(var d=0;d<r.length;d+=1)void 0!==r[d+1]?n>=r[d]&&n<r[d+1]-(r[d+1]-r[d])/2?c=d:n>=r[d]&&n<r[d+1]&&(c=d+1):n>=r[d]&&(c=d);o.normalizeSlideIndex&&(c<0||void 0===c)&&(c=0)}if((t=i.indexOf(n)>=0?i.indexOf(n):Math.floor(c/o.slidesPerGroup))>=i.length&&(t=i.length-1),c!==s){var u=parseInt(a.slides.eq(c).attr("data-swiper-slide-index")||c,10);Utils.extend(a,{snapIndex:t,realIndex:u,previousIndex:s,activeIndex:c}),a.emit("activeIndexChange"),a.emit("snapIndexChange"),l!==u&&a.emit("realIndexChange"),a.emit("slideChange")}else t!==p&&(a.snapIndex=t,a.emit("snapIndexChange"))}function updateClickedSlide(e){var t=this,a=t.params,n=$$1(e.target).closest("."+a.slideClass)[0],r=!1;if(n)for(var i=0;i<t.slides.length;i+=1)t.slides[i]===n&&(r=!0);if(!n||!r)return t.clickedSlide=void 0,void(t.clickedIndex=void 0);t.clickedSlide=n,t.virtual&&t.params.virtual.enabled?t.clickedIndex=parseInt($$1(n).attr("data-swiper-slide-index"),10):t.clickedIndex=$$1(n).index(),a.slideToClickedSlide&&void 0!==t.clickedIndex&&t.clickedIndex!==t.activeIndex&&t.slideToClickedSlide()}var update={updateSize:updateSize,updateSlides:updateSlides,updateAutoHeight:updateAutoHeight,updateSlidesOffset:updateSlidesOffset,updateSlidesProgress:updateSlidesProgress,updateProgress:updateProgress,updateSlidesClasses:updateSlidesClasses,updateActiveIndex:updateActiveIndex,updateClickedSlide:updateClickedSlide};function getTranslate(e){void 0===e&&(e=this.isHorizontal()?"x":"y");var t=this.params,a=this.rtlTranslate,n=this.translate,r=this.$wrapperEl;if(t.virtualTranslate)return a?-n:n;var i=Utils.getTranslate(r[0],e);return a&&(i=-i),i||0}function setTranslate(e,t){var a=this,n=a.rtlTranslate,r=a.params,i=a.$wrapperEl,o=a.progress,s=0,l=0;a.isHorizontal()?s=n?-e:e:l=e,r.roundLengths&&(s=Math.floor(s),l=Math.floor(l)),r.virtualTranslate||(Support.transforms3d?i.transform("translate3d("+s+"px, "+l+"px, 0px)"):i.transform("translate("+s+"px, "+l+"px)")),a.translate=a.isHorizontal()?s:l;var p=a.maxTranslate()-a.minTranslate();(0===p?0:(e-a.minTranslate())/p)!==o&&a.updateProgress(e),a.emit("setTranslate",a.translate,t)}function minTranslate(){return-this.snapGrid[0]}function maxTranslate(){return-this.snapGrid[this.snapGrid.length-1]}var translate={getTranslate:getTranslate,setTranslate:setTranslate,minTranslate:minTranslate,maxTranslate:maxTranslate};function setTransition(e,t){this.$wrapperEl.transition(e),this.emit("setTransition",e,t)}function transitionStart(e,t){void 0===e&&(e=!0);var a=this.activeIndex,n=this.params,r=this.previousIndex;n.autoHeight&&this.updateAutoHeight();var i=t;if(i||(i=a>r?"next":a<r?"prev":"reset"),this.emit("transitionStart"),e&&a!==r){if("reset"===i)return void this.emit("slideResetTransitionStart");this.emit("slideChangeTransitionStart"),"next"===i?this.emit("slideNextTransitionStart"):this.emit("slidePrevTransitionStart")}}function transitionEnd$1(e,t){void 0===e&&(e=!0);var a=this.activeIndex,n=this.previousIndex;this.animating=!1,this.setTransition(0);var r=t;if(r||(r=a>n?"next":a<n?"prev":"reset"),this.emit("transitionEnd"),e&&a!==n){if("reset"===r)return void this.emit("slideResetTransitionEnd");this.emit("slideChangeTransitionEnd"),"next"===r?this.emit("slideNextTransitionEnd"):this.emit("slidePrevTransitionEnd")}}var transition$1={setTransition:setTransition,transitionStart:transitionStart,transitionEnd:transitionEnd$1};function slideTo(e,t,a,n){void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0);var r=this,i=e;i<0&&(i=0);var o=r.params,s=r.snapGrid,l=r.slidesGrid,p=r.previousIndex,c=r.activeIndex,d=r.rtlTranslate;if(r.animating&&o.preventIntercationOnTransition)return!1;var u=Math.floor(i/o.slidesPerGroup);u>=s.length&&(u=s.length-1),(c||o.initialSlide||0)===(p||0)&&a&&r.emit("beforeSlideChangeStart");var h,f=-s[u];if(r.updateProgress(f),o.normalizeSlideIndex)for(var m=0;m<l.length;m+=1)-Math.floor(100*f)>=Math.floor(100*l[m])&&(i=m);if(r.initialized&&i!==c){if(!r.allowSlideNext&&f<r.translate&&f<r.minTranslate())return!1;if(!r.allowSlidePrev&&f>r.translate&&f>r.maxTranslate()&&(c||0)!==i)return!1}return h=i>c?"next":i<c?"prev":"reset",d&&-f===r.translate||!d&&f===r.translate?(r.updateActiveIndex(i),o.autoHeight&&r.updateAutoHeight(),r.updateSlidesClasses(),"slide"!==o.effect&&r.setTranslate(f),"reset"!==h&&(r.transitionStart(a,h),r.transitionEnd(a,h)),!1):(0!==t&&Support.transition?(r.setTransition(t),r.setTranslate(f),r.updateActiveIndex(i),r.updateSlidesClasses(),r.emit("beforeTransitionStart",t,n),r.transitionStart(a,h),r.animating||(r.animating=!0,r.onSlideToWrapperTransitionEnd||(r.onSlideToWrapperTransitionEnd=function(e){r&&!r.destroyed&&e.target===this&&(r.$wrapperEl[0].removeEventListener("transitionend",r.onSlideToWrapperTransitionEnd),r.$wrapperEl[0].removeEventListener("webkitTransitionEnd",r.onSlideToWrapperTransitionEnd),r.transitionEnd(a,h))}),r.$wrapperEl[0].addEventListener("transitionend",r.onSlideToWrapperTransitionEnd),r.$wrapperEl[0].addEventListener("webkitTransitionEnd",r.onSlideToWrapperTransitionEnd))):(r.setTransition(0),r.setTranslate(f),r.updateActiveIndex(i),r.updateSlidesClasses(),r.emit("beforeTransitionStart",t,n),r.transitionStart(a,h),r.transitionEnd(a,h)),!0)}function slideToLoop(e,t,a,n){void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0);var r=e;return this.params.loop&&(r+=this.loopedSlides),this.slideTo(r,t,a,n)}function slideNext(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);var n=this.params,r=this.animating;return n.loop?!r&&(this.loopFix(),this._clientLeft=this.$wrapperEl[0].clientLeft,this.slideTo(this.activeIndex+n.slidesPerGroup,e,t,a)):this.slideTo(this.activeIndex+n.slidesPerGroup,e,t,a)}function slidePrev(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);var n=this,r=n.params,i=n.animating,o=n.snapGrid,s=n.slidesGrid,l=n.rtlTranslate;if(r.loop){if(i)return!1;n.loopFix(),n._clientLeft=n.$wrapperEl[0].clientLeft}var p,c=l?n.translate:-n.translate,d=c<0?-Math.floor(Math.abs(c)):Math.floor(c),u=o.map(function(e){return Math.floor(e)}),h=(s.map(function(e){return Math.floor(e)}),o[u.indexOf(d)],o[u.indexOf(d)-1]);return void 0!==h&&(p=s.indexOf(h))<0&&(p=n.activeIndex-1),n.slideTo(p,e,t,a)}function slideReset(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);return this.slideTo(this.activeIndex,e,t,a)}function slideToClosest(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);var n=this,r=n.activeIndex,i=Math.floor(r/n.params.slidesPerGroup);if(i<n.snapGrid.length-1){var o=n.rtlTranslate?n.translate:-n.translate,s=n.snapGrid[i];o-s>(n.snapGrid[i+1]-s)/2&&(r=n.params.slidesPerGroup)}return n.slideTo(r,e,t,a)}function slideToClickedSlide(){var e,t=this,a=t.params,n=t.$wrapperEl,r="auto"===a.slidesPerView?t.slidesPerViewDynamic():a.slidesPerView,i=t.clickedIndex;if(a.loop){if(t.animating)return;e=parseInt($$1(t.clickedSlide).attr("data-swiper-slide-index"),10),a.centeredSlides?i<t.loopedSlides-r/2||i>t.slides.length-t.loopedSlides+r/2?(t.loopFix(),i=n.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]:not(.'+a.slideDuplicateClass+")").eq(0).index(),Utils.nextTick(function(){t.slideTo(i)})):t.slideTo(i):i>t.slides.length-r?(t.loopFix(),i=n.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]:not(.'+a.slideDuplicateClass+")").eq(0).index(),Utils.nextTick(function(){t.slideTo(i)})):t.slideTo(i)}else t.slideTo(i)}var slide={slideTo:slideTo,slideToLoop:slideToLoop,slideNext:slideNext,slidePrev:slidePrev,slideReset:slideReset,slideToClosest:slideToClosest,slideToClickedSlide:slideToClickedSlide};function loopCreate(){var e=this,t=e.params,a=e.$wrapperEl;a.children("."+t.slideClass+"."+t.slideDuplicateClass).remove();var n=a.children("."+t.slideClass);if(t.loopFillGroupWithBlank){var r=t.slidesPerGroup-n.length%t.slidesPerGroup;if(r!==t.slidesPerGroup){for(var i=0;i<r;i+=1){var o=$$1(doc.createElement("div")).addClass(t.slideClass+" "+t.slideBlankClass);a.append(o)}n=a.children("."+t.slideClass)}}"auto"!==t.slidesPerView||t.loopedSlides||(t.loopedSlides=n.length),e.loopedSlides=parseInt(t.loopedSlides||t.slidesPerView,10),e.loopedSlides+=t.loopAdditionalSlides,e.loopedSlides>n.length&&(e.loopedSlides=n.length);var s=[],l=[];n.each(function(t,a){var r=$$1(a);t<e.loopedSlides&&l.push(a),t<n.length&&t>=n.length-e.loopedSlides&&s.push(a),r.attr("data-swiper-slide-index",t)});for(var p=0;p<l.length;p+=1)a.append($$1(l[p].cloneNode(!0)).addClass(t.slideDuplicateClass));for(var c=s.length-1;c>=0;c-=1)a.prepend($$1(s[c].cloneNode(!0)).addClass(t.slideDuplicateClass))}function loopFix(){var e,t=this,a=t.params,n=t.activeIndex,r=t.slides,i=t.loopedSlides,o=t.allowSlidePrev,s=t.allowSlideNext,l=t.snapGrid,p=t.rtlTranslate;t.allowSlidePrev=!0,t.allowSlideNext=!0;var c=-l[n]-t.getTranslate();if(n<i)e=r.length-3*i+n,e+=i,t.slideTo(e,0,!1,!0)&&0!==c&&t.setTranslate((p?-t.translate:t.translate)-c);else if("auto"===a.slidesPerView&&n>=2*i||n>r.length-2*a.slidesPerView){e=-r.length+n+i,e+=i,t.slideTo(e,0,!1,!0)&&0!==c&&t.setTranslate((p?-t.translate:t.translate)-c)}t.allowSlidePrev=o,t.allowSlideNext=s}function loopDestroy(){var e=this.$wrapperEl,t=this.params,a=this.slides;e.children("."+t.slideClass+"."+t.slideDuplicateClass).remove(),a.removeAttr("data-swiper-slide-index")}var loop={loopCreate:loopCreate,loopFix:loopFix,loopDestroy:loopDestroy};function setGrabCursor(e){if(!(Support.touch||!this.params.simulateTouch||this.params.watchOverflow&&this.isLocked)){var t=this.el;t.style.cursor="move",t.style.cursor=e?"-webkit-grabbing":"-webkit-grab",t.style.cursor=e?"-moz-grabbin":"-moz-grab",t.style.cursor=e?"grabbing":"grab"}}function unsetGrabCursor(){Support.touch||this.params.watchOverflow&&this.isLocked||(this.el.style.cursor="")}var grabCursor={setGrabCursor:setGrabCursor,unsetGrabCursor:unsetGrabCursor};function appendSlide(e){var t=this.$wrapperEl,a=this.params;if(a.loop&&this.loopDestroy(),"object"==typeof e&&"length"in e)for(var n=0;n<e.length;n+=1)e[n]&&t.append(e[n]);else t.append(e);a.loop&&this.loopCreate(),a.observer&&Support.observer||this.update()}function prependSlide(e){var t=this.params,a=this.$wrapperEl,n=this.activeIndex;t.loop&&this.loopDestroy();var r=n+1;if("object"==typeof e&&"length"in e){for(var i=0;i<e.length;i+=1)e[i]&&a.prepend(e[i]);r=n+e.length}else a.prepend(e);t.loop&&this.loopCreate(),t.observer&&Support.observer||this.update(),this.slideTo(r,0,!1)}function removeSlide(e){var t=this,a=t.params,n=t.$wrapperEl,r=t.activeIndex;a.loop&&(t.loopDestroy(),t.slides=n.children("."+a.slideClass));var i,o=r;if("object"==typeof e&&"length"in e){for(var s=0;s<e.length;s+=1)i=e[s],t.slides[i]&&t.slides.eq(i).remove(),i<o&&(o-=1);o=Math.max(o,0)}else i=e,t.slides[i]&&t.slides.eq(i).remove(),i<o&&(o-=1),o=Math.max(o,0);a.loop&&t.loopCreate(),a.observer&&Support.observer||t.update(),a.loop?t.slideTo(o+t.loopedSlides,0,!1):t.slideTo(o,0,!1)}function removeAllSlides(){for(var e=[],t=0;t<this.slides.length;t+=1)e.push(t);this.removeSlide(e)}var manipulation={appendSlide:appendSlide,prependSlide:prependSlide,removeSlide:removeSlide,removeAllSlides:removeAllSlides};function onTouchStart(e){var t=this,a=t.touchEventsData,n=t.params,r=t.touches;if(!t.animating||!n.preventIntercationOnTransition){var i=e;if(i.originalEvent&&(i=i.originalEvent),a.isTouchEvent="touchstart"===i.type,(a.isTouchEvent||!("which"in i)||3!==i.which)&&(!a.isTouched||!a.isMoved))if(n.noSwiping&&$$1(i.target).closest(n.noSwipingSelector?n.noSwipingSelector:"."+n.noSwipingClass)[0])t.allowClick=!0;else if(!n.swipeHandler||$$1(i).closest(n.swipeHandler)[0]){r.currentX="touchstart"===i.type?i.targetTouches[0].pageX:i.pageX,r.currentY="touchstart"===i.type?i.targetTouches[0].pageY:i.pageY;var o=r.currentX,s=r.currentY;if(!Device.ios||Device.cordova||!n.iOSEdgeSwipeDetection||!(o<=n.iOSEdgeSwipeThreshold||o>=win.screen.width-n.iOSEdgeSwipeThreshold)){if(Utils.extend(a,{isTouched:!0,isMoved:!1,allowTouchCallbacks:!0,isScrolling:void 0,startMoving:void 0}),r.startX=o,r.startY=s,a.touchStartTime=Utils.now(),t.allowClick=!0,t.updateSize(),t.swipeDirection=void 0,n.threshold>0&&(a.allowThresholdMove=!1),"touchstart"!==i.type){var l=!0;$$1(i.target).is(a.formElements)&&(l=!1),doc.activeElement&&$$1(doc.activeElement).is(a.formElements)&&doc.activeElement!==i.target&&doc.activeElement.blur(),l&&t.allowTouchMove&&i.preventDefault()}t.emit("touchStart",i)}}}}function onTouchMove(e){var t=this,a=t.touchEventsData,n=t.params,r=t.touches,i=t.rtlTranslate,o=e;if(o.originalEvent&&(o=o.originalEvent),a.isTouched){if(!a.isTouchEvent||"mousemove"!==o.type){var s="touchmove"===o.type?o.targetTouches[0].pageX:o.pageX,l="touchmove"===o.type?o.targetTouches[0].pageY:o.pageY;if(o.preventedByNestedSwiper)return r.startX=s,void(r.startY=l);if(!t.allowTouchMove)return t.allowClick=!1,void(a.isTouched&&(Utils.extend(r,{startX:s,startY:l,currentX:s,currentY:l}),a.touchStartTime=Utils.now()));if(a.isTouchEvent&&n.touchReleaseOnEdges&&!n.loop)if(t.isVertical()){if(l<r.startY&&t.translate<=t.maxTranslate()||l>r.startY&&t.translate>=t.minTranslate())return a.isTouched=!1,void(a.isMoved=!1)}else if(s<r.startX&&t.translate<=t.maxTranslate()||s>r.startX&&t.translate>=t.minTranslate())return;if(a.isTouchEvent&&doc.activeElement&&o.target===doc.activeElement&&$$1(o.target).is(a.formElements))return a.isMoved=!0,void(t.allowClick=!1);if(a.allowTouchCallbacks&&t.emit("touchMove",o),!(o.targetTouches&&o.targetTouches.length>1)){r.currentX=s,r.currentY=l;var p,c=r.currentX-r.startX,d=r.currentY-r.startY;if(void 0===a.isScrolling)t.isHorizontal()&&r.currentY===r.startY||t.isVertical()&&r.currentX===r.startX?a.isScrolling=!1:c*c+d*d>=25&&(p=180*Math.atan2(Math.abs(d),Math.abs(c))/Math.PI,a.isScrolling=t.isHorizontal()?p>n.touchAngle:90-p>n.touchAngle);if(a.isScrolling&&t.emit("touchMoveOpposite",o),"undefined"==typeof startMoving&&(r.currentX===r.startX&&r.currentY===r.startY||(a.startMoving=!0)),a.isScrolling)a.isTouched=!1;else if(a.startMoving){t.allowClick=!1,o.preventDefault(),n.touchMoveStopPropagation&&!n.nested&&o.stopPropagation(),a.isMoved||(n.loop&&t.loopFix(),a.startTranslate=t.getTranslate(),t.setTransition(0),t.animating&&t.$wrapperEl.trigger("webkitTransitionEnd transitionend"),a.allowMomentumBounce=!1,!n.grabCursor||!0!==t.allowSlideNext&&!0!==t.allowSlidePrev||t.setGrabCursor(!0),t.emit("sliderFirstMove",o)),t.emit("sliderMove",o),a.isMoved=!0;var u=t.isHorizontal()?c:d;r.diff=u,u*=n.touchRatio,i&&(u=-u),t.swipeDirection=u>0?"prev":"next",a.currentTranslate=u+a.startTranslate;var h=!0,f=n.resistanceRatio;if(n.touchReleaseOnEdges&&(f=0),u>0&&a.currentTranslate>t.minTranslate()?(h=!1,n.resistance&&(a.currentTranslate=t.minTranslate()-1+Math.pow(-t.minTranslate()+a.startTranslate+u,f))):u<0&&a.currentTranslate<t.maxTranslate()&&(h=!1,n.resistance&&(a.currentTranslate=t.maxTranslate()+1-Math.pow(t.maxTranslate()-a.startTranslate-u,f))),h&&(o.preventedByNestedSwiper=!0),!t.allowSlideNext&&"next"===t.swipeDirection&&a.currentTranslate<a.startTranslate&&(a.currentTranslate=a.startTranslate),!t.allowSlidePrev&&"prev"===t.swipeDirection&&a.currentTranslate>a.startTranslate&&(a.currentTranslate=a.startTranslate),n.threshold>0){if(!(Math.abs(u)>n.threshold||a.allowThresholdMove))return void(a.currentTranslate=a.startTranslate);if(!a.allowThresholdMove)return a.allowThresholdMove=!0,r.startX=r.currentX,r.startY=r.currentY,a.currentTranslate=a.startTranslate,void(r.diff=t.isHorizontal()?r.currentX-r.startX:r.currentY-r.startY)}n.followFinger&&((n.freeMode||n.watchSlidesProgress||n.watchSlidesVisibility)&&(t.updateActiveIndex(),t.updateSlidesClasses()),n.freeMode&&(0===a.velocities.length&&a.velocities.push({position:r[t.isHorizontal()?"startX":"startY"],time:a.touchStartTime}),a.velocities.push({position:r[t.isHorizontal()?"currentX":"currentY"],time:Utils.now()})),t.updateProgress(a.currentTranslate),t.setTranslate(a.currentTranslate))}}}}else a.startMoving&&a.isScrolling&&t.emit("touchMoveOpposite",o)}function onTouchEnd(e){var t=this,a=t.touchEventsData,n=t.params,r=t.touches,i=t.rtlTranslate,o=t.$wrapperEl,s=t.slidesGrid,l=t.snapGrid,p=e;if(p.originalEvent&&(p=p.originalEvent),a.allowTouchCallbacks&&t.emit("touchEnd",p),a.allowTouchCallbacks=!1,!a.isTouched)return a.isMoved&&n.grabCursor&&t.setGrabCursor(!1),a.isMoved=!1,void(a.startMoving=!1);n.grabCursor&&a.isMoved&&a.isTouched&&(!0===t.allowSlideNext||!0===t.allowSlidePrev)&&t.setGrabCursor(!1);var c,d=Utils.now(),u=d-a.touchStartTime;if(t.allowClick&&(t.updateClickedSlide(p),t.emit("tap",p),u<300&&d-a.lastClickTime>300&&(a.clickTimeout&&clearTimeout(a.clickTimeout),a.clickTimeout=Utils.nextTick(function(){t&&!t.destroyed&&t.emit("click",p)},300)),u<300&&d-a.lastClickTime<300&&(a.clickTimeout&&clearTimeout(a.clickTimeout),t.emit("doubleTap",p))),a.lastClickTime=Utils.now(),Utils.nextTick(function(){t.destroyed||(t.allowClick=!0)}),!a.isTouched||!a.isMoved||!t.swipeDirection||0===r.diff||a.currentTranslate===a.startTranslate)return a.isTouched=!1,a.isMoved=!1,void(a.startMoving=!1);if(a.isTouched=!1,a.isMoved=!1,a.startMoving=!1,c=n.followFinger?i?t.translate:-t.translate:-a.currentTranslate,n.freeMode){if(c<-t.minTranslate())return void t.slideTo(t.activeIndex);if(c>-t.maxTranslate())return void(t.slides.length<l.length?t.slideTo(l.length-1):t.slideTo(t.slides.length-1));if(n.freeModeMomentum){if(a.velocities.length>1){var h=a.velocities.pop(),f=a.velocities.pop(),m=h.position-f.position,v=h.time-f.time;t.velocity=m/v,t.velocity/=2,Math.abs(t.velocity)<n.freeModeMinimumVelocity&&(t.velocity=0),(v>150||Utils.now()-h.time>300)&&(t.velocity=0)}else t.velocity=0;t.velocity*=n.freeModeMomentumVelocityRatio,a.velocities.length=0;var g=1e3*n.freeModeMomentumRatio,b=t.velocity*g,y=t.translate+b;i&&(y=-y);var w,$,C=!1,x=20*Math.abs(t.velocity)*n.freeModeMomentumBounceRatio;if(y<t.maxTranslate())n.freeModeMomentumBounce?(y+t.maxTranslate()<-x&&(y=t.maxTranslate()-x),w=t.maxTranslate(),C=!0,a.allowMomentumBounce=!0):y=t.maxTranslate(),n.loop&&n.centeredSlides&&($=!0);else if(y>t.minTranslate())n.freeModeMomentumBounce?(y-t.minTranslate()>x&&(y=t.minTranslate()+x),w=t.minTranslate(),C=!0,a.allowMomentumBounce=!0):y=t.minTranslate(),n.loop&&n.centeredSlides&&($=!0);else if(n.freeModeSticky){for(var E,S=0;S<l.length;S+=1)if(l[S]>-y){E=S;break}y=-(y=Math.abs(l[E]-y)<Math.abs(l[E-1]-y)||"next"===t.swipeDirection?l[E]:l[E-1])}if($&&t.once("transitionEnd",function(){t.loopFix()}),0!==t.velocity)g=i?Math.abs((-y-t.translate)/t.velocity):Math.abs((y-t.translate)/t.velocity);else if(n.freeModeSticky)return void t.slideToClosest();n.freeModeMomentumBounce&&C?(t.updateProgress(w),t.setTransition(g),t.setTranslate(y),t.transitionStart(!0,t.swipeDirection),t.animating=!0,o.transitionEnd(function(){t&&!t.destroyed&&a.allowMomentumBounce&&(t.emit("momentumBounce"),t.setTransition(n.speed),t.setTranslate(w),o.transitionEnd(function(){t&&!t.destroyed&&t.transitionEnd()}))})):t.velocity?(t.updateProgress(y),t.setTransition(g),t.setTranslate(y),t.transitionStart(!0,t.swipeDirection),t.animating||(t.animating=!0,o.transitionEnd(function(){t&&!t.destroyed&&t.transitionEnd()}))):t.updateProgress(y),t.updateActiveIndex(),t.updateSlidesClasses()}else if(n.freeModeSticky)return void t.slideToClosest();(!n.freeModeMomentum||u>=n.longSwipesMs)&&(t.updateProgress(),t.updateActiveIndex(),t.updateSlidesClasses())}else{for(var k=0,T=t.slidesSizesGrid[0],M=0;M<s.length;M+=n.slidesPerGroup)void 0!==s[M+n.slidesPerGroup]?c>=s[M]&&c<s[M+n.slidesPerGroup]&&(k=M,T=s[M+n.slidesPerGroup]-s[M]):c>=s[M]&&(k=M,T=s[s.length-1]-s[s.length-2]);var P=(c-s[k])/T;if(u>n.longSwipesMs){if(!n.longSwipes)return void t.slideTo(t.activeIndex);"next"===t.swipeDirection&&(P>=n.longSwipesRatio?t.slideTo(k+n.slidesPerGroup):t.slideTo(k)),"prev"===t.swipeDirection&&(P>1-n.longSwipesRatio?t.slideTo(k+n.slidesPerGroup):t.slideTo(k))}else{if(!n.shortSwipes)return void t.slideTo(t.activeIndex);"next"===t.swipeDirection&&t.slideTo(k+n.slidesPerGroup),"prev"===t.swipeDirection&&t.slideTo(k)}}}function onResize(){var e=this,t=e.params,a=e.el;if(!a||0!==a.offsetWidth){t.breakpoints&&e.setBreakpoint();var n=e.allowSlideNext,r=e.allowSlidePrev,i=e.snapGrid;if(e.allowSlideNext=!0,e.allowSlidePrev=!0,e.updateSize(),e.updateSlides(),t.freeMode){var o=Math.min(Math.max(e.translate,e.maxTranslate()),e.minTranslate());e.setTranslate(o),e.updateActiveIndex(),e.updateSlidesClasses(),t.autoHeight&&e.updateAutoHeight()}else e.updateSlidesClasses(),("auto"===t.slidesPerView||t.slidesPerView>1)&&e.isEnd&&!e.params.centeredSlides?e.slideTo(e.slides.length-1,0,!1,!0):e.slideTo(e.activeIndex,0,!1,!0);e.allowSlidePrev=r,e.allowSlideNext=n,e.params.watchOverflow&&i!==e.snapGrid&&e.checkOverflow()}}function onClick(e){this.allowClick||(this.params.preventClicks&&e.preventDefault(),this.params.preventClicksPropagation&&this.animating&&(e.stopPropagation(),e.stopImmediatePropagation()))}function attachEvents(){var e=this,t=e.params,a=e.touchEvents,n=e.el,r=e.wrapperEl;e.onTouchStart=onTouchStart.bind(e),e.onTouchMove=onTouchMove.bind(e),e.onTouchEnd=onTouchEnd.bind(e),e.onClick=onClick.bind(e);var i="container"===t.touchEventsTarget?n:r,o=!!t.nested;if(Support.touch||!Support.pointerEvents&&!Support.prefixedPointerEvents){if(Support.touch){var s=!("touchstart"!==a.start||!Support.passiveListener||!t.passiveListeners)&&{passive:!0,capture:!1};i.addEventListener(a.start,e.onTouchStart,s),i.addEventListener(a.move,e.onTouchMove,Support.passiveListener?{passive:!1,capture:o}:o),i.addEventListener(a.end,e.onTouchEnd,s)}(t.simulateTouch&&!Device.ios&&!Device.android||t.simulateTouch&&!Support.touch&&Device.ios)&&(i.addEventListener("mousedown",e.onTouchStart,!1),doc.addEventListener("mousemove",e.onTouchMove,o),doc.addEventListener("mouseup",e.onTouchEnd,!1))}else i.addEventListener(a.start,e.onTouchStart,!1),doc.addEventListener(a.move,e.onTouchMove,o),doc.addEventListener(a.end,e.onTouchEnd,!1);(t.preventClicks||t.preventClicksPropagation)&&i.addEventListener("click",e.onClick,!0),e.on(Device.ios||Device.android?"resize orientationchange observerUpdate":"resize observerUpdate",onResize,!0)}function detachEvents(){var e=this,t=e.params,a=e.touchEvents,n=e.el,r=e.wrapperEl,i="container"===t.touchEventsTarget?n:r,o=!!t.nested;if(Support.touch||!Support.pointerEvents&&!Support.prefixedPointerEvents){if(Support.touch){var s=!("onTouchStart"!==a.start||!Support.passiveListener||!t.passiveListeners)&&{passive:!0,capture:!1};i.removeEventListener(a.start,e.onTouchStart,s),i.removeEventListener(a.move,e.onTouchMove,o),i.removeEventListener(a.end,e.onTouchEnd,s)}(t.simulateTouch&&!Device.ios&&!Device.android||t.simulateTouch&&!Support.touch&&Device.ios)&&(i.removeEventListener("mousedown",e.onTouchStart,!1),doc.removeEventListener("mousemove",e.onTouchMove,o),doc.removeEventListener("mouseup",e.onTouchEnd,!1))}else i.removeEventListener(a.start,e.onTouchStart,!1),doc.removeEventListener(a.move,e.onTouchMove,o),doc.removeEventListener(a.end,e.onTouchEnd,!1);(t.preventClicks||t.preventClicksPropagation)&&i.removeEventListener("click",e.onClick,!0),e.off(Device.ios||Device.android?"resize orientationchange observerUpdate":"resize observerUpdate",onResize)}var events={attachEvents:attachEvents,detachEvents:detachEvents};function setBreakpoint(){var e=this,t=e.activeIndex,a=e.initialized,n=e.loopedSlides;void 0===n&&(n=0);var r=e.params,i=r.breakpoints;if(i&&(!i||0!==Object.keys(i).length)){var o=e.getBreakpoint(i);if(o&&e.currentBreakpoint!==o){var s=o in i?i[o]:e.originalParams,l=r.loop&&s.slidesPerView!==r.slidesPerView;Utils.extend(e.params,s),Utils.extend(e,{allowTouchMove:e.params.allowTouchMove,allowSlideNext:e.params.allowSlideNext,allowSlidePrev:e.params.allowSlidePrev}),e.currentBreakpoint=o,l&&a&&(e.loopDestroy(),e.loopCreate(),e.updateSlides(),e.slideTo(t-n+e.loopedSlides,0,!1)),e.emit("breakpoint",s)}}}function getBreakpoint(e){if(e){var t=!1,a=[];Object.keys(e).forEach(function(e){a.push(e)}),a.sort(function(e,t){return parseInt(e,10)-parseInt(t,10)});for(var n=0;n<a.length;n+=1){var r=a[n];r>=win.innerWidth&&!t&&(t=r)}return t||"max"}}var breakpoints={setBreakpoint:setBreakpoint,getBreakpoint:getBreakpoint},Browser=function(){return{isIE:!!win.navigator.userAgent.match(/Trident/g)||!!win.navigator.userAgent.match(/MSIE/g),isSafari:(e=win.navigator.userAgent.toLowerCase(),e.indexOf("safari")>=0&&e.indexOf("chrome")<0&&e.indexOf("android")<0),isUiWebView:/(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/i.test(win.navigator.userAgent)};var e}();function addClasses(){var e=this.classNames,t=this.params,a=this.rtl,n=this.$el,r=[];r.push(t.direction),t.freeMode&&r.push("free-mode"),Support.flexbox||r.push("no-flexbox"),t.autoHeight&&r.push("autoheight"),a&&r.push("rtl"),t.slidesPerColumn>1&&r.push("multirow"),Device.android&&r.push("android"),Device.ios&&r.push("ios"),Browser.isIE&&(Support.pointerEvents||Support.prefixedPointerEvents)&&r.push("wp8-"+t.direction),r.forEach(function(a){e.push(t.containerModifierClass+a)}),n.addClass(e.join(" "))}function removeClasses(){var e=this.$el,t=this.classNames;e.removeClass(t.join(" "))}var classes={addClasses:addClasses,removeClasses:removeClasses};function loadImage(e,t,a,n,r,i){var o;function s(){i&&i()}e.complete&&r?s():t?((o=new win.Image).onload=s,o.onerror=s,n&&(o.sizes=n),a&&(o.srcset=a),t&&(o.src=t)):s()}function preloadImages(){var e=this;function t(){void 0!==e&&null!==e&&e&&!e.destroyed&&(void 0!==e.imagesLoaded&&(e.imagesLoaded+=1),e.imagesLoaded===e.imagesToLoad.length&&(e.params.updateOnImagesReady&&e.update(),e.emit("imagesReady")))}e.imagesToLoad=e.$el.find("img");for(var a=0;a<e.imagesToLoad.length;a+=1){var n=e.imagesToLoad[a];e.loadImage(n,n.currentSrc||n.getAttribute("src"),n.srcset||n.getAttribute("srcset"),n.sizes||n.getAttribute("sizes"),!0,t)}}var images={loadImage:loadImage,preloadImages:preloadImages};function checkOverflow(){var e=this,t=e.isLocked;e.isLocked=1===e.snapGrid.length,e.allowSlideNext=!e.isLocked,e.allowSlidePrev=!e.isLocked,t!==e.isLocked&&e.emit(e.isLocked?"lock":"unlock"),t&&t!==e.isLocked&&(e.isEnd=!1,e.navigation.update())}var checkOverflow$1={checkOverflow:checkOverflow},defaults={init:!0,direction:"horizontal",touchEventsTarget:"container",initialSlide:0,speed:300,preventIntercationOnTransition:!1,iOSEdgeSwipeDetection:!1,iOSEdgeSwipeThreshold:20,freeMode:!1,freeModeMomentum:!0,freeModeMomentumRatio:1,freeModeMomentumBounce:!0,freeModeMomentumBounceRatio:1,freeModeMomentumVelocityRatio:1,freeModeSticky:!1,freeModeMinimumVelocity:.02,autoHeight:!1,setWrapperSize:!1,virtualTranslate:!1,effect:"slide",breakpoints:void 0,spaceBetween:0,slidesPerView:1,slidesPerColumn:1,slidesPerColumnFill:"column",slidesPerGroup:1,centeredSlides:!1,slidesOffsetBefore:0,slidesOffsetAfter:0,normalizeSlideIndex:!0,watchOverflow:!1,roundLengths:!1,touchRatio:1,touchAngle:45,simulateTouch:!0,shortSwipes:!0,longSwipes:!0,longSwipesRatio:.5,longSwipesMs:300,followFinger:!0,allowTouchMove:!0,threshold:0,touchMoveStopPropagation:!0,touchReleaseOnEdges:!1,uniqueNavElements:!0,resistance:!0,resistanceRatio:.85,watchSlidesProgress:!1,watchSlidesVisibility:!1,grabCursor:!1,preventClicks:!0,preventClicksPropagation:!0,slideToClickedSlide:!1,preloadImages:!0,updateOnImagesReady:!0,loop:!1,loopAdditionalSlides:0,loopedSlides:null,loopFillGroupWithBlank:!1,allowSlidePrev:!0,allowSlideNext:!0,swipeHandler:null,noSwiping:!0,noSwipingClass:"swiper-no-swiping",noSwipingSelector:null,passiveListeners:!0,containerModifierClass:"swiper-container-",slideClass:"swiper-slide",slideBlankClass:"swiper-slide-invisible-blank",slideActiveClass:"swiper-slide-active",slideDuplicateActiveClass:"swiper-slide-duplicate-active",slideVisibleClass:"swiper-slide-visible",slideDuplicateClass:"swiper-slide-duplicate",slideNextClass:"swiper-slide-next",slideDuplicateNextClass:"swiper-slide-duplicate-next",slidePrevClass:"swiper-slide-prev",slideDuplicatePrevClass:"swiper-slide-duplicate-prev",wrapperClass:"swiper-wrapper",runCallbacksOnInit:!0},prototypes={update:update,translate:translate,transition:transition$1,slide:slide,loop:loop,grabCursor:grabCursor,manipulation:manipulation,events:events,breakpoints:breakpoints,checkOverflow:checkOverflow$1,classes:classes,images:images},extendedDefaults={},Swiper=function(e){function t(){for(var a,n,r,i=[],o=arguments.length;o--;)i[o]=arguments[o];1===i.length&&i[0].constructor&&i[0].constructor===Object?r=i[0]:(n=(a=i)[0],r=a[1]),r||(r={}),r=Utils.extend({},r),n&&!r.el&&(r.el=n),e.call(this,r),Object.keys(prototypes).forEach(function(e){Object.keys(prototypes[e]).forEach(function(a){t.prototype[a]||(t.prototype[a]=prototypes[e][a])})});var s=this;void 0===s.modules&&(s.modules={}),Object.keys(s.modules).forEach(function(e){var t=s.modules[e];if(t.params){var a=Object.keys(t.params)[0],n=t.params[a];if("object"!=typeof n)return;if(!(a in r&&"enabled"in n))return;!0===r[a]&&(r[a]={enabled:!0}),"object"!=typeof r[a]||"enabled"in r[a]||(r[a].enabled=!0),r[a]||(r[a]={enabled:!1})}});var l=Utils.extend({},defaults);s.useModulesParams(l),s.params=Utils.extend({},l,extendedDefaults,r),s.originalParams=Utils.extend({},s.params),s.passedParams=Utils.extend({},r),s.$=$$1;var p=$$1(s.params.el);if(n=p[0]){if(p.length>1){var c=[];return p.each(function(e,a){var n=Utils.extend({},r,{el:a});c.push(new t(n))}),c}n.swiper=s,p.data("swiper",s);var d,u,h=p.children("."+s.params.wrapperClass);return Utils.extend(s,{$el:p,el:n,$wrapperEl:h,wrapperEl:h[0],classNames:[],slides:$$1(),slidesGrid:[],snapGrid:[],slidesSizesGrid:[],isHorizontal:function(){return"horizontal"===s.params.direction},isVertical:function(){return"vertical"===s.params.direction},rtl:"rtl"===n.dir.toLowerCase()||"rtl"===p.css("direction"),rtlTranslate:"horizontal"===s.params.direction&&("rtl"===n.dir.toLowerCase()||"rtl"===p.css("direction")),wrongRTL:"-webkit-box"===h.css("display"),activeIndex:0,realIndex:0,isBeginning:!0,isEnd:!1,translate:0,progress:0,velocity:0,animating:!1,allowSlideNext:s.params.allowSlideNext,allowSlidePrev:s.params.allowSlidePrev,touchEvents:(d=["touchstart","touchmove","touchend"],u=["mousedown","mousemove","mouseup"],Support.pointerEvents?u=["pointerdown","pointermove","pointerup"]:Support.prefixedPointerEvents&&(u=["MSPointerDown","MSPointerMove","MSPointerUp"]),s.touchEventsTouch={start:d[0],move:d[1],end:d[2]},s.touchEventsDesktop={start:u[0],move:u[1],end:u[2]},Support.touch||!s.params.simulateTouch?s.touchEventsTouch:s.touchEventsDesktop),touchEventsData:{isTouched:void 0,isMoved:void 0,allowTouchCallbacks:void 0,touchStartTime:void 0,isScrolling:void 0,currentTranslate:void 0,startTranslate:void 0,allowThresholdMove:void 0,formElements:"input, select, option, textarea, button, video",lastClickTime:Utils.now(),clickTimeout:void 0,velocities:[],allowMomentumBounce:void 0,isTouchEvent:void 0,startMoving:void 0},allowClick:!0,allowTouchMove:s.params.allowTouchMove,touches:{startX:0,startY:0,currentX:0,currentY:0,diff:0},imagesToLoad:[],imagesLoaded:0}),s.useModules(),s.params.init&&s.init(),s}}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={extendedDefaults:{configurable:!0},defaults:{configurable:!0},Class:{configurable:!0},$:{configurable:!0}};return t.prototype.slidesPerViewDynamic=function(){var e=this.params,t=this.slides,a=this.slidesGrid,n=this.size,r=this.activeIndex,i=1;if(e.centeredSlides){for(var o,s=t[r].swiperSlideSize,l=r+1;l<t.length;l+=1)t[l]&&!o&&(i+=1,(s+=t[l].swiperSlideSize)>n&&(o=!0));for(var p=r-1;p>=0;p-=1)t[p]&&!o&&(i+=1,(s+=t[p].swiperSlideSize)>n&&(o=!0))}else for(var c=r+1;c<t.length;c+=1)a[c]-a[r]<n&&(i+=1);return i},t.prototype.update=function(){var e=this;if(e&&!e.destroyed){var t=e.snapGrid,a=e.params;a.breakpoints&&e.setBreakpoint(),e.updateSize(),e.updateSlides(),e.updateProgress(),e.updateSlidesClasses(),e.params.freeMode?(n(),e.params.autoHeight&&e.updateAutoHeight()):(("auto"===e.params.slidesPerView||e.params.slidesPerView>1)&&e.isEnd&&!e.params.centeredSlides?e.slideTo(e.slides.length-1,0,!1,!0):e.slideTo(e.activeIndex,0,!1,!0))||n(),a.watchOverflow&&t!==e.snapGrid&&e.checkOverflow(),e.emit("update")}function n(){var t=e.rtlTranslate?-1*e.translate:e.translate,a=Math.min(Math.max(t,e.maxTranslate()),e.minTranslate());e.setTranslate(a),e.updateActiveIndex(),e.updateSlidesClasses()}},t.prototype.init=function(){var e=this;e.initialized||(e.emit("beforeInit"),e.params.breakpoints&&e.setBreakpoint(),e.addClasses(),e.params.loop&&e.loopCreate(),e.updateSize(),e.updateSlides(),e.params.watchOverflow&&e.checkOverflow(),e.params.grabCursor&&e.setGrabCursor(),e.params.preloadImages&&e.preloadImages(),e.params.loop?e.slideTo(e.params.initialSlide+e.loopedSlides,0,e.params.runCallbacksOnInit):e.slideTo(e.params.initialSlide,0,e.params.runCallbacksOnInit),e.attachEvents(),e.initialized=!0,e.emit("init"))},t.prototype.destroy=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=!0);var a=this,n=a.params,r=a.$el,i=a.$wrapperEl,o=a.slides;return void 0===a.params||a.destroyed?null:(a.emit("beforeDestroy"),a.initialized=!1,a.detachEvents(),n.loop&&a.loopDestroy(),t&&(a.removeClasses(),r.removeAttr("style"),i.removeAttr("style"),o&&o.length&&o.removeClass([n.slideVisibleClass,n.slideActiveClass,n.slideNextClass,n.slidePrevClass].join(" ")).removeAttr("style").removeAttr("data-swiper-slide-index").removeAttr("data-swiper-column").removeAttr("data-swiper-row")),a.emit("destroy"),Object.keys(a.eventsListeners).forEach(function(e){a.off(e)}),!1!==e&&(a.$el[0].swiper=null,a.$el.data("swiper",null),Utils.deleteProps(a)),a.destroyed=!0,null)},t.extendDefaults=function(e){Utils.extend(extendedDefaults,e)},a.extendedDefaults.get=function(){return extendedDefaults},a.defaults.get=function(){return defaults},a.Class.get=function(){return e},a.$.get=function(){return $$1},Object.defineProperties(t,a),t}(Framework7Class),Device$1={name:"device",proto:{device:Device},static:{device:Device}},Support$1={name:"support",proto:{support:Support},static:{support:Support}},Browser$1={name:"browser",proto:{browser:Browser},static:{browser:Browser}},Resize={name:"resize",create:function(){var e=this;Utils.extend(e,{resize:{resizeHandler:function(){e&&!e.destroyed&&e.initialized&&(e.emit("beforeResize"),e.emit("resize"))},orientationChangeHandler:function(){e&&!e.destroyed&&e.initialized&&e.emit("orientationchange")}}})},on:{init:function(){win.addEventListener("resize",this.resize.resizeHandler),win.addEventListener("orientationchange",this.resize.orientationChangeHandler)},destroy:function(){win.removeEventListener("resize",this.resize.resizeHandler),win.removeEventListener("orientationchange",this.resize.orientationChangeHandler)}}},Observer={func:win.MutationObserver||win.WebkitMutationObserver,attach:function(e,t){void 0===t&&(t={});var a=this,n=new(0,Observer.func)(function(e){e.forEach(function(e){a.emit("observerUpdate",e)})});n.observe(e,{attributes:void 0===t.attributes||t.attributes,childList:void 0===t.childList||t.childList,characterData:void 0===t.characterData||t.characterData}),a.observer.observers.push(n)},init:function(){if(Support.observer&&this.params.observer){if(this.params.observeParents)for(var e=this.$el.parents(),t=0;t<e.length;t+=1)this.observer.attach(e[t]);this.observer.attach(this.$el[0],{childList:!1}),this.observer.attach(this.$wrapperEl[0],{attributes:!1})}},destroy:function(){this.observer.observers.forEach(function(e){e.disconnect()}),this.observer.observers=[]}},Observer$1={name:"observer",params:{observer:!1,observeParents:!1},create:function(){Utils.extend(this,{observer:{init:Observer.init.bind(this),attach:Observer.attach.bind(this),destroy:Observer.destroy.bind(this),observers:[]}})},on:{init:function(){this.observer.init()},destroy:function(){this.observer.destroy()}}},Virtual={update:function(e){var t=this,a=t.params,n=a.slidesPerView,r=a.slidesPerGroup,i=a.centeredSlides,o=t.virtual,s=o.from,l=o.to,p=o.slides,c=o.slidesGrid,d=o.renderSlide,u=o.offset;t.updateActiveIndex();var h,f,m,v=t.activeIndex||0;h=t.rtlTranslate?"right":t.isHorizontal()?"left":"top",i?(f=Math.floor(n/2)+r,m=Math.floor(n/2)+r):(f=n+(r-1),m=r);var g=Math.max((v||0)-m,0),b=Math.min((v||0)+f,p.length-1),y=(t.slidesGrid[g]||0)-(t.slidesGrid[0]||0);function w(){t.updateSlides(),t.updateProgress(),t.updateSlidesClasses(),t.lazy&&t.params.lazy.enabled&&t.lazy.load()}if(Utils.extend(t.virtual,{from:g,to:b,offset:y,slidesGrid:t.slidesGrid}),s===g&&l===b&&!e)return t.slidesGrid!==c&&y!==u&&t.slides.css(h,y+"px"),void t.updateProgress();if(t.params.virtual.renderExternal)return t.params.virtual.renderExternal.call(t,{offset:y,from:g,to:b,slides:function(){for(var e=[],t=g;t<=b;t+=1)e.push(p[t]);return e}()}),void w();var $=[],C=[];if(e)t.$wrapperEl.find("."+t.params.slideClass).remove();else for(var x=s;x<=l;x+=1)(x<g||x>b)&&t.$wrapperEl.find("."+t.params.slideClass+'[data-swiper-slide-index="'+x+'"]').remove();for(var E=0;E<p.length;E+=1)E>=g&&E<=b&&(void 0===l||e?C.push(E):(E>l&&C.push(E),E<s&&$.push(E)));C.forEach(function(e){t.$wrapperEl.append(d(p[e],e))}),$.sort(function(e,t){return e<t}).forEach(function(e){t.$wrapperEl.prepend(d(p[e],e))}),t.$wrapperEl.children(".swiper-slide").css(h,y+"px"),w()},renderSlide:function(e,t){var a=this.params.virtual;if(a.cache&&this.virtual.cache[t])return this.virtual.cache[t];var n=a.renderSlide?$$1(a.renderSlide.call(this,e,t)):$$1('<div class="'+this.params.slideClass+'" data-swiper-slide-index="'+t+'">'+e+"</div>");return n.attr("data-swiper-slide-index")||n.attr("data-swiper-slide-index",t),a.cache&&(this.virtual.cache[t]=n),n},appendSlide:function(e){this.virtual.slides.push(e),this.virtual.update(!0)},prependSlide:function(e){if(this.virtual.slides.unshift(e),this.params.virtual.cache){var t=this.virtual.cache,a={};Object.keys(t).forEach(function(e){a[e+1]=t[e]}),this.virtual.cache=a}this.virtual.update(!0),this.slideNext(0)}},Virtual$1={name:"virtual",params:{virtual:{enabled:!1,slides:[],cache:!0,renderSlide:null,renderExternal:null}},create:function(){Utils.extend(this,{virtual:{update:Virtual.update.bind(this),appendSlide:Virtual.appendSlide.bind(this),prependSlide:Virtual.prependSlide.bind(this),renderSlide:Virtual.renderSlide.bind(this),slides:this.params.virtual.slides,cache:{}}})},on:{beforeInit:function(){if(this.params.virtual.enabled){this.classNames.push(this.params.containerModifierClass+"virtual");var e={watchSlidesProgress:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e),this.virtual.update()}},setTranslate:function(){this.params.virtual.enabled&&this.virtual.update()}}},Navigation={update:function(){var e=this.params.navigation;if(!this.params.loop){var t=this.navigation,a=t.$nextEl,n=t.$prevEl;n&&n.length>0&&(this.isBeginning?n.addClass(e.disabledClass):n.removeClass(e.disabledClass),n[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](e.lockClass)),a&&a.length>0&&(this.isEnd?a.addClass(e.disabledClass):a.removeClass(e.disabledClass),a[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](e.lockClass))}},init:function(){var e,t,a=this,n=a.params.navigation;(n.nextEl||n.prevEl)&&(n.nextEl&&(e=$$1(n.nextEl),a.params.uniqueNavElements&&"string"==typeof n.nextEl&&e.length>1&&1===a.$el.find(n.nextEl).length&&(e=a.$el.find(n.nextEl))),n.prevEl&&(t=$$1(n.prevEl),a.params.uniqueNavElements&&"string"==typeof n.prevEl&&t.length>1&&1===a.$el.find(n.prevEl).length&&(t=a.$el.find(n.prevEl))),e&&e.length>0&&e.on("click",function(e){e.preventDefault(),a.isEnd&&!a.params.loop||a.slideNext()}),t&&t.length>0&&t.on("click",function(e){e.preventDefault(),a.isBeginning&&!a.params.loop||a.slidePrev()}),Utils.extend(a.navigation,{$nextEl:e,nextEl:e&&e[0],$prevEl:t,prevEl:t&&t[0]}))},destroy:function(){var e=this.navigation,t=e.$nextEl,a=e.$prevEl;t&&t.length&&(t.off("click"),t.removeClass(this.params.navigation.disabledClass)),a&&a.length&&(a.off("click"),a.removeClass(this.params.navigation.disabledClass))}},Navigation$1={name:"navigation",params:{navigation:{nextEl:null,prevEl:null,hideOnClick:!1,disabledClass:"swiper-button-disabled",hiddenClass:"swiper-button-hidden",lockClass:"swiper-button-lock"}},create:function(){Utils.extend(this,{navigation:{init:Navigation.init.bind(this),update:Navigation.update.bind(this),destroy:Navigation.destroy.bind(this)}})},on:{init:function(){this.navigation.init(),this.navigation.update()},toEdge:function(){this.navigation.update()},fromEdge:function(){this.navigation.update()},destroy:function(){this.navigation.destroy()},click:function(e){var t=this.navigation,a=t.$nextEl,n=t.$prevEl;!this.params.navigation.hideOnClick||$$1(e.target).is(n)||$$1(e.target).is(a)||(a&&a.toggleClass(this.params.navigation.hiddenClass),n&&n.toggleClass(this.params.navigation.hiddenClass))}}},Pagination={update:function(){var e=this,t=e.rtl,a=e.params.pagination;if(a.el&&e.pagination.el&&e.pagination.$el&&0!==e.pagination.$el.length){var n,r=e.virtual&&e.params.virtual.enabled?e.virtual.slides.length:e.slides.length,i=e.pagination.$el,o=e.params.loop?Math.ceil((r-2*e.loopedSlides)/e.params.slidesPerGroup):e.snapGrid.length;if(e.params.loop?((n=Math.ceil((e.activeIndex-e.loopedSlides)/e.params.slidesPerGroup))>r-1-2*e.loopedSlides&&(n-=r-2*e.loopedSlides),n>o-1&&(n-=o),n<0&&"bullets"!==e.params.paginationType&&(n=o+n)):n=void 0!==e.snapIndex?e.snapIndex:e.activeIndex||0,"bullets"===a.type&&e.pagination.bullets&&e.pagination.bullets.length>0){var s,l,p,c=e.pagination.bullets;if(a.dynamicBullets&&(e.pagination.bulletSize=c.eq(0)[e.isHorizontal()?"outerWidth":"outerHeight"](!0),i.css(e.isHorizontal()?"width":"height",e.pagination.bulletSize*(a.dynamicMainBullets+4)+"px"),a.dynamicMainBullets>1&&void 0!==e.previousIndex&&(e.pagination.dynamicBulletIndex+=n-e.previousIndex,e.pagination.dynamicBulletIndex>a.dynamicMainBullets-1?e.pagination.dynamicBulletIndex=a.dynamicMainBullets-1:e.pagination.dynamicBulletIndex<0&&(e.pagination.dynamicBulletIndex=0)),s=n-e.pagination.dynamicBulletIndex,p=((l=s+(Math.min(c.length,a.dynamicMainBullets)-1))+s)/2),c.removeClass(a.bulletActiveClass+" "+a.bulletActiveClass+"-next "+a.bulletActiveClass+"-next-next "+a.bulletActiveClass+"-prev "+a.bulletActiveClass+"-prev-prev "+a.bulletActiveClass+"-main"),i.length>1)c.each(function(e,t){var r=$$1(t),i=r.index();i===n&&r.addClass(a.bulletActiveClass),a.dynamicBullets&&(i>=s&&i<=l&&r.addClass(a.bulletActiveClass+"-main"),i===s&&r.prev().addClass(a.bulletActiveClass+"-prev").prev().addClass(a.bulletActiveClass+"-prev-prev"),i===l&&r.next().addClass(a.bulletActiveClass+"-next").next().addClass(a.bulletActiveClass+"-next-next"))});else if(c.eq(n).addClass(a.bulletActiveClass),a.dynamicBullets){for(var d=c.eq(s),u=c.eq(l),h=s;h<=l;h+=1)c.eq(h).addClass(a.bulletActiveClass+"-main");d.prev().addClass(a.bulletActiveClass+"-prev").prev().addClass(a.bulletActiveClass+"-prev-prev"),u.next().addClass(a.bulletActiveClass+"-next").next().addClass(a.bulletActiveClass+"-next-next")}if(a.dynamicBullets){var f=Math.min(c.length,a.dynamicMainBullets+4),m=(e.pagination.bulletSize*f-e.pagination.bulletSize)/2-p*e.pagination.bulletSize,v=t?"right":"left";c.css(e.isHorizontal()?v:"top",m+"px")}}if("fraction"===a.type&&(i.find("."+a.currentClass).text(n+1),i.find("."+a.totalClass).text(o)),"progressbar"===a.type){var g;g=a.progressbarOpposite?e.isHorizontal()?"vertical":"horizontal":e.isHorizontal()?"horizontal":"vertical";var b=(n+1)/o,y=1,w=1;"horizontal"===g?y=b:w=b,i.find("."+a.progressbarFillClass).transform("translate3d(0,0,0) scaleX("+y+") scaleY("+w+")").transition(e.params.speed)}"custom"===a.type&&a.renderCustom?(i.html(a.renderCustom(e,n+1,o)),e.emit("paginationRender",e,i[0])):e.emit("paginationUpdate",e,i[0]),i[e.params.watchOverflow&&e.isLocked?"addClass":"removeClass"](a.lockClass)}},render:function(){var e=this,t=e.params.pagination;if(t.el&&e.pagination.el&&e.pagination.$el&&0!==e.pagination.$el.length){var a=e.virtual&&e.params.virtual.enabled?e.virtual.slides.length:e.slides.length,n=e.pagination.$el,r="";if("bullets"===t.type){for(var i=e.params.loop?Math.ceil((a-2*e.loopedSlides)/e.params.slidesPerGroup):e.snapGrid.length,o=0;o<i;o+=1)t.renderBullet?r+=t.renderBullet.call(e,o,t.bulletClass):r+="<"+t.bulletElement+' class="'+t.bulletClass+'"></'+t.bulletElement+">";n.html(r),e.pagination.bullets=n.find("."+t.bulletClass)}"fraction"===t.type&&(r=t.renderFraction?t.renderFraction.call(e,t.currentClass,t.totalClass):'<span class="'+t.currentClass+'"></span> / <span class="'+t.totalClass+'"></span>',n.html(r)),"progressbar"===t.type&&(r=t.renderProgressbar?t.renderProgressbar.call(e,t.progressbarFillClass):'<span class="'+t.progressbarFillClass+'"></span>',n.html(r)),"custom"!==t.type&&e.emit("paginationRender",e.pagination.$el[0])}},init:function(){var e=this,t=e.params.pagination;if(t.el){var a=$$1(t.el);0!==a.length&&(e.params.uniqueNavElements&&"string"==typeof t.el&&a.length>1&&1===e.$el.find(t.el).length&&(a=e.$el.find(t.el)),"bullets"===t.type&&t.clickable&&a.addClass(t.clickableClass),a.addClass(t.modifierClass+t.type),"bullets"===t.type&&t.dynamicBullets&&(a.addClass(""+t.modifierClass+t.type+"-dynamic"),e.pagination.dynamicBulletIndex=0,t.dynamicMainBullets<1&&(t.dynamicMainBullets=1)),"progressbar"===t.type&&t.progressbarOpposite&&a.addClass(t.progressbarOppositeClass),t.clickable&&a.on("click","."+t.bulletClass,function(t){t.preventDefault();var a=$$1(this).index()*e.params.slidesPerGroup;e.params.loop&&(a+=e.loopedSlides),e.slideTo(a)}),Utils.extend(e.pagination,{$el:a,el:a[0]}))}},destroy:function(){var e=this.params.pagination;if(e.el&&this.pagination.el&&this.pagination.$el&&0!==this.pagination.$el.length){var t=this.pagination.$el;t.removeClass(e.hiddenClass),t.removeClass(e.modifierClass+e.type),this.pagination.bullets&&this.pagination.bullets.removeClass(e.bulletActiveClass),e.clickable&&t.off("click","."+e.bulletClass)}}},Pagination$1={name:"pagination",params:{pagination:{el:null,bulletElement:"span",clickable:!1,hideOnClick:!1,renderBullet:null,renderProgressbar:null,renderFraction:null,renderCustom:null,progressbarOpposite:!1,type:"bullets",dynamicBullets:!1,dynamicMainBullets:1,bulletClass:"swiper-pagination-bullet",bulletActiveClass:"swiper-pagination-bullet-active",modifierClass:"swiper-pagination-",currentClass:"swiper-pagination-current",totalClass:"swiper-pagination-total",hiddenClass:"swiper-pagination-hidden",progressbarFillClass:"swiper-pagination-progressbar-fill",progressbarOppositeClass:"swiper-pagination-progressbar-opposite",clickableClass:"swiper-pagination-clickable",lockClass:"swiper-pagination-lock"}},create:function(){Utils.extend(this,{pagination:{init:Pagination.init.bind(this),render:Pagination.render.bind(this),update:Pagination.update.bind(this),destroy:Pagination.destroy.bind(this),dynamicBulletIndex:0}})},on:{init:function(){this.pagination.init(),this.pagination.render(),this.pagination.update()},activeIndexChange:function(){this.params.loop?this.pagination.update():void 0===this.snapIndex&&this.pagination.update()},snapIndexChange:function(){this.params.loop||this.pagination.update()},slidesLengthChange:function(){this.params.loop&&(this.pagination.render(),this.pagination.update())},snapGridLengthChange:function(){this.params.loop||(this.pagination.render(),this.pagination.update())},destroy:function(){this.pagination.destroy()},click:function(e){this.params.pagination.el&&this.params.pagination.hideOnClick&&this.pagination.$el.length>0&&!$$1(e.target).hasClass(this.params.pagination.bulletClass)&&this.pagination.$el.toggleClass(this.params.pagination.hiddenClass)}}},Scrollbar={setTranslate:function(){if(this.params.scrollbar.el&&this.scrollbar.el){var e=this.scrollbar,t=this.rtlTranslate,a=this.progress,n=e.dragSize,r=e.trackSize,i=e.$dragEl,o=e.$el,s=this.params.scrollbar,l=n,p=(r-n)*a;t?(p=-p)>0?(l=n-p,p=0):-p+n>r&&(l=r+p):p<0?(l=n+p,p=0):p+n>r&&(l=r-p),this.isHorizontal()?(Support.transforms3d?i.transform("translate3d("+p+"px, 0, 0)"):i.transform("translateX("+p+"px)"),i[0].style.width=l+"px"):(Support.transforms3d?i.transform("translate3d(0px, "+p+"px, 0)"):i.transform("translateY("+p+"px)"),i[0].style.height=l+"px"),s.hide&&(clearTimeout(this.scrollbar.timeout),o[0].style.opacity=1,this.scrollbar.timeout=setTimeout(function(){o[0].style.opacity=0,o.transition(400)},1e3))}},setTransition:function(e){this.params.scrollbar.el&&this.scrollbar.el&&this.scrollbar.$dragEl.transition(e)},updateSize:function(){var e=this;if(e.params.scrollbar.el&&e.scrollbar.el){var t=e.scrollbar,a=t.$dragEl,n=t.$el;a[0].style.width="",a[0].style.height="";var r,i=e.isHorizontal()?n[0].offsetWidth:n[0].offsetHeight,o=e.size/e.virtualSize,s=o*(i/e.size);r="auto"===e.params.scrollbar.dragSize?i*o:parseInt(e.params.scrollbar.dragSize,10),e.isHorizontal()?a[0].style.width=r+"px":a[0].style.height=r+"px",n[0].style.display=o>=1?"none":"",e.params.scrollbarHide&&(n[0].style.opacity=0),Utils.extend(t,{trackSize:i,divider:o,moveDivider:s,dragSize:r}),t.$el[e.params.watchOverflow&&e.isLocked?"addClass":"removeClass"](e.params.scrollbar.lockClass)}},setDragPosition:function(e){var t,a=this,n=a.scrollbar,r=a.rtlTranslate,i=n.$el,o=n.dragSize,s=n.trackSize;t=((a.isHorizontal()?"touchstart"===e.type||"touchmove"===e.type?e.targetTouches[0].pageX:e.pageX||e.clientX:"touchstart"===e.type||"touchmove"===e.type?e.targetTouches[0].pageY:e.pageY||e.clientY)-i.offset()[a.isHorizontal()?"left":"top"]-o/2)/(s-o),t=Math.max(Math.min(t,1),0),r&&(t=1-t);var l=a.minTranslate()+(a.maxTranslate()-a.minTranslate())*t;a.updateProgress(l),a.setTranslate(l),a.updateActiveIndex(),a.updateSlidesClasses()},onDragStart:function(e){var t=this.params.scrollbar,a=this.scrollbar,n=this.$wrapperEl,r=a.$el,i=a.$dragEl;this.scrollbar.isTouched=!0,e.preventDefault(),e.stopPropagation(),n.transition(100),i.transition(100),a.setDragPosition(e),clearTimeout(this.scrollbar.dragTimeout),r.transition(0),t.hide&&r.css("opacity",1),this.emit("scrollbarDragStart",e)},onDragMove:function(e){var t=this.scrollbar,a=this.$wrapperEl,n=t.$el,r=t.$dragEl;this.scrollbar.isTouched&&(e.preventDefault?e.preventDefault():e.returnValue=!1,t.setDragPosition(e),a.transition(0),n.transition(0),r.transition(0),this.emit("scrollbarDragMove",e))},onDragEnd:function(e){var t=this.params.scrollbar,a=this.scrollbar.$el;this.scrollbar.isTouched&&(this.scrollbar.isTouched=!1,t.hide&&(clearTimeout(this.scrollbar.dragTimeout),this.scrollbar.dragTimeout=Utils.nextTick(function(){a.css("opacity",0),a.transition(400)},1e3)),this.emit("scrollbarDragEnd",e),t.snapOnRelease&&this.slideToClosest())},enableDraggable:function(){var e=this;if(e.params.scrollbar.el){var t=e.scrollbar,a=e.touchEvents,n=e.touchEventsDesktop,r=e.params,i=t.$el[0],o=!(!Support.passiveListener||!r.passiveListener)&&{passive:!1,capture:!1},s=!(!Support.passiveListener||!r.passiveListener)&&{passive:!0,capture:!1};Support.touch||!Support.pointerEvents&&!Support.prefixedPointerEvents?(Support.touch&&(i.addEventListener(a.start,e.scrollbar.onDragStart,o),i.addEventListener(a.move,e.scrollbar.onDragMove,o),i.addEventListener(a.end,e.scrollbar.onDragEnd,s)),(r.simulateTouch&&!Device.ios&&!Device.android||r.simulateTouch&&!Support.touch&&Device.ios)&&(i.addEventListener("mousedown",e.scrollbar.onDragStart,o),doc.addEventListener("mousemove",e.scrollbar.onDragMove,o),doc.addEventListener("mouseup",e.scrollbar.onDragEnd,s))):(i.addEventListener(n.start,e.scrollbar.onDragStart,o),doc.addEventListener(n.move,e.scrollbar.onDragMove,o),doc.addEventListener(n.end,e.scrollbar.onDragEnd,s))}},disableDraggable:function(){var e=this;if(e.params.scrollbar.el){var t=e.scrollbar,a=e.touchEvents,n=e.touchEventsDesktop,r=e.params,i=t.$el[0],o=!(!Support.passiveListener||!r.passiveListener)&&{passive:!1,capture:!1},s=!(!Support.passiveListener||!r.passiveListener)&&{passive:!0,capture:!1};Support.touch||!Support.pointerEvents&&!Support.prefixedPointerEvents?(Support.touch&&(i.removeEventListener(a.start,e.scrollbar.onDragStart,o),i.removeEventListener(a.move,e.scrollbar.onDragMove,o),i.removeEventListener(a.end,e.scrollbar.onDragEnd,s)),(r.simulateTouch&&!Device.ios&&!Device.android||r.simulateTouch&&!Support.touch&&Device.ios)&&(i.removeEventListener("mousedown",e.scrollbar.onDragStart,o),doc.removeEventListener("mousemove",e.scrollbar.onDragMove,o),doc.removeEventListener("mouseup",e.scrollbar.onDragEnd,s))):(i.removeEventListener(n.start,e.scrollbar.onDragStart,o),doc.removeEventListener(n.move,e.scrollbar.onDragMove,o),doc.removeEventListener(n.end,e.scrollbar.onDragEnd,s))}},init:function(){if(this.params.scrollbar.el){var e=this.scrollbar,t=this.$el,a=this.params.scrollbar,n=$$1(a.el);this.params.uniqueNavElements&&"string"==typeof a.el&&n.length>1&&1===t.find(a.el).length&&(n=t.find(a.el));var r=n.find("."+this.params.scrollbar.dragClass);0===r.length&&(r=$$1('<div class="'+this.params.scrollbar.dragClass+'"></div>'),n.append(r)),Utils.extend(e,{$el:n,el:n[0],$dragEl:r,dragEl:r[0]}),a.draggable&&e.enableDraggable()}},destroy:function(){this.scrollbar.disableDraggable()}},Scrollbar$1={name:"scrollbar",params:{scrollbar:{el:null,dragSize:"auto",hide:!1,draggable:!1,snapOnRelease:!0,lockClass:"swiper-scrollbar-lock",dragClass:"swiper-scrollbar-drag"}},create:function(){var e=this;Utils.extend(e,{scrollbar:{init:Scrollbar.init.bind(e),destroy:Scrollbar.destroy.bind(e),updateSize:Scrollbar.updateSize.bind(e),setTranslate:Scrollbar.setTranslate.bind(e),setTransition:Scrollbar.setTransition.bind(e),enableDraggable:Scrollbar.enableDraggable.bind(e),disableDraggable:Scrollbar.disableDraggable.bind(e),setDragPosition:Scrollbar.setDragPosition.bind(e),onDragStart:Scrollbar.onDragStart.bind(e),onDragMove:Scrollbar.onDragMove.bind(e),onDragEnd:Scrollbar.onDragEnd.bind(e),isTouched:!1,timeout:null,dragTimeout:null}})},on:{init:function(){this.scrollbar.init(),this.scrollbar.updateSize(),this.scrollbar.setTranslate()},update:function(){this.scrollbar.updateSize()},resize:function(){this.scrollbar.updateSize()},observerUpdate:function(){this.scrollbar.updateSize()},setTranslate:function(){this.scrollbar.setTranslate()},setTransition:function(e){this.scrollbar.setTransition(e)},destroy:function(){this.scrollbar.destroy()}}},Parallax={setTransform:function(e,t){var a=this.rtl,n=$$1(e),r=a?-1:1,i=n.attr("data-swiper-parallax")||"0",o=n.attr("data-swiper-parallax-x"),s=n.attr("data-swiper-parallax-y"),l=n.attr("data-swiper-parallax-scale"),p=n.attr("data-swiper-parallax-opacity");if(o||s?(o=o||"0",s=s||"0"):this.isHorizontal()?(o=i,s="0"):(s=i,o="0"),o=o.indexOf("%")>=0?parseInt(o,10)*t*r+"%":o*t*r+"px",s=s.indexOf("%")>=0?parseInt(s,10)*t+"%":s*t+"px",void 0!==p&&null!==p){var c=p-(p-1)*(1-Math.abs(t));n[0].style.opacity=c}if(void 0===l||null===l)n.transform("translate3d("+o+", "+s+", 0px)");else{var d=l-(l-1)*(1-Math.abs(t));n.transform("translate3d("+o+", "+s+", 0px) scale("+d+")")}},setTranslate:function(){var e=this,t=e.$el,a=e.slides,n=e.progress,r=e.snapGrid;t.children("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]").each(function(t,a){e.parallax.setTransform(a,n)}),a.each(function(t,a){var i=a.progress;e.params.slidesPerGroup>1&&"auto"!==e.params.slidesPerView&&(i+=Math.ceil(t/2)-n*(r.length-1)),i=Math.min(Math.max(i,-1),1),$$1(a).find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]").each(function(t,a){e.parallax.setTransform(a,i)})})},setTransition:function(e){void 0===e&&(e=this.params.speed);this.$el.find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]").each(function(t,a){var n=$$1(a),r=parseInt(n.attr("data-swiper-parallax-duration"),10)||e;0===e&&(r=0),n.transition(r)})}},Parallax$1={name:"parallax",params:{parallax:{enabled:!1}},create:function(){Utils.extend(this,{parallax:{setTransform:Parallax.setTransform.bind(this),setTranslate:Parallax.setTranslate.bind(this),setTransition:Parallax.setTransition.bind(this)}})},on:{beforeInit:function(){this.params.parallax.enabled&&(this.params.watchSlidesProgress=!0)},init:function(){this.params.parallax&&this.parallax.setTranslate()},setTranslate:function(){this.params.parallax&&this.parallax.setTranslate()},setTransition:function(e){this.params.parallax&&this.parallax.setTransition(e)}}},Zoom={getDistanceBetweenTouches:function(e){if(e.targetTouches.length<2)return 1;var t=e.targetTouches[0].pageX,a=e.targetTouches[0].pageY,n=e.targetTouches[1].pageX,r=e.targetTouches[1].pageY;return Math.sqrt(Math.pow(n-t,2)+Math.pow(r-a,2))},onGestureStart:function(e){var t=this.params.zoom,a=this.zoom,n=a.gesture;if(a.fakeGestureTouched=!1,a.fakeGestureMoved=!1,!Support.gestures){if("touchstart"!==e.type||"touchstart"===e.type&&e.targetTouches.length<2)return;a.fakeGestureTouched=!0,n.scaleStart=Zoom.getDistanceBetweenTouches(e)}n.$slideEl&&n.$slideEl.length||(n.$slideEl=$$1(e.target).closest(".swiper-slide"),0===n.$slideEl.length&&(n.$slideEl=this.slides.eq(this.activeIndex)),n.$imageEl=n.$slideEl.find("img, svg, canvas"),n.$imageWrapEl=n.$imageEl.parent("."+t.containerClass),n.maxRatio=n.$imageWrapEl.attr("data-swiper-zoom")||t.maxRatio,0!==n.$imageWrapEl.length)?(n.$imageEl.transition(0),this.zoom.isScaling=!0):n.$imageEl=void 0},onGestureChange:function(e){var t=this.params.zoom,a=this.zoom,n=a.gesture;if(!Support.gestures){if("touchmove"!==e.type||"touchmove"===e.type&&e.targetTouches.length<2)return;a.fakeGestureMoved=!0,n.scaleMove=Zoom.getDistanceBetweenTouches(e)}n.$imageEl&&0!==n.$imageEl.length&&(Support.gestures?this.zoom.scale=e.scale*a.currentScale:a.scale=n.scaleMove/n.scaleStart*a.currentScale,a.scale>n.maxRatio&&(a.scale=n.maxRatio-1+Math.pow(a.scale-n.maxRatio+1,.5)),a.scale<t.minRatio&&(a.scale=t.minRatio+1-Math.pow(t.minRatio-a.scale+1,.5)),n.$imageEl.transform("translate3d(0,0,0) scale("+a.scale+")"))},onGestureEnd:function(e){var t=this.params.zoom,a=this.zoom,n=a.gesture;if(!Support.gestures){if(!a.fakeGestureTouched||!a.fakeGestureMoved)return;if("touchend"!==e.type||"touchend"===e.type&&e.changedTouches.length<2&&!Device.android)return;a.fakeGestureTouched=!1,a.fakeGestureMoved=!1}n.$imageEl&&0!==n.$imageEl.length&&(a.scale=Math.max(Math.min(a.scale,n.maxRatio),t.minRatio),n.$imageEl.transition(this.params.speed).transform("translate3d(0,0,0) scale("+a.scale+")"),a.currentScale=a.scale,a.isScaling=!1,1===a.scale&&(n.$slideEl=void 0))},onTouchStart:function(e){var t=this.zoom,a=t.gesture,n=t.image;a.$imageEl&&0!==a.$imageEl.length&&(n.isTouched||(Device.android&&e.preventDefault(),n.isTouched=!0,n.touchesStart.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,n.touchesStart.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY))},onTouchMove:function(e){var t=this.zoom,a=t.gesture,n=t.image,r=t.velocity;if(a.$imageEl&&0!==a.$imageEl.length&&(this.allowClick=!1,n.isTouched&&a.$slideEl)){n.isMoved||(n.width=a.$imageEl[0].offsetWidth,n.height=a.$imageEl[0].offsetHeight,n.startX=Utils.getTranslate(a.$imageWrapEl[0],"x")||0,n.startY=Utils.getTranslate(a.$imageWrapEl[0],"y")||0,a.slideWidth=a.$slideEl[0].offsetWidth,a.slideHeight=a.$slideEl[0].offsetHeight,a.$imageWrapEl.transition(0),this.rtl&&(n.startX=-n.startX,n.startY=-n.startY));var i=n.width*t.scale,o=n.height*t.scale;if(!(i<a.slideWidth&&o<a.slideHeight)){if(n.minX=Math.min(a.slideWidth/2-i/2,0),n.maxX=-n.minX,n.minY=Math.min(a.slideHeight/2-o/2,0),n.maxY=-n.minY,n.touchesCurrent.x="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,n.touchesCurrent.y="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,!n.isMoved&&!t.isScaling){if(this.isHorizontal()&&(Math.floor(n.minX)===Math.floor(n.startX)&&n.touchesCurrent.x<n.touchesStart.x||Math.floor(n.maxX)===Math.floor(n.startX)&&n.touchesCurrent.x>n.touchesStart.x))return void(n.isTouched=!1);if(!this.isHorizontal()&&(Math.floor(n.minY)===Math.floor(n.startY)&&n.touchesCurrent.y<n.touchesStart.y||Math.floor(n.maxY)===Math.floor(n.startY)&&n.touchesCurrent.y>n.touchesStart.y))return void(n.isTouched=!1)}e.preventDefault(),e.stopPropagation(),n.isMoved=!0,n.currentX=n.touchesCurrent.x-n.touchesStart.x+n.startX,n.currentY=n.touchesCurrent.y-n.touchesStart.y+n.startY,n.currentX<n.minX&&(n.currentX=n.minX+1-Math.pow(n.minX-n.currentX+1,.8)),n.currentX>n.maxX&&(n.currentX=n.maxX-1+Math.pow(n.currentX-n.maxX+1,.8)),n.currentY<n.minY&&(n.currentY=n.minY+1-Math.pow(n.minY-n.currentY+1,.8)),n.currentY>n.maxY&&(n.currentY=n.maxY-1+Math.pow(n.currentY-n.maxY+1,.8)),r.prevPositionX||(r.prevPositionX=n.touchesCurrent.x),r.prevPositionY||(r.prevPositionY=n.touchesCurrent.y),r.prevTime||(r.prevTime=Date.now()),r.x=(n.touchesCurrent.x-r.prevPositionX)/(Date.now()-r.prevTime)/2,r.y=(n.touchesCurrent.y-r.prevPositionY)/(Date.now()-r.prevTime)/2,Math.abs(n.touchesCurrent.x-r.prevPositionX)<2&&(r.x=0),Math.abs(n.touchesCurrent.y-r.prevPositionY)<2&&(r.y=0),r.prevPositionX=n.touchesCurrent.x,r.prevPositionY=n.touchesCurrent.y,r.prevTime=Date.now(),a.$imageWrapEl.transform("translate3d("+n.currentX+"px, "+n.currentY+"px,0)")}}},onTouchEnd:function(){var e=this.zoom,t=e.gesture,a=e.image,n=e.velocity;if(t.$imageEl&&0!==t.$imageEl.length){if(!a.isTouched||!a.isMoved)return a.isTouched=!1,void(a.isMoved=!1);a.isTouched=!1,a.isMoved=!1;var r=300,i=300,o=n.x*r,s=a.currentX+o,l=n.y*i,p=a.currentY+l;0!==n.x&&(r=Math.abs((s-a.currentX)/n.x)),0!==n.y&&(i=Math.abs((p-a.currentY)/n.y));var c=Math.max(r,i);a.currentX=s,a.currentY=p;var d=a.width*e.scale,u=a.height*e.scale;a.minX=Math.min(t.slideWidth/2-d/2,0),a.maxX=-a.minX,a.minY=Math.min(t.slideHeight/2-u/2,0),a.maxY=-a.minY,a.currentX=Math.max(Math.min(a.currentX,a.maxX),a.minX),a.currentY=Math.max(Math.min(a.currentY,a.maxY),a.minY),t.$imageWrapEl.transition(c).transform("translate3d("+a.currentX+"px, "+a.currentY+"px,0)")}},onTransitionEnd:function(){var e=this.zoom,t=e.gesture;t.$slideEl&&this.previousIndex!==this.activeIndex&&(t.$imageEl.transform("translate3d(0,0,0) scale(1)"),t.$imageWrapEl.transform("translate3d(0,0,0)"),t.$slideEl=void 0,t.$imageEl=void 0,t.$imageWrapEl=void 0,e.scale=1,e.currentScale=1)},toggle:function(e){var t=this.zoom;t.scale&&1!==t.scale?t.out():t.in(e)},in:function(e){var t,a,n,r,i,o,s,l,p,c,d,u,h,f,m,v,g=this.zoom,b=this.params.zoom,y=g.gesture,w=g.image;(y.$slideEl||(y.$slideEl=this.clickedSlide?$$1(this.clickedSlide):this.slides.eq(this.activeIndex),y.$imageEl=y.$slideEl.find("img, svg, canvas"),y.$imageWrapEl=y.$imageEl.parent("."+b.containerClass)),y.$imageEl&&0!==y.$imageEl.length)&&(y.$slideEl.addClass(""+b.zoomedSlideClass),void 0===w.touchesStart.x&&e?(t="touchend"===e.type?e.changedTouches[0].pageX:e.pageX,a="touchend"===e.type?e.changedTouches[0].pageY:e.pageY):(t=w.touchesStart.x,a=w.touchesStart.y),g.scale=y.$imageWrapEl.attr("data-swiper-zoom")||b.maxRatio,g.currentScale=y.$imageWrapEl.attr("data-swiper-zoom")||b.maxRatio,e?(m=y.$slideEl[0].offsetWidth,v=y.$slideEl[0].offsetHeight,n=y.$slideEl.offset().left+m/2-t,r=y.$slideEl.offset().top+v/2-a,s=y.$imageEl[0].offsetWidth,l=y.$imageEl[0].offsetHeight,p=s*g.scale,c=l*g.scale,h=-(d=Math.min(m/2-p/2,0)),f=-(u=Math.min(v/2-c/2,0)),i=n*g.scale,o=r*g.scale,i<d&&(i=d),i>h&&(i=h),o<u&&(o=u),o>f&&(o=f)):(i=0,o=0),y.$imageWrapEl.transition(300).transform("translate3d("+i+"px, "+o+"px,0)"),y.$imageEl.transition(300).transform("translate3d(0,0,0) scale("+g.scale+")"))},out:function(){var e=this.zoom,t=this.params.zoom,a=e.gesture;a.$slideEl||(a.$slideEl=this.clickedSlide?$$1(this.clickedSlide):this.slides.eq(this.activeIndex),a.$imageEl=a.$slideEl.find("img, svg, canvas"),a.$imageWrapEl=a.$imageEl.parent("."+t.containerClass)),a.$imageEl&&0!==a.$imageEl.length&&(e.scale=1,e.currentScale=1,a.$imageWrapEl.transition(300).transform("translate3d(0,0,0)"),a.$imageEl.transition(300).transform("translate3d(0,0,0) scale(1)"),a.$slideEl.removeClass(""+t.zoomedSlideClass),a.$slideEl=void 0)},enable:function(){var e=this,t=e.zoom;if(!t.enabled){t.enabled=!0;var a=!("touchstart"!==e.touchEvents.start||!Support.passiveListener||!e.params.passiveListeners)&&{passive:!0,capture:!1};Support.gestures?(e.$wrapperEl.on("gesturestart",".swiper-slide",t.onGestureStart,a),e.$wrapperEl.on("gesturechange",".swiper-slide",t.onGestureChange,a),e.$wrapperEl.on("gestureend",".swiper-slide",t.onGestureEnd,a)):"touchstart"===e.touchEvents.start&&(e.$wrapperEl.on(e.touchEvents.start,".swiper-slide",t.onGestureStart,a),e.$wrapperEl.on(e.touchEvents.move,".swiper-slide",t.onGestureChange,a),e.$wrapperEl.on(e.touchEvents.end,".swiper-slide",t.onGestureEnd,a)),e.$wrapperEl.on(e.touchEvents.move,"."+e.params.zoom.containerClass,t.onTouchMove)}},disable:function(){var e=this,t=e.zoom;if(t.enabled){e.zoom.enabled=!1;var a=!("touchstart"!==e.touchEvents.start||!Support.passiveListener||!e.params.passiveListeners)&&{passive:!0,capture:!1};Support.gestures?(e.$wrapperEl.off("gesturestart",".swiper-slide",t.onGestureStart,a),e.$wrapperEl.off("gesturechange",".swiper-slide",t.onGestureChange,a),e.$wrapperEl.off("gestureend",".swiper-slide",t.onGestureEnd,a)):"touchstart"===e.touchEvents.start&&(e.$wrapperEl.off(e.touchEvents.start,".swiper-slide",t.onGestureStart,a),e.$wrapperEl.off(e.touchEvents.move,".swiper-slide",t.onGestureChange,a),e.$wrapperEl.off(e.touchEvents.end,".swiper-slide",t.onGestureEnd,a)),e.$wrapperEl.off(e.touchEvents.move,"."+e.params.zoom.containerClass,t.onTouchMove)}}},Zoom$1={name:"zoom",params:{zoom:{enabled:!1,maxRatio:3,minRatio:1,toggle:!0,containerClass:"swiper-zoom-container",zoomedSlideClass:"swiper-slide-zoomed"}},create:function(){var e=this,t={enabled:!1,scale:1,currentScale:1,isScaling:!1,gesture:{$slideEl:void 0,slideWidth:void 0,slideHeight:void 0,$imageEl:void 0,$imageWrapEl:void 0,maxRatio:3},image:{isTouched:void 0,isMoved:void 0,currentX:void 0,currentY:void 0,minX:void 0,minY:void 0,maxX:void 0,maxY:void 0,width:void 0,height:void 0,startX:void 0,startY:void 0,touchesStart:{},touchesCurrent:{}},velocity:{x:void 0,y:void 0,prevPositionX:void 0,prevPositionY:void 0,prevTime:void 0}};"onGestureStart onGestureChange onGestureEnd onTouchStart onTouchMove onTouchEnd onTransitionEnd toggle enable disable in out".split(" ").forEach(function(a){t[a]=Zoom[a].bind(e)}),Utils.extend(e,{zoom:t})},on:{init:function(){this.params.zoom.enabled&&this.zoom.enable()},destroy:function(){this.zoom.disable()},touchStart:function(e){this.zoom.enabled&&this.zoom.onTouchStart(e)},touchEnd:function(e){this.zoom.enabled&&this.zoom.onTouchEnd(e)},doubleTap:function(e){this.params.zoom.enabled&&this.zoom.enabled&&this.params.zoom.toggle&&this.zoom.toggle(e)},transitionEnd:function(){this.zoom.enabled&&this.params.zoom.enabled&&this.zoom.onTransitionEnd()}}},Lazy$2={loadInSlide:function(e,t){void 0===t&&(t=!0);var a=this,n=a.params.lazy;if(void 0!==e&&0!==a.slides.length){var r=a.virtual&&a.params.virtual.enabled?a.$wrapperEl.children("."+a.params.slideClass+'[data-swiper-slide-index="'+e+'"]'):a.slides.eq(e),i=r.find("."+n.elementClass+":not(."+n.loadedClass+"):not(."+n.loadingClass+")");!r.hasClass(n.elementClass)||r.hasClass(n.loadedClass)||r.hasClass(n.loadingClass)||(i=i.add(r[0])),0!==i.length&&i.each(function(e,i){var o=$$1(i);o.addClass(n.loadingClass);var s=o.attr("data-background"),l=o.attr("data-src"),p=o.attr("data-srcset"),c=o.attr("data-sizes");a.loadImage(o[0],l||s,p,c,!1,function(){if(void 0!==a&&null!==a&&a&&(!a||a.params)&&!a.destroyed){if(s?(o.css("background-image",'url("'+s+'")'),o.removeAttr("data-background")):(p&&(o.attr("srcset",p),o.removeAttr("data-srcset")),c&&(o.attr("sizes",c),o.removeAttr("data-sizes")),l&&(o.attr("src",l),o.removeAttr("data-src"))),o.addClass(n.loadedClass).removeClass(n.loadingClass),r.find("."+n.preloaderClass).remove(),a.params.loop&&t){var e=r.attr("data-swiper-slide-index");if(r.hasClass(a.params.slideDuplicateClass)){var i=a.$wrapperEl.children('[data-swiper-slide-index="'+e+'"]:not(.'+a.params.slideDuplicateClass+")");a.lazy.loadInSlide(i.index(),!1)}else{var d=a.$wrapperEl.children("."+a.params.slideDuplicateClass+'[data-swiper-slide-index="'+e+'"]');a.lazy.loadInSlide(d.index(),!1)}}a.emit("lazyImageReady",r[0],o[0])}}),a.emit("lazyImageLoad",r[0],o[0])})}},load:function(){var e=this,t=e.$wrapperEl,a=e.params,n=e.slides,r=e.activeIndex,i=e.virtual&&a.virtual.enabled,o=a.lazy,s=a.slidesPerView;function l(e){if(i){if(t.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]').length)return!0}else if(n[e])return!0;return!1}function p(e){return i?$$1(e).attr("data-swiper-slide-index"):$$1(e).index()}if("auto"===s&&(s=0),e.lazy.initialImageLoaded||(e.lazy.initialImageLoaded=!0),e.params.watchSlidesVisibility)t.children("."+a.slideVisibleClass).each(function(t,a){var n=i?$$1(a).attr("data-swiper-slide-index"):$$1(a).index();e.lazy.loadInSlide(n)});else if(s>1)for(var c=r;c<r+s;c+=1)l(c)&&e.lazy.loadInSlide(c);else e.lazy.loadInSlide(r);if(o.loadPrevNext)if(s>1||o.loadPrevNextAmount&&o.loadPrevNextAmount>1){for(var d=o.loadPrevNextAmount,u=s,h=Math.min(r+u+Math.max(d,u),n.length),f=Math.max(r-Math.max(u,d),0),m=r+s;m<h;m+=1)l(m)&&e.lazy.loadInSlide(m);for(var v=f;v<r;v+=1)l(v)&&e.lazy.loadInSlide(v)}else{var g=t.children("."+a.slideNextClass);g.length>0&&e.lazy.loadInSlide(p(g));var b=t.children("."+a.slidePrevClass);b.length>0&&e.lazy.loadInSlide(p(b))}}},Lazy$3={name:"lazy",params:{lazy:{enabled:!1,loadPrevNext:!1,loadPrevNextAmount:1,loadOnTransitionStart:!1,elementClass:"swiper-lazy",loadingClass:"swiper-lazy-loading",loadedClass:"swiper-lazy-loaded",preloaderClass:"swiper-lazy-preloader"}},create:function(){Utils.extend(this,{lazy:{initialImageLoaded:!1,load:Lazy$2.load.bind(this),loadInSlide:Lazy$2.loadInSlide.bind(this)}})},on:{beforeInit:function(){this.params.lazy.enabled&&this.params.preloadImages&&(this.params.preloadImages=!1)},init:function(){this.params.lazy.enabled&&!this.params.loop&&0===this.params.initialSlide&&this.lazy.load()},scroll:function(){this.params.freeMode&&!this.params.freeModeSticky&&this.lazy.load()},resize:function(){this.params.lazy.enabled&&this.lazy.load()},scrollbarDragMove:function(){this.params.lazy.enabled&&this.lazy.load()},transitionStart:function(){this.params.lazy.enabled&&(this.params.lazy.loadOnTransitionStart||!this.params.lazy.loadOnTransitionStart&&!this.lazy.initialImageLoaded)&&this.lazy.load()},transitionEnd:function(){this.params.lazy.enabled&&!this.params.lazy.loadOnTransitionStart&&this.lazy.load()}}},Controller={LinearSpline:function(e,t){var a,n,r,i,o,s=function(e,t){for(n=-1,a=e.length;a-n>1;)e[r=a+n>>1]<=t?n=r:a=r;return a};return this.x=e,this.y=t,this.lastIndex=e.length-1,this.interpolate=function(e){return e?(o=s(this.x,e),i=o-1,(e-this.x[i])*(this.y[o]-this.y[i])/(this.x[o]-this.x[i])+this.y[i]):0},this},getInterpolateFunction:function(e){this.controller.spline||(this.controller.spline=this.params.loop?new Controller.LinearSpline(this.slidesGrid,e.slidesGrid):new Controller.LinearSpline(this.snapGrid,e.snapGrid))},setTranslate:function(e,t){var a,n,r=this,i=r.controller.control;function o(e){var t=r.rtlTranslate?-r.translate:r.translate;"slide"===r.params.controller.by&&(r.controller.getInterpolateFunction(e),n=-r.controller.spline.interpolate(-t)),n&&"container"!==r.params.controller.by||(a=(e.maxTranslate()-e.minTranslate())/(r.maxTranslate()-r.minTranslate()),n=(t-r.minTranslate())*a+e.minTranslate()),r.params.controller.inverse&&(n=e.maxTranslate()-n),e.updateProgress(n),e.setTranslate(n,r),e.updateActiveIndex(),e.updateSlidesClasses()}if(Array.isArray(i))for(var s=0;s<i.length;s+=1)i[s]!==t&&i[s]instanceof Swiper&&o(i[s]);else i instanceof Swiper&&t!==i&&o(i)},setTransition:function(e,t){var a,n=this,r=n.controller.control;function i(t){t.setTransition(e,n),0!==e&&(t.transitionStart(),t.$wrapperEl.transitionEnd(function(){r&&(t.params.loop&&"slide"===n.params.controller.by&&t.loopFix(),t.transitionEnd())}))}if(Array.isArray(r))for(a=0;a<r.length;a+=1)r[a]!==t&&r[a]instanceof Swiper&&i(r[a]);else r instanceof Swiper&&t!==r&&i(r)}},Controller$1={name:"controller",params:{controller:{control:void 0,inverse:!1,by:"slide"}},create:function(){Utils.extend(this,{controller:{control:this.params.controller.control,getInterpolateFunction:Controller.getInterpolateFunction.bind(this),setTranslate:Controller.setTranslate.bind(this),setTransition:Controller.setTransition.bind(this)}})},on:{update:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},resize:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},observerUpdate:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},setTranslate:function(e,t){this.controller.control&&this.controller.setTranslate(e,t)},setTransition:function(e,t){this.controller.control&&this.controller.setTransition(e,t)}}},a11y={makeElFocusable:function(e){return e.attr("tabIndex","0"),e},addElRole:function(e,t){return e.attr("role",t),e},addElLabel:function(e,t){return e.attr("aria-label",t),e},disableEl:function(e){return e.attr("aria-disabled",!0),e},enableEl:function(e){return e.attr("aria-disabled",!1),e},onEnterKey:function(e){var t=this,a=t.params.a11y;if(13===e.keyCode){var n=$$1(e.target);t.navigation&&t.navigation.$nextEl&&n.is(t.navigation.$nextEl)&&(t.isEnd&&!t.params.loop||t.slideNext(),t.isEnd?t.a11y.notify(a.lastSlideMessage):t.a11y.notify(a.nextSlideMessage)),t.navigation&&t.navigation.$prevEl&&n.is(t.navigation.$prevEl)&&(t.isBeginning&&!t.params.loop||t.slidePrev(),t.isBeginning?t.a11y.notify(a.firstSlideMessage):t.a11y.notify(a.prevSlideMessage)),t.pagination&&n.is("."+t.params.pagination.bulletClass)&&n[0].click()}},notify:function(e){var t=this.a11y.liveRegion;0!==t.length&&(t.html(""),t.html(e))},updateNavigation:function(){if(!this.params.loop){var e=this.navigation,t=e.$nextEl,a=e.$prevEl;a&&a.length>0&&(this.isBeginning?this.a11y.disableEl(a):this.a11y.enableEl(a)),t&&t.length>0&&(this.isEnd?this.a11y.disableEl(t):this.a11y.enableEl(t))}},updatePagination:function(){var e=this,t=e.params.a11y;e.pagination&&e.params.pagination.clickable&&e.pagination.bullets&&e.pagination.bullets.length&&e.pagination.bullets.each(function(a,n){var r=$$1(n);e.a11y.makeElFocusable(r),e.a11y.addElRole(r,"button"),e.a11y.addElLabel(r,t.paginationBulletMessage.replace(/{{index}}/,r.index()+1))})},init:function(){var e=this;e.$el.append(e.a11y.liveRegion);var t,a,n=e.params.a11y;e.navigation&&e.navigation.$nextEl&&(t=e.navigation.$nextEl),e.navigation&&e.navigation.$prevEl&&(a=e.navigation.$prevEl),t&&(e.a11y.makeElFocusable(t),e.a11y.addElRole(t,"button"),e.a11y.addElLabel(t,n.nextSlideMessage),t.on("keydown",e.a11y.onEnterKey)),a&&(e.a11y.makeElFocusable(a),e.a11y.addElRole(a,"button"),e.a11y.addElLabel(a,n.prevSlideMessage),a.on("keydown",e.a11y.onEnterKey)),e.pagination&&e.params.pagination.clickable&&e.pagination.bullets&&e.pagination.bullets.length&&e.pagination.$el.on("keydown","."+e.params.pagination.bulletClass,e.a11y.onEnterKey)},destroy:function(){var e,t,a=this;a.a11y.liveRegion&&a.a11y.liveRegion.length>0&&a.a11y.liveRegion.remove(),a.navigation&&a.navigation.$nextEl&&(e=a.navigation.$nextEl),a.navigation&&a.navigation.$prevEl&&(t=a.navigation.$prevEl),e&&e.off("keydown",a.a11y.onEnterKey),t&&t.off("keydown",a.a11y.onEnterKey),a.pagination&&a.params.pagination.clickable&&a.pagination.bullets&&a.pagination.bullets.length&&a.pagination.$el.off("keydown","."+a.params.pagination.bulletClass,a.a11y.onEnterKey)}},A11y={name:"a11y",params:{a11y:{enabled:!0,notificationClass:"swiper-notification",prevSlideMessage:"Previous slide",nextSlideMessage:"Next slide",firstSlideMessage:"This is the first slide",lastSlideMessage:"This is the last slide",paginationBulletMessage:"Go to slide {{index}}"}},create:function(){var e=this;Utils.extend(e,{a11y:{liveRegion:$$1('<span class="'+e.params.a11y.notificationClass+'" aria-live="assertive" aria-atomic="true"></span>')}}),Object.keys(a11y).forEach(function(t){e.a11y[t]=a11y[t].bind(e)})},on:{init:function(){this.params.a11y.enabled&&(this.a11y.init(),this.a11y.updateNavigation())},toEdge:function(){this.params.a11y.enabled&&this.a11y.updateNavigation()},fromEdge:function(){this.params.a11y.enabled&&this.a11y.updateNavigation()},paginationUpdate:function(){this.params.a11y.enabled&&this.a11y.updatePagination()},destroy:function(){this.params.a11y.enabled&&this.a11y.destroy()}}},Autoplay={run:function(){var e=this,t=e.slides.eq(e.activeIndex),a=e.params.autoplay.delay;t.attr("data-swiper-autoplay")&&(a=t.attr("data-swiper-autoplay")||e.params.autoplay.delay),e.autoplay.timeout=Utils.nextTick(function(){e.params.autoplay.reverseDirection?e.params.loop?(e.loopFix(),e.slidePrev(e.params.speed,!0,!0),e.emit("autoplay")):e.isBeginning?e.params.autoplay.stopOnLastSlide?e.autoplay.stop():(e.slideTo(e.slides.length-1,e.params.speed,!0,!0),e.emit("autoplay")):(e.slidePrev(e.params.speed,!0,!0),e.emit("autoplay")):e.params.loop?(e.loopFix(),e.slideNext(e.params.speed,!0,!0),e.emit("autoplay")):e.isEnd?e.params.autoplay.stopOnLastSlide?e.autoplay.stop():(e.slideTo(0,e.params.speed,!0,!0),e.emit("autoplay")):(e.slideNext(e.params.speed,!0,!0),e.emit("autoplay"))},a)},start:function(){return void 0===this.autoplay.timeout&&(!this.autoplay.running&&(this.autoplay.running=!0,this.emit("autoplayStart"),this.autoplay.run(),!0))},stop:function(){return!!this.autoplay.running&&(void 0!==this.autoplay.timeout&&(this.autoplay.timeout&&(clearTimeout(this.autoplay.timeout),this.autoplay.timeout=void 0),this.autoplay.running=!1,this.emit("autoplayStop"),!0))},pause:function(e){var t=this;t.autoplay.running&&(t.autoplay.paused||(t.autoplay.timeout&&clearTimeout(t.autoplay.timeout),t.autoplay.paused=!0,0!==e&&t.params.autoplay.waitForTransition?(t.$wrapperEl[0].addEventListener("transitionend",t.autoplay.onTransitionEnd),t.$wrapperEl[0].addEventListener("webkitTransitionEnd",t.autoplay.onTransitionEnd)):(t.autoplay.paused=!1,t.autoplay.run())))}},Autoplay$1={name:"autoplay",params:{autoplay:{enabled:!1,delay:3e3,waitForTransition:!0,disableOnInteraction:!0,stopOnLastSlide:!1,reverseDirection:!1}},create:function(){var e=this;Utils.extend(e,{autoplay:{running:!1,paused:!1,run:Autoplay.run.bind(e),start:Autoplay.start.bind(e),stop:Autoplay.stop.bind(e),pause:Autoplay.pause.bind(e),onTransitionEnd:function(t){e&&!e.destroyed&&e.$wrapperEl&&t.target===this&&(e.$wrapperEl[0].removeEventListener("transitionend",e.autoplay.onTransitionEnd),e.$wrapperEl[0].removeEventListener("webkitTransitionEnd",e.autoplay.onTransitionEnd),e.autoplay.paused=!1,e.autoplay.running?e.autoplay.run():e.autoplay.stop())}}})},on:{init:function(){this.params.autoplay.enabled&&this.autoplay.start()},beforeTransitionStart:function(e,t){this.autoplay.running&&(t||!this.params.autoplay.disableOnInteraction?this.autoplay.pause(e):this.autoplay.stop())},sliderFirstMove:function(){this.autoplay.running&&(this.params.autoplay.disableOnInteraction?this.autoplay.stop():this.autoplay.pause())},destroy:function(){this.autoplay.running&&this.autoplay.stop()}}},Fade={setTranslate:function(){for(var e=this.slides,t=0;t<e.length;t+=1){var a=this.slides.eq(t),n=-a[0].swiperSlideOffset;this.params.virtualTranslate||(n-=this.translate);var r=0;this.isHorizontal()||(r=n,n=0);var i=this.params.fadeEffect.crossFade?Math.max(1-Math.abs(a[0].progress),0):1+Math.min(Math.max(a[0].progress,-1),0);a.css({opacity:i}).transform("translate3d("+n+"px, "+r+"px, 0px)")}},setTransition:function(e){var t=this,a=t.slides,n=t.$wrapperEl;if(a.transition(e),t.params.virtualTranslate&&0!==e){var r=!1;a.transitionEnd(function(){if(!r&&t&&!t.destroyed){r=!0,t.animating=!1;for(var e=["webkitTransitionEnd","transitionend"],a=0;a<e.length;a+=1)n.trigger(e[a])}})}}},EffectFade={name:"effect-fade",params:{fadeEffect:{crossFade:!1}},create:function(){Utils.extend(this,{fadeEffect:{setTranslate:Fade.setTranslate.bind(this),setTransition:Fade.setTransition.bind(this)}})},on:{beforeInit:function(){if("fade"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"fade");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"fade"===this.params.effect&&this.fadeEffect.setTranslate()},setTransition:function(e){"fade"===this.params.effect&&this.fadeEffect.setTransition(e)}}},Cube={setTranslate:function(){var e,t=this,a=t.$el,n=t.$wrapperEl,r=t.slides,i=t.width,o=t.height,s=t.rtlTranslate,l=t.size,p=t.params.cubeEffect,c=t.isHorizontal(),d=t.virtual&&t.params.virtual.enabled,u=0;p.shadow&&(c?(0===(e=n.find(".swiper-cube-shadow")).length&&(e=$$1('<div class="swiper-cube-shadow"></div>'),n.append(e)),e.css({height:i+"px"})):0===(e=a.find(".swiper-cube-shadow")).length&&(e=$$1('<div class="swiper-cube-shadow"></div>'),a.append(e)));for(var h=0;h<r.length;h+=1){var f=r.eq(h),m=h;d&&(m=parseInt(f.attr("data-swiper-slide-index"),10));var v=90*m,g=Math.floor(v/360);s&&(v=-v,g=Math.floor(-v/360));var b=Math.max(Math.min(f[0].progress,1),-1),y=0,w=0,$=0;m%4==0?(y=4*-g*l,$=0):(m-1)%4==0?(y=0,$=4*-g*l):(m-2)%4==0?(y=l+4*g*l,$=l):(m-3)%4==0&&(y=-l,$=3*l+4*l*g),s&&(y=-y),c||(w=y,y=0);var C="rotateX("+(c?0:-v)+"deg) rotateY("+(c?v:0)+"deg) translate3d("+y+"px, "+w+"px, "+$+"px)";if(b<=1&&b>-1&&(u=90*m+90*b,s&&(u=90*-m-90*b)),f.transform(C),p.slideShadows){var x=c?f.find(".swiper-slide-shadow-left"):f.find(".swiper-slide-shadow-top"),E=c?f.find(".swiper-slide-shadow-right"):f.find(".swiper-slide-shadow-bottom");0===x.length&&(x=$$1('<div class="swiper-slide-shadow-'+(c?"left":"top")+'"></div>'),f.append(x)),0===E.length&&(E=$$1('<div class="swiper-slide-shadow-'+(c?"right":"bottom")+'"></div>'),f.append(E)),x.length&&(x[0].style.opacity=Math.max(-b,0)),E.length&&(E[0].style.opacity=Math.max(b,0))}}if(n.css({"-webkit-transform-origin":"50% 50% -"+l/2+"px","-moz-transform-origin":"50% 50% -"+l/2+"px","-ms-transform-origin":"50% 50% -"+l/2+"px","transform-origin":"50% 50% -"+l/2+"px"}),p.shadow)if(c)e.transform("translate3d(0px, "+(i/2+p.shadowOffset)+"px, "+-i/2+"px) rotateX(90deg) rotateZ(0deg) scale("+p.shadowScale+")");else{var S=Math.abs(u)-90*Math.floor(Math.abs(u)/90),k=1.5-(Math.sin(2*S*Math.PI/360)/2+Math.cos(2*S*Math.PI/360)/2),T=p.shadowScale,M=p.shadowScale/k,P=p.shadowOffset;e.transform("scale3d("+T+", 1, "+M+") translate3d(0px, "+(o/2+P)+"px, "+-o/2/M+"px) rotateX(-90deg)")}var O=Browser.isSafari||Browser.isUiWebView?-l/2:0;n.transform("translate3d(0px,0,"+O+"px) rotateX("+(t.isHorizontal()?0:u)+"deg) rotateY("+(t.isHorizontal()?-u:0)+"deg)")},setTransition:function(e){var t=this.$el;this.slides.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e),this.params.cubeEffect.shadow&&!this.isHorizontal()&&t.find(".swiper-cube-shadow").transition(e)}},EffectCube={name:"effect-cube",params:{cubeEffect:{slideShadows:!0,shadow:!0,shadowOffset:20,shadowScale:.94}},create:function(){Utils.extend(this,{cubeEffect:{setTranslate:Cube.setTranslate.bind(this),setTransition:Cube.setTransition.bind(this)}})},on:{beforeInit:function(){if("cube"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"cube"),this.classNames.push(this.params.containerModifierClass+"3d");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,resistanceRatio:0,spaceBetween:0,centeredSlides:!1,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"cube"===this.params.effect&&this.cubeEffect.setTranslate()},setTransition:function(e){"cube"===this.params.effect&&this.cubeEffect.setTransition(e)}}},Flip={setTranslate:function(){for(var e=this.slides,t=this.rtlTranslate,a=0;a<e.length;a+=1){var n=e.eq(a),r=n[0].progress;this.params.flipEffect.limitRotation&&(r=Math.max(Math.min(n[0].progress,1),-1));var i=-180*r,o=0,s=-n[0].swiperSlideOffset,l=0;if(this.isHorizontal()?t&&(i=-i):(l=s,s=0,o=-i,i=0),n[0].style.zIndex=-Math.abs(Math.round(r))+e.length,this.params.flipEffect.slideShadows){var p=this.isHorizontal()?n.find(".swiper-slide-shadow-left"):n.find(".swiper-slide-shadow-top"),c=this.isHorizontal()?n.find(".swiper-slide-shadow-right"):n.find(".swiper-slide-shadow-bottom");0===p.length&&(p=$$1('<div class="swiper-slide-shadow-'+(this.isHorizontal()?"left":"top")+'"></div>'),n.append(p)),0===c.length&&(c=$$1('<div class="swiper-slide-shadow-'+(this.isHorizontal()?"right":"bottom")+'"></div>'),n.append(c)),p.length&&(p[0].style.opacity=Math.max(-r,0)),c.length&&(c[0].style.opacity=Math.max(r,0))}n.transform("translate3d("+s+"px, "+l+"px, 0px) rotateX("+o+"deg) rotateY("+i+"deg)")}},setTransition:function(e){var t=this,a=t.slides,n=t.activeIndex,r=t.$wrapperEl;if(a.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e),t.params.virtualTranslate&&0!==e){var i=!1;a.eq(n).transitionEnd(function(){if(!i&&t&&!t.destroyed){i=!0,t.animating=!1;for(var e=["webkitTransitionEnd","transitionend"],a=0;a<e.length;a+=1)r.trigger(e[a])}})}}},EffectFlip={name:"effect-flip",params:{flipEffect:{slideShadows:!0,limitRotation:!0}},create:function(){Utils.extend(this,{flipEffect:{setTranslate:Flip.setTranslate.bind(this),setTransition:Flip.setTransition.bind(this)}})},on:{beforeInit:function(){if("flip"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"flip"),this.classNames.push(this.params.containerModifierClass+"3d");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"flip"===this.params.effect&&this.flipEffect.setTranslate()},setTransition:function(e){"flip"===this.params.effect&&this.flipEffect.setTransition(e)}}},Coverflow={setTranslate:function(){for(var e=this.width,t=this.height,a=this.slides,n=this.$wrapperEl,r=this.slidesSizesGrid,i=this.params.coverflowEffect,o=this.isHorizontal(),s=this.translate,l=o?e/2-s:t/2-s,p=o?i.rotate:-i.rotate,c=i.depth,d=0,u=a.length;d<u;d+=1){var h=a.eq(d),f=r[d],m=(l-h[0].swiperSlideOffset-f/2)/f*i.modifier,v=o?p*m:0,g=o?0:p*m,b=-c*Math.abs(m),y=o?0:i.stretch*m,w=o?i.stretch*m:0;Math.abs(w)<.001&&(w=0),Math.abs(y)<.001&&(y=0),Math.abs(b)<.001&&(b=0),Math.abs(v)<.001&&(v=0),Math.abs(g)<.001&&(g=0);var $="translate3d("+w+"px,"+y+"px,"+b+"px)  rotateX("+g+"deg) rotateY("+v+"deg)";if(h.transform($),h[0].style.zIndex=1-Math.abs(Math.round(m)),i.slideShadows){var C=o?h.find(".swiper-slide-shadow-left"):h.find(".swiper-slide-shadow-top"),x=o?h.find(".swiper-slide-shadow-right"):h.find(".swiper-slide-shadow-bottom");0===C.length&&(C=$$1('<div class="swiper-slide-shadow-'+(o?"left":"top")+'"></div>'),h.append(C)),0===x.length&&(x=$$1('<div class="swiper-slide-shadow-'+(o?"right":"bottom")+'"></div>'),h.append(x)),C.length&&(C[0].style.opacity=m>0?m:0),x.length&&(x[0].style.opacity=-m>0?-m:0)}}(Support.pointerEvents||Support.prefixedPointerEvents)&&(n[0].style.perspectiveOrigin=l+"px 50%")},setTransition:function(e){this.slides.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e)}},EffectCoverflow={name:"effect-coverflow",params:{coverflowEffect:{rotate:50,stretch:0,depth:100,modifier:1,slideShadows:!0}},create:function(){Utils.extend(this,{coverflowEffect:{setTranslate:Coverflow.setTranslate.bind(this),setTransition:Coverflow.setTransition.bind(this)}})},on:{beforeInit:function(){"coverflow"===this.params.effect&&(this.classNames.push(this.params.containerModifierClass+"coverflow"),this.classNames.push(this.params.containerModifierClass+"3d"),this.params.watchSlidesProgress=!0,this.originalParams.watchSlidesProgress=!0)},setTranslate:function(){"coverflow"===this.params.effect&&this.coverflowEffect.setTranslate()},setTransition:function(e){"coverflow"===this.params.effect&&this.coverflowEffect.setTransition(e)}}};function initSwipers(e){var t=this,a=$$1(e);if(0!==a.length&&!a[0].swiper){var n,r,i,o={};a.hasClass("tabs-swipeable-wrap")&&(a.addClass("swiper-container").children(".tabs").addClass("swiper-wrapper").children(".tab").addClass("swiper-slide"),n=a.children(".tabs").children(".tab-active").index(),r=!0,i=a.find(".tabs-routable").length>0),a.attr("data-swiper")?o=JSON.parse(a.attr("data-swiper")):(o=a.dataset(),Object.keys(o).forEach(function(e){var t=o[e];if("string"==typeof t&&0===t.indexOf("{")&&t.indexOf("}")>0)try{o[e]=JSON.parse(t)}catch(e){}})),void 0===o.initialSlide&&void 0!==n&&(o.initialSlide=n);var s=t.swiper.create(a[0],o);r&&s.on("slideChange",function(){if(i){var e=t.views.get(a.parents(".view"));e||(e=t.views.main);var n=e.router,r=n.findTabRoute(s.slides.eq(s.activeIndex)[0]);r&&n.navigate(r.path)}else t.tab.show({tabEl:s.slides.eq(s.activeIndex)})})}}Swiper.use([Device$1,Browser$1,Support$1,Resize,Observer$1,Virtual$1,Navigation$1,Pagination$1,Scrollbar$1,Parallax$1,Zoom$1,Lazy$3,Controller$1,A11y,Autoplay$1,EffectFade,EffectCube,EffectFlip,EffectCoverflow]),window.Swiper||(window.Swiper=Swiper);var Swiper$1={name:"swiper",static:{Swiper:Swiper},create:function(){this.swiper=ConstructorMethods({defaultSelector:".swiper-container",constructor:Swiper,domProp:"swiper"})},on:{pageBeforeRemove:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){t.swiper.destroy(a)})},pageMounted:function(e){var t=this;e.$el.find(".tabs-swipeable-wrap").each(function(e,a){initSwipers.call(t,a)})},pageInit:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){initSwipers.call(t,a)})},pageReinit:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){var n=t.swiper.get(a);n&&n.update&&n.update()})},tabMounted:function(e){var t=this;$$1(e).find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){initSwipers.call(t,a)})},tabShow:function(e){var t=this;$$1(e).find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){var n=t.swiper.get(a);n&&n.update&&n.update()})},tabBeforeRemove:function(e){var t=this;$$1(e).find(".swiper-init, .tabs-swipeable-wrap").each(function(e,a){t.swiper.destroy(a)})}}},PhotoBrowser=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);this.app=t;var n=Utils.extend({on:{}},t.params.photoBrowser);this.useModulesParams(n),this.params=Utils.extend(n,a),Utils.extend(this,{exposed:!1,opened:!1,activeIndex:this.params.swiper.initialSlide,url:this.params.url,view:this.params.view||t.views.main,swipeToClose:{allow:!0,isTouched:!1,diff:void 0,start:void 0,current:void 0,started:!1,activeSlide:void 0,timeStart:void 0}}),this.useModules(),this.init()}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.onSlideChange=function(e){var t=this;t.activeIndex=e.activeIndex;var a=e.activeIndex+1,n=t.params.virtualSlides?t.params.photos.length:e.slides.length;e.params.loop&&(n-=2,(a-=e.loopedSlides)<1&&(a=n+a),a>n&&(a-=n));var r=t.params.virtualSlides?e.$wrapperEl.find('.swiper-slide[data-swiper-slide-index="'+e.activeIndex+'"]'):e.slides.eq(e.activeIndex),i=t.params.virtualSlides?e.$wrapperEl.find('.swiper-slide[data-swiper-slide-index="'+e.previousIndex+'"]'):e.slides.eq(e.previousIndex),o=t.$el.find(".photo-browser-current"),s=t.$el.find(".photo-browser-total");if("page"===t.params.type&&t.params.navbar&&0===o.length&&"ios"===t.app.theme){var l=t.app.navbar.getElByPage(t.$el);l&&(o=$$1(l).find(".photo-browser-current"),s=$$1(l).find(".photo-browser-total"))}if(o.text(a),s.text(n),t.captions.length>0){var p=e.params.loop?r.attr("data-swiper-slide-index"):t.activeIndex;t.$captionsContainerEl.find(".photo-browser-caption-active").removeClass("photo-browser-caption-active"),t.$captionsContainerEl.find('[data-caption-index="'+p+'"]').addClass("photo-browser-caption-active")}var c=i.find("video");c.length>0&&"pause"in c[0]&&c[0].pause()},t.prototype.onTouchStart=function(){var e=this.swipeToClose;e.allow&&(e.isTouched=!0)},t.prototype.onTouchMove=function(e){var t=this.swipeToClose;if(t.isTouched){t.started||(t.started=!0,t.start="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,this.params.virtualSlides?t.activeSlide=this.swiper.$wrapperEl.children(".swiper-slide-active"):t.activeSlide=this.swiper.slides.eq(this.swiper.activeIndex),t.timeStart=Utils.now()),e.preventDefault(),t.current="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,t.diff=t.start-t.current;var a=1-Math.abs(t.diff)/300,n=this.exposed||"dark"===this.params.theme?0:255;t.activeSlide.transform("translate3d(0,"+-t.diff+"px,0)"),this.swiper.$el.css("background-color","rgba("+n+", "+n+", "+n+", "+a+")").transition(0)}},t.prototype.onTouchEnd=function(){var e=this,t=e.swipeToClose;if(t.isTouched=!1,t.started){t.started=!1,t.allow=!1;var a=Math.abs(t.diff),n=(new Date).getTime()-t.timeStart;n<300&&a>20||n>=300&&a>100?Utils.nextTick(function(){e.$el&&(t.diff<0?e.$el.addClass("swipe-close-to-bottom"):e.$el.addClass("swipe-close-to-top")),e.emit("local::swipeToClose",e),e.close(),t.allow=!0}):(0!==a?t.activeSlide.addClass("photo-browser-transitioning").transitionEnd(function(){t.allow=!0,t.activeSlide.removeClass("photo-browser-transitioning")}):t.allow=!0,e.swiper.$el.transition("").css("background-color",""),t.activeSlide.transform(""))}else t.started=!1},t.prototype.renderNavbar=function(){var e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);var t=e.params.iconsColor;e.params.iconsColor||"dark"!==e.params.theme||(t="white");var a="ios"===e.app.theme&&e.params.backLinkText?e.params.backLinkText:"",n="page"!==e.params.type;return('\n      <div class="navbar">\n        <div class="navbar-inner sliding">\n          <div class="left">\n            <a href="#" class="link '+(n?"popup-close":"")+" "+(a?"":"icon-only")+" "+(n?"":"back")+'" '+(n?'data-popup=".photo-browser-popup"':"")+'>\n              <i class="icon icon-back '+(t?"color-"+t:"")+'"></i>\n              '+(a?"<span>"+a+"</span>":"")+'\n            </a>\n          </div>\n          <div class="title">\n            <span class="photo-browser-current"></span>\n            <span class="photo-browser-of">'+e.params.navbarOfText+'</span>\n            <span class="photo-browser-total"></span>\n          </div>\n          <div class="right"></div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderToolbar=function(){if(this.params.renderToolbar)return this.params.renderToolbar.call(this);var e=this.params.iconsColor;return this.params.iconsColor||"dark"!==this.params.theme||(e="white"),('\n      <div class="toolbar tabbar toolbar-bottom-md">\n        <div class="toolbar-inner">\n          <a href="#" class="link photo-browser-prev">\n            <i class="icon icon-back '+(e?"color-"+e:"")+'"></i>\n          </a>\n          <a href="#" class="link photo-browser-next">\n            <i class="icon icon-forward '+(e?"color-"+e:"")+'"></i>\n          </a>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderCaption=function(e,t){return this.params.renderCaption?this.params.renderCaption.call(this,e,t):('\n      <div class="photo-browser-caption" data-caption-index="'+t+'">\n        '+e+"\n      </div>\n    ").trim()},t.prototype.renderObject=function(e,t){return this.params.renderObject?this.params.renderObject.call(this,e,t):'\n      <div class="photo-browser-slide photo-browser-object-slide swiper-slide" data-swiper-slide-index="'+t+'">'+(e.html?e.html:e)+"</div>\n    "},t.prototype.renderLazyPhoto=function(e,t){return this.params.renderLazyPhoto?this.params.renderLazyPhoto.call(this,e,t):('\n      <div class="photo-browser-slide photo-browser-slide-lazy swiper-slide" data-swiper-slide-index="'+t+'">\n          <div class="preloader swiper-lazy-preloader '+("dark"===this.params.theme?"color-white":"")+'">'+("md"===this.app.theme?Utils.mdPreloaderContent:"")+'</div>\n          <span class="swiper-zoom-container">\n              <img data-src="'+(e.url?e.url:e)+'" class="swiper-lazy">\n          </span>\n      </div>\n    ').trim()},t.prototype.renderPhoto=function(e,t){return this.params.renderPhoto?this.params.renderPhoto.call(this,e,t):('\n      <div class="photo-browser-slide swiper-slide" data-swiper-slide-index="'+t+'">\n        <span class="swiper-zoom-container">\n          <img src="'+(e.url?e.url:e)+'">\n        </span>\n      </div>\n    ').trim()},t.prototype.render=function(){var e=this;return e.params.render?e.params.render.call(e,e.params):('\n      <div class="photo-browser photo-browser-'+e.params.theme+'">\n        <div class="view">\n          <div class="page photo-browser-page photo-browser-page-'+e.params.theme+" no-toolbar "+(e.params.navbar?"":"no-navbar")+'" data-name="photo-browser-page">\n            '+(e.params.navbar?e.renderNavbar():"")+"\n            "+(e.params.toolbar?e.renderToolbar():"")+'\n            <div class="photo-browser-captions photo-browser-captions-'+(e.params.captionsTheme||e.params.theme)+'">\n              '+e.params.photos.map(function(t,a){return t.caption?e.renderCaption(t.caption,a):""}).join(" ")+'\n            </div>\n            <div class="photo-browser-swiper-container swiper-container">\n              <div class="photo-browser-swiper-wrapper swiper-wrapper">\n                '+(e.params.virtualSlides?"":e.params.photos.map(function(t,a){return t.html||("string"==typeof t||t instanceof String)&&t.indexOf("<")>=0&&t.indexOf(">")>=0?e.renderObject(t,a):!0===e.params.swiper.lazy||e.params.swiper.lazy&&e.params.swiper.lazy.enabled?e.renderLazyPhoto(t,a):e.renderPhoto(t,a)}).join(" "))+"\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderStandalone=function(){return this.params.renderStandalone?this.params.renderStandalone.call(this):'<div class="popup photo-browser-popup photo-browser-standalone popup-tablet-fullscreen">'+this.render()+"</div>"},t.prototype.renderPage=function(){return this.params.renderPage?this.params.renderPage.call(this):this.render()},t.prototype.renderPopup=function(){return this.params.renderPopup?this.params.renderPopup.call(this):'<div class="popup photo-browser-popup">'+this.render()+"</div>"},t.prototype.onOpen=function(e,t){var a=this,n=a.app,r=$$1(t);r[0].f7PhotoBrowser=a,a.$el=r,a.el=r[0],a.openedIn=e,a.opened=!0,a.$swiperContainerEl=a.$el.find(".photo-browser-swiper-container"),a.$swiperWrapperEl=a.$el.find(".photo-browser-swiper-wrapper"),a.slides=a.$el.find(".photo-browser-slide"),a.$captionsContainerEl=a.$el.find(".photo-browser-captions"),a.captions=a.$el.find(".photo-browser-caption");var i=Utils.extend({},a.params.swiper,{initialSlide:a.activeIndex,on:{tap:function(e){a.emit("local::tap",e)},click:function(e){a.params.exposition&&a.expositionToggle(),a.emit("local::click",e)},doubleTap:function(e){a.emit("local::doubleTap",e)},slideChange:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.onSlideChange(this),a.emit.apply(a,["local::slideChange"].concat(e))},transitionStart:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.emit.apply(a,["local::transitionStart"].concat(e))},transitionEnd:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.emit.apply(a,["local::transitionEnd"].concat(e))},slideChangeTransitionStart:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.emit.apply(a,["local::slideChangeTransitionStart"].concat(e))},slideChangeTransitionEnd:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.emit.apply(a,["local::slideChangeTransitionEnd"].concat(e))},lazyImageLoad:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];a.emit.apply(a,["local::lazyImageLoad"].concat(e))},lazyImageReady:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];$$1(e[0]).removeClass("photo-browser-slide-lazy"),a.emit.apply(a,["local::lazyImageReady"].concat(e))}}});a.params.swipeToClose&&"page"!==a.params.type&&Utils.extend(i.on,{touchStart:function(e){a.onTouchStart(e),a.emit("local::touchStart",e)},touchMoveOpposite:function(e){a.onTouchMove(e),a.emit("local::touchMoveOpposite",e)},touchEnd:function(e){a.onTouchEnd(e),a.emit("local::touchEnd",e)}}),a.params.virtualSlides&&Utils.extend(i,{virtual:{slides:a.params.photos,renderSlide:function(e,t){return e.html||("string"==typeof e||e instanceof String)&&e.indexOf("<")>=0&&e.indexOf(">")>=0?a.renderObject(e,t):!0===a.params.swiper.lazy||a.params.swiper.lazy&&a.params.swiper.lazy.enabled?a.renderLazyPhoto(e,t):a.renderPhoto(e,t)}}}),a.swiper=n.swiper.create(a.$swiperContainerEl,i),0===a.activeIndex&&a.onSlideChange(a.swiper),a.$el&&a.$el.trigger("photobrowser:open"),a.emit("local::open photoBrowserOpen",a)},t.prototype.onOpened=function(){this.$el&&this.$el.trigger("photobrowser:opened"),this.emit("local::opened photoBrowserOpened",this)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.swiper&&e.swiper.destroy&&(e.swiper.destroy(!0,!1),e.swiper=null,delete e.swiper),e.$el&&e.$el.trigger("photobrowser:close"),e.emit("local::close photoBrowserClose",e))},t.prototype.onClosed=function(){var e=this;e.destroyed||(e.opened=!1,e.$el=null,e.el=null,delete e.$el,delete e.el,e.$el&&e.$el.trigger("photobrowser:closed"),e.emit("local::closed photoBrowserClosed",e))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;var t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.view.$el.addClass("with-photo-browser-page with-photo-browser-page-"+e.params.theme),e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.view.$el.removeClass("with-photo-browser-page with-photo-browser-page-exposed with-photo-browser-page-"+e.params.theme),e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}}}}),e},t.prototype.openStandalone=function(){var e=this;if(e.opened)return e;var t={backdrop:!1,content:e.renderStandalone(),on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;var t={content:e.renderPopup(),on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.expositionEnable=function(){return"page"===this.params.type&&this.view.$el.addClass("with-photo-browser-page-exposed"),this.$el&&this.$el.addClass("photo-browser-exposed"),this.params.expositionHideCaptions&&this.$captionsContainerEl.addClass("photo-browser-captions-exposed"),this.exposed=!0,this},t.prototype.expositionDisable=function(){return"page"===this.params.type&&this.view.$el.removeClass("with-photo-browser-page-exposed"),this.$el&&this.$el.removeClass("photo-browser-exposed"),this.params.expositionHideCaptions&&this.$captionsContainerEl.removeClass("photo-browser-captions-exposed"),this.exposed=!1,this},t.prototype.expositionToggle=function(){return"page"===this.params.type&&this.view.$el.toggleClass("with-photo-browser-page-exposed"),this.$el&&this.$el.toggleClass("photo-browser-exposed"),this.params.expositionHideCaptions&&this.$captionsContainerEl.toggleClass("photo-browser-captions-exposed"),this.exposed=!this.exposed,this},t.prototype.open=function(e){var t=this,a=t.params.type;return t.opened?(t.swiper&&void 0!==e&&t.swiper.slideTo(parseInt(e,10)),t):(void 0!==e&&(t.activeIndex=e),"standalone"===a&&t.openStandalone(),"page"===a&&t.openPage(),"popup"===a&&t.openPopup(),t)},t.prototype.close=function(){var e=this;return e.opened?(e.params.routableModals||"page"===e.openedIn?e.view&&e.view.router.back():(e.modal.once("modalClosed",function(){Utils.nextTick(function(){e.modal.destroy(),delete e.modal})}),e.modal.close()),e):e},t.prototype.init=function(){},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy photoBrowserBeforeDestroy",e),e.$el&&(e.$el.trigger("photobrowser:beforedestroy"),delete e.$el[0].f7PhotoBrowser),Utils.deleteProps(e),e=null},t}(Framework7Class),PhotoBrowser$1={name:"photoBrowser",params:{photoBrowser:{photos:[],exposition:!0,expositionHideCaptions:!1,type:"standalone",navbar:!0,toolbar:!0,theme:"light",captionsTheme:void 0,iconsColor:void 0,swipeToClose:!0,backLinkText:"Close",navbarOfText:"of",view:void 0,url:"photos/",routableModals:!0,virtualSlides:!0,renderNavbar:void 0,renderToolbar:void 0,renderCaption:void 0,renderObject:void 0,renderLazyPhoto:void 0,renderPhoto:void 0,renderPage:void 0,renderPopup:void 0,renderStandalone:void 0,swiper:{initialSlide:0,spaceBetween:20,speed:300,loop:!1,preloadImages:!0,navigation:{nextEl:".photo-browser-next",prevEl:".photo-browser-prev"},zoom:{enabled:!0,maxRatio:3,minRatio:1},lazy:{enabled:!0}}}},create:function(){this.photoBrowser=ConstructorMethods({defaultSelector:".photo-browser",constructor:PhotoBrowser,app:this,domProp:"f7PhotoBrowser"})},static:{PhotoBrowser:PhotoBrowser}},Notification=function(e){function t(t,a){var n=Utils.extend({on:{}},t.params.notification,a);e.call(this,t,n);var r=this;r.app=t,r.params=n;var i,o,s,l,p,c,d,u=r.params,h=u.icon,f=u.title,m=u.titleRightText,v=u.subtitle,g=u.text,b=u.closeButton,y=u.closeTimeout,w=u.cssClass,$=u.closeOnClick;if(r.params.el)i=$$1(r.params.el);else{var C=r.render({icon:h,title:f,titleRightText:m,subtitle:v,text:g,closeButton:b,cssClass:w});i=$$1(C)}if(i&&i.length>0&&i[0].f7Modal)return i[0].f7Modal;if(0===i.length)return r.destroy();Utils.extend(r,{$el:i,el:i[0],type:"notification"}),i[0].f7Modal=r,b&&i.find(".notification-close-button").on("click",function(){r.close()}),i.on("click",function(e){b&&$$1(e.target).closest(".notification-close-button").length||(r.emit("local::click notificationClick",r),$&&r.close())}),r.on("beforeDestroy",function(){i.off("click")});var x,E={};function S(e){o||(o=!0,s=!1,l=void 0,c=Utils.now(),E.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,E.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}function k(e){if(o){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===l&&(l=!!(l||Math.abs(a-E.y)<Math.abs(t-E.x))),l)o=!1;else{e.preventDefault(),s||(r.$el.removeClass("notification-transitioning"),r.$el.transition(0),d=r.$el[0].offsetHeight/2),s=!0;var n=p=a-E.y;p>0&&(n=Math.pow(p,.8)),r.$el.transform("translate3d(0, "+n+"px, 0)")}}}function T(){if(!o||!s)return o=!1,void(s=!1);if(o=!1,s=!1,0!==p){var e=Utils.now()-c;r.$el.transition(""),r.$el.addClass("notification-transitioning"),r.$el.transform(""),(p<-10&&e<300||-p>=d/1)&&r.close()}}return r.on("open",function(){r.params.swipeToClose&&(r.$el.on(t.touchEvents.start,S,{passive:!0}),t.on("touchmove:active",k),t.on("touchend:passive",T)),$$1(".notification.modal-in").each(function(e,a){var n=t.notification.get(a);a!==r.el&&n&&n.close()}),y&&function e(){x=Utils.nextTick(function(){o&&s?e():r.close()},y)}()}),r.on("close beforeDestroy",function(){r.params.swipeToClose&&(r.$el.off(t.touchEvents.start,S,{passive:!0}),t.off("touchmove:active",k),t.off("touchend:passive",T)),win.clearTimeout(x)}),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.params,t=e.icon,a=e.title,n=e.titleRightText,r=e.subtitle,i=e.text,o=e.closeButton;return('\n      <div class="notification '+(e.cssClass||"")+'">\n        <div class="notification-header">\n          '+(t?'<div class="notification-icon">'+t+"</div>":"")+"\n          "+(a?'<div class="notification-title">'+a+"</div>":"")+"\n          "+(n?'<div class="notification-title-right-text">'+n+"</div>":"")+"\n          "+(o?'<span class="notification-close-button"></span>':"")+'\n        </div>\n        <div class="notification-content">\n          '+(r?'<div class="notification-subtitle">'+r+"</div>":"")+"\n          "+(i?'<div class="notification-text">'+i+"</div>":"")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Notification$1={name:"notification",static:{Notification:Notification},create:function(){this.notification=Utils.extend({},ModalMethods({app:this,constructor:Notification,defaultSelector:".notification.modal-in"}))},params:{notification:{icon:null,title:null,titleRightText:null,subtitle:null,text:null,closeButton:!1,closeTimeout:null,closeOnClick:!1,swipeToClose:!0,cssClass:null,render:null}}},Autocomplete=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n=this;n.app=t;var r,i,o,s=Utils.extend({on:{}},t.params.autocomplete);n.useModulesParams(s),n.params=Utils.extend(s,a),n.params.openerEl&&(r=$$1(n.params.openerEl)).length&&(r[0].f7Autocomplete=n),n.params.inputEl&&(i=$$1(n.params.inputEl)).length&&(i[0].f7Autocomplete=n),n.params.view?o=n.params.view:(r||i)&&(o=t.views.get(r||i)),o||(o=t.views.main);var l=Utils.now(),p=a.url;!p&&r&&r.length&&(r.attr("href")?p=r.attr("href"):r.find("a").length>0&&(p=r.find("a").attr("href"))),p&&"#"!==p&&""!==p||(p=n.params.url);var c=n.params.multiple?"checkbox":"radio";Utils.extend(n,{$openerEl:r,openerEl:r&&r[0],$inputEl:i,inputEl:i&&i[0],id:l,view:o,url:p,value:n.params.value||[],inputType:c,inputName:c+"-"+l,$modalEl:void 0,$dropdownEl:void 0});var d="";function u(){var e=n.$inputEl.val().trim();n.params.source&&n.params.source.call(n,e,function(t){var a,r,o,s="",l=n.params.limit?Math.min(n.params.limit,t.length):t.length;n.items=t,n.params.highlightMatches&&(e=e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),a=new RegExp("("+e+")","i"));for(var p=0;p<l;p+=1){var c="object"==typeof t[p]?t[p][n.params.valueProperty]:t[p],u="object"==typeof t[p]?t[p][n.params.textProperty]:t[p];0===p&&(r=c,o=n.items[p]),s+=n.renderItem({value:c,text:n.params.highlightMatches?u.replace(a,"<b>$1</b>"):u},p)}if(""===s&&""===e&&n.params.dropdownPlaceholderText&&(s+=n.renderItem({placeholder:!0,text:n.params.dropdownPlaceholderText})),n.$dropdownEl.find("ul").html(s),n.params.typeahead){if(!r||!o)return;if(0!==r.toLowerCase().indexOf(e.toLowerCase()))return;if(d.toLowerCase()===e.toLowerCase())return void(n.value=[]);if(0===d.toLowerCase().indexOf(e.toLowerCase()))return d=e,void(n.value=[]);i.val(r),i[0].setSelectionRange(e.length,r.length);var h="object"==typeof n.value[0]?n.value[0][n.params.valueProperty]:n.value[0];h&&r.toLowerCase()===h.toLowerCase()||(n.value=[o],n.emit("local::change autocompleteChange",[o]))}d=e})}function h(){var e,t,a,r=this.value;if($$1(this).parents(".autocomplete-values").length>0){if("checkbox"===n.inputType&&!this.checked){for(var i=0;i<n.value.length;i+=1)(a="string"==typeof n.value[i]?n.value[i]:n.value[i][n.params.valueProperty])!==r&&1*a!=1*r||n.value.splice(i,1);n.updateValues(),n.emit("local::change autocompleteChange",n.value)}}else{for(var o=0;o<n.items.length;o+=1)(t="object"==typeof n.items[o]?n.items[o][n.params.valueProperty]:n.items[o])!==r&&1*t!=1*r||(e=n.items[o]);if("radio"===n.inputType)n.value=[e];else if(this.checked)n.value.push(e);else for(var s=0;s<n.value.length;s+=1)(a="object"==typeof n.value[s]?n.value[s][n.params.valueProperty]:n.value[s])!==r&&1*a!=1*r||n.value.splice(s,1);n.updateValues(),("radio"===n.inputType&&this.checked||"checkbox"===n.inputType)&&n.emit("local::change autocompleteChange",n.value)}}function f(e){var t=$$1(e.target);t.is(n.$inputEl[0])||n.$dropdownEl&&t.closest(n.$dropdownEl[0]).length||n.close()}function m(){n.open()}function v(){n.open()}function g(){n.$dropdownEl.find("label.active-state").length>0||n.close()}function b(){n.positionDropdown()}function y(e){n.opened&&13===e.keyCode&&(e.preventDefault(),n.$inputEl.blur())}function w(){for(var e,t=$$1(this),a=0;a<n.items.length;a+=1){var r="object"==typeof n.items[a]?n.items[a][n.params.valueProperty]:n.items[a],i=t.attr("data-value");r!==i&&1*r!=1*i||(e=n.items[a])}n.params.updateInputValueOnSelect&&(n.$inputEl.val("object"==typeof e?e[n.params.valueProperty]:e),n.$inputEl.trigger("input change")),n.value=[e],n.emit("local::change autocompleteChange",[e]),n.close()}return n.attachEvents=function(){"dropdown"!==n.params.openIn&&n.$openerEl&&n.$openerEl.on("click",m),"dropdown"===n.params.openIn&&n.$inputEl&&(n.$inputEl.on("focus",v),n.$inputEl.on(n.params.inputEvents,u),t.device.android?$$1("html").on("click",f):n.$inputEl.on("blur",g),n.params.typeahead&&n.$inputEl.on("keydown",y))},n.detachEvents=function(){"dropdown"!==n.params.openIn&&n.$openerEl&&n.$openerEl.off("click",m),"dropdown"===n.params.openIn&&n.$inputEl&&(n.$inputEl.off("focus",v),n.$inputEl.off(n.params.inputEvents,u),t.device.android?$$1("html").off("click",f):n.$inputEl.off("blur",g),n.params.typeahead&&n.$inputEl.off("keydown",y))},n.attachDropdownEvents=function(){n.$dropdownEl.on("click","label",w),t.on("resize",b)},n.detachDropdownEvents=function(){n.$dropdownEl.off("click","label",w),t.off("resize",b)},n.attachPageEvents=function(){n.$el.on("change",'input[type="radio"], input[type="checkbox"]',h),n.params.closeOnSelect&&!n.params.multiple&&n.$el.once("click",".list label",function(){Utils.nextTick(function(){n.close()})})},n.detachPageEvents=function(){n.$el.off("change",'input[type="radio"], input[type="checkbox"]',h)},n.useModules(),n.init(),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.positionDropdown=function(){var e,t=this.$inputEl,a=this.app,n=this.$dropdownEl,r=t.parents(".page-content");if(0!==r.length){var i,o=t.offset(),s=t[0].offsetWidth,l=t[0].offsetHeight,p=t.parents(".list");p.parents().each(function(e,t){if(!i){var a=$$1(t);a.parent(r).length&&(i=a)}});var c,d=p.offset(),u=parseInt(r.css("padding-bottom"),10),h=p.length>0?d.left-r.offset().left:0,f=o.left-(p.length>0?d.left:0)-(a.rtl,0),m=o.top-(r.offset().top-r[0].scrollTop),v=r[0].scrollHeight-u-(m+r[0].scrollTop)-t[0].offsetHeight,g=a.rtl?"padding-right":"padding-left";p.length&&!this.params.expandInput&&(c=(a.rtl?p[0].offsetWidth-f-s:f)-("md"===a.theme?16:15)),n.css({left:(p.length>0?h:f)+"px",top:m+r[0].scrollTop+l+"px",width:(p.length>0?p[0].offsetWidth:s)+"px"}),n.children(".autocomplete-dropdown-inner").css(((e={maxHeight:v+"px"})[g]=p.length>0&&!this.params.expandInput?c+"px":"",e))}},t.prototype.focus=function(){this.$el.find("input[type=search]").focus()},t.prototype.source=function(e){var t=this;if(t.params.source){var a=t.$el;t.params.source.call(t,e,function(n){var r="",i=t.params.limit?Math.min(t.params.limit,n.length):n.length;t.items=n;for(var o=0;o<i;o+=1){for(var s=!1,l="object"==typeof n[o]?n[o][t.params.valueProperty]:n[o],p=0;p<t.value.length;p+=1){var c="object"==typeof t.value[p]?t.value[p][t.params.valueProperty]:t.value[p];c!==l&&1*c!=1*l||(s=!0)}r+=t.renderItem({value:l,text:"object"==typeof n[o]?n[o][t.params.textProperty]:n[o],inputType:t.inputType,id:t.id,inputName:t.inputName,selected:s},o)}a.find(".autocomplete-found ul").html(r),0===n.length?0!==e.length?(a.find(".autocomplete-not-found").show(),a.find(".autocomplete-found, .autocomplete-values").hide()):(a.find(".autocomplete-values").show(),a.find(".autocomplete-found, .autocomplete-not-found").hide()):(a.find(".autocomplete-found").show(),a.find(".autocomplete-not-found, .autocomplete-values").hide())})}},t.prototype.updateValues=function(){for(var e=this,t="",a=0;a<e.value.length;a+=1)t+=e.renderItem({value:"object"==typeof e.value[a]?e.value[a][e.params.valueProperty]:e.value[a],text:"object"==typeof e.value[a]?e.value[a][e.params.textProperty]:e.value[a],inputType:e.inputType,id:e.id,inputName:e.inputName+"-checked}",selected:!0},a);e.$el.find(".autocomplete-values ul").html(t)},t.prototype.preloaderHide=function(){"dropdown"===this.params.openIn&&this.$dropdownEl?this.$dropdownEl.find(".autocomplete-preloader").removeClass("autocomplete-preloader-visible"):$$1(".autocomplete-preloader").removeClass("autocomplete-preloader-visible")},t.prototype.preloaderShow=function(){"dropdown"===this.params.openIn&&this.$dropdownEl?this.$dropdownEl.find(".autocomplete-preloader").addClass("autocomplete-preloader-visible"):$$1(".autocomplete-preloader").addClass("autocomplete-preloader-visible")},t.prototype.renderPreloader=function(){return('\n      <div class="autocomplete-preloader preloader '+(this.params.preloaderColor?"color-"+this.params.preloaderColor:"")+'">'+("md"===this.app.theme?Utils.mdPreloaderContent:"")+"</div>\n    ").trim()},t.prototype.renderSearchbar=function(){return this.params.renderSearchbar?this.params.renderSearchbar.call(this):('\n      <form class="searchbar">\n        <div class="searchbar-inner">\n          <div class="searchbar-input-wrap">\n            <input type="search" placeholder="'+this.params.searchbarPlaceholder+'"/>\n            <i class="searchbar-icon"></i>\n            <span class="input-clear-button"></span>\n          </div>\n          <span class="searchbar-disable-button">'+this.params.searchbarDisableText+"</span>\n        </div>\n      </form>\n    ").trim()},t.prototype.renderItem=function(e,t){return this.params.renderItem?this.params.renderItem.call(this,e,t):("dropdown"!==this.params.openIn?'\n        <li>\n          <label class="item-'+e.inputType+' item-content">\n            <input type="'+e.inputType+'" name="'+e.inputName+'" value="'+e.value+'" '+(e.selected?"checked":"")+'>\n            <i class="icon icon-'+e.inputType+'"></i>\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ":e.placeholder?'\n        <li class="autocomplete-dropdown-placeholder">\n          <div class="item-content">\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ":'\n        <li>\n          <label class="item-radio item-content" data-value="'+e.value+'">\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ").trim()},t.prototype.renderNavbar=function(){var e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);var t=e.params.pageTitle;return void 0===t&&e.$openerEl&&e.$openerEl.length&&(t=e.$openerEl.find(".item-title").text().trim()),('\n      <div class="navbar '+(e.params.navbarColorTheme?"color-theme-"+e.params.navbarColorTheme:"")+'">\n        <div class="navbar-inner '+(e.params.navbarColorTheme?"color-theme-"+e.params.navbarColorTheme:"")+'">\n          <div class="left sliding">\n            <a href="#" class="link '+("page"===e.params.openIn?"back":"popup-close")+'" '+("popup"===e.params.openIn?'data-popup=".autocomplete-popup"':"")+'>\n              <i class="icon icon-back"></i>\n              <span class="ios-only">'+("page"===e.params.openIn?e.params.pageBackLinkText:e.params.popupCloseLinkText)+"</span>\n            </a>\n          </div>\n          "+(t?'<div class="title sliding">'+t+"</div>":"")+"\n          "+(e.params.preloader?'\n          <div class="right">\n            '+e.renderPreloader()+"\n          </div>\n          ":"")+'\n          <div class="subnavbar sliding">'+e.renderSearchbar()+"</div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderDropdown=function(){return this.params.renderDropdown?this.params.renderDropdown.call(this,this.items):('\n      <div class="autocomplete-dropdown">\n        <div class="autocomplete-dropdown-inner">\n          <div class="list '+(this.params.expandInput?"":"no-ios-edge")+'">\n            <ul></ul>\n          </div>\n        </div>\n        '+(this.params.preloader?this.renderPreloader():"")+"\n      </div>\n    ").trim()},t.prototype.renderPage=function(){return this.params.renderPage?this.params.renderPage.call(this,this.items):('\n      <div class="page page-with-subnavbar autocomplete-page" data-name="autocomplete-page">\n        '+this.renderNavbar()+'\n        <div class="searchbar-backdrop"></div>\n        <div class="page-content">\n          <div class="list autocomplete-list autocomplete-found autocomplete-list-'+this.id+" "+(this.params.formColorTheme?"color-theme-"+this.params.formColorTheme:"")+'">\n            <ul></ul>\n          </div>\n          <div class="list autocomplete-not-found">\n            <ul>\n              <li class="item-content"><div class="item-inner"><div class="item-title">'+this.params.notFoundText+'</div></div></li>\n            </ul>\n          </div>\n          <div class="list autocomplete-values">\n            <ul></ul>\n          </div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderPopup=function(){return this.params.renderPopup?this.params.renderPopup.call(this,this.items):('\n      <div class="popup autocomplete-popup">\n        <div class="view">\n          '+this.renderPage()+";\n        </div>\n      </div>\n    ").trim()},t.prototype.onOpen=function(e,t){var a=this,n=a.app,r=$$1(t);if(a.$el=r,a.el=r[0],a.openedIn=e,a.opened=!0,"dropdown"===a.params.openIn)a.attachDropdownEvents(),a.$dropdownEl.addClass("autocomplete-dropdown-in"),a.$inputEl.trigger("input");else{var i=r.find(".searchbar");"page"===a.params.openIn&&"ios"===n.theme&&0===i.length&&(i=$$1(n.navbar.getElByPage(r)).find(".searchbar")),a.searchbar=n.searchbar.create({el:i,backdropEl:r.find(".searchbar-backdrop"),customSearch:!0,on:{searchbarSearch:function(e,t){0===t.length&&a.searchbar.enabled?a.searchbar.backdropShow():a.searchbar.backdropHide(),a.source(t)}}}),a.attachPageEvents(),a.updateValues(),a.params.requestSourceOnOpen&&a.source("")}a.emit("local::open autocompleteOpen",a)},t.prototype.onOpened=function(){"dropdown"!==this.params.openIn&&this.params.autoFocus&&this.autoFocus(),this.emit("local::opened autocompleteOpened",this)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),"dropdown"===e.params.openIn?(e.detachDropdownEvents(),e.$dropdownEl.removeClass("autocomplete-dropdown-in").remove(),e.$inputEl.parents(".item-content-dropdown-expanded").removeClass("item-content-dropdown-expanded")):e.detachPageEvents(),e.emit("local::close autocompleteClose",e))},t.prototype.onClosed=function(){this.destroyed||(this.opened=!1,this.$el=null,this.el=null,delete this.$el,delete this.el,this.emit("local::closed autocompleteClosed",this))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;var t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}},options:{animate:e.params.animate}}}),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;var t={content:e.renderPopup(),animate:e.params.animate,on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(e.params.animate),e},t.prototype.openDropdown=function(){var e=this;e.$dropdownEl||(e.$dropdownEl=$$1(e.renderDropdown())),e.$inputEl.parents(".list").length&&e.$inputEl.parents(".item-content").length>0&&e.params.expandInput&&e.$inputEl.parents(".item-content").addClass("item-content-dropdown-expanded");var t=e.$inputEl.parents(".page-content");e.params.dropdownContainerEl?$$1(e.params.dropdownContainerEl).append(e.$dropdownEl):0===t.length?e.$dropdownEl.insertAfter(e.$inputEl):(e.positionDropdown(),t.append(e.$dropdownEl)),e.onOpen("dropdown",e.$dropdownEl),e.onOpened("dropdown",e.$dropdownEl)},t.prototype.open=function(){return this.opened?this:(this["open"+this.params.openIn.split("").map(function(e,t){return 0===t?e.toUpperCase():e}).join("")](),this)},t.prototype.close=function(){var e=this;return e.opened?("dropdown"===e.params.openIn?(e.onClose(),e.onClosed()):e.params.routableModals||"page"===e.openedIn?e.view.router.back({animate:e.params.animate}):(e.modal.once("modalClosed",function(){Utils.nextTick(function(){e.modal.destroy(),delete e.modal})}),e.modal.close()),e):e},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy autocompleteBeforeDestroy",e),e.detachEvents(),e.$inputEl&&e.$inputEl[0]&&delete e.$inputEl[0].f7Autocomplete,e.$openerEl&&e.$openerEl[0]&&delete e.$openerEl[0].f7Autocomplete,Utils.deleteProps(e),e.destroyed=!0},t}(Framework7Class),Autocomplete$1={name:"autocomplete",params:{autocomplete:{openerEl:void 0,inputEl:void 0,view:void 0,dropdownContainerEl:void 0,dropdownPlaceholderText:void 0,typeahead:!1,highlightMatches:!0,expandInput:!1,updateInputValueOnSelect:!0,inputEvents:"input",value:void 0,multiple:!1,source:void 0,limit:void 0,valueProperty:"id",textProperty:"text",openIn:"page",pageBackLinkText:"Back",popupCloseLinkText:"Close",pageTitle:void 0,searchbarPlaceholder:"Search...",searchbarDisableText:"Cancel",animate:!0,autoFocus:!1,closeOnSelect:!1,notFoundText:"Nothing found",requestSourceOnOpen:!1,preloaderColor:void 0,preloader:!1,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!0,url:"select/",renderDropdown:void 0,renderPage:void 0,renderPopup:void 0,renderItem:void 0,renderSearchbar:void 0,renderNavbar:void 0}},static:{Autocomplete:Autocomplete},create:function(){var e=this;e.autocomplete=Utils.extend(ConstructorMethods({defaultSelector:void 0,constructor:Autocomplete,app:e,domProp:"f7Autocomplete"}),{open:function(t){var a=e.autocomplete.get(t);if(a&&a.open)return a.open()},close:function(t){var a=e.autocomplete.get(t);if(a&&a.close)return a.close()}})}},ViAd=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var n,r=this;if(!win.vi)throw new Error("f7:vi SDK not found.");void 0!==win.orientation&&(n=-90===win.orientation||90===win.orientation?"horizontal":"vertical");var i=Utils.extend({},t.params.vi,{appId:t.id,appVer:t.version,language:t.language,width:t.width,height:t.height,os:Device.os,osVersion:Device.osVersion,orientation:n});r.useModulesParams(i),r.params=Utils.extend(i,a);var o={},s="on autoplay fallbackOverlay fallbackOverlayText enabled".split(" ");if(Object.keys(r.params).forEach(function(e){if(!(s.indexOf(e)>=0)){var t=r.params[e];[null,void 0].indexOf(t)>=0||(o[e]=t)}}),!r.params.appId)throw new Error('Framework7:"app.id" is required to display an ad. Make sure you have specified it on app initialization.');if(!r.params.placementId)throw new Error('Framework7:"placementId" is required to display an ad.');function l(){var e=$$1("iframe#viAd");0!==e.length&&e.css({width:t.width+"px",height:t.height+"px"})}function p(){r.$overlayEl&&(r.$overlayEl.off("click touchstart"),r.$overlayEl.remove())}r.ad=new win.vi.Ad(o),Utils.extend(r.ad,{onAdReady:function(){t.on("resize",l),r.emit("local::ready"),r.params.autoplay&&r.start()},onAdStarted:function(){r.emit("local::started")},onAdClick:function(e){r.emit("local::click",e)},onAdImpression:function(){r.emit("local::impression")},onAdStopped:function(e){t.off("resize",l),p(),r.emit("local::stopped",e),"complete"===e&&(r.emit("local::complete"),r.emit("local::completed")),"userexit"===e&&r.emit("local::userexit"),r.destroyed=!0},onAutoPlayFailed:function(e,a){var n,i;r.emit("local::autoplayFailed",e,a),e&&e.name&&-1!==e.name.indexOf("NotAllowedError")&&r.params.fallbackOverlay&&(n=a)&&(r.$overlayEl=$$1(('\n        <div class="vi-overlay no-fastclick">\n          '+(r.params.fallbackOverlayText?'<div class="vi-overlay-text">'+r.params.fallbackOverlayText+"</div>":"")+'\n          <div class="vi-overlay-play-button"></div>\n        </div>\n      ').trim()),r.$overlayEl.on("touchstart",function(){i=Utils.now()}),r.$overlayEl.on("click",function(){if(!(Utils.now()-i>300)){if(n)return n.play(),void p();r.start(),p()}}),t.root.append(r.$overlayEl))},onAdError:function(e){p(),t.off("resize",l),r.emit("local::error",e),r.destroyed=!0}}),r.init(),Utils.extend(r,{app:t})}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.start=function(){this.destroyed||this.ad&&this.ad.startAd()},t.prototype.pause=function(){this.destroyed||this.ad&&this.ad.pauseAd()},t.prototype.resume=function(){this.destroyed||this.ad&&this.ad.resumeAd()},t.prototype.stop=function(){this.destroyed||this.ad&&this.ad.stopAd()},t.prototype.init=function(){this.destroyed||this.ad&&this.ad.initAd()},t.prototype.destroy=function(){this.destroyed=!0,this.emit("local::beforeDestroy"),Utils.deleteProps(this)},t}(Framework7Class),Vi={name:"vi",params:{vi:{enabled:!1,autoplay:!0,fallbackOverlay:!0,fallbackOverlayText:"Please watch this ad",showMute:!0,startMuted:(Device.ios||Device.android)&&!Device.cordova,appId:null,appVer:null,language:null,width:null,height:null,placementId:"pltd4o7ibb9rc653x14",placementType:"interstitial",videoSlot:null,showProgress:!0,showBranding:!0,os:null,osVersion:null,orientation:null,age:null,gender:null,advertiserId:null,latitude:null,longitude:null,accuracy:null,storeId:null,ip:null,manufacturer:null,model:null,connectionType:null,connectionProvider:null}},create:function(){var e=this;e.vi={sdkReady:!1,createAd:function(t){return new ViAd(e,t)},loadSdk:function(){if(!e.vi.skdReady){var t=doc.createElement("script");t.onload=function(){e.emit("viSdkReady"),e.vi.skdReady=!0},t.src="https://c.vi-serve.com/viadshtml/vi.min.js",$$1("head").append(t)}}}},on:{init:function(){(this.params.vi.enabled||this.passedParams.vi&&!1!==this.passedParams.vi.enabled)&&this.vi.loadSdk()}}},Typography={name:"typography"};return"undefined"!=typeof window&&(window.Template7||(window.Template7=Template7),window.Dom7||(window.Dom7=$$1)),Framework7.use([DeviceModule,SupportModule,UtilsModule,ResizeModule,RequestModule,TouchModule,ClicksModule,Router$1,HistoryModule,StorageModule,Statusbar$1,View$1,Navbar$1,Toolbar$1,Subnavbar,TouchRipple$1,Modal$1,Dialog$1,Popup$1,LoginScreen$1,Popover$1,Actions$1,Sheet$1,Toast$1,Preloader$1,Progressbar$1,Sortable$1,Swipeout$1,Accordion$1,VirtualList$1,ListIndex$1,Timeline,Tabs,Panel$1,Card,Chip,Form,Input$1,Checkbox,Radio,Toggle$1,Range$1,Stepper$1,SmartSelect$1,Grid,Calendar$1,Picker$1,InfiniteScroll$1,PullToRefresh$1,Lazy$1,DataTable$1,Fab$1,Searchbar$1,Messages$1,Messagebar$1,Swiper$1,PhotoBrowser$1,Notification$1,Autocomplete$1,Vi,Typography]),Framework7});
//# sourceMappingURL=framework7.min.js.map
