<?php
    function slugs($string, $lower) {

        $table = array(
                'Š'=>'S', 'š'=>'s', 'Đ'=>'Dj', 'đ'=>'dj', 'Ž'=>'Z', 'ž'=>'z', 'Č'=>'C', 'č'=>'c', 'Ć'=>'C', 'ć'=>'c',
                'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E',
                'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O',
                'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ý'=>'Y', 'Þ'=>'B', 'ß'=>'Ss',
                'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'æ'=>'a', 'ç'=>'c', 'è'=>'e', 'é'=>'e',
                'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'ð'=>'o', 'ñ'=>'n', 'ò'=>'o', 'ó'=>'o',
                'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ý'=>'y', 'ý'=>'y', 'þ'=>'b',
                'ÿ'=>'y', 'Ŕ'=>'R', 'ŕ'=>'r', '/' => '-', ' ' => '-'
        );

        // -- Remove duplicated spaces
        $stripped = preg_replace(array('/\s{2,}/', '/[\t\n]/'), ' ', $string);

        // -- Returns the slug

        if($lower == '1'){
            return strtolower(strtr($string, $table));
        } else {
            return (strtr($string, $table));
        }


    }

    function dataValida($data, $formato){
        if(!isset($_SESSION)){ session_start(); }
        $sincronizacao = $_SESSION["configs"]["config_sincronizacao"];
        /* FORMATO: 0 - Datetime | 1 - START_DATE FBET */

        switch ($formato) {
            case '0':
                if(strtotime($data) <= strtotime(date('Y-m-d H:i:s')) || strtotime($data) > strtotime($sincronizacao)){
                    return FALSE;
                } else {
                    return TRUE;
                }
                break;

            case '1':
                $data = explode(' ', $data);
                $hora = $data[1].':00';
                $data = explode('/', $data[0]);
                $data = $data[2].'-'.$data[1].'-'.$data[0].' '.$hora;
                if(strtotime($data) <= strtotime(date('Y-m-d H:i:s')) || strtotime($data) > strtotime($sincronizacao)){
                    return FALSE;
                } else {
                    return TRUE;
                }
                break;

            default:
                if(strtotime($data) <= strtotime(date('Y-m-d H:i:s'))){
                    return FALSE;
                } else {
                    return TRUE;
                }
                break;
        }
    }

    function desfazDatetime($datetime){
        $datetime = explode(' ', $datetime);
        $hora = $datetime[1];
        $datetime = explode('-', $datetime[0]);
        return $datetime[2].'/'.$datetime[1].'/'.$datetime[0].' '.$hora;
    }

    function FBETDateToDatetime($d){
        $d = explode(' ', $d);
        $h = $d[1].':00';
        $d = explode('/', $d[0]);
        return $d[2].'-'.$d[1].'-'.$d[0].' '.$h;
    }

    function alteraCotacao($odd, $porcentagem, $tipo){
        $porcentagem = str_replace('-', '', $porcentagem);
        $porcentagem = str_replace('%', '', $porcentagem);
        $tipo = str_replace('0', '-', $tipo);
        $tipo = str_replace('1', '+', $tipo);

        $pct = (float)$odd / 100;
        $pct = (float)$pct * $porcentagem;

        if($tipo == '-'){
            $total = (float)$odd - (float)$pct;
        }
        else {
            $total = (float)$odd + (float)$pct;
        }

        if($total < 1){
            $total = '0.00';
        }

        return number_format($total, 2);
    }

    function modificaOdds($data){
        /*
            ARRAY. Esta função recebe no parâmetro data, um conjunto de informações. Esta função é responsável por aplicar as mudanças feitas no menu mercados.
            [0] = MERCADO:OPÇÃO:ODD
        */
        $ret = array();
        if(!isset($_SESSION)){ session_start(); }
        $mercados = $_SESSION["mercados"];
        $ct_maxima = $_SESSION["configs"]["config_ct_maxima"];
        $userid = 0;
        if(isset($_SESSION["usuario_id"])){ $userid = (int)$_SESSION["usuario_id"]; }

        foreach ($data as $k => $v) {
            $i = explode(':', $v); // $i[0] = MERCADO, $i[1] = OPÇÃO, $i[2] = ODD
            if(isset($i[3])){ $k = $i[3]; } // Se tiver o quarto item (i[3]), é o ID

            // Pesquisa se há modificação para o usuário
            if(isset($mercados[$userid][$i[0]][$i[1]])){
                $ret[$k] = alteraCotacao($i[2], $mercados[$userid][$i[0]][$i[1]]['porcentagem'], $mercados[$userid][$i[0]][$i[1]]['tipo']);
                if($mercados[$userid][$i[0]][$i[1]]['limite'] <> '' && $mercados[$userid][$i[0]][$i[1]]['limite'] <> '0' && $ret[$k] > $mercados[$userid][$i[0]][$i[1]]['limite']){
                    $ret[$k] = $mercados[$userid][$i[0]][$i[1]]['limite'];
                }
            } elseif(isset($mercados[$userid][$i[0]]['all'])){
                $ret[$k] = alteraCotacao($i[2], $mercados[$userid][$i[0]]['all']['porcentagem'], $mercados[$userid][$i[0]]['all']['tipo']);
                if($mercados[$userid][$i[0]]['all']['limite'] <> '' && $mercados[$userid][$i[0]]['all']['limite'] <> '0' && $ret[$k] > $mercados[$userid][$i[0]]['all']['limite']){
                    $ret[$k] = $mercados[$userid][$i[0]]['all']['limite'];
                }
            } elseif(isset($mercados[0][$i[0]][$i[1]])){
                $ret[$k] = alteraCotacao($i[2], $mercados[0][$i[0]][$i[1]]['porcentagem'], $mercados[0][$i[0]][$i[1]]['tipo']);
                if($mercados[0][$i[0]][$i[1]]['limite'] <> '' && $mercados[0][$i[0]][$i[1]]['limite'] <> '0' && $ret[$k] > $mercados[0][$i[0]][$i[1]]['limite']){
                    $ret[$k] = $mercados[0][$i[0]][$i[1]]['limite'];
                }
            } elseif(isset($mercados[0][$i[0]]['all'])){
                $ret[$k] = alteraCotacao($i[2], $mercados[0][$i[0]]['all']['porcentagem'], $mercados[0][$i[0]]['all']['tipo']);
                if($mercados[0][$i[0]]['all']['limite'] <> '' && $mercados[0][$i[0]]['all']['limite'] <> '0' && $ret[$k] > $mercados[0][$i[0]]['all']['limite']){
                    $ret[$k] = $mercados[0][$i[0]]['all']['limite'];
                }
            } else {
                $ret[$k] = $i[2];
            }
            if($ret[$k] > $ct_maxima){ $ret[$k] = $ct_maxima; }
        }

        return $ret;
    }

    function setErrorAJAX($msg){
        echo $msg; exit; // Mostra mensagem e interrompe script (usado na finalização de apostas e afins)
        return '';
    }

    function formataReal($cents){
        $cents /= 100;
        return number_format($cents, 2, ',', '.');
    }

    function realToCents($v){
        $v = str_replace('.', '', $v);
        $v = str_replace(',', '', $v);
        return $v;
    }


    function geraToken($tamanho = 8, $maiusculas = true, $numeros = true, $simbolos = false){
        $token = "";
        // Caracteres de cada tipo
        $lmin = 'abcdefghijklmnopqrstuvwxyz';
        $lmai = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $num = '1234567890';
        $simb = '!@#$%*-';

        // Variáveis internas
        $retorno = '';
        $caracteres = '';

        // Caracteres que poderão ser utilizados
        $caracteres .= $lmin;
        if ($maiusculas) $caracteres .= $lmai;
        if ($numeros) $caracteres .= $num;
        if ($simbolos) $caracteres .= $simb;

        // Total de caracteres possíveis
        $len = strlen($caracteres);

        for ($n = 1; $n <= $tamanho; $n++) {
            // Aleatório de 1 até $len para pegar um dos caracteres
            $rand = mt_rand(1, $len);
            // Concatena um dos caracteres na variável $retorno
            $token .= $caracteres[$rand-1];
        }

        return $token;
    }

    function exibirTelImpressao($config_tel_impressao, $tel_banca, $usuario, $users){
        switch ($config_tel_impressao) {
            case '1': // Exibir número da banca
                return $tel_banca;
                break;

            case '2': // Exibir número cambista, supervisor++, banca
                if($users[$usuario]['telefone'] <> ''){ return $users[$usuario]['telefone']; }
                $tel = 0;
                $aux = $usuario;
                while($tel == 0){
                    $supervisor = $users[$aux]['gerente'];
                    if($users[$supervisor]['telefone'] <> ''){ return $users[$supervisor]['telefone']; }
                    else {
                        if((int)$users[$supervisor]["gerente"] == '0'){ return $tel_banca; }
                        $aux = $users[$supervisor]['gerente'];
                    }
                }

                break;

            case '3': // Exibir número supervisor, banca
                $supervisor = $users[$usuario]['gerente'];
                if($users[$supervisor]['telefone'] <> ''){ return $users[$supervisor]['telefone']; }
                else { return $tel_banca; }
                break;

            case '4': // Exibir número cambista, banca
                if($users[$usuario]['telefone'] <> ''){ return $users[$usuario]['telefone']; }
                else { return $tel_banca; }
                break;

            default:
                return $tel_banca;
                break;
        }
    }

    function finishJSONRequest($ret){
        echo json_encode($ret); exit;
    }

    function balanceResume($users, $date, $enddate){
        include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
        $ret = array();

        $sql = $mysqli->query("SELECT cupom_valor, cupom_codigo, cupom_data, cupom_cliente, cupom_retorno, cupom_usuario, cupom_comissao, cupom_saidas, cupom_situacao FROM cupons WHERE cupom_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY cupom_data DESC");

        while($c = $sql->fetch_assoc()){
            $u = $c["cupom_usuario"];
            if(!isset($ret[$u])){
                // Inicia variáveis
                $ret[$u]['open_entries'] = 0;
                $ret[$u]['entries'] = 0;
                $ret[$u]['cancelled'] = 0;
                $ret[$u]['comissions'] = 0;
                $ret[$u]['rewards'] = 0;
                $ret[$u]['lanc'] = 0;
                $ret[$u]['total'] = 0;
            }

            switch ($c["cupom_situacao"]) {
                case '1':
                    $ret[$u]['open_entries'] += $c["cupom_valor"];
                    // $ret[$u]['comissions'] += $c["cupom_comissao"];
                    break;

                case '2':
                    $ret[$u]['entries'] += $c["cupom_valor"];
                    $ret[$u]['rewards'] += $c["cupom_saidas"];
                    $ret[$u]['comissions'] += $c["cupom_comissao"];
                    break;

                case '3':
                    $ret[$u]['entries'] += $c["cupom_valor"];
                    $ret[$u]['comissions'] += $c["cupom_comissao"];
                    break;

                case '4':
                    $ret[$u]['cancelled'] += $c["cupom_valor"];
                    break;

                default:
                    # code...
                    break;
            }
        }

        // Agora, lançamentos
        $sql = $mysqli->query("SELECT * FROM lancamentos WHERE lancamento_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59'");

        while($c = $sql->fetch_assoc()){
            $u = $c["lancamento_usuario"];
            if(!isset($ret[$u])){
                // Inicia variáveis
                $ret[$u]['open_entries'] = 0;
                $ret[$u]['entries'] = 0;
                $ret[$u]['cancelled'] = 0;
                $ret[$u]['comissions'] = 0;
                $ret[$u]['rewards'] = 0;
                $ret[$u]['lanc'] = 0;
                $ret[$u]['total'] = 0;
            }

            if($c["lancamento_tipo"] == 'C'){ $ret[$u]['lanc'] += $c["lancamento_valor"]; } else { $ret[$u]['lanc'] -= $c["lancamento_valor"]; }
        }

        // Por fim, formata real
        foreach ($ret as $id => $v) {
            $ret[$id]['total'] = ($ret[$id]['entries'] + ($ret[$id]['lanc'])) - ($ret[$id]['rewards'] + $ret[$id]['comissions']);
            $ret[$id]['open_entries'] = formataReal($ret[$id]['open_entries']);
            $ret[$id]['entries'] = formataReal($ret[$id]['entries']);
            $ret[$id]['cancelled'] = formataReal($ret[$id]['cancelled']);
            $ret[$id]['comissions'] = formataReal($ret[$id]['comissions']);
            $ret[$id]['lanc'] = formataReal($ret[$id]['lanc']);
            $ret[$id]['rewards'] = formataReal($ret[$id]['rewards']);
            $ret[$id]['total'] = formataReal($ret[$id]['total']);
        }
        return $ret;
    }

    function url_exists($url) {
        if (!$fp = curl_init($url)) return false;
        return true;
    }

    function appGeraDataEvento($data){
        $data = date('Y-m-d H:i:s', $data);

        $data = date('Y-m-d H:i:s', strtotime('+0 hours', strtotime($data)));
        $data = explode(' ', $data);
        $hora = $data[1];
        $data = explode('-', $data[0]);
        $data = $data[2].'/'.$data[1].'/'.$data[0].' '.substr($hora, 0, 5);
        return $data;
    }

    function getHierarquia($admin, $user, $users){
        $atualUser = $user;
        $max = 200;
        while(1 == 1){
            if($max == 0){ return false; }
            if($users[$atualUser]['usuario_gerente'] == '0'){ return false; }
            if($users[$atualUser]['usuario_gerente'] == $admin){ return true; }
            $atualUser = $users[$atualUser]['usuario_gerente'];
            $max--;
        }
    }

?>