<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$datetime = date('Y-m-d H:i:s');
	$_GET = $query;
	if(isset($_SESSION["usuario"]["api_token"])){ $_GET["token"] = $_SESSION["usuario"]["api_token"]; }
	if(isset($_SESSION["usuario"]["id"])){ $userid = $_SESSION["usuario"]["id"]; }
	$token = $mysqli->escape_string($_GET["token"]);
	$perms = array();
	$user = $mysqli->escape_string($_GET["user"]);
	$grade = $mysqli->escape_string($_GET["rate"]);
	$date = $mysqli->escape_string(FBETDateToDatetime($_GET["date"].' 00:00'));
	$enddate = $mysqli->escape_string(FBETDateToDatetime($_GET["enddate"].' 23:59'));

	// Pesquisa usuários
	$users = array();
	$user_consultor = array(); // Tipo de usuário de quem está consultando a API
	$sql = $mysqli->query("SELECT * FROM usuarios WHERE usuario_api_token = '$token' OR usuario_id = '$user'");
	while ($t = $sql->fetch_assoc()) {
		if($t["usuario_api_token"] == $token){
			$user_consultor["id"] = $t["usuario_id"];
			$user_consultor["nome"] = utf8_encode($t["usuario_nome"]);
			$user_consultor["gerente"] = $t["usuario_gerente"];
			$user_consultor["status"] = $t["usuario_status"];
			$user_consultor["tipo"] = $t["usuario_tipo"];
			$user_consultor["credito"] = $t["usuario_credito"];
			$perms = explode('-', $t["usuario_permissoes"]);
		} else {
			$users["id"] = $t["usuario_id"];
			$users["nome"] = utf8_encode($t["usuario_nome"]);
			$users["gerente"] = $t["usuario_gerente"];
			$users["status"] = $t["usuario_status"];
			$users["tipo"] = $t["usuario_tipo"];
			$users["credito"] = $t["usuario_credito"];
		}
	}
	$userid = $user_consultor["id"];

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	if(!in_array('25', $perms) && !in_array('2', $perms)){ $ret['error'] = 'Previlégios insuficientes para atualizar comissões.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerms'; finishJSONRequest($ret); }

	if((in_array('25', $perms) && !in_array('2', $perms)) && $user_consultor["id"] <> $users["gerente"]){ $ret['error'] = 'Previlégios insuficientes para atualizar comissões. O usuário não é gerenciado por você.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerms'; finishJSONRequest($ret); }

	// Verificações
	if((int)$user == 0){ $ret['error'] = 'O usuário informado não é válido.'; $ret['status'] = 'error'; $ret['status_code'] = 'validationError'; finishJSONRequest($ret); }
	if((int)$grade == 0){ $ret['error'] = 'A grade selecionada não é válida.'; $ret['status'] = 'error'; $ret['status_code'] = 'validationError'; finishJSONRequest($ret); }
	if($date == ''){ $ret['error'] = 'A data informada não é válida.'; $ret['status'] = 'error'; $ret['status_code'] = 'validationError'; finishJSONRequest($ret); }

	// Pesquisa regras
	$opcoes = array();
	$sql = $mysqli->query("SELECT * FROM opcoes_grade WHERE og_grade = '$grade'");
	while($o = $sql->fetch_assoc()){
		$i = count($opcoes);
		$opcoes[$i]["min"] = $o["og_minimo"];
		$opcoes[$i]["max"] = $o["og_maximo"];
		$opcoes[$i]["percent"] = $o["og_comissao"];
	}

	$mqueries = "UPDATE usuarios SET usuario_grade = '$grade' WHERE usuario_id = '$user'; ";
	$ret['updated'] = array();
	$ret['ignored'] = array();

	##################################################### RECALCULO DE COMISSÃO #####################################################


  	$sql = $mysqli->query("SELECT * FROM cupons WHERE cupom_data BETWEEN '$date' and '$enddate' and cupom_situacao <> '4' and cupom_usuario = '$user'");
  	if(!$sql){ $ret['error'] = 'Ocorreu um erro. Erro: '.$mysqli->error; $ret['status'] = 'error'; $ret['status_code'] = 'dbError'; finishJSONRequest($ret); }
  	$ret['total_coupons'] = mysqli_num_rows($sql);
  	while($c = $sql->fetch_assoc()){
  		$id = $c["cupom_id"];
  		$qtd = (int)$c["cupom_jogos"];
  		$porcentagem = 0;
  		if($qtd == 0){ continue; }

  		// Encontra grade
  		foreach ($opcoes as $k => $g) {
  			if($qtd >= $g['min'] && $qtd <= $g['max']){ $porcentagem = $g['percent']; }
  		}

  		// Define comissão
  		$comissao = ($c["cupom_valor"] / 100) * $porcentagem;

  		// Confere se não é igual a comissão atual
  		if($comissao == $c["cupom_comissao"]){
	  		$ret['ignored'][$c["cupom_codigo"]]['code'] = $c["cupom_codigo"];
	  		$ret['ignored'][$c["cupom_codigo"]]['seller_id'] = $c["cupom_usuario"];
	  		$ret['ignored'][$c["cupom_codigo"]]['old_comission'] = formataReal($c["cupom_comissao"]);
	  		$ret['ignored'][$c["cupom_codigo"]]['new_comission'] = formataReal($comissao);
  			continue;
  		}
  		$mqueries .= "UPDATE cupons SET cupom_comissao = '$comissao' WHERE cupom_id = '$id'; ";
  		$ret['updated'][$c["cupom_codigo"]]['code'] = $c["cupom_codigo"];
  		$ret['updated'][$c["cupom_codigo"]]['seller_id'] = $c["cupom_usuario"];
  		$ret['updated'][$c["cupom_codigo"]]['old_comission'] = formataReal($c["cupom_comissao"]);
  		$ret['updated'][$c["cupom_codigo"]]['new_comission'] = formataReal($comissao);
  	}

	##################################################### /RECALCULO DE COMISSÃO ####################################################

  	// Por fim, adiciona ao histórico
  	$sql = $mysqli->query("SELECT * FROM grades WHERE grade_id = '$grade'");
  	$g = $sql->fetch_assoc();
  	$titulo = utf8_decode('Recálculo de comissão para o usuário '.$users['nome'].' - (Grade '.$g["grade_nome"].')');
  	$descricao = utf8_decode(json_encode($ret));
  	$mqueries .= "INSERT INTO historico SET hist_tipo = 'comissionRecalc', hist_titulo = '$titulo', hist_descricao = '$descricao', hist_usuario = '$user', hist_admin = '$userid', hist_data = '$datetime'; ";

	$sqlmulti = mysqli_multi_query($mysqli, $mqueries);
	if(!$sqlmulti){
		if($mysqli->error <> 'Query was empty'){
			$ret['error'] = 'Ocorreu um erro ao recalcular comissões. Erro: '.$mysqli->error; $ret['status'] = 'error'; $ret['status_code'] = 'dbError'; finishJSONRequest($ret);
		}
	}


	// Datas
	$ret['success'] = 'Recálculo efetuado com sucesso!';
	$ret['status'] = 'success';

	echo json_encode($ret);
?>