<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$datetime = date('Y-m-d H:i:s');
	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	if(isset($_SESSION["usuario"]["api_token"])){ $_GET["token"] = $_SESSION["usuario"]["api_token"]; }
	if(isset($_SESSION["usuario"]["id"])){ $userid = $_SESSION["usuario"]["id"]; }
	$token = $_GET["token"];
	$user = $_GET["user"];
	$perms = array();

	############# INFO PARA CONSULTA DE CAIXA #############

	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }
	if(!isset($_GET["type"])){ $type = $domingo; } else { $type = $mysqli->escape_string($_GET["type"]); }

	############# INFO PARA CONSULTA DE CAIXA #############
	$tokenconta = $user.substr(sha1($date.$enddate), 0, 12);

	// Pesquisa usuários
	$users = array();
	$user_consultor = array(); // Tipo de usuário de quem está consultando a API
	$sql = $mysqli->query("SELECT * FROM usuarios WHERE usuario_id = '$userid' OR usuario_id = '$user' ORDER BY usuario_nome ASC");
	while ($t = $sql->fetch_assoc()) {
		if($t["usuario_api_token"] == $token){
			$user_consultor["id"] = $t["usuario_id"];
			$user_consultor["nome"] = utf8_encode($t["usuario_nome"]);
			$user_consultor["gerente"] = $t["usuario_gerente"];
			$user_consultor["status"] = $t["usuario_status"];
			$user_consultor["tipo"] = $t["usuario_tipo"];
			$user_consultor["credito"] = $t["usuario_credito"];
			$perms = explode('-', $t["usuario_permissoes"]);
		}

		$users[$t["usuario_id"]]["id"] = $t["usuario_id"];
		$users[$t["usuario_id"]]["nome"] = utf8_encode($t["usuario_nome"]);
		$users[$t["usuario_id"]]["gerente"] = $t["usuario_gerente"];
		$users[$t["usuario_id"]]["status"] = $t["usuario_status"];
		$users[$t["usuario_id"]]["credito"] = $t["usuario_credito"];
		$users[$t["usuario_id"]]["tipo"] = $t["usuario_tipo"];
		$users[$t["usuario_id"]]["permissoes"] = explode('-', $t["usuario_permissoes"]);
	}

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Confere se possui permissões
	if(!in_array('31', $perms) && (!in_array('30', $perms) || $users[$user]['gerente'] <> $userid)){ $ret['error'] = 'Você não possui permissões suficientes para prestar contas.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Pesquisa se já existe conta com esse token
	$sql = $mysqli->query("SELECT conta_id FROM contas WHERE conta_token = '$tokenconta'");
	if(mysqli_num_rows($sql) > 0){ $ret['error'] = 'Esta prestação de contas já foi marcada como finalizada.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Percorre usuários
	$i = 1;
	$caixas = array();
	array_push($caixas, $user);

	// Caixas
	$caixas = balanceResume($caixas, $date, $enddate);

	// Percorre caixas e atribui aos usuários
	$open_entries = realToCents($caixas[$user]["open_entries"]);
	$entries = realToCents($caixas[$user]["entries"]);
	$cancelled = realToCents($caixas[$user]["cancelled"]);
	$comissions = realToCents($caixas[$user]["comissions"]);
	$rewards = realToCents($caixas[$user]["rewards"]);
	$lanc = realToCents($caixas[$user]["lanc"]);
	$balance = realToCents($caixas[$user]["total"]);
	$balance_type = realToCents(((int)$caixas[$user]["total"] < 0) ? '-' : '+');

	// Lança
	$periodo = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));
	$sql = $mysqli->query("INSERT INTO contas SET conta_token = '$tokenconta', conta_periodo = '$periodo', conta_usuario = '$user', conta_entradas = '$entries', conta_saidas = '$rewards', conta_comissoes = '$comissions', conta_lancamentos = '$lanc', conta_total = '$balance', conta_prestador = '$userid', conta_data = '$datetime'");
	if(!$sql){
		$ret['error'] = 'Houve um erro ao salvar. O sistema retornou: '.$mysqli->error.'.'; $ret['status'] = 'error'; $ret['status_code'] = 'databaseError'; finishJSONRequest($ret);
	}

	// Joga bilhetes para lixeira
	$sql = $mysqli->query("UPDATE cupons SET cupom_lixeira = '1', cupom_nota = '$tokenconta' WHERE cupom_usuario = '$user' and cupom_data BETWEEN '$date 00:00:00' and '$enddate 23:59:59'");
	if(!$sql){
		$ret['error'] = 'Houve um erro ao salvar [2]. O sistema retornou: '.$mysqli->error.'.'; $ret['status'] = 'error'; $ret['status_code'] = 'databaseError'; finishJSONRequest($ret);
	}


	// Datas
	$ret['success'] = 'Pronto! Salvo com sucesso.';
	$ret['status'] = 'success';
	$ret['user'] = $user;
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;
	$ret['code'] = $tokenconta;
	$ret['dates'] = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));

	echo json_encode($ret);
?>