<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	if(isset($_SESSION["usuario"]["api_token"])){ $_GET["token"] = $_SESSION["usuario"]["api_token"]; }
	if(isset($_SESSION["usuario"]["id"])){ $userid = $_SESSION["usuario"]["id"]; }
	$token = $_GET["token"];
	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }
	if(!isset($_GET["type"])){ $type = $domingo; } else { $type = $mysqli->escape_string($_GET["type"]); }

	// Retorno
	$ret = array();

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_tipo, usuario_permissoes, usuario_nome FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$usertipo = $u["usuario_tipo"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Verifica type e permissões
	if(!in_array('29', $perms)){ $ret['error'] = 'Previlégios insuficientes para efetuar lançamentos.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerms'; finishJSONRequest($ret); }

	// Pesquisa
	$usuarios[$userid] = utf8_encode($u["usuario_nome"]);

	// Caso haja filtro por usuário
	$user_filtro = '';
	if(isset($_GET["user"])){ $user_id_filtro = (int)$_GET["user"]; $user_filtro2 = "lancamento_usuario = '$user_id_filtro' AND "; }

	$sql2 = $mysqli->query("SELECT * FROM lancamentos WHERE $user_filtro2 lancamento_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY lancamento_id DESC");

	// Pesquisa usuários do sistema
	$sql3 = $mysqli->query("SELECT usuario_id, usuario_nome FROM usuarios");
	while ($us = $sql3->fetch_assoc()) { $usuarios[$us["usuario_id"]] = utf8_encode($us["usuario_nome"]); }

	if(!$sql){ $ret['error'] = 'Erro de consulta: '.$mysqli->error; $ret['status'] = 'error'; $ret['status_code'] = 'dbExecError'; finishJSONRequest($ret); }


	// Lançamentos
	while ($l = $sql2->fetch_assoc()) {
		if($usertipo <> '1' && getHierarquia($userid, $l["lancamento_usuario"], $_SESSION['users']) == false){ continue; }
		$i = count($ret['list']);
		$ret['list'][$i]['id'] = $l["lancamento_id"];
		$ret['list'][$i]['user'] = $usuarios[$l["lancamento_usuario"]];
		$ret['list'][$i]['userid'] = $l["lancamento_usuario"];
		$ret['list'][$i]['price'] = formataReal($l["lancamento_valor"]);
		$ret['list'][$i]['type'] = $l["lancamento_tipo"];
		$ret['list'][$i]['description'] = utf8_encode($l["lancamento_descricao"]);
		$ret['list'][$i]['date'] = $l["lancamento_data"];
		$ret['list'][$i]['admin'] = $usuarios[$l["lancamento_feito_por"]];
		$ret['list'][$i]['admin_id'] = $l["lancamento_feito_por"];
	}

	$ret['success'] = 'Lançamentos de caixa listados com sucesso.';
	$ret['status'] = 'success';
	$ret['user'] = (int)$user;
	$ret['dates'] = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;
	echo json_encode($ret);
?>