<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$perms = array();

	############# INFO PARA CONSULTA DE CAIXA #############

	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }
	if(!isset($_GET["type"])){ $type = $domingo; } else { $type = $mysqli->escape_string($_GET["type"]); }

	############# INFO PARA CONSULTA DE CAIXA #############

	// Pesquisa usuários
	$users = array();
	$user_consultor = array(); // Tipo de usuário de quem está consultando a API
	$sql = $mysqli->query("SELECT * FROM usuarios ORDER BY usuario_nome ASC");
	while ($t = $sql->fetch_assoc()) {
		if($t["usuario_api_token"] == $token){
			$user_consultor["id"] = $t["usuario_id"];
			$user_consultor["nome"] = utf8_encode($t["usuario_nome"]);
			$user_consultor["gerente"] = $t["usuario_gerente"];
			$user_consultor["status"] = $t["usuario_status"];
			$user_consultor["tipo"] = $t["usuario_tipo"];
			$user_consultor["credito"] = $t["usuario_credito"];
			$perms = explode('-', $t["usuario_permissoes"]);
		}

		$users[$t["usuario_id"]]["id"] = $t["usuario_id"];
		$users[$t["usuario_id"]]["nome"] = utf8_encode($t["usuario_nome"]);
		$users[$t["usuario_id"]]["gerente"] = $t["usuario_gerente"];
		$users[$t["usuario_id"]]["status"] = $t["usuario_status"];
		$users[$t["usuario_id"]]["credito"] = $t["usuario_credito"];
		$users[$t["usuario_id"]]["tipo"] = $t["usuario_tipo"];
		$users[$t["usuario_id"]]["permissoes"] = explode('-', $t["usuario_permissoes"]);
	}

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Confere se possui permissões
	if(!in_array('31', $perms) && !in_array('30', $perms)){ $ret['error'] = 'Você não possui permissões suficientes para prestar contas.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Percorre usuários
	$i = 1;
	$caixas = array();
	foreach ($users as $id => $v) {
		if(!in_array('3', $v["permissoes"])){ continue; }
		if(!in_array('31', $perms) && $v["gerente"] <> $user_consultor["id"] && getHierarquia($user_consultor["id"], $v['id'], $_SESSION['users']) == false){ continue; }
		$ret['user_info'][$i]['id'] = $v["id"];
		$ret['user_info'][$i]['name'] = $v["nome"];
		$ret['user_info'][$i]['manager'] = $users[$v["gerente"]]["nome"];
		$ret['user_info'][$i]['manager_id'] = $users[$v["gerente"]]["id"];
		$ret['user_info'][$i]['status'] = $v["status"];
		$ret['user_info'][$i]['credit'] = formataReal($v["credito"]);
		$ret['user_info'][$i]['balance'] = '0,00';
		array_push($caixas, $v["id"]);
		$i++;
	}

	// Caixas
	$caixas = balanceResume($caixas, $date, $enddate);

	// Percorre caixas e atribui aos usuários
	foreach ($ret['user_info'] as $k => $v) {
		if(isset($caixas[$v["id"]])){
			$ret['user_info'][$k]['open_entries'] = $caixas[$v["id"]]["open_entries"];
			$ret['user_info'][$k]['entries'] = $caixas[$v["id"]]["entries"];
			$ret['user_info'][$k]['cancelled'] = $caixas[$v["id"]]["cancelled"];
			$ret['user_info'][$k]['comissions'] = $caixas[$v["id"]]["comissions"];
			$ret['user_info'][$k]['rewards'] = $caixas[$v["id"]]["rewards"];
			$ret['user_info'][$k]['lanc'] = $caixas[$v["id"]]["lanc"];
			$ret['user_info'][$k]['balance'] = $caixas[$v["id"]]["total"];
			$ret['user_info'][$k]['balance_type'] = ((int)$caixas[$v["id"]]["total"] < 0) ? '-' : '+';
		}
	}

	// Datas
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;
	$ret['dates'] = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));

	echo json_encode($ret);
?>