<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Retorno
	$ret = array();
	$ret['date'] = date('Y-m-d H:i:s');

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_permissoes, usuario_nome FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Verifica type e permissões
	if(!in_array('9', $perms)){ $ret['error'] = 'Você não possui permissões suficientes para visualizar o mapa.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Pesquisa
	$ret['combos'] = array();
	$jogos = array();
	$sortReturn = array();
	$choices_consultar = array();
	$bilhetes = array();
	$sql = $mysqli->query("SELECT cupom_codigo, cupom_valor, cupom_retorno, cupom_choices FROM cupons WHERE cupom_situacao = '1' AND cupom_usuario <> '0'");
	while ($b = $sql->fetch_assoc()) {
		$bilhetes[$b["cupom_codigo"]]['code'] = $b["cupom_codigo"];
		$bilhetes[$b["cupom_codigo"]]['price'] = $b["cupom_valor"];
		$bilhetes[$b["cupom_codigo"]]['return'] = $b["cupom_retorno"];
		$bilhetes[$b["cupom_codigo"]]['choices'] = $b["cupom_choices"];

		$choices = explode('-', $b["cupom_choices"]);

		// Adiciona choices para consulta
		foreach ($choices as $k) { if(!in_array($k, $choices_consultar)){ array_push($choices_consultar, $k); } }

		sort($choices);
		$choices = sha1(implode('', $choices));

		// Adiciona combinação
		if(!$ret['combos'][$choices]){ $ret['combos'][$choices]['price'] = 0; $ret['combos'][$choices]['return'] = 0; $ret['combos'][$choices]['qtd'] = 0; $ret['combos'][$choices]['coupons'] = array(); $ret['combos'][$choices]['matches'] = array(); }
		$ret['combos'][$choices]['price'] += $b["cupom_valor"];
		$ret['combos'][$choices]['return'] += $b["cupom_retorno"];
		$ret['combos'][$choices]['qtd']++;
		$ret['combos'][$choices]['choices'] = explode('-', $b["cupom_choices"]);
		array_push($ret['combos'][$choices]['coupons'], $b["cupom_codigo"]);
	}

	// Pega códigos
	$choices_consultar = join("','", $choices_consultar);
	$sql = $mysqli->query("SELECT DISTINCT(aposta_opcao_id), aposta_status, aposta_jogo_nome, aposta_opcao, aposta_mercado FROM apostas WHERE aposta_opcao_id IN('$choices_consultar')");
	while($c = $sql->fetch_assoc()){
		$jogos[$c["aposta_opcao_id"]]['choice_id'] = $c["aposta_opcao_id"];
		$jogos[$c["aposta_opcao_id"]]['name'] = utf8_encode($c["aposta_jogo_nome"]);
		$jogos[$c["aposta_opcao_id"]]['option'] = utf8_encode($c["aposta_opcao"]);
		$jogos[$c["aposta_opcao_id"]]['market'] = utf8_encode($c["aposta_mercado"]);
		$jogos[$c["aposta_opcao_id"]]['win'] = ($c["aposta_status"] == '2') ? '1' : '0';
	}

	// Por fim, percorre combos adicionando jogos
	foreach($ret['combos'] as $k => $v){

		$ret['combos'][$k]['price'] = formataReal($v['price']);
		$ret['combos'][$k]['return'] = formataReal($v['return']);

		foreach ($v['choices'] as $cc) {
			$i = count($ret['combos'][$k]['matches']);
			$ret['combos'][$k]['matches'][$i] = $jogos[$cc];
		}
	}

	usort($ret['combos'], function($a, $b) {
	    return $b['price'] - $a['price'];
	});

	echo json_encode($ret);
?>