<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$type = $_GET["type"];
	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));
	$melhoresVendedores = array();
	$vendasPrejogoAovivo = array();

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }

	// Retorno
	$ret = array();

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_permissoes, usuario_nome FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido. T: '.$_GET["token"]; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Verifica type e permissões
	if(!in_array('18', $perms)){
		$ret['error'] = 'Você não possui permissões suficientes para esta consulta. #'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret);
	}

	// Pesquisa
	$usuarios = array();
	$ret['managers'] = array();

	// Caso haja filtro por usuário
	$user_filtro = "cupom_usuario <> '0' AND ";

	$sql = $mysqli->query("SELECT cupom_aovivo, cupom_valor, cupom_parcial, cupom_codigo, cupom_data, cupom_cliente, cupom_retorno, cupom_usuario, cupom_comissao, cupom_saidas, cupom_situacao FROM cupons WHERE $user_filtro cupom_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY cupom_data DESC");
	$sql2 = $mysqli->query("SELECT * FROM lancamentos WHERE lancamento_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59'");

	// Pesquisa usuários do sistema
	$sql3 = $mysqli->query("SELECT usuario_id, usuario_tipo, usuario_grade, usuario_nome, usuario_gerente FROM usuarios");
	while ($us = $sql3->fetch_assoc()) {
		$usuarios[$us["usuario_id"]]['id'] = utf8_encode($us["usuario_id"]);
		$usuarios[$us["usuario_id"]]['name'] = utf8_encode($us["usuario_nome"]);
		$usuarios[$us["usuario_id"]]['manager'] = utf8_encode($us["usuario_gerente"]);
		if($us["usuario_tipo"] == '4'){
			$ret['managers'][$us["usuario_id"]]['id'] = utf8_encode($us["usuario_id"]);
			$ret['managers'][$us["usuario_id"]]['name'] = utf8_encode($us["usuario_nome"]);
			$ret['managers'][$us["usuario_id"]]['rate'] = utf8_encode($us["usuario_grade"]);
			$ret['managers'][$us["usuario_id"]]['open_entries'] = 0;
			$ret['managers'][$us["usuario_id"]]['entries'] = 0;
			$ret['managers'][$us["usuario_id"]]['cancelled'] = 0;
			$ret['managers'][$us["usuario_id"]]['comissions'] = 0;
			$ret['managers'][$us["usuario_id"]]['comissions_manager'] = 0;
			$ret['managers'][$us["usuario_id"]]['rewards'] = 0;
			$ret['managers'][$us["usuario_id"]]['lanc'] = 0;
			$ret['managers'][$us["usuario_id"]]['total'] = 0;
		}
	}

	if(!$sql){ $ret['error'] = 'Erro de consulta: '.$mysqli->error; $ret['status'] = 'error'; $ret['status_code'] = 'dbExecError'; finishJSONRequest($ret); }


	// Lançamentos
	while ($l = $sql2->fetch_assoc()) {
		if($l["lancamento_tipo"] == 'C'){ $ret['managers'][$usuarios[$l["lancamento_usuario"]]['manager']]['lanc'] += $l["lancamento_valor"]; } else { $ret['managers'][$usuarios[$l["lancamento_usuario"]]['manager']]['lanc'] -= $l["lancamento_valor"]; }
	}

	while ($c = $sql->fetch_assoc()) {

		switch ($c["cupom_situacao"]) {
			case '1':
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['open_entries'] += $c["cupom_valor"];
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['comissions'] += $c["cupom_comissao"];
				break;

			case '2':
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['entries'] += $c["cupom_valor"];
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['rewards'] += $c["cupom_saidas"];
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['comissions'] += $c["cupom_comissao"];
				break;

			case '3':
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['entries'] += $c["cupom_valor"];
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['comissions'] += $c["cupom_comissao"];
				break;

			case '4':
				$ret['managers'][$usuarios[$c["cupom_usuario"]]['manager']]['cancelled'] += $c["cupom_valor"];
				break;

			default:
				# code...
				break;
		}
	}

	foreach ($ret['managers'] as $k => $v) {
		$ret['managers'][$k]['total'] = ($ret['managers'][$k]['entries'] + $ret['managers'][$k]['open_entries']) - ($ret['managers'][$k]['rewards'] + $ret['managers'][$k]['comissions']);

		if($ret['managers'][$k]['total'] > 0){ $ret['managers'][$k]['total_type'] = '+'; }
		elseif($ret['managers'][$k]['total'] == 0){ $ret['managers'][$k]['total_type'] = '0'; }
		else { $ret['managers'][$k]['total_type'] = '-'; }

		// Comissão para o gerente
		$c = 0;
		if($ret['managers'][$k]['total'] > 0){
			$c = $ret['managers'][$k]['total'] / 100;
			$c *= $ret['managers'][$k]['rate'];
			$ret['managers'][$k]['total'] -= $c;
		}

		$ret['managers'][$k]['open_entries'] = formataReal($ret['managers'][$k]['open_entries']);
		$ret['managers'][$k]['entries'] = formataReal($ret['managers'][$k]['entries']);
		$ret['managers'][$k]['cancelled'] = formataReal($ret['managers'][$k]['cancelled']);
		$ret['managers'][$k]['comissions'] = formataReal($ret['managers'][$k]['comissions']);
		$ret['managers'][$k]['comissions_manager'] = formataReal($c);
		$ret['managers'][$k]['rewards'] = formataReal($ret['managers'][$k]['rewards']);
		$ret['managers'][$k]['lanc'] = formataReal($ret['managers'][$k]['lanc']);
		$ret['managers'][$k]['total'] = formataReal($ret['managers'][$k]['total']);
	}

	$ret['dates'] = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;
	echo json_encode($ret);
?>