<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$type = $_GET["type"];
	$tipos_permitidos = array('credit', 'geral', 'oddsChanges', 'matches', 'markets');
	$perms = array();

	############# INFO PARA CONSULTA DE CAIXA #############

	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }
	if(!isset($_GET["type"])){ $type = $domingo; } else { $type = $mysqli->escape_string($_GET["type"]); }

	############# INFO PARA CONSULTA DE CAIXA #############

	// Pesquisa usuários
	$users = array();
	$user_consultor = array(); // Tipo de usuário de quem está consultando a API
	$sql = $mysqli->query("SELECT * FROM usuarios ORDER BY usuario_nome ASC");
	while ($t = $sql->fetch_assoc()) {
		if($t["usuario_api_token"] == $token){
			$user_consultor["id"] = $t["usuario_id"];
			$user_consultor["nome"] = utf8_encode($t["usuario_nome"]);
			$user_consultor["gerente"] = $t["usuario_gerente"];
			$user_consultor["status"] = $t["usuario_status"];
			$user_consultor["tipo"] = $t["usuario_tipo"];
			$user_consultor["credito"] = $t["usuario_credito"];
			$perms = explode('-', $t["usuario_permissoes"]);
		}

		$users[$t["usuario_id"]]["id"] = $t["usuario_id"];
		$users[$t["usuario_id"]]["nome"] = utf8_encode($t["usuario_nome"]);
		$users[$t["usuario_id"]]["gerente"] = $t["usuario_gerente"];
		$users[$t["usuario_id"]]["status"] = $t["usuario_status"];
		$users[$t["usuario_id"]]["credito"] = $t["usuario_credito"];
		$users[$t["usuario_id"]]["tipo"] = $t["usuario_tipo"];
	}

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	if(!in_array('28', $perms)){ $ret['error'] = 'Previlégios insuficientes para visualizar histórico.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerms'; finishJSONRequest($ret); }

	// if(!in_array($type, $tipos_permitidos)){ $ret['error'] = 'Tipo de consulta inválido.'; $ret['status'] = 'error'; $ret['status_code'] = 'wrongType'; finishJSONRequest($ret); }

	// Consulta
	if($type == 'geral'){
		$sql = $mysqli->query("SELECT * FROM historico WHERE hist_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY hist_id DESC");
	} else {
		$sql = $mysqli->query("SELECT * FROM historico WHERE hist_tipo = '$type' AND hist_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY hist_id DESC");
	}

	$ret['history'] = array();
	while ($h = $sql->fetch_assoc()) {
		$i = count($ret['history']);
		$ret['history'][$i]['id'] = $h["hist_id"];
		$ret['history'][$i]['title'] = utf8_encode($h["hist_titulo"]);
		$ret['history'][$i]['type'] = utf8_encode($h["hist_tipo"]);
		$ret['history'][$i]['description'] = utf8_encode($h["hist_descricao"]);
		$ret['history'][$i]['affected_user'] = $users[$h["hist_usuario"]]['nome'];
		$ret['history'][$i]['affected_user_id'] = $h["hist_usuario"];
		$ret['history'][$i]['admin'] = $users[$h["hist_admin"]]['nome'];
		$ret['history'][$i]['admin_id'] = $h["hist_admin"];
		$ret['history'][$i]['date'] = desfazDatetime($h["hist_data"]);
	}

	// Datas
	$ret['success'] = 'Histórico listado com sucesso!';
	$ret['status'] = 'success';
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;

	echo json_encode($ret);
?>