<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	function consultaHierarquia($admin, $user, $users){
		$atualUser = $user;
		while(1 == 1){
			if($users[$atualUser]['gerente'] == '0'){ return false; }
			if($users[$atualUser]['gerente'] == $admin){ return true; }
			$atualUser = $users[$atualUser]['gerente'];
		}
	}

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	if(count($_POST) == 0){ $_POST = $_GET; }
	$token = $_GET["token"];
	if($token == '' && isset($_SESSION["usuario"])){ $_GET["token"] = $_SESSION["usuario"]["api_token"]; $token = $_SESSION["usuario"]["api_token"]; }

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Retorno
	$ret = array();
	$ret['date'] = date('Y-m-d H:i:s');
	$datetime = date('Y-m-d H:i:s');

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_permissoes, usuario_nome, usuario_tipo FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Verifica type e permissões
	if(!in_array('22', $perms) && !in_array('23', $perms)){ $ret['error'] = 'Você não possui permissões suficientes para visualizar a apuração.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Todos os usuários
	$users = array();
	$sql = $mysqli->query("SELECT * FROM usuarios ORDER BY usuario_nome ASC");
	while ($t = $sql->fetch_assoc()) {
		$users[$t["usuario_id"]]["id"] = $t["usuario_id"];
		$users[$t["usuario_id"]]["nome"] = utf8_encode($t["usuario_nome"]);
		$users[$t["usuario_id"]]["gerente"] = $t["usuario_gerente"];
		$users[$t["usuario_id"]]["status"] = $t["usuario_status"];
		$users[$t["usuario_id"]]["credito"] = $t["usuario_credito"];
		$users[$t["usuario_id"]]["tipo"] = $t["usuario_tipo"];
	}

	// RECEBE VARIÁVEIS
	$ret['dates'] = $_POST["date"].' a '.$_POST["enddate"];
	$status = $_POST["status"];
	$date = explode('/', $mysqli->escape_string($_POST["date"]));
	$enddate = explode('/', $mysqli->escape_string($_POST["enddate"]));
	$date = $date[2].'-'.$date[1].'-'.$date[0];
	$enddate = $enddate[2].'-'.$enddate[1].'-'.$enddate[0];
	$level2 = $mysqli->escape_string($_POST["level2"]);
	$level3 = $mysqli->escape_string($_POST["level3"]);
	$level4 = $mysqli->escape_string($_POST["level4"]);
	$usuarioBase = $userid;
	$usuario_selecionado = 0;
	if((int)$level2 <> '0'){ $usuario_selecionado = 1; $usuarioBase = $level2; }
	if((int)$level3 <> '0'){ $usuario_selecionado = 1; $usuarioBase = $level3; }
	if((int)$level4 <> '0'){ $usuario_selecionado = 1; $usuarioBase = $level4; }

	if($usuarioBase <> $userid){ $ret['dates'] = $users[$usuarioBase]['nome'].' | '.$ret['dates']; }

	// Inicia arrays
	$lv2 = array();
	$lv3 = array();
	$lv4 = array();
	$hierarquia = array();

	// Tipos de usuários
	$usuariosPesquisa = array($usuarioBase); // Usuários que fazem parte da pesquisa

	if($usuario_selecionado == '1' || $u["usuario_tipo"] <> '1'){
		$sql = $mysqli->query("SELECT t1.usuario_id AS lev1, t2.usuario_id as lev2, t3.usuario_id as lev3, t4.usuario_id as lev4 FROM usuarios AS t1 LEFT JOIN usuarios AS t2 ON t2.usuario_gerente = t1.usuario_id LEFT JOIN usuarios AS t3 ON t3.usuario_gerente = t2.usuario_id LEFT JOIN usuarios AS t4 ON t4.usuario_gerente = t3.usuario_id WHERE t1.usuario_id = '$usuarioBase'");
	} else {
		$sql = $mysqli->query("SELECT t1.usuario_id AS lev1, t2.usuario_id as lev2, t3.usuario_id as lev3, t4.usuario_id as lev4 FROM usuarios AS t1 LEFT JOIN usuarios AS t2 ON t2.usuario_gerente = t1.usuario_id LEFT JOIN usuarios AS t3 ON t3.usuario_gerente = t2.usuario_id LEFT JOIN usuarios AS t4 ON t4.usuario_gerente = t3.usuario_id");
	}
	while($i = $sql->fetch_assoc()){

		// Para caso de administradores
		if($usuario_selecionado == '0'){
			$i['lev4'] = $i['lev3'];
			$i['lev3'] = $i['lev2'];
			$i['lev2'] = $i['lev1'];
		}

		// Hierarquias
		if(!isset($hierarquia[$usuarioBase])){ $hierarquia[$usuarioBase] = array(); }
		if(!isset($hierarquia[$i["lev2"]])){ $hierarquia[$i["lev2"]] = array(); }
		if(!isset($hierarquia[$i["lev3"]])){ $hierarquia[$i["lev3"]] = array(); }

		if((int)$i["lev2"] <> 0 && !in_array($i["lev2"], $usuariosPesquisa)){
			array_push($usuariosPesquisa, $i["lev2"]);
			array_push($lv2, $i["lev2"]);

			// Hierarquias
			$hierarquia[$usuarioBase][] = $i["lev2"];
		}

		if((int)$i["lev3"] <> 0 && !in_array($i["lev3"], $usuariosPesquisa)){
			array_push($usuariosPesquisa, $i["lev3"]);
			array_push($lv3, $i["lev3"]);

			// Hierarquias
			$hierarquia[$usuarioBase][] = $i["lev3"];
			$hierarquia[$i["lev2"]][] = $i["lev3"];
		}

		if((int)$i["lev4"] <> 0 && !in_array($i["lev4"], $usuariosPesquisa)){
			array_push($usuariosPesquisa, $i["lev4"]);
			array_push($lv4, $i["lev4"]);

			// Hierarquias
			$hierarquia[$usuarioBase][] = $i["lev4"];
			$hierarquia[$i["lev2"]][] = $i["lev4"];
			$hierarquia[$i["lev3"]][] = $i["lev4"];
		}
	}

	// Bloqueia caso consulta seja a usuário não gerenciado
	if($usuarioBase <> $userid && !consultaHierarquia($userid, $usuarioBase, $users) && $u["usuario_tipo"] <> '1'){ $ret['error'] = 'Este usuário não faz parte do seu gerenciamento.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Faz pesquisa
	$status = join("','", $status);
	$usuariosPesquisa = join("','", $usuariosPesquisa);

	if($u["usuario_tipo"] == '1' && $usuario_selecionado == 0){
		$sql = $mysqli->query("SELECT cupom_valor, cupom_parcial, cupom_situacao, cupom_saidas, cupom_data, cupom_codigo, cupom_comissao, cupom_aovivo, cupom_cliente, cupom_usuario FROM cupons WHERE cupom_situacao IN('$status') and cupom_data BETWEEN '$date 00:00:00' and '$enddate 23:59:59'");
	} else {
		$sql = $mysqli->query("SELECT cupom_valor, cupom_parcial, cupom_situacao, cupom_saidas, cupom_data, cupom_codigo, cupom_comissao, cupom_aovivo, cupom_cliente, cupom_usuario FROM cupons WHERE cupom_situacao IN('$status') and cupom_usuario IN('$usuariosPesquisa') and cupom_data BETWEEN '$date 00:00:00' and '$enddate 23:59:59'");
	}

	$ret['qtd'] = mysqli_num_rows($sql);
	$ret['total']['open_entries'] = 0;
	$ret['total']['entries'] = 0;
	$ret['total']['rewards'] = 0;
	$ret['total']['cancelled'] = 0;
	$ret['total']['comissions'] = 0;
	$ret['total']['total'] = 0;

	while ($b = $sql->fetch_assoc()) {
		if($b["cupom_usuario"] == '0'){ continue; }
		if(!isset($ret['byUser'][$b["cupom_usuario"]])){
			$ret['byUser'][$b["cupom_usuario"]]['id'] = $b["cupom_usuario"];
			$ret['byUser'][$b["cupom_usuario"]]['name'] = $users[$b["cupom_usuario"]]['nome'];
			$ret['byUser'][$b["cupom_usuario"]]['id_manager'] = $users[$b["cupom_usuario"]]['gerente'];
			$ret['byUser'][$b["cupom_usuario"]]['name_manager'] = $users[$users[$b["cupom_usuario"]]['gerente']]['nome'];
			$ret['byUser'][$b["cupom_usuario"]]['open_entries'] = 0;
			$ret['byUser'][$b["cupom_usuario"]]['entries'] = 0;
			$ret['byUser'][$b["cupom_usuario"]]['rewards'] = 0;
			$ret['byUser'][$b["cupom_usuario"]]['cancelled'] = 0;
			$ret['byUser'][$b["cupom_usuario"]]['comissions'] = 0;
			$ret['byUser'][$b["cupom_usuario"]]['total'] = 0;
		}
		switch ($b["cupom_situacao"]) {
			case '1':
				$ret['total']['open_entries'] += $b["cupom_valor"];
				$ret['byUser'][$b["cupom_usuario"]]['open_entries'] += $b["cupom_valor"];
				// $ret['total']['comissions'] += $b["cupom_comissao"];
				break;

			case '2':
				$ret['total']['entries'] += $b["cupom_valor"];
				$ret['total']['rewards'] += $b["cupom_saidas"];
				$ret['total']['comissions'] += $b["cupom_comissao"];
				$ret['byUser'][$b["cupom_usuario"]]['entries'] += $b["cupom_valor"];
				$ret['byUser'][$b["cupom_usuario"]]['rewards'] += $b["cupom_saidas"];
				$ret['byUser'][$b["cupom_usuario"]]['comissions'] += $b["cupom_comissao"];
				break;

			case '3':
				$ret['total']['entries'] += $b["cupom_valor"];
				$ret['total']['comissions'] += $b["cupom_comissao"];
				$ret['byUser'][$b["cupom_usuario"]]['entries'] += $b["cupom_valor"];
				$ret['byUser'][$b["cupom_usuario"]]['comissions'] += $b["cupom_comissao"];
				break;

			case '4':
				$ret['total']['cancelled'] += $b["cupom_valor"];
				$ret['byUser'][$b["cupom_usuario"]]['cancelled'] += $b["cupom_valor"];
				break;

			default:
				# code...
				break;
		}

		$ret['coupons'][$c["cupom_codigo"]]['code'] = ($b["cupom_codigo"]);
		$ret['coupons'][$b["cupom_codigo"]]['date'] = desfazDatetime($b["cupom_data"]);
		$ret['coupons'][$b["cupom_codigo"]]['client'] = utf8_encode($b["cupom_cliente"]);
		$ret['coupons'][$b["cupom_codigo"]]['seller'] = utf8_encode($users[$b["cupom_usuario"]]['nome']);
		$ret['coupons'][$b["cupom_codigo"]]['price'] = formataReal($b["cupom_valor"]);
		$ret['coupons'][$b["cupom_codigo"]]['return'] = formataReal($b["cupom_retorno"]);
		$ret['coupons'][$b["cupom_codigo"]]['rewards'] = formataReal($b["cupom_saidas"]);
		$ret['coupons'][$b["cupom_codigo"]]['status'] = ($b["cupom_situacao"]);
		if($b["cupom_situacao"] == '1' && $b["cupom_parcial"] == '1'){ $ret['coupons'][$b["cupom_codigo"]]['status'] = '11'; }
	}

	// Total
	$ret['total']['total'] += (($ret['total']['entries']) - ($ret['total']['rewards'] + $ret['total']['comissions']));

	// Formata
	$ret['total']['open_entries'] = formataReal($ret['total']['open_entries']);
	$ret['total']['entries'] = formataReal($ret['total']['entries']);
	$ret['total']['rewards'] = formataReal($ret['total']['rewards']);
	$ret['total']['cancelled'] = formataReal($ret['total']['cancelled']);
	$ret['total']['comissions'] = formataReal($ret['total']['comissions']);
	$ret['total']['total'] = formataReal($ret['total']['total']);


	// Adiciona valores vindos da hierarquia
	foreach ($hierarquia as $k => $h2) {
		if(count($h2) == 0){ continue; }
		foreach ($h2 as $h) {
			if(!isset($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k])){
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['id'] = $k;
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['name'] = $users[$k]['nome'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['id_manager'] = $users[$k]['gerente'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['name_manager'] = $users[$users[$k]['gerente']]['nome'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['open_entries'] = $ret['byUser'][$k]['open_entries'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['entries'] = $ret['byUser'][$k]['entries'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['rewards'] = $ret['byUser'][$k]['rewards'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['cancelled'] = $ret['byUser'][$k]['cancelled'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['comissions'] = $ret['byUser'][$k]['comissions'];
				$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['total'] = (($ret['byUser'][$k]['entries']) - ($ret['byUser'][$k]['rewards'] + $ret['byUser'][$k]['comissions']));
			}

			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['open_entries'] += ($ret['byUser'][$h]['open_entries']);
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['entries'] += ($ret['byUser'][$h]['entries']);
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['rewards'] += ($ret['byUser'][$h]['rewards']);
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['cancelled'] += ($ret['byUser'][$h]['cancelled']);
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['comissions'] += ($ret['byUser'][$h]['comissions']);
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['total'] += (($ret['byUser'][$h]['entries']) - ($ret['byUser'][$h]['rewards'] + $ret['byUser'][$h]['comissions']));
		}

		// Correção BUG
		if($k == $userid){
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['open_entries'] /= 2;
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['entries'] /= 2;
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['rewards'] /= 2;
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['cancelled'] /= 2;
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['comissions'] /= 2;
			$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['total'] /= 2;
		}

		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['open_entries'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['open_entries']);
		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['entries'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['entries']);
		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['rewards'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['rewards']);
		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['cancelled'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['cancelled']);
		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['comissions'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['comissions']);
		$ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['total'] = formataReal($ret['byManager'][$_SESSION["tipos_usuarios"][$users[$k]['tipo']]['nome']][$k]['total']);
	}

	foreach ($ret['byUser'] as $k => $v) {
		$ret['byUser'][$k]['total'] += (($ret['byUser'][$k]['entries']) - ($ret['byUser'][$k]['rewards'] + $ret['byUser'][$k]['comissions']));
		$ret['byUser'][$k]['open_entries'] = formataReal($ret['byUser'][$k]['open_entries']);
		$ret['byUser'][$k]['entries'] = formataReal($ret['byUser'][$k]['entries']);
		$ret['byUser'][$k]['rewards'] = formataReal($ret['byUser'][$k]['rewards']);
		$ret['byUser'][$k]['cancelled'] = formataReal($ret['byUser'][$k]['cancelled']);
		$ret['byUser'][$k]['comissions'] = formataReal($ret['byUser'][$k]['comissions']);
		$ret['byUser'][$k]['balance_type'] = ($ret['byUser'][$k]['total'] <= 0) ? '-' : '+';
		$ret['byUser'][$k]['total'] = formataReal($ret['byUser'][$k]['total']);
	}

	if(isset($ret['byManager']['Administradores'])){ unset($ret['byManager']['Administradores']); }
	$ret['status'] = 'success';
	$ret['success'] = 'Pronto!';

	if($_POST["includeCoupons"] <> 'on' && $_POST["includeCoupons"] <> '1'){ unset($ret['coupons']); }

	$_SESSION["apuracao"] = json_encode($ret);
	echo json_encode($ret);
?>