<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$perms = array();
	$userid = 0;

	// Pesquisa usuários
	$users = array();
	$user_consultor = array(); // Tipo de usuário de quem está consultando a API
	$sql = $mysqli->query("SELECT * FROM usuarios ORDER BY usuario_nome ASC");
	while ($t = $sql->fetch_assoc()) {
		if($t["usuario_api_token"] == $token){
			$user_consultor["id"] = $t["usuario_id"];
			$user_consultor["nome"] = utf8_encode($t["usuario_nome"]);
			$user_consultor["gerente"] = $t["usuario_gerente"];
			$user_consultor["status"] = $t["usuario_status"];
			$user_consultor["tipo"] = $t["usuario_tipo"];
			$user_consultor["credito"] = $t["usuario_credito"];
			$perms = explode('-', $t["usuario_permissoes"]);
			$userid = $t["usuario_id"];
		}

		$users[$t["usuario_id"]]["id"] = $t["usuario_id"];
		$users[$t["usuario_id"]]["nome"] = utf8_encode($t["usuario_nome"]);
		$users[$t["usuario_id"]]["gerente"] = $t["usuario_gerente"];
		$users[$t["usuario_id"]]["status"] = $t["usuario_status"];
		$users[$t["usuario_id"]]["credito"] = $t["usuario_credito"];
		$users[$t["usuario_id"]]["tipo"] = $t["usuario_tipo"];
		$users[$t["usuario_id"]]["permissoes"] = explode('-', $t["usuario_permissoes"]);
	}

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Confere se possui permissões
	if(!in_array('31', $perms) && !in_array('30', $perms)){ $ret['error'] = 'Você não possui permissões suficientes para ver o histórico de prestações de contas.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Consulta
	if(in_array('31', $perms)){
		$sql = $mysqli->query("SELECT * FROM contas ORDER BY conta_id DESC LIMIT 600");
	} else {
		$sql = $mysqli->query("SELECT * FROM contas WHERE conta_prestador = '$userid' ORDER BY conta_id DESC LIMIT 600");
	}

	// Percorre caixas e atribui aos usuários
	while ($conta = $sql->fetch_assoc()) {
		$k = count($ret['items']);
		$ret['items'][$k]['entries'] = formataReal($conta["conta_entradas"]);
		$ret['items'][$k]['comissions'] = formataReal($conta["conta_comissoes"]);
		$ret['items'][$k]['rewards'] = formataReal($conta["conta_saidas"]);
		$ret['items'][$k]['lanc'] = formataReal($conta["conta_lancamentos"]);
		$ret['items'][$k]['balance'] = formataReal($conta["conta_total"]);
		$ret['items'][$k]['balance_type'] = ((int)$conta["conta_total"] < 0) ? '-' : '+';
		$ret['items'][$k]['date'] = ($conta["conta_periodo"]);
		$ret['items'][$k]['admin'] = $users[$conta["conta_prestador"]]["nome"];
		$ret['items'][$k]['admin_id'] = $conta["conta_prestador"];
		$ret['items'][$k]['user'] = $users[$conta["conta_usuario"]]["nome"];
		$ret['items'][$k]['user_id'] = $conta["conta_usuario"];
	}

	// Datas
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;

	echo json_encode($ret);
?>