<?php
	// ini_set('display_errors',1);
    // ini_set('display_startup_erros',1);
    // error_reporting(E_ALL ^ E_NOTICE);

	// Arquivo de conexão
	require $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	require $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';

	// Recebe variáveis
	if(!isset($_SESSION["apostas"]) && isset($_POST["apostas"])){ $_SESSION["apostas"] = $_POST["apostas"]; }
	$datetime = date('Y-m-d H:i:s');
	$userid = $_SESSION["usuario"]["id"];
	$valor = $mysqli->escape_string($_POST["valor"]); // Formato: XX.XXX,XX
	$valorEmCentavos = realToCents($valor);
	$cliente = $mysqli->escape_string(utf8_decode($_POST["cliente"]));
	$qtd = count($_SESSION["apostas"]);
	$userid = $_SESSION["usuario"]["id"];
	$usertipo = $_SESSION["usuario"]["tipo"];
	$userpermissoes = $_SESSION["usuario"]["permissoes"]; // Array (necessário ter permissão 3 para efetuar apostas)
	$cfg = $_SESSION["configs"];
	$cotacao_total = 0;
	$mqueries = '';
	$cupom_codigo = geraToken(8, true, true);
	$cupom_codigo = substr(sha1($userid.strtotime(date('Y-m-d H:i:s'))), 0, 8);
	$choices = array();
	$matches = array();
	$simulador = 0;
	$isLive = 0;

	if(!isset($_SESSION["usuario"]["id"])){
		$cupom_codigo = 'PIN'.substr($cupom_codigo, 1);
		$simulador = 1;
		$userid = 0;
		$usertipo = 3;
		$userpermissoes = array('3');
		$_SESSION["usuario"]["min_jogos"] = 1;
		$_SESSION["usuario"]["aposta_minima"] = 200; // 2,00
		$_SESSION["usuario"]["aposta_maxima"] = 20000000; // 200.000,00
		$_SESSION["usuario"]["credito"] = 5000000; // 50.000,00
		$_SESSION["usuario"]["limite_simples"] = 500000000; // 5.000.000,00
		$_SESSION["usuario"]["limite_duplas"] = 500000000; // 5.000.000,00
		$_SESSION["usuario"]["limite_geral"] = 500000000; // 5.000.000,00
	} else {
		// Se não é SIMULADOR, atualiza crédito
		$sql = $mysqli->query("SELECT usuario_credito FROM usuarios WHERE usuario_id = '$userid'");
		$uc = $sql->fetch_assoc();
		$_SESSION["usuario"]["credito"] = $uc["usuario_credito"];
	}



	################################################### VERIFICAÇÕES ###################################################

	// Verifica se usuário está bloqueado
	if($_SESSION["usuario"]["status"] == '0'){ setErrorAJAX('Você está bloqueado e não pode efetuar apostas.'); exit; }

	// Confere quantidade de apostas
	if($qtd > $cfg['config_max_apostas']){ setErrorAJAX('Você só pode adicionar até '.$cfg['config_max_apostas'].' jogos por bilhete.'); exit; }

	// Verifica se há apostas no bilhete
	if($qtd == 0){ setErrorAJAX('Você não pode finalizar um bilhete sem nenhuma partida.'); exit; }

	// Verifica se usuário não é gerente ou supervisor
	if(!in_array('3', $userpermissoes)){ setErrorAJAX('Você não tem permissões para efetuar apostas.'); exit; }

	// Verifica se valor está vazio
	if($valor == ''){ setErrorAJAX('Você precisa mencionar um valor para sua aposta.'); exit; }

	// Verifica se usuário adicionou o mínimo de jogos [TABELA USUARIOS]
	if(isset($_SESSION["usuario"]["min_jogos"]) && $qtd < $_SESSION["usuario"]["min_jogos"]){ setErrorAJAX('Você precisa adicionar pelo menos '.$_SESSION["usuario"]["min_jogos"].' jogos para finalizar.'); exit; }

	// Verifica se usuário adicionou o mínimo de jogos [TABELA CONFIGS]
	if(!isset($_SESSION["usuario"]["min_jogos"]) && $qtd < (int)$cfg["config_min_jogos"]){ setErrorAJAX('Para finalizar esta aposta, você precisa adicionar pelo menos '.$_SESSION["usuario"]["min_jogos"].' jogos.'); exit; }

	// Confere se nome do cliente é obrigatório. Caso seja, confere se foi informado.
	if((int)$cfg["config_exigir_nome_cliente"] == '1' && ($cliente == '' || $cliente == ' ')){ setErrorAJAX('Você precisa informar o nome do cliente.'); exit; }

	// Confere se usuário pode efetuar vendas com esse valor
	if($valorEmCentavos < realToCents($_SESSION["usuario"]["aposta_minima"])){ setErrorAJAX('O menor valor permitido para apostas é de R$'.formataReal($_SESSION["usuario"]["aposta_minima"])); exit; }
	if($valorEmCentavos > realToCents($_SESSION["usuario"]["aposta_maxima"])){ setErrorAJAX('O maior valor permitido para apostas é de R$'.formataReal($_SESSION["usuario"]["aposta_maxima"])); exit; }
	if($valorEmCentavos > ($_SESSION["usuario"]["credito"])){ setErrorAJAX('Créditos insuficientes. Você só possui R$'.formataReal($_SESSION["usuario"]["credito"])); exit; }

	// Confere limite diário
	$date = date('Y-m-d');
	$lims['simples'] = 0;
	$lims['duplas'] = 0;
	$lims['total'] = 0;
	$sql = $mysqli->query("SELECT sum(cupom_valor) as valor, cupom_jogos FROM `cupons` WHERE cupom_usuario = '$userid' and cupom_data >= '$date 00:00:00' GROUP BY cupom_jogos");
	while ($l = $sql->fetch_assoc()) {
		if($l["cupom_jogos"] == '1'){ $lims['simples'] += $l["valor"]; }
		elseif($l["cupom_jogos"] == '2'){ $lims['duplas'] += $l["valor"]; }
		$lims['total'] += $l["valor"];
	}

	// Confere limite simples
	if(($lims['simples'] + $valorEmCentavos) > $_SESSION["usuario"]["limite_simples"] && $qtd == '1' && $_SESSION["usuario"]["limite_simples"] <> ''){ setErrorAJAX('Você esgotou seu limite DIÁRIO de R$'.formataReal($_SESSION["usuario"]["limite_simples"]).' para apostas simples.'); exit; }

	// Confere limite duplas
	elseif(($lims['duplas'] + $valorEmCentavos) > $_SESSION["usuario"]["limite_duplas"] && $qtd == '2' && $_SESSION["usuario"]["limite_duplas"] <> ''){ setErrorAJAX('Você esgotou seu limite DIÁRIO de R$'.formataReal($_SESSION["usuario"]["limite_duplas"]).' para apostas duplas.'); exit; }

	// Confere limite duplas
	elseif(($lims['total'] + $valorEmCentavos) > $_SESSION["usuario"]["limite_geral"] && $_SESSION["usuario"]["limite_geral"] <> ''){ setErrorAJAX('Você esgotou seu limite DIÁRIO de R$'.formataReal($_SESSION["usuario"]["limite_geral"]).' para apostas.'); exit; }


	// Consulta disponibilidade da partida
	include $_SERVER["DOCUMENT_ROOT"].'/views/ajax/consultarDisponibilidadeJogo.php';

	// Verifica cotações, em caso de ao vivo
	include $_SERVER["DOCUMENT_ROOT"].'/views/ajax/verificaCotacoes.php';


	###################################################### MAXBET ######################################################

	// Consulta maxbets
	$maxbet = array();
	$maxprice = array();
	$queries_limites = '';
	$sql = $mysqli->query("SELECT * FROM limites ORDER BY lim_id DESC LIMIT 600");
	while ($reg = $sql->fetch_assoc()) {
		$limid = $ret["lim_id"];
		if($reg["lim_maxbet"] <> ''){ $maxbet[$reg["lim_jogo_id"]] = $reg["lim_maxbet"]; }
		if($reg["lim_maxprice"] <> ''){
			$tapostado = (int)$reg["lim_apostado"];
			$tapostado += $valorEmCentavos;
			if($tapostado > $reg["lim_maxprice"]){ $maxprice[utf8_encode($reg["lim_jogo_id"])] = 0; }
			else {
				$maxprice[utf8_encode($reg["lim_jogo_id"])] = 1;
			}
		}
	}

	###################################################### /MAXBET #####################################################

	// Confere cotações
	foreach ($_SESSION["apostas"] as $mid => $a) {
		if($qtd == 1 && $a["aposta_cotacao"] < $cfg["config_ct_minima_simples"]){ setErrorAJAX('A menor cotação permitida para apostas simples é de '.$cfg["config_ct_minima_simples"]); exit; }
		elseif($qtd > 1 && $a["aposta_cotacao"] < $cfg["config_ct_minima_multipla"]){ setErrorAJAX('A menor cotação permitida para apostas múltiplas é de '.$cfg["config_ct_minima_multipla"]); exit; }

		// Verifica se é ao vivo
		if($a["codigo_aposta"] == 'aovivo'){ $isLive = 1; }

		// Adiciona à cotação total
		if($cotacao_total == '0'){ $cotacao_total = $a["aposta_cotacao"]; }
		else { $cotacao_total *= $a["aposta_cotacao"]; }

		// Confere maxbet
		if(isset($maxbet[$mid]) && $valorEmCentavos > $maxbet[$mid]){ setErrorAJAX('O maior valor permitido para apostas na partida '.$a["aposta_jogo_nome"].' é de R$'.formataReal($maxbet[$mid])); exit; }
		elseif(isset($maxbet[$a["aposta_campeonato"]]) && $valorEmCentavos > $maxbet[$a["aposta_campeonato"]]){ setErrorAJAX('O maior valor permitido para apostas no campeonato '.$a["aposta_campeonato"].' é de R$'.formataReal($maxbet[$a["aposta_campeonato"]])); exit; }

		// Confere maxprice
		if(isset($maxprice[$mid]) && $maxprice[$mid] == '0'){ setErrorAJAX('Limite de apostas atingido para a partida '.$a["aposta_jogo_nome"]); exit; }
		elseif(isset($maxprice[$a["aposta_campeonato"]]) && $maxprice[$a["aposta_campeonato"]] == '0'){ setErrorAJAX('Limite de apostas atingido para o campeonato '.$a["aposta_campeonato"]); exit; }

		// Incrementa limits
		$ac = utf8_decode($a["aposta_campeonato"]);
		$queries_limites .= "UPDATE limites SET lim_apostado = (lim_apostado + $valorEmCentavos) WHERE lim_jogo_id = '$mid'; ";
		$queries_limites .= "UPDATE limites SET lim_apostado = (lim_apostado + $valorEmCentavos) WHERE lim_jogo_id = '$ac'; ";

		// Adiciona incremento de opções apostadas
		extract ($a, EXTR_OVERWRITE, "wddx");

		// Trata variáveis
		$aposta_jogo_nome = utf8_decode($aposta_jogo_nome);
		$aposta_campeonato = utf8_decode($aposta_campeonato);
		$aposta_nome_aposta = utf8_decode($aposta_nome_aposta);
		$aposta_opcao = utf8_decode($aposta_opcao);
		$aposta_choice_id = $a["aposta_token"];

		$mqueries .= "INSERT INTO opcoes_apostadas SET oa_match = '$mid', oa_match_name = '$aposta_jogo_nome', oa_valor = '$valorEmCentavos', oa_bet_name = '$aposta_nome_aposta', oa_choice = '$aposta_token', oa_choice_name = '$aposta_opcao', oa_bilhetes = concat(oa_bilhetes, '-', '$cupom_codigo'), oa_notificado = '0' ON DUPLICATE KEY UPDATE oa_valor = (oa_valor + $valorEmCentavos), oa_bilhetes = concat(oa_bilhetes, '-', '$cupom_codigo'); INSERT INTO apostas SET aposta_cupom = '$cupom_codigo', aposta_jogo_nome = '$aposta_jogo_nome', aposta_jogo_id = '$aposta_match_id', aposta_usuario = '$userid', aposta_data_jogo = '$aposta_data_jogo', aposta_data = '$datetime', aposta_status = '1', aposta_codigo = '$codigo_aposta', aposta_campeonato = '$aposta_campeonato', aposta_mercado = '$aposta_nome_aposta', aposta_opcao = '$aposta_opcao', aposta_opcao_id = '$aposta_choice_id', aposta_cotacao = '$aposta_cotacao'; ";

		// Adiciona contagem de choices e matches
		array_push($matches, $mid);
		array_push($choices, $aposta_token);
	}

	// Confere se cotação total (para multiplas) foi suprida
	if($cfg["config_menor_multiplicador_bilhete"] <> '' && $cotacao_total < $cfg["config_menor_multiplicador_bilhete"] && $qtd > 1){ setErrorAJAX('A cotação mínima para um bilhete com mais de 1 jogo é de '.$cfg["config_menor_multiplicador_bilhete"]); exit; }

	// Confere se cotação total é maior que multiplicador permitido
	if($cotacao_total > $cfg["config_multiplicador"] && $cfg["config_atingiu_maximo"] == '0'){ setErrorAJAX('A maior cotação permitida por bilhete é de '.$cfg["config_multiplicador"].'x.'); exit; }

	################################################### /VERIFICAÇÕES ##################################################


	##################################################### COMISSÕES ####################################################

	// Define co'''missão
	if((int)$_SESSION["usuario"]["grade"] <> '0'){
		$grade = (int)$_SESSION["usuario"]["grade"];
		$comissao = '0';

		$sql_grade = $mysqli->query("SELECT * FROM opcoes_grade
		LEFT JOIN grades ON grades.grade_id = opcoes_grade.og_grade
		WHERE og_grade = '$grade' and '$qtd' >= og_minimo and '$qtd' <= og_maximo");
		if(mysqli_num_rows($sql_grade) > 0){
			$gr = $sql_grade->fetch_assoc();

			if($cotacao_total >= (int)$gr["grade_odd_minima"]){
				$comissao = ($valorEmCentavos / 100) * $gr["og_comissao"];
			}
			else {
				$comissao = 0;
			}
		}
	}
	else {
		$comissao = 0;
	}

	##################################################### /COMISSÕES ####################################################

	// Adiciona cupom ao banco de dados
	$retorno = $valorEmCentavos * $cotacao_total;
	$choices = implode('-', $choices);
	$matches = implode('-', $matches);
	$mqueries .= "INSERT INTO cupons SET cupom_aovivo = '$isLive', cupom_codigo = '$cupom_codigo', cupom_usuario = '$userid', cupom_cliente = '$cliente', cupom_valor = '$valorEmCentavos', cupom_retorno = '$retorno', cupom_jogos = '$qtd', cupom_data = '$datetime', cupom_comissao = '$comissao', cupom_matches = '$matches', cupom_choices = '$choices'; ";

	// Por fim, remove saldo
	$mqueries .= "UPDATE usuarios SET usuario_credito = (usuario_credito - $valorEmCentavos) WHERE usuario_id = '$userid'; ";

	// Por fim, cadastra tudo no banco
	$mqueries .= $queries_limites;
	$sqlmulti = mysqli_multi_query($mysqli, $mqueries);
	if($sqlmulti){
		$ret = array();
		$ret['status'] = 1;
		$ret['codigo'] = strtoupper($cupom_codigo);
		$_SESSION["usuario"]["credito"] -= $valorEmCentavos;
		$ret['credito'] = formataReal($_SESSION["usuario"]["credito"] - $valorEmCentavos);
		$_SESSION["apostas"] = array();
		if($simulador == '1'){ unset($_SESSION["usuario"]); }
		echo json_encode($ret);
	}
	else {
		if($mysqli->error == 'Query was empty'){
			setErrorAJAX('Houve um erro ao finalizar seu bilhete. Por favor, entre em contato com o atendimento.');
		}
		else {
			setErrorAJAX('Houve um erro ao finalizar seu bilhete. Por favor, entre em contato com o atendimento. Erro: '.$mysqli->error);
		}
	}

?>