<?php
	require $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
    require $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';

	// Recebe parâmetros GET
	$datetime = date('Y-m-d H:i:s');
	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$userid = 0;
	if(isset($_SESSION["usuario"]["api_token"])){ $_GET["token"] = $_SESSION["usuario"]["api_token"]; }
	if(isset($_SESSION["usuario"]["id"])){ $userid = $_SESSION["usuario"]["id"]; }
	$token = $_GET["token"];
	$user = $_GET["user"];
	$balance = $_GET["balance"];

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtoken'; finishJSONRequest($ret); }
	if($token == ''){ $ret['error'] = 'Efetue login em sua conta primeiramente.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtoken'; finishJSONRequest($ret); }

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_credito, usuario_permissoes, usuario_nome, usuario_tipo FROM usuarios WHERE usuario_api_token = '$token' OR usuario_id = '$user'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$users = array();
	$perms = array();
	while($u = $sql->fetch_assoc()){
		$users[$u["usuario_id"]]['id'] = $u["usuario_id"];
		$users[$u["usuario_id"]]['nome'] = utf8_encode($u["usuario_nome"]);
		$users[$u["usuario_id"]]['credito'] = $u["usuario_credito"];
		$users[$u["usuario_id"]]['tipo'] = $u["usuario_tipo"];
		$users[$u["usuario_id"]]['gerente'] = $u["usuario_gerente"];
		$users[$u["usuario_id"]]['permissoes'] = explode('-', $u["usuario_permissoes"]);

		// ID de quem está cadastrando
		if($u["usuario_id"] <> $user){
			$userid = $u["usuario_id"];
			$perms = $users[$u["usuario_id"]]['permissoes'];
		}
	}

	// Confere se possui permissões
	if(!in_array('26', $perms) && (!in_array('27', $perms) || (getHierarquia($userid, $users[$user]['id'], $_SESSION['users']) == false))){ $ret['error'] = 'Você não possui permissões suficientes para adicionar saldo.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Atualiza saldo
	$balance = str_replace('.', '', $balance);
	$balance = str_replace(',', '', $balance);
	$sql = $mysqli->query("UPDATE usuarios SET usuario_credito = '$balance' WHERE usuario_id = '$user'");
	if(!$sql){
		$ret['error'] = 'Houve um erro ao alterar saldo. O sistema retornou: '.$mysqli->error.'.'; $ret['status'] = 'error'; $ret['status_code'] = 'databaseError'; finishJSONRequest($ret);
	}

	// Adiciona ao histórico
	$titulo = utf8_decode('Crédito de '.$users[$user]['nome'].' (#'.$users[$user]['id'].') alterado de R$'.formataReal($users[$user]['credito']).' para R$'.formataReal($balance).' por '.$users[$userid]['nome'].' (#'.$users[$userid]['id'].')');
	$descricao = utf8_decode('Crédito de '.$users[$user]['nome'].' (#'.$users[$user]['id'].') alterado de R$'.formataReal($users[$user]['credito']).' para R$'.formataReal($balance).' por '.$users[$userid]['nome'].' (#'.$users[$userid]['id'].')');
	$sql = $mysqli->query("INSERT INTO historico SET hist_tipo = 'credit', hist_titulo = '$titulo', hist_descricao = '$descricao', hist_usuario = '$user', hist_admin = '$userid', hist_data = '$datetime'");

	$ret['success'] = 'Pronto! Alterado com sucesso.';
	$ret['status'] = 'success';
	$ret['new_balance'] = $balance;
	$ret['user'] = $user;
	finishJSONRequest($ret);
?>