<?php
	// Tenta se conectar ao servidor MySQL
	include $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
	include $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';
	$cfg = $_SESSION["configs"];

	// ini_set('display_errors',1);
	// ini_set('display_startup_erros',1);
	// error_reporting(E_ALL);

	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$type = $_GET["type"];
	$prox_segunda = date('Y-m-d', strtotime('next Monday'));
	$segunda = date('Y-m-d', strtotime('-7 days', strtotime($prox_segunda)));
	$domingo = date('Y-m-d', strtotime('-1 day', strtotime($prox_segunda)));
	$melhoresVendedores = array();
	$vendasPrejogoAovivo = array();
	$multiplicador = $cfg['config_multiplicador'];
	$limite_premio = $cfg['config_max_ganhos_reais'];

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Datas
	if(!isset($_GET["date"])){ $date = $segunda; } else { $date = $mysqli->escape_string($_GET["date"]); }
	if(!isset($_GET["enddate"])){ $enddate = $domingo; } else { $enddate = $mysqli->escape_string($_GET["enddate"]); }
	if(!isset($_GET["type"])){ $type = $domingo; } else { $type = $mysqli->escape_string($_GET["type"]); }

	// Retorno
	$ret = array();
	$tipos_permitidos = array('personal' => 21, 'general' => 24);

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_permissoes, usuario_nome FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Verifica type e permissões
	if(!isset($_GET["type"])){ $ret['error'] = 'Tipo de consulta não especificado.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }
	if(isset($_GET["type"]) && !isset($tipos_permitidos[$type])){ $ret['error'] = 'Tipo de consulta inválido.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidType'; finishJSONRequest($ret); }
	if(count($perms) == 0 || (isset($tipos_permitidos[$type]) && !in_array($tipos_permitidos[$type], $perms))){
		if(!in_array('17', $perms)){
			$ret['error'] = 'Você não possui permissões suficientes para esta consulta. #'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret);
		}
	}

	// Caso seja gerente (PERM 17) confere usuários gerenciados
	$gerenciados = array();
	if(!in_array('24', $perms) && !in_array('21', $perms) && in_array('17', $perms)){
		$sql = $mysqli->query("SELECT usuario_id FROM usuarios WHERE usuario_gerente = '$userid'");
		while ($ug = $sql->fetch_assoc()) { array_push($gerenciados, $ug["usuario_id"]); }
	}

	// Pesquisa
	$usuarios[$userid] = utf8_encode($u["usuario_nome"]);
	if($type == 'general'){

		// Caso haja filtro por usuário
		$user_filtro = "cupom_usuario <> '0' AND ";
		if(isset($_GET["user"])){ $user_id_filtro = (int)$_GET["user"]; $user_filtro = "cupom_usuario = '$user_id_filtro' AND "; $user_filtro2 = "lancamento_usuario = '$user_id_filtro' AND "; }

		$sql = $mysqli->query("SELECT cupom_aovivo, cupom_valor, cupom_parcial, cupom_codigo, cupom_data, cupom_cliente, cupom_retorno, cupom_usuario, cupom_comissao, cupom_saidas, cupom_situacao FROM cupons WHERE $user_filtro cupom_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' ORDER BY cupom_data DESC");
		$sql2 = $mysqli->query("SELECT * FROM lancamentos WHERE $user_filtro2 lancamento_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59'");

		// Pesquisa usuários do sistema
		$sql3 = $mysqli->query("SELECT usuario_id, usuario_nome FROM usuarios");
		while ($us = $sql3->fetch_assoc()) { $usuarios[$us["usuario_id"]] = utf8_encode($us["usuario_nome"]); }
	} else {
		$sql = $mysqli->query("SELECT cupom_valor, cupom_parcial, cupom_codigo, cupom_data, cupom_cliente, cupom_retorno, cupom_usuario, cupom_comissao, cupom_saidas, cupom_situacao FROM cupons WHERE cupom_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59' AND cupom_usuario = '$userid' ORDER BY cupom_data DESC");
		$sql2 = $mysqli->query("SELECT * FROM lancamentos WHERE lancamento_usuario = '$userid' AND lancamento_data BETWEEN '$date 00:00:00' AND '$enddate 23:59:59'");
	}

	if(!$sql){ $ret['error'] = 'Erro de consulta: '.$mysqli->error; $ret['status'] = 'error'; $ret['status_code'] = 'dbExecError'; finishJSONRequest($ret); }

	// Inicia variáveis
	$ret['open_entries'] = 0;
	$ret['entries'] = 0;
	$ret['cancelled'] = 0;
	$ret['comissions'] = 0;
	$ret['rewards'] = 0;
	$ret['lanc'] = 0;
	$ret['total'] = 0;
	$ret['today_coupons'] = 0;
	$ret['coupons'] = array();
	$ret['lancs'] = array();

	// Lançamentos
	while ($l = $sql2->fetch_assoc()) {
		if($l["lancamento_tipo"] == 'C'){ $ret['lanc'] += $l["lancamento_valor"]; } else { $ret['lanc'] -= $l["lancamento_valor"]; }

		$auxLanc = count($ret['lancs']);
		$ret['lancs'][$auxLanc]['id'] = $l["lancamento_id"];
		$ret['lancs'][$auxLanc]['trash'] = $l["lancamento_lixeira"];
		$ret['lancs'][$auxLanc]['user'] = $usuarios[$l["lancamento_usuario"]];
		$ret['lancs'][$auxLanc]['user_id'] = $l["lancamento_usuario"];
		$ret['lancs'][$auxLanc]['price'] = formataReal($l["lancamento_valor"]);
		$ret['lancs'][$auxLanc]['description'] = utf8_encode($l["lancamento_descricao"]);
		$ret['lancs'][$auxLanc]['type'] = $l["lancamento_tipo"];
		$ret['lancs'][$auxLanc]['date'] = ($l["lancamento_data"]);
		$ret['lancs'][$auxLanc]['admin'] = $usuarios[$l["lancamento_feito_por"]];
		$ret['lancs'][$auxLanc]['admin_id'] = $l["lancamento_feito_por"];
	}

	while ($c = $sql->fetch_assoc()) {

		// Para gerentes
		if(!in_array('24', $perms) && in_array('17', $perms)){
			if($type == 'general'){
				if(getHierarquia($userid, $c["cupom_usuario"], $_SESSION["users"]) == false){ continue; }
			}
		}

		switch ($c["cupom_situacao"]) {
			case '1':
				$ret['open_entries'] += $c["cupom_valor"];
				// $ret['comissions'] += $c["cupom_comissao"];
				break;

			case '2':
				$ret['entries'] += $c["cupom_valor"];
				$ret['rewards'] += $c["cupom_saidas"];
				$ret['comissions'] += $c["cupom_comissao"];
				break;

			case '3':
				$ret['entries'] += $c["cupom_valor"];
				$ret['comissions'] += $c["cupom_comissao"];
				break;

			case '4':
				$ret['cancelled'] += $c["cupom_valor"];
				break;

			default:
				# code...
				break;
		}

		// Ajusta retorno
		if(($c["cupom_retorno"] / $c["cupom_valor"]) > $multiplicador){
			$c["cupom_retorno"] = $c["cupom_valor"] * $multiplicador;
		}

		$ret['coupons'][$c["cupom_codigo"]]['code'] = ($c["cupom_codigo"]);
		$ret['coupons'][$c["cupom_codigo"]]['date'] = desfazDatetime($c["cupom_data"]);
		$ret['coupons'][$c["cupom_codigo"]]['client'] = utf8_encode($c["cupom_cliente"]);
		$ret['coupons'][$c["cupom_codigo"]]['seller'] = $usuarios[$c["cupom_usuario"]];
		$ret['coupons'][$c["cupom_codigo"]]['price'] = formataReal($c["cupom_valor"]);
		$ret['coupons'][$c["cupom_codigo"]]['return'] = formataReal($c["cupom_retorno"]);
		$ret['coupons'][$c["cupom_codigo"]]['rewards'] = formataReal($c["cupom_saidas"]);
		$ret['coupons'][$c["cupom_codigo"]]['status'] = ($c["cupom_situacao"]);
		if($c["cupom_situacao"] == '1' && $c["cupom_parcial"] == '1'){ $ret['coupons'][$c["cupom_codigo"]]['status'] = '11'; }

		// Soma bilhetes do dia
		if(strtotime($c["cupom_data"]) > strtotime(date('Y-m-d').' 00:00:00')){ $ret["today_coupons"]++; }

		// Melhores vendedores
		if(!isset($melhoresVendedores[$c["cupom_usuario"]])){ $melhoresVendedores[$c["cupom_usuario"]] = $c["cupom_valor"]; }
		else { $melhoresVendedores[$c["cupom_usuario"]] += $c["cupom_valor"]; }

		// Vendas por categoria
		$d_categoria = explode(' ', $c["cupom_data"]);
		$d_categoria = explode('-', $d_categoria[0]);
		$d_categoria = $d_categoria[2].'/'.$d_categoria[1];
		if(!isset($vendasPrejogoAovivo[$d_categoria])){ $vendasPrejogoAovivo[$d_categoria]['live'] = 0; $vendasPrejogoAovivo[$d_categoria]['prematch'] = 0; }
		if($c["cupom_aovivo"] == '1'){ $vendasPrejogoAovivo[$d_categoria]['live']++; } else { $vendasPrejogoAovivo[$d_categoria]['prematch']++; }
	}

	// Ordena de forma decrescente
	arsort($melhoresVendedores);
	ksort($vendasPrejogoAovivo);
	$best_seller = array_keys($melhoresVendedores);
	$best_seller = $best_seller[0];

	if(!isset($_GET["user"]) && $type == 'personal') {
		$ret['total'] = ($ret['entries'] + ($ret['lanc'])) - ($ret['rewards'] + $ret['comissions']);
	} elseif(!isset($_GET["user"])){
		$ret['total'] = ($ret['entries']) - ($ret['rewards'] + $ret['comissions']);
	} else {
		$ret['total'] = ($ret['entries'] + ($ret['lanc'])) - ($ret['rewards'] + $ret['comissions']);
	}

	$ret['open_entries'] = formataReal($ret['open_entries']);
	$ret['entries'] = formataReal($ret['entries']);
	$ret['cancelled'] = formataReal($ret['cancelled']);
	$ret['comissions'] = formataReal($ret['comissions']);
	$ret['lanc'] = formataReal($ret['lanc']);
	$ret['rewards'] = formataReal($ret['rewards']);
	$ret['total'] = formataReal($ret['total']);
	$ret['dates'] = date("d/m/Y", strtotime($date)).' a '.date("d/m/Y", strtotime($enddate));
	$ret['date'] = $date;
	$ret['enddate'] = $enddate;
	$ret['username_balance'] = ((int)$user_id_filtro <> 0) ? $usuarios[$user_id_filtro] : '';
	$ret['best_seller'] = $usuarios[$best_seller];
	$ret['best_seller_balance'] = formataReal($melhoresVendedores[$best_seller]);
	$ret['seller_by_category'] = $vendasPrejogoAovivo;
	echo json_encode($ret);
?>