<?php
	require $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
    require $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';

	// Recebe parâmetros GET
	$datetime = date('Y-m-d H:i:s');
	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;
	$token = $_GET["token"];
	$_SESSION["tipos_usuarios"][0]["plural"] = 'Usuários sem selecionar o tipo dele';

	// Verifica type e permissões
	if(!isset($_GET["token"])){ $ret['error'] = 'Token inexistente ou invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtoken'; finishJSONRequest($ret); }
	if($token == ''){ $ret['error'] = 'Efetue login em sua conta primeiramente.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtoken'; finishJSONRequest($ret); }

	// Pesquisa usuário
	$sql = $mysqli->query("SELECT usuario_id, usuario_permissoes, usuario_nome, usuario_tipo FROM usuarios WHERE usuario_api_token = '$token'");
	if(mysqli_num_rows($sql) == 0 || !isset($_GET["token"]) || $_GET["token"] == ''){ $ret['error'] = 'TOKEN invalido.'; $ret['status'] = 'error'; $ret['status_code'] = 'notfoundtype'; finishJSONRequest($ret); }

	// Pega dados do usuario
	$u = $sql->fetch_assoc();
	$userid = $u["usuario_id"];
	$perms = explode('-', $u["usuario_permissoes"]);

	// Confere se possui permissões
	if(!in_array('1', $perms)){ $ret['error'] = 'Você não possui permissões suficientes para cadastrar.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPerm'; finishJSONRequest($ret); }

	// Pesquisa se há usuário com mesmo nome
	$nome = $mysqli->escape_string(utf8_decode($_GET["name"]));
	$sql = $mysqli->query("SELECT usuario_id FROM usuarios WHERE usuario_nome = '$nome'");
	if(mysqli_num_rows($sql) > 0){ $ret['error'] = 'Já existe um usuário cadastrado com este nome.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidName'; finishJSONRequest($ret); }

	// Verifica se usuário pode cadastrar esse tipo de usuário
	if($_SESSION["tipos_usuarios"][$_GET["user_type"]]["hierarquia"] <= $_SESSION["tipos_usuarios"][$u["usuario_tipo"]]["hierarquia"] && $_SESSION["tipos_usuarios"][$u["usuario_tipo"]]["hierarquia"] <> '1'){ $ret['error'] = 'Você não possui permissões suficientes para cadastrar '.strtolower($_SESSION["tipos_usuarios"][(int)$_GET["user_type"]]["plural"]).'.'; $ret['status'] = 'error'; $ret['status_code'] = 'invalidPermType'; finishJSONRequest($ret); }

	// Recebe variáveis
	$name = $mysqli->escape_string(utf8_decode($_GET["name"]));
	$pass = $mysqli->escape_string(utf8_decode($_GET["pass"]));
	$pass = substr(sha1($pass), 5, -5);
	$manager = $mysqli->escape_string(utf8_decode($_GET["manager"]));
	$phone = $mysqli->escape_string(utf8_decode($_GET["phone"]));
	$user_type = $mysqli->escape_string(utf8_decode($_GET["user_type"]));
	$status = $mysqli->escape_string(utf8_decode($_GET["status"]));
	$diary_limit_1 = realToCents($mysqli->escape_string(utf8_decode($_GET["diary_limit_1"])));
	$diary_limit_2 = realToCents($mysqli->escape_string(utf8_decode($_GET["diary_limit_2"])));
	$diary_limit_general = realToCents($mysqli->escape_string(utf8_decode($_GET["diary_limit_general"])));
	$min_matches = $mysqli->escape_string(utf8_decode($_GET["min_matches"]));
	$min_price = realToCents($mysqli->escape_string(utf8_decode($_GET["min_price"])));
	$max_price = realToCents($mysqli->escape_string(utf8_decode($_GET["max_price"])));
	$credit = realToCents($mysqli->escape_string(utf8_decode($_GET["credit"])));
	$bet_live = $mysqli->escape_string(utf8_decode($_GET["bet_live"]));
	$comission_rate = $mysqli->escape_string(utf8_decode($_GET["comission_rate"]));
	$new_comission_name = $mysqli->escape_string(utf8_decode($_GET["new_comission_name"]));
	$new_comission_rules = $mysqli->escape_string(utf8_decode($_GET["new_comission_rules"]));
	$api_token = substr(sha1(date('YmdHis').rand(1111111, 999999999)), 0, -20);
	$perms = implode('-', $_SESSION["tipos_usuarios"][$user_type]["permissoes"]);
	$manager = ($_SESSION["tipos_usuarios"][$u["usuario_tipo"]]["hierarquia"] == '1') ? $manager : $userid;

	// Campos vazios
	if($name == ''){ $ret['error'] = 'Você precisa informar o NOME.'; $ret['status'] = 'error'; $ret['status_code'] = 'emptyField'; finishJSONRequest($ret); }
	if($pass == ''){ $ret['error'] = 'Você precisa informar a SENHA.'; $ret['status'] = 'error'; $ret['status_code'] = 'emptyField'; finishJSONRequest($ret); }
	if((int)$user_type == ''){ $ret['error'] = 'Você precisa informar o tipo de usuário.'; $ret['status'] = 'error'; $ret['status_code'] = 'emptyField'; finishJSONRequest($ret); }
	if((int)$user_type == ''){ $ret['error'] = 'Você precisa informar o crédito inicial do usuário.'; $ret['status'] = 'error'; $ret['status_code'] = 'emptyField'; finishJSONRequest($ret); }

	// Caso haja cadastro de grade
	if($user_type == '4'){
		$comission_rate = (int)$mysqli->escape_string(utf8_decode($_GET["comission_manager"]));
	} else {
		if($new_comission_rules <> ''){
			$new_comission_rules = explode(PHP_EOL, $_GET["new_comission_rules"]);

			// Cadastra grade
			if($new_comission_name == ''){ $new_comission_name = 'Grade '.rand(99, 9999); }
			$sql = $mysqli->query("INSERT INTO grades SET grade_nome = '$new_comission_name'");
			$comission_rate = $mysqli->insert_id;

			$qtd_rules = count($new_comission_rules);
			$aux = 0;
			$mqueries = '';
			foreach ($new_comission_rules as $rule) {
				$aux++;
				$r = explode(':', $rule);
				$r_min = (int)$r[0];
				$r_max = (int)$r[0];
				$r_comission = (int)$r[1];
				if($aux == $qtd_rules){ $r_max = 100; }
				$mqueries .= "INSERT INTO opcoes_grade SET og_grade = '$comission_rate', og_minimo = '$r_min', og_maximo = '$r_max', og_comissao = '$r_comission'; ";
			}
		}
	}

	// Insere usuário na grade
	$sql = $mysqli->query("INSERT INTO usuarios SET usuario_api_token = '$api_token', usuario_nome = '$name', usuario_gerente = '$manager', usuario_tipo = '$user_type', usuario_limite_simples = '$diary_limit_1', usuario_limite_duplas = '$diary_limit_2', usuario_limite_geral = '$diary_limit_general', usuario_min_jogos = '$min_matches', usuario_grade = '$comission_rate', usuario_status = '$status', usuario_senha = '$pass', usuario_data_cadastro = '$datetime', usuario_telefone = '$phone', usuario_aposta_minima = '$min_price', usuario_aposta_maxima = '$max_price', usuario_aovivo = '$bet_live', usuario_credito = '$credit', usuario_permissoes = '$perms'");

	if($sql){


		if($new_comission_rules <> ''){
			// Cadastra regras no banco de dados
			$sqlmulti = mysqli_multi_query($mysqli, $mqueries);
			if(!$sqlmulti){ $ret['error'] = 'O usuário foi cadastrado, mas houve uma falha ao tentar cadastrar a grade de comissões especificada. Por favor, entre em contato com o atendimento.'; $ret['status'] = 'error'; $ret['status_code'] = 'errOnSendRate'; finishJSONRequest($ret); }
		}

		$ret['success'] = 'Pronto! O usuário foi cadastrado.';
		$ret['status'] = 'success';
		$ret['slug'] = $_SESSION["tipos_usuarios"][$_GET["user_type"]]["slug"];
		finishJSONRequest($ret);
	} else {
		$ret['error'] = 'Houve um erro ao cadastrar o usuário. O sistema retornou: '.$mysqli->error.'.'; $ret['status'] = 'error'; $ret['status_code'] = 'databaseError'; finishJSONRequest($ret);
	}
?>