<?php
	require $_SERVER["DOCUMENT_ROOT"].'/inc/conexao.php';
    require $_SERVER["DOCUMENT_ROOT"].'/inc/functions.php';

    // Inicia sessão
    if(!isset($_SESSION)){ session_start(); }

    // Seta esporte padrão, caso não haja
    if(!isset($_SESSION["esporte_slug"]) || $_SESSION["esporte_slug"] == ''){ $_SESSION["esporte_slug"] = 'futebol'; }
    $codigo_aposta = $_SESSION["esporte_slug"];

	// Recebe parâmetros GET
	$urlbase = $_SERVER['SERVER_NAME'].$_SERVER ['REQUEST_URI'];
	$parts = parse_url($urlbase);
	parse_str($parts['query'], $query);
	$_GET = $query;

	// Caso seja para limpar cupom
	if(isset($_GET["clear"]) && $_GET["clear"] == 'all'){ $_SESSION["apostas"] = array(); echo '1'; exit; }
	elseif(isset($_GET["clear"])){ unset($_SESSION["apostas"][$_GET["clear"]]); echo '1'; exit; }

	// Inicializa sessão que salva apostas
	if(!isset($_SESSION["apostas"])){ $_SESSION["apostas"] = array(); }

	// Parâmetros
	$match_id = $mysqli->escape_string($_GET["match"]);
	$choice_id = $mysqli->escape_string($_GET["choice"]);

	// Se opção já existe, remove
	if(isset($_SESSION["apostas"][$match_id]) && $_SESSION["apostas"][$match_id]["aposta_token"] == $choice_id){
		unset($_SESSION["apostas"][$match_id]); echo '1'; exit;
	}

	// Aciona erros de campos vazios
	if($match_id == ''){ echo 'Erro! A partida especificada não é válida.'; exit; }
	if($choice_id == ''){ echo 'Erro! A opção especificada não é válida.'; exit; }

	$xml = simplexml_load_file(APIPATH.'/apostas_b365.php?id_partida='.$match_id);
	if(!$xml){ echo 'Erro! A partida solicitada não está disponível.'; exit; }

	$_SESSION["apostas"][$match_id]["aposta_esporte"] = $_SESSION["esporte"];
	$_SESSION["apostas"][$match_id]["aposta_campeonato"] = (string)$xml->attributes()->name_campeonato;
	$_SESSION["apostas"][$match_id]["aposta_match_id"] = $match_id;
	$_SESSION["apostas"][$match_id]["aposta_jogo_nome"] = (string)$xml->attributes()->partida;
	$_SESSION["apostas"][$match_id]["aposta_data_jogo"] = FBETDateToDatetime((string)$xml->attributes()->start_date);
	$_SESSION["apostas"][$match_id]["codigo_aposta"] = $codigo_aposta;
	$_SESSION["apostas"][$match_id]["aposta_token"] = $choice_id;

	$mudancaOdds = array();
	foreach ($xml as $k => $bet) {
		foreach ($bet as $k2 => $choice) {
			if((string)$choice->attributes()->id <> $choice_id){ continue; }

			$_SESSION["apostas"][$match_id]["aposta_nome_aposta"] = (string)$bet->attributes()->name;
			$_SESSION["apostas"][$match_id]["aposta_opcao"] = (string)$choice->attributes()->name;
			$mudancaOdds[0] = (string)$bet->attributes()->name.':'.(string)$choice->attributes()->name.':'.(string)$choice->attributes()->odd;
		}
	}
	// Caso não encontre opção
	if(!isset($mudancaOdds[0])){ echo 'Esta opção não está mais disponível para apostas ou não foi encontrada.'; exit; }
	$mudancaOdds = modificaOdds($mudancaOdds);
	if($mudancaOdds[0] <= 1){ echo 'Cotação inválida!'; exit; }
	$_SESSION["apostas"][$match_id]["aposta_cotacao"] = $mudancaOdds[0];

	echo '1';
?>